/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.DownloadProtocol;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.ResourceType;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.util.URLUtil;
import com.sun.javaws.util.VersionString;
import com.sun.javaws.xml.XMLNode;
import com.sun.javaws.xml.XMLNodeBuilder;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;

public class ResourcesDesc
implements ResourceType {
    private ArrayList _list = new ArrayList();
    private LaunchDesc _parent = null;

    boolean isEmpty() {
        return this._list.isEmpty();
    }

    public ExtensionDesc[] getExtensionDescs() {
        ArrayList arrayList = new ArrayList();
        ExtensionDesc[] extensionDescArray = new ExtensionDesc[]{};
        this.visit(new ResourceVisitor(this, arrayList){
            private final ArrayList val$l;
            private final ResourcesDesc this$0;

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                this.val$l.add(extensionDesc);
            }

            public void visitJARDesc(JARDesc jARDesc) {
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }
            {
                this.this$0 = resourcesDesc;
                this.val$l = arrayList;
            }
        });
        return arrayList.toArray(extensionDescArray);
    }

    public JARDesc[] getLocalJarDescs() {
        ArrayList arrayList = new ArrayList(this._list.size());
        for (int i = 0; i < this._list.size(); ++i) {
            Object e = this._list.get(i);
            if (!(e instanceof JARDesc)) continue;
            arrayList.add(e);
        }
        return this.toJARDescArray(arrayList);
    }

    public JARDesc getMainJar(boolean bl) {
        JARDesc[] jARDescArray = new JARDesc[2];
        this.visit(new ResourceVisitor(this, jARDescArray){
            private final JARDesc[] val$results;
            private final ResourcesDesc this$0;

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
            }

            public void visitJARDesc(JARDesc jARDesc) {
                if (jARDesc.isJavaFile()) {
                    if (this.val$results[0] == null) {
                        this.val$results[0] = jARDesc;
                    }
                    if (jARDesc.isMainJarFile()) {
                        this.val$results[1] = jARDesc;
                    }
                }
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }
            {
                this.this$0 = resourcesDesc;
                this.val$results = jARDescArray;
            }
        });
        JARDesc jARDesc = jARDescArray[0];
        JARDesc jARDesc2 = jARDescArray[1];
        return jARDesc2 != null && bl ? jARDesc2 : jARDesc;
    }

    public JARDesc[] getEagerOrAllJarDescs(boolean bl) {
        HashSet hashSet = new HashSet();
        if (!bl) {
            this.visit(new ResourceVisitor(this, hashSet){
                private final HashSet val$eagerParts;
                private final ResourcesDesc this$0;

                public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                }

                public void visitJARDesc(JARDesc jARDesc) {
                    if (!jARDesc.isLazyDownload() && jARDesc.getPartName() != null) {
                        this.val$eagerParts.add(jARDesc.getPartName());
                    }
                }

                public void visitJREDesc(JREDesc jREDesc) {
                }

                public void visitPackageDesc(PackageDesc packageDesc) {
                }

                public void visitPropertyDesc(PropertyDesc propertyDesc) {
                }
                {
                    this.this$0 = resourcesDesc;
                    this.val$eagerParts = hashSet;
                }
            });
        }
        ArrayList arrayList = new ArrayList();
        this.addJarsToList(arrayList, hashSet, bl, true);
        return this.toJARDescArray(arrayList);
    }

    public JREDesc getSelectedJRE() {
        for (int i = 0; i < this._list.size(); ++i) {
            Object e = this._list.get(i);
            if (!(e instanceof JREDesc) || !((JREDesc)e).isSelected()) continue;
            return (JREDesc)e;
        }
        return null;
    }

    public LaunchDesc getParent() {
        return this._parent;
    }

    void setParent(LaunchDesc launchDesc) {
        this._parent = launchDesc;
        for (int i = 0; i < this._list.size(); ++i) {
            JREDesc jREDesc;
            Object e = this._list.get(i);
            if (!(e instanceof JREDesc) || (jREDesc = (JREDesc)e).getNestedResources() == null) continue;
            jREDesc.getNestedResources().setParent(launchDesc);
        }
    }

    void addResource(ResourceType resourceType) {
        if (resourceType != null) {
            this._list.add(resourceType);
        }
    }

    public void visit(ResourceVisitor resourceVisitor) {
        for (int i = 0; i < this._list.size(); ++i) {
            ResourceType resourceType = (ResourceType)this._list.get(i);
            resourceType.visit(resourceVisitor);
        }
    }

    public XMLNode asXML() {
        XMLNodeBuilder xMLNodeBuilder = new XMLNodeBuilder("resources", null);
        for (int i = 0; i < this._list.size(); ++i) {
            ResourceType resourceType = (ResourceType)this._list.get(i);
            xMLNodeBuilder.add(resourceType);
        }
        return xMLNodeBuilder.getNode();
    }

    public Properties getResourceProperties() {
        Properties properties = new Properties();
        this.visit(new ResourceVisitor(this, properties){
            private final Properties val$props;
            private final ResourcesDesc this$0;

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
            }

            public void visitJARDesc(JARDesc jARDesc) {
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
                this.val$props.setProperty(propertyDesc.getKey(), propertyDesc.getValue());
            }
            {
                this.this$0 = resourcesDesc;
                this.val$props = properties;
            }
        });
        return properties;
    }

    public JARDesc[] getPart(String string) {
        ArrayList arrayList = new ArrayList();
        this.visit(new ResourceVisitor(this, string, arrayList){
            private final String val$name;
            private final ArrayList val$l;
            private final ResourcesDesc this$0;

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
            }

            public void visitJARDesc(JARDesc jARDesc) {
                if (this.val$name.equals(jARDesc.getPartName())) {
                    this.val$l.add(jARDesc);
                }
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }
            {
                this.this$0 = resourcesDesc;
                this.val$name = string;
                this.val$l = arrayList;
            }
        });
        return this.toJARDescArray(arrayList);
    }

    public JARDesc[] getPartJars(String string) {
        return this.getPartJars(new String[]{string});
    }

    public JARDesc[] getPartJars(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        ArrayList arrayList = new ArrayList();
        this.addJarsToList(arrayList, hashSet, false, false);
        return this.toJARDescArray(arrayList);
    }

    private JARDesc[] toJARDescArray(ArrayList arrayList) {
        JARDesc[] jARDescArray = new JARDesc[arrayList.size()];
        return arrayList.toArray(jARDescArray);
    }

    public PackageInformation getPackageInformation(String string) {
        if ((string = string.replace('/', '.')).endsWith(".class")) {
            string = string.substring(0, string.length() - 6);
        }
        return ResourcesDesc.visitPackageElements(this.getParent(), string);
    }

    private void addJarsToList(ArrayList arrayList, HashSet hashSet, boolean bl, boolean bl2) {
        this.visit(new ResourceVisitor(this, bl, bl2, hashSet, arrayList){
            private final boolean val$includeAll;
            private final boolean val$includeEager;
            private final HashSet val$includeParts;
            private final ArrayList val$list;
            private final ResourcesDesc this$0;

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                Object object;
                HashSet hashSet = extensionDesc.getExtensionPackages(this.val$includeParts, this.val$includeEager);
                if (extensionDesc.getExtensionDesc() == null) {
                    object = ConfigProperties.getInstance().getKnownPlatforms();
                    DiskCacheEntry diskCacheEntry = null;
                    try {
                        diskCacheEntry = DownloadProtocol.getCachedExtension(extensionDesc.getLocation(), extensionDesc.getVersion(), (String)object);
                        if (diskCacheEntry != null && diskCacheEntry.getFile() != null) {
                            LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(diskCacheEntry.getFile());
                            extensionDesc.setExtensionDesc(launchDesc);
                        }
                    }
                    catch (Exception exception) {
                        Debug.ignoredException(exception);
                    }
                }
                if (extensionDesc.getExtensionDesc() != null && (object = extensionDesc.getExtensionDesc().getResources()) != null) {
                    ResourcesDesc.access$000((ResourcesDesc)object, this.val$list, hashSet, this.val$includeAll, this.val$includeEager);
                }
            }

            public void visitJARDesc(JARDesc jARDesc) {
                if (this.val$includeAll || this.val$includeEager && !jARDesc.isLazyDownload() || this.val$includeParts.contains(jARDesc.getPartName())) {
                    this.val$list.add(jARDesc);
                }
            }

            public void visitJREDesc(JREDesc jREDesc) {
                if (jREDesc.isSelected()) {
                    ResourcesDesc resourcesDesc;
                    ResourcesDesc resourcesDesc2 = jREDesc.getNestedResources();
                    if (resourcesDesc2 != null) {
                        ResourcesDesc.access$000(resourcesDesc2, this.val$list, this.val$includeParts, this.val$includeAll, this.val$includeEager);
                    }
                    if (jREDesc.getExtensionDesc() != null && (resourcesDesc = jREDesc.getExtensionDesc().getResources()) != null) {
                        ResourcesDesc.access$000(resourcesDesc, this.val$list, new HashSet(), this.val$includeAll, this.val$includeEager);
                    }
                }
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }
            {
                this.this$0 = resourcesDesc;
                this.val$includeAll = bl;
                this.val$includeEager = bl2;
                this.val$includeParts = hashSet;
                this.val$list = arrayList;
            }
        });
    }

    private ExtensionDesc findExtension(URL uRL, String string) {
        ExtensionDesc[] extensionDescArray = new ExtensionDesc[1];
        this.visit(new ResourceVisitor(this, extensionDescArray, uRL, string){
            private final ExtensionDesc[] val$ea;
            private final URL val$location;
            private final String val$version;
            private final ResourcesDesc this$0;

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                if (this.val$ea[0] == null) {
                    if (URLUtil.equals(extensionDesc.getLocation(), this.val$location) && (this.val$version == null || new VersionString(this.val$version).contains(extensionDesc.getVersion()))) {
                        this.val$ea[0] = extensionDesc;
                    } else {
                        LaunchDesc launchDesc = extensionDesc.getExtensionDesc();
                        if (launchDesc != null && launchDesc.getResources() != null) {
                            this.val$ea[0] = ResourcesDesc.access$100(launchDesc.getResources(), this.val$location, this.val$version);
                        }
                    }
                }
            }

            public void visitJARDesc(JARDesc jARDesc) {
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }
            {
                this.this$0 = resourcesDesc;
                this.val$ea = extensionDescArray;
                this.val$location = uRL;
                this.val$version = string;
            }
        });
        return extensionDescArray[0];
    }

    public JARDesc[] getResource(URL uRL, String string) {
        VersionString versionString = string != null ? new VersionString(string) : null;
        JARDesc[] jARDescArray = new JARDesc[1];
        this.visit(new ResourceVisitor(this, uRL, versionString, jARDescArray){
            private final URL val$location;
            private final VersionString val$vs;
            private final JARDesc[] val$resources;
            private final ResourcesDesc this$0;

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
            }

            public void visitJARDesc(JARDesc jARDesc) {
                if (URLUtil.equals(jARDesc.getLocation(), this.val$location)) {
                    if (this.val$vs == null) {
                        this.val$resources[0] = jARDesc;
                    } else if (this.val$vs.contains(jARDesc.getVersion())) {
                        this.val$resources[0] = jARDesc;
                    }
                }
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }
            {
                this.this$0 = resourcesDesc;
                this.val$location = uRL;
                this.val$vs = versionString;
                this.val$resources = jARDescArray;
            }
        });
        if (jARDescArray[0] == null) {
            return null;
        }
        if (jARDescArray[0].getPartName() != null) {
            return this.getPartJars(jARDescArray[0].getPartName());
        }
        return jARDescArray;
    }

    static PackageInformation access$200(LaunchDesc launchDesc, String string) {
        return ResourcesDesc.visitPackageElements(launchDesc, string);
    }

    private static PackageInformation visitPackageElements(LaunchDesc launchDesc, String string) {
        PackageInformation[] packageInformationArray = new PackageInformation[1];
        launchDesc.getResources().visit(new ResourceVisitor(packageInformationArray, string, launchDesc){
            private final PackageInformation[] val$result;
            private final String val$name;
            private final LaunchDesc val$ld;

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                if (!extensionDesc.isInstaller()) {
                    LaunchDesc launchDesc = extensionDesc.getExtensionDesc();
                    if (this.val$result[0] == null && launchDesc.isLibrary() && launchDesc.getResources() != null) {
                        this.val$result[0] = ResourcesDesc.access$200(launchDesc, this.val$name);
                    }
                }
            }

            public void visitJARDesc(JARDesc jARDesc) {
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
                if (this.val$result[0] == null && packageDesc.match(this.val$name)) {
                    this.val$result[0] = new PackageInformation(this.val$ld, packageDesc.getPart());
                }
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }
            {
                this.val$result = packageInformationArray;
                this.val$name = string;
                this.val$ld = launchDesc;
            }
        });
        return packageInformationArray[0];
    }

    static void access$000(ResourcesDesc resourcesDesc, ArrayList arrayList, HashSet hashSet, boolean bl, boolean bl2) {
        resourcesDesc.addJarsToList(arrayList, hashSet, bl, bl2);
    }

    static ExtensionDesc access$100(ResourcesDesc resourcesDesc, URL uRL, String string) {
        return resourcesDesc.findExtension(uRL, string);
    }

    public JARDesc[] getExtensionPart(URL uRL, String string, String string2) {
        JARDesc[][] jARDescArray = new JARDesc[1][];
        this.visit(new ResourceVisitor(this, uRL, string, jARDescArray, string2){
            private final URL val$url;
            private final String val$version;
            private final JARDesc[][] val$jdss;
            private final String val$part;
            private final ResourcesDesc this$0;

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                if (URLUtil.equals(extensionDesc.getLocation(), this.val$url)) {
                    if (this.val$version == null) {
                        if (extensionDesc.getVersion() == null && extensionDesc.getExtensionResources() != null) {
                            this.val$jdss[0] = extensionDesc.getExtensionResources().getPart(this.val$part);
                        }
                    } else if (this.val$version.equals(extensionDesc.getVersion()) && extensionDesc.getExtensionResources() != null) {
                        this.val$jdss[0] = extensionDesc.getExtensionResources().getPart(this.val$part);
                    }
                }
            }

            public void visitJARDesc(JARDesc jARDesc) {
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }
            {
                this.this$0 = resourcesDesc;
                this.val$url = uRL;
                this.val$version = string;
                this.val$jdss = jARDescArray;
                this.val$part = string2;
            }
        });
        return jARDescArray[0];
    }

    public JARDesc[] getExtensionPart(URL uRL, String string, String[] stringArray) {
        ExtensionDesc extensionDesc = this.findExtension(uRL, string);
        if (extensionDesc == null) {
            return null;
        }
        ResourcesDesc resourcesDesc = extensionDesc.getExtensionResources();
        if (resourcesDesc == null) {
            return null;
        }
        return resourcesDesc.getPartJars(stringArray);
    }

    public static class PackageInformation {
        private LaunchDesc _launchDesc;
        private String _part;

        public LaunchDesc getLaunchDesc() {
            return this._launchDesc;
        }

        public String getPart() {
            return this._part;
        }

        PackageInformation(LaunchDesc launchDesc, String string) {
            this._launchDesc = launchDesc;
            this._part = string;
        }
    }
}

