/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.javaws.Resources;
import com.sun.jnlp.CheckServicePermission;
import com.sun.jnlp.FileContentsImpl;
import com.sun.jnlp.FileOpenServiceImpl;
import com.sun.jnlp.SmartSecurityDialog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jnlp.FileContents;
import javax.jnlp.FileSaveService;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;

public final class FileSaveServiceImpl
implements FileSaveService {
    static FileSaveServiceImpl _sharedInstance = null;
    private SmartSecurityDialog _securityDialog = new SmartSecurityDialog(Resources.getString("APIImpl.file.save.message"));
    private String _lastPath;

    private FileSaveServiceImpl() {
    }

    synchronized boolean askUser() {
        if (CheckServicePermission.hasFileAccessPermissions()) {
            return true;
        }
        return this._securityDialog.showDialog();
    }

    static long computeMaxLength(long l) {
        return l * 3L;
    }

    String getLastPath() {
        return this._lastPath;
    }

    void setLastPath(String string) {
        this._lastPath = string;
    }

    public static synchronized FileSaveService getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new FileSaveServiceImpl();
        }
        return _sharedInstance;
    }

    public FileContents saveAsFileDialog(String string, String[] stringArray, FileContents fileContents) throws IOException {
        return this.saveFileDialog(string, stringArray, fileContents.getInputStream(), fileContents.getName());
    }

    public FileContents saveFileDialog(String string, String[] stringArray, InputStream inputStream, String string2) throws IOException {
        if (!this.askUser()) {
            return null;
        }
        Object t = AccessController.doPrivileged(new PrivilegedAction(this, string, inputStream){
            private final String val$pathHint;
            private final InputStream val$stream;
            private final FileSaveServiceImpl this$0;

            public Object run() {
                JFileChooser jFileChooser = null;
                FileSystemView fileSystemView = FileOpenServiceImpl.getFileSystemView();
                jFileChooser = this.val$pathHint != null ? new JFileChooser(this.val$pathHint, fileSystemView) : new JFileChooser(this.this$0.getLastPath(), fileSystemView);
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setDialogType(1);
                jFileChooser.setMultiSelectionEnabled(false);
                int n = jFileChooser.showSaveDialog(null);
                if (n == 1) {
                    return null;
                }
                File file = jFileChooser.getSelectedFile();
                if (file != null) {
                    try {
                        byte[] byArray = new byte[8192];
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.val$stream);
                        int n2 = bufferedInputStream.read(byArray);
                        while (n2 != -1) {
                            bufferedOutputStream.write(byArray, 0, n2);
                            n2 = bufferedInputStream.read(byArray);
                        }
                        bufferedOutputStream.close();
                        this.this$0.setLastPath(file.getPath());
                        return new FileContentsImpl(file, FileSaveServiceImpl.computeMaxLength(file.length()));
                    }
                    catch (IOException iOException) {
                        return iOException;
                    }
                }
                return null;
            }
            {
                this.this$0 = fileSaveServiceImpl;
                this.val$pathHint = string;
                this.val$stream = inputStream;
            }
        });
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        return (FileContents)t;
    }
}

