/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.javaws.LaunchDownload;
import com.sun.javaws.Main;
import com.sun.javaws.cache.InstallCache;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.security.JNLPClassPath;
import com.sun.javaws.security.Resource;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class JNLPClassLoader
extends SecureClassLoader {
    private static JNLPClassLoader _instance = null;
    private LaunchDesc _launchDesc = null;
    private JNLPClassPath _jcp = null;
    private AppPolicy _appPolicy;
    private AccessControlContext _acc = null;
    private boolean _initialized = false;

    public int getDefaultSecurityModel() {
        return this._launchDesc.getSecurityModel();
    }

    public void downloadEager(LaunchDownload.DownloadProgress downloadProgress, boolean bl) throws JNLPException, IOException {
        LaunchDownload.downloadEagerorAll(this._launchDesc, false, downloadProgress, bl);
    }

    public LaunchDesc getLaunchDesc() {
        return this._launchDesc;
    }

    public static synchronized JNLPClassLoader createClassLoader() {
        if (_instance == null) {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            _instance = classLoader instanceof JNLPClassLoader ? (JNLPClassLoader)classLoader : new JNLPClassLoader(classLoader);
        }
        return _instance;
    }

    public static synchronized JNLPClassLoader getInstance() {
        return _instance;
    }

    public JNLPClassLoader(ClassLoader classLoader) {
        super(classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
    }

    public void downloadParts(String[] stringArray, LaunchDownload.DownloadProgress downloadProgress, boolean bl) throws JNLPException, IOException {
        LaunchDownload.downloadParts(this._launchDesc, stringArray, downloadProgress, bl);
    }

    public JARDesc getJarDescFromFileURL(URL uRL) {
        return this._jcp.getJarDescFromFileURL(uRL);
    }

    private void initialize(LaunchDesc launchDesc, boolean bl, AppPolicy appPolicy) {
        this._launchDesc = launchDesc;
        this._jcp = new JNLPClassPath(launchDesc, bl);
        this._acc = AccessController.getContext();
        this._appPolicy = appPolicy;
        this._initialized = true;
    }

    static JNLPClassPath access$000(JNLPClassLoader jNLPClassLoader) {
        return jNLPClassLoader._jcp;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        if (!this._initialized) {
            return super.findClass(string);
        }
        if (Globals.TraceClassLoading) {
            Debug.println("Loading class " + string);
        }
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(this, string){
                private final String val$name;
                private final JNLPClassLoader this$0;

                public Object run() throws ClassNotFoundException {
                    String string = this.val$name.replace('.', '/').concat(".class");
                    Resource resource = JNLPClassLoader.access$000(this.this$0).getResource(string, false);
                    if (resource != null) {
                        try {
                            return JNLPClassLoader.access$100(this.this$0, this.val$name, resource);
                        }
                        catch (IOException iOException) {
                            throw new ClassNotFoundException(this.val$name, iOException);
                        }
                    }
                    throw new ClassNotFoundException(this.val$name);
                }
                {
                    this.this$0 = jNLPClassLoader;
                    this.val$name = string;
                }
            }, this._acc);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ClassNotFoundException)privilegedActionException.getException();
        }
    }

    public String findLibrary(String string) {
        if (!this._initialized) {
            return super.findLibrary(string);
        }
        string = Globals.isWindowsPlatform() ? string + ".dll" : "lib" + string + ".so";
        if (Globals.TraceClassLoading) {
            Debug.println("Looking up native library: " + string);
        }
        File[] fileArray = LaunchDownload.getNativeDirectories(this._launchDesc);
        for (int i = 0; i < fileArray.length; ++i) {
            File file = new File(fileArray[i], string);
            if (!file.exists()) continue;
            if (Globals.TraceClassLoading) {
                Debug.println("Native library found: " + file.getAbsolutePath());
            }
            return file.getAbsolutePath();
        }
        if (Globals.TraceClassLoading) {
            Debug.println("Native library not found");
        }
        return super.findLibrary(string);
    }

    public URL findResource(String string) {
        if (!this._initialized) {
            return super.findResource(string);
        }
        Resource resource = (Resource)AccessController.doPrivileged(new PrivilegedAction(this, string){
            private final String val$name;
            private final JNLPClassLoader this$0;

            public Object run() {
                return JNLPClassLoader.access$000(this.this$0).getResource(this.val$name, true);
            }
            {
                this.this$0 = jNLPClassLoader;
                this.val$name = string;
            }
        }, this._acc);
        return resource != null ? this._jcp.checkURL(resource.getURL()) : null;
    }

    public URL getResource(String string) {
        URL uRL = null;
        for (int i = 0; uRL == null && i < 3; ++i) {
            if (Globals.TraceClassLoading) {
                Debug.println("Looking up resource: " + string + " (attempt: " + i + ")");
            }
            uRL = super.getResource(string);
        }
        return uRL;
    }

    static AccessControlContext access$300(JNLPClassLoader jNLPClassLoader) {
        return jNLPClassLoader._acc;
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Object object;
        Permission permission;
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        this._appPolicy.addPermissions(permissionCollection, codeSource);
        URL uRL = codeSource.getLocation();
        try {
            permission = uRL.openConnection().getPermission();
        }
        catch (IOException iOException) {
            permission = null;
        }
        JARDesc jARDesc = this._jcp.getJarDescFromFileURL(uRL);
        if (jARDesc != null) {
            object = InstallCache.getDiskCache().getBaseDirForHost(jARDesc.getLocation());
            object = ((String)object).endsWith(File.separator) ? (String)object + '-' : (String)object + File.separator + '-';
            permissionCollection.add(new FilePermission((String)object, "read"));
        }
        if (permission instanceof FilePermission) {
            object = permission.getName();
            if (((String)object).endsWith(File.separator)) {
                object = (String)object + "-";
                permission = new FilePermission((String)object, "read");
            }
        } else if (permission == null && uRL.getProtocol().equals("file")) {
            object = uRL.getFile().replace('/', File.separatorChar);
            if (((String)object).endsWith(File.separator)) {
                object = (String)object + "-";
            }
            permission = new FilePermission((String)object, "read");
        } else {
            object = uRL.getHost();
            if (object == null) {
                object = "localhost";
            }
            permission = new SocketPermission((String)object, "connect, accept");
        }
        if (permission != null) {
            object = System.getSecurityManager();
            if (object != null) {
                Permission permission2 = permission;
                AccessController.doPrivileged(new PrivilegedAction(this, (SecurityManager)object, permission2){
                    private final SecurityManager val$sm;
                    private final Permission val$fp;
                    private final JNLPClassLoader this$0;

                    public Object run() throws SecurityException {
                        this.val$sm.checkPermission(this.val$fp);
                        return null;
                    }
                    {
                        this.this$0 = jNLPClassLoader;
                        this.val$sm = securityManager;
                        this.val$fp = permission;
                    }
                }, this._acc);
            }
            permissionCollection.add(permission);
        }
        return permissionCollection;
    }

    public Enumeration findResources(String string) throws IOException {
        if (!this._initialized) {
            return super.findResources(string);
        }
        Enumeration enumeration = (Enumeration)AccessController.doPrivileged(new PrivilegedAction(this, string){
            private final String val$name;
            private final JNLPClassLoader this$0;

            public Object run() {
                return JNLPClassLoader.access$000(this.this$0).getResources(this.val$name, true);
            }
            {
                this.this$0 = jNLPClassLoader;
                this.val$name = string;
            }
        }, this._acc);
        return new Enumeration(this, enumeration){
            private URL res;
            private final Enumeration val$e;
            private final JNLPClassLoader this$0;

            public boolean hasMoreElements() {
                Resource resource;
                if (Thread.currentThread().getThreadGroup() == Main.getSecurityThreadGroup()) {
                    return false;
                }
                if (this.res != null) {
                    return true;
                }
                while ((resource = (Resource)AccessController.doPrivileged(new PrivilegedAction(this){
                    private final 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Object run() {
                        if (!4.access$200(this.this$1).hasMoreElements()) {
                            return null;
                        }
                        return 4.access$200(this.this$1).nextElement();
                    }
                }, JNLPClassLoader.access$300(this.this$0))) != null) {
                    this.res = JNLPClassLoader.access$000(this.this$0).checkURL(resource.getURL());
                    if (this.res == null) continue;
                }
                return this.res != null;
            }

            public Object nextElement() {
                if (this.res == null) {
                    throw new NoSuchElementException();
                }
                URL uRL = this.res;
                this.res = null;
                return uRL;
            }
            {
                this.this$0 = jNLPClassLoader;
                this.val$e = enumeration;
            }

            static Enumeration access$200(4 var0) {
                return var0.val$e;
            }
        };
    }

    private boolean isSealed(String string, Manifest manifest) {
        String string2 = string.replace('.', '/').concat("/");
        Attributes attributes = manifest.getAttributes(string2);
        String string3 = null;
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string3);
    }

    public void downloadResource(URL uRL, String string, LaunchDownload.DownloadProgress downloadProgress, boolean bl) throws JNLPException, IOException {
        LaunchDownload.downloadResource(this._launchDesc, uRL, string, downloadProgress, bl);
    }

    public static synchronized JNLPClassLoader createClassLoader(LaunchDesc launchDesc, AppPolicy appPolicy) {
        JNLPClassLoader jNLPClassLoader = JNLPClassLoader.createClassLoader();
        if (!jNLPClassLoader._initialized) {
            jNLPClassLoader.initialize(launchDesc, launchDesc.isApplet(), appPolicy);
        }
        return jNLPClassLoader;
    }

    private Class defineClass(String string, Resource resource) throws IOException {
        Object object;
        Certificate[] certificateArray;
        Object object2;
        int n = string.lastIndexOf(46);
        URL uRL = resource.getCodeSourceURL();
        if (n != -1) {
            object2 = string.substring(0, n);
            certificateArray = this.getPackage((String)object2);
            object = resource.getManifest();
            if (certificateArray != null) {
                boolean bl;
                if (certificateArray.isSealed()) {
                    bl = certificateArray.isSealed(uRL);
                } else {
                    boolean bl2 = bl = object == null || !this.isSealed((String)object2, (Manifest)object);
                }
                if (!bl) {
                    throw new SecurityException("sealing violation");
                }
            } else if (object != null) {
                this.definePackage((String)object2, (Manifest)object, uRL);
            } else {
                this.definePackage((String)object2, null, null, null, null, null, null, null);
            }
        }
        object2 = resource.getBytes();
        certificateArray = resource.getCertificates();
        object = new CodeSource(uRL, certificateArray);
        return this.defineClass(string, (byte[])object2, 0, ((byte[])object2).length, (CodeSource)object);
    }

    public void downloadExtensionParts(URL uRL, String string, String[] stringArray, LaunchDownload.DownloadProgress downloadProgress, boolean bl) throws JNLPException, IOException {
        LaunchDownload.downloadExtensionPart(this._launchDesc, uRL, string, stringArray, downloadProgress, bl);
    }

    static Class access$100(JNLPClassLoader jNLPClassLoader, String string, Resource resource) throws IOException {
        return jNLPClassLoader.defineClass(string, resource);
    }

    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        String string2 = string.replace('.', '/').concat("/");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        URL uRL2 = null;
        Attributes attributes = manifest.getAttributes(string2);
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            string9 = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (string3 == null) {
                string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (string4 == null) {
                string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (string5 == null) {
                string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (string6 == null) {
                string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (string7 == null) {
                string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (string8 == null) {
                string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (string9 == null) {
                string9 = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(string9)) {
            uRL2 = uRL;
        }
        return this.definePackage(string, string3, string4, string5, string6, string7, string8, uRL2);
    }
}

