/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.Resources;
import com.sun.javaws.cache.DiskCache;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.InstallCache;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.util.URLUtil;
import com.sun.jnlp.CheckServicePermission;
import com.sun.jnlp.FileContentsImpl;
import com.sun.jnlp.JNLPClassLoader;
import com.sun.jnlp.SmartSecurityDialog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;

public final class PersistenceServiceImpl
implements PersistenceService {
    private long _globalLimit = -1L;
    private long _appLimit = -1L;
    private long _size = -1L;
    private static PersistenceServiceImpl _sharedInstance = null;
    private final SmartSecurityDialog _securityDialog = new SmartSecurityDialog();
    private DiskCache _muffincache = null;

    private PersistenceServiceImpl() {
    }

    public static synchronized void initialize() {
        if (_sharedInstance == null) {
            _sharedInstance = new PersistenceServiceImpl();
        }
        if (_sharedInstance != null) {
            if (PersistenceServiceImpl._sharedInstance._muffincache == null) {
                PersistenceServiceImpl._sharedInstance._muffincache = InstallCache.getMuffinCache();
            }
            PersistenceServiceImpl._sharedInstance._appLimit = ConfigProperties.getInstance().getMuffinSizeLimit();
        }
    }

    private boolean askUser(long l, long l2) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(this, l, l2){
            private final long val$requested;
            private final long val$currentLimit;
            private final PersistenceServiceImpl this$0;
            {
                this.this$0 = persistenceServiceImpl;
                this.val$requested = l;
                this.val$currentLimit = l2;
            }

            public Object run() {
                String string = Resources.getString("APIImpl.persistence.message", new Long(this.val$requested), new Long(this.val$currentLimit));
                return new Boolean(PersistenceServiceImpl.access$100(this.this$0).showDialog(string));
            }
        });
        return bl;
    }

    private long reconcileMaxSize(long l, long l2, long l3) {
        long l4 = l + l2;
        boolean bl = CheckServicePermission.hasFileAccessPermissions();
        if (bl || this.askUser(l4, l3)) {
            this._appLimit = l4;
            return l;
        }
        return l3 - l2;
    }

    public static synchronized PersistenceServiceImpl getInstance() {
        PersistenceServiceImpl.initialize();
        return _sharedInstance;
    }

    public int getTag(URL uRL) throws MalformedURLException, IOException {
        Integer n;
        block4: {
            n = null;
            if (this._muffincache == null) {
                return -1;
            }
            this.checkAccess(uRL);
            try {
                n = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(this, uRL){
                    private final URL val$url;
                    private final PersistenceServiceImpl this$0;

                    public Object run() throws MalformedURLException, IOException {
                        long[] lArray = PersistenceServiceImpl.access$000(this.this$0).getMuffinAttributes(this.val$url);
                        if (lArray == null) {
                            throw new MalformedURLException();
                        }
                        return new Integer((int)lArray[0]);
                    }
                    {
                        this.this$0 = persistenceServiceImpl;
                        this.val$url = uRL;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block4;
                throw (MalformedURLException)exception;
            }
        }
        return n;
    }

    long getLength(URL uRL) throws MalformedURLException, IOException {
        if (this._muffincache == null) {
            return -1L;
        }
        this.checkAccess(uRL);
        return this._muffincache.getMuffinSize(uRL);
    }

    long getMaxLength(URL uRL) throws MalformedURLException, IOException {
        if (this._muffincache == null) {
            return -1L;
        }
        this.checkAccess(uRL);
        Long l = null;
        try {
            l = (Long)AccessController.doPrivileged(new PrivilegedExceptionAction(this, uRL){
                private final URL val$url;
                private final PersistenceServiceImpl this$0;

                public Object run() throws IOException {
                    long[] lArray = PersistenceServiceImpl.access$000(this.this$0).getMuffinAttributes(this.val$url);
                    if (lArray == null) {
                        return new Long(-1L);
                    }
                    return new Long(lArray[1]);
                }
                {
                    this.this$0 = persistenceServiceImpl;
                    this.val$url = uRL;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return l;
    }

    private void checkAccess(URL uRL) throws MalformedURLException {
        URL uRL2;
        LaunchDesc launchDesc = JNLPClassLoader.getInstance().getLaunchDesc();
        if (launchDesc != null && (uRL2 = launchDesc.getCodebase()) != null) {
            int n;
            String string;
            if (uRL == null || !uRL2.getHost().equals(uRL.getHost())) {
                this.throwAccessDenied(uRL);
            }
            if ((string = uRL.getFile()) == null) {
                this.throwAccessDenied(uRL);
            }
            if ((n = string.lastIndexOf(47)) == -1) {
                return;
            }
            if (!uRL2.getFile().startsWith(string.substring(0, n + 1))) {
                this.throwAccessDenied(uRL);
            }
        }
    }

    public void delete(URL uRL) throws MalformedURLException, IOException {
        block4: {
            if (this._muffincache == null) {
                return;
            }
            this.checkAccess(uRL);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(this, uRL){
                    private final URL val$url;
                    private final PersistenceServiceImpl this$0;

                    public Object run() throws MalformedURLException, IOException {
                        DiskCacheEntry diskCacheEntry = PersistenceServiceImpl.access$000(this.this$0).getMuffinEntry('P', this.val$url);
                        if (diskCacheEntry == null) {
                            throw new FileNotFoundException(this.val$url.toString());
                        }
                        PersistenceServiceImpl.access$000(this.this$0).removeMuffinEntry(diskCacheEntry);
                        return null;
                    }
                    {
                        this.this$0 = persistenceServiceImpl;
                        this.val$url = uRL;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block4;
                throw (MalformedURLException)exception;
            }
        }
    }

    private void throwAccessDenied(URL uRL) throws MalformedURLException {
        throw new MalformedURLException(Resources.getString("APIImpl.persistence.accessdenied", uRL.toString()));
    }

    public void setTag(URL uRL, int n) throws MalformedURLException, IOException {
        block4: {
            if (this._muffincache == null) {
                return;
            }
            this.checkAccess(uRL);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(this, uRL, n){
                    private final URL val$url;
                    private final int val$tag;
                    private final PersistenceServiceImpl this$0;

                    public Object run() throws MalformedURLException, IOException {
                        PersistenceServiceImpl.access$000(this.this$0).putMuffinAttributes(this.val$url, this.val$tag, this.this$0.getMaxLength(this.val$url));
                        return null;
                    }
                    {
                        this.this$0 = persistenceServiceImpl;
                        this.val$url = uRL;
                        this.val$tag = n;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block4;
                throw (MalformedURLException)exception;
            }
        }
    }

    private long checkSetMaxSize(URL uRL, long l) throws IOException {
        long l2;
        URL[] uRLArray = null;
        try {
            uRLArray = (URL[])AccessController.doPrivileged(new PrivilegedExceptionAction(this, uRL){
                private final URL val$url;
                private final PersistenceServiceImpl this$0;

                public Object run() throws IOException {
                    if (PersistenceServiceImpl.access$000(this.this$0) == null) {
                        return new Long(-1L);
                    }
                    return PersistenceServiceImpl.access$000(this.this$0).getAccessibleMuffins(this.val$url);
                }
                {
                    this.this$0 = persistenceServiceImpl;
                    this.val$url = uRL;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        long l3 = 0L;
        if (uRLArray != null) {
            for (int i = 0; i < uRLArray.length; ++i) {
                if (uRLArray[i] == null) continue;
                URL uRL2 = uRLArray[i];
                Long l4 = null;
                try {
                    l4 = (Long)AccessController.doPrivileged(new PrivilegedExceptionAction(this, uRL2){
                        private final URL val$friendMuffin;
                        private final PersistenceServiceImpl this$0;

                        public Object run() throws IOException {
                            return new Long(PersistenceServiceImpl.access$000(this.this$0).getMuffinSize(this.val$friendMuffin));
                        }
                        {
                            this.this$0 = persistenceServiceImpl;
                            this.val$friendMuffin = uRL;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (IOException)privilegedActionException.getException();
                }
                l3 += l4.longValue();
            }
        }
        if ((l2 = l + l3) > this._appLimit) {
            return this.reconcileMaxSize(l, l3, this._appLimit);
        }
        return l;
    }

    public long create(URL uRL, long l) throws MalformedURLException, IOException {
        Long l2;
        block5: {
            if (this._muffincache == null) {
                return -1L;
            }
            this.checkAccess(uRL);
            l2 = null;
            long l3 = -1L;
            l3 = this.checkSetMaxSize(uRL, l);
            if (l3 < 0L) {
                return -1L;
            }
            long l4 = l3;
            try {
                l2 = (Long)AccessController.doPrivileged(new PrivilegedExceptionAction(this, uRL, l4){
                    private final URL val$url;
                    private final long val$pass_newmaxsize;
                    private final PersistenceServiceImpl this$0;

                    public Object run() throws MalformedURLException, IOException {
                        File file = PersistenceServiceImpl.access$000(this.this$0).getTempCacheFile(this.val$url, null);
                        if (file == null) {
                            return new Long(-1L);
                        }
                        PersistenceServiceImpl.access$000(this.this$0).insertMuffinEntry(this.val$url, file, 0, this.val$pass_newmaxsize);
                        return new Long(this.val$pass_newmaxsize);
                    }
                    {
                        this.this$0 = persistenceServiceImpl;
                        this.val$url = uRL;
                        this.val$pass_newmaxsize = l;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block5;
                throw (MalformedURLException)exception;
            }
        }
        return l2;
    }

    long setMaxLength(URL uRL, long l) throws MalformedURLException, IOException {
        long l2;
        block5: {
            l2 = 0L;
            if (this._muffincache == null) {
                return -1L;
            }
            this.checkAccess(uRL);
            l2 = this.checkSetMaxSize(uRL, l);
            if (l2 < 0L) {
                return -1L;
            }
            long l3 = l2;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(this, uRL, l3){
                    private final URL val$url;
                    private final long val$f_newmaxsize;
                    private final PersistenceServiceImpl this$0;

                    public Object run() throws MalformedURLException, IOException {
                        PersistenceServiceImpl.access$000(this.this$0).putMuffinAttributes(this.val$url, this.this$0.getTag(this.val$url), this.val$f_newmaxsize);
                        return null;
                    }
                    {
                        this.this$0 = persistenceServiceImpl;
                        this.val$url = uRL;
                        this.val$f_newmaxsize = l;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block5;
                throw (MalformedURLException)exception;
            }
        }
        return l2;
    }

    static DiskCache access$000(PersistenceServiceImpl persistenceServiceImpl) {
        return persistenceServiceImpl._muffincache;
    }

    static SmartSecurityDialog access$100(PersistenceServiceImpl persistenceServiceImpl) {
        return persistenceServiceImpl._securityDialog;
    }

    public String[] getNames(URL uRL) throws MalformedURLException, IOException {
        String[] stringArray;
        block4: {
            stringArray = null;
            if (this._muffincache == null) {
                return null;
            }
            URL uRL2 = URLUtil.asPathURL(uRL);
            this.checkAccess(uRL2);
            try {
                stringArray = (String[])AccessController.doPrivileged(new PrivilegedExceptionAction(this, uRL2){
                    private final URL val$pathUrl;
                    private final PersistenceServiceImpl this$0;

                    public Object run() throws MalformedURLException, IOException {
                        File file = PersistenceServiceImpl.access$000(this.this$0).getMuffinFileForURL(this.val$pathUrl);
                        if (!file.isDirectory()) {
                            file = file.getParentFile();
                        }
                        File[] fileArray = file.listFiles();
                        Vector<String> vector = new Vector<String>();
                        for (int i = 0; i < fileArray.length; ++i) {
                            if (!PersistenceServiceImpl.access$000(this.this$0).isMainMuffinFile(fileArray[i])) continue;
                            DiskCacheEntry diskCacheEntry = PersistenceServiceImpl.access$000(this.this$0).getCacheEntryFromFile(fileArray[i]);
                            URL uRL = diskCacheEntry.getLocation();
                            File file2 = new File(uRL.getFile());
                            vector.addElement(file2.getName());
                        }
                        return vector.toArray(new String[0]);
                    }
                    {
                        this.this$0 = persistenceServiceImpl;
                        this.val$pathUrl = uRL;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block4;
                throw (MalformedURLException)exception;
            }
        }
        return stringArray;
    }

    private URL[] getAccessibleMuffins(URL uRL) throws IOException {
        if (this._muffincache == null) {
            return null;
        }
        return this._muffincache.getAccessibleMuffins(uRL);
    }

    public FileContents get(URL uRL) throws MalformedURLException, IOException {
        if (this._muffincache == null) {
            return null;
        }
        this.checkAccess(uRL);
        File file = this._muffincache.getMuffinFileForURL(uRL);
        if (file == null) {
            throw new FileNotFoundException(uRL.toString());
        }
        return new FileContentsImpl(file, this, uRL, this.getMaxLength(uRL));
    }
}

