/*
 * Decompiled with CFR 0.152.
 */
package gdtel.ui;

import gdtel.ui.ValidarNombreFichero;
import gdtel.ui.swing.FileFilterEx;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class ExportarImagenJpg {
    private String strRutaImagen = "";

    public boolean guardarImageLayerJpg(String strRuta, Image imagen) {
        if (imagen == null) {
            return false;
        }
        this.strRutaImagen = strRuta;
        JFileChooser fileDlg = strRuta == null ? new JFileChooser() : new JFileChooser(strRuta);
        fileDlg.setFileSelectionMode(0);
        FileFilterEx filter = new FileFilterEx("jpg");
        filter.setDescription("Archivos jpg");
        fileDlg.addChoosableFileFilter(filter);
        int nRet = fileDlg.showSaveDialog(null);
        if (nRet == 0) {
            ValidarNombreFichero validaFichero;
            String strNombreFichero;
            File fich = fileDlg.getSelectedFile();
            String strPath = fich.getPath();
            if (!strPath.endsWith(".jpg")) {
                strPath = strPath + ".jpg";
            }
            if (!(strNombreFichero = fich.getName()).endsWith(".jpg")) {
                strNombreFichero = strNombreFichero + ".jpg";
            }
            if (!(validaFichero = new ValidarNombreFichero()).validaNombreFichero(strNombreFichero)) {
                return false;
            }
            if (!this.generarBufferImage(strPath, imagen)) {
                return false;
            }
            this.strRutaImagen = fileDlg.getCurrentDirectory().getPath();
        }
        return true;
    }

    public String getRutaImagen() {
        return this.strRutaImagen;
    }

    private boolean generarBufferImage(String strRuta, Image imagen) {
        int nWidth = imagen.getWidth(null);
        int nHeight = imagen.getHeight(null);
        if (strRuta == null) {
            return false;
        }
        if (strRuta.equals("")) {
            return false;
        }
        try {
            System.gc();
            BufferedImage buffer = new BufferedImage(nWidth, nHeight, 1);
            Graphics2D g2 = buffer.createGraphics();
            g2.setColor(Color.WHITE);
            g2.drawRect(0, 0, nWidth, nHeight);
            g2.fillRect(0, 0, nWidth, nHeight);
            g2.drawImage(imagen, 0, 0, null);
            g2.dispose();
            ImageIO.write((RenderedImage)buffer, "jpg", new File(strRuta));
            return true;
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "Se ha producido un error a la hora de generar la imagen.", "Atenci\u00f3n", 2);
            return false;
        }
    }
}

