/*
 * Decompiled with CFR 0.152.
 */
package gdtel.ui.piccolo;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PInputManager;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.nodes.P3DRect;
import edu.umd.cs.piccolox.swing.PScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import modela.ui.piccolo.PCanvasModela;

public class VistaReferenciaControl {
    private JRootPane rootPanel;
    private PCanvasModela displayBean;
    private Rectangle2D.Double limites;
    PCanvasModela canvas;
    private PScrollPane scrollPane;
    protected P3DRect viewBox;
    private PPath resizeBox;
    private PPath resizeBox2;
    private PPath resizeBox3;
    private PPath resizeBox4;
    private AdjustmentListener adjustmentListener;
    PPath tempBox;
    PLayer viewLayer;
    public PCamera thumbCamera;
    public PCamera mainViewCamera;
    public PCanvasModela mainViewCanvas;
    double mousePressedX;
    double mousePressedY;
    double viewBoxWhenPressedX;
    double viewBoxWhenPressedY;
    double viewBoxWhenPressedWidth;
    double viewBoxWhenPressedHeight;
    private static final int VIEW_BOX_MIN_DIM = 10;
    private static final int RESIZE_BOX_DIM = 7;
    private ComponentListener guiResizedListener;
    private ComponentListener displayBeanResizedListener;
    private PropertyChangeListener displayBeanViewChangeListener;

    public VistaReferenciaControl(PCanvasModela canvasPadre) {
        this.mainViewCanvas = canvasPadre;
        this.mainViewCanvas.getCamera().addLayer(0, canvasPadre.getLayer());
        this.rootPanel = new JRootPane();
        this.init();
    }

    private void init() {
        this.inicializar();
        this.mainViewCamera = this.mainViewCanvas.getCamera();
        this.inicializarRootPanel();
        this.rootPanel.revalidate();
        this.rootPanel.repaint();
    }

    private void inicializar() {
        this.rootPanel.removeAll();
        if (this.guiResizedListener != null) {
            this.rootPanel.removeComponentListener(this.guiResizedListener);
        }
        if (this.displayBean != null) {
            if (this.displayBeanResizedListener != null) {
                this.mainViewCanvas.removeComponentListener(this.displayBeanResizedListener);
            }
            if (this.displayBeanViewChangeListener != null) {
                this.mainViewCamera.removePropertyChangeListener("viewTransform", this.displayBeanViewChangeListener);
            }
        }
    }

    void zoomExtensionTotal() {
        this.calculateRootBounds();
        PBounds mainViewBounds = this.mainViewCamera.getViewBounds();
        this.thumbCamera.addPropertyChangeListener("viewTransform", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                VistaReferenciaControl.this.updateResizeBox();
            }
        });
        if (mainViewBounds.contains(this.limites)) {
            this.thumbCamera.animateViewToCenterBounds((Rectangle2D)mainViewBounds, true, 1L);
        } else {
            this.thumbCamera.animateViewToCenterBounds((Rectangle2D)this.limites, true, 1L);
        }
        this.updateViewBox();
        this.updateResizeBox();
    }

    private void inicializarRootPanel() {
        this.canvas = new PCanvasModela();
        this.canvas.setPreferredSize(new Dimension(250, 250));
        this.canvas.removeInputEventListener((PInputEventListener)this.canvas.getZoomEventHandler());
        this.canvas.removeInputEventListener((PInputEventListener)this.canvas.getPanEventHandler());
        this.scrollPane = new PScrollPane((Component)((Object)this.canvas));
        this.scrollListener(true);
        this.rootPanel.setLayout(new BorderLayout());
        this.rootPanel.add((Component)this.scrollPane, "Center");
        this.thumbCamera = this.canvas.getCamera();
        this.createViewBox();
        this.createResizeBox();
        this.viewLayer = new PLayer();
        this.viewLayer.addChild((PNode)this.viewBox);
        this.viewLayer.addChild((PNode)this.resizeBox);
        this.viewLayer.addChild((PNode)this.resizeBox2);
        this.viewLayer.addChild((PNode)this.resizeBox3);
        this.viewLayer.addChild((PNode)this.resizeBox4);
        this.thumbCamera.addLayer(this.mainViewCanvas.getLayer());
        this.canvas.getLayer().addChild((PNode)this.viewLayer);
        this.thumbCamera.addLayer(this.viewLayer);
        this.guiResizedListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                VistaReferenciaControl.this.zoomExtensionTotal();
            }
        };
        this.rootPanel.addComponentListener(this.guiResizedListener);
        this.displayBeanResizedListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                VistaReferenciaControl.this.updateViewBox();
                VistaReferenciaControl.this.updateResizeBox();
            }
        };
        this.mainViewCanvas.addComponentListener(this.displayBeanResizedListener);
        this.displayBeanViewChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                VistaReferenciaControl.this.updateViewBox();
                VistaReferenciaControl.this.updateResizeBox();
            }
        };
        this.mainViewCamera.addPropertyChangeListener("viewTransform", this.displayBeanViewChangeListener);
        this.viewBox.addInputEventListener((PInputEventListener)new VistaAdapter());
        this.resizeBox.addInputEventListener((PInputEventListener)new ReadaptadoraSizeAdapter(2));
        this.resizeBox2.addInputEventListener((PInputEventListener)new ReadaptadoraSizeAdapter(3));
        this.resizeBox3.addInputEventListener((PInputEventListener)new ReadaptadoraSizeAdapter(4));
        this.resizeBox4.addInputEventListener((PInputEventListener)new ReadaptadoraSizeAdapter(1));
    }

    public Component getRootPanel() {
        return this.rootPanel;
    }

    public PCamera getCamaraPrincipal() {
        return this.mainViewCamera;
    }

    public PCamera getThumbCamera() {
        return this.thumbCamera;
    }

    public PCanvasModela getThumbCanvas() {
        return this.canvas;
    }

    public PCanvasModela getMainViewCanvas() {
        return this.mainViewCanvas;
    }

    public void cerrar() {
        this.rootPanel = null;
    }

    public void refresh() {
        this.init();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VistaReferenciaControl.this.zoomExtensionTotal();
            }
        });
    }

    private void createViewBox() {
        this.viewBox = new P3DRect();
        this.viewBox.setPaint((Paint)new Color(128, 128, 255));
        this.viewBox.setTransparency(0.4f);
    }

    void createTempBox() {
        this.tempBox = new PPath((Shape)this.viewBox.getBounds());
        this.tempBox.setPaint(null);
    }

    private void createResizeBox() {
        this.resizeBox = new PPath((Shape)new Rectangle2D.Double());
        this.resizeBox.setPaint((Paint)new Color(128, 128, 255));
        this.resizeBox2 = new PPath((Shape)new Rectangle2D.Double());
        this.resizeBox2.setPaint((Paint)new Color(128, 128, 255));
        this.resizeBox3 = new PPath((Shape)new Rectangle2D.Double());
        this.resizeBox3.setPaint((Paint)new Color(128, 128, 255));
        this.resizeBox4 = new PPath((Shape)new Rectangle2D.Double());
        this.resizeBox4.setPaint((Paint)new Color(128, 128, 255));
    }

    void updateViewBox() {
        PBounds shrimpViewBounds = this.mainViewCamera.getViewBounds();
        double x = shrimpViewBounds.getX();
        double y = shrimpViewBounds.getY();
        double w = shrimpViewBounds.getWidth();
        double h = shrimpViewBounds.getHeight();
        double scale = this.thumbCamera.getViewScale();
        double oldW = w;
        double oldH = h;
        if (w < h) {
            w = Math.max(w, 10.0 / scale);
            h = h * w / oldW;
        } else {
            h = Math.max(h, 10.0 / scale);
            w = w * h / oldH;
        }
        this.viewBox.setBounds((Rectangle2D)new Rectangle2D.Double(x -= (w - oldW) / 2.0, y -= (h - oldH) / 2.0, w, h));
    }

    void updateResizeBox() {
        PBounds viewBoxBounds = this.viewBox.getBounds();
        double scale = this.thumbCamera.getViewScale();
        double w = 7.0 / scale;
        double h = 7.0 / scale;
        double x = viewBoxBounds.getX() + viewBoxBounds.getWidth() - w;
        double y = viewBoxBounds.getY() + viewBoxBounds.getHeight() - h;
        this.resizeBox.setPathTo((Shape)new Rectangle2D.Double(x, y, w, h));
        x = viewBoxBounds.getX();
        y = viewBoxBounds.getY() + viewBoxBounds.getHeight() - h;
        this.resizeBox2.setPathTo((Shape)new Rectangle2D.Double(x, y, w, h));
        x = viewBoxBounds.getX();
        y = viewBoxBounds.getY();
        this.resizeBox3.setPathTo((Shape)new Rectangle2D.Double(x, y, w, h));
        x = viewBoxBounds.getX() + viewBoxBounds.getWidth() - w;
        y = viewBoxBounds.getY();
        this.resizeBox4.setPathTo((Shape)new Rectangle2D.Double(x, y, w, h));
    }

    private void calculateRootBounds() {
        this.limites = new Rectangle2D.Double();
        this.limites.setRect(this.mainViewCanvas.getBounds().getBounds2D());
        double x = this.limites.getX();
        double y = this.limites.getY();
        double w = this.limites.getWidth();
        double h = this.limites.getHeight();
        x -= w * (double)0.02f;
        y -= h * (double)0.02f;
        this.limites.setRect(x, y, w *= (double)1.04f, h *= (double)1.04f);
    }

    public void scrollListener(boolean bOn) {
        if (!bOn) {
            this.scrollPane.getHorizontalScrollBar().removeAdjustmentListener(this.adjustmentListener);
            this.scrollPane.getVerticalScrollBar().removeAdjustmentListener(this.adjustmentListener);
            this.adjustmentListener = null;
            return;
        }
        this.adjustmentListener = new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent evt) {
            }
        };
        this.scrollPane.getHorizontalScrollBar().addAdjustmentListener(this.adjustmentListener);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(this.adjustmentListener);
    }

    private class ReadaptadoraSizeAdapter
    extends PInputManager {
        private static final int RESIZE_BOX_NE = 1;
        private static final int RESIZE_BOX_SE = 2;
        private static final int RESIZE_BOX_SO = 3;
        private static final int RESIZE_BOX_NO = 4;
        private int nTipo = 2;

        public ReadaptadoraSizeAdapter(int nNuevoTipo) {
            this.nTipo = nNuevoTipo;
        }

        public void mouseEntered(PInputEvent e) {
            switch (this.nTipo) {
                case 1: {
                    VistaReferenciaControl.this.canvas.setCursor(Cursor.getPredefinedCursor(7));
                    break;
                }
                case 2: {
                    VistaReferenciaControl.this.canvas.setCursor(Cursor.getPredefinedCursor(5));
                    break;
                }
                case 3: {
                    VistaReferenciaControl.this.canvas.setCursor(Cursor.getPredefinedCursor(4));
                    break;
                }
                case 4: {
                    VistaReferenciaControl.this.canvas.setCursor(Cursor.getPredefinedCursor(6));
                }
            }
        }

        public void mouseExited(PInputEvent e) {
            VistaReferenciaControl.this.canvas.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void mousePressed(PInputEvent e) {
            VistaReferenciaControl.this.mousePressedX = e.getPosition().getX();
            VistaReferenciaControl.this.mousePressedY = e.getPosition().getY();
            VistaReferenciaControl.this.viewBoxWhenPressedWidth = VistaReferenciaControl.this.viewBox.getBounds().getWidth();
            VistaReferenciaControl.this.viewBoxWhenPressedHeight = VistaReferenciaControl.this.viewBox.getBounds().getHeight();
            VistaReferenciaControl.this.createTempBox();
            VistaReferenciaControl.this.viewLayer.addChild((PNode)VistaReferenciaControl.this.tempBox);
        }

        public void mouseReleased(PInputEvent e) {
            VistaReferenciaControl.this.mainViewCamera.animateViewToCenterBounds((Rectangle2D)VistaReferenciaControl.this.tempBox.getBounds(), true, 1L);
            VistaReferenciaControl.this.tempBox.removeFromParent();
        }

        public void mouseDragged(PInputEvent e) {
            double mouseDraggedX = e.getPosition().getX();
            double mouseDraggedY = e.getPosition().getY();
            double diffX = VistaReferenciaControl.this.mousePressedX - mouseDraggedX;
            double diffY = VistaReferenciaControl.this.mousePressedY - mouseDraggedY;
            double w = VistaReferenciaControl.this.viewBoxWhenPressedWidth - diffX;
            double h = VistaReferenciaControl.this.viewBoxWhenPressedHeight - diffY;
            double x = VistaReferenciaControl.this.viewBox.getBounds().getX();
            double y = VistaReferenciaControl.this.viewBox.getBounds().getY();
            switch (this.nTipo) {
                case 1: {
                    x = VistaReferenciaControl.this.viewBox.getBounds().getX();
                    y = mouseDraggedY;
                    h = VistaReferenciaControl.this.viewBoxWhenPressedHeight + diffY;
                    w = VistaReferenciaControl.this.viewBoxWhenPressedWidth - diffX;
                    VistaReferenciaControl.this.tempBox.setPathTo((Shape)new Rectangle2D.Double(x, y, w, h));
                    break;
                }
                case 4: {
                    x = mouseDraggedX;
                    y = mouseDraggedY;
                    w = VistaReferenciaControl.this.viewBoxWhenPressedWidth + diffX;
                    h = VistaReferenciaControl.this.viewBoxWhenPressedHeight + diffY;
                    VistaReferenciaControl.this.tempBox.setPathTo((Shape)new Rectangle2D.Double(x, y, w, h));
                    break;
                }
                case 2: {
                    w = VistaReferenciaControl.this.viewBoxWhenPressedWidth - diffX;
                    h = VistaReferenciaControl.this.viewBoxWhenPressedHeight - diffY;
                    x = VistaReferenciaControl.this.viewBox.getBounds().getX();
                    y = VistaReferenciaControl.this.viewBox.getBounds().getY();
                    VistaReferenciaControl.this.tempBox.setPathTo((Shape)new Rectangle2D.Double(x, y, w, h));
                    break;
                }
                case 3: {
                    x = mouseDraggedX;
                    w = VistaReferenciaControl.this.viewBoxWhenPressedWidth + diffX;
                    h = VistaReferenciaControl.this.viewBoxWhenPressedHeight - diffY;
                    y = VistaReferenciaControl.this.viewBox.getBounds().getY();
                    VistaReferenciaControl.this.tempBox.setPathTo((Shape)new Rectangle2D.Double(x, y, w, h));
                }
            }
        }
    }

    public class VistaAdapter
    extends PInputManager {
        public void mouseEntered(PInputEvent e) {
            VistaReferenciaControl.this.canvas.setCursor(Cursor.getPredefinedCursor(13));
        }

        public void mouseExited(PInputEvent e) {
            VistaReferenciaControl.this.canvas.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void mousePressed(PInputEvent e) {
            VistaReferenciaControl.this.mousePressedX = e.getPosition().getX();
            VistaReferenciaControl.this.mousePressedY = e.getPosition().getY();
            VistaReferenciaControl.this.viewBoxWhenPressedX = VistaReferenciaControl.this.viewBox.getBounds().getX();
            VistaReferenciaControl.this.viewBoxWhenPressedY = VistaReferenciaControl.this.viewBox.getBounds().getY();
            VistaReferenciaControl.this.createTempBox();
            VistaReferenciaControl.this.viewLayer.addChild((PNode)VistaReferenciaControl.this.tempBox);
        }

        public void mouseReleased(PInputEvent e) {
            VistaReferenciaControl.this.mainViewCamera.animateViewToCenterBounds((Rectangle2D)VistaReferenciaControl.this.tempBox.getBounds(), true, 1L);
            VistaReferenciaControl.this.tempBox.removeFromParent();
        }

        public void mouseDragged(PInputEvent e) {
            double mouseDraggedX = e.getPosition().getX();
            double mouseDraggedY = e.getPosition().getY();
            double x = VistaReferenciaControl.this.viewBoxWhenPressedX - (VistaReferenciaControl.this.mousePressedX - mouseDraggedX);
            double y = VistaReferenciaControl.this.viewBoxWhenPressedY - (VistaReferenciaControl.this.mousePressedY - mouseDraggedY);
            double w = VistaReferenciaControl.this.viewBox.getBounds().getWidth();
            double h = VistaReferenciaControl.this.viewBox.getBounds().getHeight();
            VistaReferenciaControl.this.tempBox.setPathTo((Shape)new Rectangle2D.Double(x, y, w, h));
            VistaReferenciaControl.this.updateResizeBox();
        }
    }
}

