/*
 * Decompiled with CFR 0.152.
 */
package modela.bd.obj;

import gdtel.ui.IAsignable;
import gdtel.util.GeneradorID;
import gdtel.util.UtilObj;
import java.math.BigDecimal;
import modela.graf.CodificadorAtributosXML;
import modela.graf.CreadorXMLDefProc;
import modela.graf.Referencia;

public class TrAviso
extends Referencia
implements Cloneable,
IAsignable,
Comparable {
    private BigDecimal X_ID = BigDecimal.valueOf(GeneradorID.getID());
    private String C_NOMBRE = null;
    private String D_DESCRIPCION = null;

    public String getNOMBRE() {
        return this.C_NOMBRE;
    }

    public void setNOMBRE(String _C_NOMBRE) {
        this.C_NOMBRE = _C_NOMBRE;
    }

    public String getDESCRIPCION() {
        return this.D_DESCRIPCION;
    }

    public void setDESCRIPCION(String _D_DESCRIPCION) {
        this.D_DESCRIPCION = _D_DESCRIPCION;
    }

    public BigDecimal getXID() {
        return this.X_ID;
    }

    public void setXID(BigDecimal _X_ID) {
        this.X_ID = _X_ID;
    }

    public double getID() {
        if (this.getXID() == null) {
            return 0.0;
        }
        return this.getXID().doubleValue();
    }

    public String getClave() {
        if (this.getXID() == null) {
            return "";
        }
        return this.getXID().toString();
    }

    public String getNombre() {
        return this.getNOMBRE();
    }

    public String getDescripcion() {
        return this.getDESCRIPCION();
    }

    public String toString() {
        return this.getNOMBRE();
    }

    public void toPrintln() {
        String strID = this.X_ID == null ? "null" : this.X_ID.toString();
        String strDescr = this.D_DESCRIPCION == null ? "null" : this.D_DESCRIPCION.toString();
        String strNombre = this.C_NOMBRE == null ? "null" : this.C_NOMBRE;
        System.out.println(strID + " - " + strNombre + " - " + strDescr);
    }

    public Object clone() {
        Object obj = null;
        try {
            obj = super.clone();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        super.finalize();
    }

    public String toXML() {
        String strXML = null;
        if (this.C_NOMBRE == null || this.X_ID == null || this.D_DESCRIPCION == null) {
            return null;
        }
        strXML = "<AVISO id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(this.X_ID.longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES + " nombre=" + CreadorXMLDefProc.COMILLAS_DOBLES + CodificadorAtributosXML.codificar(this.C_NOMBRE) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " descripcion=" + CreadorXMLDefProc.COMILLAS_DOBLES + CodificadorAtributosXML.codificar(this.D_DESCRIPCION) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + "/>";
        return strXML;
    }

    public boolean equals(TrAviso c) {
        if (c == null) {
            return false;
        }
        if (UtilObj.isAnyNull(this.getXID(), c.getXID())) {
            return false;
        }
        if (!UtilObj.areBothNull(this.getXID(), c.getXID()) && c.getXID().compareTo(this.getXID()) != 0) {
            return false;
        }
        if (UtilObj.isAnyNull(c.getNombre(), this.getNombre())) {
            return false;
        }
        if (!UtilObj.areBothNull(c.getNombre(), this.getNombre()) && !c.getNombre().equals(this.getNombre())) {
            return false;
        }
        if (UtilObj.isAnyNull(c.getDescripcion(), this.getDescripcion())) {
            return false;
        }
        return UtilObj.areBothNull(c.getDescripcion(), this.getDescripcion()) || c.getDescripcion().equals(this.getDescripcion());
    }

    public int compareTo(Object o) {
        TrAviso avisoN = (TrAviso)o;
        int cmp = this.getNombre().compareTo(avisoN.getNombre());
        return cmp;
    }
}

