/*
 * Decompiled with CFR 0.152.
 */
package modela.bd.obj;

import gdtel.ui.IAsignable;
import gdtel.util.GeneradorID;
import gdtel.util.UtilObj;
import java.math.BigDecimal;
import modela.bd.obj.TrAviso;
import modela.graf.CodificadorAtributosXML;
import modela.graf.CreadorXMLDefProc;
import modela.graf.Referencia;

public class TrAvisoTransicion
extends Referencia
implements Cloneable,
IAsignable,
Comparable {
    private BigDecimal X_ID = BigDecimal.valueOf(GeneradorID.getID());
    private TrAviso m_trAviso = null;
    private boolean m_bValida = true;
    private String m_strMenajeOk = null;
    private String m_strComprobar = null;
    public static final String COMPROBAR_TRAMITAR = "TRAMITAR";
    public static final String COMPROBAR_DESHACER = "DESHACER";
    public static final String COMPROBAR_TRAMITAR_DESHACER = "TRAMITAR Y DESHACER";
    public static final String COMPROBAR_VISUALIZAR = "VISUALIZAR";

    public BigDecimal getXID() {
        return this.X_ID;
    }

    public void setXID(BigDecimal _X_ID) {
        this.X_ID = _X_ID;
    }

    public double getID() {
        if (this.getXID() == null) {
            return 0.0;
        }
        return this.getXID().doubleValue();
    }

    public String getClave() {
        if (this.getXID() == null) {
            return "";
        }
        return this.getXID().toString();
    }

    public TrAviso getAviso() {
        return this.m_trAviso;
    }

    public void setAviso(TrAviso trAviso) {
        this.m_trAviso = trAviso;
    }

    public String getMensajeOk() {
        return this.m_strMenajeOk;
    }

    public void setMensajeOk(String strMensajeOk) {
        this.m_strMenajeOk = strMensajeOk;
    }

    public String getMensajeNoOk() {
        return this.m_strMenajeOk;
    }

    public String getNombre() {
        if (this.m_trAviso == null) {
            return "";
        }
        return this.m_trAviso.getNOMBRE();
    }

    public String getDescripcion() {
        if (this.m_trAviso == null) {
            return "";
        }
        return this.m_trAviso.getDESCRIPCION();
    }

    public void toPrintln() {
        if (this.m_trAviso == null) {
            return;
        }
        String strID = this.X_ID == null ? "null" : this.X_ID.toString();
        String strDescr = this.m_trAviso.getDESCRIPCION() == null ? "null" : this.m_trAviso.getDESCRIPCION();
        String strNombre = this.m_trAviso.getNOMBRE() == null ? "null" : this.m_trAviso.getNOMBRE();
        System.out.println(strID + " - " + strNombre + " - " + strDescr);
    }

    public Object clone() {
        Object obj = null;
        try {
            obj = super.clone();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        super.finalize();
    }

    public String toXML(BigDecimal TransicionID) {
        String strXML = null;
        if (this.m_trAviso == null || this.X_ID == null || TransicionID == null) {
            return null;
        }
        strXML = "<AVISO_TRANSICION  id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(this.X_ID.longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " aviso_id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(this.m_trAviso.getXID().longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " transicion_id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(TransicionID.longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES;
        if (this.m_strMenajeOk != null && !this.m_strMenajeOk.equals("")) {
            strXML = strXML + " mensaje_ok=" + CreadorXMLDefProc.COMILLAS_DOBLES + CodificadorAtributosXML.codificar(this.m_strMenajeOk) + CreadorXMLDefProc.COMILLAS_DOBLES;
        }
        if (this.m_strComprobar != null && !this.m_strComprobar.equals("")) {
            strXML = strXML + " comprobar=" + CreadorXMLDefProc.COMILLAS_DOBLES + this.m_strComprobar + CreadorXMLDefProc.COMILLAS_DOBLES;
        }
        strXML = strXML + " valida=" + CreadorXMLDefProc.COMILLAS_DOBLES + this.isValidaToString() + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + "/>";
        return strXML;
    }

    public boolean equals(TrAvisoTransicion c) {
        if (c == null) {
            return false;
        }
        if (UtilObj.isAnyNull(this.getXID(), c.getXID())) {
            return false;
        }
        if (!UtilObj.areBothNull(this.getXID(), c.getXID()) && c.getXID().compareTo(this.getXID()) != 0) {
            return false;
        }
        if (UtilObj.isAnyNull(c.getAviso(), this.getAviso())) {
            return false;
        }
        if (!UtilObj.areBothNull(c.getAviso(), this.getAviso()) && !c.getAviso().equals(this.getAviso())) {
            return false;
        }
        if (UtilObj.isAnyNull(c.getMensajeOk(), this.getMensajeOk())) {
            return false;
        }
        if (!UtilObj.areBothNull(c.getMensajeOk(), this.getMensajeOk()) && !c.getMensajeOk().equals(this.getMensajeOk())) {
            return false;
        }
        if (UtilObj.isAnyNull(c.getMensajeNoOk(), this.getMensajeNoOk())) {
            return false;
        }
        return UtilObj.areBothNull(c.getMensajeNoOk(), this.getMensajeNoOk()) || c.getMensajeOk().equals(this.getMensajeNoOk());
    }

    public void setValida(boolean bValida) {
        this.m_bValida = bValida;
    }

    public boolean isValida() {
        return this.m_bValida;
    }

    public String isValidaToString() {
        if (this.isValida()) {
            return "S";
        }
        return "N";
    }

    public String getComprobar() {
        return this.m_strComprobar;
    }

    public void setComprobar(String strComprobar) {
        this.m_strComprobar = strComprobar;
    }

    public String toString() {
        if (this.m_trAviso == null) {
            return "";
        }
        return this.m_trAviso.getNOMBRE();
    }

    public String getValidaToString() {
        if (this.isValida()) {
            return "S\u00cd";
        }
        return "NO";
    }

    public String getComprobarToString() {
        if (this.m_strComprobar == null) {
            return "";
        }
        if (this.m_strComprobar.equals("T")) {
            return COMPROBAR_TRAMITAR;
        }
        if (this.m_strComprobar.equals("D")) {
            return COMPROBAR_DESHACER;
        }
        if (this.m_strComprobar.equals("A")) {
            return COMPROBAR_TRAMITAR_DESHACER;
        }
        if (this.m_strComprobar.equals("V")) {
            return COMPROBAR_VISUALIZAR;
        }
        return "";
    }

    public int compareTo(Object o) {
        TrAvisoTransicion avisoTran = (TrAvisoTransicion)o;
        int cmp = this.getNombre().compareTo(avisoTran.getNombre());
        return cmp;
    }
}

