/*
 * Decompiled with CFR 0.152.
 */
package modela.bd.obj;

import gdtel.bd.tpo.TpoPK;
import gdtel.ui.IAsignable;
import gdtel.util.GeneradorID;
import java.math.BigDecimal;
import java.util.ArrayList;
import modela.bd.obj.TrParametro;
import modela.bd.obj.TrTipoBloque;
import modela.bd.obj.TrTipoTarea;
import modela.conf.ModelaConf;
import modela.graf.CodificadorAtributosXML;
import modela.graf.CreadorXMLDefProc;
import modela.graf.Referencia;

public class TrBloque
extends Referencia
implements Cloneable,
IAsignable,
Comparable {
    private TpoPK xID = new TpoPK(BigDecimal.valueOf(GeneradorID.getID()));
    private String strNombre = null;
    private String strDescripcion = null;
    private String informar = "N";
    private ArrayList m_Parametros = null;
    private TrTipoBloque m_TipoBloque = new TrTipoBloque();

    public TrBloque() {
        this.m_Parametros = new ArrayList();
    }

    public TpoPK getBloqueId() {
        return this.xID;
    }

    public void setBloqueId(TpoPK pIDBloque) {
        this.xID = pIDBloque;
    }

    public String getClave() {
        if (this.getBloqueId() == null) {
            return "";
        }
        return this.getBloqueId().toString();
    }

    public double getID() {
        if (this.getBloqueId() == null) {
            return 0.0;
        }
        return this.getBloqueId().getPkVal().doubleValue();
    }

    public String getNombre() {
        return this.strNombre;
    }

    public void setNombre(String pNombre) {
        this.strNombre = pNombre;
    }

    public String getDescripcion() {
        return this.strDescripcion;
    }

    public void setDescripcion(String pDescripcion) {
        this.strDescripcion = pDescripcion;
    }

    public String toString() {
        return this.getNombre();
    }

    public String getInformar() {
        return this.informar;
    }

    public boolean isInformar() {
        return this.informar.compareTo("S") == 0;
    }

    public void setInformar(String strValor) {
        this.informar = strValor;
    }

    public void setInformar(boolean bInformar) {
        this.informar = bInformar ? "S" : "N";
    }

    public Object clone() {
        Object obj = null;
        try {
            obj = super.clone();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        super.finalize();
    }

    public void toPrintln() {
        String strID = this.xID == null ? "null" : this.xID.toString();
        String strNombre = this.strNombre == null ? "null" : this.strNombre;
        String strDescr = this.strDescripcion == null ? "null" : this.strDescripcion.toString();
        System.out.println(strID + " - " + strNombre + " - " + strDescr);
    }

    public boolean equals(TrBloque trBloqueCompara) {
        if (trBloqueCompara == null) {
            return false;
        }
        if (this.xID == null || trBloqueCompara.getBloqueId() == null ? this.xID != null || trBloqueCompara.getBloqueId() != null : this.xID.getPkVal().compareTo(trBloqueCompara.getBloqueId().getPkVal()) != 0) {
            return false;
        }
        if (this.strNombre == null || trBloqueCompara.getNombre() == null ? this.strNombre != null || trBloqueCompara.getNombre() != null : !this.strNombre.equals(trBloqueCompara.getNombre())) {
            return false;
        }
        return !(this.strDescripcion == null || trBloqueCompara.getDescripcion() == null ? this.strDescripcion != null || trBloqueCompara.getDescripcion() != null : !this.strDescripcion.equals(trBloqueCompara.getDescripcion()));
    }

    public String toXMLFinParametro() {
        return "</BLOQUE>";
    }

    public final ArrayList getParametros() {
        return this.m_Parametros;
    }

    public final void setParametros(ArrayList Parametros) {
        this.m_Parametros = Parametros;
    }

    public final TrTipoBloque getTipoBloque() {
        return this.m_TipoBloque;
    }

    public final void setTipoBloque(TrTipoBloque trTipoBloque) {
        this.m_TipoBloque = trTipoBloque;
    }

    public void addParametro(TrParametro newParametro) {
        this.m_Parametros.add(newParametro);
    }

    public void limpiarListaParametros() {
        this.m_Parametros.clear();
    }

    public String toXML() {
        String strXML = null;
        if (this.m_TipoBloque == null) {
            return null;
        }
        if (this.strNombre == null || this.xID == null || this.strDescripcion == null || this.m_TipoBloque.getTipoBloque() == null) {
            return null;
        }
        strXML = "<BLOQUE id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(this.xID.getPkVal().longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES + " nombre=" + CreadorXMLDefProc.COMILLAS_DOBLES + CodificadorAtributosXML.codificar(this.strNombre) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " descripcion=" + CreadorXMLDefProc.COMILLAS_DOBLES + CodificadorAtributosXML.codificar(this.strDescripcion) + CreadorXMLDefProc.COMILLAS_DOBLES;
        if (!this.m_TipoBloque.getTipoBloque().equals("")) {
            strXML = strXML + " tipo=" + CreadorXMLDefProc.COMILLAS_DOBLES + CodificadorAtributosXML.codificar(this.m_TipoBloque.getTipoBloque()) + CreadorXMLDefProc.COMILLAS_DOBLES;
        }
        strXML = strXML + " informar=" + CreadorXMLDefProc.COMILLAS_DOBLES + this.getInformar() + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + ">";
        if (!ModelaConf.isCompatibleTrewa0()) {
            if (this.m_Parametros.size() > 0) {
                strXML = strXML + "\n";
                strXML = strXML + "<PARAMETROS_BLOQUE>";
                strXML = strXML + "\n";
                int nOrden = 1;
                for (int i = 0; i < this.m_Parametros.size(); ++i) {
                    TrParametro parametro = (TrParametro)this.m_Parametros.get(i);
                    if (parametro == null) continue;
                    strXML = strXML + "<PARAMETRO_BLOQUE parametro_id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(parametro.getPARAMID().getPkVal().longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES + " orden=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(nOrden) + CreadorXMLDefProc.COMILLAS_DOBLES + "/>";
                    ++nOrden;
                }
                strXML = strXML + "\n";
                strXML = strXML + "</PARAMETROS_BLOQUE>";
                strXML = strXML + "\n";
            }
        } else {
            strXML = strXML + "\n";
            strXML = strXML + "<PARAMETROS_BLOQUE>";
            strXML = strXML + "\n";
            int nOrden = 1;
            for (int i = 0; i < this.m_Parametros.size(); ++i) {
                TrParametro parametro = (TrParametro)this.m_Parametros.get(i);
                if (parametro == null) continue;
                strXML = strXML + "<PARAMETRO_BLOQUE parametro_id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(parametro.getPARAMID().getPkVal().longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES + " orden=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(nOrden) + CreadorXMLDefProc.COMILLAS_DOBLES + "/>";
                ++nOrden;
            }
            strXML = strXML + "\n";
            strXML = strXML + "</PARAMETROS_BLOQUE>";
            strXML = strXML + "\n";
        }
        strXML = strXML + "</BLOQUE>";
        return strXML;
    }

    public int compareTo(Object o) {
        TrBloque bloqueN = (TrBloque)o;
        int cmp = this.getNombre().compareTo(bloqueN.getNombre());
        return cmp;
    }

    public TrTipoTarea getTrTipoTarea() {
        if (this.getTipoBloque() == TrTipoBloque.FORM || this.getTipoBloque() == TrTipoBloque.WEB || this.getTipoBloque() == TrTipoBloque.REPORT) {
            return TrTipoTarea.MANIPULAR_DATOS;
        }
        if (this.getTipoBloque() == TrTipoBloque.OTROS) {
            return TrTipoTarea.OTROS;
        }
        return null;
    }

    public void addParametro(TrParametro newParametro, int ordenParametro) {
        int nSizeActual = this.m_Parametros.size();
        if (ordenParametro > nSizeActual - 1) {
            do {
                this.m_Parametros.add(null);
            } while (ordenParametro > (nSizeActual = this.m_Parametros.size()) - 1);
        }
        this.m_Parametros.set(ordenParametro, newParametro);
    }

    public void eliminarParametrosNulos() {
        for (int nDel = this.m_Parametros.size() - 1; nDel >= 0; --nDel) {
            if (this.m_Parametros.get(nDel) != null) continue;
            this.m_Parametros.remove(nDel);
        }
    }
}

