/*
 * Decompiled with CFR 0.152.
 */
package modela.bd.obj;

import gdtel.ui.IAsignable;
import gdtel.util.GeneradorID;
import java.math.BigDecimal;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrTransicion;
import modela.graf.CodificadorAtributosXML;
import modela.graf.CreadorXMLDefProc;
import modela.graf.Referencia;

public class TrPlazoSimple
extends Referencia
implements Cloneable,
IAsignable {
    private BigDecimal X_ID = BigDecimal.valueOf(GeneradorID.getID());
    private BigDecimal TRANSICION_ID = null;
    private String D_DESCRIPCION = null;
    private String m_strUnidad = null;
    private int m_nNumUnidades = 0;
    private TrTransicion transicionQueProvoca = null;
    private TrFase faseAsociada = null;
    public static final String UNIDADES_DIA = "DIAS";
    public static final String UNIDADES_MES = "MESES";
    public static final String UNIDADES_ANO = "A\u00d1OS";
    public static final int TIPO_ORIGEN_TRANSICION = 1;
    public static final int TIPO_ORIGEN_TAREA = 2;

    public BigDecimal getXID() {
        return this.X_ID;
    }

    public void setXID(BigDecimal _X_ID) {
        this.X_ID = _X_ID;
    }

    public BigDecimal getTransicionID() {
        return this.TRANSICION_ID;
    }

    public void setTransicionID(BigDecimal _X_ID) {
        this.TRANSICION_ID = _X_ID;
    }

    public TrTransicion getTransicionQueProvoca() {
        return this.transicionQueProvoca;
    }

    public void setTransicionQueProvoca(TrTransicion transi) {
        this.transicionQueProvoca = transi;
        if (transi != null) {
            this.setTransicionID(transi.getTRANID());
        } else {
            this.setTransicionID(null);
        }
    }

    public TrFase getFaseAsociada() {
        return this.faseAsociada;
    }

    public void setFaseAsociada(TrFase pFase) {
        this.faseAsociada = pFase;
    }

    public double getID() {
        if (this.getXID() == null) {
            return 0.0;
        }
        return this.getXID().doubleValue();
    }

    public String getClave() {
        if (this.getXID() == null) {
            return "";
        }
        return this.getXID().toString();
    }

    public String getDescripcion() {
        return this.D_DESCRIPCION;
    }

    public void setDESCRIPCION(String strDescripcion) {
        this.D_DESCRIPCION = strDescripcion;
    }

    public String getNombre() {
        return "";
    }

    public String toString() {
        return "";
    }

    public String getUnidad() {
        return this.m_strUnidad;
    }

    public void setUnidad(String strUnidad) {
        this.m_strUnidad = strUnidad;
    }

    public int getNumUnidades() {
        return this.m_nNumUnidades;
    }

    public void setNumUnidades(int nUnidades) {
        this.m_nNumUnidades = nUnidades;
    }

    public String toXML(int nTipoOrigenPlazo, BigDecimal idOrigenPlazo) {
        if (idOrigenPlazo == null) {
            return null;
        }
        if (this.X_ID == null || this.D_DESCRIPCION == null || this.faseAsociada == null || this.m_strUnidad == null) {
            return null;
        }
        String strXML = null;
        strXML = "<PLAZO_SIMPLE id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(this.X_ID.longValue()) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " descripcion=" + CreadorXMLDefProc.COMILLAS_DOBLES + CodificadorAtributosXML.codificar(this.D_DESCRIPCION) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " fase_id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(this.faseAsociada.getFASEID().longValue()) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " unidad=" + CreadorXMLDefProc.COMILLAS_DOBLES + CodificadorAtributosXML.codificar(this.m_strUnidad) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " numero_uds=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(this.m_nNumUnidades) + CreadorXMLDefProc.COMILLAS_DOBLES;
        if (nTipoOrigenPlazo == 1) {
            strXML = strXML + " transfase_id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(idOrigenPlazo.longValue()) + CreadorXMLDefProc.COMILLAS_DOBLES;
            if (this.transicionQueProvoca != null) {
                strXML = strXML + " transicion_id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(this.transicionQueProvoca.getTRANID().longValue()) + CreadorXMLDefProc.COMILLAS_DOBLES;
            }
        } else if (nTipoOrigenPlazo == 2) {
            strXML = strXML + " tareafase_id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(idOrigenPlazo.longValue()) + CreadorXMLDefProc.COMILLAS_DOBLES;
        }
        strXML = strXML + "/>";
        return strXML;
    }

    public String getUnidadesToString() {
        if (this.m_strUnidad == null) {
            return "";
        }
        if (this.m_strUnidad.equals("D")) {
            return UNIDADES_DIA;
        }
        if (this.m_strUnidad.equals("M")) {
            return UNIDADES_MES;
        }
        if (this.m_strUnidad.equals("A")) {
            return UNIDADES_ANO;
        }
        return "";
    }
}

