/*
 * Decompiled with CFR 0.152.
 */
package modela.conf;

import gdtel.util.file.CreadorArchivo;
import java.awt.Color;
import java.awt.Font;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;
import modela.conf.History;
import modela.ui.ModelaUI;
import modela.ui.informes.ParametrosInformeGuia;
import modela.util.UtilidadesVarias;

public class ModelaConf {
    private static boolean bCompatibilidadTrewa0 = false;
    private static ParametrosInformeGuia m_ParametrosInfoGuia = new ParametrosInformeGuia();
    private static boolean bSalvarAlSalir = false;
    private static String fichero = "config.properties";
    private static String strRutaAplicacion = "";
    private static String strRutaArchivo;
    private static String strRutaImagen;
    private static String logo_informes;
    private static ArrayList arrHistory;
    private static String sistemaActivo;
    private static String sistemaPorDefecto;
    private static String VALOR_SISTEMA_DEFECTO;
    private static Window ventanaActiva;
    private static boolean bMostrarPostIt;
    private static boolean bMostrarIconoTareaGenerar;
    private static boolean bMostrarIconoTareaIncorporar;
    private static boolean bMostrarIconoTareaManipular;
    private static boolean bMostrarIconoTareaOtros;
    private static boolean bMostrarNumGraficosFase;
    private static boolean bMostrarSombraGraficos;
    private static int nGrosorSombras;
    private static Font fuenteGrFase;
    private static Font fuenteMetafase;
    public static final String ATRIBUTO_MOSTRAR_PERFILES_EXISTENTES = "Existan perfiles";
    public static final String ATRIBUTO_MOSTRAR_PERFILES_INEXISTENTES = "No existan perfiles";
    public static final String ATRIBUTO_MOSTRAR_PERFILES_SIEMPRE = "Ambos casos";
    private static boolean bMostrarIconoAvisoPerfiles;
    private static String strAtributoMostrarPerfiles;
    private static boolean bMostrarIconoCondiciones;
    private static boolean bMostrarIconoAvisos;
    private static boolean bMostrarIconoAcciones;
    private static boolean bMostrarOcurrenciasTransicion;
    public static final String ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO = "";
    public static final String ATRIBUTO_TRANSICION_ADICIONAL_DESCRIPCION = "Descripci\u00f3n";
    public static final String ATRIBUTO_TRANSICION_ADICIONAL_DESCRIPCION_FECHA = "Descripci\u00f3n fecha";
    public static final String ATRIBUTO_TRANSICION_ADICIONAL_ETIQUETA_LARGA = "Etiqueta larga";
    private static boolean bMostrarInfoAuxTransicion;
    private static String strAtributoAdicionalTransicion;
    private static boolean bMostrarNodosClasicos;
    private static Font fuenteGrTransi;
    private static Color colorFondoCanvas;
    private static boolean bMostrarAvisoTransiNoPintadas;
    private static Font fuentePostIt;
    private static boolean bMostrarToolTipConClic;
    private static Color colorFondoToolTip;
    private static Color colorTextoToolTip;
    private static Font fuenteToolTip;
    private static boolean bMostrarToolTip;
    private static int nItemsPorPagina;
    public static final String ATRIBUTO_ENCONDING_UTF8 = "UTF-8";
    public static final String ATRIBUTO_ENCONDING_ISO88591 = "ISO-8859-1";
    public static final String ATRIBUTO_ENCONDING_ASCII = "US-ASCII";
    public static final String ATRIBUTO_ENCONDING_UTF16BE = "UTF-16BE";
    public static final String ATRIBUTO_ENCONDING_UTF16LE = "UTF-16LE";
    public static final String ATRIBUTO_ENCONDING_UTF16 = "UTF-16";
    private static boolean bMarcarReutilizablesComoEditables;
    private static boolean bPedirConfirmacionAlSalir;
    private static boolean bPedirGuardarAlSalir;
    private static String strMarcaVariables;
    private static boolean bLimpiarVariables;
    private static String strEncoding;
    public static String PROP_RUTARCHIVOS;
    public static String PROP_RUTAIMAGENES;
    private static String PROP_HISTORICO1;
    private static String PROP_HISTORICO2;
    private static String PROP_HISTORICO3;
    private static String PROP_HISTORICO4;
    private static String PROP_MOSTRAR_ICONOS_AVISO_PERFILES;
    private static String PROP_ATRIBUTO_MOSTRAR_PERFILES;
    private static String PROP_MOSTRAR_ICONOS_ACCIONES;
    private static String PROP_MOSTRAR_ICONOS_CONDICIONES;
    private static String PROP_MOSTRAR_ICONOS_AVISOS;
    private static String PROP_MOSTRAR_ICONOS_TAREAS_GEN;
    private static String PROP_MOSTRAR_ICONOS_TAREAS_INC;
    private static String PROP_MOSTRAR_ICONOS_TAREAS_BLQ;
    private static String PROP_MOSTRAR_ICONOS_TAREAS_OTR;
    private static String PROP_MOSTRAR_INFOAUX_TRANSICION;
    private static String PROP_ATRIBUTO_INFOAUX_TRANSICION;
    private static String PROP_MOSTRAR_MAX_OCURRENCIAS_TRANSICION;
    private static String PROP_MOSTRAR_NUM_GRAF_FASE;
    private static String PROP_MOSTRAR_SOMBRA_GRAF;
    private static String PROP_GROSOR_SOMBRA;
    private static String PROP_COLOR_FONDO_CANVAS;
    private static String PROP_MOSTRAR_POST_IT;
    private static String PROP_MOSTRAR_TOOL_TIP_CON_CLIP;
    private static String PROP_MOSTRAR_TOOL_TIP;
    private static String PROP_COLOR_FONDO_TOOL_TIP;
    private static String PROP_COLOR_TEXTO_TOOL_TIP;
    private static String PROP_MOSTRAR_NODOS_CLASICOS;
    private static String PROP_FUENTE_POST_IT;
    private static String PROP_FUENTE_GR_FASE;
    private static String PROP_FUENTE_METAFASE;
    private static String PROP_FUENTE_GR_TRANSI;
    private static String PROP_FUENTE_TOOL_TIP;
    public static String PROP_SISTEMA_DEFECTO;
    public static String PROP_LOGO_INFORMES;
    private static String PROP_MARCAR_REUTILIZABLES_EDITABLES;
    private static String PROP_MOSTRAR_AVISO_TRANSI_NO_PINTADAS;
    private static String PROP_PEDIR_CONFIRMACION_AL_SALIR;
    private static String PROP_PEDIR_GUARDAR_AL_SALIR;
    private static String PROP_MARCA_VARIABLES;
    private static String PROP_LIMPIAR_LISTA_VARIABLES;
    private static String PROP_ENCODING;
    private static String PROP_ITEMS_PAGINA_GRAFICAS;
    private static boolean bCreacionRapidaTransiciones;

    public static boolean isCompatibleTrewa0() {
        return bCompatibilidadTrewa0;
    }

    public static void setCompatibleTrewa0(boolean bCompatible) {
        bCompatibilidadTrewa0 = bCompatible;
    }

    public static boolean isCreacionRapidaTransiciones() {
        return bCreacionRapidaTransiciones;
    }

    public static void setCreacionRapidaTransiciones(boolean bValor) {
        bCreacionRapidaTransiciones = bValor;
    }

    public static void setRutaAplicacion(String sNuevaRuta) {
        strRutaAplicacion = sNuevaRuta;
    }

    public static String getRutaAplicacion() {
        return strRutaAplicacion;
    }

    public static String getRutaArchivo() {
        return strRutaArchivo;
    }

    public static void setRutaArchivo(String strRutaArchivoNuevo) {
        strRutaArchivo = strRutaArchivoNuevo;
    }

    public static String getRutaImagen() {
        return strRutaImagen;
    }

    public static void setRutaImagen(String strRutaImagenNueva) {
        strRutaImagen = strRutaImagenNueva;
    }

    public static ArrayList getArrayHistorico() {
        return arrHistory;
    }

    public static void setArrayHistorico(ArrayList arrAux) {
        arrHistory = arrAux;
    }

    public static void addHistory(History history) {
        boolean bEsta = false;
        for (int i = 0; i < arrHistory.size() && !bEsta; ++i) {
            History aux = (History)arrHistory.get(i);
            if (!aux.equals(history)) continue;
            bEsta = true;
        }
        if (!bEsta) {
            arrHistory.add(0, history);
            if (arrHistory.size() > 4) {
                arrHistory.remove(4);
            }
        }
    }

    private static void cargaArrayHistorico(Properties p) {
        char c2 = '/';
        char c1 = '\\';
        String h1 = p.getProperty(PROP_HISTORICO1);
        String h2 = p.getProperty(PROP_HISTORICO2);
        String h3 = p.getProperty(PROP_HISTORICO3);
        String h4 = p.getProperty(PROP_HISTORICO4);
        if (h1 != null && !h1.equals(ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO)) {
            String h11 = h1.replace(c1, c2);
            History histuno = new History();
            histuno.setRuta(h11);
            arrHistory.add(histuno);
        }
        if (h2 != null && !h2.equals(ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO)) {
            String h22 = h2.replace(c1, c2);
            History histdos = new History();
            histdos.setRuta(h22);
            arrHistory.add(histdos);
        }
        if (h3 != null && !h3.equals(ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO)) {
            String h33 = h3.replace(c1, c2);
            History histres = new History();
            histres.setRuta(h33);
            arrHistory.add(histres);
        }
        if (h4 != null && !h4.equals(ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO)) {
            String h44 = h4.replace(c1, c2);
            History histcuatro = new History();
            histcuatro.setRuta(h44);
            arrHistory.add(histcuatro);
        }
    }

    private static boolean writeHistory(CreadorArchivo crear) {
        boolean bRet = false;
        if (arrHistory.size() == 0) {
            bRet = crear.escribir(PROP_HISTORICO1 + "=" + ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO);
            bRet = crear.escribir(PROP_HISTORICO2 + "=" + ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO);
            bRet = crear.escribir(PROP_HISTORICO3 + "=" + ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO);
            bRet = crear.escribir(PROP_HISTORICO4 + "=" + ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO);
            return bRet;
        }
        for (int i = 0; i < arrHistory.size(); ++i) {
            History aux = (History)arrHistory.get(i);
            if (aux.getRuta().equals(ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO)) continue;
            if (i == 0) {
                bRet = crear.escribir(PROP_HISTORICO1 + "=" + aux.getRuta());
                if (i + 1 == arrHistory.size()) {
                    bRet = crear.escribir(PROP_HISTORICO2 + "=" + ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO);
                    bRet = crear.escribir(PROP_HISTORICO3 + "=" + ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO);
                    bRet = crear.escribir(PROP_HISTORICO4 + "=" + ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO);
                }
            }
            if (i == 1) {
                bRet = crear.escribir(PROP_HISTORICO2 + "=" + aux.getRuta());
                if (i + 1 == arrHistory.size()) {
                    bRet = crear.escribir(PROP_HISTORICO3 + "=" + ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO);
                    bRet = crear.escribir(PROP_HISTORICO4 + "=" + ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO);
                }
            }
            if (i == 2) {
                bRet = crear.escribir(PROP_HISTORICO3 + "=" + aux.getRuta());
                if (i + 1 == arrHistory.size()) {
                    bRet = crear.escribir(PROP_HISTORICO4 + "=" + ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO);
                }
            }
            if (i != 3) continue;
            bRet = crear.escribir(PROP_HISTORICO4 + "=" + aux.getRuta());
        }
        return bRet;
    }

    public static boolean getmostrarNumeroGraficosAsociados() {
        return bMostrarNumGraficosFase;
    }

    public static void mostrarNumeroGraficosAsociados(boolean bMostrar) {
        bMostrarNumGraficosFase = bMostrar;
    }

    public static boolean getMostrarSombraGraficos() {
        return bMostrarSombraGraficos;
    }

    public static void mostrarSombraGraficos(boolean bMostrar) {
        bMostrarSombraGraficos = bMostrar;
    }

    public static int getGrosorSombraGraficos() {
        return nGrosorSombras;
    }

    public static void setGrosorSombraGraficos(int nGrosor) {
        nGrosorSombras = nGrosor;
    }

    public static boolean getMostrarIconoTareaGenerar() {
        return bMostrarIconoTareaGenerar;
    }

    public static void mostrarIconoTareaGenerar(boolean bMostrar) {
        bMostrarIconoTareaGenerar = bMostrar;
    }

    public static boolean getMostrarIconoTareaIncorporar() {
        return bMostrarIconoTareaIncorporar;
    }

    public static void mostrarIconoTareaIncorporar(boolean bMostrar) {
        bMostrarIconoTareaIncorporar = bMostrar;
    }

    public static boolean getMostrarIconoTareaManipular() {
        return bMostrarIconoTareaManipular;
    }

    public static void mostrarIconoTareaManipular(boolean bMostrar) {
        bMostrarIconoTareaManipular = bMostrar;
    }

    public static boolean getMostrarIconoTareaOtros() {
        return bMostrarIconoTareaOtros;
    }

    public static void mostrarIconoTareaOtros(boolean bMostrar) {
        bMostrarIconoTareaOtros = bMostrar;
    }

    public static String getMarcaVariables() {
        return strMarcaVariables;
    }

    public static void setMarcaVariables(String strMarca) {
        strMarcaVariables = strMarca;
    }

    public static boolean getMostrarIconoAvisoPerfiles() {
        return bMostrarIconoAvisoPerfiles;
    }

    public static void mostrarIconoAvisoPerfiles(boolean bMostrar) {
        bMostrarIconoAvisoPerfiles = bMostrar;
    }

    public static String getAtributoMostrarPerfiles() {
        return strAtributoMostrarPerfiles;
    }

    public static void setAtributoMostrarPerfiles(String strAtributo) {
        strAtributoMostrarPerfiles = strAtributo;
    }

    public static boolean getMostrarIconoAcciones() {
        return bMostrarIconoAcciones;
    }

    public static void mostrarIconoAcciones(boolean bMostrar) {
        bMostrarIconoAcciones = bMostrar;
    }

    public static boolean getMostrarIconoCondiciones() {
        return bMostrarIconoCondiciones;
    }

    public static void mostrarIconoCondiciones(boolean bMostrar) {
        bMostrarIconoCondiciones = bMostrar;
    }

    public static boolean getMostrarIconoAvisos() {
        return bMostrarIconoAvisos;
    }

    public static void mostrarIconoAvisos(boolean bMostrar) {
        bMostrarIconoAvisos = bMostrar;
    }

    public static boolean getMostrarInfoAuxiliarTransicion() {
        return bMostrarInfoAuxTransicion;
    }

    public static void mostrarInfoAuxiliarTransicion(boolean bMostrar) {
        bMostrarInfoAuxTransicion = bMostrar;
    }

    public static boolean getMostrarOcurrenciasTransicion() {
        return bMostrarOcurrenciasTransicion;
    }

    public static void mostrarOcurrenciasTransicion(boolean bMostrar) {
        bMostrarOcurrenciasTransicion = bMostrar;
    }

    public static String getAtributoAuxTransicion() {
        return strAtributoAdicionalTransicion;
    }

    public static void setAtributoAuxTransicion(String strAtributo) {
        strAtributoAdicionalTransicion = strAtributo;
    }

    public static void mostrarNodosClasicos(boolean bMostrar) {
        bMostrarNodosClasicos = bMostrar;
    }

    public static boolean getMostrarNodosClasicos() {
        return bMostrarNodosClasicos;
    }

    public static void setColorFondoCanvas(Color clrColor) {
        colorFondoCanvas = clrColor;
    }

    public static Color getColorFondoCanvas() {
        if (colorFondoCanvas == null) {
            return Color.white;
        }
        return colorFondoCanvas;
    }

    public static void mostrarToolTipConClic(boolean bMostrar) {
        bMostrarToolTipConClic = bMostrar;
    }

    public static boolean getMostrarToolTipConClic() {
        return bMostrarToolTipConClic;
    }

    public static void mostrarToolTip(boolean bMostrar) {
        bMostrarToolTip = bMostrar;
    }

    public static boolean getMostrarToolTip() {
        return bMostrarToolTip;
    }

    public static void setColorFondoToolTip(Color clrColor) {
        colorFondoToolTip = clrColor;
    }

    public static Color getColorFondoToolTip() {
        if (colorFondoToolTip == null) {
            return ModelaUI.colorDefaultFondoToolTip;
        }
        return colorFondoToolTip;
    }

    public static void setColorTextoToolTip(Color clrColor) {
        colorTextoToolTip = clrColor;
    }

    public static Color getColorTextoToolTip() {
        if (colorTextoToolTip == null) {
            return ModelaUI.colorDefaultTextoToolTip;
        }
        return colorTextoToolTip;
    }

    public static void mostrarPostIt(boolean bMostrar) {
        bMostrarPostIt = bMostrar;
    }

    public static boolean getMostrarPostIt() {
        return bMostrarPostIt;
    }

    public static void setFuentePostIt(Font fuente) {
        fuentePostIt = fuente;
    }

    public static Font getFuentePostIt() {
        return fuentePostIt;
    }

    public static void setFuenteToolTip(Font fuente) {
        fuenteToolTip = fuente;
    }

    public static Font getFuenteToolTip() {
        return fuenteToolTip;
    }

    public static void setFuenteGrFase(Font fuente) {
        fuenteGrFase = fuente;
    }

    public static Font getFuenteGrFase() {
        return fuenteGrFase;
    }

    public static void setFuenteMetafase(Font fuente) {
        fuenteMetafase = fuente;
    }

    public static Font getFuenteMetafase() {
        return fuenteMetafase;
    }

    public static void setFuenteGrTransi(Font fuente) {
        fuenteGrTransi = fuente;
    }

    public static Font getFuenteGrTransi() {
        return fuenteGrTransi;
    }

    public static String getSistemaActivo() {
        return sistemaActivo;
    }

    public static void setSistemaActivo(String nuevoSistema, boolean bDefecto) {
        sistemaActivo = nuevoSistema;
        if (bDefecto) {
            ModelaConf.setSistemaPorDefecto(sistemaActivo);
        }
    }

    public static void setSistemaPorDefecto(String nuevoSistemaPorDefecto) {
        sistemaPorDefecto = nuevoSistemaPorDefecto;
    }

    public static String getSistemaPorDefecto() {
        return sistemaPorDefecto;
    }

    public static void setLogoInformes(String strLogo) {
        logo_informes = strLogo;
    }

    public static String getLogoInforme() {
        File logoExisteTmp;
        if (logo_informes == null) {
            logo_informes = ModelaUI.IMG_LOGO_JUSTICIA;
        }
        if (!logo_informes.equals(ModelaUI.IMG_LOGO_JUSTICIA) && !(logoExisteTmp = new File(logo_informes)).exists()) {
            System.out.println("- [ Error ] No se ha podido localizar el logo de informes: " + logo_informes);
            System.out.println("- Se utilizar\u00e1 el logo de informes por defecto");
            logo_informes = ModelaUI.IMG_LOGO_JUSTICIA;
        }
        return logo_informes;
    }

    public static boolean getMarcarReutilizablesComoEditables() {
        return bMarcarReutilizablesComoEditables;
    }

    public static void marcarReutilizablesComoEditables(boolean bMostrar) {
        bMarcarReutilizablesComoEditables = bMostrar;
    }

    public static void mostrarAvisoTransiNoPintadas(boolean bMostrar) {
        bMostrarAvisoTransiNoPintadas = bMostrar;
    }

    public static boolean getMostrarAvisoTransiNoPintadas() {
        return bMostrarAvisoTransiNoPintadas;
    }

    public static boolean getLimpiarListaVariables() {
        return bLimpiarVariables;
    }

    public static void limpiarListaVariables(boolean bLimpiar) {
        bLimpiarVariables = bLimpiar;
    }

    public static void pedirConfirmacionAlSalir(boolean bPedir) {
        bPedirConfirmacionAlSalir = bPedir;
    }

    public static boolean getPedirConfirmacionAlSalir() {
        return bPedirConfirmacionAlSalir;
    }

    public static void pedirGuardarAlSalir(boolean bPedir) {
        bPedirGuardarAlSalir = bPedir;
    }

    public static boolean getPedirGuardarAlSalir() {
        return bPedirGuardarAlSalir;
    }

    public static int getItemsPorPagina() {
        return nItemsPorPagina;
    }

    public static void setItemsPorPagina(int nItem) {
        nItemsPorPagina = nItem;
    }

    public static void setVentanaActiva(Window nuevaVentanaActiva) {
        ventanaActiva = nuevaVentanaActiva;
    }

    public static void mostrarVentanaActiva() {
        try {
            if (ventanaActiva == null) {
                return;
            }
            if (!ventanaActiva.isShowing()) {
                ventanaActiva = null;
                return;
            }
            ventanaActiva.toFront();
        }
        catch (Exception ex) {
            ventanaActiva = null;
        }
    }

    public static ParametrosInformeGuia getParametrosInformeGuia() {
        return m_ParametrosInfoGuia;
    }

    public static boolean getSalvarAlSalir() {
        return bSalvarAlSalir;
    }

    public static void setSalvarAlSalir(boolean pValor) {
        bSalvarAlSalir = pValor;
    }

    public static String getEncoding() {
        return strEncoding;
    }

    public static void setEncoding(String valorEncoding) {
        strEncoding = valorEncoding;
    }

    public static boolean cargar() {
        System.out.println("- [ Info ] Cargando configuraci\u00f3n almacenada en el properties...");
        arrHistory = new ArrayList();
        char c1 = '\\';
        char c2 = '/';
        try {
            String strAppWorkingDir = System.getProperty("user.dir");
            if (strAppWorkingDir != null) {
                ModelaConf.setRutaAplicacion(strAppWorkingDir);
            }
            if (fichero == null || !new File(fichero).exists()) {
                System.out.println("- No existe el fichero de propiedades. Se genera uno con valores por defecto");
                strRutaArchivo = System.getProperty("user.dir");
                strRutaImagen = System.getProperty("user.dir");
                ModelaConf.salvar();
            }
            Properties prop = new Properties();
            prop.load(new FileInputStream(new File(fichero)));
            String s1 = prop.getProperty(PROP_RUTARCHIVOS);
            String s2 = prop.getProperty(PROP_RUTAIMAGENES);
            if (s1 == null || s1.equals(ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO)) {
                s1 = System.getProperty("user.dir");
            }
            if (s2 == null || s2.equals(ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO)) {
                s2 = System.getProperty("user.dir");
            }
            ModelaConf.cargaArrayHistorico(prop);
            String strRuta = s1.replace(c1, c2);
            String strImagen = s2.replace(c1, c2);
            ModelaConf.setRutaArchivo(strRuta);
            ModelaConf.setRutaImagen(strImagen);
            String sSistema = prop.getProperty(PROP_SISTEMA_DEFECTO);
            if (sSistema == null || sSistema.equals(ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO)) {
                ModelaConf.setSistemaPorDefecto(VALOR_SISTEMA_DEFECTO);
            } else {
                ModelaConf.setSistemaPorDefecto(sSistema);
            }
            logo_informes = ModelaUI.IMG_LOGO_JUSTICIA;
            String strTmpLogo = prop.getProperty(PROP_LOGO_INFORMES);
            if (strTmpLogo != null && !strTmpLogo.equals(ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO)) {
                logo_informes = strTmpLogo;
            }
            bMostrarIconoAvisoPerfiles = UtilidadesVarias.interpretaString2Boolean(prop.getProperty(PROP_MOSTRAR_ICONOS_AVISO_PERFILES), "true", "false", true);
            strAtributoMostrarPerfiles = prop.getProperty(PROP_ATRIBUTO_MOSTRAR_PERFILES);
            bMostrarIconoAcciones = UtilidadesVarias.interpretaString2Boolean(prop.getProperty(PROP_MOSTRAR_ICONOS_ACCIONES), "true", "false", true);
            bMostrarIconoCondiciones = UtilidadesVarias.interpretaString2Boolean(prop.getProperty(PROP_MOSTRAR_ICONOS_CONDICIONES), "true", "false", true);
            bMostrarIconoAvisos = UtilidadesVarias.interpretaString2Boolean(prop.getProperty(PROP_MOSTRAR_ICONOS_AVISOS), "true", "false", true);
            bMostrarIconoTareaGenerar = UtilidadesVarias.interpretaString2Boolean(prop.getProperty(PROP_MOSTRAR_ICONOS_TAREAS_GEN), "true", "false", true);
            bMostrarIconoTareaIncorporar = UtilidadesVarias.interpretaString2Boolean(prop.getProperty(PROP_MOSTRAR_ICONOS_TAREAS_INC), "true", "false", true);
            bMostrarIconoTareaManipular = UtilidadesVarias.interpretaString2Boolean(prop.getProperty(PROP_MOSTRAR_ICONOS_TAREAS_BLQ), "true", "false", true);
            bMostrarIconoTareaOtros = UtilidadesVarias.interpretaString2Boolean(prop.getProperty(PROP_MOSTRAR_ICONOS_TAREAS_OTR), "true", "false", true);
            bMostrarInfoAuxTransicion = UtilidadesVarias.interpretaString2Boolean(prop.getProperty(PROP_MOSTRAR_INFOAUX_TRANSICION), "true", "false", false);
            strAtributoAdicionalTransicion = prop.getProperty(PROP_ATRIBUTO_INFOAUX_TRANSICION);
            bMostrarOcurrenciasTransicion = UtilidadesVarias.interpretaString2Boolean(prop.getProperty(PROP_MOSTRAR_MAX_OCURRENCIAS_TRANSICION), "true", "false", true);
            bMostrarNumGraficosFase = UtilidadesVarias.interpretaString2Boolean(prop.getProperty(PROP_MOSTRAR_NUM_GRAF_FASE), "true", "false", true);
            bMostrarSombraGraficos = UtilidadesVarias.interpretaString2Boolean(prop.getProperty(PROP_MOSTRAR_SOMBRA_GRAF), "true", "false", false);
            nGrosorSombras = prop.getProperty(PROP_GROSOR_SOMBRA) != null && !prop.getProperty(PROP_GROSOR_SOMBRA).equals(ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO) ? Integer.parseInt(prop.getProperty(PROP_GROSOR_SOMBRA)) : 5;
            if (prop.getProperty(PROP_COLOR_FONDO_CANVAS) != null && !prop.getProperty(PROP_COLOR_FONDO_CANVAS).equals(ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO)) {
                colorFondoCanvas = new Color(Integer.parseInt(prop.getProperty(PROP_COLOR_FONDO_CANVAS)));
            }
            bMostrarNodosClasicos = UtilidadesVarias.interpretaString2Boolean(prop.getProperty(PROP_MOSTRAR_NODOS_CLASICOS), "true", "false", false);
            fuentePostIt = UtilidadesVarias.obtenerFuente(prop.getProperty(PROP_FUENTE_POST_IT), ModelaUI.fuenteDefaultPostIt);
            fuenteToolTip = UtilidadesVarias.obtenerFuente(prop.getProperty(PROP_FUENTE_TOOL_TIP), ModelaUI.fuenteDefaultPostIt);
            fuenteGrFase = UtilidadesVarias.obtenerFuente(prop.getProperty(PROP_FUENTE_GR_FASE), ModelaUI.fuenteDefaultGrFase);
            fuenteMetafase = UtilidadesVarias.obtenerFuente(prop.getProperty(PROP_FUENTE_METAFASE), ModelaUI.fuenteDefaultMetafase);
            fuenteGrTransi = UtilidadesVarias.obtenerFuente(prop.getProperty(PROP_FUENTE_GR_TRANSI), ModelaUI.fuenteDefaultGrTransi);
            bMarcarReutilizablesComoEditables = UtilidadesVarias.interpretaString2Boolean(prop.getProperty(PROP_MARCAR_REUTILIZABLES_EDITABLES), "true", "false", false);
            bPedirConfirmacionAlSalir = UtilidadesVarias.interpretaString2Boolean(prop.getProperty(PROP_PEDIR_CONFIRMACION_AL_SALIR), "true", "false", true);
            bPedirGuardarAlSalir = UtilidadesVarias.interpretaString2Boolean(prop.getProperty(PROP_PEDIR_GUARDAR_AL_SALIR), "true", "false", true);
            strMarcaVariables = prop.getProperty(PROP_MARCA_VARIABLES);
            if (strMarcaVariables == null || strMarcaVariables.equals(ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO)) {
                strMarcaVariables = "$$";
            }
            bLimpiarVariables = UtilidadesVarias.interpretaString2Boolean(prop.getProperty(PROP_LIMPIAR_LISTA_VARIABLES), "true", "false", true);
            nItemsPorPagina = prop.getProperty(PROP_ITEMS_PAGINA_GRAFICAS) != null && !prop.getProperty(PROP_ITEMS_PAGINA_GRAFICAS).equals(ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO) ? Integer.parseInt(prop.getProperty(PROP_ITEMS_PAGINA_GRAFICAS)) : 5;
            strEncoding = prop.getProperty(PROP_ENCODING);
            bMostrarAvisoTransiNoPintadas = UtilidadesVarias.interpretaString2Boolean(prop.getProperty(PROP_MOSTRAR_AVISO_TRANSI_NO_PINTADAS), "true", "false", true);
            bMostrarPostIt = UtilidadesVarias.interpretaString2Boolean(prop.getProperty(PROP_MOSTRAR_POST_IT), "true", "false", true);
            bMostrarToolTip = UtilidadesVarias.interpretaString2Boolean(prop.getProperty(PROP_MOSTRAR_TOOL_TIP), "true", "false", true);
            bMostrarToolTipConClic = UtilidadesVarias.interpretaString2Boolean(prop.getProperty(PROP_MOSTRAR_TOOL_TIP_CON_CLIP), "true", "false", false);
            if (prop.getProperty(PROP_COLOR_FONDO_TOOL_TIP) != null && !prop.getProperty(PROP_COLOR_FONDO_TOOL_TIP).equals(ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO)) {
                colorFondoToolTip = new Color(Integer.parseInt(prop.getProperty(PROP_COLOR_FONDO_TOOL_TIP)));
            }
            if (prop.getProperty(PROP_COLOR_TEXTO_TOOL_TIP) != null && !prop.getProperty(PROP_COLOR_TEXTO_TOOL_TIP).equals(ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO)) {
                colorTextoToolTip = new Color(Integer.parseInt(prop.getProperty(PROP_COLOR_TEXTO_TOOL_TIP)));
            }
            System.out.println("- Configuraci\u00f3n cargada con \u00e9xito.");
        }
        catch (Exception e) {
            System.out.println("- [ Error ] Cargando configuraci\u00f3n en " + fichero + ":\n");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean salvar() {
        System.out.println("- [ Info ] Salvando configuraci\u00f3n en el properties...");
        char c1 = '\\';
        char c2 = '/';
        try {
            CreadorArchivo crear = new CreadorArchivo();
            crear.crearArchivoSalida(fichero, ATRIBUTO_ENCONDING_ISO88591);
            crear.escribir("#Archivo de configuracion de model@");
            String s1 = ModelaConf.getRutaArchivo();
            String s2 = ModelaConf.getRutaImagen();
            String strRuta = s1.replace(c1, c2);
            String strImagen = s2.replace(c1, c2);
            crear.escribir("# - - - Rutas - - - - - - - - - - - - - - - - - ");
            crear.escribir(PROP_RUTARCHIVOS + "=" + strRuta);
            crear.escribir(PROP_RUTAIMAGENES + "=" + strImagen);
            crear.escribir("# - - - Hist\u00f3rico - - - - - - - - - - - - - - - ");
            ModelaConf.writeHistory(crear);
            crear.escribir("# - - - Propiedades Gr\u00e1fico - - - - - - - - - - ");
            crear.escribir(PROP_MOSTRAR_ICONOS_AVISO_PERFILES + "=" + ModelaConf.getMostrarIconoAvisoPerfiles());
            crear.escribir(PROP_ATRIBUTO_MOSTRAR_PERFILES + "=" + ModelaConf.getAtributoMostrarPerfiles());
            crear.escribir(PROP_MOSTRAR_ICONOS_ACCIONES + "=" + ModelaConf.getMostrarIconoAcciones());
            crear.escribir(PROP_MOSTRAR_ICONOS_CONDICIONES + "=" + ModelaConf.getMostrarIconoCondiciones());
            crear.escribir(PROP_MOSTRAR_ICONOS_AVISOS + "=" + ModelaConf.getMostrarIconoAvisos());
            crear.escribir(PROP_MOSTRAR_ICONOS_TAREAS_GEN + "=" + ModelaConf.getMostrarIconoTareaGenerar());
            crear.escribir(PROP_MOSTRAR_ICONOS_TAREAS_INC + "=" + ModelaConf.getMostrarIconoTareaIncorporar());
            crear.escribir(PROP_MOSTRAR_ICONOS_TAREAS_BLQ + "=" + ModelaConf.getMostrarIconoTareaManipular());
            crear.escribir(PROP_MOSTRAR_ICONOS_TAREAS_OTR + "=" + ModelaConf.getMostrarIconoTareaOtros());
            crear.escribir(PROP_MOSTRAR_INFOAUX_TRANSICION + "=" + ModelaConf.getMostrarInfoAuxiliarTransicion());
            crear.escribir(PROP_ATRIBUTO_INFOAUX_TRANSICION + "=" + ModelaConf.getAtributoAuxTransicion());
            crear.escribir(PROP_MOSTRAR_MAX_OCURRENCIAS_TRANSICION + "=" + ModelaConf.getMostrarOcurrenciasTransicion());
            crear.escribir(PROP_MOSTRAR_NUM_GRAF_FASE + "=" + ModelaConf.getmostrarNumeroGraficosAsociados());
            crear.escribir(PROP_MOSTRAR_SOMBRA_GRAF + "=" + ModelaConf.getMostrarSombraGraficos());
            crear.escribir(PROP_GROSOR_SOMBRA + "=" + String.valueOf(ModelaConf.getGrosorSombraGraficos()));
            crear.escribir(PROP_COLOR_FONDO_CANVAS + "=" + ModelaConf.getColorFondoCanvas().getRGB());
            crear.escribir(PROP_MOSTRAR_NODOS_CLASICOS + "=" + ModelaConf.getMostrarNodosClasicos());
            crear.escribir(PROP_MOSTRAR_POST_IT + "=" + ModelaConf.getMostrarPostIt());
            crear.escribir(PROP_MOSTRAR_TOOL_TIP + "=" + ModelaConf.getMostrarToolTip());
            crear.escribir(PROP_MOSTRAR_TOOL_TIP_CON_CLIP + "=" + ModelaConf.getMostrarToolTipConClic());
            crear.escribir(PROP_COLOR_FONDO_TOOL_TIP + "=" + ModelaConf.getColorFondoToolTip().getRGB());
            crear.escribir(PROP_COLOR_TEXTO_TOOL_TIP + "=" + ModelaConf.getColorTextoToolTip().getRGB());
            crear.escribir(PROP_FUENTE_TOOL_TIP + "=" + UtilidadesVarias.escribirFuente(ModelaConf.getFuenteToolTip()));
            crear.escribir(PROP_FUENTE_POST_IT + "=" + UtilidadesVarias.escribirFuente(ModelaConf.getFuentePostIt()));
            crear.escribir(PROP_FUENTE_GR_FASE + "=" + UtilidadesVarias.escribirFuente(ModelaConf.getFuenteGrFase()));
            crear.escribir(PROP_FUENTE_METAFASE + "=" + UtilidadesVarias.escribirFuente(ModelaConf.getFuenteMetafase()));
            crear.escribir(PROP_FUENTE_GR_TRANSI + "=" + UtilidadesVarias.escribirFuente(ModelaConf.getFuenteGrTransi()));
            crear.escribir("# - - - Otros - - - - - - - - - - - - - - - - - ");
            crear.escribir(PROP_SISTEMA_DEFECTO + "=" + sistemaPorDefecto);
            crear.escribir(PROP_LOGO_INFORMES + "=" + ModelaConf.getLogoInforme());
            crear.escribir(PROP_MARCAR_REUTILIZABLES_EDITABLES + "=" + ModelaConf.getMarcarReutilizablesComoEditables());
            crear.escribir(PROP_MOSTRAR_AVISO_TRANSI_NO_PINTADAS + "=" + ModelaConf.getMostrarAvisoTransiNoPintadas());
            crear.escribir(PROP_PEDIR_CONFIRMACION_AL_SALIR + "=" + ModelaConf.getPedirConfirmacionAlSalir());
            crear.escribir(PROP_PEDIR_GUARDAR_AL_SALIR + "=" + ModelaConf.getPedirGuardarAlSalir());
            crear.escribir(PROP_MARCA_VARIABLES + "=" + ModelaConf.getMarcaVariables());
            crear.escribir(PROP_LIMPIAR_LISTA_VARIABLES + "=" + ModelaConf.getLimpiarListaVariables());
            crear.escribir(PROP_ENCODING + "=" + ModelaConf.getEncoding());
            crear.escribir("# - - - Modo Gr\u00e1ficas - - - - - - - - - - - - - ");
            crear.escribir(PROP_ITEMS_PAGINA_GRAFICAS + "=" + String.valueOf(ModelaConf.getItemsPorPagina()));
            crear.cerrarArchivoSalida();
            System.out.println("- Configuraci\u00f3n salvada con \u00e9xito.");
        }
        catch (Exception e) {
            System.out.println("- [ Error ] Salvando configuraci\u00f3n en " + fichero + " :\n");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String obtenerVersion() {
        String strVersion = new String();
        try {
            ResourceBundle bun = ResourceBundle.getBundle("version");
            strVersion = bun.getString("Version");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strVersion;
    }

    public static String obtenerTitulo() {
        String strTitulo = new String();
        try {
            ResourceBundle bun = ResourceBundle.getBundle("version");
            strTitulo = bun.getString("TituloVentana");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strTitulo;
    }

    public static String obtenerFecha() {
        String strFecha = new String();
        try {
            ResourceBundle bun = ResourceBundle.getBundle("version");
            strFecha = bun.getString("Fecha");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strFecha;
    }

    static {
        sistemaActivo = ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO;
        sistemaPorDefecto = "W@NDA";
        VALOR_SISTEMA_DEFECTO = "NUEVO_SISTEMA";
        ventanaActiva = null;
        bMostrarPostIt = true;
        bMostrarIconoTareaGenerar = true;
        bMostrarIconoTareaIncorporar = true;
        bMostrarIconoTareaManipular = true;
        bMostrarIconoTareaOtros = true;
        bMostrarNumGraficosFase = true;
        bMostrarSombraGraficos = false;
        nGrosorSombras = 5;
        fuenteGrFase = ModelaUI.fuenteDefaultGrFase;
        fuenteMetafase = ModelaUI.fuenteDefaultMetafase;
        bMostrarIconoAvisoPerfiles = true;
        strAtributoMostrarPerfiles = new String(ATRIBUTO_MOSTRAR_PERFILES_INEXISTENTES);
        bMostrarIconoCondiciones = true;
        bMostrarIconoAvisos = true;
        bMostrarIconoAcciones = true;
        bMostrarOcurrenciasTransicion = true;
        bMostrarInfoAuxTransicion = false;
        strAtributoAdicionalTransicion = new String(ATRIBUTO_TRANSICION_ADICIONAL_NINGUNO);
        bMostrarNodosClasicos = false;
        fuenteGrTransi = ModelaUI.fuenteDefaultGrTransi;
        colorFondoCanvas = Color.white;
        bMostrarAvisoTransiNoPintadas = true;
        fuentePostIt = ModelaUI.fuenteDefaultPostIt;
        bMostrarToolTipConClic = false;
        colorFondoToolTip = ModelaUI.colorDefaultFondoToolTip;
        colorTextoToolTip = ModelaUI.colorDefaultTextoToolTip;
        fuenteToolTip = ModelaUI.fuenteDefaultToolTip;
        bMostrarToolTip = true;
        nItemsPorPagina = 4;
        bMarcarReutilizablesComoEditables = false;
        bPedirConfirmacionAlSalir = true;
        bPedirGuardarAlSalir = true;
        strMarcaVariables = new String("$$");
        bLimpiarVariables = true;
        strEncoding = new String(ATRIBUTO_ENCONDING_UTF8);
        PROP_RUTARCHIVOS = "RutaArchivos";
        PROP_RUTAIMAGENES = "RutaImagenes";
        PROP_HISTORICO1 = "Historico1";
        PROP_HISTORICO2 = "Historico2";
        PROP_HISTORICO3 = "Historico3";
        PROP_HISTORICO4 = "Historico4";
        PROP_MOSTRAR_ICONOS_AVISO_PERFILES = "MostrarIconosAvisoPerfiles";
        PROP_ATRIBUTO_MOSTRAR_PERFILES = "AtributoMostrarPerfiles";
        PROP_MOSTRAR_ICONOS_ACCIONES = "MostrarIconosAcciones";
        PROP_MOSTRAR_ICONOS_CONDICIONES = "MostrarIconosCondiciones";
        PROP_MOSTRAR_ICONOS_AVISOS = "MostrarIconosAvisos";
        PROP_MOSTRAR_ICONOS_TAREAS_GEN = "MostrarIconosTareasGen";
        PROP_MOSTRAR_ICONOS_TAREAS_INC = "MostrarIconosTareasInc";
        PROP_MOSTRAR_ICONOS_TAREAS_BLQ = "MostrarIconosTareasBlq";
        PROP_MOSTRAR_ICONOS_TAREAS_OTR = "MostrarIconosTareasOtr";
        PROP_MOSTRAR_INFOAUX_TRANSICION = "MostrarInfoAuxTransicion";
        PROP_ATRIBUTO_INFOAUX_TRANSICION = "AtributoInfoAuxTransicion";
        PROP_MOSTRAR_MAX_OCURRENCIAS_TRANSICION = "MostrarMaxOcurrencias";
        PROP_MOSTRAR_NUM_GRAF_FASE = "MostrarNumGraficosFase";
        PROP_MOSTRAR_SOMBRA_GRAF = "MostrarSombraGraficos";
        PROP_GROSOR_SOMBRA = "GrosorSombra";
        PROP_COLOR_FONDO_CANVAS = "ColorFondoCanvas";
        PROP_MOSTRAR_POST_IT = "mostrarPostIt";
        PROP_MOSTRAR_TOOL_TIP_CON_CLIP = "mostrarToolTipConClic";
        PROP_MOSTRAR_TOOL_TIP = "mostrarToolTip";
        PROP_COLOR_FONDO_TOOL_TIP = "ColorFondoToolTip";
        PROP_COLOR_TEXTO_TOOL_TIP = "ColorTextoToolTip";
        PROP_MOSTRAR_NODOS_CLASICOS = "MostrarNodosClasicos";
        PROP_FUENTE_POST_IT = "FuentePostIt";
        PROP_FUENTE_GR_FASE = "FuenteGrFase";
        PROP_FUENTE_METAFASE = "FuenteMetafase";
        PROP_FUENTE_GR_TRANSI = "FuenteGrTransi";
        PROP_FUENTE_TOOL_TIP = "FuenteToolTip";
        PROP_SISTEMA_DEFECTO = "Sistema";
        PROP_LOGO_INFORMES = "LogoInformes";
        PROP_MARCAR_REUTILIZABLES_EDITABLES = "ReutilizablesNoEditables";
        PROP_MOSTRAR_AVISO_TRANSI_NO_PINTADAS = "AvisoTrNoPintadas";
        PROP_PEDIR_CONFIRMACION_AL_SALIR = "ConfirmarAlSalir";
        PROP_PEDIR_GUARDAR_AL_SALIR = "DialogoGuardarAlSalir";
        PROP_MARCA_VARIABLES = "MarcaVariables";
        PROP_LIMPIAR_LISTA_VARIABLES = "LimpiarListaVariables";
        PROP_ENCODING = "Encoding";
        PROP_ITEMS_PAGINA_GRAFICAS = "ItemsPerPagGrafica";
        bCreacionRapidaTransiciones = false;
    }
}

