/*
 * Decompiled with CFR 0.152.
 */
package modela.graf;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.ValidarNombreFichero;
import gdtel.ui.swing.FileFilterEx;
import gdtel.ui.swing.PropiedadesJDialog;
import java.awt.Component;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import modela.bd.ConjuntoDatosModela;
import modela.bd.RepositorioModela;
import modela.bd.obj.ConjuntoDatosAccion;
import modela.bd.obj.ConjuntoDatosAmbitosLey;
import modela.bd.obj.ConjuntoDatosCondicion;
import modela.bd.obj.ConjuntoDatosFase;
import modela.bd.obj.ConjuntoDatosMetafase;
import modela.bd.obj.ConjuntoDatosNormativa;
import modela.bd.obj.ConjuntoDatosOrganismo;
import modela.bd.obj.ConjuntoDatosParametros;
import modela.bd.obj.ConjuntoDatosPerfilUsuario;
import modela.bd.obj.ConjuntoDatosPlantillas;
import modela.bd.obj.ConjuntoDatosTarea;
import modela.bd.obj.ConjuntoDatosTareaEnFase;
import modela.bd.obj.ConjuntoDatosTareaFaseDefProcedimiento;
import modela.bd.obj.ConjuntoDatosTipoActo;
import modela.bd.obj.ConjuntoDatosTiposIndicacion;
import modela.bd.obj.ConjuntoDatosTiposNormativa;
import modela.bd.obj.ConjuntoDatosTiposOrganismo;
import modela.bd.obj.ConjuntoDatosTiposParrafo;
import modela.bd.obj.ConjuntoDatosTiposPublicacion;
import modela.bd.obj.ConjuntoDatosTransicion;
import modela.bd.obj.ConjuntoDatosTransicionDefProcedimiento;
import modela.bd.obj.ConjuntoDatosVariables;
import modela.bd.obj.DefProcGr;
import modela.bd.obj.TrAccion;
import modela.bd.obj.TrAccionTareaFase;
import modela.bd.obj.TrAccionTransicion;
import modela.bd.obj.TrAmbitoLey;
import modela.bd.obj.TrAviso;
import modela.bd.obj.TrAvisoTareaFase;
import modela.bd.obj.TrAvisoTransicion;
import modela.bd.obj.TrBloque;
import modela.bd.obj.TrBloquePermitido;
import modela.bd.obj.TrCondicion;
import modela.bd.obj.TrCondicionTareaFase;
import modela.bd.obj.TrCondicionTransicion;
import modela.bd.obj.TrDocumentoPermitido;
import modela.bd.obj.TrExpediente;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrFaseGr;
import modela.bd.obj.TrIndicacionFicha;
import modela.bd.obj.TrMetafase;
import modela.bd.obj.TrNormativa;
import modela.bd.obj.TrOrganismo;
import modela.bd.obj.TrOrganismoProc;
import modela.bd.obj.TrParametro;
import modela.bd.obj.TrParrafoTipDoc;
import modela.bd.obj.TrPerfilTareaFase;
import modela.bd.obj.TrPerfilTransEvol;
import modela.bd.obj.TrPerfilUsuario;
import modela.bd.obj.TrPlantilla;
import modela.bd.obj.TrSistema;
import modela.bd.obj.TrTarea;
import modela.bd.obj.TrTareaEnFase;
import modela.bd.obj.TrTareaEnFaseDefProcedimiento;
import modela.bd.obj.TrTipoActo;
import modela.bd.obj.TrTipoDocumento;
import modela.bd.obj.TrTipoIndicacionFicha;
import modela.bd.obj.TrTipoNormativa;
import modela.bd.obj.TrTipoOrganismo;
import modela.bd.obj.TrTipoParrafo;
import modela.bd.obj.TrTipoPublicacion;
import modela.bd.obj.TrTransicion;
import modela.bd.obj.TrTransicionDefProcedimiento;
import modela.bd.obj.TrVariable;
import modela.conf.ModelaConf;
import modela.graf.CreadorXMLDefProc;
import modela.graf.DestructorDDP;
import modela.graf.LectorXMLDefProc;
import modela.graf.Referencia;
import modela.ui.piccolo.PCanvasModela;
import modela.ui.swing.GestionPropGraficoMetafaseJDialog;
import modela.ui.swing.MantenimientoAccionJDialog;
import modela.ui.swing.MantenimientoAvisoJDialog;
import modela.ui.swing.MantenimientoBloquesJDialog;
import modela.ui.swing.MantenimientoCondicionJDialog;
import modela.ui.swing.MantenimientoFasesJDialog;
import modela.ui.swing.MantenimientoMetafasesJDialog;
import modela.ui.swing.MantenimientoParametrosJDialog;
import modela.ui.swing.MantenimientoPerfilUsuarioJDialog;
import modela.ui.swing.MantenimientoPlantillaJDialog;
import modela.ui.swing.MantenimientoTareaJDialog;
import modela.ui.swing.MantenimientoTipoActoJDialog;
import modela.ui.swing.MantenimientoTipoDocumentoJDialog;
import modela.ui.swing.MantenimientoTipoParrafoJDialog;
import modela.ui.swing.MantenimientoTransicionJDialog;
import modela.ui.swing.MantenimientoVariablesJDialog;
import modela.ui.swing.PropDefProcJPanel;

public class DDPGrafico {
    protected DefProcGr dDPGr0;
    protected ConjuntoDatosTransicionDefProcedimiento TransicionesDefProcInvolucradas = new ConjuntoDatosTransicionDefProcedimiento();
    protected ConjuntoDatosTareaFaseDefProcedimiento TareaFaseDefProcInvolucradas = new ConjuntoDatosTareaFaseDefProcedimiento();
    protected ConjuntoDatos ModulosReutilizables = new ConjuntoDatos();
    protected ConjuntoDatosTarea tareasInvolucradasEnCarga = new ConjuntoDatosTarea();
    protected ConjuntoDatosTareaEnFase tareasEnFaseInvolucradasEnCarga = new ConjuntoDatosTareaEnFase();
    protected ConjuntoDatosParametros parametrosInvolucradosEnCarga = new ConjuntoDatosParametros();
    protected ConjuntoDatosTipoActo tiposActoInvolucradosEnCarga = new ConjuntoDatosTipoActo();
    protected ConjuntoDatosTiposParrafo tiposParrafoInvolucradosEnCarga = new ConjuntoDatosTiposParrafo();
    protected ConjuntoDatosPlantillas plantillasInvolucradasEnCarga = new ConjuntoDatosPlantillas();
    protected ConjuntoDatosVariables variablesInvolucradasEnCarga = new ConjuntoDatosVariables();
    protected ConjuntoDatosTiposOrganismo tiposOrganismoInvolucradosEnCarga = new ConjuntoDatosTiposOrganismo();
    protected ConjuntoDatosOrganismo organismosInvolucradosEnCarga = new ConjuntoDatosOrganismo();
    protected ConjuntoDatosTiposIndicacion tiposIndicacionInvolucradosEnCarga = new ConjuntoDatosTiposIndicacion();
    protected ConjuntoDatosTiposNormativa tiposNormativaInvolucradosEnCarga = new ConjuntoDatosTiposNormativa();
    protected ConjuntoDatosTiposPublicacion tiposPublicacionInvolucradosEnCarga = new ConjuntoDatosTiposPublicacion();
    protected ConjuntoDatosAmbitosLey ambitosLeyInvolucradosEnCarga = new ConjuntoDatosAmbitosLey();
    protected ConjuntoDatosNormativa normativasInvolucradasEnCarga = new ConjuntoDatosNormativa();
    protected TrMetafase metafaseActiva = null;
    protected PCanvasModela canvasGrafico = null;
    protected Component componentePadre = null;
    protected TrExpediente expediente = null;
    protected DestructorDDP destructorDDP = new DestructorDDP(this);
    protected boolean bIncoherente = false;
    protected ArrayList listaDDPs = new ArrayList();
    protected DDPGrafico ddpPrincipal = null;
    protected TrSistema conjuntoDatosGlobal = null;
    protected boolean bProcesado = false;
    protected boolean bCerrado = false;
    protected String nomArchivo;
    protected String stPath;
    protected String pathSimple = null;
    protected boolean bEditable = true;
    protected boolean bInfoGraficaInicial = true;
    protected boolean bBloqueado = false;

    public DDPGrafico() {
        this.ddpPrincipal = null;
        this.conjuntoDatosGlobal = null;
        this.bProcesado = false;
        this.bCerrado = false;
        this.nomArchivo = null;
        this.stPath = null;
        this.pathSimple = null;
        this.bEditable = true;
        this.bInfoGraficaInicial = true;
        this.bBloqueado = false;
    }

    public DDPGrafico(DDPGrafico graficoPrincipal) {
        this.ddpPrincipal = graficoPrincipal;
        this.bProcesado = false;
        this.bCerrado = false;
        this.bEditable = true;
        this.bInfoGraficaInicial = true;
        this.bBloqueado = false;
    }

    public boolean isProcesado() {
        return this.bProcesado;
    }

    public void setProcesado(boolean pValor) {
        this.bProcesado = pValor;
    }

    public boolean isCerrado() {
        if (this.getDDPPadre() == null) {
            return this.bCerrado;
        }
        return this.getDDPPadre().isCerrado();
    }

    public void setCerrado(boolean pValor) {
        if (this.getDDPPadre() == null) {
            this.bCerrado = pValor;
        } else {
            this.getDDPPadre().setCerrado(pValor);
        }
    }

    public boolean isEditable() {
        if (this.getDDPPadre() == null) {
            return true;
        }
        return this.bEditable;
    }

    public void setEditable(boolean pValor) {
        if (this.getDDPPadre() == null && !pValor) {
            return;
        }
        this.bEditable = pValor;
    }

    public String isEditableToString() {
        if (this.isEditable()) {
            return "S";
        }
        return "N";
    }

    public boolean isIncoherente() {
        return this.bIncoherente;
    }

    public void setIncoherente(boolean bIncoherencia) {
        this.bIncoherente = bIncoherencia;
    }

    public void setInfoGraficaInicial(boolean bInfoInicial) {
        this.bInfoGraficaInicial = bInfoInicial;
    }

    public boolean getInfoGraficaInicial() {
        return this.bInfoGraficaInicial;
    }

    public DDPGrafico getDDPPadre() {
        return this.ddpPrincipal;
    }

    public TrSistema getConjuntoDatosGlobal() {
        return this.conjuntoDatosGlobal;
    }

    public void setConjuntoDatosGlobal(TrSistema pConjuntoGlobal) {
        this.conjuntoDatosGlobal = pConjuntoGlobal;
    }

    public DestructorDDP getDestructorDDP() {
        return this.destructorDDP;
    }

    public void setDestructorDDP(DestructorDDP pDestructor) {
        this.destructorDDP = pDestructor;
    }

    public void setDDP(DefProcGr nuevoDDP) {
        this.dDPGr0 = nuevoDDP;
        this.establecerSistema(nuevoDDP);
    }

    public DefProcGr getDDP() {
        return this.dDPGr0;
    }

    public void setPadre(Component compPadre) {
        this.componentePadre = compPadre;
    }

    public void setCanvas(PCanvasModela nuevoCanvas) {
        this.canvasGrafico = nuevoCanvas;
    }

    public PCanvasModela getCanvas() {
        return this.canvasGrafico;
    }

    public TrExpediente getExpediente() {
        return this.expediente;
    }

    public void setExpediente(TrExpediente pExpediente) {
        this.expediente = pExpediente;
    }

    public DefProcGr introducirNuevoDDPGr() {
        DefProcGr DDPGrNuevo = new DefProcGr();
        PropDefProcJPanel panelDatos = new PropDefProcJPanel();
        PropiedadesJDialog p = new PropiedadesJDialog(panelDatos, 2);
        p.setTitle("Nueva definici\u00f3n del procedimiento");
        if (this.getDDPPadre() != null) {
            panelDatos.permitirModificarSistema(false);
            panelDatos.permitirModificarCategoria(false);
            p.setTitle("Nueva definici\u00f3n del procedimiento reutilizable");
            DDPGrNuevo.getTIPOEVOL().setSISTEMA(this.getDDPPadre().getDDP().getTIPOEVOL().getSISTEMA());
        } else {
            DDPGrNuevo.getTIPOEVOL().setSISTEMA(ModelaConf.getSistemaPorDefecto());
            this.setDDP(DDPGrNuevo);
        }
        p.setValoresAsignables(DDPGrNuevo);
        panelDatos.setGrafico(this);
        p.setVisible(true);
        if (p.seAplica()) {
            if (this.getDDPPadre() != null) {
                if (this.existeDDPGrafico(DDPGrNuevo.getTIPOEVOL().getABREVIATURA()) != null) {
                    JOptionPane.showMessageDialog(p, "Imposible crear:\nYa existe una DDP con la abreviatura indicada.", "Atenci\u00f3n", 2);
                    DDPGrNuevo = null;
                    return null;
                }
            } else {
                ModelaConf.setSistemaActivo(DDPGrNuevo.getTIPOEVOL().getSISTEMA(), true);
                ModelaConf.salvar();
            }
            return DDPGrNuevo;
        }
        DDPGrNuevo = null;
        return null;
    }

    public void editarPropiedadesDDPGr() {
        block7: {
            String strSistemaOriginal;
            String strDescripOriginal;
            String strAbreviaturaOriginal;
            PropiedadesJDialog p;
            block8: {
                int n;
                PropDefProcJPanel panelDatos = new PropDefProcJPanel();
                p = new PropiedadesJDialog(panelDatos, 2);
                p.setTitle("Propiedades de la definici\u00f3n del procedimiento");
                p.setValoresAsignables(this.getDDP());
                if (this.getDDPPadre() != null) {
                    panelDatos.permitirModificarSistema(false);
                    panelDatos.permitirModificarCategoria(false);
                }
                if (this.getDDP().getTIPOEVOL() == null) {
                    return;
                }
                strAbreviaturaOriginal = this.getDDP().getTIPOEVOL().getABREVIATURA();
                strDescripOriginal = this.getDDP().getTIPOEVOL().getDESCRIPCION();
                strSistemaOriginal = this.getDDP().getTIPOEVOL().getSISTEMA();
                panelDatos.setGrafico(this);
                p.setVisible(true);
                if (!p.seAplica()) break block7;
                if (this.getDDPPadre() != null) break block8;
                if (this.getDDP() != null && this.getDDP().getTIPOEVOL() != null) {
                    for (n = 0; n < this.getListaDDPs().size(); ++n) {
                        if (((DDPGrafico)this.getListaDDPs().get(n)).getDDP() == null || ((DDPGrafico)this.getListaDDPs().get(n)).getDDP().getTIPOEVOL() == null || !((DDPGrafico)this.getListaDDPs().get(n)).getDDP().getTIPOEVOL().getABREVIATURA().equals(this.getDDP().getTIPOEVOL().getABREVIATURA())) continue;
                        JOptionPane.showMessageDialog(p, "Imposible modificar:\nYa existe una DDP con la abreviatura indicada.", "Atenci\u00f3n", 2);
                        this.getDDP().getTIPOEVOL().setABREVIATURA(strAbreviaturaOriginal);
                        this.getDDP().getTIPOEVOL().setDESCRIPCION(strDescripOriginal);
                        this.getDDP().getTIPOEVOL().setSISTEMA(strSistemaOriginal);
                        return;
                    }
                }
                if (this.getDDP() == null || this.getDDP().getTIPOEVOL() == null) break block7;
                ModelaConf.setSistemaActivo(this.getDDP().getTIPOEVOL().getSISTEMA(), true);
                ModelaConf.salvar();
                for (n = 0; n < this.getListaDDPs().size(); ++n) {
                    if (((DDPGrafico)this.getListaDDPs().get(n)).getDDP() == null || ((DDPGrafico)this.getListaDDPs().get(n)).getDDP().getTIPOEVOL() == null) continue;
                    ((DDPGrafico)this.getListaDDPs().get(n)).getDDP().getTIPOEVOL().setSISTEMA(this.getDDP().getTIPOEVOL().getSISTEMA());
                }
                break block7;
            }
            if (this.getDDP() != null && this.getDDP().getTIPOEVOL() != null && this.getDDP().getTIPOEVOL().getABREVIATURA().equals(this.getDDPPadre().getDDP().getTIPOEVOL().getABREVIATURA())) {
                JOptionPane.showMessageDialog(p, "Imposible modificar:\nYa existe una DDP con la abreviatura indicada.", "Atenci\u00f3n", 2);
                this.getDDP().getTIPOEVOL().setABREVIATURA(strAbreviaturaOriginal);
                this.getDDP().getTIPOEVOL().setDESCRIPCION(strDescripOriginal);
                this.getDDP().getTIPOEVOL().setSISTEMA(strSistemaOriginal);
                return;
            }
            for (int n = 0; n < this.getDDPPadre().getListaDDPs().size(); ++n) {
                if (((DDPGrafico)this.getDDPPadre().getListaDDPs().get(n)).getDDP() == null || ((DDPGrafico)this.getDDPPadre().getListaDDPs().get(n)).getDDP().getTIPOEVOL() == null || !((DDPGrafico)this.getDDPPadre().getListaDDPs().get(n)).getDDP().getTIPOEVOL().getABREVIATURA().equals(this.getDDP().getTIPOEVOL().getABREVIATURA()) || ((DDPGrafico)this.getDDPPadre().getListaDDPs().get(n)).getDDP().getTIPOEVOL().getTIEVID().longValue() == this.getDDP().getTIPOEVOL().getTIEVID().longValue()) continue;
                JOptionPane.showMessageDialog(p, "Imposible modificar:\nYa existe una DDP con la abreviatura indicada.", "Atenci\u00f3n", 2);
                this.getDDP().getTIPOEVOL().setABREVIATURA(strAbreviaturaOriginal);
                this.getDDP().getTIPOEVOL().setDESCRIPCION(strDescripOriginal);
                this.getDDP().getTIPOEVOL().setSISTEMA(strSistemaOriginal);
                return;
            }
        }
    }

    private boolean abrirXMLDDefProc(File openFile) {
        this.setIncoherente(false);
        LectorXMLDefProc lectorXML = null;
        if (openFile == null) {
            return false;
        }
        this.limpiar();
        lectorXML = new LectorXMLDefProc();
        lectorXML.setGrafico(this);
        boolean bResul = lectorXML.leerArchivo(openFile);
        return bResul;
    }

    public void mostrarPropiedades() {
        PropiedadesJDialog p = new PropiedadesJDialog(new PropDefProcJPanel(), 1);
        p.setTitle("Propiedades de la definici\u00f3n del procedimiento");
        p.setValoresAsignables(this.getDDP());
        p.setVisible(true);
    }

    public boolean nuevo() {
        DefProcGr DDPGrNuevo = this.introducirNuevoDDPGr();
        if (DDPGrNuevo == null) {
            return false;
        }
        this.setDDP(DDPGrNuevo);
        return true;
    }

    public void establecerSistema(DefProcGr defProcNuevo) {
        RepositorioModela repositorio = RepositorioModela.obtenerRepositorio();
        String strSistema = defProcNuevo.getTIPOEVOL().getSISTEMA();
        TrSistema sistemaActual = repositorio.addSistema(strSistema);
        this.setConjuntoDatosGlobal(sistemaActual);
    }

    public boolean abrir() {
        String strRuta = ModelaConf.getRutaArchivo();
        JFileChooser fileDlg = strRuta != null ? new JFileChooser(strRuta) : new JFileChooser();
        fileDlg.setFileSelectionMode(0);
        String[] extensiones = new String[]{"xml", "xmd"};
        FileFilterEx filter = new FileFilterEx(extensiones);
        filter.setDescription("Archivos XML, XMD");
        fileDlg.addChoosableFileFilter(filter);
        int nRet = fileDlg.showOpenDialog(this.componentePadre);
        if (nRet == 0) {
            File fich = fileDlg.getSelectedFile();
            this.nomArchivo = fich.getPath();
            this.stPath = fich.getAbsolutePath();
            this.pathSimple = fich.getParent();
            File path = fileDlg.getCurrentDirectory();
            ModelaConf.setRutaArchivo(path.getAbsolutePath());
            ModelaConf.salvar();
            return this.abrirXMLDDefProc(fileDlg.getSelectedFile());
        }
        return false;
    }

    public boolean abrir(String strRuta) {
        boolean bRes = false;
        if (strRuta != null) {
            File fich = new File(strRuta);
            this.nomArchivo = fich.getPath();
            this.stPath = fich.getAbsolutePath();
            this.pathSimple = fich.getParent();
            ModelaConf.setRutaArchivo(this.pathSimple);
            bRes = ModelaConf.salvar();
            return this.abrirXMLDDefProc(fich);
        }
        return bRes;
    }

    public boolean salvar(boolean pCerrar) {
        ModelaConf.setCompatibleTrewa0(false);
        CreadorXMLDefProc creadorXML = null;
        String strRuta = ModelaConf.getRutaArchivo();
        JFileChooser fileDlg = new JFileChooser(strRuta);
        String strExtensionFichero = null;
        if (!pCerrar) {
            strExtensionFichero = "xmd";
        } else if (pCerrar) {
            strExtensionFichero = "xml";
        }
        fileDlg.setFileSelectionMode(0);
        FileFilterEx filter = new FileFilterEx(strExtensionFichero);
        filter.setDescription("Archivos " + strExtensionFichero);
        fileDlg.addChoosableFileFilter(filter);
        int nRet = fileDlg.showSaveDialog(this.componentePadre);
        if (nRet == 0) {
            ValidarNombreFichero validaFichero;
            String strNombreFichero;
            creadorXML = new CreadorXMLDefProc();
            File fich = fileDlg.getSelectedFile();
            String strPath = fich.getPath();
            if (!strPath.endsWith("." + strExtensionFichero)) {
                strPath = strPath + "." + strExtensionFichero;
            }
            if (!(strNombreFichero = fich.getName()).endsWith("." + strExtensionFichero)) {
                strNombreFichero = strNombreFichero + "." + strExtensionFichero;
            }
            if (!(validaFichero = new ValidarNombreFichero()).validaNombreFichero(strNombreFichero)) {
                return false;
            }
            File path = fileDlg.getCurrentDirectory();
            ModelaConf.setRutaArchivo(path.getAbsolutePath());
            this.nomArchivo = strPath;
            this.stPath = path.getAbsolutePath();
            this.pathSimple = fich.getParent();
            ModelaConf.salvar();
            this.setCerrado(pCerrar);
            if (this.getDDPPadre() == null) {
                return creadorXML.generarArchivo(strPath, this, pCerrar);
            }
            return creadorXML.generarArchivo(strPath, this.getDDPPadre(), pCerrar);
        }
        return false;
    }

    public void setNombreArchivo(String strNomArchivo) {
        this.nomArchivo = strNomArchivo;
    }

    public void setPath(String strPath) {
        this.stPath = strPath;
    }

    public String getNombreArchivo() {
        if (this.getDDPPadre() == null) {
            return this.nomArchivo;
        }
        return this.getDDPPadre().nomArchivo;
    }

    public String getPath() {
        return this.stPath;
    }

    public String getPathSimple() {
        return this.pathSimple;
    }

    public boolean salvarSimple() {
        if (this.nomArchivo == null) {
            return this.salvar(false);
        }
        if (this.isCerrado()) {
            return this.salvar(false);
        }
        ModelaConf.setCompatibleTrewa0(false);
        CreadorXMLDefProc creadorXML = null;
        creadorXML = new CreadorXMLDefProc();
        if (!this.nomArchivo.endsWith(".xmd")) {
            this.nomArchivo = this.nomArchivo + ".xmd";
        }
        this.setCerrado(false);
        if (this.getDDPPadre() == null) {
            return creadorXML.generarArchivo(this.nomArchivo, this, false);
        }
        return creadorXML.generarArchivo(this.nomArchivo, this.getDDPPadre(), false);
    }

    public boolean cerrar(String ficheroSalida, String rutaSalida) {
        CreadorXMLDefProc creadorXML = null;
        creadorXML = new CreadorXMLDefProc();
        if (!ficheroSalida.endsWith(".xml")) {
            ficheroSalida = ficheroSalida + ".xml";
        }
        if (this.getDDPPadre() == null) {
            return creadorXML.generarArchivo(ficheroSalida, this, true);
        }
        return creadorXML.generarArchivo(ficheroSalida, this.getDDPPadre(), true);
    }

    public void inicializar() {
        this.dDPGr0 = null;
        if (this.conjuntoDatosGlobal != null) {
            this.conjuntoDatosGlobal.inicializar();
        }
        this.TransicionesDefProcInvolucradas = new ConjuntoDatosTransicionDefProcedimiento();
        this.TareaFaseDefProcInvolucradas = new ConjuntoDatosTareaFaseDefProcedimiento();
        this.tareasEnFaseInvolucradasEnCarga = new ConjuntoDatosTareaEnFase();
        this.tareasInvolucradasEnCarga = new ConjuntoDatosTarea();
        this.parametrosInvolucradosEnCarga = new ConjuntoDatosParametros();
        this.tiposActoInvolucradosEnCarga = new ConjuntoDatosTipoActo();
        this.tiposParrafoInvolucradosEnCarga = new ConjuntoDatosTiposParrafo();
        this.plantillasInvolucradasEnCarga = new ConjuntoDatosPlantillas();
        this.variablesInvolucradasEnCarga = new ConjuntoDatosVariables();
        this.tiposOrganismoInvolucradosEnCarga = new ConjuntoDatosTiposOrganismo();
        this.organismosInvolucradosEnCarga = new ConjuntoDatosOrganismo();
        this.tiposIndicacionInvolucradosEnCarga = new ConjuntoDatosTiposIndicacion();
        this.tiposNormativaInvolucradosEnCarga = new ConjuntoDatosTiposNormativa();
        this.tiposPublicacionInvolucradosEnCarga = new ConjuntoDatosTiposPublicacion();
        this.ambitosLeyInvolucradosEnCarga = new ConjuntoDatosAmbitosLey();
        this.normativasInvolucradasEnCarga = new ConjuntoDatosNormativa();
    }

    public void limpiar() {
        this.dDPGr0 = null;
        if (this.TransicionesDefProcInvolucradas != null) {
            this.TransicionesDefProcInvolucradas.removeAllElements();
            this.TransicionesDefProcInvolucradas = null;
        }
        if (this.TareaFaseDefProcInvolucradas != null) {
            this.TareaFaseDefProcInvolucradas.removeAllElements();
            this.TareaFaseDefProcInvolucradas = null;
        }
        if (this.tareasInvolucradasEnCarga != null) {
            this.tareasInvolucradasEnCarga.removeAllElements();
            this.tareasInvolucradasEnCarga = null;
        }
        if (this.tareasEnFaseInvolucradasEnCarga != null) {
            this.tareasEnFaseInvolucradasEnCarga.removeAllElements();
            this.tareasEnFaseInvolucradasEnCarga = null;
        }
        if (this.parametrosInvolucradosEnCarga != null) {
            this.parametrosInvolucradosEnCarga.removeAllElements();
            this.parametrosInvolucradosEnCarga = null;
        }
        if (this.tiposActoInvolucradosEnCarga != null) {
            this.tiposActoInvolucradosEnCarga.removeAllElements();
            this.tiposActoInvolucradosEnCarga = null;
        }
        if (this.tiposParrafoInvolucradosEnCarga != null) {
            this.tiposParrafoInvolucradosEnCarga.removeAllElements();
            this.tiposParrafoInvolucradosEnCarga = null;
        }
        if (this.plantillasInvolucradasEnCarga != null) {
            this.plantillasInvolucradasEnCarga.removeAllElements();
            this.plantillasInvolucradasEnCarga = null;
        }
        if (this.variablesInvolucradasEnCarga != null) {
            this.variablesInvolucradasEnCarga.removeAllElements();
            this.variablesInvolucradasEnCarga = null;
        }
        if (this.tiposOrganismoInvolucradosEnCarga != null) {
            this.tiposOrganismoInvolucradosEnCarga.removeAllElements();
            this.tiposOrganismoInvolucradosEnCarga = null;
        }
        if (this.organismosInvolucradosEnCarga != null) {
            this.organismosInvolucradosEnCarga.removeAllElements();
            this.organismosInvolucradosEnCarga = null;
        }
        if (this.tiposIndicacionInvolucradosEnCarga != null) {
            this.tiposIndicacionInvolucradosEnCarga.removeAllElements();
            this.tiposIndicacionInvolucradosEnCarga = null;
        }
        if (this.tiposNormativaInvolucradosEnCarga != null) {
            this.tiposNormativaInvolucradosEnCarga.removeAllElements();
            this.tiposNormativaInvolucradosEnCarga = null;
        }
        if (this.tiposPublicacionInvolucradosEnCarga != null) {
            this.tiposPublicacionInvolucradosEnCarga.removeAllElements();
            this.tiposPublicacionInvolucradosEnCarga = null;
        }
        if (this.ambitosLeyInvolucradosEnCarga != null) {
            this.ambitosLeyInvolucradosEnCarga.removeAllElements();
            this.ambitosLeyInvolucradosEnCarga = null;
        }
        if (this.normativasInvolucradasEnCarga != null) {
            this.normativasInvolucradasEnCarga.removeAllElements();
            this.normativasInvolucradasEnCarga = null;
        }
        if (this.getCanvas() != null) {
            this.getCanvas().getLayer().removeAllChildren();
        }
    }

    public boolean insertarGraficoDeFase() {
        if (this.canvasGrafico == null) {
            return false;
        }
        MantenimientoFasesJDialog mttoFases = new MantenimientoFasesJDialog();
        mttoFases.setGrafico(this);
        mttoFases.establecerModoTrabajo(2);
        mttoFases.setVisible(true);
        mttoFases.refrescarGrafico();
        Object[] seleccionMultiple = null;
        seleccionMultiple = mttoFases.obtenerElementosSeleccionados();
        TrFase fase = null;
        if (seleccionMultiple != null) {
            for (int i = 0; i < seleccionMultiple.length; ++i) {
                fase = (TrFase)seleccionMultiple[i];
                if (fase == null) continue;
                if (fase.getTIPOEVOL() != null && fase.getTIPOEVOL().getTIEVID().longValue() == this.getDDP().getTIPOEVOL().getTIEVID().longValue()) {
                    JOptionPane.showMessageDialog((Component)((Object)this.canvasGrafico), "Ha sido imposible insertar la fase: " + fase.getNombre() + "\nLa fase seleccionada est\u00e1 asociada a este mismo DDP.", "Atenci\u00f3n:", 2);
                    continue;
                }
                TrFaseGr faseGr = new TrFaseGr();
                faseGr.setTrFase(fase);
                this.canvasGrafico.crearGraficoDeFase(faseGr);
                mttoFases.dispararInformarArriba(fase);
            }
        }
        return true;
    }

    public boolean insertarGraficoDeTransicion(ConjuntoDatos transicionesSinInfoGraf) {
        if (this.canvasGrafico == null) {
            return false;
        }
        MantenimientoTransicionJDialog mttoTransiciones = new MantenimientoTransicionJDialog(false);
        mttoTransiciones.setTitle("Incluir transiciones no dibujadas en el procedimiento");
        mttoTransiciones.establecerModoTrabajo(8);
        mttoTransiciones.setDesdeUtilidadGrf(true);
        mttoTransiciones.setGrafico(this, transicionesSinInfoGraf);
        mttoTransiciones.activarSeleccion(true);
        mttoTransiciones.setLocationRelativeTo(null);
        mttoTransiciones.setVisible(true);
        Object[] totalElementos = mttoTransiciones.obtenerElementosSeleccionados();
        if (totalElementos == null) {
            return false;
        }
        for (int n = 0; n < totalElementos.length; ++n) {
            TrTransicion transiSeleccionada = (TrTransicion)totalElementos[n];
            if (transiSeleccionada == null) {
                return false;
            }
            this.canvasGrafico.crearGraficoTransicion(transiSeleccionada);
        }
        return true;
    }

    public void mostrarPropiedadesGraficasMetafase() {
        if (this.getMetafasesInvolucradas() == null) {
            return;
        }
        if (this.getMetafasesInvolucradas().getListaDatos() == null) {
            return;
        }
        if (this.getMetafasesInvolucradas().getListaDatos().size() < 1) {
            return;
        }
        GestionPropGraficoMetafaseJDialog gestionGrMetafases = new GestionPropGraficoMetafaseJDialog();
        gestionGrMetafases.inicializarListaElementos(this.getMetafasesInvolucradas());
        gestionGrMetafases.setDesdeUtilidadGrf(true);
        gestionGrMetafases.setLocationRelativeTo(null);
        gestionGrMetafases.activarSeleccion(false);
        gestionGrMetafases.setVisible(true);
        this.canvasGrafico.repaint();
    }

    public void mostrarPropiedadesSeleccion(ConjuntoDatos listaElementos, int nTipoGrafico) {
        if (listaElementos == null) {
            return;
        }
        if (listaElementos.getListaDatos() == null) {
            return;
        }
        if (listaElementos.getListaDatos().size() < 1) {
            return;
        }
        if (nTipoGrafico == 1) {
            MantenimientoFasesJDialog mttoFases = new MantenimientoFasesJDialog(2);
            mttoFases.setGrafico(this);
            mttoFases.inicializarListaElementos(listaElementos);
            mttoFases.setDesdeUtilidadGrf(true);
            mttoFases.activarSeleccion(false);
            mttoFases.permitirEliminar(false);
            mttoFases.permitirModificar(true);
            mttoFases.permitirInsertar(false);
            mttoFases.setLocationRelativeTo(null);
            mttoFases.setVisible(true);
        } else if (nTipoGrafico == 2) {
            MantenimientoTransicionJDialog mttoTransiciones = new MantenimientoTransicionJDialog(true);
            mttoTransiciones.setGrafico(this);
            mttoTransiciones.setDesdeUtilidadGrf(true);
            mttoTransiciones.setViendoPropiedades(true);
            mttoTransiciones.inicializarListaElementos(listaElementos);
            mttoTransiciones.activarSeleccion(false);
            mttoTransiciones.permitirEliminar(false);
            mttoTransiciones.permitirModificar(true);
            mttoTransiciones.permitirInsertar(false);
            mttoTransiciones.setLocationRelativeTo(null);
            mttoTransiciones.setVisible(true);
        }
    }

    public TrMetafase seleccionarMetafaseAasignar() {
        MantenimientoMetafasesJDialog mttoMetafases = new MantenimientoMetafasesJDialog();
        mttoMetafases.setGrafico(this);
        mttoMetafases.inicializarListaElementos(this.getMetafasesInvolucradas());
        mttoMetafases.setDesdeUtilidadGrf(true);
        mttoMetafases.activarSeleccion(true);
        mttoMetafases.setLocationRelativeTo(null);
        mttoMetafases.setVisible(true);
        TrMetafase metaDevuelta = null;
        if (mttoMetafases.obtenerElementoSeleccionado() != null) {
            metaDevuelta = (TrMetafase)mttoMetafases.obtenerElementoSeleccionado();
        }
        mttoMetafases.refrescarGrafico();
        return metaDevuelta;
    }

    public void setFasesInvolucradas(ConjuntoDatos nuevasFases) {
        if (!(nuevasFases instanceof ConjuntoDatosFase)) {
            return;
        }
        this.conjuntoDatosGlobal.setFasesInvolucradas(nuevasFases);
    }

    public ConjuntoDatosModela getFasesInvolucradas() {
        return this.conjuntoDatosGlobal.getFasesInvolucradas();
    }

    public TrFase obtenerFase(BigDecimal pID) {
        if (this.getFasesInvolucradas() == null) {
            return null;
        }
        if (this.getFasesInvolucradas().obtenerNumRegistros() < 1) {
            return null;
        }
        TrFase faseTmp = null;
        for (int n = 0; n < this.getFasesInvolucradas().getListaDatos().size(); ++n) {
            faseTmp = (TrFase)this.getFasesInvolucradas().getListaDatos().get(n);
            if (faseTmp.getFASEID().longValue() != pID.longValue()) continue;
            return faseTmp;
        }
        return null;
    }

    public ArrayList obtenerFasesDeMetafase(TrMetafase metafaseBuscada) {
        ArrayList totalFases = new ArrayList();
        ArrayList<TrFase> fasesEncontradas = new ArrayList<TrFase>();
        totalFases = this.getFasesInvolucradas().getListaDatos();
        if (metafaseBuscada == null) {
            return null;
        }
        if (totalFases == null) {
            return null;
        }
        for (int i = 0; i < totalFases.size(); ++i) {
            TrFase fase = (TrFase)totalFases.get(i);
            if (fase.getMETAFASE() == null || fase.getMETAFASE().getMETAID().longValue() != metafaseBuscada.getMETAID().longValue()) continue;
            fasesEncontradas.add(fase);
        }
        return fasesEncontradas;
    }

    public ArrayList obtenerFasesDeMetafaseEnEsteDDP(TrMetafase metafaseBuscada) {
        ArrayList totalFases = new ArrayList();
        ArrayList<TrFase> fasesEncontradas = new ArrayList<TrFase>();
        totalFases = this.getFasesInvolucradasGr().getListaDatos();
        if (metafaseBuscada == null) {
            return null;
        }
        if (totalFases == null) {
            return null;
        }
        for (int i = 0; i < totalFases.size(); ++i) {
            TrFase fase = (TrFase)totalFases.get(i);
            if (fase.getMETAFASE() == null || fase.getMETAFASE().getMETAID().longValue() != metafaseBuscada.getMETAID().longValue()) continue;
            fasesEncontradas.add(fase);
        }
        return fasesEncontradas;
    }

    public TrTransicion obtenerTransicion(BigDecimal pID) {
        if (this.getTransicionesInvolucradas() == null) {
            return null;
        }
        if (this.getTransicionesInvolucradas().obtenerNumRegistros() < 1) {
            return null;
        }
        TrTransicion transicionTmp = null;
        for (int n = 0; n < this.getTransicionesInvolucradas().getListaDatos().size(); ++n) {
            transicionTmp = (TrTransicion)this.getTransicionesInvolucradas().getListaDatos().get(n);
            if (transicionTmp.getTRANID().longValue() != pID.longValue()) continue;
            return transicionTmp;
        }
        return null;
    }

    public void setMetafasesInvolucradas(ConjuntoDatos nuevasMetafases) {
        if (!(nuevasMetafases instanceof ConjuntoDatosMetafase)) {
            return;
        }
        this.conjuntoDatosGlobal.setMetafasesInvolucradas(nuevasMetafases);
    }

    public ConjuntoDatosModela getMetafasesInvolucradas() {
        return this.conjuntoDatosGlobal.getMetafasesInvolucradas();
    }

    public void setPerfilesUsuarioInvolucrados(ConjuntoDatos nuevosPerfiles) {
        if (!(nuevosPerfiles instanceof ConjuntoDatosPerfilUsuario)) {
            return;
        }
        this.conjuntoDatosGlobal.setPerfilesUsuarioInvolucrados(nuevosPerfiles);
    }

    public ConjuntoDatosModela getPerfilesUsuarioInvolucrados() {
        return this.conjuntoDatosGlobal.getPerfilesUsuarioInvolucrados();
    }

    public void setTareasEnFaseInvolucradasEnCarga(ConjuntoDatosTareaEnFase nuevasTareasEnFase) {
        if (nuevasTareasEnFase != null) {
            this.tareasEnFaseInvolucradasEnCarga = nuevasTareasEnFase;
        }
    }

    public ConjuntoDatosTareaEnFase getTareasEnFaseInvolucradasEnCarga() {
        return this.tareasEnFaseInvolucradasEnCarga;
    }

    public void setAccionesInvolucradas(ConjuntoDatos nuevasAcciones) {
        if (!(nuevasAcciones instanceof ConjuntoDatosAccion)) {
            return;
        }
        this.conjuntoDatosGlobal.setAccionesInvolucradas(nuevasAcciones);
    }

    public ConjuntoDatosModela getAccionesInvolucradas() {
        return this.conjuntoDatosGlobal.getAccionesInvolucradas();
    }

    public void setCondicionesInvolucradas(ConjuntoDatos nuevasCondiciones) {
        if (!(nuevasCondiciones instanceof ConjuntoDatosCondicion)) {
            return;
        }
        this.conjuntoDatosGlobal.setCondicionesInvolucradas(nuevasCondiciones);
    }

    public ConjuntoDatosModela getCondicionesInvolucradas() {
        return this.conjuntoDatosGlobal.getCondicionesInvolucradas();
    }

    public void setTransicionesInvolucradas(ConjuntoDatos nuevasTransiciones) {
        if (!(nuevasTransiciones instanceof ConjuntoDatosTransicion)) {
            return;
        }
        this.conjuntoDatosGlobal.setTransicionesInvolucradas(nuevasTransiciones);
    }

    public ConjuntoDatosTransicion getTransicionesInvolucradas() {
        return this.conjuntoDatosGlobal.getTransicionesInvolucradas();
    }

    public void setTareasInvolucradas(ConjuntoDatos nuevasTareasInvolucradas) {
        if (!(nuevasTareasInvolucradas instanceof ConjuntoDatosTarea)) {
            return;
        }
        this.conjuntoDatosGlobal.setTareasInvolucradas(nuevasTareasInvolucradas);
    }

    public ConjuntoDatosTarea getTareasInvolucradas() {
        return this.conjuntoDatosGlobal.getTareasInvolucradas();
    }

    public void setTiposActoInvolucrados(ConjuntoDatos nuevosTiposActo) {
        if (!(nuevosTiposActo instanceof ConjuntoDatosTipoActo)) {
            return;
        }
        this.conjuntoDatosGlobal.setTiposActoInvolucrados(nuevosTiposActo);
    }

    public ConjuntoDatosTipoActo getTiposActoInvolucrados() {
        return this.conjuntoDatosGlobal.getTiposActoInvolucrados();
    }

    public void mantenimientoPerfilesUsuario() {
        MantenimientoPerfilUsuarioJDialog mttoPerfilesUsuario = new MantenimientoPerfilUsuarioJDialog();
        mttoPerfilesUsuario.setGrafico(this);
        mttoPerfilesUsuario.inicializarListaElementos(this.getPerfilesUsuarioInvolucrados());
        mttoPerfilesUsuario.activarSeleccion(false);
        mttoPerfilesUsuario.setLocationRelativeTo(null);
        mttoPerfilesUsuario.setVisible(true);
    }

    public void mantenimientoMetafases() {
        MantenimientoMetafasesJDialog mttoMetafases = new MantenimientoMetafasesJDialog();
        mttoMetafases.setGrafico(this);
        mttoMetafases.inicializarListaElementos(this.getMetafasesInvolucradas());
        mttoMetafases.activarSeleccion(false);
        mttoMetafases.setLocationRelativeTo(null);
        mttoMetafases.setVisible(true);
        mttoMetafases.refrescarGrafico();
    }

    public void mantenimientoFases() {
        MantenimientoFasesJDialog mttoFases = new MantenimientoFasesJDialog();
        mttoFases.inicializarListaElementos(this.getFasesInvolucradas());
        mttoFases.setGrafico(this);
        mttoFases.activarSeleccion(false);
        mttoFases.setLocationRelativeTo(null);
        mttoFases.setVisible(true);
        mttoFases.refrescarGrafico();
    }

    public void mantenimientoTransiciones() {
        MantenimientoTransicionJDialog mttoTransiciones = new MantenimientoTransicionJDialog(false);
        mttoTransiciones.setDesdeUtilidadGrf(false);
        mttoTransiciones.inicializarListaElementos(this.getTransicionesInvolucradas());
        mttoTransiciones.setGrafico(this);
        mttoTransiciones.activarSeleccion(false);
        mttoTransiciones.setLocationRelativeTo(null);
        mttoTransiciones.setVisible(true);
    }

    public void mantenimientoAcciones() {
        MantenimientoAccionJDialog mttoAccionUsuario = new MantenimientoAccionJDialog();
        mttoAccionUsuario.setGrafico(this);
        mttoAccionUsuario.inicializarListaElementos(this.getAccionesInvolucradas());
        mttoAccionUsuario.activarSeleccion(false);
        mttoAccionUsuario.setLocationRelativeTo(null);
        mttoAccionUsuario.setVisible(true);
    }

    public void mantenimientoCondiciones() {
        MantenimientoCondicionJDialog mttoCondicionUsuario = new MantenimientoCondicionJDialog();
        mttoCondicionUsuario.setGrafico(this);
        mttoCondicionUsuario.inicializarListaElementos(this.getCondicionesInvolucradas());
        mttoCondicionUsuario.activarSeleccion(false);
        mttoCondicionUsuario.setLocationRelativeTo(null);
        mttoCondicionUsuario.setVisible(true);
    }

    public void mantenimientoTareas() {
        MantenimientoTareaJDialog mttoTareaJDialog = new MantenimientoTareaJDialog();
        mttoTareaJDialog.setGrafico(this);
        mttoTareaJDialog.inicializarListaElementos(this.getTareasInvolucradas());
        mttoTareaJDialog.activarSeleccion(false);
        mttoTareaJDialog.setLocationRelativeTo(null);
        mttoTareaJDialog.setModal(true);
        mttoTareaJDialog.setVisible(true);
    }

    public void mantenimientoTiposActo() {
        MantenimientoTipoActoJDialog mttoTipoActoJDialog = new MantenimientoTipoActoJDialog();
        mttoTipoActoJDialog.setGrafico(this);
        mttoTipoActoJDialog.inicializarListaElementos(this.getTiposActoInvolucrados());
        mttoTipoActoJDialog.activarSeleccion(false);
        mttoTipoActoJDialog.setLocationRelativeTo(null);
        mttoTipoActoJDialog.setModal(true);
        mttoTipoActoJDialog.setVisible(true);
    }

    public void mantenimientoParametros() {
        MantenimientoParametrosJDialog mttoParametrosJDialog = new MantenimientoParametrosJDialog();
        mttoParametrosJDialog.inicializarListaElementos(this.getParametrosInvolucrados());
        mttoParametrosJDialog.setGrafico(this);
        mttoParametrosJDialog.setLocationRelativeTo(null);
        mttoParametrosJDialog.setModal(true);
        mttoParametrosJDialog.activarSeleccion(false);
        mttoParametrosJDialog.setVisible(true);
    }

    public void mantenimientoBloques() {
        MantenimientoBloquesJDialog mttoBloquesJDialog = new MantenimientoBloquesJDialog();
        mttoBloquesJDialog.setGrafico(this);
        mttoBloquesJDialog.inicializarListaElementos(this.getBloquesInvolucrados());
        mttoBloquesJDialog.setLocationRelativeTo(null);
        mttoBloquesJDialog.setModal(true);
        mttoBloquesJDialog.activarSeleccion(false);
        mttoBloquesJDialog.setVisible(true);
    }

    public void mantenimientoAvisos() {
        MantenimientoAvisoJDialog mttoAvisoJDialog = new MantenimientoAvisoJDialog();
        mttoAvisoJDialog.setGrafico(this);
        mttoAvisoJDialog.inicializarListaElementos(this.getAvisosInvolucrados());
        mttoAvisoJDialog.activarSeleccion(false);
        mttoAvisoJDialog.setLocationRelativeTo(null);
        mttoAvisoJDialog.setVisible(true);
    }

    public void mantenimientoPlantillas() {
        MantenimientoPlantillaJDialog mttoPlantillasJDialog = new MantenimientoPlantillaJDialog();
        mttoPlantillasJDialog.setGrafico(this);
        mttoPlantillasJDialog.inicializarListaElementos(this.getPlantillasInvolucradas());
        mttoPlantillasJDialog.activarSeleccion(false);
        mttoPlantillasJDialog.setLocationRelativeTo(null);
        mttoPlantillasJDialog.setVisible(true);
    }

    public void mantenimientoTipoParrafos() {
        MantenimientoTipoParrafoJDialog mttoTipoParrafoJDialog = new MantenimientoTipoParrafoJDialog();
        mttoTipoParrafoJDialog.setGrafico(this);
        mttoTipoParrafoJDialog.inicializarListaElementos(this.getTipoParrafosInvolucrados());
        mttoTipoParrafoJDialog.activarSeleccion(false);
        mttoTipoParrafoJDialog.setLocationRelativeTo(null);
        mttoTipoParrafoJDialog.setVisible(true);
    }

    public void mantenimientoTipoDocumento() {
        MantenimientoTipoDocumentoJDialog mttoTipoDocumentoJDialog = new MantenimientoTipoDocumentoJDialog();
        mttoTipoDocumentoJDialog.setGrafico(this);
        mttoTipoDocumentoJDialog.inicializarListaElementos(this.getTipoDocumentosInvolucrados());
        mttoTipoDocumentoJDialog.activarSeleccion(false);
        mttoTipoDocumentoJDialog.setLocationRelativeTo(null);
        mttoTipoDocumentoJDialog.setVisible(true);
    }

    public void mantenimientoVariables() {
        MantenimientoVariablesJDialog mttoVariablesJDialog = new MantenimientoVariablesJDialog();
        mttoVariablesJDialog.setGrafico(this);
        mttoVariablesJDialog.inicializarListaElementos(this.getVariablesInvolucradas());
        mttoVariablesJDialog.setLocationRelativeTo(null);
        mttoVariablesJDialog.setModal(true);
        mttoVariablesJDialog.activarSeleccion(false);
        mttoVariablesJDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        super.finalize();
    }

    public void setParametrosInvolucrados(ConjuntoDatosModela nuevosParametros) {
        this.conjuntoDatosGlobal.setParametrosInvolucrados(nuevosParametros);
    }

    public ConjuntoDatosModela getParametrosInvolucrados() {
        return this.conjuntoDatosGlobal.getParametrosInvolucrados();
    }

    public void setBloquesInvolucrados(ConjuntoDatosModela nuevosBloques) {
        this.conjuntoDatosGlobal.setBloquesInvolucrados(nuevosBloques);
    }

    public ConjuntoDatosModela getBloquesInvolucrados() {
        return this.conjuntoDatosGlobal.getBloquesInvolucrados();
    }

    public void establecerMetafaseActiva(TrMetafase nuevaMetafaseActiva) {
        this.metafaseActiva = nuevaMetafaseActiva;
    }

    public TrMetafase getMetafaseActiva() {
        return this.metafaseActiva;
    }

    public TrMetafase obtenerMetafaseActiva() {
        if (this.metafaseActiva != null) {
            this.metafaseActiva.setDefaultMetafase(true);
            return this.metafaseActiva;
        }
        if (this.getMetafasesInvolucradas() != null && this.getMetafasesInvolucradas().getListaDatos().size() > 0) {
            this.metafaseActiva = (TrMetafase)this.getMetafasesInvolucradas().obtenerDato(0);
            this.metafaseActiva.setDefaultMetafase(true);
            return this.metafaseActiva;
        }
        this.metafaseActiva = new TrMetafase();
        this.metafaseActiva.setNOMBRE("METAFASE 1");
        this.metafaseActiva.setDESCRIPCION("--");
        this.metafaseActiva.setDefaultMetafase(true);
        this.getMetafasesInvolucradas().add(this.metafaseActiva);
        return this.metafaseActiva;
    }

    public void setAvisosInvolucrados(ConjuntoDatosModela nuevosAvisos) {
        this.conjuntoDatosGlobal.setAvisosInvolucrados(nuevosAvisos);
    }

    public ConjuntoDatosModela getAvisosInvolucrados() {
        return this.conjuntoDatosGlobal.getAvisosInvolucrados();
    }

    public void setPlantillasInvolucradas(ConjuntoDatosModela nuevasPlantillas) {
        this.conjuntoDatosGlobal.setPlantillasInvolucradas(nuevasPlantillas);
    }

    public ConjuntoDatosModela getPlantillasInvolucradas() {
        return this.conjuntoDatosGlobal.getPlantillasInvolucradas();
    }

    public void setModulosReutilizables(ConjuntoDatos nuevosModulosReutilizables) {
        this.ModulosReutilizables = nuevosModulosReutilizables;
    }

    public ConjuntoDatos getModulosReutilizables() {
        ArrayList listaReu = new ArrayList();
        listaReu = this.getDDPPadre() == null ? this.getListaDDPs() : this.getDDPPadre().getListaDDPs();
        ArrayList<DefProcGr> listaReuDDP = new ArrayList<DefProcGr>();
        if (listaReu != null) {
            for (int i = 0; i < listaReu.size(); ++i) {
                listaReuDDP.add(((DDPGrafico)listaReu.get(i)).getDDP());
            }
        }
        this.ModulosReutilizables = new ConjuntoDatos();
        this.ModulosReutilizables.setListaDatos(listaReuDDP);
        return this.ModulosReutilizables;
    }

    public void setTipoParrafosInvolucrados(ConjuntoDatosModela nuevosTipoParrafos) {
        this.conjuntoDatosGlobal.setTipoParrafosInvolucrados(nuevosTipoParrafos);
    }

    public ConjuntoDatosModela getTipoParrafosInvolucrados() {
        return this.conjuntoDatosGlobal.getTipoParrafosInvolucrados();
    }

    public void setTipoDocumentosInvolucrados(ConjuntoDatosModela nuevosTipoDocumentos) {
        this.conjuntoDatosGlobal.setTipoDocumentosInvolucrados(nuevosTipoDocumentos);
    }

    public ConjuntoDatosModela getTipoDocumentosInvolucrados() {
        return this.conjuntoDatosGlobal.getTipoDocumentosInvolucrados();
    }

    public ConjuntoDatosModela getVariablesInvolucradas() {
        return this.conjuntoDatosGlobal.getVariablesInvolucradas();
    }

    public void setVariablesInvolucradas(ConjuntoDatosModela nuevasVariables) {
        this.conjuntoDatosGlobal.setVariablesInvolucradas(nuevasVariables);
    }

    public ConjuntoDatosTiposOrganismo getTiposOrganismoInvolucrados() {
        return this.conjuntoDatosGlobal.getTiposOrganismoInvolucrados();
    }

    public ConjuntoDatosOrganismo getOrganismosInvolucrados() {
        return this.conjuntoDatosGlobal.getOrganismosInvolucrados();
    }

    public ConjuntoDatosTiposIndicacion getTiposIndicacionInvolucrados() {
        return this.conjuntoDatosGlobal.getTiposIndicacionInvolucrados();
    }

    public ConjuntoDatosTiposNormativa getTiposNormativaInvolucrados() {
        return this.conjuntoDatosGlobal.getTiposNormativaInvolucrados();
    }

    public ConjuntoDatosTiposPublicacion getTiposPublicacionInvolucrados() {
        return this.conjuntoDatosGlobal.getTiposPublicacionInvolucrados();
    }

    public ConjuntoDatosNormativa getNormativasInvolucradas() {
        return this.conjuntoDatosGlobal.getNormativasInvolucradas();
    }

    public ConjuntoDatosAmbitosLey getAmbitosLeyInvolucrados() {
        return this.conjuntoDatosGlobal.getAmbitosLeyInvolucrados();
    }

    public void setTiposOrganismoInvolucrados(ConjuntoDatosTiposOrganismo nuevoConjunto) {
        this.conjuntoDatosGlobal.setTiposOrganismoInvolucrados(nuevoConjunto);
    }

    public void setOrganismosInvolucrados(ConjuntoDatosOrganismo nuevoConjunto) {
        this.conjuntoDatosGlobal.setOrganismosInvolucrados(nuevoConjunto);
    }

    public void setTiposIndicacionInvolucrados(ConjuntoDatosTiposIndicacion nuevoConjunto) {
        this.conjuntoDatosGlobal.setTiposIndicacionInvolucrados(nuevoConjunto);
    }

    public void setTiposNormativaInvolucrados(ConjuntoDatosTiposNormativa nuevoConjunto) {
        this.conjuntoDatosGlobal.setTiposNormativaInvolucrados(nuevoConjunto);
    }

    public void setTiposPublicacionInvolucrados(ConjuntoDatosTiposPublicacion nuevoConjunto) {
        this.conjuntoDatosGlobal.setTiposPublicacionInvolucrados(nuevoConjunto);
    }

    public void setNormativasInvolucradas(ConjuntoDatosNormativa nuevoConjunto) {
        this.conjuntoDatosGlobal.setNormativasInvolucradas(nuevoConjunto);
    }

    public void setAmbitosLeyInvolucrados(ConjuntoDatosAmbitosLey nuevoConjunto) {
        this.conjuntoDatosGlobal.setAmbitosLeyInvolucrados(nuevoConjunto);
    }

    public void setArbolTiposEvolucion(ConjuntoDatosModela nuevoArbol) {
        this.conjuntoDatosGlobal.setArbolTiposEvolucion(nuevoArbol);
    }

    public ConjuntoDatosModela getArbolTiposEvolucion() {
        return this.conjuntoDatosGlobal.getArbolTiposEvolucion();
    }

    public ConjuntoDatosTransicionDefProcedimiento getTransicionesDelProcInvolucradas() {
        return this.TransicionesDefProcInvolucradas;
    }

    public void setTransicionesDelProcInvolucradas(ConjuntoDatosTransicionDefProcedimiento nuevasTransicionesDelProc) {
        this.TransicionesDefProcInvolucradas = nuevasTransicionesDelProc;
    }

    public ConjuntoDatosTareaFaseDefProcedimiento getTareaFaseDefProcInvolucradas() {
        return this.TareaFaseDefProcInvolucradas;
    }

    public void setTareaFaseDefProcInvolucradas(ConjuntoDatosTareaFaseDefProcedimiento nuevasFasesDefProc) {
        this.TareaFaseDefProcInvolucradas = nuevasFasesDefProc;
    }

    public ConjuntoDatosTarea getTareasInvolucradasEnCarga() {
        return this.tareasInvolucradasEnCarga;
    }

    public void setTareasInvolucradasEnCarga(ConjuntoDatosTarea nuevasTareasInvolucradasEnCarga) {
        this.tareasInvolucradasEnCarga = nuevasTareasInvolucradasEnCarga;
    }

    public ConjuntoDatosParametros getParametrosInvolucradosEnCarga() {
        return this.parametrosInvolucradosEnCarga;
    }

    public void setParametrosInvolucradosEnCarga(ConjuntoDatosParametros nuevosParametrosInvolucradosEnCarga) {
        this.parametrosInvolucradosEnCarga = nuevosParametrosInvolucradosEnCarga;
    }

    public ConjuntoDatosTipoActo getTiposActoInvolucradosEnCarga() {
        return this.tiposActoInvolucradosEnCarga;
    }

    public void setTiposActoInvolucradosEnCarga(ConjuntoDatosTipoActo nuevosTiposActoInvolucradosEnCarga) {
        this.tiposActoInvolucradosEnCarga = nuevosTiposActoInvolucradosEnCarga;
    }

    public ConjuntoDatosTiposParrafo getTiposParrafoInvolucradosEnCarga() {
        return this.tiposParrafoInvolucradosEnCarga;
    }

    public void setTiposParrafoInvolucradosEnCarga(ConjuntoDatosTiposParrafo nuevoCd) {
        this.tiposParrafoInvolucradosEnCarga = nuevoCd;
    }

    public ConjuntoDatosPlantillas getPlantillasInvolucradasEnCarga() {
        return this.plantillasInvolucradasEnCarga;
    }

    public void setPlantillasInvolucradasEnCarga(ConjuntoDatosPlantillas nuevoCd) {
        this.plantillasInvolucradasEnCarga = nuevoCd;
    }

    public ConjuntoDatosVariables getVariablesInvolucradasEnCarga() {
        return this.variablesInvolucradasEnCarga;
    }

    public void setVariablesInvolucradasEnCarga(ConjuntoDatosVariables nuevoCd) {
        this.variablesInvolucradasEnCarga = nuevoCd;
    }

    public ConjuntoDatosTiposOrganismo getTiposOrganismoInvolucradosEnCarga() {
        return this.tiposOrganismoInvolucradosEnCarga;
    }

    public void setTiposOrganismoInvolucradosEnCarga(ConjuntoDatosTiposOrganismo nuevoCd) {
        this.tiposOrganismoInvolucradosEnCarga = nuevoCd;
    }

    public ConjuntoDatosOrganismo getOrganismosInvolucradosEnCarga() {
        return this.organismosInvolucradosEnCarga;
    }

    public void setOrganismosInvolucradosEnCarga(ConjuntoDatosOrganismo nuevoCd) {
        this.organismosInvolucradosEnCarga = nuevoCd;
    }

    public ConjuntoDatosTiposIndicacion getTiposIndicacionInvolucradosEnCarga() {
        return this.tiposIndicacionInvolucradosEnCarga;
    }

    public void setTiposIndicacionInvolucradosEnCarga(ConjuntoDatosTiposIndicacion nuevoCd) {
        this.tiposIndicacionInvolucradosEnCarga = nuevoCd;
    }

    public ConjuntoDatosTiposNormativa getTiposNormativaInvolucradosEnCarga() {
        return this.tiposNormativaInvolucradosEnCarga;
    }

    public void setTiposNormativaInvolucradosEnCarga(ConjuntoDatosTiposNormativa nuevoCd) {
        this.tiposNormativaInvolucradosEnCarga = nuevoCd;
    }

    public ConjuntoDatosTiposPublicacion getTiposPublicacionInvolucradosEnCarga() {
        return this.tiposPublicacionInvolucradosEnCarga;
    }

    public void setTiposPublicacionInvolucradosEnCarga(ConjuntoDatosTiposPublicacion nuevoCd) {
        this.tiposPublicacionInvolucradosEnCarga = nuevoCd;
    }

    public ConjuntoDatosAmbitosLey getAmbitosLeyInvolucradosEnCarga() {
        return this.ambitosLeyInvolucradosEnCarga;
    }

    public void setAmbitosLeyInvolucradosEnCarga(ConjuntoDatosAmbitosLey nuevoCd) {
        this.ambitosLeyInvolucradosEnCarga = nuevoCd;
    }

    public ConjuntoDatosNormativa getNormativasInvolucradasEnCarga() {
        return this.normativasInvolucradasEnCarga;
    }

    public void setNormativasInvolucradasEnCarga(ConjuntoDatosNormativa nuevoCd) {
        this.normativasInvolucradasEnCarga = nuevoCd;
    }

    public void addDDP(DDPGrafico nuevoDDP) {
        if (nuevoDDP == null) {
            return;
        }
        this.listaDDPs.add(nuevoDDP);
    }

    public DDPGrafico obtenerDDPReutilizable(BigDecimal idDDPbuscado) {
        if (this.listaDDPs == null) {
            return null;
        }
        for (int n = 0; n < this.listaDDPs.size(); ++n) {
            if (((DDPGrafico)this.listaDDPs.get(n)).getDDP() == null || ((DDPGrafico)this.listaDDPs.get(n)).getDDP().getTIPOEVOL() == null || ((DDPGrafico)this.listaDDPs.get(n)).getDDP().getTIPOEVOL().getTIEVID().longValue() != idDDPbuscado.longValue()) continue;
            return (DDPGrafico)this.listaDDPs.get(n);
        }
        return null;
    }

    public boolean obtenerValidezTipoEvolucion(TrFase faseAValidar) {
        if (faseAValidar == null) {
            return true;
        }
        if (faseAValidar.getTIPOEVOL() != null && this != null) {
            ArrayList listaReutili = new ArrayList();
            DDPGrafico graficoAux = null;
            listaReutili = this.getDDPPadre() == null ? this.getListaDDPs() : this.getDDPPadre().getListaDDPs();
            TrFase faseBuscada = null;
            for (int g = 0; g < listaReutili.size(); ++g) {
                graficoAux = (DDPGrafico)listaReutili.get(g);
                faseBuscada = (TrFase)graficoAux.getFasesInvolucradasGr().obtenerDato(faseAValidar.getFASEID());
                if (faseBuscada == null || faseAValidar.getTIPOEVOL().getTIEVID().longValue() != graficoAux.getDDP().getTIPOEVOL().getTIEVID().longValue()) continue;
                return false;
            }
        }
        return true;
    }

    public void eliminarDDP(DDPGrafico delDDP) {
        if (delDDP == null) {
            return;
        }
        this.listaDDPs.remove(delDDP);
    }

    public ArrayList getListaDDPs() {
        return this.listaDDPs;
    }

    public void setListaDDPs(ArrayList nuevaLista) {
        this.listaDDPs = nuevaLista;
    }

    public ArrayList obtenerReutilizablesAsociados(boolean bCerrandoDefinicion) {
        if (!bCerrandoDefinicion && this.getDDPPadre() == null) {
            return this.getListaDDPs();
        }
        ArrayList<DDPGrafico> arrReuti = new ArrayList<DDPGrafico>();
        DDPGrafico ddpReutilizable = null;
        TrFase faseAux = null;
        for (int f = 0; f < this.getFasesInvolucradasGr().listaDatos.size(); ++f) {
            faseAux = (TrFase)this.getFasesInvolucradasGr().listaDatos.get(f);
            if (faseAux.getTIPOEVOL() == null || (ddpReutilizable = this.getDDPPadre() == null ? this.obtenerDDPReutilizable(faseAux.getTIPOEVOL().getTIEVID()) : this.getDDPPadre().obtenerDDPReutilizable(faseAux.getTIPOEVOL().getTIEVID())) == null || arrReuti.contains(ddpReutilizable)) continue;
            arrReuti.add(ddpReutilizable);
        }
        return arrReuti;
    }

    public ConjuntoDatosModela getPerfilesUsuarioInvolucradosGr() {
        int n2;
        Referencia perfilTrans;
        ArrayList listaPerfilTrans;
        int n;
        boolean recorrerTransicionesProc = true;
        boolean recorrerTareasEnFaseProc = true;
        boolean recorrerConjuntoPerfiles = true;
        ConjuntoDatosPerfilUsuario cdPerfiles = new ConjuntoDatosPerfilUsuario();
        ArrayList<TrPerfilUsuario> listaPerfilesFinal = new ArrayList<TrPerfilUsuario>();
        cdPerfiles.setListaDatos(listaPerfilesFinal);
        if (this.TransicionesDefProcInvolucradas == null) {
            recorrerTransicionesProc = false;
        }
        if (this.TransicionesDefProcInvolucradas.getListaDatos() == null) {
            recorrerTransicionesProc = false;
        }
        if (this.TransicionesDefProcInvolucradas.getListaDatos().size() < 1) {
            recorrerTransicionesProc = false;
        }
        if (recorrerTransicionesProc) {
            ArrayList listaTransiProc = this.TransicionesDefProcInvolucradas.getListaDatos();
            TrTransicionDefProcedimiento transiProc = null;
            for (n = 0; n < listaTransiProc.size(); ++n) {
                transiProc = (TrTransicionDefProcedimiento)listaTransiProc.get(n);
                recorrerConjuntoPerfiles = true;
                if (transiProc.getConjuntoPerfilTransEvol() == null) {
                    recorrerConjuntoPerfiles = false;
                }
                if (transiProc.getConjuntoPerfilTransEvol().getListaDatos() == null) {
                    recorrerConjuntoPerfiles = false;
                }
                if (transiProc.getConjuntoPerfilTransEvol().getListaDatos().size() < 1) {
                    recorrerConjuntoPerfiles = false;
                }
                if (!recorrerConjuntoPerfiles) continue;
                listaPerfilTrans = transiProc.getConjuntoPerfilTransEvol().getListaDatos();
                perfilTrans = null;
                for (n2 = 0; n2 < listaPerfilTrans.size(); ++n2) {
                    perfilTrans = (TrPerfilTransEvol)listaPerfilTrans.get(n2);
                    if (listaPerfilesFinal.contains(((TrPerfilTransEvol)perfilTrans).getPERFIL())) continue;
                    listaPerfilesFinal.add(((TrPerfilTransEvol)perfilTrans).getPERFIL());
                }
            }
        }
        if (this.TareaFaseDefProcInvolucradas == null) {
            recorrerTareasEnFaseProc = false;
        }
        if (this.TareaFaseDefProcInvolucradas.getListaDatos() == null) {
            recorrerTareasEnFaseProc = false;
        }
        if (this.TareaFaseDefProcInvolucradas.getListaDatos().size() < 1) {
            recorrerTareasEnFaseProc = false;
        }
        if (recorrerTareasEnFaseProc) {
            ArrayList listaTareasProc = this.TareaFaseDefProcInvolucradas.getListaDatos();
            TrTareaEnFaseDefProcedimiento tareaProc = null;
            for (n = 0; n < listaTareasProc.size(); ++n) {
                tareaProc = (TrTareaEnFaseDefProcedimiento)listaTareasProc.get(n);
                recorrerConjuntoPerfiles = true;
                if (tareaProc.getConjuntoPerfilesTareaFase() == null) {
                    recorrerConjuntoPerfiles = false;
                }
                if (tareaProc.getConjuntoPerfilesTareaFase().getListaDatos() == null) {
                    recorrerConjuntoPerfiles = false;
                }
                if (tareaProc.getConjuntoPerfilesTareaFase().getListaDatos().size() < 1) {
                    recorrerConjuntoPerfiles = false;
                }
                if (!recorrerConjuntoPerfiles) continue;
                listaPerfilTrans = tareaProc.getConjuntoPerfilesTareaFase().getListaDatos();
                perfilTrans = null;
                for (n2 = 0; n2 < listaPerfilTrans.size(); ++n2) {
                    perfilTrans = (TrPerfilTareaFase)listaPerfilTrans.get(n2);
                    if (listaPerfilesFinal.contains(((TrPerfilTareaFase)perfilTrans).getPERFIL())) continue;
                    listaPerfilesFinal.add(((TrPerfilTareaFase)perfilTrans).getPERFIL());
                }
            }
        }
        return cdPerfiles;
    }

    public ConjuntoDatosTipoActo getTiposActoInvolucradosGr() {
        ConjuntoDatosModela cdVariablesAux;
        boolean recorrerTransicionesProc = true;
        boolean recorrerVariables = true;
        ConjuntoDatosTipoActo cdTiposActo = new ConjuntoDatosTipoActo();
        ArrayList<TrTipoActo> listaTiposActoFinal = new ArrayList<TrTipoActo>();
        cdTiposActo.setListaDatos(listaTiposActoFinal);
        TrTipoActo tipoActo = null;
        if (this.TransicionesDefProcInvolucradas == null) {
            recorrerTransicionesProc = false;
        }
        if (this.TransicionesDefProcInvolucradas.getListaDatos() == null) {
            recorrerTransicionesProc = false;
        }
        if (this.TransicionesDefProcInvolucradas.getListaDatos().size() < 1) {
            recorrerTransicionesProc = false;
        }
        if (recorrerTransicionesProc) {
            ArrayList listaTransiProc = this.TransicionesDefProcInvolucradas.getListaDatos();
            TrTransicionDefProcedimiento transiProc = null;
            for (int n = 0; n < listaTransiProc.size(); ++n) {
                transiProc = (TrTransicionDefProcedimiento)listaTransiProc.get(n);
                if (transiProc.getTransicion() == null || (tipoActo = transiProc.getTransicion().getTipoActo()) == null || listaTiposActoFinal.contains(tipoActo)) continue;
                listaTiposActoFinal.add(tipoActo);
            }
        }
        if ((cdVariablesAux = this.getVariablesInvolucradasGr()) == null || cdVariablesAux.getListaDatos() == null || cdVariablesAux.getListaDatos().size() < 1) {
            recorrerVariables = false;
        }
        if (recorrerVariables) {
            ArrayList listaVariables = new ArrayList();
            if (cdVariablesAux != null) {
                listaVariables = cdVariablesAux.getListaDatos();
            }
            TrVariable variable = null;
            for (int n = 0; n < listaVariables.size(); ++n) {
                variable = (TrVariable)listaVariables.get(n);
                if (variable.getTipoActo() == null || listaTiposActoFinal.contains(tipoActo = variable.getTipoActo())) continue;
                listaTiposActoFinal.add(tipoActo);
            }
        }
        return cdTiposActo;
    }

    public ConjuntoDatosModela getCondicionesInvolucradasGr() {
        int n;
        boolean recorrerTransicionesProc = true;
        boolean recorrerTareasEnFaseProc = true;
        boolean recorrerConjuntoCondiciones = true;
        ConjuntoDatosCondicion cdCondiciones = new ConjuntoDatosCondicion();
        ArrayList<TrCondicion> listaCondicionesFinal = new ArrayList<TrCondicion>();
        cdCondiciones.setListaDatos(listaCondicionesFinal);
        if (this.TransicionesDefProcInvolucradas == null) {
            recorrerTransicionesProc = false;
        }
        if (this.TransicionesDefProcInvolucradas.getListaDatos() == null) {
            recorrerTransicionesProc = false;
        }
        if (this.TransicionesDefProcInvolucradas.getListaDatos().size() < 1) {
            recorrerTransicionesProc = false;
        }
        if (recorrerTransicionesProc) {
            ArrayList listaTransiProc = this.TransicionesDefProcInvolucradas.getListaDatos();
            TrTransicionDefProcedimiento transiProc = null;
            for (n = 0; n < listaTransiProc.size(); ++n) {
                transiProc = (TrTransicionDefProcedimiento)listaTransiProc.get(n);
                recorrerConjuntoCondiciones = true;
                if (transiProc.getConjuntoCondicionTransicion() == null) {
                    recorrerConjuntoCondiciones = false;
                }
                if (transiProc.getConjuntoCondicionTransicion().getListaDatos() == null) {
                    recorrerConjuntoCondiciones = false;
                }
                if (transiProc.getConjuntoCondicionTransicion().getListaDatos().size() < 1) {
                    recorrerConjuntoCondiciones = false;
                }
                if (!recorrerConjuntoCondiciones) continue;
                ArrayList listaCondicionesTrans = transiProc.getConjuntoCondicionTransicion().getListaDatos();
                TrCondicionTransicion condicionTrans = null;
                TrCondicion condicion = null;
                for (int n2 = 0; n2 < listaCondicionesTrans.size(); ++n2) {
                    condicionTrans = (TrCondicionTransicion)listaCondicionesTrans.get(n2);
                    condicion = condicionTrans.getCondicion();
                    if (condicion == null || listaCondicionesFinal.contains(condicion)) continue;
                    listaCondicionesFinal.add(condicion);
                }
            }
        }
        if (this.TareaFaseDefProcInvolucradas == null) {
            recorrerTareasEnFaseProc = false;
        }
        if (this.TareaFaseDefProcInvolucradas.getListaDatos() == null) {
            recorrerTareasEnFaseProc = false;
        }
        if (this.TareaFaseDefProcInvolucradas.getListaDatos().size() < 1) {
            recorrerTareasEnFaseProc = false;
        }
        if (recorrerTareasEnFaseProc) {
            ArrayList listaTareasProc = this.TareaFaseDefProcInvolucradas.getListaDatos();
            TrTareaEnFaseDefProcedimiento tareaProc = null;
            for (n = 0; n < listaTareasProc.size(); ++n) {
                tareaProc = (TrTareaEnFaseDefProcedimiento)listaTareasProc.get(n);
                recorrerConjuntoCondiciones = true;
                if (tareaProc.getConjuntoCondicionTareaFase() == null) {
                    recorrerConjuntoCondiciones = false;
                }
                if (tareaProc.getConjuntoCondicionTareaFase().getListaDatos() == null) {
                    recorrerConjuntoCondiciones = false;
                }
                if (tareaProc.getConjuntoCondicionTareaFase().getListaDatos().size() < 1) {
                    recorrerConjuntoCondiciones = false;
                }
                if (!recorrerConjuntoCondiciones) continue;
                ArrayList listaCondicionesTarea = tareaProc.getConjuntoCondicionTareaFase().getListaDatos();
                TrCondicionTareaFase condicionTarea = null;
                for (int n2 = 0; n2 < listaCondicionesTarea.size(); ++n2) {
                    condicionTarea = (TrCondicionTareaFase)listaCondicionesTarea.get(n2);
                    if (condicionTarea == null || listaCondicionesFinal.contains(condicionTarea.getCondicion())) continue;
                    listaCondicionesFinal.add(condicionTarea.getCondicion());
                }
            }
        }
        return cdCondiciones;
    }

    public ConjuntoDatosModela getAccionesInvolucradasGr() {
        int n;
        boolean recorrerTransicionesProc = true;
        boolean recorrerTareasEnFaseProc = true;
        boolean recorrerConjuntoAcciones = true;
        ConjuntoDatosAccion cdAcciones = new ConjuntoDatosAccion();
        ArrayList<TrAccion> listaAccionesFinal = new ArrayList<TrAccion>();
        cdAcciones.setListaDatos(listaAccionesFinal);
        if (this.TransicionesDefProcInvolucradas == null) {
            recorrerTransicionesProc = false;
        }
        if (this.TransicionesDefProcInvolucradas.getListaDatos() == null) {
            recorrerTransicionesProc = false;
        }
        if (this.TransicionesDefProcInvolucradas.getListaDatos().size() < 1) {
            recorrerTransicionesProc = false;
        }
        if (recorrerTransicionesProc) {
            ArrayList listaTransiProc = this.TransicionesDefProcInvolucradas.getListaDatos();
            TrTransicionDefProcedimiento transiProc = null;
            for (n = 0; n < listaTransiProc.size(); ++n) {
                transiProc = (TrTransicionDefProcedimiento)listaTransiProc.get(n);
                recorrerConjuntoAcciones = true;
                if (transiProc.getConjuntoAccionTransicion() == null) {
                    recorrerConjuntoAcciones = false;
                }
                if (transiProc.getConjuntoAccionTransicion().getListaDatos() == null) {
                    recorrerConjuntoAcciones = false;
                }
                if (transiProc.getConjuntoAccionTransicion().getListaDatos().size() < 1) {
                    recorrerConjuntoAcciones = false;
                }
                if (!recorrerConjuntoAcciones) continue;
                ArrayList listaAccionesTrans = transiProc.getConjuntoAccionTransicion().getListaDatos();
                TrAccionTransicion accionTrans = null;
                TrAccion accion = null;
                for (int n2 = 0; n2 < listaAccionesTrans.size(); ++n2) {
                    accionTrans = (TrAccionTransicion)listaAccionesTrans.get(n2);
                    accion = accionTrans.getAccion();
                    if (accion == null || listaAccionesFinal.contains(accion)) continue;
                    listaAccionesFinal.add(accion);
                }
            }
        }
        if (this.TareaFaseDefProcInvolucradas == null) {
            recorrerTareasEnFaseProc = false;
        }
        if (this.TareaFaseDefProcInvolucradas.getListaDatos() == null) {
            recorrerTareasEnFaseProc = false;
        }
        if (this.TareaFaseDefProcInvolucradas.getListaDatos().size() < 1) {
            recorrerTareasEnFaseProc = false;
        }
        if (recorrerTareasEnFaseProc) {
            ArrayList listaTareasProc = this.TareaFaseDefProcInvolucradas.getListaDatos();
            TrTareaEnFaseDefProcedimiento tareaProc = null;
            for (n = 0; n < listaTareasProc.size(); ++n) {
                tareaProc = (TrTareaEnFaseDefProcedimiento)listaTareasProc.get(n);
                recorrerConjuntoAcciones = true;
                if (tareaProc.getConjuntoAccionTareaFase() == null) {
                    recorrerConjuntoAcciones = false;
                }
                if (tareaProc.getConjuntoAccionTareaFase().getListaDatos() == null) {
                    recorrerConjuntoAcciones = false;
                }
                if (tareaProc.getConjuntoAccionTareaFase().getListaDatos().size() < 1) {
                    recorrerConjuntoAcciones = false;
                }
                if (!recorrerConjuntoAcciones) continue;
                ArrayList listaAccionesTarea = tareaProc.getConjuntoAccionTareaFase().getListaDatos();
                TrAccionTareaFase accionTarea = null;
                for (int n2 = 0; n2 < listaAccionesTarea.size(); ++n2) {
                    accionTarea = (TrAccionTareaFase)listaAccionesTarea.get(n2);
                    if (listaAccionesFinal.contains(accionTarea.getAccion())) continue;
                    listaAccionesFinal.add(accionTarea.getAccion());
                }
            }
        }
        return cdAcciones;
    }

    public ConjuntoDatosModela getAvisosInvolucradosGr() {
        int n;
        boolean recorrerTransicionesProc = true;
        boolean recorrerTareasEnFaseProc = true;
        boolean recorrerConjuntoAvisos = true;
        ConjuntoDatosModela cdAvisos = new ConjuntoDatosModela();
        ArrayList<TrAviso> listaAvisosFinal = new ArrayList<TrAviso>();
        cdAvisos.setListaDatos(listaAvisosFinal);
        if (this.TransicionesDefProcInvolucradas == null) {
            recorrerTransicionesProc = false;
        }
        if (this.TransicionesDefProcInvolucradas.getListaDatos() == null) {
            recorrerTransicionesProc = false;
        }
        if (this.TransicionesDefProcInvolucradas.getListaDatos().size() < 1) {
            recorrerTransicionesProc = false;
        }
        if (recorrerTransicionesProc) {
            ArrayList listaTransiProc = this.TransicionesDefProcInvolucradas.getListaDatos();
            TrTransicionDefProcedimiento transiProc = null;
            for (n = 0; n < listaTransiProc.size(); ++n) {
                transiProc = (TrTransicionDefProcedimiento)listaTransiProc.get(n);
                recorrerConjuntoAvisos = true;
                if (transiProc.getConjuntoAvisoTransicion() == null) {
                    recorrerConjuntoAvisos = false;
                }
                if (transiProc.getConjuntoAvisoTransicion().getListaDatos() == null) {
                    recorrerConjuntoAvisos = false;
                }
                if (transiProc.getConjuntoAvisoTransicion().getListaDatos().size() < 1) {
                    recorrerConjuntoAvisos = false;
                }
                if (!recorrerConjuntoAvisos) continue;
                ArrayList listaAvisosTrans = transiProc.getConjuntoAvisoTransicion().getListaDatos();
                TrAvisoTransicion avisoTrans = null;
                TrAviso aviso = null;
                for (int n2 = 0; n2 < listaAvisosTrans.size(); ++n2) {
                    avisoTrans = (TrAvisoTransicion)listaAvisosTrans.get(n2);
                    aviso = avisoTrans.getAviso();
                    if (aviso == null || listaAvisosFinal.contains(aviso)) continue;
                    listaAvisosFinal.add(aviso);
                }
            }
        }
        if (this.TareaFaseDefProcInvolucradas == null) {
            recorrerTareasEnFaseProc = false;
        }
        if (this.TareaFaseDefProcInvolucradas.getListaDatos() == null) {
            recorrerTareasEnFaseProc = false;
        }
        if (this.TareaFaseDefProcInvolucradas.getListaDatos().size() < 1) {
            recorrerTareasEnFaseProc = false;
        }
        if (recorrerTareasEnFaseProc) {
            ArrayList listaTareasProc = this.TareaFaseDefProcInvolucradas.getListaDatos();
            TrTareaEnFaseDefProcedimiento tareaProc = null;
            for (n = 0; n < listaTareasProc.size(); ++n) {
                tareaProc = (TrTareaEnFaseDefProcedimiento)listaTareasProc.get(n);
                recorrerConjuntoAvisos = true;
                if (tareaProc.getConjuntoAvisoTareaFase() == null) {
                    recorrerConjuntoAvisos = false;
                }
                if (tareaProc.getConjuntoAvisoTareaFase().getListaDatos() == null) {
                    recorrerConjuntoAvisos = false;
                }
                if (tareaProc.getConjuntoAvisoTareaFase().getListaDatos().size() < 1) {
                    recorrerConjuntoAvisos = false;
                }
                if (!recorrerConjuntoAvisos) continue;
                ArrayList listaAvisosTarea = tareaProc.getConjuntoAvisoTareaFase().getListaDatos();
                TrAvisoTareaFase avisoTarea = null;
                for (int n2 = 0; n2 < listaAvisosTarea.size(); ++n2) {
                    avisoTarea = (TrAvisoTareaFase)listaAvisosTarea.get(n2);
                    if (listaAvisosFinal.contains(avisoTarea.getAviso())) continue;
                    listaAvisosFinal.add(avisoTarea.getAviso());
                }
            }
        }
        return cdAvisos;
    }

    public ConjuntoDatosModela getMetafasesInvolucradasGr() {
        int n;
        boolean recorrerTransicionesProc = true;
        boolean recorrerTareasFaseProc = true;
        ConjuntoDatosMetafase cdMetafases = new ConjuntoDatosMetafase();
        ArrayList<TrMetafase> listaMetafasesFinal = new ArrayList<TrMetafase>();
        cdMetafases.setListaDatos(listaMetafasesFinal);
        if (this.canvasGrafico == null) {
            return cdMetafases;
        }
        ArrayList fasesEnCanvas = this.canvasGrafico.obtenerFases(true);
        if (fasesEnCanvas != null) {
            TrFase faseAux = null;
            for (int n2 = 0; n2 < fasesEnCanvas.size(); ++n2) {
                faseAux = (TrFase)fasesEnCanvas.get(n2);
                if (faseAux.getMETAFASE() == null || listaMetafasesFinal.contains(faseAux.getMETAFASE())) continue;
                listaMetafasesFinal.add(faseAux.getMETAFASE());
            }
        }
        if (this.TransicionesDefProcInvolucradas == null) {
            recorrerTransicionesProc = false;
        }
        if (this.TransicionesDefProcInvolucradas.getListaDatos() == null) {
            recorrerTransicionesProc = false;
        }
        if (this.TransicionesDefProcInvolucradas.getListaDatos().size() < 1) {
            recorrerTransicionesProc = false;
        }
        if (recorrerTransicionesProc) {
            ArrayList listaTransiProc = this.TransicionesDefProcInvolucradas.getListaDatos();
            TrTransicionDefProcedimiento transiProc = null;
            TrTransicion transicion = null;
            TrMetafase metafase = null;
            TrFase fase = null;
            for (n = 0; n < listaTransiProc.size(); ++n) {
                transiProc = (TrTransicionDefProcedimiento)listaTransiProc.get(n);
                if (transiProc.getTransicion() == null) continue;
                transicion = transiProc.getTransicion();
                fase = transicion.getTrFaseIni();
                if (fase != null && fase.getMETAFASE() != null && !listaMetafasesFinal.contains(metafase = fase.getMETAFASE())) {
                    listaMetafasesFinal.add(metafase);
                }
                if (!transicion.getTIPO().equals("D")) {
                    fase = transicion.getFaseFin();
                    if (fase == null || fase.getMETAFASE() == null || listaMetafasesFinal.contains(metafase = fase.getMETAFASE())) continue;
                    listaMetafasesFinal.add(metafase);
                    continue;
                }
                if (transicion.getConjuntoFasesFin() == null || transicion.getConjuntoFasesFin().getListaDatos() == null) continue;
                for (int nf = 0; nf < transicion.getConjuntoFasesFin().getListaDatos().size(); ++nf) {
                    fase = (TrFase)transicion.getConjuntoFasesFin().getListaDatos().get(nf);
                    if (fase == null || fase.getMETAFASE() == null || listaMetafasesFinal.contains(metafase = fase.getMETAFASE())) continue;
                    listaMetafasesFinal.add(metafase);
                }
            }
        }
        if (this.TareaFaseDefProcInvolucradas == null) {
            recorrerTareasFaseProc = false;
        }
        if (this.TareaFaseDefProcInvolucradas.getListaDatos() == null) {
            recorrerTareasFaseProc = false;
        }
        if (this.TareaFaseDefProcInvolucradas.getListaDatos().size() < 1) {
            recorrerTareasFaseProc = false;
        }
        if (recorrerTareasFaseProc) {
            ArrayList listaTareasProc = this.TareaFaseDefProcInvolucradas.getListaDatos();
            TrTareaEnFaseDefProcedimiento tareaProc = null;
            TrMetafase metafase = null;
            TrTareaEnFase tareaFase = null;
            for (n = 0; n < listaTareasProc.size(); ++n) {
                TrFase faseAct;
                tareaProc = (TrTareaEnFaseDefProcedimiento)listaTareasProc.get(n);
                if (tareaProc.getTareaEnFase() == null || (tareaFase = tareaProc.getTareaEnFase()).getFase() == null || (faseAct = tareaFase.getFase()) == null || (metafase = faseAct.getMETAFASE()) == null || listaMetafasesFinal.contains(metafase)) continue;
                listaMetafasesFinal.add(metafase);
            }
        }
        return cdMetafases;
    }

    public ConjuntoDatosModela getFasesInvolucradasGr() {
        int n;
        TrFase fase;
        boolean recorrerTransicionesProc = true;
        boolean recorrerTareasFaseProc = true;
        ConjuntoDatosFase cdFases = new ConjuntoDatosFase();
        ArrayList listaFasesFinal = new ArrayList();
        cdFases.setListaDatos(listaFasesFinal);
        if (this.canvasGrafico == null) {
            return cdFases;
        }
        ArrayList fasesEnCanvas = this.canvasGrafico.obtenerFases(true);
        if (fasesEnCanvas != null) {
            for (int n2 = 0; n2 < fasesEnCanvas.size(); ++n2) {
                if (listaFasesFinal.contains(fasesEnCanvas.get(n2))) continue;
                listaFasesFinal.add(fasesEnCanvas.get(n2));
            }
        }
        if (this.TransicionesDefProcInvolucradas == null) {
            recorrerTransicionesProc = false;
        }
        if (this.TransicionesDefProcInvolucradas.getListaDatos() == null) {
            recorrerTransicionesProc = false;
        }
        if (this.TransicionesDefProcInvolucradas.getListaDatos().size() < 1) {
            recorrerTransicionesProc = false;
        }
        if (recorrerTransicionesProc) {
            ArrayList listaTransiProc = this.TransicionesDefProcInvolucradas.getListaDatos();
            TrTransicionDefProcedimiento transiProc = null;
            fase = null;
            TrTransicion transicion = null;
            for (n = 0; n < listaTransiProc.size(); ++n) {
                transiProc = (TrTransicionDefProcedimiento)listaTransiProc.get(n);
                if (transiProc.getTransicion() == null) continue;
                transicion = transiProc.getTransicion();
                fase = transicion.getTrFaseIni();
                if (fase != null && !listaFasesFinal.contains(fase)) {
                    listaFasesFinal.add(fase);
                }
                if (!transicion.getTIPO().equals("D")) {
                    fase = transicion.getFaseFin();
                    if (fase == null || listaFasesFinal.contains(fase)) continue;
                    listaFasesFinal.add(fase);
                    continue;
                }
                if (transicion.getConjuntoFasesFin() == null || transicion.getConjuntoFasesFin().getListaDatos() == null) continue;
                for (int nf = 0; nf < transicion.getConjuntoFasesFin().getListaDatos().size(); ++nf) {
                    fase = (TrFase)transicion.getConjuntoFasesFin().getListaDatos().get(nf);
                    if (fase == null || listaFasesFinal.contains(fase)) continue;
                    listaFasesFinal.add(fase);
                }
            }
        }
        if (this.TareaFaseDefProcInvolucradas == null) {
            recorrerTareasFaseProc = false;
        }
        if (this.TareaFaseDefProcInvolucradas.getListaDatos() == null) {
            recorrerTareasFaseProc = false;
        }
        if (this.TareaFaseDefProcInvolucradas.getListaDatos().size() < 1) {
            recorrerTareasFaseProc = false;
        }
        if (recorrerTareasFaseProc) {
            ArrayList listaTareasProc = this.TareaFaseDefProcInvolucradas.getListaDatos();
            TrTareaEnFaseDefProcedimiento tareaProc = null;
            fase = null;
            TrTareaEnFase tareaFase = null;
            for (n = 0; n < listaTareasProc.size(); ++n) {
                tareaProc = (TrTareaEnFaseDefProcedimiento)listaTareasProc.get(n);
                if (tareaProc.getTareaEnFase() == null || (fase = (tareaFase = tareaProc.getTareaEnFase()).getFase()) == null || listaFasesFinal.contains(fase)) continue;
                listaFasesFinal.add(fase);
            }
        }
        return cdFases;
    }

    public ConjuntoDatosTransicion getTransicionesInvolucradasGr() {
        boolean recorrerTransicionesProc = true;
        ConjuntoDatosTransicion cdTransi = new ConjuntoDatosTransicion();
        ArrayList<TrTransicion> listaTransiFinal = new ArrayList<TrTransicion>();
        cdTransi.setListaDatos(listaTransiFinal);
        if (this.TransicionesDefProcInvolucradas == null) {
            recorrerTransicionesProc = false;
        }
        if (this.TransicionesDefProcInvolucradas.getListaDatos() == null) {
            recorrerTransicionesProc = false;
        }
        if (this.TransicionesDefProcInvolucradas.getListaDatos().size() < 1) {
            recorrerTransicionesProc = false;
        }
        if (recorrerTransicionesProc) {
            ArrayList listaTransiProc = this.TransicionesDefProcInvolucradas.getListaDatos();
            TrTransicionDefProcedimiento transiProc = null;
            TrTransicion transicion = null;
            for (int n = 0; n < listaTransiProc.size(); ++n) {
                transiProc = (TrTransicionDefProcedimiento)listaTransiProc.get(n);
                if (transiProc.getTransicion() == null || listaTransiFinal.contains(transicion = transiProc.getTransicion())) continue;
                listaTransiFinal.add(transicion);
            }
        }
        return cdTransi;
    }

    public ConjuntoDatosModela getParametrosInvolucradosGr() {
        ConjuntoDatosModela cdBloquesAux;
        boolean recorrerVariables = true;
        boolean recorrerBloques = true;
        ConjuntoDatosModela cdParametros = new ConjuntoDatosModela();
        ArrayList<TrParametro> listaParametrosFinal = new ArrayList<TrParametro>();
        cdParametros.setListaDatos(listaParametrosFinal);
        TrParametro parametro = null;
        ConjuntoDatosModela cdVariablesAux = this.getVariablesInvolucradasGr();
        if (cdVariablesAux == null || cdVariablesAux.getListaDatos() == null || cdVariablesAux.getListaDatos().size() < 1) {
            recorrerVariables = false;
        }
        if (recorrerVariables) {
            ArrayList listaVariables = new ArrayList();
            if (cdVariablesAux != null) {
                listaVariables = cdVariablesAux.getListaDatos();
            }
            ArrayList listaParametrosVariable = null;
            TrVariable variableAux = null;
            for (int n = 0; n < listaVariables.size(); ++n) {
                variableAux = (TrVariable)listaVariables.get(n);
                if (variableAux.getParametros() == null) continue;
                listaParametrosVariable = variableAux.getParametros();
                for (int n2 = 0; n2 < listaParametrosVariable.size(); ++n2) {
                    parametro = (TrParametro)listaParametrosVariable.get(n2);
                    if (listaParametrosFinal.contains(parametro)) continue;
                    listaParametrosFinal.add(parametro);
                }
            }
        }
        if ((cdBloquesAux = this.getBloquesInvolucradosGr()) == null || cdBloquesAux.getListaDatos() == null || cdBloquesAux.getListaDatos().size() < 1) {
            recorrerBloques = false;
        }
        if (recorrerBloques) {
            ArrayList listaBloques = new ArrayList();
            if (cdBloquesAux != null) {
                listaBloques = cdBloquesAux.getListaDatos();
            }
            ArrayList listaParametrosBloque = null;
            TrBloque bloqueAux = null;
            for (int n = 0; n < listaBloques.size(); ++n) {
                bloqueAux = (TrBloque)listaBloques.get(n);
                if (bloqueAux.getParametros() == null) continue;
                listaParametrosBloque = bloqueAux.getParametros();
                for (int n2 = 0; n2 < listaParametrosBloque.size(); ++n2) {
                    parametro = (TrParametro)listaParametrosBloque.get(n2);
                    if (listaParametrosFinal.contains(parametro)) continue;
                    listaParametrosFinal.add(parametro);
                }
            }
        }
        return cdParametros;
    }

    public ConjuntoDatosModela getBloquesInvolucradosGr() {
        boolean recorrerTareasEnFaseProc = true;
        ConjuntoDatosModela cdBloques = new ConjuntoDatosModela();
        ArrayList<TrBloque> listaBloquesFinal = new ArrayList<TrBloque>();
        cdBloques.setListaDatos(listaBloquesFinal);
        if (this.TareaFaseDefProcInvolucradas == null) {
            recorrerTareasEnFaseProc = false;
        }
        if (this.TareaFaseDefProcInvolucradas.getListaDatos() == null) {
            recorrerTareasEnFaseProc = false;
        }
        if (this.TareaFaseDefProcInvolucradas.getListaDatos().size() < 1) {
            recorrerTareasEnFaseProc = false;
        }
        if (recorrerTareasEnFaseProc) {
            ArrayList listaTareasProc = this.TareaFaseDefProcInvolucradas.getListaDatos();
            TrTareaEnFaseDefProcedimiento tareaProc = null;
            TrTareaEnFase tareaEnFase = null;
            TrBloquePermitido bloquePermitido = null;
            TrBloque bloque = null;
            for (int n = 0; n < listaTareasProc.size(); ++n) {
                tareaProc = (TrTareaEnFaseDefProcedimiento)listaTareasProc.get(n);
                tareaEnFase = tareaProc.getTareaEnFase();
                if (tareaEnFase == null) continue;
                if (tareaEnFase.getTarea() != null && tareaEnFase.getTarea() instanceof TrBloquePermitido) {
                    bloquePermitido = (TrBloquePermitido)tareaEnFase.getTarea();
                    bloque = bloquePermitido.getBloqueIni();
                    if (bloque != null && !listaBloquesFinal.contains(bloque)) {
                        listaBloquesFinal.add(bloque);
                    }
                    if ((bloque = bloquePermitido.getBloqueFin()) != null && !listaBloquesFinal.contains(bloque)) {
                        listaBloquesFinal.add(bloque);
                    }
                }
                if (tareaEnFase.getTareaLlamante() == null || !(tareaEnFase.getTareaLlamante() instanceof TrBloquePermitido)) continue;
                bloquePermitido = (TrBloquePermitido)tareaEnFase.getTareaLlamante();
                bloque = bloquePermitido.getBloqueIni();
                if (bloque != null && !listaBloquesFinal.contains(bloque)) {
                    listaBloquesFinal.add(bloque);
                }
                if ((bloque = bloquePermitido.getBloqueFin()) == null || listaBloquesFinal.contains(bloque)) continue;
                listaBloquesFinal.add(bloque);
            }
        }
        return cdBloques;
    }

    public ConjuntoDatosModela getTipoDocumentosInvolucradosGr() {
        boolean recorrerTareasEnFaseProc = true;
        ConjuntoDatosModela cdTiposDoc = new ConjuntoDatosModela();
        ArrayList<TrTipoDocumento> listaTiposDocFinal = new ArrayList<TrTipoDocumento>();
        cdTiposDoc.setListaDatos(listaTiposDocFinal);
        if (this.TareaFaseDefProcInvolucradas == null) {
            recorrerTareasEnFaseProc = false;
        }
        if (this.TareaFaseDefProcInvolucradas.getListaDatos() == null) {
            recorrerTareasEnFaseProc = false;
        }
        if (this.TareaFaseDefProcInvolucradas.getListaDatos().size() < 1) {
            recorrerTareasEnFaseProc = false;
        }
        if (recorrerTareasEnFaseProc) {
            ArrayList listaTareasProc = this.TareaFaseDefProcInvolucradas.getListaDatos();
            TrTareaEnFaseDefProcedimiento tareaProc = null;
            TrTareaEnFase tareaEnFase = null;
            TrDocumentoPermitido documentoPermitido = null;
            TrTipoDocumento tipoDocumento = null;
            for (int n = 0; n < listaTareasProc.size(); ++n) {
                tareaProc = (TrTareaEnFaseDefProcedimiento)listaTareasProc.get(n);
                tareaEnFase = tareaProc.getTareaEnFase();
                if (tareaEnFase == null || tareaEnFase.getTarea() == null || !(tareaEnFase.getTarea() instanceof TrDocumentoPermitido) || (tipoDocumento = (documentoPermitido = (TrDocumentoPermitido)tareaEnFase.getTarea()).getTipoDocumento()) == null || listaTiposDocFinal.contains(tipoDocumento)) continue;
                listaTiposDocFinal.add(tipoDocumento);
            }
        }
        return cdTiposDoc;
    }

    public ConjuntoDatosModela getPlantillasInvolucradasGr() {
        boolean recorrerTiposDoc = true;
        ConjuntoDatosModela cdPlantillas = new ConjuntoDatosModela();
        ArrayList<TrPlantilla> listaPlantillasFinal = new ArrayList<TrPlantilla>();
        cdPlantillas.setListaDatos(listaPlantillasFinal);
        ConjuntoDatosModela cdTiposDocumentoAux = this.getTipoDocumentosInvolucradosGr();
        if (cdTiposDocumentoAux == null || cdTiposDocumentoAux.getListaDatos() == null || cdTiposDocumentoAux.getListaDatos().size() < 1) {
            recorrerTiposDoc = false;
        }
        if (recorrerTiposDoc) {
            TrPlantilla plantilla = null;
            ArrayList listaTiposDoc = new ArrayList();
            if (cdTiposDocumentoAux != null) {
                listaTiposDoc = cdTiposDocumentoAux.getListaDatos();
            }
            TrTipoDocumento tipoDocumentoAux = null;
            for (int n = 0; n < listaTiposDoc.size(); ++n) {
                tipoDocumentoAux = (TrTipoDocumento)listaTiposDoc.get(n);
                if (tipoDocumentoAux.getPlantilla() == null || listaPlantillasFinal.contains(plantilla = tipoDocumentoAux.getPlantilla())) continue;
                listaPlantillasFinal.add(plantilla);
            }
        }
        return cdPlantillas;
    }

    public ConjuntoDatosModela getTipoParrafosInvolucradosGr() {
        boolean recorrerTiposDoc = true;
        ConjuntoDatosModela cdTiposParrafo = new ConjuntoDatosModela();
        ArrayList<TrTipoParrafo> listaTiposParrafoFinal = new ArrayList<TrTipoParrafo>();
        cdTiposParrafo.setListaDatos(listaTiposParrafoFinal);
        ConjuntoDatosModela cdTiposDocumentoAux = this.getTipoDocumentosInvolucradosGr();
        if (cdTiposDocumentoAux == null || cdTiposDocumentoAux.getListaDatos() == null || cdTiposDocumentoAux.getListaDatos().size() < 1) {
            recorrerTiposDoc = false;
        }
        if (recorrerTiposDoc) {
            TrParrafoTipDoc parrafoDoc = null;
            TrTipoParrafo tipoParrafo = null;
            ArrayList listaTiposDoc = new ArrayList();
            if (cdTiposDocumentoAux != null) {
                listaTiposDoc = cdTiposDocumentoAux.getListaDatos();
            }
            ArrayList listaTiposParrafo = null;
            TrTipoDocumento tipoDocumentoAux = null;
            for (int n = 0; n < listaTiposDoc.size(); ++n) {
                tipoDocumentoAux = (TrTipoDocumento)listaTiposDoc.get(n);
                if (tipoDocumentoAux.getParrafoTipoDoc() == null) continue;
                listaTiposParrafo = tipoDocumentoAux.getParrafoTipoDoc();
                for (int n2 = 0; n2 < listaTiposParrafo.size(); ++n2) {
                    parrafoDoc = (TrParrafoTipDoc)listaTiposParrafo.get(n2);
                    if (parrafoDoc.getTipoParrafo() == null || listaTiposParrafoFinal.contains(tipoParrafo = parrafoDoc.getTipoParrafo())) continue;
                    listaTiposParrafoFinal.add(tipoParrafo);
                }
            }
        }
        return cdTiposParrafo;
    }

    public ConjuntoDatosTarea getTareasInvolucradasGr() {
        boolean recorrerTareasEnFaseProc = true;
        ConjuntoDatosTarea cdTareas = new ConjuntoDatosTarea();
        ArrayList<TrTarea> listaTareasFinal = new ArrayList<TrTarea>();
        cdTareas.setListaDatos(listaTareasFinal);
        if (this.TareaFaseDefProcInvolucradas == null) {
            recorrerTareasEnFaseProc = false;
        }
        if (this.TareaFaseDefProcInvolucradas.getListaDatos() == null) {
            recorrerTareasEnFaseProc = false;
        }
        if (this.TareaFaseDefProcInvolucradas.getListaDatos().size() < 1) {
            recorrerTareasEnFaseProc = false;
        }
        if (recorrerTareasEnFaseProc) {
            ArrayList listaTareasProc = this.TareaFaseDefProcInvolucradas.getListaDatos();
            TrTareaEnFaseDefProcedimiento tareaProc = null;
            TrTareaEnFase tareaEnFase = null;
            TrTarea tarea = null;
            for (int n = 0; n < listaTareasProc.size(); ++n) {
                tareaProc = (TrTareaEnFaseDefProcedimiento)listaTareasProc.get(n);
                tareaEnFase = tareaProc.getTareaEnFase();
                if (tareaEnFase == null) continue;
                if (tareaEnFase.getTarea() != null && (tarea = tareaEnFase.getTarea()) != null && !listaTareasFinal.contains(tarea)) {
                    listaTareasFinal.add(tarea);
                }
                if (tareaEnFase.getTareaLlamante() == null || (tarea = tareaEnFase.getTareaLlamante()) == null || listaTareasFinal.contains(tarea)) continue;
                listaTareasFinal.add(tarea);
            }
        }
        return cdTareas;
    }

    public ConjuntoDatosModela getVariablesInvolucradasGr() {
        boolean recorrerTiposDoc = true;
        ConjuntoDatosModela cdVariables = new ConjuntoDatosModela();
        ArrayList<TrVariable> listaVariablesFinal = new ArrayList<TrVariable>();
        cdVariables.setListaDatos(listaVariablesFinal);
        ConjuntoDatosModela cdTiposDocumentoAux = this.getTipoDocumentosInvolucradosGr();
        if (cdTiposDocumentoAux == null || cdTiposDocumentoAux.getListaDatos() == null || cdTiposDocumentoAux.getListaDatos().size() < 1) {
            recorrerTiposDoc = false;
        }
        if (recorrerTiposDoc) {
            TrVariable variable = null;
            ArrayList listaTiposDoc = new ArrayList();
            if (cdTiposDocumentoAux != null) {
                listaTiposDoc = cdTiposDocumentoAux.getListaDatos();
            }
            ArrayList listaVariables = null;
            TrTipoDocumento tipoDocumentoAux = null;
            for (int n = 0; n < listaTiposDoc.size(); ++n) {
                tipoDocumentoAux = (TrTipoDocumento)listaTiposDoc.get(n);
                if (tipoDocumentoAux.getVariables() == null) continue;
                listaVariables = tipoDocumentoAux.getVariables();
                for (int n2 = 0; n2 < listaVariables.size(); ++n2) {
                    variable = (TrVariable)listaVariables.get(n2);
                    if (listaVariablesFinal.contains(variable)) continue;
                    listaVariablesFinal.add(variable);
                }
            }
        }
        return cdVariables;
    }

    public ConjuntoDatosOrganismo getOrganismosInvolucradosGr() {
        int org;
        ConjuntoDatosOrganismo cdOrganismos = new ConjuntoDatosOrganismo();
        ArrayList listaOrganismosFinal = new ArrayList();
        cdOrganismos.setListaDatos(listaOrganismosFinal);
        TrOrganismo organismoPadreAux = null;
        ArrayList<TrOrganismo> arrOrganismosPadre = new ArrayList<TrOrganismo>();
        if (this.getDDP() == null) {
            return cdOrganismos;
        }
        if (this.getDDP().getTIPOEVOL() == null) {
            return cdOrganismos;
        }
        if (this.getDDP().getTIPOEVOL().getUORG_X_UROG() != null) {
            arrOrganismosPadre.clear();
            arrOrganismosPadre = null;
            arrOrganismosPadre = new ArrayList();
            for (organismoPadreAux = this.getDDP().getTIPOEVOL().getUORG_X_UROG().getTrOrganismoPadre(); organismoPadreAux != null; organismoPadreAux = organismoPadreAux.getTrOrganismoPadre()) {
                if (arrOrganismosPadre.contains(organismoPadreAux)) continue;
                arrOrganismosPadre.add(organismoPadreAux);
            }
            for (org = arrOrganismosPadre.size() - 1; org >= 0; --org) {
                if (listaOrganismosFinal.contains(arrOrganismosPadre.get(org))) continue;
                listaOrganismosFinal.add(arrOrganismosPadre.get(org));
            }
            if (!listaOrganismosFinal.contains(this.getDDP().getTIPOEVOL().getUORG_X_UROG())) {
                listaOrganismosFinal.add(this.getDDP().getTIPOEVOL().getUORG_X_UROG());
            }
        }
        if (this.getDDP().getTIPOEVOL().getUORG_X_UROG_COMP() != null) {
            arrOrganismosPadre.clear();
            arrOrganismosPadre = null;
            arrOrganismosPadre = new ArrayList();
            for (organismoPadreAux = this.getDDP().getTIPOEVOL().getUORG_X_UROG_COMP().getTrOrganismoPadre(); organismoPadreAux != null; organismoPadreAux = organismoPadreAux.getTrOrganismoPadre()) {
                if (arrOrganismosPadre.contains(organismoPadreAux)) continue;
                arrOrganismosPadre.add(organismoPadreAux);
            }
            for (org = arrOrganismosPadre.size() - 1; org >= 0; --org) {
                if (listaOrganismosFinal.contains(arrOrganismosPadre.get(org))) continue;
                listaOrganismosFinal.add(arrOrganismosPadre.get(org));
            }
            if (!listaOrganismosFinal.contains(this.getDDP().getTIPOEVOL().getUORG_X_UROG_COMP())) {
                listaOrganismosFinal.add(this.getDDP().getTIPOEVOL().getUORG_X_UROG_COMP());
            }
        }
        if (this.getDDP().getTIPOEVOL().getUORG_X_UROG_RES() != null) {
            arrOrganismosPadre.clear();
            arrOrganismosPadre = null;
            arrOrganismosPadre = new ArrayList();
            for (organismoPadreAux = this.getDDP().getTIPOEVOL().getUORG_X_UROG_RES().getTrOrganismoPadre(); organismoPadreAux != null; organismoPadreAux = organismoPadreAux.getTrOrganismoPadre()) {
                if (arrOrganismosPadre.contains(organismoPadreAux)) continue;
                arrOrganismosPadre.add(organismoPadreAux);
            }
            for (org = arrOrganismosPadre.size() - 1; org >= 0; --org) {
                if (listaOrganismosFinal.contains(arrOrganismosPadre.get(org))) continue;
                listaOrganismosFinal.add(arrOrganismosPadre.get(org));
            }
            if (!listaOrganismosFinal.contains(this.getDDP().getTIPOEVOL().getUORG_X_UROG_RES())) {
                listaOrganismosFinal.add(this.getDDP().getTIPOEVOL().getUORG_X_UROG_RES());
            }
        }
        if (this.getDDP().getTIPOEVOL().getUORG_X_UROG_TRAM() != null) {
            arrOrganismosPadre.clear();
            arrOrganismosPadre = null;
            arrOrganismosPadre = new ArrayList();
            for (organismoPadreAux = this.getDDP().getTIPOEVOL().getUORG_X_UROG_TRAM().getTrOrganismoPadre(); organismoPadreAux != null; organismoPadreAux = organismoPadreAux.getTrOrganismoPadre()) {
                if (arrOrganismosPadre.contains(organismoPadreAux)) continue;
                arrOrganismosPadre.add(organismoPadreAux);
            }
            for (org = arrOrganismosPadre.size() - 1; org >= 0; --org) {
                if (listaOrganismosFinal.contains(arrOrganismosPadre.get(org))) continue;
                listaOrganismosFinal.add(arrOrganismosPadre.get(org));
            }
            if (!listaOrganismosFinal.contains(this.getDDP().getTIPOEVOL().getUORG_X_UROG_TRAM())) {
                listaOrganismosFinal.add(this.getDDP().getTIPOEVOL().getUORG_X_UROG_TRAM());
            }
        }
        for (int n = 0; n < this.getDDP().getTIPOEVOL().getOrganismosProcedimientoInvolucrados().getListaDatos().size(); ++n) {
            TrOrganismoProc orgProcAux = (TrOrganismoProc)this.getDDP().getTIPOEVOL().getOrganismosProcedimientoInvolucrados().getListaDatos().get(n);
            TrOrganismo orgAux = orgProcAux.getOrganismoAsociado();
            arrOrganismosPadre.clear();
            arrOrganismosPadre = null;
            arrOrganismosPadre = new ArrayList();
            for (organismoPadreAux = orgAux.getTrOrganismoPadre(); organismoPadreAux != null; organismoPadreAux = organismoPadreAux.getTrOrganismoPadre()) {
                if (arrOrganismosPadre.contains(organismoPadreAux)) continue;
                arrOrganismosPadre.add(organismoPadreAux);
            }
            for (int org2 = arrOrganismosPadre.size() - 1; org2 >= 0; --org2) {
                if (listaOrganismosFinal.contains(arrOrganismosPadre.get(org2))) continue;
                listaOrganismosFinal.add(arrOrganismosPadre.get(org2));
            }
            if (listaOrganismosFinal.contains(orgAux)) continue;
            listaOrganismosFinal.add(orgAux);
        }
        return cdOrganismos;
    }

    public ConjuntoDatosTiposOrganismo getTiposOrganismoInvolucradosGr() {
        boolean recorrerOrganismos = true;
        ConjuntoDatosTiposOrganismo cdTiposOrganismo = new ConjuntoDatosTiposOrganismo();
        ArrayList<TrTipoOrganismo> listaTiposOrganismoFinal = new ArrayList<TrTipoOrganismo>();
        cdTiposOrganismo.setListaDatos(listaTiposOrganismoFinal);
        ConjuntoDatosOrganismo cdOrganismosAux = this.getOrganismosInvolucradosGr();
        if (cdOrganismosAux == null || cdOrganismosAux.getListaDatos() == null || cdOrganismosAux.getListaDatos().size() < 1) {
            recorrerOrganismos = false;
        }
        if (recorrerOrganismos) {
            TrTipoOrganismo tipo = null;
            TrOrganismo organismoAux = null;
            ArrayList listaOrganismos = new ArrayList();
            if (cdOrganismosAux != null) {
                listaOrganismos = cdOrganismosAux.getListaDatos();
            }
            for (int n = 0; n < listaOrganismos.size(); ++n) {
                organismoAux = (TrOrganismo)listaOrganismos.get(n);
                if (organismoAux.getTrTipoOrganismo() == null || listaTiposOrganismoFinal.contains(tipo = organismoAux.getTrTipoOrganismo())) continue;
                listaTiposOrganismoFinal.add(tipo);
            }
        }
        return cdTiposOrganismo;
    }

    public ConjuntoDatosAmbitosLey getAmbitosLeyInvolucradosGr() {
        boolean recorrerNormativas = true;
        ConjuntoDatosAmbitosLey cdAmbitosLey = new ConjuntoDatosAmbitosLey();
        ArrayList<TrAmbitoLey> listaAmbitosFinal = new ArrayList<TrAmbitoLey>();
        cdAmbitosLey.setListaDatos(listaAmbitosFinal);
        if (this.getDDP() == null) {
            return cdAmbitosLey;
        }
        if (this.getDDP().getTIPOEVOL() == null) {
            return cdAmbitosLey;
        }
        ConjuntoDatos cdNormativaAux = this.getDDP().getTIPOEVOL().getNormativasProcedimiento();
        if (cdNormativaAux == null || cdNormativaAux.getListaDatos() == null || cdNormativaAux.getListaDatos().size() < 1) {
            recorrerNormativas = false;
        }
        if (recorrerNormativas) {
            TrAmbitoLey ambito = null;
            TrNormativa normativaAux = null;
            ArrayList listaNormativas = new ArrayList();
            if (cdNormativaAux != null) {
                listaNormativas = cdNormativaAux.getListaDatos();
            }
            for (int n = 0; n < listaNormativas.size(); ++n) {
                normativaAux = (TrNormativa)listaNormativas.get(n);
                if (normativaAux.getAmbitoLey0() == null || listaAmbitosFinal.contains(ambito = normativaAux.getAmbitoLey0())) continue;
                listaAmbitosFinal.add(ambito);
            }
        }
        return cdAmbitosLey;
    }

    public ConjuntoDatosTiposPublicacion getTiposPublicacionInvolucradosGr() {
        boolean recorrerNormativas = true;
        ConjuntoDatosTiposPublicacion cdTipos = new ConjuntoDatosTiposPublicacion();
        ArrayList<TrTipoPublicacion> listaTiposFinal = new ArrayList<TrTipoPublicacion>();
        cdTipos.setListaDatos(listaTiposFinal);
        if (this.getDDP() == null) {
            return cdTipos;
        }
        if (this.getDDP().getTIPOEVOL() == null) {
            return cdTipos;
        }
        ConjuntoDatos cdNormativaAux = this.getDDP().getTIPOEVOL().getNormativasProcedimiento();
        if (cdNormativaAux == null || cdNormativaAux.getListaDatos() == null || cdNormativaAux.getListaDatos().size() < 1) {
            recorrerNormativas = false;
        }
        if (recorrerNormativas) {
            TrTipoPublicacion tipo = null;
            TrNormativa normativaAux = null;
            ArrayList listaNormativas = new ArrayList();
            if (cdNormativaAux != null) {
                listaNormativas = cdNormativaAux.getListaDatos();
            }
            for (int n = 0; n < listaNormativas.size(); ++n) {
                normativaAux = (TrNormativa)listaNormativas.get(n);
                if (normativaAux.getTrTipoPublicacion0() == null || listaTiposFinal.contains(tipo = normativaAux.getTrTipoPublicacion0())) continue;
                listaTiposFinal.add(tipo);
            }
        }
        return cdTipos;
    }

    public ConjuntoDatosTiposNormativa getTiposNormativaInvolucradosGr() {
        boolean recorrerNormativas = true;
        ConjuntoDatosTiposNormativa cdTipos = new ConjuntoDatosTiposNormativa();
        ArrayList<TrTipoNormativa> listaTiposFinal = new ArrayList<TrTipoNormativa>();
        cdTipos.setListaDatos(listaTiposFinal);
        if (this.getDDP() == null) {
            return cdTipos;
        }
        if (this.getDDP().getTIPOEVOL() == null) {
            return cdTipos;
        }
        ConjuntoDatos cdNormativaAux = this.getDDP().getTIPOEVOL().getNormativasProcedimiento();
        if (cdNormativaAux == null || cdNormativaAux.getListaDatos() == null || cdNormativaAux.getListaDatos().size() < 1) {
            recorrerNormativas = false;
        }
        if (recorrerNormativas) {
            TrTipoNormativa tipo = null;
            TrNormativa normativaAux = null;
            ArrayList listaNormativas = new ArrayList();
            if (cdNormativaAux != null) {
                listaNormativas = cdNormativaAux.getListaDatos();
            }
            for (int n = 0; n < listaNormativas.size(); ++n) {
                normativaAux = (TrNormativa)listaNormativas.get(n);
                if (normativaAux.getTrTipoNormativa0() == null || listaTiposFinal.contains(tipo = normativaAux.getTrTipoNormativa0())) continue;
                listaTiposFinal.add(tipo);
            }
        }
        return cdTipos;
    }

    public ConjuntoDatosTiposIndicacion getTiposIndicacionInvolucradosGr() {
        boolean recorrerFichas = true;
        ConjuntoDatosTiposIndicacion cdTipos = new ConjuntoDatosTiposIndicacion();
        ArrayList<TrTipoIndicacionFicha> listaTiposFinal = new ArrayList<TrTipoIndicacionFicha>();
        cdTipos.setListaDatos(listaTiposFinal);
        if (this.getDDP() == null) {
            return cdTipos;
        }
        if (this.getDDP().getTIPOEVOL() == null) {
            return cdTipos;
        }
        ConjuntoDatos cdFichaAux = this.getDDP().getTIPOEVOL().getFichaProcedimientoInvolucradas();
        if (cdFichaAux == null || cdFichaAux.getListaDatos() == null || cdFichaAux.getListaDatos().size() < 1) {
            recorrerFichas = false;
        }
        if (recorrerFichas) {
            TrTipoIndicacionFicha tipo = null;
            TrIndicacionFicha fichaAux = null;
            ArrayList listaFichas = new ArrayList();
            if (cdFichaAux != null) {
                listaFichas = cdFichaAux.getListaDatos();
            }
            for (int n = 0; n < listaFichas.size(); ++n) {
                fichaAux = (TrIndicacionFicha)listaFichas.get(n);
                if (fichaAux.getTipoIndicacionFicha() == null || listaTiposFinal.contains(tipo = fichaAux.getTipoIndicacionFicha())) continue;
                listaTiposFinal.add(tipo);
            }
        }
        return cdTipos;
    }

    public boolean existeInfoGraf() {
        if (this.canvasGrafico == null) {
            return false;
        }
        return this.canvasGrafico.obtenerNumGraficos(1) != 0;
    }

    public DDPGrafico existeDDPGrafico(String abreviaturaBuscada) {
        if (abreviaturaBuscada == null) {
            return null;
        }
        if (abreviaturaBuscada.equals("")) {
            return null;
        }
        DDPGrafico ddpPrincipalAux = null;
        ddpPrincipalAux = this.getDDPPadre() == null ? this : this.getDDPPadre();
        if (abreviaturaBuscada.equals(ddpPrincipalAux.getDDP().getTIPOEVOL().getABREVIATURA())) {
            return ddpPrincipalAux;
        }
        for (int n = 0; n < ddpPrincipalAux.getListaDDPs().size(); ++n) {
            if (((DDPGrafico)ddpPrincipalAux.getListaDDPs().get(n)).getDDP() == null || ((DDPGrafico)ddpPrincipalAux.getListaDDPs().get(n)).getDDP().getTIPOEVOL() == null || !((DDPGrafico)ddpPrincipalAux.getListaDDPs().get(n)).getDDP().getTIPOEVOL().getABREVIATURA().equals(abreviaturaBuscada)) continue;
            return (DDPGrafico)ddpPrincipalAux.getListaDDPs().get(n);
        }
        return null;
    }

    public boolean existenCondicionesTransicion() {
        if (this.getTransicionesDelProcInvolucradas() != null && this.getTransicionesDelProcInvolucradas().obtenerNumRegistros() > 0) {
            ArrayList vDatos = this.getTransicionesDelProcInvolucradas().getListaDatos();
            TrTransicionDefProcedimiento transicion = null;
            for (int j = 0; j < vDatos.size(); ++j) {
                transicion = (TrTransicionDefProcedimiento)vDatos.get(j);
                if (transicion.getConjuntoCondicionTransicion() == null || transicion.getConjuntoCondicionTransicion().obtenerNumRegistros() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean existenCondicionesTareaEnFase() {
        if (this.getTareaFaseDefProcInvolucradas() != null && this.getTareaFaseDefProcInvolucradas().obtenerNumRegistros() > 0) {
            ArrayList vDatos = this.getTareaFaseDefProcInvolucradas().getListaDatos();
            TrTareaEnFaseDefProcedimiento tareaFase = null;
            for (int j = 0; j < vDatos.size(); ++j) {
                tareaFase = (TrTareaEnFaseDefProcedimiento)vDatos.get(j);
                if (tareaFase.getConjuntoCondicionTareaFase() == null || tareaFase.getConjuntoCondicionTareaFase().obtenerNumRegistros() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean existenAccionesTransicion() {
        if (this.getTransicionesDelProcInvolucradas() != null && this.getTransicionesDelProcInvolucradas().obtenerNumRegistros() > 0) {
            ArrayList vDatos = this.getTransicionesDelProcInvolucradas().getListaDatos();
            TrTransicionDefProcedimiento transicion = null;
            for (int j = 0; j < vDatos.size(); ++j) {
                transicion = (TrTransicionDefProcedimiento)vDatos.get(j);
                if (transicion.getConjuntoAccionTransicion() == null || transicion.getConjuntoAccionTransicion().obtenerNumRegistros() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean existenAccionesTareaEnFase() {
        if (this.getTareaFaseDefProcInvolucradas() != null && this.getTareaFaseDefProcInvolucradas().obtenerNumRegistros() > 0) {
            ArrayList vDatos = this.getTareaFaseDefProcInvolucradas().getListaDatos();
            TrTareaEnFaseDefProcedimiento tareaFase = null;
            for (int j = 0; j < vDatos.size(); ++j) {
                tareaFase = (TrTareaEnFaseDefProcedimiento)vDatos.get(j);
                if (tareaFase.getConjuntoAccionTareaFase() == null || tareaFase.getConjuntoAccionTareaFase().obtenerNumRegistros() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean existenAvisosTransicion() {
        if (this.getTransicionesDelProcInvolucradas() != null && this.getTransicionesDelProcInvolucradas().obtenerNumRegistros() > 0) {
            ArrayList vDatos = this.getTransicionesDelProcInvolucradas().getListaDatos();
            TrTransicionDefProcedimiento transicion = null;
            for (int j = 0; j < vDatos.size(); ++j) {
                transicion = (TrTransicionDefProcedimiento)vDatos.get(j);
                if (transicion.getConjuntoAvisoTransicion() == null || transicion.getConjuntoAvisoTransicion().obtenerNumRegistros() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean existenAvisosTareaEnFase() {
        if (this.getTareaFaseDefProcInvolucradas() != null && this.getTareaFaseDefProcInvolucradas().obtenerNumRegistros() > 0) {
            ArrayList vDatos = this.getTareaFaseDefProcInvolucradas().getListaDatos();
            TrTareaEnFaseDefProcedimiento tareaFase = null;
            for (int j = 0; j < vDatos.size(); ++j) {
                tareaFase = (TrTareaEnFaseDefProcedimiento)vDatos.get(j);
                if (tareaFase.getConjuntoAvisoTareaFase() == null || tareaFase.getConjuntoAvisoTareaFase().obtenerNumRegistros() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean existenParrafosTipoDocumento() {
        if (this.getTipoDocumentosInvolucradosGr() != null && this.getTipoDocumentosInvolucradosGr().obtenerNumRegistros() > 0) {
            ArrayList vDatos = this.getTipoDocumentosInvolucradosGr().getListaDatos();
            TrTipoDocumento tipoDocum = null;
            for (int n = 0; n < vDatos.size(); ++n) {
                tipoDocum = (TrTipoDocumento)vDatos.get(n);
                if (tipoDocum.getParrafoTipoDoc() == null || tipoDocum.getParrafoTipoDoc().size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public ConjuntoDatos getTransicionesPlazoSimple(TrFase faseIni) {
        ConjuntoDatosTransicionDefProcedimiento conjuntoTransicionesInvolucradas = this.getTransicionesDelProcInvolucradas();
        if (conjuntoTransicionesInvolucradas == null || conjuntoTransicionesInvolucradas.getListaDatos().size() == 0) {
            return null;
        }
        ConjuntoDatosTransicion conjuntoTransicion = new ConjuntoDatosTransicion();
        TrTransicionDefProcedimiento transicionDefProc = null;
        for (int j = 0; j < conjuntoTransicionesInvolucradas.getListaDatos().size(); ++j) {
            TrFase faseIniAux;
            TrTransicion transicion;
            transicionDefProc = (TrTransicionDefProcedimiento)conjuntoTransicionesInvolucradas.getListaDatos().get(j);
            if (transicionDefProc == null || transicionDefProc.getTransicion() == null || (transicion = transicionDefProc.getTransicion()) == null || transicion.getTIPO() == null) continue;
            if (transicion.getTIPO().equals("ES")) {
                conjuntoTransicion.add(transicion);
                continue;
            }
            if (transicion.getTIPO().equals("EN")) {
                conjuntoTransicion.add(transicion);
                continue;
            }
            if (faseIni == null || (faseIniAux = transicion.getTrFaseIni()) == null || faseIni.getID() != faseIniAux.getID()) continue;
            conjuntoTransicion.add(transicion);
        }
        return conjuntoTransicion;
    }

    public int obtenerAparicionesDeTransicion(TrTransicion transiABuscar) {
        int n;
        if (transiABuscar == null) {
            return 0;
        }
        int nApariciones = 0;
        TrTransicionDefProcedimiento transiProcAux = null;
        ArrayList arrReutilizables = new ArrayList();
        DDPGrafico ddpAux = null;
        if (this.getDDPPadre() == null) {
            ddpAux = this;
            arrReutilizables = this.getListaDDPs();
        } else {
            ddpAux = this.getDDPPadre();
            arrReutilizables = this.getDDPPadre().getListaDDPs();
        }
        if (ddpAux.getTransicionesDelProcInvolucradas() != null && ddpAux.getTransicionesDelProcInvolucradas().obtenerNumRegistros() > 0) {
            for (n = 0; n < ddpAux.getTransicionesDelProcInvolucradas().getListaDatos().size(); ++n) {
                transiProcAux = (TrTransicionDefProcedimiento)ddpAux.getTransicionesDelProcInvolucradas().getListaDatos().get(n);
                if (transiProcAux.getTransicion() == null || transiProcAux.getTransicion().getTRANID().longValue() != transiABuscar.getTRANID().longValue()) continue;
                ++nApariciones;
            }
        }
        for (n = 0; n < arrReutilizables.size(); ++n) {
            ddpAux = (DDPGrafico)arrReutilizables.get(n);
            transiProcAux = null;
            for (int r = 0; r < ddpAux.getTransicionesDelProcInvolucradas().getListaDatos().size(); ++r) {
                transiProcAux = (TrTransicionDefProcedimiento)ddpAux.getTransicionesDelProcInvolucradas().getListaDatos().get(r);
                if (transiProcAux.getTransicion() == null || transiProcAux.getTransicion().getTRANID().longValue() != transiABuscar.getTRANID().longValue()) continue;
                ++nApariciones;
            }
        }
        return nApariciones;
    }

    public String toString() {
        if (this.getDDP() == null) {
            return "";
        }
        if (this.getDDP().getTIPOEVOL() == null) {
            return "";
        }
        return this.getDDP().getTIPOEVOL().getABREVIATURA();
    }

    public ConjuntoDatosTransicionDefProcedimiento getTransicionesDefProcSalida(TrFase fase) {
        ConjuntoDatosTransicionDefProcedimiento conjuntoTransDefProcAux = new ConjuntoDatosTransicionDefProcedimiento();
        ConjuntoDatosTransicionDefProcedimiento conjuntoTransDefProc = this.getTransicionesDelProcInvolucradas();
        if (conjuntoTransDefProc == null) {
            return null;
        }
        if (conjuntoTransDefProc.getListaDatos() == null) {
            return null;
        }
        if (conjuntoTransDefProc.getListaDatos().size() <= 0) {
            return null;
        }
        TrTransicionDefProcedimiento transicionDefProc = null;
        for (int i = 0; i < conjuntoTransDefProc.getListaDatos().size(); ++i) {
            TrTransicion transicionAux;
            transicionDefProc = (TrTransicionDefProcedimiento)conjuntoTransDefProc.getListaDatos().get(i);
            if (transicionDefProc == null || (transicionAux = transicionDefProc.getTransicion()) == null || transicionAux.getTrFaseIni() == null || transicionAux.getTrFaseIni().getID() != fase.getID()) continue;
            conjuntoTransDefProcAux.add(transicionDefProc);
        }
        return conjuntoTransDefProcAux;
    }

    public ConjuntoDatosTransicionDefProcedimiento getTransicionesDefProcEntrada(TrFase fase) {
        ConjuntoDatosTransicionDefProcedimiento conjuntoTransDefProcAux = new ConjuntoDatosTransicionDefProcedimiento();
        ConjuntoDatosTransicionDefProcedimiento conjuntoTransDefProc = this.getTransicionesDelProcInvolucradas();
        if (conjuntoTransDefProc == null) {
            return null;
        }
        if (conjuntoTransDefProc.getListaDatos() == null) {
            return null;
        }
        if (conjuntoTransDefProc.getListaDatos().size() <= 0) {
            return null;
        }
        int i = 0;
        TrTransicionDefProcedimiento transicionDefProc = null;
        while (i < conjuntoTransDefProc.getListaDatos().size()) {
            transicionDefProc = (TrTransicionDefProcedimiento)conjuntoTransDefProc.getListaDatos().get(i);
            if (transicionDefProc == null) continue;
            TrTransicion transicionAux = transicionDefProc.getTransicion();
            if (transicionAux != null) {
                if (transicionAux.getTIPO().equals("D")) {
                    if (transicionAux.getConjuntoFasesFin() != null && transicionAux.getConjuntoFasesFin().getListaDatos() != null && transicionAux.getConjuntoFasesFin().getListaDatos().size() > 0) {
                        TrFase faseAux = null;
                        boolean bEncontrado = false;
                        for (int j = 0; j < transicionAux.getConjuntoFasesFin().getListaDatos().size() && !bEncontrado; ++j) {
                            faseAux = (TrFase)transicionAux.getConjuntoFasesFin().getListaDatos().get(j);
                            if (faseAux.getID() != fase.getID()) continue;
                            conjuntoTransDefProcAux.add(transicionDefProc);
                            bEncontrado = true;
                        }
                    }
                } else if (transicionAux.getFaseFin() != null && transicionAux.getFaseFin().getID() == fase.getID()) {
                    conjuntoTransDefProcAux.add(transicionDefProc);
                }
            }
            ++i;
        }
        return conjuntoTransDefProcAux;
    }

    public ConjuntoDatosTareaFaseDefProcedimiento getTareasEnFaseDefProc(TrFase fase) {
        ConjuntoDatosTareaFaseDefProcedimiento conjuntoTareasEnFaseDefProcAux = new ConjuntoDatosTareaFaseDefProcedimiento();
        ConjuntoDatosTareaFaseDefProcedimiento conjuntoTareasEnFaseDefProc = this.getTareaFaseDefProcInvolucradas();
        if (fase == null) {
            return conjuntoTareasEnFaseDefProcAux;
        }
        if (conjuntoTareasEnFaseDefProc == null) {
            return conjuntoTareasEnFaseDefProcAux;
        }
        if (conjuntoTareasEnFaseDefProc.getListaDatos() == null) {
            return conjuntoTareasEnFaseDefProcAux;
        }
        if (conjuntoTareasEnFaseDefProc.getListaDatos().size() <= 0) {
            return conjuntoTareasEnFaseDefProcAux;
        }
        TrTareaEnFaseDefProcedimiento tareaDefProc = null;
        for (int i = 0; i < conjuntoTareasEnFaseDefProc.getListaDatos().size(); ++i) {
            tareaDefProc = (TrTareaEnFaseDefProcedimiento)conjuntoTareasEnFaseDefProc.getListaDatos().get(i);
            if (tareaDefProc == null || tareaDefProc.getTareaEnFase() == null || tareaDefProc.getTareaEnFase().getFase() == null || fase.getID() != tareaDefProc.getTareaEnFase().getFase().getID()) continue;
            conjuntoTareasEnFaseDefProcAux.add(tareaDefProc);
        }
        return conjuntoTareasEnFaseDefProcAux;
    }

    public boolean isFaseUtilizadaEnTransicionesDefProcSinGraficos(TrFase faseClave) {
        int c;
        ArrayList<DDPGrafico> listaGraficos = new ArrayList<DDPGrafico>();
        DDPGrafico graficoAux = null;
        if (this.getDDPPadre() == null) {
            listaGraficos.add(this);
            for (c = 0; c < this.getListaDDPs().size(); ++c) {
                listaGraficos.add((DDPGrafico)this.getListaDDPs().get(c));
            }
        } else {
            listaGraficos.add(this.getDDPPadre());
            for (c = 0; c < this.getDDPPadre().getListaDDPs().size(); ++c) {
                listaGraficos.add((DDPGrafico)this.getDDPPadre().getListaDDPs().get(c));
            }
        }
        boolean validarTransiciones = true;
        for (int d = 0; d < listaGraficos.size(); ++d) {
            graficoAux = (DDPGrafico)listaGraficos.get(d);
            validarTransiciones = true;
            if (graficoAux.getTransicionesDelProcInvolucradas() == null) {
                validarTransiciones = false;
            }
            if (graficoAux.getTransicionesDelProcInvolucradas().getListaDatos() == null) {
                validarTransiciones = false;
            }
            if (graficoAux.getTransicionesDelProcInvolucradas().getListaDatos().size() < 1) {
                validarTransiciones = false;
            }
            if (!validarTransiciones) continue;
            TrTransicionDefProcedimiento transicionDefProcAux = null;
            TrTransicion transiSinGrafRelacionada = null;
            ArrayList arrTransicionesDefProc = graficoAux.getTransicionesDelProcInvolucradas().getListaDatos();
            for (int n = 0; n < arrTransicionesDefProc.size(); ++n) {
                transicionDefProcAux = (TrTransicionDefProcedimiento)arrTransicionesDefProc.get(n);
                if (graficoAux.getCanvas() == null || graficoAux.getCanvas().localizarGraficosTransicion(transicionDefProcAux.getTransicion()).size() >= 1) continue;
                transiSinGrafRelacionada = transicionDefProcAux.getTransicion();
                if (transiSinGrafRelacionada.getTrFaseIni() != null && transiSinGrafRelacionada.getTrFaseIni().getFASEID().longValue() == faseClave.getFASEID().longValue()) {
                    return true;
                }
                if (!transiSinGrafRelacionada.getTIPO().equals("D")) {
                    if (transiSinGrafRelacionada.getFaseFin() == null || transiSinGrafRelacionada.getFaseFin().getFASEID().longValue() != faseClave.getFASEID().longValue()) continue;
                    return true;
                }
                if (transiSinGrafRelacionada.getConjuntoFasesFin() == null) continue;
                TrFase faseFinvAux = null;
                for (int nD = 0; nD < transiSinGrafRelacionada.getConjuntoFasesFin().obtenerNumRegistros(); ++nD) {
                    faseFinvAux = (TrFase)transiSinGrafRelacionada.getConjuntoFasesFin().obtenerDato(nD);
                    if (faseFinvAux.getFASEID().longValue() != faseClave.getFASEID().longValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isTransicionAsociadaAProcedimiento(TrTransicion transicionClave) {
        int c;
        ArrayList<DDPGrafico> listaGraficos = new ArrayList<DDPGrafico>();
        DDPGrafico graficoAux = null;
        if (this.getDDPPadre() == null) {
            listaGraficos.add(this);
            for (c = 0; c < this.getListaDDPs().size(); ++c) {
                listaGraficos.add((DDPGrafico)this.getListaDDPs().get(c));
            }
        } else {
            listaGraficos.add(this.getDDPPadre());
            for (c = 0; c < this.getDDPPadre().getListaDDPs().size(); ++c) {
                listaGraficos.add((DDPGrafico)this.getDDPPadre().getListaDDPs().get(c));
            }
        }
        boolean validarTransiciones = true;
        for (int d = 0; d < listaGraficos.size(); ++d) {
            graficoAux = (DDPGrafico)listaGraficos.get(d);
            validarTransiciones = true;
            if (graficoAux.getTransicionesDelProcInvolucradas() == null) {
                validarTransiciones = false;
            }
            if (graficoAux.getTransicionesDelProcInvolucradas().getListaDatos() == null) {
                validarTransiciones = false;
            }
            if (graficoAux.getTransicionesDelProcInvolucradas().getListaDatos().size() < 1) {
                validarTransiciones = false;
            }
            if (!validarTransiciones) continue;
            TrTransicionDefProcedimiento transicionDefProcAux = null;
            ArrayList arrTransicionesDefProc = graficoAux.getTransicionesDelProcInvolucradas().getListaDatos();
            for (int n = 0; n < arrTransicionesDefProc.size(); ++n) {
                transicionDefProcAux = (TrTransicionDefProcedimiento)arrTransicionesDefProc.get(n);
                if (transicionDefProcAux.getTransicion().getTRANID().longValue() != transicionClave.getTRANID().longValue()) continue;
                return true;
            }
        }
        return false;
    }

    public ArrayList getProcedimientosUsanFase(TrFase faseBusca) {
        ArrayList<DDPGrafico> listaProcUsanFase = new ArrayList<DDPGrafico>();
        ArrayList listaReutilizables = new ArrayList();
        if (this.getDDPPadre() == null) {
            if (this.getFasesInvolucradasGr().existeElemento(faseBusca, false) != null) {
                listaProcUsanFase.add(this);
            }
            listaReutilizables = this.getListaDDPs();
        } else {
            if (this.getDDPPadre().getFasesInvolucradasGr().existeElemento(faseBusca, false) != null) {
                listaProcUsanFase.add(this.getDDPPadre());
            }
            listaReutilizables = this.getDDPPadre().getListaDDPs();
        }
        DDPGrafico graficoAux = null;
        for (int n = 0; n < listaReutilizables.size(); ++n) {
            graficoAux = (DDPGrafico)listaReutilizables.get(n);
            if (graficoAux.getFasesInvolucradasGr().existeElemento(faseBusca, false) == null) continue;
            listaProcUsanFase.add(graficoAux);
        }
        return listaProcUsanFase;
    }

    public void setBloqueado(boolean bValor) {
        this.bBloqueado = bValor;
    }

    public boolean isBloqueado() {
        return this.bBloqueado;
    }
}

