/*
 * Decompiled with CFR 0.152.
 */
package modela.graf;

import edu.umd.cs.piccolo.PNode;
import gdtel.bd.tpo.TpoPK;
import gdtel.util.GeneradorID;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import modela.bd.ConjuntoDatosModela;
import modela.bd.obj.DefProcGr;
import modela.bd.obj.TrAccion;
import modela.bd.obj.TrAccionTareaFase;
import modela.bd.obj.TrAccionTransicion;
import modela.bd.obj.TrAmbitoLey;
import modela.bd.obj.TrAmbitoLeyEnCarga;
import modela.bd.obj.TrAviso;
import modela.bd.obj.TrAvisoTareaFase;
import modela.bd.obj.TrAvisoTransicion;
import modela.bd.obj.TrBloque;
import modela.bd.obj.TrBloquePermitido;
import modela.bd.obj.TrCondicion;
import modela.bd.obj.TrCondicionTareaFase;
import modela.bd.obj.TrCondicionTransicion;
import modela.bd.obj.TrDocumentoPermitido;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrFaseGr;
import modela.bd.obj.TrIndicacionFicha;
import modela.bd.obj.TrMetafase;
import modela.bd.obj.TrMetafaseGr;
import modela.bd.obj.TrNodoGr;
import modela.bd.obj.TrNormativa;
import modela.bd.obj.TrNormativaEnCarga;
import modela.bd.obj.TrOrganismo;
import modela.bd.obj.TrOrganismoEnCarga;
import modela.bd.obj.TrOrganismoProc;
import modela.bd.obj.TrParametro;
import modela.bd.obj.TrParametroEnCarga;
import modela.bd.obj.TrParrafoTipDoc;
import modela.bd.obj.TrPerfilTareaFase;
import modela.bd.obj.TrPerfilTransEvol;
import modela.bd.obj.TrPerfilUsuario;
import modela.bd.obj.TrPlantilla;
import modela.bd.obj.TrPlantillaEnCarga;
import modela.bd.obj.TrPlantillaProcedimiento;
import modela.bd.obj.TrPlazoCompuestoDefProc;
import modela.bd.obj.TrPlazoSimple;
import modela.bd.obj.TrTarea;
import modela.bd.obj.TrTareaEnCarga;
import modela.bd.obj.TrTareaEnFase;
import modela.bd.obj.TrTareaEnFaseDefProcedimiento;
import modela.bd.obj.TrTareaEnFaseEnCarga;
import modela.bd.obj.TrTipoActo;
import modela.bd.obj.TrTipoActoEnCarga;
import modela.bd.obj.TrTipoBloque;
import modela.bd.obj.TrTipoCategoria;
import modela.bd.obj.TrTipoDocumento;
import modela.bd.obj.TrTipoEvol;
import modela.bd.obj.TrTipoImplementacion;
import modela.bd.obj.TrTipoIndicacionFicha;
import modela.bd.obj.TrTipoIndicacionFichaEnCarga;
import modela.bd.obj.TrTipoNormativa;
import modela.bd.obj.TrTipoNormativaEnCarga;
import modela.bd.obj.TrTipoOrganismo;
import modela.bd.obj.TrTipoOrganismoEnCarga;
import modela.bd.obj.TrTipoParametro;
import modela.bd.obj.TrTipoParrafo;
import modela.bd.obj.TrTipoParrafoEnCarga;
import modela.bd.obj.TrTipoPublicacion;
import modela.bd.obj.TrTipoPublicacionEnCarga;
import modela.bd.obj.TrTipoTarea;
import modela.bd.obj.TrTransicion;
import modela.bd.obj.TrTransicionDefProcedimiento;
import modela.bd.obj.TrTransicionGr;
import modela.bd.obj.TrVariable;
import modela.bd.obj.TrVariableEnCarga;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.piccolo.PCanvasModela;
import modela.ui.piccolo.nodes.CreadorExtremoTransicion;
import modela.ui.piccolo.nodes.PNodoGrafico;
import modela.ui.piccolo.nodes.PostItPNode;
import modela.ui.piccolo.nodes.TransicionPNode;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class LectorXMLDefProc
extends DefaultHandler {
    protected DDPGrafico grafico = null;
    protected Locator locator = null;
    private final DefProcGr defProcActivo = null;
    private TrTipoEvol tipoEvolActivo = null;
    protected TrMetafase metafaseActiva = null;
    protected TrFase faseActiva = null;
    private TrPerfilUsuario perfilActivo = null;
    private TrTransicion transicionActiva = null;
    private TrPlazoCompuestoDefProc plazoCompuestoActivo = null;
    private TrTransicionDefProcedimiento transicionProcActiva = null;
    private TrTareaEnFaseDefProcedimiento tareaFaseProcActiva = null;
    private TrTransicionGr transicionGrActivo = null;
    private PNodoGrafico pNodoActivoIni = null;
    private PNodoGrafico pNodoActivoFin = null;
    private TrTarea tareaActiva = null;
    private TrTareaEnFase tEnFaseActiva = null;
    BigDecimal faseIDActiva = null;
    private TrTipoParrafo tipoParrafoActivo = null;
    private TrPlantilla PlantillaActiva = null;
    private TrTipoActo tipoActoActivo = null;
    private TrCondicion condicionActiva = null;
    private TrAccion accionActiva = null;
    private TrAviso AvisoActivo = null;
    private TrTipoOrganismo tipoOrganismoActivo = null;
    private TrTipoIndicacionFicha tipoIndicacionActivo = null;
    private TrOrganismo organismoActivo = null;
    private TrTipoNormativa tipoNormativaActivo = null;
    private TrTipoPublicacion tipoPublicacionActivo = null;
    private TrAmbitoLey ambitoLeyActivo = null;
    protected TrNormativa normativaActiva = null;
    private TrParametro trParametroActivo = null;
    private TrBloque trBloqueActivo = null;
    private TrTipoDocumento tipoDocumentoActivo = null;
    private TrVariable trVariableActiva = null;
    private PostItPNode postItActivo = null;
    private boolean bFaseIDIni = false;
    private boolean bFaseIDFin = false;
    private boolean bTransicionIDIni = false;
    private boolean bTransicionIDFin = false;
    private int nGruposReutilizablesOpen = 0;
    private boolean bProcesandoReutilizables = false;
    private ArrayList listaRecorridoDDP = null;
    private PCanvasModela canvasReutilizable = null;
    private String sistemaPrincipal = null;
    protected long auxID = 0L;
    private long idTareaUnico = 0L;
    private long idTareaFaseUnico = 0L;
    protected int nVersionTrewa = 0;
    protected boolean bProcesoFallido = false;
    public static int CONTROL_DUPLICIDAD_POR_ID = 1;
    public static int CONTROL_DUPLICIDAD_POR_ATRIBUTOS = 2;
    public static int LECTURA_DEFINICION_PROC = 1;
    public static int LECTURA_IMPORTACION_DES = 2;
    private int tipoControlDuplicidad = CONTROL_DUPLICIDAD_POR_ID;
    private int tipoLectura = LECTURA_DEFINICION_PROC;
    private boolean bActualizarEntidades = false;
    private boolean bXMLValido = true;
    private boolean bPrimeraEtiqueta = true;

    public LectorXMLDefProc() {
        this.tipoControlDuplicidad = CONTROL_DUPLICIDAD_POR_ID;
        this.listaRecorridoDDP = new ArrayList();
    }

    public void setActualizarEntidades(boolean pValor) {
        this.bActualizarEntidades = pValor;
    }

    public void setTipoControlDuplicidad(int nTipo) {
        this.tipoControlDuplicidad = nTipo;
    }

    public void setTipoLectura(int nTipo) {
        this.tipoLectura = nTipo;
        if (nTipo == LECTURA_DEFINICION_PROC) {
            this.tipoControlDuplicidad = CONTROL_DUPLICIDAD_POR_ID;
        } else if (nTipo == LECTURA_IMPORTACION_DES) {
            this.tipoControlDuplicidad = CONTROL_DUPLICIDAD_POR_ATRIBUTOS;
        }
    }

    public void setGrafico(DDPGrafico grafico) {
        this.grafico = grafico;
    }

    public DDPGrafico getGrafico() {
        return this.grafico;
    }

    public boolean leerArchivo(File openFile) {
        if (openFile == null) {
            return false;
        }
        if (this.grafico == null) {
            return false;
        }
        this.grafico.setIncoherente(false);
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = saxFactory.newSAXParser();
            saxParser.parse(openFile, (DefaultHandler)this);
            GeneradorID.setID(this.auxID);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.grafico.limpiar();
            return false;
        }
        if (!this.bXMLValido) {
            JOptionPane.showMessageDialog(null, "El fichero seleccionado no es v\u00e1lido:\nLa definici\u00f3n del procedimiento no est\u00e1 bien formada.", "Fichero no v\u00e1lido", 2);
            return false;
        }
        return true;
    }

    public boolean leerImputStream(InputStream inputStream) {
        if (inputStream == null) {
            return false;
        }
        if (this.grafico == null) {
            return false;
        }
        this.grafico.setIncoherente(false);
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = saxFactory.newSAXParser();
            saxParser.parse(inputStream, (DefaultHandler)this);
            GeneradorID.setID(this.auxID);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.grafico.limpiar();
            return false;
        }
        if (!this.bXMLValido) {
            JOptionPane.showMessageDialog(null, "El fichero seleccionado no es v\u00e1lido:\nLa definici\u00f3n del procedimiento no est\u00e1 bien formada.", "Fichero no v\u00e1lido", 2);
            return false;
        }
        return true;
    }

    public boolean leerURL(String strURL) {
        if (this.grafico != null) {
            this.grafico.setIncoherente(false);
        }
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = saxFactory.newSAXParser();
            saxParser.parse(strURL, (DefaultHandler)this);
            GeneradorID.setID(this.auxID);
        }
        catch (Exception ex) {
            System.out.println("- [ Error ] Durante la lectura del XML del DDP:\n");
            ex.printStackTrace();
            System.out.println("- Intentando crear fichero temporal en " + strURL);
            InputStream in = null;
            File f = null;
            try {
                URL url = new URL(strURL);
                in = url.openStream();
                if (in != null) {
                    int k;
                    int aBuffSize = 1;
                    String StringFromWS = "";
                    byte[] buff = new byte[aBuffSize];
                    ByteArrayOutputStream xOutputStream = new ByteArrayOutputStream(aBuffSize);
                    while ((k = in.read(buff)) != -1) {
                        ((OutputStream)xOutputStream).write(buff, 0, k);
                    }
                    StringFromWS = StringFromWS + ((Object)xOutputStream).toString();
                    String nombreFile = System.getProperty("java.io.tmpdir", "c:/");
                    if (!nombreFile.endsWith("/") && !nombreFile.endsWith("\\")) {
                        nombreFile = nombreFile + System.getProperty("file.separator");
                    }
                    nombreFile = nombreFile + "BeanModela_" + System.currentTimeMillis() + ".ddp";
                    FileWriter fw = new FileWriter(nombreFile);
                    fw.write(StringFromWS);
                    fw.close();
                    f = new File(nombreFile);
                    strURL = f.getAbsolutePath();
                    System.out.println("- Parseando fichero temporal en " + strURL);
                    SAXParser saxParser = saxFactory.newSAXParser();
                    saxParser.parse(strURL, (DefaultHandler)this);
                    GeneradorID.setID(this.auxID);
                    if (f.exists()) {
                        f.delete();
                    }
                }
                return false;
            }
            catch (Exception e) {
                if (f == null) {
                    e.printStackTrace();
                    return false;
                }
                if (f.exists()) {
                    f.delete();
                }
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() {
        this.bXMLValido = true;
        this.bPrimeraEtiqueta = true;
        System.out.println("- [ Info ] Comienza la lectura del documento XML del DDP...");
        if (this.grafico == null) {
            return;
        }
        this.grafico.inicializar();
    }

    public void endDocument() {
        if (this.grafico != null) {
            if (this.grafico.getTareasInvolucradasEnCarga() != null) {
                this.grafico.getTareasInvolucradasEnCarga().removeAllElements();
                this.grafico.tareasInvolucradasEnCarga = null;
            }
            if (this.grafico.getTareasEnFaseInvolucradasEnCarga() != null) {
                this.grafico.getTareasEnFaseInvolucradasEnCarga().removeAllElements();
                this.grafico.tareasEnFaseInvolucradasEnCarga = null;
            }
            if (this.grafico.getParametrosInvolucradosEnCarga() != null) {
                this.grafico.getParametrosInvolucradosEnCarga().removeAllElements();
                this.grafico.parametrosInvolucradosEnCarga = null;
            }
            if (this.grafico.getTiposParrafoInvolucradosEnCarga() != null) {
                this.grafico.getTiposParrafoInvolucradosEnCarga().removeAllElements();
                this.grafico.tiposParrafoInvolucradosEnCarga = null;
            }
            if (this.grafico.getTiposActoInvolucradosEnCarga() != null) {
                this.grafico.getTiposActoInvolucradosEnCarga().removeAllElements();
                this.grafico.tiposActoInvolucradosEnCarga = null;
            }
            if (this.grafico.getPlantillasInvolucradasEnCarga() != null) {
                this.grafico.getPlantillasInvolucradasEnCarga().removeAllElements();
                this.grafico.plantillasInvolucradasEnCarga = null;
            }
            if (this.grafico.getVariablesInvolucradasEnCarga() != null) {
                this.grafico.getVariablesInvolucradasEnCarga().removeAllElements();
                this.grafico.variablesInvolucradasEnCarga = null;
            }
            if (this.grafico.getTiposOrganismoInvolucradosEnCarga() != null) {
                this.grafico.getTiposOrganismoInvolucradosEnCarga().removeAllElements();
                this.grafico.tiposOrganismoInvolucradosEnCarga = null;
            }
            if (this.grafico.getOrganismosInvolucradosEnCarga() != null) {
                this.grafico.getOrganismosInvolucradosEnCarga().removeAllElements();
                this.grafico.organismosInvolucradosEnCarga = null;
            }
            if (this.grafico.getTiposIndicacionInvolucradosEnCarga() != null) {
                this.grafico.getTiposIndicacionInvolucradosEnCarga().removeAllElements();
                this.grafico.tiposIndicacionInvolucradosEnCarga = null;
            }
            if (this.grafico.getTiposNormativaInvolucradosEnCarga() != null) {
                this.grafico.getTiposNormativaInvolucradosEnCarga().removeAllElements();
                this.grafico.tiposNormativaInvolucradosEnCarga = null;
            }
            if (this.grafico.getTiposPublicacionInvolucradosEnCarga() != null) {
                this.grafico.getTiposPublicacionInvolucradosEnCarga().removeAllElements();
                this.grafico.tiposPublicacionInvolucradosEnCarga = null;
            }
            if (this.grafico.getAmbitosLeyInvolucradosEnCarga() != null) {
                this.grafico.getAmbitosLeyInvolucradosEnCarga().removeAllElements();
                this.grafico.ambitosLeyInvolucradosEnCarga = null;
            }
            if (this.grafico.getNormativasInvolucradasEnCarga() != null) {
                this.grafico.getNormativasInvolucradasEnCarga().removeAllElements();
                this.grafico.normativasInvolucradasEnCarga = null;
            }
        }
        System.out.println("- Termina la lectura del documento XML del DDP");
    }

    public void startElement(String uri, String localName, String qName, Attributes att) throws SAXException {
        if (this.bPrimeraEtiqueta) {
            if (qName.equals("DEF_PROCEDIMIENTO") || qName.equals("DEF_PROCEDIMIENTO_MODELA")) {
                this.bXMLValido = true;
                if (this.grafico != null) {
                    if (qName.equals("DEF_PROCEDIMIENTO")) {
                        this.grafico.setCerrado(true);
                    } else {
                        this.grafico.setCerrado(false);
                    }
                }
            } else {
                this.bXMLValido = false;
            }
            this.bPrimeraEtiqueta = false;
        }
        if (!this.bXMLValido) {
            return;
        }
        if (qName.equals("DEF_PROCEDIMIENTOS_R")) {
            this.bProcesandoReutilizables = true;
            ++this.nGruposReutilizablesOpen;
        }
        if (qName.equals("DEF_PROCEDIMIENTO_R")) {
            this.bProcesandoReutilizables = true;
            try {
                this.crearDefProc(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("DEFINICI\u00d3N DE PROCEDIMIENTO REUTILIZABLE:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("DEF_PROCEDIMIENTO") || qName.equals("DEF_PROCEDIMIENTO_MODELA")) {
            try {
                this.crearDefProc(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("DEFINICI\u00d3N DE PROCEDIMIENTOS:\nError durante el proceso de carga");
            }
            return;
        }
        if (this.grafico.isProcesado()) {
            return;
        }
        if (qName.equals("PERFIL_USUARIO")) {
            try {
                this.crearPerfilUsuario(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("PERFIL DE USUARIO:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("PARAMETRO")) {
            try {
                this.crearParametro(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("PARAMETRO:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("BLOQUE")) {
            try {
                this.crearBloque(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("BLOQUE:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("PARAMETRO_BLOQUE")) {
            try {
                this.addParametroBloque(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("PAR\u00c1METRO DEL BLOQUE:\nError durante el proceso de carga");
            }
        }
        if (qName.equals("TIPO_PARRAFO") || qName.equals("PARRAFO")) {
            try {
                this.crearTipoParrafo(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("TIPO DE P\u00c1RRAFO:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("PLANTILLA")) {
            try {
                this.crearPlantilla(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("PLANTILLA:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("TIPO_ACTO")) {
            try {
                this.crearTipoActo(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("TIPO DE ACTO:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("VARIABLE")) {
            try {
                this.crearVariable(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("VARIABLE:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("PARAMETRO_VARIABLE")) {
            try {
                this.addParametroVariable(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("PAR\u00c1METRO DE LA VARIABLE:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("TIPO_DOCUMENTO")) {
            try {
                this.crearTipoDocumento(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("TIPO DE DOCUMENTO:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("PARRAFO_TIPDOC")) {
            try {
                this.addParrafoTipoDocTipoDocumento(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("P\u00c1RRAFO DEL TIPO DOCUMENTO:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("VARIABLE_ID")) {
            try {
                this.addVariableTipoDocumento(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("VARIABLES DEL TIPO DE DOCUMENTO:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("TAREA")) {
            if (this.nVersionTrewa == 0) {
                try {
                    this.crearTarea_v0(att);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new SAXException("TAREAS:\nError durante el proceso de carga");
                }
            }
            if (this.nVersionTrewa == 1) {
                try {
                    this.crearTarea_v1(att);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new SAXException("TAREAS:\nError durante el proceso de carga");
                }
            }
            return;
        }
        if (qName.equals("DATOS_BLOQUES")) {
            try {
                this.addBloqueTarea_v0(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("TAREA TIPO BLOQUE:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("DATOS_DOCUMENTO")) {
            try {
                this.addDocumentoTarea_v0(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("TAREA TIPO DOCUMENTO:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("CONDICION")) {
            try {
                this.crearCondicion(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("CONDICI\u00d3N:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("ACCION")) {
            try {
                this.crearAccion(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("ACCI\u00d3N:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("AVISO")) {
            try {
                this.crearAviso(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("AVISO:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("METAFASE")) {
            try {
                this.crearMetafase(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("METAFASE:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("FASE")) {
            try {
                this.crearFase(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("FASE:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("TRANSICION")) {
            try {
                this.crearTransicion(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("TRANSICI\u00d3N:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("PERFIL_TRANSICION")) {
            try {
                this.addPerfilTransicion(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("PERFIL EN TRANSICI\u00d3N:\nError durante el proceso de carga");
            }
        }
        if (qName.equals("FASE_INI")) {
            this.bFaseIDIni = true;
            this.bFaseIDFin = false;
            return;
        }
        if (qName.equals("FASES_FIN")) {
            this.bFaseIDIni = false;
            this.bFaseIDFin = true;
            return;
        }
        if (qName.equals("FASE_ID")) {
            try {
                this.crearFaseTransicion(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("FASE EN TRANSICI\u00d3N:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("TAREA_FASE")) {
            if (this.nVersionTrewa == 0) {
                try {
                    this.crearTareaEnFase_v0(att);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new SAXException("TAREA EN FASE:\nError durante el proceso de carga");
                }
            }
            if (this.nVersionTrewa == 1) {
                try {
                    this.crearTareaEnFase_v1(att);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new SAXException("TAREA EN FASE:\nError durante el proceso de carga");
                }
            }
            return;
        }
        if (qName.equals("PERFIL_TAREA")) {
            try {
                this.addPerfilTenFase(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("PERFIL EN TAREA EN FASE:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("CONDICION_TRANSICION")) {
            try {
                this.crearCondicionTransicion(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("CONDICI\u00d3N EN TRANSICI\u00d3N:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("ACCION_TRANSICION")) {
            try {
                this.crearAccionTransicion(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("ACCI\u00d3N EN TRANSICI\u00d3N:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("AVISO_TRANSICION")) {
            try {
                this.crearAvisoTransicion(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("AVISO EN TRANSICI\u00d3N:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("CONDICION_TAREA")) {
            try {
                this.crearCondicionTarea(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("CONDICI\u00d3N EN TAREA EN FASE:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("ACCION_TAREA")) {
            try {
                this.crearAccionTarea(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("ACCI\u00d3N EN TAREA EN FASE:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("AVISO_TAREA")) {
            try {
                this.crearAvisoTarea(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("AVISO EN TAREA EN FASE:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("PLAZO_SIMPLE")) {
            try {
                this.crearPlazoSimple(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("PLAZO SIMPLE:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("PLAZO_COMPUESTO")) {
            try {
                this.crearPlazoCompuesto(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("PLAZO COMPUESTO:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("TRANSICIONES_INI")) {
            this.bTransicionIDIni = true;
            this.bTransicionIDFin = false;
            return;
        }
        if (qName.equals("TRANSICIONES_FIN")) {
            this.bTransicionIDIni = false;
            this.bTransicionIDFin = true;
            return;
        }
        if (qName.equals("TRANSICION_ID")) {
            try {
                this.addTransicionPlazoCompuesto(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("TRANSICI\u00d3N EN PLAZO COMPUESTO:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("TIPO_ORGANISMO")) {
            try {
                this.crearTipoOrganismo(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("TIPO DE ORGANISMO:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("ORGANISMO")) {
            try {
                this.crearOrganismo(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("ORGANISMO:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("ORGANISMO_PROC")) {
            try {
                this.crearOrganismoDelProcedimiento(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("ORGANISMO DEL PROCEDIMIENTO:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("TIPO_INDICACION")) {
            try {
                this.crearTipoIndicacion(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("TIPO DE INDICACI\u00d3N:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("INDICACION_FICHA")) {
            try {
                this.crearFichaProcedimiento(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("INDICACI\u00d3N FICHA:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("TIPO_NORMATIVA")) {
            try {
                this.crearTipoNormativa(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("TIPO DE NORMATIVA:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("TIPO_PUBLICACION")) {
            try {
                this.crearTipoPublicacion(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("TIPO DE PUBLICACI\u00d3N:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("AMBITO_LEY")) {
            try {
                this.crearAmbitoLey(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("AMBITO LEY:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("NORMATIVA")) {
            try {
                this.crearNormativa(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("NORMATIVA:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("NORMATIVA_ID")) {
            try {
                this.crearNormativaDelProcedimiento(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("NORMATIVA DEL PROCEDIMIENTO:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("PLANTILLA_PROCEDIMIENTO")) {
            try {
                this.crearPlantillaProcedimiento(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("PLANTILLA DEL PROCEDIMIENTO:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("DEFPROC_GR")) {
            try {
                this.crearDefProcGr(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("DEFINICI\u00d3N GR\u00c1FICA DEL PROCEDIMIENTO:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("METAFASE_GR")) {
            try {
                this.crearGraficoMetafase(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("GR\u00c1FICO DE METAFASE:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("EXTREMOTRAN_GR")) {
            try {
                this.crearGraficoExtremo(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("GR\u00c1FICO DE EXTREMO TRANSICI\u00d3N:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("TRANSICION_GR")) {
            try {
                this.crearGraficoTransicion(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("GR\u00c1FICO DE TRANSICI\u00d3N:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("NODO_TRANGR")) {
            try {
                this.crearNodoTransicion(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("NODO DE TRANSICI\u00d3N:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("POST_IT")) {
            try {
                this.crearPostIt(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("POST IT:\nError durante el proceso de carga");
            }
            return;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.bXMLValido) {
            return;
        }
        if (qName.equals("DEF_PROCEDIMIENTOS_R")) {
            --this.nGruposReutilizablesOpen;
            if (this.nGruposReutilizablesOpen < 1) {
                this.bProcesandoReutilizables = false;
            }
            return;
        }
        if (qName.equals("DEF_PROCEDIMIENTO") || qName.equals("DEF_PROCEDIMIENTO_MODELA")) {
            this.grafico.setProcesado(true);
            this.listaRecorridoDDP.remove(this.listaRecorridoDDP.size() - 1);
            this.grafico = this.listaRecorridoDDP.size() > 0 ? (DDPGrafico)this.listaRecorridoDDP.get(this.listaRecorridoDDP.size() - 1) : null;
            return;
        }
        if (qName.equals("DEF_PROCEDIMIENTO_R")) {
            this.grafico.setProcesado(true);
            this.listaRecorridoDDP.remove(this.listaRecorridoDDP.size() - 1);
            this.grafico = this.listaRecorridoDDP.size() > 0 ? (DDPGrafico)this.listaRecorridoDDP.get(this.listaRecorridoDDP.size() - 1) : null;
            this.bProcesandoReutilizables = false;
            return;
        }
        if (this.grafico.isProcesado()) {
            return;
        }
        if (qName.equals("BLOQUE")) {
            try {
                this.trBloqueActivo.eliminarParametrosNulos();
                this.controlDuplicidadBloque();
                this.trBloqueActivo = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("/BLOQUES:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("VARIABLE")) {
            try {
                this.trVariableActiva.eliminarParametrosNulos();
                this.controlDuplicidadVariable();
                this.trVariableActiva = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("/VARIABLES:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("TIPO_DOCUMENTO")) {
            try {
                this.controlDuplicidadTipoDocumento();
                this.tipoDocumentoActivo = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("/TIPOS DE DOCUMENTO:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("TAREA")) {
            this.tareaActiva = null;
            return;
        }
        if (qName.equals("METAFASE")) {
            this.metafaseActiva = null;
            return;
        }
        if (qName.equals("FASE")) {
            this.faseActiva = null;
            return;
        }
        if (qName.equals("TRANSICION")) {
            try {
                if (this.transicionActiva != null && this.grafico != null) {
                    if (this.grafico.getTransicionesInvolucradas().obtenerDato(this.transicionActiva.getTRANID()) == null) {
                        this.grafico.getTransicionesInvolucradas().add(this.transicionActiva, this.grafico.getDDP().getTIPOEVOL().getTIEVID());
                    } else {
                        this.transicionActiva = (TrTransicion)this.grafico.getTransicionesInvolucradas().obtenerDato(this.transicionActiva.getTRANID());
                        this.transicionActiva.addReferencia(this.grafico.getDDP().getTIPOEVOL().getTIEVID());
                    }
                }
                this.transicionActiva = null;
                if (this.transicionProcActiva != null && this.grafico != null) {
                    this.grafico.getTransicionesDelProcInvolucradas().add(this.transicionProcActiva);
                }
                this.transicionProcActiva = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("/TRANSICI\u00d3N:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("FASE_INI")) {
            this.bFaseIDIni = false;
            return;
        }
        if (qName.equals("FASES_FIN")) {
            this.bFaseIDFin = false;
            return;
        }
        if (qName.equals("TAREA_FASE")) {
            try {
                this.tEnFaseActiva = null;
                if (this.tareaFaseProcActiva != null && this.grafico != null) {
                    double idTareaEnFase = this.tareaFaseProcActiva.getTareaEnFase().getX_ID().doubleValue();
                    if (this.grafico.getTareaFaseDefProcInvolucradas().getTareaEnFaseDefProcedimiento(idTareaEnFase) == null) {
                        this.grafico.getTareaFaseDefProcInvolucradas().add(this.tareaFaseProcActiva);
                    }
                }
                this.tareaFaseProcActiva = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("/TAREAS EN FASE:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("PLAZO_COMPUESTO")) {
            try {
                if (this.plazoCompuestoActivo != null) {
                    if (this.grafico.getDDP() != null && this.grafico.getDDP().getTIPOEVOL() != null && this.grafico.getDDP().getTIPOEVOL().getPlazosCompuestosProcedimiento() != null) {
                        if (this.grafico.getDDP().getTIPOEVOL().getPlazosCompuestosProcedimiento().obtenerDato(this.plazoCompuestoActivo.getXID()) == null) {
                            this.grafico.getDDP().getTIPOEVOL().getPlazosCompuestosProcedimiento().add(this.plazoCompuestoActivo);
                        } else {
                            this.plazoCompuestoActivo = (TrPlazoCompuestoDefProc)this.grafico.getDDP().getTIPOEVOL().getPlazosCompuestosProcedimiento().obtenerDato(this.plazoCompuestoActivo.getXID());
                        }
                    }
                    this.plazoCompuestoActivo = null;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("/PLAZOS COMPUESTOS:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("TRANSICIONES_INI")) {
            this.bTransicionIDIni = false;
            return;
        }
        if (qName.equals("TRANSICIONES_FIN")) {
            this.bTransicionIDFin = false;
            return;
        }
        if (qName.equals("ORGANISMOS")) {
            this.asociarOrganismosPadre();
            return;
        }
        if (qName.equals("TRANSICION_GR")) {
            try {
                if (this.transicionGrActivo == null) {
                    return;
                }
                if (this.grafico.getCanvas() != null && !this.grafico.getCanvas().isGrTransicionCoherente(this.transicionGrActivo, this.pNodoActivoIni, this.pNodoActivoFin)) {
                    System.out.println("- Gr\u00e1fico de transici\u00f3n incoherente encontrado.");
                    this.transicionGrActivo = null;
                    this.grafico.setIncoherente(true);
                    return;
                }
                this.transicionGrActivo.ordenarVertices();
                TransicionPNode pNodoTr = new TransicionPNode(this.transicionGrActivo, this.getGrafico().getCanvas());
                pNodoTr.setPNodoGraficoFaseIni(this.pNodoActivoIni);
                pNodoTr.setPNodoGraficoFaseFin(this.pNodoActivoFin);
                pNodoTr.notificarCreacionAExtremos();
                this.grafico.getCanvas().getLayer().addChild((PNode)pNodoTr);
                this.transicionGrActivo = null;
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("/GR\u00c1FICO DE TRANSICI\u00d3N:\nError durante el proceso de carga");
            }
        }
        if (qName.equals("POST_IT")) {
            try {
                if (this.postItActivo == null) {
                    return;
                }
                this.grafico.getCanvas().getLayer().addChild((PNode)this.postItActivo);
                this.postItActivo = null;
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("/POSTIT:\nError durante el proceso de carga");
            }
        }
    }

    public void warning(SAXParseException e) throws SAXException {
        System.out.println("- [ Alerta ] " + e.getMessage());
        this.bProcesoFallido = true;
    }

    public void error(SAXParseException e) throws SAXException {
        System.out.println("- [ Error ] Durante la lectura del XML del DDP");
        this.bProcesoFallido = true;
        throw new SAXException(e.getMessage());
    }

    public void fatalError(SAXParseException e) throws SAXException {
        System.out.println("- [ Error ] Durante la lectura del XML del DDP: ");
        System.out.println("- Linea: " + this.locator.getLineNumber());
        System.out.println("- Columna: " + this.locator.getColumnNumber());
        System.out.println("- PublicID: " + this.locator.getPublicId());
        System.out.println("- SystemID: " + this.locator.getSystemId());
        System.out.println(e.getMessage());
        this.bProcesoFallido = true;
        throw new SAXException(e.getMessage());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean crearDefProc(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        if (!this.bProcesandoReutilizables) {
            this.listaRecorridoDDP.add(this.grafico);
        } else {
            this.grafico = this.localizarDiagramaEnLista(new BigDecimal(att.getValue("id")));
            if (this.grafico == null) {
                this.grafico = new DDPGrafico((DDPGrafico)this.listaRecorridoDDP.get(0));
                this.canvasReutilizable = new PCanvasModela();
                this.grafico.setCanvas(this.canvasReutilizable);
                this.canvasReutilizable.setDiagrama(this.grafico);
                ((DDPGrafico)this.listaRecorridoDDP.get(0)).addDDP(this.grafico);
            }
            this.listaRecorridoDDP.add(this.grafico);
        }
        this.tipoEvolActivo = new TrTipoEvol();
        if (att.getValue("id") == null) return false;
        String strId = att.getValue("id");
        this.tipoEvolActivo.setTIEVID(new BigDecimal(strId));
        if (this.auxID < Long.parseLong(strId)) {
            this.auxID = Long.parseLong(strId);
        }
        if (att.getValue("nombre") == null) {
            return false;
        }
        this.tipoEvolActivo.setABREVIATURA(att.getValue("nombre"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.tipoEvolActivo.setDESCRIPCION(att.getValue("descripcion"));
        if (att.getValue("sistema") == null) return false;
        if (!this.bProcesandoReutilizables) {
            this.tipoEvolActivo.setSISTEMA(att.getValue("sistema"));
            this.sistemaPrincipal = new String(this.tipoEvolActivo.getSISTEMA());
        } else {
            if (this.sistemaPrincipal == null) return false;
            this.tipoEvolActivo.setSISTEMA(this.sistemaPrincipal);
        }
        if (att.getValue("version") != null) {
            String strVersion = att.getValue("version");
            strVersion = strVersion.replace('.', '-');
            int nVersionTmp = Integer.parseInt(strVersion = strVersion.replaceAll("-", ""));
            if (nVersionTmp < 100) {
                this.nVersionTrewa = 0;
            }
            if (nVersionTmp >= 100) {
                this.nVersionTrewa = 1;
            }
        }
        if (att.getValue("organo") != null) {
            String strOrganoId = att.getValue("organo");
            this.tipoEvolActivo.setIdOrganoCarga(new BigDecimal(strOrganoId));
        }
        if (att.getValue("organo_competente") != null) {
            String strOrganoCompetenteId = att.getValue("organo_competente");
            this.tipoEvolActivo.setIdOrganoCompetenteCarga(new BigDecimal(strOrganoCompetenteId));
        }
        if (att.getValue("organo_resuelve") != null) {
            String strOrganoResuelveId = att.getValue("organo_resuelve");
            this.tipoEvolActivo.setIdOrganoResuelveCarga(new BigDecimal(strOrganoResuelveId));
        }
        if (att.getValue("organo_tramita") != null) {
            String strOrganoTramitaId = att.getValue("organo_tramita");
            this.tipoEvolActivo.setIdOrganoTramitaCarga(new BigDecimal(strOrganoTramitaId));
        }
        if (att.getValue("motor_tramita") != null) {
            this.tipoEvolActivo.setMotorTramita(att.getValue("motor_tramita"));
        }
        boolean bLogico = false;
        String sLogico = "N";
        if (att.getValue("informar") != null) {
            sLogico = att.getValue("informar");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.tipoEvolActivo.setINFORMAR(bLogico);
        if (att.getValue("descrip_ampliada") != null) {
            this.tipoEvolActivo.setDESCRIPCION_AMP(att.getValue("descrip_ampliada"));
        }
        sLogico = "N";
        if (att.getValue("vigente") != null) {
            sLogico = att.getValue("vigente");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.tipoEvolActivo.setVIGENTE(bLogico);
        if (att.getValue("categoria") != null) {
            this.tipoEvolActivo.setCATEGORIA(TrTipoCategoria.obtenerTipoCategoria(att.getValue("categoria")));
        }
        if (att.getValue("familia") != null) {
            this.tipoEvolActivo.setFamilia(att.getValue("familia"));
        }
        if (att.getValue("desc_familia") != null) {
            this.tipoEvolActivo.setDescripcionFamilia(att.getValue("desc_familia"));
        }
        if (att.getValue("subfamilia") != null) {
            this.tipoEvolActivo.setSubfamilia(att.getValue("subfamilia"));
        }
        if (att.getValue("desc_subfamilia") != null) {
            this.tipoEvolActivo.setDescripcionSubfamilia(att.getValue("desc_subfamilia"));
        }
        if (att.getValue("comentarios") != null) {
            this.tipoEvolActivo.setComentarios(att.getValue("comentarios"));
        }
        if (this.grafico.isCerrado()) {
            this.grafico.setEditable(ModelaConf.getMarcarReutilizablesComoEditables());
        } else if (att.getValue("editable") != null) {
            if (att.getValue("editable").equals("S")) {
                this.grafico.setEditable(true);
            } else if (att.getValue("editable").equals("N")) {
                this.grafico.setEditable(false);
            }
        }
        DefProcGr defProc = new DefProcGr();
        defProc.setTIPOEVOL(this.tipoEvolActivo);
        if (this.grafico.getDDP() != null) return true;
        this.grafico.setDDP(defProc);
        return true;
    }

    private DDPGrafico localizarDiagramaEnLista(BigDecimal idDDP) {
        ArrayList listaDDPsTratados = ((DDPGrafico)this.listaRecorridoDDP.get(0)).getListaDDPs();
        if (listaDDPsTratados == null) {
            return null;
        }
        if (listaDDPsTratados.size() < 1) {
            return null;
        }
        for (int n = 0; n < listaDDPsTratados.size(); ++n) {
            if (((DDPGrafico)listaDDPsTratados.get(n)).getDDP().getTIPOEVOL().getTIEVID().longValue() != idDDP.longValue()) continue;
            return (DDPGrafico)listaDDPsTratados.get(n);
        }
        return null;
    }

    public boolean crearPerfilUsuario(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.perfilActivo = new TrPerfilUsuario();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.perfilActivo.setX_PEUS(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("nombre") == null) {
            return false;
        }
        this.perfilActivo.setNOMBRE(att.getValue("nombre"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.perfilActivo.setDESCRIPCION(att.getValue("descripcion"));
        this.controlDuplicidadPerfil();
        return true;
    }

    public boolean crearParametro(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.trParametroActivo = new TrParametro();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            BigDecimal bdId = new BigDecimal(strId);
            TpoPK id = new TpoPK(bdId);
            this.trParametroActivo.setPARAMID(id);
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("nombre") == null) {
            return false;
        }
        this.trParametroActivo.setNOMBRE(att.getValue("nombre"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.trParametroActivo.setDESCRIPCION(att.getValue("descripcion"));
        if (att.getValue("tipo") == null) {
            return false;
        }
        String strTipo = att.getValue("tipo");
        this.trParametroActivo.setTipoParametro(TrTipoParametro.obtenerTipoParametro(strTipo));
        if (att.getValue("tamanio") != null) {
            this.trParametroActivo.setTAMANIO(Long.parseLong(att.getValue("tamanio")));
        }
        this.controlDuplicidadParametro();
        return true;
    }

    public boolean crearBloque(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.trBloqueActivo = new TrBloque();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            BigDecimal bdId = new BigDecimal(strId);
            TpoPK id = new TpoPK(bdId);
            this.trBloqueActivo.setBloqueId(id);
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("nombre") == null) {
            return false;
        }
        this.trBloqueActivo.setNombre(att.getValue("nombre"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.trBloqueActivo.setDescripcion(att.getValue("descripcion"));
        if (att.getValue("tipo") == null) {
            return false;
        }
        String strTipo = att.getValue("tipo");
        this.trBloqueActivo.setTipoBloque(TrTipoBloque.obtenerTipoBloque(strTipo));
        boolean bLogico = false;
        String sLogico = "N";
        if (att.getValue("informar") != null) {
            sLogico = att.getValue("informar");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.trBloqueActivo.setInformar(bLogico);
        return true;
    }

    public boolean addParametroBloque(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        if (this.trBloqueActivo == null) {
            return false;
        }
        String strId = null;
        if (att.getValue("parametro_id") == null) {
            return false;
        }
        strId = att.getValue("parametro_id");
        int ordenPara = -1;
        ordenPara = att.getValue("orden") != null ? new Integer(att.getValue("orden")) : -1;
        BigDecimal idParametro = new BigDecimal(strId);
        if (this.grafico.getParametrosInvolucradosEnCarga() != null) {
            TrParametro parametro = this.grafico.getParametrosInvolucradosEnCarga().obtenerParametroDeParametrosEnCarga(idParametro);
            if (parametro != null) {
                if (ordenPara != -1) {
                    this.trBloqueActivo.addParametro(parametro, ordenPara);
                } else {
                    this.trBloqueActivo.addParametro(parametro);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean crearTipoParrafo(Attributes att) throws Exception {
        boolean bLogico = true;
        String sLogico = "S";
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.tipoParrafoActivo = new TrTipoParrafo();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.tipoParrafoActivo.setXID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("abreviatura") == null) {
            return false;
        }
        this.tipoParrafoActivo.setAbreviatura(att.getValue("abreviatura"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.tipoParrafoActivo.setDescripcion(att.getValue("descripcion"));
        if (att.getValue("contenido") != null) {
            this.tipoParrafoActivo.setContenido(att.getValue("contenido"));
        }
        if (att.getValue("alineacion") == null) {
            return false;
        }
        this.tipoParrafoActivo.setAlineacion(att.getValue("alineacion"));
        if (att.getValue("etiqueta") != null) {
            this.tipoParrafoActivo.setEtiqueta(att.getValue("etiqueta"));
        }
        if (att.getValue("estilo") == null) {
            return false;
        }
        this.tipoParrafoActivo.setEstilo(att.getValue("estilo"));
        if (att.getValue("estilo_etiq") == null) {
            return false;
        }
        this.tipoParrafoActivo.setEstiloEtiq(att.getValue("estilo_etiq"));
        if (att.getValue("ubicacion") == null) {
            return false;
        }
        this.tipoParrafoActivo.setUbicacion(att.getValue("ubicacion"));
        if (att.getValue("editable") == null) {
            return false;
        }
        sLogico = att.getValue("editable");
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.tipoParrafoActivo.setEditable(bLogico);
        if (att.getValue("nombre_fichero") != null) {
            this.tipoParrafoActivo.setNombreFichero(att.getValue("nombre_fichero"));
            this.tipoParrafoActivo.setRutaCompleta(ModelaConf.getRutaArchivo() + System.getProperty("file.separator") + this.tipoParrafoActivo.getNombreFichero());
            if (att.getValue("ruta_completa") != null) {
                this.tipoParrafoActivo.setRutaCompleta(att.getValue("ruta_completa"));
            }
        }
        if (att.getValue("formato") != null) {
            this.tipoParrafoActivo.setFormato(att.getValue("formato"));
        }
        this.controlDuplicidadTipoParrafo();
        return true;
    }

    public boolean crearPlantilla(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.PlantillaActiva = new TrPlantilla();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.PlantillaActiva.setXID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("nombre") == null) {
            return false;
        }
        this.PlantillaActiva.setNOMBRE(att.getValue("nombre"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.PlantillaActiva.setDESCRIPCION(att.getValue("descripcion"));
        if (att.getValue("nombre_informe") == null) {
            return false;
        }
        this.PlantillaActiva.setNOMBRE_INFORME(att.getValue("nombre_informe"));
        this.controlDuplicidadPlantilla();
        return true;
    }

    public boolean crearVariable(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.trVariableActiva = new TrVariable();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            BigDecimal bdId = new BigDecimal(strId);
            TpoPK id = new TpoPK(bdId);
            this.trVariableActiva.setVARIABLEID(id);
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("nombre") == null) {
            return false;
        }
        this.trVariableActiva.setNOMBRE(att.getValue("nombre"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.trVariableActiva.setDESCRIPCION(att.getValue("descripcion"));
        if (att.getValue("paquete") != null) {
            this.trVariableActiva.setPAQUETE(att.getValue("paquete"));
        }
        if (att.getValue("nombre_funcion") != null) {
            this.trVariableActiva.setFuncion(att.getValue("nombre_funcion"));
        }
        if (att.getValue("implementacion") != null) {
            this.trVariableActiva.setTipoImplementacion(new TrTipoImplementacion(att.getValue("implementacion")));
        }
        if (att.getValue("tipo_acto_id") != null) {
            this.addTipoActoVariable(att);
        }
        return true;
    }

    public boolean addTipoActoVariable(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        if (this.trVariableActiva == null) {
            return false;
        }
        String strId = null;
        if (att.getValue("tipo_acto_id") == null) {
            return false;
        }
        strId = att.getValue("tipo_acto_id");
        BigDecimal idTipoActo = new BigDecimal(strId);
        if (this.grafico.getTiposActoInvolucradosEnCarga() != null) {
            TrTipoActo tipoActo = this.grafico.getTiposActoInvolucradosEnCarga().obtenerTipoActoDeTiposActoEnCarga(idTipoActo);
            if (tipoActo != null) {
                this.trVariableActiva.setTipoActo(tipoActo);
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean addParametroVariable(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        if (this.trVariableActiva == null) {
            return false;
        }
        String strId = null;
        if (att.getValue("parametro_id") == null) {
            return false;
        }
        strId = att.getValue("parametro_id");
        int ordenPara = -1;
        ordenPara = att.getValue("orden") != null ? new Integer(att.getValue("orden")) : -1;
        BigDecimal idParametro = new BigDecimal(strId);
        if (this.grafico.getParametrosInvolucradosEnCarga() != null) {
            TrParametro parametro = this.grafico.getParametrosInvolucradosEnCarga().obtenerParametroDeParametrosEnCarga(idParametro);
            if (parametro != null) {
                if (ordenPara != -1) {
                    this.trVariableActiva.addParametro(parametro, ordenPara);
                } else {
                    this.trVariableActiva.addParametro(parametro);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean crearTipoDocumento(Attributes att) throws Exception {
        boolean bLogico = true;
        String sLogico = "S";
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.tipoDocumentoActivo = new TrTipoDocumento();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.tipoDocumentoActivo.setXID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("etiqueta") == null) {
            return false;
        }
        this.tipoDocumentoActivo.setEtiqueta(att.getValue("etiqueta"));
        if (att.getValue("nombre") == null) {
            return false;
        }
        this.tipoDocumentoActivo.setNombre(att.getValue("nombre"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.tipoDocumentoActivo.setDescripcion(att.getValue("descripcion"));
        if (att.getValue("plantilla_id") != null) {
            this.addPlantillaTipoDocumento(att);
        }
        if (att.getValue("ent_sal") == null) {
            return false;
        }
        this.tipoDocumentoActivo.setEntSal(att.getValue("ent_sal"));
        if (att.getValue("inc_gen") == null) {
            return false;
        }
        this.tipoDocumentoActivo.setIncGen(att.getValue("inc_gen"));
        if (att.getValue("multiple") == null) {
            return false;
        }
        sLogico = att.getValue("multiple");
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.tipoDocumentoActivo.setMultiple(bLogico);
        if (att.getValue("auxiliar") != null) {
            this.tipoDocumentoActivo.setAuxiliar(att.getValue("auxiliar"));
        }
        if (att.getValue("fecha_firma") == null) {
            return false;
        }
        sLogico = att.getValue("fecha_firma");
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.tipoDocumentoActivo.setFechaFirma(bLogico);
        sLogico = "N";
        if (att.getValue("informar") != null) {
            sLogico = att.getValue("informar");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.tipoDocumentoActivo.setInformar(bLogico);
        sLogico = "N";
        if (att.getValue("archivable") != null) {
            sLogico = att.getValue("archivable");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.tipoDocumentoActivo.setArchivable(bLogico);
        sLogico = "N";
        if (att.getValue("versionable") != null) {
            sLogico = att.getValue("versionable");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.tipoDocumentoActivo.setVersionable(bLogico);
        sLogico = "N";
        if (att.getValue("reutilizable") != null) {
            sLogico = att.getValue("reutilizable");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.tipoDocumentoActivo.setReutilizable(bLogico);
        sLogico = "N";
        if (att.getValue("registrable") != null) {
            sLogico = att.getValue("registrable");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.tipoDocumentoActivo.setRegistrable(bLogico);
        sLogico = "N";
        if (att.getValue("notificable") != null) {
            sLogico = att.getValue("notificable");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.tipoDocumentoActivo.setNotificable(bLogico);
        if (att.getValue("modogen") != null) {
            this.tipoDocumentoActivo.setModoGen(att.getValue("modogen"));
        } else {
            this.tipoDocumentoActivo.setModoGen("R");
        }
        if (att.getValue("clase_doc") != null) {
            this.tipoDocumentoActivo.setClaseDoc(att.getValue("clase_doc"));
        } else {
            this.tipoDocumentoActivo.setClaseDoc("G");
        }
        sLogico = "N";
        if (att.getValue("fusionar") != null) {
            sLogico = att.getValue("fusionar");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.tipoDocumentoActivo.setFusionar_Var(bLogico);
        sLogico = "N";
        if (att.getValue("firma_digital") != null) {
            sLogico = att.getValue("firma_digital");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.tipoDocumentoActivo.setFirma_Digi(bLogico);
        if (att.getValue("tipo_firma") != null) {
            this.tipoDocumentoActivo.setTipo_Firma(att.getValue("tipo_firma"));
        } else {
            this.tipoDocumentoActivo.setTipo_Firma("-");
        }
        if (att.getValue("nombre_fichero") != null) {
            this.tipoDocumentoActivo.setNom_Fichero(att.getValue("nombre_fichero"));
            this.tipoDocumentoActivo.setRuta(ModelaConf.getRutaArchivo() + System.getProperty("file.separator") + this.tipoDocumentoActivo.getT_Nom_Fichero());
            if (att.getValue("ruta_completa") != null) {
                this.tipoDocumentoActivo.setRuta(att.getValue("ruta_completa"));
            }
        }
        if (att.getValue("formato") != null) {
            this.tipoDocumentoActivo.setTFormato(att.getValue("formato"));
        }
        return true;
    }

    public boolean addPlantillaTipoDocumento(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        if (this.tipoDocumentoActivo == null) {
            return false;
        }
        String strId = null;
        if (att.getValue("plantilla_id") == null) {
            return false;
        }
        strId = att.getValue("plantilla_id");
        BigDecimal idPlantillaAux = new BigDecimal(strId);
        if (this.grafico.getPlantillasInvolucradasEnCarga() != null) {
            TrPlantilla plantilla = this.grafico.getPlantillasInvolucradasEnCarga().obtenerPlantillaDePlantillasEnCarga(idPlantillaAux);
            if (plantilla != null) {
                this.tipoDocumentoActivo.setPlantilla(plantilla);
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean addParrafoTipoDocTipoDocumento(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        boolean bLogico = true;
        String sLogico = "S";
        TrParrafoTipDoc parrafoTipDocActivo = new TrParrafoTipDoc();
        if (att.getValue("etiqueta") != null) {
            parrafoTipDocActivo.setEtiqueta(att.getValue("etiqueta"));
        }
        if (att.getValue("alineacion") == null) {
            return false;
        }
        parrafoTipDocActivo.setAlineacion(att.getValue("alineacion"));
        if (att.getValue("estilo") == null) {
            return false;
        }
        parrafoTipDocActivo.setEstilo(att.getValue("estilo"));
        if (att.getValue("estilo_etiq") == null) {
            return false;
        }
        parrafoTipDocActivo.setEstiloEtiq(att.getValue("estilo_etiq"));
        if (att.getValue("orden") == null) {
            return false;
        }
        parrafoTipDocActivo.setOrden(new Integer(att.getValue("orden")));
        if (att.getValue("editable") == null) {
            return false;
        }
        sLogico = att.getValue("editable");
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        parrafoTipDocActivo.setEditable(bLogico);
        String strId = null;
        if (att.getValue("tipo_parrafo") == null) {
            return false;
        }
        strId = att.getValue("tipo_parrafo");
        BigDecimal idTipoParrafo = new BigDecimal(strId);
        if (this.grafico.getTiposParrafoInvolucradosEnCarga() != null) {
            TrTipoParrafo tipoParrafo = this.grafico.getTiposParrafoInvolucradosEnCarga().obtenerTipoParrafoDeTiposParrafoEnCarga(idTipoParrafo);
            if (tipoParrafo != null) {
                parrafoTipDocActivo.setTipoParrafo(tipoParrafo);
            } else {
                return false;
            }
        }
        sLogico = "N";
        if (att.getValue("fusionar") != null) {
            sLogico = att.getValue("fusionar");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        parrafoTipDocActivo.setFusionar(bLogico);
        if (att.getValue("nombre_fichero") != null) {
            parrafoTipDocActivo.setNOMB_FICHERO(att.getValue("nombre_fichero"));
            parrafoTipDocActivo.setRutaCompleta(ModelaConf.getRutaArchivo() + System.getProperty("file.separator") + parrafoTipDocActivo.getNOMB_FICHERO());
            if (att.getValue("ruta_completa") != null) {
                parrafoTipDocActivo.setRutaCompleta(att.getValue("ruta_completa"));
            }
        }
        if (att.getValue("formato") != null) {
            parrafoTipDocActivo.setFORMATO(att.getValue("formato"));
        }
        if (att.getValue("parrafo") == null) {
            return false;
        }
        parrafoTipDocActivo.setParrafo(att.getValue("parrafo"));
        this.tipoDocumentoActivo.addParrafoTipoDoc(parrafoTipDocActivo);
        return true;
    }

    public boolean addVariableTipoDocumento(Attributes att) throws Exception {
        TrVariable variableToTipoDoc;
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        if (this.tipoDocumentoActivo == null) {
            return false;
        }
        BigDecimal idVariable = null;
        if (att.getValue("id") == null) {
            return false;
        }
        idVariable = new BigDecimal(att.getValue("id"));
        if (this.grafico.getVariablesInvolucradasEnCarga() != null && (variableToTipoDoc = this.grafico.getVariablesInvolucradasEnCarga().obtenerVariableDeVariablesEnCarga(idVariable)) != null) {
            this.tipoDocumentoActivo.addVariable(variableToTipoDoc);
        }
        return true;
    }

    public boolean crearTipoActo(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.tipoActoActivo = new TrTipoActo();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.tipoActoActivo.setTIPOID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("etiqueta") == null) {
            return false;
        }
        this.tipoActoActivo.setABREVIATURA(att.getValue("etiqueta"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.tipoActoActivo.setDESCRIPCION(att.getValue("descripcion"));
        this.controlDuplicidadTipoActo();
        return true;
    }

    public boolean crearTarea_v0(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        if (att.getValue("tipo") != null) {
            String strTipo = att.getValue("tipo");
            TrTipoTarea tipoTarea = TrTipoTarea.obtenerTipoTarea(strTipo);
            if (tipoTarea == null) {
                return false;
            }
            this.tareaActiva = tipoTarea.equals(TrTipoTarea.MANIPULAR_DATOS) ? new TrBloquePermitido() : new TrDocumentoPermitido();
            this.tareaActiva.setTrTipoTarea(TrTipoTarea.obtenerTipoTarea(strTipo));
        } else {
            this.tareaActiva = new TrBloquePermitido();
            this.tareaActiva.setTrTipoTarea(TrTipoTarea.MANIPULAR_DATOS);
        }
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.tareaActiva.setID_TAREA(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("nombre") == null) {
            return false;
        }
        this.tareaActiva.setNOMBRE(att.getValue("nombre"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.tareaActiva.setDESCRIPCION(att.getValue("descripcion"));
        return true;
    }

    public boolean addBloqueTarea_v0(Attributes att) throws Exception {
        TrBloque bloque;
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        if (this.tareaActiva == null) {
            return false;
        }
        if (!(this.tareaActiva instanceof TrBloquePermitido)) {
            return false;
        }
        TrBloquePermitido bloquePermitido = (TrBloquePermitido)this.tareaActiva;
        String strId = null;
        if (att.getValue("bloque_ini_id") == null) {
            return false;
        }
        strId = att.getValue("bloque_ini_id");
        BigDecimal idBloque = new BigDecimal(strId);
        if (this.grafico.getBloquesInvolucrados() != null) {
            bloque = (TrBloque)this.grafico.getBloquesInvolucrados().obtenerDato(idBloque);
            if (bloque != null) {
                bloquePermitido.setBloqueIni(bloque);
            } else {
                return false;
            }
        }
        strId = null;
        if (att.getValue("bloque_fin_id") == null) {
            return false;
        }
        strId = att.getValue("bloque_fin_id");
        idBloque = new BigDecimal(strId);
        if (this.grafico.getBloquesInvolucrados() != null) {
            bloque = (TrBloque)this.grafico.getBloquesInvolucrados().obtenerDato(idBloque);
            if (bloque != null) {
                bloquePermitido.setBloqueFin(bloque);
            } else {
                return false;
            }
        }
        boolean bBloqueEncontrado = false;
        if (this.grafico.getTareasInvolucradas().obtenerTareaBloque(bloquePermitido) == null) {
            this.grafico.getTareasInvolucradas().add(bloquePermitido);
        } else {
            bBloqueEncontrado = true;
            bloquePermitido = this.grafico.getTareasInvolucradas().obtenerTareaBloque(bloquePermitido);
        }
        TrTareaEnCarga tareaEnCarga = new TrTareaEnCarga();
        tareaEnCarga.setIdEnCarga(this.tareaActiva.getID_TAREA());
        tareaEnCarga.setTarea(bloquePermitido);
        this.grafico.getTareasInvolucradasEnCarga().add(tareaEnCarga);
        if (!bBloqueEncontrado) {
            ++this.idTareaUnico;
            bloquePermitido.setID_TAREA(new BigDecimal(String.valueOf(this.idTareaUnico)));
        }
        return true;
    }

    public boolean addDocumentoTarea_v0(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        if (this.tareaActiva == null) {
            return false;
        }
        if (!(this.tareaActiva instanceof TrDocumentoPermitido)) {
            return false;
        }
        TrDocumentoPermitido DocumentoPermitido = (TrDocumentoPermitido)this.tareaActiva;
        String strId = null;
        if (att.getValue("documento_id") == null) {
            return false;
        }
        strId = att.getValue("documento_id");
        BigDecimal idDocumento = new BigDecimal(strId);
        if (this.grafico.getTipoDocumentosInvolucrados() != null) {
            TrTipoDocumento tipoDocumento = (TrTipoDocumento)this.grafico.getTipoDocumentosInvolucrados().obtenerDato(idDocumento);
            if (tipoDocumento != null) {
                DocumentoPermitido.setTipoDocumento(tipoDocumento);
            } else {
                return false;
            }
        }
        boolean bDocumentoEncontrado = false;
        if (this.grafico.getTareasInvolucradas().obtenerTareaDocumento(DocumentoPermitido) == null) {
            this.grafico.getTareasInvolucradas().add(DocumentoPermitido);
        } else {
            bDocumentoEncontrado = true;
            DocumentoPermitido = this.grafico.getTareasInvolucradas().obtenerTareaDocumento(DocumentoPermitido);
        }
        TrTareaEnCarga tareaEnCarga = new TrTareaEnCarga();
        tareaEnCarga.setIdEnCarga(this.tareaActiva.getID_TAREA());
        tareaEnCarga.setTarea(DocumentoPermitido);
        this.grafico.getTareasInvolucradasEnCarga().add(tareaEnCarga);
        if (!bDocumentoEncontrado) {
            ++this.idTareaUnico;
            DocumentoPermitido.setID_TAREA(new BigDecimal(String.valueOf(this.idTareaUnico)));
        }
        return true;
    }

    public boolean crearTarea_v1(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        if (att.getValue("tipo") != null) {
            String strTipo = att.getValue("tipo");
            TrTipoTarea tipoTarea = TrTipoTarea.obtenerTipoTarea(strTipo);
            if (tipoTarea == null) {
                return false;
            }
            this.tareaActiva = tipoTarea.equals(TrTipoTarea.MANIPULAR_DATOS) || tipoTarea.equals(TrTipoTarea.OTROS) ? new TrBloquePermitido() : new TrDocumentoPermitido();
            this.tareaActiva.setTrTipoTarea(TrTipoTarea.obtenerTipoTarea(strTipo));
        } else {
            this.tareaActiva = new TrBloquePermitido();
            this.tareaActiva.setTrTipoTarea(TrTipoTarea.MANIPULAR_DATOS);
        }
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.tareaActiva.setID_TAREA(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("nombre") == null) {
            return false;
        }
        this.tareaActiva.setNOMBRE(att.getValue("nombre"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.tareaActiva.setDESCRIPCION(att.getValue("descripcion"));
        BigDecimal idTipoDoc_Bloque_Id = null;
        if (att.getValue("tipodoc_bloque_id") == null) {
            return false;
        }
        String strAux = att.getValue("tipodoc_bloque_id");
        idTipoDoc_Bloque_Id = new BigDecimal(strAux);
        if (this.tareaActiva instanceof TrDocumentoPermitido) {
            this.addDocumentoTarea_v1(idTipoDoc_Bloque_Id);
        } else {
            this.addBloqueTarea_v1(idTipoDoc_Bloque_Id);
        }
        return true;
    }

    public boolean addDocumentoTarea_v1(BigDecimal idDocumento) {
        if (this.grafico == null) {
            return false;
        }
        if (this.tareaActiva == null) {
            return false;
        }
        if (idDocumento == null) {
            return false;
        }
        if (!(this.tareaActiva instanceof TrDocumentoPermitido)) {
            return false;
        }
        TrDocumentoPermitido documentoPermitido = (TrDocumentoPermitido)this.tareaActiva;
        if (this.grafico.getTipoDocumentosInvolucrados() != null) {
            TrTipoDocumento tipoDocumento = (TrTipoDocumento)this.grafico.getTipoDocumentosInvolucrados().obtenerDato(idDocumento);
            if (tipoDocumento != null) {
                documentoPermitido.setTipoDocumento(tipoDocumento);
            } else {
                return false;
            }
        }
        boolean bDocumentoEncontrado = false;
        if (this.grafico.getTareasInvolucradas().obtenerTareaDocumento(documentoPermitido) == null) {
            this.grafico.getTareasInvolucradas().add(documentoPermitido);
        } else {
            bDocumentoEncontrado = true;
            documentoPermitido = this.grafico.getTareasInvolucradas().obtenerTareaDocumento(documentoPermitido);
        }
        TrTareaEnCarga tareaEnCarga = new TrTareaEnCarga();
        tareaEnCarga.setIdEnCarga(this.tareaActiva.getID_TAREA());
        tareaEnCarga.setTarea(documentoPermitido);
        this.grafico.getTareasInvolucradasEnCarga().add(tareaEnCarga);
        if (!bDocumentoEncontrado) {
            ++this.idTareaUnico;
            documentoPermitido.setID_TAREA(new BigDecimal(String.valueOf(this.idTareaUnico)));
        }
        return true;
    }

    public boolean addBloqueTarea_v1(BigDecimal idBloque) {
        if (this.grafico == null) {
            return false;
        }
        if (idBloque == null) {
            return false;
        }
        if (this.tareaActiva == null) {
            return false;
        }
        if (!(this.tareaActiva instanceof TrBloquePermitido)) {
            return false;
        }
        TrBloquePermitido bloquePermitido = (TrBloquePermitido)this.tareaActiva;
        if (this.grafico.getBloquesInvolucrados() != null) {
            TrBloque bloque = (TrBloque)this.grafico.getBloquesInvolucrados().obtenerDato(idBloque);
            if (bloque != null) {
                bloquePermitido.setBloqueFin(bloque);
            } else {
                return false;
            }
        }
        boolean bBloqueEncontrado = false;
        if (this.grafico.getTareasInvolucradas().obtenerTareaBloque(bloquePermitido) == null) {
            this.grafico.getTareasInvolucradas().add(bloquePermitido);
        } else {
            bBloqueEncontrado = true;
            bloquePermitido = this.grafico.getTareasInvolucradas().obtenerTareaBloque(bloquePermitido);
        }
        TrTareaEnCarga tareaEnCarga = new TrTareaEnCarga();
        tareaEnCarga.setIdEnCarga(this.tareaActiva.getID_TAREA());
        tareaEnCarga.setTarea(bloquePermitido);
        this.grafico.getTareasInvolucradasEnCarga().add(tareaEnCarga);
        if (!bBloqueEncontrado) {
            ++this.idTareaUnico;
            bloquePermitido.setID_TAREA(new BigDecimal(String.valueOf(this.idTareaUnico)));
        }
        return true;
    }

    public boolean crearCondicion(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.condicionActiva = new TrCondicion();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.condicionActiva.setXID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("nombre") == null) {
            return false;
        }
        this.condicionActiva.setNombre(att.getValue("nombre"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.condicionActiva.setDescripcion(att.getValue("descripcion"));
        boolean bLogico = false;
        String sLogico = "N";
        if (att.getValue("param_ref_exp") != null) {
            sLogico = att.getValue("param_ref_exp");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.condicionActiva.setExp(bLogico);
        sLogico = "N";
        if (att.getValue("param_ref_tran") != null) {
            sLogico = att.getValue("param_ref_tran");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.condicionActiva.setTrans(bLogico);
        sLogico = "N";
        if (att.getValue("param_ref_docper") != null) {
            sLogico = att.getValue("param_ref_docper");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.condicionActiva.setDocPermitido(bLogico);
        sLogico = "N";
        if (att.getValue("param_ref_expxfas") != null) {
            sLogico = att.getValue("param_ref_expxfas");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.condicionActiva.setExpEnFase(bLogico);
        sLogico = "N";
        if (att.getValue("param_ref_tipevo") != null) {
            sLogico = att.getValue("param_ref_tipevo");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.condicionActiva.setTipoEvol(bLogico);
        sLogico = "N";
        if (att.getValue("param_ref_fecha") != null) {
            sLogico = att.getValue("param_ref_fecha");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.condicionActiva.setFecha(bLogico);
        sLogico = "N";
        if (att.getValue("param_ref_usuario") != null) {
            sLogico = att.getValue("param_ref_usuario");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.condicionActiva.setUsuario(bLogico);
        sLogico = "N";
        if (att.getValue("param_ref_fase") != null) {
            sLogico = att.getValue("param_ref_fase");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.condicionActiva.setFase(bLogico);
        sLogico = "N";
        if (att.getValue("param_ref_tipdoc") != null) {
            sLogico = att.getValue("param_ref_tipdoc");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.condicionActiva.setTipo_Documento(bLogico);
        if (att.getValue("implementacion") != null) {
            this.condicionActiva.setTipoImplementacion(new TrTipoImplementacion(att.getValue("implementacion")));
        } else {
            this.condicionActiva.setTipoImplementacion(new TrTipoImplementacion("F"));
        }
        if (att.getValue("paquete") != null) {
            this.condicionActiva.setPaquete(att.getValue("paquete"));
        }
        if (att.getValue("nombre_funcion") != null) {
            this.condicionActiva.setFuncion(att.getValue("nombre_funcion"));
        }
        sLogico = "N";
        if (att.getValue("compleja") != null) {
            sLogico = att.getValue("compleja");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.condicionActiva.setExpresionCompleja(bLogico);
        if (att.getValue("expresion") != null) {
            this.condicionActiva.setValorExpresionCompleja(att.getValue("expresion"));
        }
        if (att.getValue("texto_libre") != null) {
            this.condicionActiva.setTextoLibre(att.getValue("texto_libre"));
        }
        this.controlDuplicidadCondicion();
        return true;
    }

    public boolean crearAccion(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.accionActiva = new TrAccion();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.accionActiva.setXID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("nombre") == null) {
            return false;
        }
        this.accionActiva.setNombre(att.getValue("nombre"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.accionActiva.setDescripcion(att.getValue("descripcion"));
        boolean bLogico = true;
        String sLogico = "S";
        if (att.getValue("param_ref_exp") != null) {
            sLogico = att.getValue("param_ref_exp");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.accionActiva.setExp(bLogico);
        sLogico = "N";
        if (att.getValue("param_ref_tran") != null) {
            sLogico = att.getValue("param_ref_tran");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.accionActiva.setTrans(bLogico);
        sLogico = "N";
        if (att.getValue("param_ref_docper") != null) {
            sLogico = att.getValue("param_ref_docper");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.accionActiva.setDocPermitido(bLogico);
        sLogico = "N";
        if (att.getValue("param_ref_expxfas") != null) {
            sLogico = att.getValue("param_ref_expxfas");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.accionActiva.setExpEnFase(bLogico);
        sLogico = "N";
        if (att.getValue("param_ref_tipevo") != null) {
            sLogico = att.getValue("param_ref_tipevo");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.accionActiva.setTipoEvol(bLogico);
        sLogico = "N";
        if (att.getValue("param_ref_fecha") != null) {
            sLogico = att.getValue("param_ref_fecha");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.accionActiva.setFecha(bLogico);
        sLogico = "N";
        if (att.getValue("param_ref_usuario") != null) {
            sLogico = att.getValue("param_ref_usuario");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.accionActiva.setUsuario(bLogico);
        sLogico = "N";
        if (att.getValue("param_ref_fase") != null) {
            sLogico = att.getValue("param_ref_fase");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.accionActiva.setFase(bLogico);
        sLogico = "N";
        if (att.getValue("param_ref_tipdoc") != null) {
            sLogico = att.getValue("param_ref_tipdoc");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.accionActiva.setTipo_Documento(bLogico);
        if (att.getValue("implementacion") != null) {
            this.accionActiva.setTipoImplementacion(new TrTipoImplementacion(att.getValue("implementacion")));
        } else {
            this.accionActiva.setTipoImplementacion(new TrTipoImplementacion("F"));
        }
        if (att.getValue("paquete") != null) {
            this.accionActiva.setPaquete(att.getValue("paquete"));
        }
        if (att.getValue("nombre_funcion") != null) {
            this.accionActiva.setFuncion(att.getValue("nombre_funcion"));
        }
        if (att.getValue("texto_libre") != null) {
            this.accionActiva.setTextoLibre(att.getValue("texto_libre"));
        }
        this.controlDuplicidadAccion();
        return true;
    }

    public boolean crearAviso(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.AvisoActivo = new TrAviso();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.AvisoActivo.setXID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("nombre") == null) {
            return false;
        }
        this.AvisoActivo.setNOMBRE(att.getValue("nombre"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.AvisoActivo.setDESCRIPCION(att.getValue("descripcion"));
        this.controlDuplicidadAviso();
        return true;
    }

    public boolean crearMetafase(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.metafaseActiva = new TrMetafase();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.metafaseActiva.setMETAID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("nombre") == null) {
            return false;
        }
        this.metafaseActiva.setNOMBRE(att.getValue("nombre"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.metafaseActiva.setDESCRIPCION(att.getValue("descripcion"));
        if (att.getValue("orden") != null) {
            this.metafaseActiva.setORDEN(new Integer(att.getValue("orden")));
        }
        boolean bLogico = false;
        String sLogico = "N";
        if (att.getValue("informar") != null) {
            sLogico = att.getValue("informar");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.metafaseActiva.setINFORMAR(bLogico);
        this.controlDuplicidadMetafase();
        return true;
    }

    public boolean crearFase(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        if (this.tipoLectura == LECTURA_IMPORTACION_DES && att.getValue("defproc_r_id") != null) {
            return false;
        }
        this.faseActiva = new TrFase();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.faseActiva.setFASEID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("nombre") == null) {
            return false;
        }
        this.faseActiva.setNOMBRE(att.getValue("nombre"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.faseActiva.setDESCRIPCION(att.getValue("descripcion"));
        if (att.getValue("orden") != null) {
            this.faseActiva.setORDEN(new Integer(att.getValue("orden")));
        }
        if (this.tipoLectura == LECTURA_DEFINICION_PROC && att.getValue("defproc_r_id") != null) {
            BigDecimal idReutilizable = new BigDecimal(att.getValue("defproc_r_id"));
            DDPGrafico graficoPPal = (DDPGrafico)this.listaRecorridoDDP.get(0);
            for (int n = 0; n < graficoPPal.getListaDDPs().size(); ++n) {
                if (((DDPGrafico)graficoPPal.getListaDDPs().get(n)).getDDP().getTIPOEVOL().getTIEVID().longValue() != idReutilizable.longValue()) continue;
                this.faseActiva.setTIPOEVOL(((DDPGrafico)graficoPPal.getListaDDPs().get(n)).getDDP().getTIPOEVOL());
            }
        }
        boolean bLogico = false;
        String sLogico = "N";
        if (att.getValue("informar") != null) {
            sLogico = att.getValue("informar");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.faseActiva.setINFORMAR(bLogico);
        if (att.getValue("texto_aux") != null) {
            this.faseActiva.setTextoAuxiliar(att.getValue("texto_aux"));
        }
        this.faseActiva.setMETAFASE(this.metafaseActiva);
        this.controlDuplicidadFase();
        return true;
    }

    public boolean crearTransicion(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        if (this.grafico.getCanvas() == null) {
            return false;
        }
        this.transicionActiva = new TrTransicion();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.transicionActiva.setTRANID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("etiqueta") == null) {
            return false;
        }
        this.transicionActiva.setETIQUETA(att.getValue("etiqueta"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.transicionActiva.setDESCRIPCION(att.getValue("descripcion"));
        if (att.getValue("tipo") == null) {
            return false;
        }
        this.transicionActiva.setTIPO(att.getValue("tipo"));
        BigDecimal tmpID = null;
        if (att.getValue("actoadm_id") != null && this.grafico.getTiposActoInvolucradosEnCarga() != null) {
            tmpID = BigDecimal.valueOf(Long.parseLong(att.getValue("actoadm_id")));
            TrTipoActo tmpTipoActo = this.grafico.getTiposActoInvolucradosEnCarga().obtenerTipoActoDeTiposActoEnCarga(tmpID);
            if (tmpTipoActo != null) {
                this.transicionActiva.setTipoActo(tmpTipoActo);
            }
        }
        if (att.getValue("desc_fecha") != null) {
            this.transicionActiva.setDESCRIPCIONFECHA(att.getValue("desc_fecha"));
        }
        if (att.getValue("orden") != null) {
            this.transicionActiva.setORDEN(new Integer(att.getValue("orden")));
        }
        boolean bValida = true;
        String sValida = "S";
        if (att.getValue("valida") == null) {
            return false;
        }
        sValida = att.getValue("valida");
        String sSi = "S";
        String sNo = "N";
        if (sValida.equals(sSi)) {
            bValida = true;
        } else if (sValida.equals(sNo)) {
            bValida = false;
        }
        this.transicionActiva.setValida(bValida);
        this.transicionActiva.setVALIDA(sValida);
        boolean bLogico = false;
        String sLogico = "N";
        if (att.getValue("informar") != null) {
            sLogico = att.getValue("informar");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.transicionActiva.setINFORMAR(bLogico);
        if (att.getValue("etiq_larga") != null) {
            this.transicionActiva.setETIQUETA_LARGA(att.getValue("etiq_larga"));
        }
        Integer maxOcurrenciasPermitidas = null;
        if (att.getValue("max_ocurrencias") != null) {
            maxOcurrenciasPermitidas = Integer.valueOf(att.getValue("max_ocurrencias"));
        }
        this.crearTransicionProcedimiento(maxOcurrenciasPermitidas);
        return true;
    }

    public void crearTransicionProcedimiento(Integer nMaxOcurrencias) {
        this.transicionProcActiva = new TrTransicionDefProcedimiento();
        this.transicionProcActiva.setTransicion(this.transicionActiva);
        this.transicionProcActiva.setMaxOcurrencias(nMaxOcurrencias);
    }

    public boolean addPerfilTransicion(Attributes att) throws Exception {
        TrPerfilUsuario perfil;
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        if (this.transicionProcActiva == null) {
            return false;
        }
        String strId = null;
        if (att.getValue("perfil_id") == null) {
            return false;
        }
        strId = att.getValue("perfil_id");
        String strPermiso = null;
        if (att.getValue("permiso") == null) {
            return false;
        }
        strPermiso = att.getValue("permiso");
        TrPerfilTransEvol trPerfilTrans = new TrPerfilTransEvol();
        trPerfilTrans.setTIPOEVOL_ID(this.grafico.getDDP().getDDPGID());
        trPerfilTrans.setTRAN_ID(this.transicionActiva.getTRANID());
        BigDecimal idPerfil = new BigDecimal(strId);
        if (this.grafico.getPerfilesUsuarioInvolucrados() != null && (perfil = (TrPerfilUsuario)this.grafico.getPerfilesUsuarioInvolucrados().obtenerDato(idPerfil)) != null) {
            trPerfilTrans.setPERFIL(perfil);
        }
        trPerfilTrans.setPERMISO(strPermiso);
        if (!this.transicionProcActiva.existePerfilEnTransicion(trPerfilTrans)) {
            this.transicionProcActiva.addPerfilTransEvol(trPerfilTrans);
        }
        return true;
    }

    public boolean crearFaseTransicion(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (this.transicionActiva == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.faseIDActiva = new BigDecimal(strId);
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (this.bFaseIDIni) {
            TrFase faseIniTmp = null;
            faseIniTmp = (TrFase)this.grafico.getFasesInvolucradas().obtenerDato(this.faseIDActiva);
            if (faseIniTmp != null) {
                this.transicionActiva.setTrFaseIni(faseIniTmp);
            }
            return true;
        }
        if (this.bFaseIDFin) {
            TrFase faseFinTmp = null;
            faseFinTmp = (TrFase)this.grafico.getFasesInvolucradas().obtenerDato(this.faseIDActiva);
            if (faseFinTmp != null) {
                this.transicionActiva.setTrFaseFin(faseFinTmp);
            }
            if (this.transicionActiva.getTIPO().equals("D") && faseFinTmp != null) {
                this.transicionActiva.addFaseFin(faseFinTmp);
            }
            return true;
        }
        return false;
    }

    public boolean crearTareaEnFase_v0(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.tEnFaseActiva = new TrTareaEnFase();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.tEnFaseActiva.setX_ID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("etiqueta") == null) {
            return false;
        }
        this.tEnFaseActiva.setETIQUETA(att.getValue("etiqueta"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.tEnFaseActiva.setDESCRIPCION(att.getValue("descripcion"));
        boolean bObligatorio = false;
        String sObliga = null;
        if (att.getValue("obligatoria") != null) {
            sObliga = att.getValue("obligatoria");
            String sSi = "S";
            String sNo = "N";
            if (sObliga.equals(sSi)) {
                bObligatorio = true;
            } else if (sObliga.equals(sNo)) {
                bObligatorio = false;
            }
        } else {
            return false;
        }
        this.tEnFaseActiva.setOBLIGATORIA(bObligatorio);
        BigDecimal tmpID = null;
        if (att.getValue("tarea_id") == null) {
            return false;
        }
        tmpID = BigDecimal.valueOf(Long.parseLong(att.getValue("tarea_id")));
        TrTarea tareaObtenida = this.grafico.getTareasInvolucradasEnCarga().obtenerTareaDeTareaEnCarga(tmpID);
        if (tareaObtenida != null) {
            this.tEnFaseActiva.setTarea(tareaObtenida);
        }
        ConjuntoDatosModela TotalFases = this.grafico.getFasesInvolucradas();
        BigDecimal tmpIDFase = null;
        if (att.getValue("fase_id") == null) {
            return false;
        }
        tmpIDFase = BigDecimal.valueOf(Long.parseLong(att.getValue("fase_id")));
        boolean bValida = true;
        String sValida = null;
        if (att.getValue("valida") != null) {
            sValida = att.getValue("valida");
            String sSiValida = "S";
            String sNoValida = "N";
            if (sValida.equals(sSiValida)) {
                bValida = true;
            } else if (sValida.equals(sNoValida)) {
                bValida = false;
            }
        } else {
            return false;
        }
        this.tEnFaseActiva.setValida(bValida);
        if (att.getValue("orden") != null) {
            this.tEnFaseActiva.setORDEN(new Integer(att.getValue("orden")));
        }
        if (tareaObtenida != null && tareaObtenida instanceof TrBloquePermitido) {
            TrBloque bloqueInicialABuscar = ((TrBloquePermitido)tareaObtenida).getBloqueIni();
            TrTarea tareaLlamanteLocalizada = null;
            if (bloqueInicialABuscar != null) {
                BigDecimal idBloqueABuscar = bloqueInicialABuscar.getBloqueId().getPkVal();
                tareaLlamanteLocalizada = this.grafico.getTareasInvolucradasEnCarga().obtenerTareaDeTareaEnCargaConBloqueFinalID(idBloqueABuscar);
                if (tareaLlamanteLocalizada == null) {
                    tareaLlamanteLocalizada = new TrBloquePermitido();
                    ((TrBloquePermitido)tareaLlamanteLocalizada).setBloqueFin(bloqueInicialABuscar);
                    if (this.grafico.getTareasInvolucradas().obtenerTareaBloque((TrBloquePermitido)tareaLlamanteLocalizada) == null) {
                        this.grafico.getTareasInvolucradas().add(tareaLlamanteLocalizada);
                    }
                    TrTareaEnCarga tareaEnCargaToAdd = new TrTareaEnCarga();
                    tareaEnCargaToAdd.setIdEnCarga(new BigDecimal(GeneradorID.getID()));
                    tareaEnCargaToAdd.setTarea(tareaLlamanteLocalizada);
                    tareaLlamanteLocalizada.setNOMBRE(bloqueInicialABuscar.getNombre());
                    tareaLlamanteLocalizada.setDESCRIPCION(bloqueInicialABuscar.getDescripcion());
                    this.grafico.getTareasInvolucradasEnCarga().add(tareaEnCargaToAdd);
                }
                this.tEnFaseActiva.setTareaLlamante(tareaLlamanteLocalizada);
            }
        }
        boolean bTareaEnFaseEncontrada = false;
        TrFase tmpFase = (TrFase)TotalFases.obtenerDato(tmpIDFase);
        if (tmpFase != null) {
            BigDecimal tareaIDaux = null;
            if (tareaObtenida != null) {
                tareaIDaux = tareaObtenida.getID_TAREA();
            }
            if (tmpFase.getConjuntoTareasEnFase().obtenerTenFaseAsociadaATareaID(tareaIDaux) == null) {
                tmpFase.addTareaEnFase(this.tEnFaseActiva);
            } else {
                this.tEnFaseActiva = tmpFase.getConjuntoTareasEnFase().obtenerTenFaseAsociadaATareaID(tareaIDaux);
                bTareaEnFaseEncontrada = true;
            }
            this.tEnFaseActiva.setFase(tmpFase);
        }
        TrTareaEnFaseEnCarga tareaEnFaseEnCarga = new TrTareaEnFaseEnCarga();
        tareaEnFaseEnCarga.setIdEnCarga(new BigDecimal(att.getValue("id")));
        this.grafico.getTareasEnFaseInvolucradasEnCarga().add(tareaEnFaseEnCarga);
        this.crearTareaFaseProcedimiento();
        tareaEnFaseEnCarga.setTareaEnFaseDefProc(this.tareaFaseProcActiva);
        if (!bTareaEnFaseEncontrada) {
            ++this.idTareaFaseUnico;
            this.tEnFaseActiva.setX_ID(new BigDecimal(String.valueOf(this.idTareaFaseUnico)));
        }
        return true;
    }

    public boolean crearTareaEnFase_v1(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.tEnFaseActiva = new TrTareaEnFase();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.tEnFaseActiva.setX_ID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("etiqueta") == null) {
            return false;
        }
        this.tEnFaseActiva.setETIQUETA(att.getValue("etiqueta"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.tEnFaseActiva.setDESCRIPCION(att.getValue("descripcion"));
        if (att.getValue("auxiliar") != null) {
            this.tEnFaseActiva.setTextoAuxiliar(att.getValue("auxiliar"));
        }
        BigDecimal tmpIDacto = null;
        if (att.getValue("actoadm_id") != null && this.grafico.getTiposActoInvolucradosEnCarga() != null) {
            tmpIDacto = BigDecimal.valueOf(Long.parseLong(att.getValue("actoadm_id")));
            TrTipoActo tmpTipoActo = this.grafico.getTiposActoInvolucradosEnCarga().obtenerTipoActoDeTiposActoEnCarga(tmpIDacto);
            if (tmpTipoActo != null) {
                this.tEnFaseActiva.setTipoActo(tmpTipoActo);
            }
        }
        boolean bObligatorio = false;
        String sObliga = null;
        if (att.getValue("obligatoria") != null) {
            sObliga = att.getValue("obligatoria");
            String sSi = "S";
            String sNo = "N";
            if (sObliga.equals(sSi)) {
                bObligatorio = true;
            } else if (sObliga.equals(sNo)) {
                bObligatorio = false;
            }
        } else {
            return false;
        }
        this.tEnFaseActiva.setOBLIGATORIA(bObligatorio);
        BigDecimal tmpID = null;
        if (att.getValue("tarea_id") == null) {
            return false;
        }
        tmpID = BigDecimal.valueOf(Long.parseLong(att.getValue("tarea_id")));
        TrTarea tareaObtenida = this.grafico.getTareasInvolucradasEnCarga().obtenerTareaDeTareaEnCarga(tmpID);
        if (tareaObtenida != null) {
            this.tEnFaseActiva.setTarea(tareaObtenida);
        }
        ConjuntoDatosModela TotalFases = this.grafico.getFasesInvolucradas();
        BigDecimal tmpIDFase = null;
        if (att.getValue("fase_id") == null) {
            return false;
        }
        tmpIDFase = BigDecimal.valueOf(Long.parseLong(att.getValue("fase_id")));
        if (att.getValue("orden") != null) {
            this.tEnFaseActiva.setORDEN(new Integer(att.getValue("orden")));
        }
        boolean bLogico = true;
        String sLogico = null;
        if (att.getValue("valida") != null) {
            sLogico = att.getValue("valida");
            String sSiValida = "S";
            String sNoValida = "N";
            if (sLogico.equals(sSiValida)) {
                bLogico = true;
            } else if (sLogico.equals(sNoValida)) {
                bLogico = false;
            }
        } else {
            return false;
        }
        this.tEnFaseActiva.setValida(bLogico);
        sLogico = "N";
        if (att.getValue("informar") != null) {
            sLogico = att.getValue("informar");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.tEnFaseActiva.setInformar(bLogico);
        if (att.getValue("etiq_larga") != null) {
            this.tEnFaseActiva.setETIQUETALARGA(att.getValue("etiq_larga"));
        }
        BigDecimal idTemporal = null;
        if (att.getValue("tarea_llamante_id") != null) {
            idTemporal = BigDecimal.valueOf(Long.parseLong(att.getValue("tarea_llamante_id")));
            TrTarea tareaLlamanteObtenida = this.grafico.getTareasInvolucradasEnCarga().obtenerTareaDeTareaEnCarga(idTemporal);
            if (tareaLlamanteObtenida != null && (tareaLlamanteObtenida.getTrTipoTarea().equals(TrTipoTarea.MANIPULAR_DATOS) || tareaLlamanteObtenida.getTrTipoTarea().equals(TrTipoTarea.OTROS))) {
                this.tEnFaseActiva.setTareaLlamante(tareaLlamanteObtenida);
            }
        }
        boolean bTareaEnFaseEncontrada = false;
        TrFase tmpFase = (TrFase)TotalFases.obtenerDato(tmpIDFase);
        if (tmpFase != null) {
            if (tmpFase.getConjuntoTareasEnFase().existeElemento(this.tEnFaseActiva, false) == null) {
                tmpFase.addTareaEnFase(this.tEnFaseActiva);
            } else {
                this.tEnFaseActiva = (TrTareaEnFase)tmpFase.getConjuntoTareasEnFase().existeElemento(this.tEnFaseActiva, false);
                bTareaEnFaseEncontrada = true;
            }
            this.tEnFaseActiva.setFase(tmpFase);
        }
        TrTareaEnFaseEnCarga tareaEnFaseEnCarga = new TrTareaEnFaseEnCarga();
        tareaEnFaseEnCarga.setIdEnCarga(new BigDecimal(att.getValue("id")));
        this.grafico.getTareasEnFaseInvolucradasEnCarga().add(tareaEnFaseEnCarga);
        this.crearTareaFaseProcedimiento();
        tareaEnFaseEnCarga.setTareaEnFaseDefProc(this.tareaFaseProcActiva);
        if (!bTareaEnFaseEncontrada) {
            ++this.idTareaFaseUnico;
            this.tEnFaseActiva.setX_ID(new BigDecimal(String.valueOf(this.idTareaFaseUnico)));
        }
        return true;
    }

    public void crearTareaFaseProcedimiento() {
        this.tareaFaseProcActiva = new TrTareaEnFaseDefProcedimiento();
        this.tareaFaseProcActiva.setTareaEnFase(this.tEnFaseActiva);
    }

    public boolean addPerfilTenFase(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        if (this.tEnFaseActiva == null) {
            return false;
        }
        if (this.tareaFaseProcActiva == null) {
            return false;
        }
        TrPerfilTareaFase perfilTarea = new TrPerfilTareaFase();
        String strId = null;
        if (att.getValue("perfil_id") == null) {
            return false;
        }
        strId = att.getValue("perfil_id");
        BigDecimal idPerfilT = new BigDecimal(strId);
        if (this.grafico.getPerfilesUsuarioInvolucrados() != null) {
            TrPerfilUsuario perfilT = (TrPerfilUsuario)this.grafico.getPerfilesUsuarioInvolucrados().obtenerDato(idPerfilT);
            if (perfilT != null) {
                if (this.tareaFaseProcActiva.getConjuntoPerfilesTareaFase().obtenerDato(idPerfilT) == null) {
                    perfilTarea.setPERFIL(perfilT);
                }
            } else {
                return false;
            }
        }
        if (att.getValue("permiso") != null) {
            perfilTarea.setPERMISO(att.getValue("permiso"));
        }
        if (!this.tareaFaseProcActiva.existePerfilEnTareaFase(perfilTarea)) {
            this.tareaFaseProcActiva.addPerfilTareaFase(perfilTarea);
        }
        return true;
    }

    public boolean crearCondicionTransicion(Attributes att) throws Exception {
        String strId;
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        boolean bLogico = true;
        String sLogico = "S";
        String strTransicionId = null;
        TrCondicionTransicion condicionTransicionActiva = new TrCondicionTransicion();
        if (att.getValue("id") != null) {
            strId = att.getValue("id");
            condicionTransicionActiva.setXID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("obligatoria") == null) {
            return false;
        }
        sLogico = att.getValue("obligatoria");
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        condicionTransicionActiva.setObligatoria(bLogico);
        if (att.getValue("condicion_id") != null) {
            strId = att.getValue("condicion_id");
            if (!this.setCondicionToCondicionTransicion(condicionTransicionActiva, new BigDecimal(strId))) {
                return false;
            }
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("transicion_id") != null) {
            strTransicionId = att.getValue("transicion_id");
            if (this.auxID < Long.parseLong(strTransicionId)) {
                this.auxID = Long.parseLong(strTransicionId);
            }
        } else {
            return false;
        }
        if (strTransicionId == null) {
            return false;
        }
        if (strTransicionId.equals("")) {
            return false;
        }
        if (att.getValue("mensaje_ok") != null) {
            condicionTransicionActiva.setMensajeOk(att.getValue("mensaje_ok"));
        }
        if (att.getValue("mensaje_no_ok") != null) {
            condicionTransicionActiva.setMensajeNoOk(att.getValue("mensaje_no_ok"));
        }
        if (att.getValue("comprobar") == null) {
            return false;
        }
        condicionTransicionActiva.setComprobar(att.getValue("comprobar"));
        if (att.getValue("mostrar_msj") == null) {
            return false;
        }
        condicionTransicionActiva.setMostrarMsj(att.getValue("mostrar_msj"));
        if (att.getValue("valida") == null) {
            return false;
        }
        sLogico = att.getValue("valida");
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        condicionTransicionActiva.setValida(bLogico);
        if (att.getValue("texto_libre") != null) {
            condicionTransicionActiva.setTextoLibre(att.getValue("texto_libre"));
        }
        return this.addCondicionTransicionToTransicion(condicionTransicionActiva, new BigDecimal(strTransicionId));
    }

    public boolean setCondicionToCondicionTransicion(TrCondicionTransicion condicionTransicion, BigDecimal objID) {
        if (condicionTransicion == null) {
            return false;
        }
        if (this.grafico.getCondicionesInvolucradas() != null) {
            TrCondicion condicion = (TrCondicion)this.grafico.getCondicionesInvolucradas().obtenerDato(objID);
            if (condicion != null) {
                condicionTransicion.setCondicion(condicion);
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean addCondicionTransicionToTransicion(TrCondicionTransicion condicionTransicion, BigDecimal objID) {
        if (condicionTransicion == null) {
            return false;
        }
        if (this.grafico.getTransicionesDelProcInvolucradas() != null) {
            TrTransicionDefProcedimiento transicionDefProc = this.grafico.getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(objID.doubleValue());
            if (transicionDefProc != null) {
                if (!transicionDefProc.existeCondicionEnTransicion(condicionTransicion)) {
                    transicionDefProc.addCondicionTransicion(condicionTransicion);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean crearAccionTransicion(Attributes att) throws Exception {
        String strId;
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        boolean bLogico = true;
        String sLogico = "S";
        String strTransicionId = null;
        TrAccionTransicion accionTransicionActiva = new TrAccionTransicion();
        if (att.getValue("id") != null) {
            strId = att.getValue("id");
            accionTransicionActiva.setXID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("accion_id") != null) {
            strId = att.getValue("accion_id");
            if (!this.setAccionToAccionTransicion(accionTransicionActiva, new BigDecimal(strId))) {
                return false;
            }
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else if (att.getValue("condicion_id") != null) {
            strId = att.getValue("condicion_id");
            if (!this.setAccionToAccionTransicion(accionTransicionActiva, new BigDecimal(strId))) {
                return false;
            }
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("transicion_id") != null) {
            strTransicionId = att.getValue("transicion_id");
            if (this.auxID < Long.parseLong(strTransicionId)) {
                this.auxID = Long.parseLong(strTransicionId);
            }
        } else {
            return false;
        }
        if (strTransicionId == null) {
            return false;
        }
        if (strTransicionId.equals("")) {
            return false;
        }
        if (att.getValue("mensaje_ok") != null) {
            accionTransicionActiva.setMensajeOk(att.getValue("mensaje_ok"));
        }
        if (att.getValue("mensaje_no_ok") != null) {
            accionTransicionActiva.setMensajeNoOk(att.getValue("mensaje_no_ok"));
        }
        if (att.getValue("comprobar") == null) {
            return false;
        }
        accionTransicionActiva.setComprobar(att.getValue("comprobar"));
        if (att.getValue("mostrar_msj") == null) {
            return false;
        }
        accionTransicionActiva.setMostrarMsj(att.getValue("mostrar_msj"));
        if (att.getValue("valida") == null) {
            return false;
        }
        sLogico = att.getValue("valida");
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        accionTransicionActiva.setValida(bLogico);
        if (att.getValue("texto_libre") != null) {
            accionTransicionActiva.setTextoLibre(att.getValue("texto_libre"));
        }
        return this.addAccionTransicionToTransicion(accionTransicionActiva, new BigDecimal(strTransicionId));
    }

    public boolean setAccionToAccionTransicion(TrAccionTransicion accionTransicion, BigDecimal objID) {
        if (accionTransicion == null) {
            return false;
        }
        if (this.grafico.getAccionesInvolucradas() != null) {
            TrAccion accion = (TrAccion)this.grafico.getAccionesInvolucradas().obtenerDato(objID);
            if (accion != null) {
                accionTransicion.setAccion(accion);
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean addAccionTransicionToTransicion(TrAccionTransicion accionTransicion, BigDecimal objID) {
        if (accionTransicion == null) {
            return false;
        }
        if (this.grafico.getTransicionesDelProcInvolucradas() != null) {
            TrTransicionDefProcedimiento transicionDefProc = this.grafico.getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(objID.doubleValue());
            if (transicionDefProc != null) {
                if (!transicionDefProc.existeAccionEnTransicion(accionTransicion)) {
                    transicionDefProc.addAccionTransicion(accionTransicion);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean crearAvisoTransicion(Attributes att) throws Exception {
        String strId;
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        boolean bLogico = true;
        String sLogico = "S";
        String strTransicionId = null;
        TrAvisoTransicion avisoTransicionActivo = new TrAvisoTransicion();
        if (att.getValue("id") != null) {
            strId = att.getValue("id");
            avisoTransicionActivo.setXID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("aviso_id") != null) {
            strId = att.getValue("aviso_id");
            if (!this.setAvisoToAvisoTransicion(avisoTransicionActivo, new BigDecimal(strId))) {
                return false;
            }
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else if (att.getValue("condicion_id") != null) {
            strId = att.getValue("condicion_id");
            if (!this.setAvisoToAvisoTransicion(avisoTransicionActivo, new BigDecimal(strId))) {
                return false;
            }
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("transicion_id") != null) {
            strTransicionId = att.getValue("transicion_id");
            if (this.auxID < Long.parseLong(strTransicionId)) {
                this.auxID = Long.parseLong(strTransicionId);
            }
        } else {
            return false;
        }
        if (strTransicionId == null) {
            return false;
        }
        if (strTransicionId.equals("")) {
            return false;
        }
        if (att.getValue("mensaje_ok") != null) {
            avisoTransicionActivo.setMensajeOk(att.getValue("mensaje_ok"));
        }
        if (att.getValue("comprobar") == null) {
            return false;
        }
        avisoTransicionActivo.setComprobar(att.getValue("comprobar"));
        if (att.getValue("valida") == null) {
            return false;
        }
        sLogico = att.getValue("valida");
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        avisoTransicionActivo.setValida(bLogico);
        return this.addAvisoTransicionToTransicion(avisoTransicionActivo, new BigDecimal(strTransicionId));
    }

    public boolean setAvisoToAvisoTransicion(TrAvisoTransicion avisoTransicion, BigDecimal objID) {
        if (avisoTransicion == null) {
            return false;
        }
        if (this.grafico.getAvisosInvolucrados() != null) {
            TrAviso aviso = (TrAviso)this.grafico.getAvisosInvolucrados().obtenerDato(objID);
            if (aviso != null) {
                avisoTransicion.setAviso(aviso);
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean addAvisoTransicionToTransicion(TrAvisoTransicion avisoTransicion, BigDecimal objID) {
        if (avisoTransicion == null) {
            return false;
        }
        if (this.grafico.getTransicionesDelProcInvolucradas() != null) {
            TrTransicionDefProcedimiento transicionDefProc = this.grafico.getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(objID.doubleValue());
            if (transicionDefProc != null) {
                if (!transicionDefProc.existeAvisoEnTransicion(avisoTransicion)) {
                    transicionDefProc.addAvisoTransicion(avisoTransicion);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean crearCondicionTarea(Attributes att) throws Exception {
        String strId;
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        boolean bLogico = true;
        String sLogico = "S";
        String strTareaEnFaseID = null;
        TrCondicionTareaFase condicionTareaFaseActiva = new TrCondicionTareaFase();
        if (att.getValue("id") != null) {
            strId = att.getValue("id");
            condicionTareaFaseActiva.setXID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("obligatoria") == null) {
            return false;
        }
        sLogico = att.getValue("obligatoria");
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        condicionTareaFaseActiva.setObligatoria(bLogico);
        if (att.getValue("condicion_id") != null) {
            strId = att.getValue("condicion_id");
            if (!this.setCondicionToCondicionTareaFase(condicionTareaFaseActiva, new BigDecimal(strId))) {
                return false;
            }
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("tareafase_id") != null) {
            strTareaEnFaseID = att.getValue("tareafase_id");
            if (this.auxID < Long.parseLong(strTareaEnFaseID)) {
                this.auxID = Long.parseLong(strTareaEnFaseID);
            }
        } else {
            return false;
        }
        if (strTareaEnFaseID == null) {
            return false;
        }
        if (strTareaEnFaseID.equals("")) {
            return false;
        }
        if (att.getValue("mensaje_ok") != null) {
            condicionTareaFaseActiva.setMensajeOk(att.getValue("mensaje_ok"));
        }
        if (att.getValue("mensaje_no_ok") != null) {
            condicionTareaFaseActiva.setMensajeNoOk(att.getValue("mensaje_no_ok"));
        }
        if (att.getValue("comprobar") == null) {
            return false;
        }
        condicionTareaFaseActiva.setComprobar(att.getValue("comprobar"));
        if (att.getValue("mostrar_msj") == null) {
            return false;
        }
        condicionTareaFaseActiva.setMostrarMsj(att.getValue("mostrar_msj"));
        if (att.getValue("valida") == null) {
            return false;
        }
        sLogico = att.getValue("valida");
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        condicionTareaFaseActiva.setValida(bLogico);
        if (att.getValue("texto_libre") != null) {
            condicionTareaFaseActiva.setTextoLibre(att.getValue("texto_libre"));
        }
        return this.addCondicionTareaFaseToTareaEnFase(condicionTareaFaseActiva, new BigDecimal(strTareaEnFaseID));
    }

    public boolean setCondicionToCondicionTareaFase(TrCondicionTareaFase condicionTareaFase, BigDecimal objID) {
        if (condicionTareaFase == null) {
            return false;
        }
        if (this.grafico.getCondicionesInvolucradas() != null) {
            TrCondicion condicion = (TrCondicion)this.grafico.getCondicionesInvolucradas().obtenerDato(objID);
            if (condicion != null) {
                condicionTareaFase.setCondicion(condicion);
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean addCondicionTareaFaseToTareaEnFase(TrCondicionTareaFase condicionTareaFase, BigDecimal objID) {
        if (condicionTareaFase == null) {
            return false;
        }
        if (this.grafico.getTareasEnFaseInvolucradasEnCarga() != null) {
            TrTareaEnFaseDefProcedimiento tareaEnFaseDefProc = this.grafico.getTareasEnFaseInvolucradasEnCarga().obtenerTareaEnFaseDeTareaEnFaseEnCarga(objID);
            if (tareaEnFaseDefProc != null) {
                if (!tareaEnFaseDefProc.existeCondicionEnTareaFase(condicionTareaFase)) {
                    tareaEnFaseDefProc.addCondicionTareaFase(condicionTareaFase);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean crearAccionTarea(Attributes att) throws Exception {
        String strId;
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        boolean bLogico = true;
        String sLogico = "S";
        String strTareaEnFaseID = null;
        TrAccionTareaFase accionTareaFaseActiva = new TrAccionTareaFase();
        if (att.getValue("id") != null) {
            strId = att.getValue("id");
            accionTareaFaseActiva.setXID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("accion_id") != null) {
            strId = att.getValue("accion_id");
            if (!this.setAccionToAccionTareaFase(accionTareaFaseActiva, new BigDecimal(strId))) {
                return false;
            }
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else if (att.getValue("condicion_id") != null) {
            strId = att.getValue("condicion_id");
            if (!this.setAccionToAccionTareaFase(accionTareaFaseActiva, new BigDecimal(strId))) {
                return false;
            }
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("tareafase_id") != null) {
            strTareaEnFaseID = att.getValue("tareafase_id");
            if (this.auxID < Long.parseLong(strTareaEnFaseID)) {
                this.auxID = Long.parseLong(strTareaEnFaseID);
            }
        } else {
            return false;
        }
        if (strTareaEnFaseID == null) {
            return false;
        }
        if (strTareaEnFaseID.equals("")) {
            return false;
        }
        if (att.getValue("mensaje_ok") != null) {
            accionTareaFaseActiva.setMensajeOk(att.getValue("mensaje_ok"));
        }
        if (att.getValue("mensaje_no_ok") != null) {
            accionTareaFaseActiva.setMensajeNoOk(att.getValue("mensaje_no_ok"));
        }
        if (att.getValue("comprobar") == null) {
            return false;
        }
        accionTareaFaseActiva.setComprobar(att.getValue("comprobar"));
        if (att.getValue("mostrar_msj") == null) {
            return false;
        }
        accionTareaFaseActiva.setMostrarMsj(att.getValue("mostrar_msj"));
        if (att.getValue("valida") == null) {
            return false;
        }
        sLogico = att.getValue("valida");
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        accionTareaFaseActiva.setValida(bLogico);
        if (att.getValue("texto_libre") != null) {
            accionTareaFaseActiva.setTextoLibre(att.getValue("texto_libre"));
        }
        return this.addAccionTareaFaseToTareaEnFase(accionTareaFaseActiva, new BigDecimal(strTareaEnFaseID));
    }

    public boolean setAccionToAccionTareaFase(TrAccionTareaFase accionTareaFase, BigDecimal objID) {
        if (accionTareaFase == null) {
            return false;
        }
        if (this.grafico.getAccionesInvolucradas() != null) {
            TrAccion accion = (TrAccion)this.grafico.getAccionesInvolucradas().obtenerDato(objID);
            if (accion != null) {
                accionTareaFase.setAccion(accion);
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean addAccionTareaFaseToTareaEnFase(TrAccionTareaFase accionTareaFase, BigDecimal objID) {
        if (accionTareaFase == null) {
            return false;
        }
        if (this.grafico.getTareasEnFaseInvolucradasEnCarga() != null) {
            TrTareaEnFaseDefProcedimiento tareaEnFaseDefProc = this.grafico.getTareasEnFaseInvolucradasEnCarga().obtenerTareaEnFaseDeTareaEnFaseEnCarga(objID);
            if (tareaEnFaseDefProc != null) {
                if (!tareaEnFaseDefProc.existeAccionEnTareaFase(accionTareaFase)) {
                    tareaEnFaseDefProc.addAccionTareaFase(accionTareaFase);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean crearAvisoTarea(Attributes att) throws Exception {
        String strId;
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        String strTareaEnFaseID = null;
        boolean bLogico = true;
        String sLogico = "S";
        TrAvisoTareaFase avisoTareaFaseActiva = new TrAvisoTareaFase();
        if (att.getValue("id") != null) {
            strId = att.getValue("id");
            avisoTareaFaseActiva.setXID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("aviso_id") != null) {
            strId = att.getValue("aviso_id");
            if (!this.setAvisoToAvisoTareaFase(avisoTareaFaseActiva, new BigDecimal(strId))) {
                return false;
            }
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else if (att.getValue("condicion_id") != null) {
            strId = att.getValue("condicion_id");
            if (!this.setAvisoToAvisoTareaFase(avisoTareaFaseActiva, new BigDecimal(strId))) {
                return false;
            }
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("tareafase_id") != null) {
            strTareaEnFaseID = att.getValue("tareafase_id");
            if (this.auxID < Long.parseLong(strTareaEnFaseID)) {
                this.auxID = Long.parseLong(strTareaEnFaseID);
            }
        } else {
            return false;
        }
        if (strTareaEnFaseID == null) {
            return false;
        }
        if (strTareaEnFaseID.equals("")) {
            return false;
        }
        if (att.getValue("mensaje_ok") != null) {
            avisoTareaFaseActiva.setMensajeOk(att.getValue("mensaje_ok"));
        }
        if (att.getValue("comprobar") == null) {
            return false;
        }
        avisoTareaFaseActiva.setComprobar(att.getValue("comprobar"));
        if (att.getValue("valida") == null) {
            return false;
        }
        sLogico = att.getValue("valida");
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        avisoTareaFaseActiva.setValida(bLogico);
        return this.addAvisoTareaFaseToTareaEnFase(avisoTareaFaseActiva, new BigDecimal(strTareaEnFaseID));
    }

    public boolean setAvisoToAvisoTareaFase(TrAvisoTareaFase avisoTareaFase, BigDecimal objID) {
        if (avisoTareaFase == null) {
            return false;
        }
        if (this.grafico.getAvisosInvolucrados() != null) {
            TrAviso aviso = (TrAviso)this.grafico.getAvisosInvolucrados().obtenerDato(objID);
            if (aviso != null) {
                avisoTareaFase.setAviso(aviso);
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean addAvisoTareaFaseToTareaEnFase(TrAvisoTareaFase avisoTareaFase, BigDecimal objID) {
        if (avisoTareaFase == null) {
            return false;
        }
        if (this.grafico.getTareasEnFaseInvolucradasEnCarga() != null) {
            TrTareaEnFaseDefProcedimiento tareaEnFaseDefProc = this.grafico.getTareasEnFaseInvolucradasEnCarga().obtenerTareaEnFaseDeTareaEnFaseEnCarga(objID);
            if (tareaEnFaseDefProc != null) {
                if (!tareaEnFaseDefProc.existeAvisoEnTareaFase(avisoTareaFase)) {
                    tareaEnFaseDefProc.addAvisoTareaFase(avisoTareaFase);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean crearPlazoSimple(Attributes att) throws Exception {
        TrTareaEnFaseDefProcedimiento tareaEnFaseDefProc;
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        TrPlazoSimple plazoSimpleActivo = new TrPlazoSimple();
        if (att.getValue("id") == null) {
            return false;
        }
        String strId = att.getValue("id");
        plazoSimpleActivo.setXID(new BigDecimal(strId));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        plazoSimpleActivo.setDESCRIPCION(att.getValue("descripcion"));
        String strIDFase = null;
        if (att.getValue("fase_id") == null) {
            return false;
        }
        strIDFase = att.getValue("fase_id");
        if (strIDFase != null && this.grafico.getFasesInvolucradas() != null) {
            TrFase faseAux = null;
            faseAux = (TrFase)this.grafico.getFasesInvolucradas().obtenerDato(new BigDecimal(strIDFase));
            if (faseAux != null) {
                plazoSimpleActivo.setFaseAsociada(faseAux);
            }
        }
        if (att.getValue("unidad") == null) {
            return false;
        }
        plazoSimpleActivo.setUnidad(att.getValue("unidad"));
        if (att.getValue("numero_uds") == null) {
            return false;
        }
        plazoSimpleActivo.setNumUnidades(Integer.parseInt(att.getValue("numero_uds")));
        String strIDTransFase = null;
        if (att.getValue("transfase_id") != null) {
            strIDTransFase = att.getValue("transfase_id");
        }
        if (strIDTransFase != null && this.grafico.getTransicionesDelProcInvolucradas() != null) {
            TrTransicionDefProcedimiento transicionProce = null;
            transicionProce = this.grafico.getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(Double.parseDouble(strIDTransFase));
            if (transicionProce != null && transicionProce.getTransicion() != null) {
                if (transicionProce.getTransicion().getTIPO().equals("D")) {
                    transicionProce.addPlazoSimple(plazoSimpleActivo);
                } else {
                    transicionProce.setPlazoSimple(plazoSimpleActivo);
                }
            }
        }
        String strIDTareaFase = null;
        if (att.getValue("tareafase_id") != null) {
            strIDTareaFase = att.getValue("tareafase_id");
        }
        if (strIDTareaFase != null && this.grafico.getTareasEnFaseInvolucradasEnCarga() != null && (tareaEnFaseDefProc = this.grafico.getTareasEnFaseInvolucradasEnCarga().obtenerTareaEnFaseDeTareaEnFaseEnCarga(new BigDecimal(strIDTareaFase))) != null) {
            tareaEnFaseDefProc.setPlazoSimple(plazoSimpleActivo);
        }
        String strIDTransicion = null;
        if (att.getValue("transicion_id") != null) {
            strIDTransicion = att.getValue("transicion_id");
        }
        if (strIDTransicion != null && this.grafico.getTransicionesInvolucradas() != null) {
            TrTransicion transicionProvoca = null;
            transicionProvoca = (TrTransicion)this.grafico.getTransicionesInvolucradas().obtenerDato(new BigDecimal(strIDTransicion));
            if (transicionProvoca != null) {
                plazoSimpleActivo.setTransicionQueProvoca(transicionProvoca);
            }
        }
        return true;
    }

    public boolean crearPlazoCompuesto(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.plazoCompuestoActivo = new TrPlazoCompuestoDefProc();
        if (att.getValue("id") == null) {
            return false;
        }
        String strId = att.getValue("id");
        this.plazoCompuestoActivo.setXID(new BigDecimal(strId));
        if (att.getValue("abreviatura") == null) {
            return false;
        }
        this.plazoCompuestoActivo.setABREVIATURA(att.getValue("abreviatura"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.plazoCompuestoActivo.setDESCRIPCION(att.getValue("descripcion"));
        if (att.getValue("unidad") == null) {
            return false;
        }
        this.plazoCompuestoActivo.setUNIDAD(att.getValue("unidad"));
        if (att.getValue("numero_uds") == null) {
            return false;
        }
        this.plazoCompuestoActivo.setUNIDADES(new Integer(att.getValue("numero_uds")));
        boolean bLogico = false;
        String sLogico = "N";
        if (att.getValue("vigente") != null) {
            sLogico = att.getValue("vigente");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.plazoCompuestoActivo.setVigente(bLogico);
        if (att.getValue("tipo") == null) {
            return false;
        }
        this.plazoCompuestoActivo.setTIPO(att.getValue("tipo"));
        return true;
    }

    public boolean addTransicionPlazoCompuesto(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        if (this.plazoCompuestoActivo == null) {
            return false;
        }
        if (this.grafico.getTransicionesInvolucradas() == null) {
            return false;
        }
        BigDecimal transicionID = null;
        TrTransicion transicionTmp = null;
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            transicionID = new BigDecimal(strId);
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        transicionTmp = (TrTransicion)this.grafico.getTransicionesInvolucradas().obtenerDato(transicionID);
        if (transicionTmp == null) {
            return false;
        }
        if (this.bTransicionIDIni) {
            this.plazoCompuestoActivo.getTransicionesIni().add(transicionTmp);
            return true;
        }
        if (this.bTransicionIDFin) {
            this.plazoCompuestoActivo.getTransicionesFin().add(transicionTmp);
            return true;
        }
        return true;
    }

    public boolean crearTipoOrganismo(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.tipoOrganismoActivo = new TrTipoOrganismo();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.tipoOrganismoActivo.setTIORID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("abreviatura") == null) {
            return false;
        }
        this.tipoOrganismoActivo.setAbreviatura(att.getValue("abreviatura"));
        if (att.getValue("descripcion") != null) {
            this.tipoOrganismoActivo.setDescripcion(att.getValue("descripcion"));
        }
        this.controlDuplicidadTipoOrganismo();
        return true;
    }

    public boolean crearOrganismo(Attributes att) throws Exception {
        String tipoAux;
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.organismoActivo = new TrOrganismo();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.organismoActivo.setUORGID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("codigo") == null) {
            return false;
        }
        this.organismoActivo.setCodigo(att.getValue("codigo"));
        if (att.getValue("nombre") != null) {
            this.organismoActivo.setNombre(att.getValue("nombre"));
        }
        if (att.getValue("nombre_largo") != null) {
            this.organismoActivo.setNombreLargo(att.getValue("nombre_largo"));
        }
        if (att.getValue("tipo") != null && ((tipoAux = att.getValue("tipo")).equals("SC") || tipoAux.equals("DP") || tipoAux.equals("EE") || tipoAux.equals("CE"))) {
            this.organismoActivo.setTipo(att.getValue("tipo"));
        }
        if (att.getValue("tipoorg_id") != null) {
            BigDecimal idTipoOrganismo = new BigDecimal(att.getValue("tipoorg_id"));
            TrTipoOrganismo tipoOrganismo = null;
            if (this.grafico.getTiposOrganismoInvolucradosEnCarga() != null && (tipoOrganismo = this.grafico.getTiposOrganismoInvolucradosEnCarga().obtenerTipoOrganismoDeTiposOrganismoEnCarga(idTipoOrganismo)) != null) {
                this.organismoActivo.setTrTipoOrganismo(tipoOrganismo);
            }
        }
        if (att.getValue("orgpadre_id") != null) {
            BigDecimal idOrgPadre = new BigDecimal(att.getValue("orgpadre_id"));
            this.organismoActivo.setIDPadre(idOrgPadre);
        }
        this.controlDuplicidadOrganismo();
        if (this.grafico.getDDP() != null && this.grafico.getDDP().getTIPOEVOL() != null) {
            if (this.grafico.getDDP().getTIPOEVOL().getIdOrganoCarga() != null && this.grafico.getDDP().getTIPOEVOL().getIdOrganoCarga().longValue() == this.organismoActivo.getUORGID().longValue()) {
                this.grafico.getDDP().getTIPOEVOL().setUORG_X_UROG(this.organismoActivo);
            }
            if (this.grafico.getDDP().getTIPOEVOL().getIdOrganoCompetenteCarga() != null && this.grafico.getDDP().getTIPOEVOL().getIdOrganoCompetenteCarga().longValue() == this.organismoActivo.getUORGID().longValue()) {
                this.grafico.getDDP().getTIPOEVOL().setUORG_X_UROG_COMP(this.organismoActivo);
            }
            if (this.grafico.getDDP().getTIPOEVOL().getIdOrganoResuelveCarga() != null && this.grafico.getDDP().getTIPOEVOL().getIdOrganoResuelveCarga().longValue() == this.organismoActivo.getUORGID().longValue()) {
                this.grafico.getDDP().getTIPOEVOL().setUORG_X_UROG_RES(this.organismoActivo);
            }
            if (this.grafico.getDDP().getTIPOEVOL().getIdOrganoTramitaCarga() != null && this.grafico.getDDP().getTIPOEVOL().getIdOrganoTramitaCarga().longValue() == this.organismoActivo.getUORGID().longValue()) {
                this.grafico.getDDP().getTIPOEVOL().setUORG_X_UROG_TRAM(this.organismoActivo);
            }
        }
        return true;
    }

    public boolean asociarOrganismosPadre() {
        if (this.grafico == null) {
            return false;
        }
        if (this.grafico.getOrganismosInvolucradosEnCarga() == null) {
            return false;
        }
        if (this.grafico.getOrganismosInvolucradosEnCarga().getListaDatos() == null) {
            return false;
        }
        TrOrganismo organismoAux = null;
        BigDecimal idOrgPadre = null;
        for (int n = 0; n < this.grafico.getOrganismosInvolucradosEnCarga().getListaDatos().size(); ++n) {
            organismoAux = ((TrOrganismoEnCarga)this.grafico.getOrganismosInvolucradosEnCarga().getListaDatos().get(n)).getOrganismo();
            idOrgPadre = organismoAux.getIDPadre();
            if (idOrgPadre == null) continue;
            TrOrganismo organismoPadre = null;
            if (this.grafico.getOrganismosInvolucradosEnCarga() == null || (organismoPadre = this.grafico.getOrganismosInvolucradosEnCarga().obtenerOrganismoDeOrganismosEnCarga(idOrgPadre)) == null) continue;
            organismoAux.setTrOrganismoPadre(organismoPadre);
        }
        return true;
    }

    public boolean crearTipoIndicacion(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.tipoIndicacionActivo = new TrTipoIndicacionFicha();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.tipoIndicacionActivo.setTIINID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("abreviatura") == null) {
            return false;
        }
        this.tipoIndicacionActivo.setAbreviatura(att.getValue("abreviatura"));
        if (att.getValue("descripcion") != null) {
            this.tipoIndicacionActivo.setDescripcion(att.getValue("descripcion"));
        }
        this.controlDuplicidadTipoIndicacion();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean crearFichaProcedimiento(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        TrIndicacionFicha indicacionFichaActiva = new TrIndicacionFicha();
        if (att.getValue("id") == null) return false;
        String strId = att.getValue("id");
        indicacionFichaActiva.setINFIID(new BigDecimal(strId));
        if (this.auxID < Long.parseLong(strId)) {
            this.auxID = Long.parseLong(strId);
        }
        if (att.getValue("tipo_indicacion_id") == null) return false;
        BigDecimal idTipo = new BigDecimal(att.getValue("tipo_indicacion_id"));
        TrTipoIndicacionFicha tipoIndicacion = null;
        if (this.grafico.getTiposIndicacionInvolucradosEnCarga() == null) return false;
        tipoIndicacion = this.grafico.getTiposIndicacionInvolucradosEnCarga().obtenerTipoIndicacionFichaDeTiposIndicacionFichaEnCarga(idTipo);
        if (tipoIndicacion == null) {
            return false;
        }
        indicacionFichaActiva.setTipoIndicacionFicha(tipoIndicacion);
        if (att.getValue("descripcion") != null) {
            indicacionFichaActiva.setDESCRIPCION(att.getValue("descripcion"));
        }
        if (this.grafico.getDDP() == null || this.grafico.getDDP().getTIPOEVOL() == null) return true;
        if (this.grafico.getDDP().getTIPOEVOL().getFichaProcedimientoInvolucradas().obtenerDato(indicacionFichaActiva.getINFIID()) == null) {
            this.grafico.getDDP().getTIPOEVOL().getFichaProcedimientoInvolucradas().add(indicacionFichaActiva);
            return true;
        } else {
            indicacionFichaActiva = (TrIndicacionFicha)this.grafico.getDDP().getTIPOEVOL().getFichaProcedimientoInvolucradas().obtenerDato(indicacionFichaActiva.getINFIID());
        }
        return true;
    }

    public boolean crearTipoNormativa(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.tipoNormativaActivo = new TrTipoNormativa();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.tipoNormativaActivo.setX_ID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("abreviatura") == null) {
            return false;
        }
        this.tipoNormativaActivo.setABREVIATURA(att.getValue("abreviatura"));
        if (att.getValue("descripcion") != null) {
            this.tipoNormativaActivo.setDESCRIPCION(att.getValue("descripcion"));
        }
        this.controlDuplicidadTipoNormativa();
        return true;
    }

    public boolean crearTipoPublicacion(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.tipoPublicacionActivo = new TrTipoPublicacion();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.tipoPublicacionActivo.setX_ID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("abreviatura") == null) {
            return false;
        }
        this.tipoPublicacionActivo.setABREVIATURA(att.getValue("abreviatura"));
        if (att.getValue("descripcion") != null) {
            this.tipoPublicacionActivo.setDESCRIPCION(att.getValue("descripcion"));
        }
        this.controlDuplicidadTipoPublicacion();
        return true;
    }

    public boolean crearAmbitoLey(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.ambitoLeyActivo = new TrAmbitoLey();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.ambitoLeyActivo.setX_ID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("abreviatura") == null) {
            return false;
        }
        this.ambitoLeyActivo.setABREVIATURA(att.getValue("abreviatura"));
        if (att.getValue("descripcion") != null) {
            this.ambitoLeyActivo.setDESCRIPCION(att.getValue("descripcion"));
        }
        this.controlDuplicidadAmbitoLey();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean crearNormativa(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.normativaActiva = new TrNormativa();
        if (att.getValue("id") == null) return false;
        String strId = att.getValue("id");
        this.normativaActiva.setX_ID(new BigDecimal(strId));
        if (this.auxID < Long.parseLong(strId)) {
            this.auxID = Long.parseLong(strId);
        }
        if (att.getValue("tipo_normativa_id") == null) return false;
        BigDecimal idTipo = new BigDecimal(att.getValue("tipo_normativa_id"));
        TrTipoNormativa tipoNormativa = null;
        if (this.grafico.getTiposNormativaInvolucradosEnCarga() == null) return false;
        tipoNormativa = this.grafico.getTiposNormativaInvolucradosEnCarga().obtenerTipoNormativaDeTiposNormativaEnCarga(idTipo);
        if (tipoNormativa == null) {
            return false;
        }
        this.normativaActiva.setTrTipoNormativa0(tipoNormativa);
        if (att.getValue("ambito_ley_id") == null) return false;
        idTipo = new BigDecimal(att.getValue("ambito_ley_id"));
        TrAmbitoLey ambitoLey = null;
        if (this.grafico.getAmbitosLeyInvolucradosEnCarga() == null) return false;
        ambitoLey = this.grafico.getAmbitosLeyInvolucradosEnCarga().obtenerAmbitoLeyDeAmbitosLeyEnCarga(idTipo);
        if (ambitoLey == null) {
            return false;
        }
        this.normativaActiva.setAmbitoLey0(ambitoLey);
        if (att.getValue("descripcion") != null) {
            this.normativaActiva.setDescripcion(att.getValue("descripcion"));
        }
        if (att.getValue("fecha_vigor") != null) {
            this.normativaActiva.setFECHA_VIGOR(att.getValue("fecha_vigor"));
        }
        if (att.getValue("titulo") == null) {
            return false;
        }
        this.normativaActiva.setTitulo(att.getValue("titulo"));
        if (att.getValue("numero") == null) {
            return false;
        }
        this.normativaActiva.setNumero(Integer.valueOf(att.getValue("numero")));
        if (att.getValue("anio") == null) {
            return false;
        }
        this.normativaActiva.setAnio(Integer.valueOf(att.getValue("anio")));
        if (att.getValue("tipo_publicacion_id") != null) {
            idTipo = new BigDecimal(att.getValue("tipo_publicacion_id"));
            TrTipoPublicacion tipoPublicacion = null;
            if (this.grafico.getTiposPublicacionInvolucradosEnCarga() != null && (tipoPublicacion = this.grafico.getTiposPublicacionInvolucradosEnCarga().obtenerTipoPublicacionDeTiposPublicacionEnCarga(idTipo)) != null) {
                this.normativaActiva.setTrTipoPublicacion0(tipoPublicacion);
            }
        }
        if (att.getValue("fecha_publicacion") != null) {
            this.normativaActiva.setFECHA_PUBLICACION(att.getValue("fecha_publicacion"));
        }
        if (att.getValue("num_publicacion") != null) {
            this.normativaActiva.setNumero_Publicacion(Integer.valueOf(att.getValue("num_publicacion")));
        }
        this.controlDuplicidadNormativa();
        return true;
    }

    public boolean crearNormativaDelProcedimiento(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        BigDecimal idBuscado = null;
        if (att.getValue("id") == null) {
            return false;
        }
        String strId = att.getValue("id");
        idBuscado = new BigDecimal(strId);
        TrNormativa normativaAdd = null;
        if (this.grafico.getNormativasInvolucradasEnCarga() != null) {
            normativaAdd = this.grafico.getNormativasInvolucradasEnCarga().obtenerNormativaDeNormativasEnCarga(idBuscado);
        }
        if (normativaAdd == null) {
            return false;
        }
        if (this.grafico.getDDP() != null && this.grafico.getDDP().getTIPOEVOL() != null && this.grafico.getDDP().getTIPOEVOL().getNormativasProcedimiento().obtenerDato(normativaAdd.getX_ID()) == null) {
            this.grafico.getDDP().getTIPOEVOL().getNormativasProcedimiento().add(normativaAdd);
        }
        return true;
    }

    public boolean crearOrganismoDelProcedimiento(Attributes att) throws Exception {
        if (this.grafico == null || att.getLength() < 1) {
            return false;
        }
        TrOrganismoProc organismoProc = new TrOrganismoProc();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            organismoProc.setXOrganismoProc(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        BigDecimal idBuscado = null;
        if (att.getValue("organismo_id") == null) {
            return false;
        }
        String strId = att.getValue("organismo_id");
        idBuscado = new BigDecimal(strId);
        TrOrganismo organismoAsociado = null;
        if (this.grafico.getOrganismosInvolucradosEnCarga() != null) {
            organismoAsociado = this.grafico.getOrganismosInvolucradosEnCarga().obtenerOrganismoDeOrganismosEnCarga(idBuscado);
        }
        if (organismoAsociado == null) {
            return false;
        }
        organismoProc.setOrganismoAsociado(organismoAsociado);
        if (att.getValue("tipo_asociacion") == null) {
            return false;
        }
        organismoProc.setTipoAsociacion(att.getValue("tipo_asociacion"));
        SimpleDateFormat formatoDeFecha = new SimpleDateFormat("dd/MM/yyyy");
        if (att.getValue("fecha_ini_vigencia") == null) {
            return false;
        }
        Date fechaIniAux = formatoDeFecha.parse(att.getValue("fecha_ini_vigencia"));
        organismoProc.setFechaInicioVigencia(fechaIniAux);
        if (att.getValue("fecha_fin_vigencia") != null) {
            Date fechaFinAux = formatoDeFecha.parse(att.getValue("fecha_fin_vigencia"));
            organismoProc.setFechaFinVigencia(fechaFinAux);
        }
        if (att.getValue("observaciones") != null) {
            organismoProc.setObservaciones(att.getValue("observaciones"));
        }
        if (this.grafico.getDDP() != null && this.grafico.getDDP().getTIPOEVOL() != null && this.grafico.getDDP().getTIPOEVOL().getOrganismosProcedimientoInvolucrados().obtenerDato(organismoProc.getXOrganismoProc()) == null) {
            this.grafico.getDDP().getTIPOEVOL().getOrganismosProcedimientoInvolucrados().add(organismoProc);
        }
        return true;
    }

    public boolean crearPlantillaProcedimiento(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        TrPlantillaProcedimiento plantillaProc = new TrPlantillaProcedimiento();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            plantillaProc.setXID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("nombre") == null) {
            return false;
        }
        plantillaProc.setNOMBRE(att.getValue("nombre"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        plantillaProc.setDESCRIPCION(att.getValue("descripcion"));
        if (att.getValue("nombre_fichero") != null) {
            plantillaProc.setNOMB_FICHERO(att.getValue("nombre_fichero"));
            plantillaProc.setRutaCompleta(ModelaConf.getRutaArchivo() + System.getProperty("file.separator") + plantillaProc.getNOMB_FICHERO());
            if (att.getValue("ruta_completa") != null) {
                plantillaProc.setRutaCompleta(att.getValue("ruta_completa"));
            }
        }
        if (att.getValue("formato") != null) {
            plantillaProc.setFORMATO(att.getValue("formato"));
        }
        if (this.grafico.getDDP() != null && this.grafico.getDDP().getTIPOEVOL() != null) {
            if (this.grafico.getDDP().getTIPOEVOL().getPlantillasProcInvolucradas().obtenerDato(plantillaProc.getXID()) == null) {
                this.grafico.getDDP().getTIPOEVOL().getPlantillasProcInvolucradas().add(plantillaProc);
            } else {
                plantillaProc = (TrPlantillaProcedimiento)this.grafico.getDDP().getTIPOEVOL().getPlantillasProcInvolucradas().obtenerDato(plantillaProc.getXID());
            }
        }
        return true;
    }

    public boolean crearDefProcGr(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        DefProcGr defProc = this.grafico.getDDP();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            defProc.setDDPGID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("titulo") != null) {
            defProc.setTITULO(att.getValue("titulo"));
        } else if (defProc.getTIPOEVOL().getDESCRIPCION() != null) {
            defProc.setTITULO(defProc.getTIPOEVOL().getDESCRIPCION());
        } else {
            return false;
        }
        this.grafico.setDDP(defProc);
        return true;
    }

    public boolean crearGraficoMetafase(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        TrMetafaseGr metafaseGrAux = new TrMetafaseGr();
        String strId = null;
        if (att.getValue("id") != null) {
            strId = att.getValue("id");
            metafaseGrAux.setMETAGID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        Color colorDeFondo = null;
        if (att.getValue("color_fondo") != null) {
            colorDeFondo = new Color(Integer.parseInt(att.getValue("color_fondo")));
            metafaseGrAux.setColorFondo(colorDeFondo);
        }
        Color colorDeTexto = null;
        if (att.getValue("color_texto") != null) {
            colorDeTexto = new Color(Integer.parseInt(att.getValue("color_texto")));
            metafaseGrAux.setColorTexto(colorDeTexto);
        }
        String strIdAux = new String();
        strIdAux = att.getValue("metafase_id");
        BigDecimal buscarMetaID = new BigDecimal(strIdAux);
        if ((TrMetafase)this.grafico.getMetafasesInvolucradas().obtenerDato(buscarMetaID) == null) {
            return false;
        }
        ((TrMetafase)this.grafico.getMetafasesInvolucradas().obtenerDato(buscarMetaID)).setPropiedadesGraficas(metafaseGrAux);
        return true;
    }

    public boolean crearGraficoExtremo(Attributes att) throws Exception {
        PNodoGrafico extremo;
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        if (this.grafico.getCanvas() == null) {
            return false;
        }
        TrFaseGr faseGr = new TrFaseGr();
        String strId = null;
        if (att.getValue("id") != null) {
            strId = att.getValue("id");
            faseGr.setID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        String strTipo = null;
        if (att.getValue("tipo") == null) {
            return false;
        }
        strTipo = att.getValue("tipo");
        if (att.getValue("xizq") == null) {
            return false;
        }
        faseGr.setX(Long.parseLong(att.getValue("xizq")));
        if (att.getValue("yarr") == null) {
            return false;
        }
        faseGr.setY(Long.parseLong(att.getValue("yarr")));
        if (att.getValue("ancho") == null) {
            return false;
        }
        faseGr.setAncho(Long.parseLong(att.getValue("ancho")));
        if (att.getValue("alto") == null) {
            return false;
        }
        faseGr.setAlto(Long.parseLong(att.getValue("alto")));
        Color colorDeFondo = null;
        if (att.getValue("color_fondo") != null) {
            colorDeFondo = new Color(Integer.parseInt(att.getValue("color_fondo")));
            faseGr.setColorFondo(colorDeFondo);
        }
        Color colorDeTexto = null;
        if (att.getValue("color_texto") != null) {
            colorDeTexto = new Color(Integer.parseInt(att.getValue("color_texto")));
            faseGr.setColorTexto(colorDeTexto);
        }
        faseGr.setDefProcGr(this.defProcActivo);
        strId = att.getValue("fase_id");
        BigDecimal faseID = new BigDecimal(strId);
        faseGr.setTrFase((TrFase)this.grafico.getFasesInvolucradas().obtenerDato(faseID));
        if (faseGr.getTrFase() != null && (extremo = CreadorExtremoTransicion.crearExtremo(faseGr, strTipo, this.getGrafico().getCanvas())) != null) {
            this.grafico.getCanvas().getLayer().addChild((PNode)extremo);
        }
        return true;
    }

    public boolean crearGraficoTransicion(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        if (this.grafico.getCanvas() == null) {
            return false;
        }
        this.transicionGrActivo = new TrTransicionGr();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.transicionGrActivo.setID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("transicion_id") != null) {
            String strTranID = att.getValue("transicion_id");
            BigDecimal transicionID = new BigDecimal(strTranID);
            this.transicionGrActivo.setTransicion((TrTransicion)this.grafico.getTransicionesInvolucradas().obtenerDato(transicionID));
        }
        if (att.getValue("extremotran_ini") == null) {
            return false;
        }
        String strExtremoIniGrId = att.getValue("extremotran_ini");
        BigDecimal extremoIniID = new BigDecimal(strExtremoIniGrId);
        this.pNodoActivoIni = this.grafico.getCanvas().localizarGraficoFase(extremoIniID);
        if (this.pNodoActivoIni != null) {
            this.transicionGrActivo.setGraficoExtremoInicial(this.pNodoActivoIni.getTrFaseGrAsociada());
        }
        if (att.getValue("extremotran_fin") == null) {
            return false;
        }
        String strExtremoFinGrId = att.getValue("extremotran_fin");
        BigDecimal extremoFinID = new BigDecimal(strExtremoFinGrId);
        this.pNodoActivoFin = this.grafico.getCanvas().localizarGraficoFase(extremoFinID);
        Color colorDeLinea = null;
        if (att.getValue("color_linea") != null) {
            colorDeLinea = new Color(Integer.parseInt(att.getValue("color_linea")));
            this.transicionGrActivo.setcolorLinea(colorDeLinea);
        }
        Color colorDeTexto = null;
        if (att.getValue("color_texto") != null) {
            colorDeTexto = new Color(Integer.parseInt(att.getValue("color_texto")));
            this.transicionGrActivo.setColorTexto(colorDeTexto);
        }
        if (this.pNodoActivoFin != null) {
            this.transicionGrActivo.setGraficoExtremoFinal(this.pNodoActivoFin.getTrFaseGrAsociada());
        }
        this.transicionGrActivo.setDefProcGr(this.defProcActivo);
        return true;
    }

    public boolean crearNodoTransicion(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        if (this.grafico.getCanvas() == null) {
            return false;
        }
        if (this.transicionGrActivo == null) {
            return false;
        }
        TrNodoGr nodo = new TrNodoGr();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            nodo.setNOTGID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("x") == null) {
            return false;
        }
        nodo.setX(Long.parseLong(att.getValue("x")));
        if (att.getValue("y") == null) {
            return false;
        }
        nodo.setY(Long.parseLong(att.getValue("y")));
        if (att.getValue("orden") == null) {
            return false;
        }
        nodo.setOrden(Integer.parseInt(att.getValue("orden")));
        this.transicionGrActivo.addVertice(nodo);
        return true;
    }

    public boolean crearPostIt(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        if (this.grafico.getCanvas() == null) {
            return false;
        }
        this.postItActivo = new PostItPNode(this.grafico.getCanvas());
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.postItActivo.getTrFaseGrAsociada().setID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("nodo_asociado_id") != null) {
            String strNodoId = att.getValue("nodo_asociado_id");
            BigDecimal nodoID = new BigDecimal(strNodoId);
            PNodoGrafico nodoAsociado = this.grafico.getCanvas().localizarGraficoFase(nodoID);
            if (nodoAsociado != null) {
                nodoAsociado.addPostIt(this.postItActivo);
            }
            this.postItActivo.setPNodoGraficoAsociado(nodoAsociado);
        }
        if (att.getValue("texto") != null) {
            this.postItActivo.setTexto(att.getValue("texto"));
        }
        if (att.getValue("xizq") == null) {
            return false;
        }
        this.postItActivo.setX(Long.parseLong(att.getValue("xizq")));
        if (att.getValue("yarr") == null) {
            return false;
        }
        this.postItActivo.setY(Long.parseLong(att.getValue("yarr")));
        if (att.getValue("ancho") == null) {
            return false;
        }
        this.postItActivo.setWidth(Long.parseLong(att.getValue("ancho")));
        if (att.getValue("alto") == null) {
            return false;
        }
        this.postItActivo.setHeight(Long.parseLong(att.getValue("alto")));
        return true;
    }

    private void controlDuplicidadPerfil() {
        if (this.tipoLectura == LECTURA_IMPORTACION_DES) {
            this.perfilActivo.setX_PEUS(new BigDecimal(GeneradorID.getID()));
        }
        if (this.tipoControlDuplicidad == CONTROL_DUPLICIDAD_POR_ID) {
            if (this.grafico.getPerfilesUsuarioInvolucrados().obtenerDato(this.perfilActivo.getX_PEUS()) == null) {
                this.grafico.getPerfilesUsuarioInvolucrados().add(this.perfilActivo);
            } else {
                this.perfilActivo = (TrPerfilUsuario)this.grafico.getPerfilesUsuarioInvolucrados().obtenerDato(this.perfilActivo.getX_PEUS());
            }
        } else {
            TrPerfilUsuario perfilEncontrado = (TrPerfilUsuario)this.grafico.getPerfilesUsuarioInvolucrados().existeElemento(this.perfilActivo, false);
            if (perfilEncontrado == null) {
                this.grafico.getPerfilesUsuarioInvolucrados().add(this.perfilActivo);
            } else if (this.bActualizarEntidades) {
                perfilEncontrado.setNOMBRE(this.perfilActivo.getNOMBRE());
                perfilEncontrado.setDESCRIPCION(this.perfilActivo.getDESCRIPCION());
            }
        }
    }

    private void controlDuplicidadParametro() {
        TrParametroEnCarga parametroEnCarga = new TrParametroEnCarga();
        parametroEnCarga.setIdEnCarga(this.trParametroActivo.getPARAMID().getPkVal());
        if (this.tipoLectura == LECTURA_IMPORTACION_DES) {
            this.trParametroActivo.setPARAMID(new TpoPK(new BigDecimal(GeneradorID.getID())));
        }
        if (this.tipoControlDuplicidad == CONTROL_DUPLICIDAD_POR_ID) {
            if (this.grafico.getParametrosInvolucrados().obtenerDato(this.trParametroActivo.getPARAMID().getPkVal()) == null) {
                this.grafico.getParametrosInvolucrados().add(this.trParametroActivo);
            } else {
                this.trParametroActivo = (TrParametro)this.grafico.getParametrosInvolucrados().obtenerDato(this.trParametroActivo.getPARAMID().getPkVal());
            }
            parametroEnCarga.setParametro(this.trParametroActivo);
            this.grafico.getParametrosInvolucradosEnCarga().add(parametroEnCarga);
        } else {
            TrParametro parametroEncontrado = (TrParametro)this.grafico.getParametrosInvolucrados().existeElemento(this.trParametroActivo, false);
            if (parametroEncontrado == null) {
                this.grafico.getParametrosInvolucrados().add(this.trParametroActivo);
                parametroEnCarga.setParametro(this.trParametroActivo);
                this.grafico.getParametrosInvolucradosEnCarga().add(parametroEnCarga);
            } else {
                if (this.bActualizarEntidades) {
                    parametroEncontrado.setNOMBRE(this.trParametroActivo.getNOMBRE());
                    parametroEncontrado.setDESCRIPCION(this.trParametroActivo.getDESCRIPCION());
                    parametroEncontrado.setTipoParametro(this.trParametroActivo.getTipoParametro());
                    parametroEncontrado.setTAMANIO(this.trParametroActivo.getTAMANIO());
                }
                parametroEnCarga.setParametro(parametroEncontrado);
                this.grafico.getParametrosInvolucradosEnCarga().add(parametroEnCarga);
            }
        }
    }

    protected void controlDuplicidadBloque() {
        if (this.tipoLectura == LECTURA_IMPORTACION_DES) {
            this.trBloqueActivo.setBloqueId(new TpoPK(new BigDecimal(GeneradorID.getID())));
        }
        if (this.tipoControlDuplicidad == CONTROL_DUPLICIDAD_POR_ID) {
            if (this.grafico.getBloquesInvolucrados().obtenerDato(this.trBloqueActivo.getBloqueId().getPkVal()) == null) {
                this.grafico.getBloquesInvolucrados().add(this.trBloqueActivo);
            } else {
                this.trBloqueActivo = (TrBloque)this.grafico.getBloquesInvolucrados().obtenerDato(this.trBloqueActivo.getBloqueId().getPkVal());
            }
        } else {
            TrBloque bloqueEncontrado = (TrBloque)this.grafico.getBloquesInvolucrados().existeElemento(this.trBloqueActivo, false);
            if (bloqueEncontrado == null) {
                this.grafico.getBloquesInvolucrados().add(this.trBloqueActivo);
                if (this.grafico.getTareasInvolucradas() != null) {
                    TrBloquePermitido tareaAsociada = new TrBloquePermitido();
                    tareaAsociada.setBloqueFin(this.trBloqueActivo);
                    tareaAsociada.setNOMBRE(this.trBloqueActivo.getNombre());
                    tareaAsociada.setDESCRIPCION(this.trBloqueActivo.getDescripcion());
                    tareaAsociada.setTrTipoTarea(this.trBloqueActivo.getTrTipoTarea());
                    this.grafico.getTareasInvolucradas().add(tareaAsociada);
                }
            } else {
                if (this.bActualizarEntidades) {
                    bloqueEncontrado.setNombre(this.trBloqueActivo.getNombre());
                    bloqueEncontrado.setDescripcion(this.trBloqueActivo.getDescripcion());
                    bloqueEncontrado.setTipoBloque(this.trBloqueActivo.getTipoBloque());
                    bloqueEncontrado.setInformar(this.trBloqueActivo.getInformar());
                    bloqueEncontrado.setParametros(this.trBloqueActivo.getParametros());
                }
                if (this.grafico.getTareasInvolucradas() != null) {
                    TrBloquePermitido bloquePerAux = new TrBloquePermitido();
                    bloquePerAux.setBloqueFin(bloqueEncontrado);
                    TrBloquePermitido tareaLocalizada = this.grafico.getTareasInvolucradas().obtenerTareaBloque(bloquePerAux);
                    if (tareaLocalizada == null) {
                        TrBloquePermitido tareaAsociada = new TrBloquePermitido();
                        tareaAsociada.setBloqueFin(this.trBloqueActivo);
                        tareaAsociada.setNOMBRE(this.trBloqueActivo.getNombre());
                        tareaAsociada.setDESCRIPCION(this.trBloqueActivo.getDescripcion());
                        tareaAsociada.setTrTipoTarea(this.trBloqueActivo.getTrTipoTarea());
                        this.grafico.getTareasInvolucradas().add(tareaAsociada);
                    } else if (this.bActualizarEntidades) {
                        tareaLocalizada.setNOMBRE(this.trBloqueActivo.getNombre());
                        tareaLocalizada.setDESCRIPCION(this.trBloqueActivo.getDescripcion());
                        tareaLocalizada.setTrTipoTarea(this.trBloqueActivo.getTrTipoTarea());
                    }
                }
            }
        }
        this.trBloqueActivo = null;
    }

    protected void controlDuplicidadTipoParrafo() {
        TrTipoParrafoEnCarga tipoParrafoEnCarga = new TrTipoParrafoEnCarga();
        tipoParrafoEnCarga.setIdEnCarga(this.tipoParrafoActivo.getXID());
        if (this.tipoLectura == LECTURA_IMPORTACION_DES) {
            this.tipoParrafoActivo.setXID(new BigDecimal(GeneradorID.getID()));
        }
        if (this.tipoControlDuplicidad == CONTROL_DUPLICIDAD_POR_ID) {
            if (this.grafico.getTipoParrafosInvolucrados().obtenerDato(this.tipoParrafoActivo.getXID()) == null) {
                this.grafico.getTipoParrafosInvolucrados().add(this.tipoParrafoActivo);
            } else {
                this.tipoParrafoActivo = (TrTipoParrafo)this.grafico.getTipoParrafosInvolucrados().obtenerDato(this.tipoParrafoActivo.getXID());
            }
            tipoParrafoEnCarga.setTipoParrafo(this.tipoParrafoActivo);
            this.grafico.getTiposParrafoInvolucradosEnCarga().add(tipoParrafoEnCarga);
        } else {
            TrTipoParrafo tipoEncontrado = (TrTipoParrafo)this.grafico.getTipoParrafosInvolucrados().existeElemento(this.tipoParrafoActivo, false);
            if (tipoEncontrado == null) {
                this.grafico.getTipoParrafosInvolucrados().add(this.tipoParrafoActivo);
                tipoParrafoEnCarga.setTipoParrafo(this.tipoParrafoActivo);
                this.grafico.getTiposParrafoInvolucradosEnCarga().add(tipoParrafoEnCarga);
            } else {
                if (this.bActualizarEntidades) {
                    tipoEncontrado.setAbreviatura(this.tipoParrafoActivo.getAbreviatura());
                    tipoEncontrado.setDescripcion(this.tipoParrafoActivo.getDescripcion());
                    tipoEncontrado.setEtiqueta(this.tipoParrafoActivo.getEtiqueta());
                    tipoEncontrado.setContenido(this.tipoParrafoActivo.getContenido());
                    tipoEncontrado.setAlineacion(this.tipoParrafoActivo.getAlineacion());
                    tipoEncontrado.setEstilo(this.tipoParrafoActivo.getEstilo());
                    tipoEncontrado.setEstiloEtiq(this.tipoParrafoActivo.getEstiloEtiq());
                    tipoEncontrado.setUbicacion(this.tipoParrafoActivo.getUbicacion());
                    tipoEncontrado.setEditable(this.tipoParrafoActivo.isEditable());
                    tipoEncontrado.setNombreFichero(this.tipoParrafoActivo.getNombreFichero());
                    tipoEncontrado.setFormato(this.tipoParrafoActivo.getFormato());
                }
                tipoParrafoEnCarga.setTipoParrafo(tipoEncontrado);
                this.grafico.getTiposParrafoInvolucradosEnCarga().add(tipoParrafoEnCarga);
            }
        }
    }

    protected void controlDuplicidadPlantilla() {
        TrPlantillaEnCarga plantillaEnCarga = new TrPlantillaEnCarga();
        plantillaEnCarga.setIdEnCarga(this.PlantillaActiva.getXID());
        if (this.tipoLectura == LECTURA_IMPORTACION_DES) {
            this.PlantillaActiva.setXID(new BigDecimal(GeneradorID.getID()));
        }
        if (this.tipoControlDuplicidad == CONTROL_DUPLICIDAD_POR_ID) {
            if (this.grafico.getPlantillasInvolucradas().obtenerDato(this.PlantillaActiva.getXID()) == null) {
                this.grafico.getPlantillasInvolucradas().add(this.PlantillaActiva);
            } else {
                this.PlantillaActiva = (TrPlantilla)this.grafico.getPlantillasInvolucradas().obtenerDato(this.PlantillaActiva.getXID());
            }
            plantillaEnCarga.setPlantilla(this.PlantillaActiva);
            this.grafico.getPlantillasInvolucradasEnCarga().add(plantillaEnCarga);
        } else {
            TrPlantilla plantillaEncontrada = (TrPlantilla)this.grafico.getPlantillasInvolucradas().existeElemento(this.PlantillaActiva, false);
            if (plantillaEncontrada == null) {
                this.grafico.getPlantillasInvolucradas().add(this.PlantillaActiva);
                plantillaEnCarga.setPlantilla(this.PlantillaActiva);
                this.grafico.getPlantillasInvolucradasEnCarga().add(plantillaEnCarga);
            } else {
                if (this.bActualizarEntidades) {
                    plantillaEncontrada.setNOMBRE(this.PlantillaActiva.getNOMBRE());
                    plantillaEncontrada.setDESCRIPCION(this.PlantillaActiva.getDESCRIPCION());
                    plantillaEncontrada.setNOMBRE_INFORME(this.PlantillaActiva.getNOMBRE_INFORME());
                }
                plantillaEnCarga.setPlantilla(plantillaEncontrada);
                this.grafico.getPlantillasInvolucradasEnCarga().add(plantillaEnCarga);
            }
        }
    }

    protected void controlDuplicidadTipoActo() {
        TrTipoActoEnCarga tipoActoEnCarga = new TrTipoActoEnCarga();
        tipoActoEnCarga.setIdEnCarga(this.tipoActoActivo.getTIPOID());
        if (this.tipoLectura == LECTURA_IMPORTACION_DES) {
            this.tipoActoActivo.setTIPOID(new BigDecimal(GeneradorID.getID()));
        }
        if (this.tipoControlDuplicidad == CONTROL_DUPLICIDAD_POR_ID) {
            if (this.grafico.getTiposActoInvolucrados().obtenerDato(this.tipoActoActivo.getTIPOID()) == null) {
                this.grafico.getTiposActoInvolucrados().add(this.tipoActoActivo);
            } else {
                this.tipoActoActivo = (TrTipoActo)this.grafico.getTiposActoInvolucrados().obtenerDato(this.tipoActoActivo.getTIPOID());
            }
            tipoActoEnCarga.setTipoActo(this.tipoActoActivo);
            this.grafico.getTiposActoInvolucradosEnCarga().add(tipoActoEnCarga);
        } else {
            TrTipoActo tipoEncontrado = (TrTipoActo)this.grafico.getTiposActoInvolucrados().existeElemento(this.tipoActoActivo, false);
            if (tipoEncontrado == null) {
                this.grafico.getTiposActoInvolucrados().add(this.tipoActoActivo);
                tipoActoEnCarga.setTipoActo(this.tipoActoActivo);
                this.grafico.getTiposActoInvolucradosEnCarga().add(tipoActoEnCarga);
            } else {
                if (this.bActualizarEntidades) {
                    tipoEncontrado.setABREVIATURA(this.tipoActoActivo.getABREVIATURA());
                    tipoEncontrado.setDESCRIPCION(this.tipoActoActivo.getDESCRIPCION());
                }
                tipoActoEnCarga.setTipoActo(tipoEncontrado);
                this.grafico.getTiposActoInvolucradosEnCarga().add(tipoActoEnCarga);
            }
        }
    }

    protected void controlDuplicidadVariable() {
        TrVariableEnCarga variableEnCarga = new TrVariableEnCarga();
        variableEnCarga.setIdEnCarga(this.trVariableActiva.getVARIABLEID().getPkVal());
        if (this.tipoLectura == LECTURA_IMPORTACION_DES) {
            this.trVariableActiva.setVARIABLEID(new TpoPK(new BigDecimal(GeneradorID.getID())));
        }
        if (this.tipoControlDuplicidad == CONTROL_DUPLICIDAD_POR_ID) {
            if (this.grafico.getVariablesInvolucradas().obtenerDato(this.trVariableActiva.getVARIABLEID().getPkVal()) == null) {
                this.grafico.getVariablesInvolucradas().add(this.trVariableActiva);
            } else {
                this.trVariableActiva = (TrVariable)this.grafico.getVariablesInvolucradas().obtenerDato(this.trVariableActiva.getVARIABLEID().getPkVal());
            }
            variableEnCarga.setVariable(this.trVariableActiva);
            this.grafico.getVariablesInvolucradasEnCarga().add(variableEnCarga);
        } else {
            TrVariable variableEncontrada = (TrVariable)this.grafico.getVariablesInvolucradas().existeElemento(this.trVariableActiva, false);
            if (variableEncontrada == null) {
                this.grafico.getVariablesInvolucradas().add(this.trVariableActiva);
                variableEnCarga.setVariable(this.trVariableActiva);
                this.grafico.getVariablesInvolucradasEnCarga().add(variableEnCarga);
            } else {
                if (this.bActualizarEntidades) {
                    variableEncontrada.setNOMBRE(this.trVariableActiva.getNOMBRE());
                    variableEncontrada.setDESCRIPCION(this.trVariableActiva.getDESCRIPCION());
                    variableEncontrada.setPAQUETE(this.trVariableActiva.getPAQUETE());
                    variableEncontrada.setFuncion(this.trVariableActiva.getFuncion());
                    variableEncontrada.setTipoImplementacion(this.trVariableActiva.getTipoImplementacion());
                    variableEncontrada.setTipoActo(this.trVariableActiva.getTipoActo());
                    variableEncontrada.setParametros(this.trVariableActiva.getParametros());
                }
                variableEnCarga.setVariable(variableEncontrada);
                this.grafico.getVariablesInvolucradasEnCarga().add(variableEnCarga);
            }
        }
        this.trVariableActiva = null;
    }

    protected void controlDuplicidadTipoDocumento() {
        if (this.tipoLectura == LECTURA_IMPORTACION_DES) {
            this.tipoDocumentoActivo.setXID(new BigDecimal(GeneradorID.getID()));
        }
        if (this.tipoControlDuplicidad == CONTROL_DUPLICIDAD_POR_ID) {
            if (this.grafico.getTipoDocumentosInvolucrados().obtenerDato(this.tipoDocumentoActivo.getXID()) == null) {
                this.grafico.getTipoDocumentosInvolucrados().add(this.tipoDocumentoActivo);
            } else {
                this.tipoDocumentoActivo = (TrTipoDocumento)this.grafico.getTipoDocumentosInvolucrados().obtenerDato(this.tipoDocumentoActivo.getXID());
            }
        } else {
            TrTipoDocumento tipoDocEncontrado = (TrTipoDocumento)this.grafico.getTipoDocumentosInvolucrados().existeElemento(this.tipoDocumentoActivo, false);
            if (tipoDocEncontrado == null) {
                this.grafico.getTipoDocumentosInvolucrados().add(this.tipoDocumentoActivo);
                if (this.grafico.getTareasInvolucradas() != null) {
                    TrDocumentoPermitido tareaAsociada = new TrDocumentoPermitido();
                    tareaAsociada.setTipoDocumento(this.tipoDocumentoActivo);
                    tareaAsociada.setNOMBRE(this.tipoDocumentoActivo.getNombre());
                    tareaAsociada.setDESCRIPCION(this.tipoDocumentoActivo.getDescripcion());
                    tareaAsociada.setTrTipoTarea(this.tipoDocumentoActivo.getTrTipoTarea());
                    this.grafico.getTareasInvolucradas().add(tareaAsociada);
                }
            } else {
                if (this.bActualizarEntidades) {
                    tipoDocEncontrado.setEtiqueta(this.tipoDocumentoActivo.getEtiqueta());
                    tipoDocEncontrado.setNombre(this.tipoDocumentoActivo.getNombre());
                    tipoDocEncontrado.setDescripcion(this.tipoDocumentoActivo.getDescripcion());
                    tipoDocEncontrado.setPlantilla(this.tipoDocumentoActivo.getPlantilla());
                    tipoDocEncontrado.setEntSal(this.tipoDocumentoActivo.getEntSal());
                    tipoDocEncontrado.setIncGen(this.tipoDocumentoActivo.getIncGen());
                    tipoDocEncontrado.setMultiple(this.tipoDocumentoActivo.isMultiple());
                    tipoDocEncontrado.setAuxiliar(this.tipoDocumentoActivo.getAuxiliar());
                    tipoDocEncontrado.setFechaFirma(this.tipoDocumentoActivo.isFechaFirma());
                    tipoDocEncontrado.setInformar(this.tipoDocumentoActivo.isInformar());
                    tipoDocEncontrado.setArchivable(this.tipoDocumentoActivo.isArchivable());
                    tipoDocEncontrado.setVersionable(this.tipoDocumentoActivo.isVersionable());
                    tipoDocEncontrado.setReutilizable(this.tipoDocumentoActivo.isReutilizable());
                    tipoDocEncontrado.setRegistrable(this.tipoDocumentoActivo.isRegistrable());
                    tipoDocEncontrado.setNotificable(this.tipoDocumentoActivo.isNotificable());
                    tipoDocEncontrado.setModoGen(this.tipoDocumentoActivo.getModoGen());
                    tipoDocEncontrado.setClaseDoc(this.tipoDocumentoActivo.getClaseDoc());
                    tipoDocEncontrado.setFusionar_Var(this.tipoDocumentoActivo.isFusionar_Var());
                    tipoDocEncontrado.setFirma_Digi(this.tipoDocumentoActivo.isFirma_Digi());
                    tipoDocEncontrado.setTipo_Firma(this.tipoDocumentoActivo.getTipo_Firma());
                    tipoDocEncontrado.setNom_Fichero(this.tipoDocumentoActivo.getT_Nom_Fichero());
                    tipoDocEncontrado.setTFormato(this.tipoDocumentoActivo.getT_Formato());
                    tipoDocEncontrado.setParrafoTipoDoc(this.tipoDocumentoActivo.getParrafoTipoDoc());
                    tipoDocEncontrado.setVariables(this.tipoDocumentoActivo.getVariables());
                }
                if (this.grafico.getTareasInvolucradas() != null) {
                    TrDocumentoPermitido documentoPerAux = new TrDocumentoPermitido();
                    documentoPerAux.setTipoDocumento(tipoDocEncontrado);
                    TrDocumentoPermitido tareaLocalizada = this.grafico.getTareasInvolucradas().obtenerTareaDocumento(documentoPerAux);
                    if (tareaLocalizada == null) {
                        TrDocumentoPermitido tareaAsociada = new TrDocumentoPermitido();
                        tareaAsociada.setTipoDocumento(this.tipoDocumentoActivo);
                        tareaAsociada.setNOMBRE(this.tipoDocumentoActivo.getNombre());
                        tareaAsociada.setDESCRIPCION(this.tipoDocumentoActivo.getDescripcion());
                        tareaAsociada.setTrTipoTarea(this.tipoDocumentoActivo.getTrTipoTarea());
                        this.grafico.getTareasInvolucradas().add(tareaAsociada);
                    } else if (this.bActualizarEntidades) {
                        tareaLocalizada.setNOMBRE(this.tipoDocumentoActivo.getNombre());
                        tareaLocalizada.setDESCRIPCION(this.tipoDocumentoActivo.getDescripcion());
                        tareaLocalizada.setTrTipoTarea(this.tipoDocumentoActivo.getTrTipoTarea());
                    }
                }
            }
        }
        this.tipoDocumentoActivo = null;
    }

    protected void controlDuplicidadCondicion() {
        if (this.tipoLectura == LECTURA_IMPORTACION_DES) {
            this.condicionActiva.setXID(new BigDecimal(GeneradorID.getID()));
        }
        if (this.tipoControlDuplicidad == CONTROL_DUPLICIDAD_POR_ID) {
            if (this.grafico.getCondicionesInvolucradas().obtenerDato(this.condicionActiva.getXID()) == null) {
                this.grafico.getCondicionesInvolucradas().add(this.condicionActiva);
            } else {
                this.condicionActiva = (TrCondicion)this.grafico.getCondicionesInvolucradas().obtenerDato(this.condicionActiva.getXID());
            }
        } else {
            TrCondicion condicionEncontrada = (TrCondicion)this.grafico.getCondicionesInvolucradas().existeElemento(this.condicionActiva, false);
            if (condicionEncontrada == null) {
                this.grafico.getCondicionesInvolucradas().add(this.condicionActiva);
            } else if (this.bActualizarEntidades) {
                condicionEncontrada.setNombre(this.condicionActiva.getNombre());
                condicionEncontrada.setDescripcion(this.condicionActiva.getDescripcion());
                condicionEncontrada.setExp(this.condicionActiva.isExp());
                condicionEncontrada.setTrans(this.condicionActiva.isTrans());
                condicionEncontrada.setDocPermitido(this.condicionActiva.isDocPermitido());
                condicionEncontrada.setExpEnFase(this.condicionActiva.isExpEnFase());
                condicionEncontrada.setTipoEvol(this.condicionActiva.isTipoEvol());
                condicionEncontrada.setFecha(this.condicionActiva.isFecha());
                condicionEncontrada.setUsuario(this.condicionActiva.isUsuario());
                condicionEncontrada.setFase(this.condicionActiva.isFase());
                condicionEncontrada.setTipo_Documento(this.condicionActiva.isTipo_Documento());
                condicionEncontrada.setTipoImplementacion(this.condicionActiva.getTipoImplementacion());
                condicionEncontrada.setPaquete(this.condicionActiva.getPaquete());
                condicionEncontrada.setFuncion(this.condicionActiva.getFuncion());
                condicionEncontrada.setExpresionCompleja(this.condicionActiva.isExpresionCompleja());
                condicionEncontrada.setValorExpresionCompleja(this.condicionActiva.getValorExpresionCompleja());
                condicionEncontrada.setTextoLibre(this.condicionActiva.getTextoLibre());
            }
        }
    }

    protected void controlDuplicidadAccion() {
        if (this.tipoLectura == LECTURA_IMPORTACION_DES) {
            this.accionActiva.setXID(new BigDecimal(GeneradorID.getID()));
        }
        if (this.tipoControlDuplicidad == CONTROL_DUPLICIDAD_POR_ID) {
            if (this.grafico.getAccionesInvolucradas().obtenerDato(this.accionActiva.getXID()) == null) {
                this.grafico.getAccionesInvolucradas().add(this.accionActiva);
            } else {
                this.accionActiva = (TrAccion)this.grafico.getAccionesInvolucradas().obtenerDato(this.accionActiva.getXID());
            }
        } else {
            TrAccion accionEncontrada = (TrAccion)this.grafico.getAccionesInvolucradas().existeElemento(this.accionActiva, false);
            if (accionEncontrada == null) {
                this.grafico.getAccionesInvolucradas().add(this.accionActiva);
            } else if (this.bActualizarEntidades) {
                accionEncontrada.setNombre(this.accionActiva.getNombre());
                accionEncontrada.setDescripcion(this.accionActiva.getDescripcion());
                accionEncontrada.setExp(this.accionActiva.isExp());
                accionEncontrada.setTrans(this.accionActiva.isTrans());
                accionEncontrada.setDocPermitido(this.accionActiva.isDocPermitido());
                accionEncontrada.setExpEnFase(this.accionActiva.isExpEnFase());
                accionEncontrada.setTipoEvol(this.accionActiva.isTipoEvol());
                accionEncontrada.setFecha(this.accionActiva.isFecha());
                accionEncontrada.setUsuario(this.accionActiva.isUsuario());
                accionEncontrada.setFase(this.accionActiva.isFase());
                accionEncontrada.setTipo_Documento(this.accionActiva.isTipo_Documento());
                accionEncontrada.setTipoImplementacion(this.accionActiva.getTipoImplementacion());
                accionEncontrada.setPaquete(this.accionActiva.getPaquete());
                accionEncontrada.setFuncion(this.accionActiva.getFuncion());
                accionEncontrada.setTextoLibre(this.accionActiva.getTextoLibre());
            }
        }
    }

    protected void controlDuplicidadAviso() {
        if (this.tipoLectura == LECTURA_IMPORTACION_DES) {
            this.AvisoActivo.setXID(new BigDecimal(GeneradorID.getID()));
        }
        if (this.tipoControlDuplicidad == CONTROL_DUPLICIDAD_POR_ID) {
            if (this.grafico.getAvisosInvolucrados().obtenerDato(this.AvisoActivo.getXID()) == null) {
                this.grafico.getAvisosInvolucrados().add(this.AvisoActivo);
            } else {
                this.AvisoActivo = (TrAviso)this.grafico.getAvisosInvolucrados().obtenerDato(this.AvisoActivo.getXID());
            }
        } else {
            TrAviso avisoEncontrado = (TrAviso)this.grafico.getAvisosInvolucrados().existeElemento(this.AvisoActivo, false);
            if (avisoEncontrado == null) {
                this.grafico.getAvisosInvolucrados().add(this.AvisoActivo);
            } else if (this.bActualizarEntidades) {
                avisoEncontrado.setNOMBRE(this.AvisoActivo.getNOMBRE());
                avisoEncontrado.setDESCRIPCION(this.AvisoActivo.getDESCRIPCION());
            }
        }
    }

    protected void controlDuplicidadMetafase() {
        if (this.tipoLectura == LECTURA_IMPORTACION_DES) {
            this.metafaseActiva.setMETAID(new BigDecimal(GeneradorID.getID()));
        }
        if (this.tipoControlDuplicidad == CONTROL_DUPLICIDAD_POR_ID) {
            if (this.grafico.getMetafasesInvolucradas().obtenerDato(this.metafaseActiva.getMETAID()) == null) {
                this.grafico.getMetafasesInvolucradas().add(this.metafaseActiva);
            } else {
                this.metafaseActiva = (TrMetafase)this.grafico.getMetafasesInvolucradas().obtenerDato(this.metafaseActiva.getMETAID());
            }
        } else {
            TrMetafase metafaseEncontrada = (TrMetafase)this.grafico.getMetafasesInvolucradas().existeElemento(this.metafaseActiva, false);
            if (metafaseEncontrada == null) {
                this.grafico.getMetafasesInvolucradas().add(this.metafaseActiva);
            } else if (this.bActualizarEntidades) {
                metafaseEncontrada.setNOMBRE(this.metafaseActiva.getNOMBRE());
                metafaseEncontrada.setDESCRIPCION(this.metafaseActiva.getDESCRIPCION());
                metafaseEncontrada.setORDEN(this.metafaseActiva.getORDEN());
                metafaseEncontrada.setINFORMAR(this.metafaseActiva.getINFORMAR());
            }
        }
    }

    protected void controlDuplicidadFase() {
        if (this.tipoLectura == LECTURA_IMPORTACION_DES) {
            this.faseActiva.setFASEID(new BigDecimal(GeneradorID.getID()));
        }
        if (this.tipoControlDuplicidad == CONTROL_DUPLICIDAD_POR_ID) {
            if (this.grafico.getFasesInvolucradas().obtenerDato(this.faseActiva.getFASEID()) == null) {
                this.grafico.getFasesInvolucradas().add(this.faseActiva);
            } else {
                this.faseActiva = (TrFase)this.grafico.getFasesInvolucradas().obtenerDato(this.faseActiva.getFASEID());
            }
        } else {
            TrFase faseEncontrada = (TrFase)this.grafico.getFasesInvolucradas().existeElemento(this.faseActiva, false);
            if (faseEncontrada == null) {
                this.grafico.getFasesInvolucradas().add(this.faseActiva);
            } else if (this.bActualizarEntidades) {
                faseEncontrada.setNOMBRE(this.faseActiva.getNOMBRE());
                faseEncontrada.setDESCRIPCION(this.faseActiva.getDESCRIPCION());
                faseEncontrada.setORDEN(this.faseActiva.getORDEN());
                faseEncontrada.setTIPOEVOL(this.faseActiva.getTIPOEVOL());
                faseEncontrada.setMETAFASE(this.faseActiva.getMETAFASE());
                faseEncontrada.setINFORMAR(this.faseActiva.isInformar());
                faseEncontrada.setTextoAuxiliar(this.faseActiva.getTextoAuxiliar());
            }
        }
    }

    protected void controlDuplicidadTipoOrganismo() {
        TrTipoOrganismoEnCarga tipoOrganismoEnCarga = new TrTipoOrganismoEnCarga();
        tipoOrganismoEnCarga.setIdEnCarga(this.tipoOrganismoActivo.getTIORID());
        if (this.tipoLectura == LECTURA_IMPORTACION_DES) {
            this.tipoOrganismoActivo.setTIORID(new BigDecimal(GeneradorID.getID()));
        }
        if (this.tipoControlDuplicidad == CONTROL_DUPLICIDAD_POR_ID) {
            if (this.grafico.getTiposOrganismoInvolucrados().obtenerDato(this.tipoOrganismoActivo.getTIORID()) == null) {
                this.grafico.getTiposOrganismoInvolucrados().add(this.tipoOrganismoActivo);
            } else {
                this.tipoOrganismoActivo = (TrTipoOrganismo)this.grafico.getTiposOrganismoInvolucrados().obtenerDato(this.tipoOrganismoActivo.getTIORID());
            }
            tipoOrganismoEnCarga.setTipoOrganismo(this.tipoOrganismoActivo);
            this.grafico.getTiposOrganismoInvolucradosEnCarga().add(tipoOrganismoEnCarga);
        } else {
            TrTipoOrganismo tipoEncontrado = (TrTipoOrganismo)this.grafico.getTiposOrganismoInvolucrados().existeElemento(this.tipoOrganismoActivo, false);
            if (tipoEncontrado == null) {
                this.grafico.getTiposOrganismoInvolucrados().add(this.tipoOrganismoActivo);
                tipoOrganismoEnCarga.setTipoOrganismo(this.tipoOrganismoActivo);
                this.grafico.getTiposOrganismoInvolucradosEnCarga().add(tipoOrganismoEnCarga);
            } else {
                if (this.bActualizarEntidades) {
                    tipoEncontrado.setAbreviatura(this.tipoOrganismoActivo.getAbreviatura());
                    tipoEncontrado.setDescripcion(this.tipoOrganismoActivo.getDescripcion());
                }
                tipoOrganismoEnCarga.setTipoOrganismo(tipoEncontrado);
                this.grafico.getTiposOrganismoInvolucradosEnCarga().add(tipoOrganismoEnCarga);
            }
        }
    }

    protected void controlDuplicidadOrganismo() {
        TrOrganismoEnCarga organismoEnCarga = new TrOrganismoEnCarga();
        organismoEnCarga.setIdEnCarga(this.organismoActivo.getUORGID());
        if (this.tipoLectura == LECTURA_IMPORTACION_DES) {
            this.organismoActivo.setUORGID(new BigDecimal(GeneradorID.getID()));
        }
        if (this.tipoControlDuplicidad == CONTROL_DUPLICIDAD_POR_ID) {
            if (this.grafico.getOrganismosInvolucrados().obtenerDato(this.organismoActivo.getUORGID()) == null) {
                this.grafico.getOrganismosInvolucrados().add(this.organismoActivo);
            } else {
                this.organismoActivo = (TrOrganismo)this.grafico.getOrganismosInvolucrados().obtenerDato(this.organismoActivo.getUORGID());
            }
            organismoEnCarga.setOrganismo(this.organismoActivo);
            this.grafico.getOrganismosInvolucradosEnCarga().add(organismoEnCarga);
        } else {
            TrOrganismo organismoEncontrado = (TrOrganismo)this.grafico.getOrganismosInvolucrados().existeElemento(this.organismoActivo, false);
            if (organismoEncontrado == null) {
                this.grafico.getOrganismosInvolucrados().add(this.organismoActivo);
                organismoEnCarga.setOrganismo(this.organismoActivo);
                this.grafico.getOrganismosInvolucradosEnCarga().add(organismoEnCarga);
            } else {
                if (this.bActualizarEntidades) {
                    organismoEncontrado.setCodigo(this.organismoActivo.getCodigo());
                    organismoEncontrado.setNombre(this.organismoActivo.getNombre());
                    organismoEncontrado.setNombreLargo(this.organismoActivo.getNombreLargo());
                    organismoEncontrado.setTipo(this.organismoActivo.getTipo());
                    organismoEncontrado.setTrTipoOrganismo(this.organismoActivo.getTrTipoOrganismo());
                    organismoEncontrado.setTrOrganismoPadre(this.organismoActivo.getTrOrganismoPadre());
                }
                organismoEnCarga.setOrganismo(organismoEncontrado);
                this.grafico.getOrganismosInvolucradosEnCarga().add(organismoEnCarga);
            }
        }
    }

    protected void controlDuplicidadTipoIndicacion() {
        TrTipoIndicacionFichaEnCarga tipoIndicacionEnCarga = new TrTipoIndicacionFichaEnCarga();
        tipoIndicacionEnCarga.setIdEnCarga(this.tipoIndicacionActivo.getTIINID());
        if (this.tipoLectura == LECTURA_IMPORTACION_DES) {
            this.tipoIndicacionActivo.setTIINID(new BigDecimal(GeneradorID.getID()));
        }
        if (this.tipoControlDuplicidad == CONTROL_DUPLICIDAD_POR_ID) {
            if (this.grafico.getTiposIndicacionInvolucrados().obtenerDato(this.tipoIndicacionActivo.getTIINID()) == null) {
                this.grafico.getTiposIndicacionInvolucrados().add(this.tipoIndicacionActivo);
            } else {
                this.tipoIndicacionActivo = (TrTipoIndicacionFicha)this.grafico.getTiposIndicacionInvolucrados().obtenerDato(this.tipoIndicacionActivo.getTIINID());
            }
            tipoIndicacionEnCarga.setTipoIndicacionFicha(this.tipoIndicacionActivo);
            this.grafico.getTiposIndicacionInvolucradosEnCarga().add(tipoIndicacionEnCarga);
        } else {
            TrTipoIndicacionFicha tipoEncontrado = (TrTipoIndicacionFicha)this.grafico.getTiposIndicacionInvolucrados().existeElemento(this.tipoIndicacionActivo, false);
            if (tipoEncontrado == null) {
                this.grafico.getTiposIndicacionInvolucrados().add(this.tipoIndicacionActivo);
                tipoIndicacionEnCarga.setTipoIndicacionFicha(this.tipoIndicacionActivo);
                this.grafico.getTiposIndicacionInvolucradosEnCarga().add(tipoIndicacionEnCarga);
            } else {
                if (this.bActualizarEntidades) {
                    tipoEncontrado.setAbreviatura(this.tipoIndicacionActivo.getAbreviatura());
                    tipoEncontrado.setDescripcion(this.tipoIndicacionActivo.getDescripcion());
                }
                tipoIndicacionEnCarga.setTipoIndicacionFicha(tipoEncontrado);
                this.grafico.getTiposIndicacionInvolucradosEnCarga().add(tipoIndicacionEnCarga);
            }
        }
    }

    protected void controlDuplicidadTipoNormativa() {
        TrTipoNormativaEnCarga tipoNormativaEnCarga = new TrTipoNormativaEnCarga();
        tipoNormativaEnCarga.setIdEnCarga(this.tipoNormativaActivo.getX_ID());
        if (this.tipoLectura == LECTURA_IMPORTACION_DES) {
            this.tipoNormativaActivo.setX_ID(new BigDecimal(GeneradorID.getID()));
        }
        if (this.tipoControlDuplicidad == CONTROL_DUPLICIDAD_POR_ID) {
            if (this.grafico.getTiposNormativaInvolucrados().obtenerDato(this.tipoNormativaActivo.getX_ID()) == null) {
                this.grafico.getTiposNormativaInvolucrados().add(this.tipoNormativaActivo);
            } else {
                this.tipoNormativaActivo = (TrTipoNormativa)this.grafico.getTiposNormativaInvolucrados().obtenerDato(this.tipoNormativaActivo.getX_ID());
            }
            tipoNormativaEnCarga.setTipoNormativa(this.tipoNormativaActivo);
            this.grafico.getTiposNormativaInvolucradosEnCarga().add(tipoNormativaEnCarga);
        } else {
            TrTipoNormativa tipoEncontrado = (TrTipoNormativa)this.grafico.getTiposNormativaInvolucrados().existeElemento(this.tipoNormativaActivo, false);
            if (tipoEncontrado == null) {
                this.grafico.getTiposNormativaInvolucrados().add(this.tipoNormativaActivo);
                tipoNormativaEnCarga.setTipoNormativa(this.tipoNormativaActivo);
                this.grafico.getTiposNormativaInvolucradosEnCarga().add(tipoNormativaEnCarga);
            } else {
                if (this.bActualizarEntidades) {
                    tipoEncontrado.setABREVIATURA(this.tipoNormativaActivo.getABREVIATURA());
                    tipoEncontrado.setDESCRIPCION(this.tipoNormativaActivo.getDESCRIPCION());
                }
                tipoNormativaEnCarga.setTipoNormativa(tipoEncontrado);
                this.grafico.getTiposNormativaInvolucradosEnCarga().add(tipoNormativaEnCarga);
            }
        }
    }

    protected void controlDuplicidadTipoPublicacion() {
        TrTipoPublicacionEnCarga tipoPublicacionEnCarga = new TrTipoPublicacionEnCarga();
        tipoPublicacionEnCarga.setIdEnCarga(this.tipoPublicacionActivo.getX_ID());
        if (this.tipoLectura == LECTURA_IMPORTACION_DES) {
            this.tipoPublicacionActivo.setX_ID(new BigDecimal(GeneradorID.getID()));
        }
        if (this.tipoControlDuplicidad == CONTROL_DUPLICIDAD_POR_ID) {
            if (this.grafico.getTiposPublicacionInvolucrados().obtenerDato(this.tipoPublicacionActivo.getX_ID()) == null) {
                this.grafico.getTiposPublicacionInvolucrados().add(this.tipoPublicacionActivo);
            } else {
                this.tipoPublicacionActivo = (TrTipoPublicacion)this.grafico.getTiposPublicacionInvolucrados().obtenerDato(this.tipoPublicacionActivo.getX_ID());
            }
            tipoPublicacionEnCarga.setTipoPublicacion(this.tipoPublicacionActivo);
            this.grafico.getTiposPublicacionInvolucradosEnCarga().add(tipoPublicacionEnCarga);
        } else {
            TrTipoPublicacion tipoEncontrado = (TrTipoPublicacion)this.grafico.getTiposPublicacionInvolucrados().existeElemento(this.tipoPublicacionActivo, false);
            if (tipoEncontrado == null) {
                this.grafico.getTiposPublicacionInvolucrados().add(this.tipoPublicacionActivo);
                tipoPublicacionEnCarga.setTipoPublicacion(this.tipoPublicacionActivo);
                this.grafico.getTiposPublicacionInvolucradosEnCarga().add(tipoPublicacionEnCarga);
            } else {
                if (this.bActualizarEntidades) {
                    tipoEncontrado.setABREVIATURA(this.tipoPublicacionActivo.getABREVIATURA());
                    tipoEncontrado.setDESCRIPCION(this.tipoPublicacionActivo.getDESCRIPCION());
                }
                tipoPublicacionEnCarga.setTipoPublicacion(tipoEncontrado);
                this.grafico.getTiposPublicacionInvolucradosEnCarga().add(tipoPublicacionEnCarga);
            }
        }
    }

    protected void controlDuplicidadAmbitoLey() {
        TrAmbitoLeyEnCarga ambitoLeyEnCarga = new TrAmbitoLeyEnCarga();
        ambitoLeyEnCarga.setIdEnCarga(this.ambitoLeyActivo.getX_ID());
        if (this.tipoLectura == LECTURA_IMPORTACION_DES) {
            this.ambitoLeyActivo.setX_ID(new BigDecimal(GeneradorID.getID()));
        }
        if (this.tipoControlDuplicidad == CONTROL_DUPLICIDAD_POR_ID) {
            if (this.grafico.getAmbitosLeyInvolucrados().obtenerDato(this.ambitoLeyActivo.getX_ID()) == null) {
                this.grafico.getAmbitosLeyInvolucrados().add(this.ambitoLeyActivo);
            } else {
                this.ambitoLeyActivo = (TrAmbitoLey)this.grafico.getAmbitosLeyInvolucrados().obtenerDato(this.ambitoLeyActivo.getX_ID());
            }
            ambitoLeyEnCarga.setAmbitoLey(this.ambitoLeyActivo);
            this.grafico.getAmbitosLeyInvolucradosEnCarga().add(ambitoLeyEnCarga);
        } else {
            TrAmbitoLey ambitoLeyEncontrado = (TrAmbitoLey)this.grafico.getAmbitosLeyInvolucrados().existeElemento(this.ambitoLeyActivo, false);
            if (ambitoLeyEncontrado == null) {
                this.grafico.getAmbitosLeyInvolucrados().add(this.ambitoLeyActivo);
                ambitoLeyEnCarga.setAmbitoLey(this.ambitoLeyActivo);
                this.grafico.getAmbitosLeyInvolucradosEnCarga().add(ambitoLeyEnCarga);
            } else {
                if (this.bActualizarEntidades) {
                    ambitoLeyEncontrado.setABREVIATURA(this.ambitoLeyActivo.getABREVIATURA());
                    ambitoLeyEncontrado.setDESCRIPCION(this.ambitoLeyActivo.getDESCRIPCION());
                }
                ambitoLeyEnCarga.setAmbitoLey(ambitoLeyEncontrado);
                this.grafico.getAmbitosLeyInvolucradosEnCarga().add(ambitoLeyEnCarga);
            }
        }
    }

    protected void controlDuplicidadNormativa() {
        TrNormativaEnCarga normativaEnCarga = new TrNormativaEnCarga();
        normativaEnCarga.setIdEnCarga(this.normativaActiva.getX_ID());
        if (this.tipoLectura == LECTURA_IMPORTACION_DES) {
            this.normativaActiva.setX_ID(new BigDecimal(GeneradorID.getID()));
        }
        if (this.tipoControlDuplicidad == CONTROL_DUPLICIDAD_POR_ID) {
            if (this.grafico.getNormativasInvolucradas().obtenerDato(this.normativaActiva.getX_ID()) == null) {
                this.grafico.getNormativasInvolucradas().add(this.normativaActiva);
            } else {
                this.normativaActiva = (TrNormativa)this.grafico.getNormativasInvolucradas().obtenerDato(this.normativaActiva.getX_ID());
            }
            normativaEnCarga.setNormativa(this.normativaActiva);
            this.grafico.getNormativasInvolucradasEnCarga().add(normativaEnCarga);
        } else {
            TrNormativa normativaEncontrada = (TrNormativa)this.grafico.getNormativasInvolucradas().existeElemento(this.normativaActiva, false);
            if (normativaEncontrada == null) {
                this.grafico.getNormativasInvolucradas().add(this.normativaActiva);
                normativaEnCarga.setNormativa(this.normativaActiva);
                this.grafico.getNormativasInvolucradasEnCarga().add(normativaEnCarga);
            } else {
                if (this.bActualizarEntidades) {
                    normativaEncontrada.setTrTipoNormativa0(this.normativaActiva.getTrTipoNormativa0());
                    normativaEncontrada.setAmbitoLey0(this.normativaActiva.getAmbitoLey0());
                    normativaEncontrada.setDescripcion(this.normativaActiva.getDescripcion());
                    normativaEncontrada.setFECHA_VIGOR(this.normativaActiva.getFECHA_VIGOR());
                    normativaEncontrada.setTitulo(this.normativaActiva.getTitulo());
                    normativaEncontrada.setNumero(this.normativaActiva.getNumero());
                    normativaEncontrada.setAnio(this.normativaActiva.getAnio());
                    normativaEncontrada.setTrTipoPublicacion0(this.normativaActiva.getTrTipoPublicacion0());
                    normativaEncontrada.setFECHA_PUBLICACION(this.normativaActiva.getFECHA_PUBLICACION());
                    normativaEncontrada.setNumero_Publicacion(this.normativaActiva.getNumero_Publicacion());
                }
                normativaEnCarga.setNormativa(normativaEncontrada);
                this.grafico.getNormativasInvolucradasEnCarga().add(normativaEnCarga);
            }
        }
    }
}

