/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.informes;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import gdtel.ui.ValidarNombreFichero;
import gdtel.ui.swing.FileFilterEx;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import modela.bd.obj.TrIndicacionFicha;
import modela.bd.obj.TrNormativa;
import modela.bd.obj.TrOrganismo;
import modela.bd.obj.TrOrganismoProc;
import modela.bd.obj.TrPlantillaProcedimiento;
import modela.bd.obj.TrPlazoCompuestoDefProc;
import modela.bd.obj.TrTransicion;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;

public class InformeProcedimientosPDF {
    private DDPGrafico m_grafico = null;
    private final Font tituloFont = FontFactory.getFont((String)"Helvetica", (float)12.0f, (int)1);
    private final Font camposFont = FontFactory.getFont((String)"Helvetica", (float)13.0f, (int)1);
    private final Font entidadesFont = FontFactory.getFont((String)"Helvetica", (float)16.0f, (int)4);
    private final Font valoresFont = FontFactory.getFont((String)"Helvetica", (float)10.0f, (int)0);
    private final Font transicionesFont = FontFactory.getFont((String)"Helvetica", (float)10.0f, (int)2);
    Image transN = null;
    Image transD = null;
    Image transU = null;
    Image transES = null;
    Image transEN = null;
    Image transI = null;
    Image transF = null;
    Image logoJusticia = null;

    public InformeProcedimientosPDF(DDPGrafico grafico) {
        this.m_grafico = grafico;
    }

    public void crearInformePDF() {
        Document document = new Document();
        try {
            String strRuta = this.seleccionarRutaInforme();
            if (strRuta == null || strRuta.equals("")) {
                return;
            }
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(strRuta));
            this.transN = Image.getInstance((URL)this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_NORMAL));
            this.transD = Image.getInstance((URL)this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_DIVISION));
            this.transU = Image.getInstance((URL)this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_UNION));
            this.transES = Image.getInstance((URL)this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_ES));
            this.transEN = Image.getInstance((URL)this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_EN));
            this.transI = Image.getInstance((URL)this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_INICIO));
            this.transF = Image.getInstance((URL)this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_FIN));
            this.logoJusticia = ModelaConf.getLogoInforme().equals(ModelaUI.IMG_LOGO_JUSTICIA) ? Image.getInstance((URL)this.getClass().getResource(ModelaUI.IMG_LOGO_JUSTICIA)) : Image.getInstance((String)ModelaConf.getLogoInforme());
            Image jpg = Image.getInstance((Image)this.logoJusticia);
            jpg.scaleAbsolute(160.0f, 40.0f);
            Chunk ck = new Chunk(jpg, 0.0f, -5.0f);
            Phrase p1 = new Phrase();
            p1.add((Object)ck);
            p1.add((Object)new Paragraph("   Ficha del procedimiento  ", this.tituloFont));
            p1.add((Object)new Paragraph(this.getNombreProcedimiento(), this.tituloFont));
            PdfPTable table2 = new PdfPTable(2);
            table2.addCell("celda 1");
            table2.addCell("Celda 2");
            HeaderFooter header = new HeaderFooter(p1, false);
            header.setBorder(2);
            document.setHeader(header);
            HeaderFooter footer = new HeaderFooter(new Phrase("P\u00e1gina ", this.camposFont), new Phrase("", this.camposFont));
            footer.setAlignment(2);
            footer.setBorder(1);
            document.setFooter(footer);
            document.open();
            document.setPageSize(PageSize.A4);
            document.add((Element)new Paragraph(" "));
            PdfPTable table = new PdfPTable(3);
            PdfPCell cell = null;
            table.addCell((Phrase)new Paragraph("Abreviatura", this.camposFont));
            table.addCell((Phrase)new Paragraph("Nombre", this.camposFont));
            table.addCell((Phrase)new Paragraph("Tipo", this.camposFont));
            cell = new PdfPCell((Phrase)new Paragraph(this.getAbreviaturaProcedimiento(), this.valoresFont));
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell((Phrase)new Paragraph(this.getNombreProcedimiento(), this.valoresFont));
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell((Phrase)new Paragraph(this.getTipoProcedimiento(), this.valoresFont));
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            table.addCell((Phrase)new Paragraph("Descripci\u00f3n:", this.camposFont));
            cell = new PdfPCell((Phrase)new Paragraph(this.getDescripcionProcedimiento(), this.valoresFont));
            cell.setColspan(2);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            table.setWidthPercentage(100.0f);
            document.add((Element)table);
            table = new PdfPTable(4);
            table.addCell((Phrase)new Paragraph("Familia:", this.camposFont));
            cell = new PdfPCell((Phrase)new Paragraph(this.getFamilia(), this.valoresFont));
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            table.addCell((Phrase)new Paragraph("Descripci\u00f3n:", this.camposFont));
            cell = new PdfPCell((Phrase)new Paragraph(this.getDescripcionFamilia(), this.valoresFont));
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            table.addCell((Phrase)new Paragraph("SubFamilia:", this.camposFont));
            cell = new PdfPCell((Phrase)new Paragraph(this.getSubFamilia(), this.valoresFont));
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            table.addCell((Phrase)new Paragraph("Descripci\u00f3n:", this.camposFont));
            cell = new PdfPCell((Phrase)new Paragraph(this.getDescripcionSubFamilia(), this.valoresFont));
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            table.setWidthPercentage(100.0f);
            document.add((Element)table);
            table = new PdfPTable(2);
            table.addCell((Phrase)new Paragraph("Organismo al que pertenece:", this.camposFont));
            cell = new PdfPCell((Phrase)new Paragraph(this.getOrganismoPertenece(), this.valoresFont));
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            table.addCell((Phrase)new Paragraph("Organismo competente:", this.camposFont));
            cell = new PdfPCell((Phrase)new Paragraph(this.getOrganismoCompetente(), this.valoresFont));
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            table.addCell((Phrase)new Paragraph("Organismo que tramita:", this.camposFont));
            cell = new PdfPCell((Phrase)new Paragraph(this.getOrganismoTramita(), this.valoresFont));
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            table.addCell((Phrase)new Paragraph("Organismo que resuelve:", this.camposFont));
            cell = new PdfPCell((Phrase)new Paragraph(this.getOrganismoResuelve(), this.valoresFont));
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            table.setWidthPercentage(100.0f);
            float[] sizesC = new float[]{40.0f, 60.0f};
            try {
                if (table != null) {
                    table.setWidths(sizesC);
                }
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
            document.add((Element)table);
            table = this.rellenarOrganismosProc();
            if (table != null) {
                document.add((Element)new Paragraph(" "));
                document.add((Element)new Paragraph("Otros organismos asociados", this.entidadesFont));
                document.add((Element)new Paragraph(" "));
                table.setWidthPercentage(100.0f);
                document.add((Element)table);
            }
            if ((table = this.rellenarFicha()) != null) {
                document.add((Element)new Paragraph(" "));
                document.add((Element)new Paragraph("Ficha", this.entidadesFont));
                document.add((Element)new Paragraph(" "));
                table.setWidthPercentage(100.0f);
                document.add((Element)table);
            }
            if ((table = this.rellenarPlantilla()) != null) {
                document.add((Element)new Paragraph(" "));
                document.add((Element)new Paragraph("Plantillas", this.entidadesFont));
                document.add((Element)new Paragraph(" "));
                table.setWidthPercentage(100.0f);
                document.add((Element)table);
            }
            if ((table = this.rellenarNormativasAplicables()) != null) {
                document.add((Element)new Paragraph(" "));
                document.add((Element)new Paragraph("Normativa aplicable", this.entidadesFont));
                document.add((Element)new Paragraph(" "));
                table.setWidthPercentage(100.0f);
                document.add((Element)table);
            }
            if ((table = this.rellenarPlazos()) != null) {
                document.add((Element)new Paragraph(" "));
                document.add((Element)new Paragraph("Plazos", this.entidadesFont));
                document.add((Element)new Paragraph(" "));
                table.setWidthPercentage(100.0f);
                document.add((Element)table);
            }
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
        document.close();
    }

    private String getAbreviaturaProcedimiento() {
        if (this.m_grafico.getDDP() == null || this.m_grafico.getDDP().getTIPOEVOL() == null) {
            return "";
        }
        return this.m_grafico.getDDP().getTIPOEVOL().getABREVIATURA();
    }

    private String getNombreProcedimiento() {
        if (this.m_grafico.getDDP() == null || this.m_grafico.getDDP().getTIPOEVOL() == null) {
            return "";
        }
        return this.m_grafico.getDDP().getTIPOEVOL().getNombre();
    }

    private String getTipoProcedimiento() {
        if (this.m_grafico.getDDP() == null || this.m_grafico.getDDP().getTIPOEVOL() == null) {
            return "";
        }
        return this.m_grafico.getDDP().getTIPOEVOL().getCATEGORIA().toString();
    }

    private String getDescripcionProcedimiento() {
        if (this.m_grafico.getDDP() == null || this.m_grafico.getDDP().getTIPOEVOL() == null) {
            return "";
        }
        return this.m_grafico.getDDP().getTIPOEVOL().getDESCRIPCION();
    }

    private String getOrganismoPertenece() {
        if (this.m_grafico.getDDP() == null || this.m_grafico.getDDP().getTIPOEVOL() == null || this.m_grafico.getDDP().getTIPOEVOL().getUORG_X_UROG() == null) {
            return "";
        }
        TrOrganismo organismo = this.m_grafico.getDDP().getTIPOEVOL().getUORG_X_UROG();
        if (organismo == null) {
            return "";
        }
        return organismo.toString();
    }

    private String getOrganismoCompetente() {
        if (this.m_grafico.getDDP() == null || this.m_grafico.getDDP().getTIPOEVOL() == null || this.m_grafico.getDDP().getTIPOEVOL().getUORG_X_UROG_COMP() == null) {
            return "";
        }
        TrOrganismo organismo = this.m_grafico.getDDP().getTIPOEVOL().getUORG_X_UROG_COMP();
        if (organismo == null) {
            return "";
        }
        return organismo.toString();
    }

    private String getOrganismoTramita() {
        if (this.m_grafico.getDDP() == null || this.m_grafico.getDDP().getTIPOEVOL() == null || this.m_grafico.getDDP().getTIPOEVOL().getUORG_X_UROG_TRAM() == null) {
            return "";
        }
        TrOrganismo organismo = this.m_grafico.getDDP().getTIPOEVOL().getUORG_X_UROG_TRAM();
        if (organismo == null) {
            return "";
        }
        return organismo.toString();
    }

    private String getOrganismoResuelve() {
        if (this.m_grafico.getDDP() == null || this.m_grafico.getDDP().getTIPOEVOL() == null || this.m_grafico.getDDP().getTIPOEVOL().getUORG_X_UROG_RES() == null) {
            return "";
        }
        TrOrganismo organismo = this.m_grafico.getDDP().getTIPOEVOL().getUORG_X_UROG_RES();
        if (organismo == null) {
            return "";
        }
        return organismo.toString();
    }

    private String getFamilia() {
        if (this.m_grafico.getDDP() == null || this.m_grafico.getDDP().getTIPOEVOL() == null || this.m_grafico.getDDP().getTIPOEVOL().getFamilia() == null || this.m_grafico.getDDP().getTIPOEVOL().getFamilia().equals("")) {
            return "";
        }
        return this.m_grafico.getDDP().getTIPOEVOL().getFamilia();
    }

    private String getDescripcionFamilia() {
        if (this.m_grafico.getDDP() == null || this.m_grafico.getDDP().getTIPOEVOL() == null || this.m_grafico.getDDP().getTIPOEVOL().getFamilia() == null || this.m_grafico.getDDP().getTIPOEVOL().getFamilia().equals("")) {
            return "";
        }
        return this.m_grafico.getDDP().getTIPOEVOL().getDescripcionFamilia();
    }

    private String getSubFamilia() {
        if (this.m_grafico.getDDP() == null || this.m_grafico.getDDP().getTIPOEVOL() == null || this.m_grafico.getDDP().getTIPOEVOL().getFamilia() == null || this.m_grafico.getDDP().getTIPOEVOL().getFamilia().equals("")) {
            return "";
        }
        return this.m_grafico.getDDP().getTIPOEVOL().getSubfamilia();
    }

    private String getDescripcionSubFamilia() {
        if (this.m_grafico.getDDP() == null || this.m_grafico.getDDP().getTIPOEVOL() == null || this.m_grafico.getDDP().getTIPOEVOL().getFamilia() == null || this.m_grafico.getDDP().getTIPOEVOL().getFamilia().equals("")) {
            return "";
        }
        return this.m_grafico.getDDP().getTIPOEVOL().getDescripcionSubfamilia();
    }

    private PdfPTable rellenarFicha() {
        if (this.m_grafico.getDDP() == null || this.m_grafico.getDDP().getTIPOEVOL() == null || this.m_grafico.getDDP().getTIPOEVOL().getFichaProcedimientoInvolucradas() == null || this.m_grafico.getDDP().getTIPOEVOL().getFichaProcedimientoInvolucradas().getListaDatos() == null || this.m_grafico.getDDP().getTIPOEVOL().getFichaProcedimientoInvolucradas().getListaDatos().size() <= 0) {
            return null;
        }
        ArrayList listaFichas = this.m_grafico.getDDP().getTIPOEVOL().getFichaProcedimientoInvolucradas().getListaDatos();
        PdfPTable table = null;
        if (listaFichas.size() > 0) {
            table = new PdfPTable(2);
            table.addCell((Phrase)new Paragraph("Tipo indicaci\u00f3n", this.camposFont));
            table.addCell((Phrase)new Paragraph("Descripci\u00f3n", this.camposFont));
            for (int i = 0; i < listaFichas.size(); ++i) {
                TrIndicacionFicha indicacionFicha = (TrIndicacionFicha)listaFichas.get(i);
                if (indicacionFicha == null) continue;
                if (indicacionFicha.getTipoIndicacionFicha() == null) {
                    table.addCell(" ");
                } else if (indicacionFicha.getTipoIndicacionFicha().getDescripcion() == null) {
                    table.addCell(" ");
                } else if (indicacionFicha.getTipoIndicacionFicha().getDescripcion().equals("")) {
                    table.addCell(" ");
                } else {
                    table.addCell((Phrase)new Paragraph(indicacionFicha.getTipoIndicacionFicha().getDescripcion(), this.valoresFont));
                }
                if (indicacionFicha.getDESCRIPCION() == null) {
                    table.addCell(" ");
                    continue;
                }
                if (indicacionFicha.getDESCRIPCION().equals("")) {
                    table.addCell(" ");
                    continue;
                }
                table.addCell((Phrase)new Paragraph(indicacionFicha.getDESCRIPCION(), this.valoresFont));
            }
        }
        float[] sizesC = new float[]{40.0f, 60.0f};
        try {
            if (table != null) {
                table.setWidths(sizesC);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return table;
    }

    private PdfPTable rellenarPlantilla() {
        if (this.m_grafico.getDDP() == null || this.m_grafico.getDDP().getTIPOEVOL() == null || this.m_grafico.getDDP().getTIPOEVOL().getPlantillasProcInvolucradas() == null || this.m_grafico.getDDP().getTIPOEVOL().getPlantillasProcInvolucradas().getListaDatos() == null || this.m_grafico.getDDP().getTIPOEVOL().getPlantillasProcInvolucradas().getListaDatos().size() <= 0) {
            return null;
        }
        ArrayList listaPlantillas = this.m_grafico.getDDP().getTIPOEVOL().getPlantillasProcInvolucradas().getListaDatos();
        PdfPTable table = null;
        if (listaPlantillas.size() > 0) {
            table = new PdfPTable(3);
            table.addCell((Phrase)new Paragraph("Nombre", this.camposFont));
            table.addCell((Phrase)new Paragraph("Archivo", this.camposFont));
            table.addCell((Phrase)new Paragraph("Descripci\u00f3n", this.camposFont));
            for (int i = 0; i < listaPlantillas.size(); ++i) {
                TrPlantillaProcedimiento plantillaProc = (TrPlantillaProcedimiento)listaPlantillas.get(i);
                if (plantillaProc == null) continue;
                if (plantillaProc.getNombre() == null) {
                    table.addCell(" ");
                } else if (plantillaProc.getNombre().equals("")) {
                    table.addCell(" ");
                } else {
                    table.addCell((Phrase)new Paragraph(plantillaProc.getNombre(), this.valoresFont));
                }
                if (plantillaProc.getNOMB_FICHERO() == null) {
                    table.addCell(" ");
                } else if (plantillaProc.getNOMB_FICHERO().equals("")) {
                    table.addCell(" ");
                } else {
                    table.addCell((Phrase)new Paragraph(plantillaProc.getNOMB_FICHERO(), this.valoresFont));
                }
                if (plantillaProc.getDescripcion() == null) {
                    table.addCell(" ");
                    continue;
                }
                if (plantillaProc.getDescripcion().equals("")) {
                    table.addCell(" ");
                    continue;
                }
                table.addCell((Phrase)new Paragraph(plantillaProc.getDescripcion(), this.valoresFont));
            }
        }
        float[] sizesC = new float[]{25.0f, 25.0f, 50.0f};
        try {
            if (table != null) {
                table.setWidths(sizesC);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return table;
    }

    private PdfPTable rellenarNormativasAplicables() {
        if (this.m_grafico.getDDP() == null || this.m_grafico.getDDP().getTIPOEVOL() == null || this.m_grafico.getDDP().getTIPOEVOL().getNormativasProcedimiento() == null || this.m_grafico.getDDP().getTIPOEVOL().getNormativasProcedimiento().getListaDatos() == null || this.m_grafico.getDDP().getTIPOEVOL().getNormativasProcedimiento().getListaDatos().size() <= 0) {
            return null;
        }
        ArrayList listaNormativas = this.m_grafico.getDDP().getTIPOEVOL().getNormativasProcedimiento().getListaDatos();
        PdfPTable table = null;
        if (listaNormativas.size() > 0) {
            table = new PdfPTable(6);
            for (int i = 0; i < listaNormativas.size(); ++i) {
                PdfPCell cell;
                TrNormativa normativaProc = (TrNormativa)listaNormativas.get(i);
                if (normativaProc != null) {
                    cell = null;
                    table.addCell((Phrase)new Paragraph("T\u00edtulo:", this.camposFont));
                    if (normativaProc.getTitulo() == null) {
                        table.addCell(" ");
                    } else if (normativaProc.getTitulo().equals("")) {
                        table.addCell(" ");
                    } else {
                        cell = new PdfPCell((Phrase)new Paragraph(normativaProc.getTitulo(), this.valoresFont));
                        cell.setVerticalAlignment(5);
                        table.addCell(cell);
                    }
                    table.addCell((Phrase)new Paragraph("N\u00famero:", this.camposFont));
                    if (normativaProc.getNumero() == null) {
                        table.addCell(" ");
                    } else {
                        cell = new PdfPCell((Phrase)new Paragraph(normativaProc.getNumero().toString(), this.valoresFont));
                        cell.setVerticalAlignment(5);
                        table.addCell(cell);
                    }
                    table.addCell((Phrase)new Paragraph("A\u00f1o:", this.camposFont));
                    if (normativaProc.getAnio() == null) {
                        table.addCell(" ");
                    } else {
                        cell = new PdfPCell((Phrase)new Paragraph(normativaProc.getAnio().toString(), this.valoresFont));
                        cell.setVerticalAlignment(5);
                        table.addCell(cell);
                    }
                    table.addCell((Phrase)new Paragraph("\u00c1mbito Ley: ", this.camposFont));
                    cell = normativaProc.getDescripcion() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (normativaProc.getDescripcion().equals("") ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(normativaProc.getDescripcion(), this.valoresFont)));
                    cell.setColspan(5);
                    cell.setVerticalAlignment(5);
                    table.addCell(cell);
                    table.addCell((Phrase)new Paragraph("Fecha   vigor: ", this.camposFont));
                    cell = null;
                    cell = normativaProc.getFECHA_VIGOR() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (normativaProc.getFECHA_VIGOR().equals("") ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(normativaProc.getFECHA_VIGOR(), this.valoresFont)));
                    cell.setColspan(2);
                    cell.setVerticalAlignment(5);
                    table.addCell(cell);
                    table.addCell((Phrase)new Paragraph("Fecha publicaci\u00f3n: ", this.camposFont));
                    cell = null;
                    cell = normativaProc.getFECHA_PUBLICACION() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (normativaProc.getFECHA_PUBLICACION().equals("") ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(normativaProc.getFECHA_PUBLICACION(), this.valoresFont)));
                    cell.setColspan(2);
                    cell.setVerticalAlignment(5);
                    table.addCell(cell);
                    cell = null;
                }
                cell = new PdfPCell((Phrase)new Paragraph(" "));
                cell.setBorder(0);
                table.addCell(cell);
                table.addCell(cell);
                table.addCell(cell);
                table.addCell(cell);
                table.addCell(cell);
                table.addCell(cell);
            }
        }
        return table;
    }

    private PdfPTable rellenarPlazos() {
        if (this.m_grafico.getDDP() == null || this.m_grafico.getDDP().getTIPOEVOL() == null || this.m_grafico.getDDP().getTIPOEVOL().getPlazosCompuestosProcedimiento() == null || this.m_grafico.getDDP().getTIPOEVOL().getPlazosCompuestosProcedimiento().getListaDatos() == null || this.m_grafico.getDDP().getTIPOEVOL().getPlazosCompuestosProcedimiento().getListaDatos().size() <= 0) {
            return null;
        }
        ArrayList listaPlazos = this.m_grafico.getDDP().getTIPOEVOL().getPlazosCompuestosProcedimiento().getListaDatos();
        PdfPTable table = null;
        if (listaPlazos.size() > 0) {
            table = new PdfPTable(7);
            for (int i = 0; i < listaPlazos.size(); ++i) {
                PdfPCell cell;
                TrPlazoCompuestoDefProc plazoCompuesto = (TrPlazoCompuestoDefProc)listaPlazos.get(i);
                if (plazoCompuesto != null) {
                    cell = null;
                    cell = new PdfPCell((Phrase)new Paragraph("Descripci\u00f3n:", this.camposFont));
                    cell.setColspan(2);
                    table.addCell(cell);
                    cell = plazoCompuesto.getDescripcion() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (plazoCompuesto.getDescripcion().equals("") ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(plazoCompuesto.getDescripcion(), this.valoresFont)));
                    cell.setColspan(5);
                    cell.setVerticalAlignment(5);
                    table.addCell(cell);
                    table.addCell((Phrase)new Paragraph("Tipo:", this.camposFont));
                    cell = plazoCompuesto.getTIPO() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (plazoCompuesto.getTIPO().equals("") ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(plazoCompuesto.getDescripcionTipoPlazo(), this.valoresFont)));
                    cell.setColspan(2);
                    cell.setVerticalAlignment(5);
                    table.addCell(cell);
                    cell.setColspan(2);
                    table.addCell((Phrase)new Paragraph("Tiempo:", this.camposFont));
                    if (plazoCompuesto.getUNIDADES() == null) {
                        table.addCell(" ");
                    } else {
                        cell = new PdfPCell((Phrase)new Paragraph(plazoCompuesto.getUNIDADES().toString(), this.valoresFont));
                        cell.setVerticalAlignment(5);
                        table.addCell(cell);
                    }
                    table.addCell((Phrase)new Paragraph("Unidad:", this.camposFont));
                    if (plazoCompuesto.getUNIDAD() == null) {
                        table.addCell(" ");
                    } else if (plazoCompuesto.getUNIDAD().equals("")) {
                        table.addCell(" ");
                    } else {
                        cell = new PdfPCell((Phrase)new Paragraph(plazoCompuesto.getDescripcionUnidad(), this.valoresFont));
                        cell.setVerticalAlignment(5);
                        table.addCell(cell);
                    }
                    if (plazoCompuesto.getTransicionesIni() != null && plazoCompuesto.getTransicionesIni().getListaDatos() != null && plazoCompuesto.getTransicionesIni().getListaDatos().size() > 0) {
                        cell = new PdfPCell((Phrase)new Paragraph("Transiciones en las que empieza a contar el plazo", this.transicionesFont));
                        cell.setColspan(7);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph("Tipo ", this.camposFont));
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph("Etiqueta ", this.camposFont));
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph("Descripci\u00f3n ", this.camposFont));
                        cell.setColspan(3);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph("Tipo de acto", this.camposFont));
                        cell.setColspan(2);
                        table.addCell(cell);
                        ArrayList listaTransicionesInicio = plazoCompuesto.getTransicionesIni().getListaDatos();
                        for (int j = 0; j < listaTransicionesInicio.size(); ++j) {
                            TrTransicion transicionIni = (TrTransicion)listaTransicionesInicio.get(j);
                            if (transicionIni == null) continue;
                            if (transicionIni.getTIPO() == null) {
                                cell = new PdfPCell((Phrase)new Paragraph(" "));
                            } else if (transicionIni.getTIPO().equals("")) {
                                cell = new PdfPCell((Phrase)new Paragraph(" "));
                            } else {
                                if (transicionIni.getTIPO().equals("N")) {
                                    cell = new PdfPCell(this.transN);
                                }
                                if (transicionIni.getTIPO().equals("D")) {
                                    cell = new PdfPCell(this.transD);
                                }
                                if (transicionIni.getTIPO().equals("U")) {
                                    cell = new PdfPCell(this.transU);
                                }
                                if (transicionIni.getTIPO().equals("ES")) {
                                    cell = new PdfPCell(this.transES);
                                }
                                if (transicionIni.getTIPO().equals("EN")) {
                                    cell = new PdfPCell(this.transEN);
                                }
                                if (transicionIni.getTIPO().equals("I")) {
                                    cell = new PdfPCell(this.transI);
                                }
                                if (transicionIni.getTIPO().equals("F")) {
                                    cell = new PdfPCell(this.transF);
                                }
                            }
                            cell.setColspan(1);
                            cell.setMinimumHeight(25.0f);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            table.addCell(cell);
                            cell = transicionIni.getETIQUETA() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (transicionIni.getETIQUETA().equals("") ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(transicionIni.getETIQUETA(), this.valoresFont)));
                            cell.setColspan(1);
                            cell.setVerticalAlignment(5);
                            table.addCell(cell);
                            cell = transicionIni.getDESCRIPCION() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (transicionIni.getDESCRIPCION().equals("") ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(transicionIni.getDESCRIPCION(), this.valoresFont)));
                            cell.setColspan(3);
                            cell.setVerticalAlignment(5);
                            table.addCell(cell);
                            cell = transicionIni.getTipoActo() == null ? new PdfPCell((Phrase)new Paragraph("  ")) : new PdfPCell((Phrase)new Paragraph(transicionIni.getTipoActo().toString(), this.valoresFont));
                            cell.setColspan(2);
                            cell.setVerticalAlignment(5);
                            table.addCell(cell);
                        }
                    }
                    if (plazoCompuesto.getTransicionesFin() != null && plazoCompuesto.getTransicionesFin().getListaDatos() != null && plazoCompuesto.getTransicionesFin().getListaDatos().size() > 0) {
                        cell = new PdfPCell((Phrase)new Paragraph("Transiciones en las que termina la cuenta para el plazo", this.transicionesFont));
                        cell.setColspan(7);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph("Tipo ", this.camposFont));
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph("Etiqueta ", this.camposFont));
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph("Descripci\u00f3n ", this.camposFont));
                        cell.setColspan(3);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph("Tipo de acto ", this.camposFont));
                        cell.setColspan(2);
                        table.addCell(cell);
                        ArrayList listaTransicionesFin = plazoCompuesto.getTransicionesFin().getListaDatos();
                        for (int k = 0; k < listaTransicionesFin.size(); ++k) {
                            TrTransicion transicionFin = (TrTransicion)listaTransicionesFin.get(k);
                            if (transicionFin == null) continue;
                            if (transicionFin.getTIPO() == null) {
                                cell = new PdfPCell((Phrase)new Paragraph(" "));
                            } else if (transicionFin.getTIPO().equals("")) {
                                cell = new PdfPCell((Phrase)new Paragraph(" "));
                            } else {
                                if (transicionFin.getTIPO().equals("N")) {
                                    cell = new PdfPCell(this.transN);
                                }
                                if (transicionFin.getTIPO().equals("D")) {
                                    cell = new PdfPCell(this.transD);
                                }
                                if (transicionFin.getTIPO().equals("U")) {
                                    cell = new PdfPCell(this.transU);
                                }
                                if (transicionFin.getTIPO().equals("ES")) {
                                    cell = new PdfPCell(this.transES);
                                }
                                if (transicionFin.getTIPO().equals("EN")) {
                                    cell = new PdfPCell(this.transEN);
                                }
                                if (transicionFin.getTIPO().equals("I")) {
                                    cell = new PdfPCell(this.transI);
                                }
                                if (transicionFin.getTIPO().equals("F")) {
                                    cell = new PdfPCell(this.transF);
                                }
                            }
                            cell.setColspan(1);
                            cell.setMinimumHeight(25.0f);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            table.addCell(cell);
                            cell = transicionFin.getETIQUETA() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (transicionFin.getETIQUETA().equals("") ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(transicionFin.getETIQUETA(), this.valoresFont)));
                            cell.setColspan(1);
                            cell.setVerticalAlignment(5);
                            table.addCell(cell);
                            cell = transicionFin.getDESCRIPCION() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (transicionFin.getDESCRIPCION().equals("") ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(transicionFin.getDESCRIPCION(), this.valoresFont)));
                            cell.setColspan(3);
                            cell.setVerticalAlignment(5);
                            table.addCell(cell);
                            if (transicionFin.getTipoActo() == null) {
                                cell = new PdfPCell((Phrase)new Paragraph(" "));
                            } else {
                                cell = new PdfPCell((Phrase)new Paragraph(transicionFin.getTipoActo().toString(), this.valoresFont));
                                cell.setVerticalAlignment(5);
                            }
                            cell.setColspan(2);
                            table.addCell(cell);
                        }
                    }
                }
                cell = new PdfPCell((Phrase)new Paragraph(" "));
                cell.setBorder(0);
                table.addCell(cell);
                table.addCell(cell);
                table.addCell(cell);
                table.addCell(cell);
                table.addCell(cell);
                table.addCell(cell);
                table.addCell(cell);
            }
        }
        return table;
    }

    private String seleccionarRutaInforme() {
        String strRuta = null;
        JFileChooser fileDlg = new JFileChooser(ModelaConf.getRutaArchivo());
        fileDlg.setFileSelectionMode(0);
        FileFilterEx filter = new FileFilterEx("pdf");
        filter.setDescription("Archivos pdf");
        fileDlg.addChoosableFileFilter(filter);
        int nRet = fileDlg.showSaveDialog(null);
        if (nRet == 0) {
            ValidarNombreFichero validaFichero;
            String strNombreFichero;
            File fich = fileDlg.getSelectedFile();
            strRuta = fich.getPath();
            if (!strRuta.endsWith(".pdf")) {
                strRuta = strRuta + ".pdf";
            }
            if (!(strNombreFichero = fich.getName()).endsWith(".pdf")) {
                strNombreFichero = strNombreFichero + ".pdf";
            }
            if (!(validaFichero = new ValidarNombreFichero()).validaNombreFichero(strNombreFichero)) {
                return null;
            }
        }
        ModelaConf.setRutaArchivo(fileDlg.getCurrentDirectory().getPath());
        ModelaConf.salvar();
        return strRuta;
    }

    public void onEndPage(PdfWriter writer, Document document) {
        try {
            Rectangle page = document.getPageSize();
            PdfPTable head = new PdfPTable(3);
            for (int k = 1; k <= 6; ++k) {
                head.addCell("head " + k);
            }
            head.setTotalWidth(page.getWidth() - document.leftMargin() - document.rightMargin());
            head.writeSelectedRows(0, -1, document.leftMargin(), page.getHeight() - document.topMargin() + head.getTotalHeight(), writer.getDirectContent());
            PdfPTable foot = new PdfPTable(3);
            for (int k = 1; k <= 6; ++k) {
                foot.addCell("foot " + k);
            }
            foot.setTotalWidth(page.getWidth() - document.leftMargin() - document.rightMargin());
            foot.writeSelectedRows(0, -1, document.leftMargin(), document.bottomMargin(), writer.getDirectContent());
        }
        catch (Exception e) {
            System.out.println("- [ Error ] Final de p\u00e1gina inesperado en documento: \n");
            e.printStackTrace();
        }
    }

    private PdfPTable rellenarOrganismosProc() {
        if (this.m_grafico.getDDP() == null || this.m_grafico.getDDP().getTIPOEVOL() == null || this.m_grafico.getDDP().getTIPOEVOL().getOrganismosProcedimientoInvolucrados() == null || this.m_grafico.getDDP().getTIPOEVOL().getOrganismosProcedimientoInvolucrados().getListaDatos() == null || this.m_grafico.getDDP().getTIPOEVOL().getOrganismosProcedimientoInvolucrados().getListaDatos().size() <= 0) {
            return null;
        }
        PdfPTable table = null;
        ArrayList listaOrganismos = this.m_grafico.getDDP().getTIPOEVOL().getOrganismosProcedimientoInvolucrados().getListaDatos();
        if (listaOrganismos.size() > 0) {
            table = new PdfPTable(4);
            for (int i = 0; i < listaOrganismos.size(); ++i) {
                table.addCell((Phrase)new Paragraph("Nombre", this.camposFont));
                table.addCell((Phrase)new Paragraph("Tipo asociaci\u00f3n", this.camposFont));
                table.addCell((Phrase)new Paragraph("Observaciones", this.camposFont));
                table.addCell((Phrase)new Paragraph("Periodo de vigencia", this.camposFont));
                TrOrganismoProc organismoProc = (TrOrganismoProc)listaOrganismos.get(i);
                if (organismoProc == null) continue;
                table.addCell((Phrase)new Paragraph(organismoProc.getOrganismoAsociado().getNombre(), this.valoresFont));
                table.addCell((Phrase)new Paragraph(organismoProc.getTipoAsociacion(), this.valoresFont));
                if (organismoProc.getObservaciones() == null) {
                    table.addCell(" ");
                } else if (organismoProc.getObservaciones().equals("")) {
                    table.addCell(" ");
                } else {
                    table.addCell((Phrase)new Paragraph(organismoProc.getObservaciones(), this.valoresFont));
                }
                SimpleDateFormat formatoDeFecha = new SimpleDateFormat("dd/MM/yyyy");
                String fechaIni = formatoDeFecha.format(organismoProc.getFechaInicioVigencia());
                String fechaFin = "";
                if (organismoProc.getFechaFinVigencia() != null) {
                    fechaFin = formatoDeFecha.format(organismoProc.getFechaFinVigencia());
                }
                table.addCell((Phrase)new Paragraph(fechaIni + " - " + fechaFin, this.valoresFont));
                PdfPCell cell = new PdfPCell((Phrase)new Paragraph(" "));
                cell.setBorder(0);
                table.addCell(cell);
                table.addCell(cell);
                table.addCell(cell);
                table.addCell(cell);
            }
        }
        float[] sizesC = new float[]{25.0f, 20.0f, 30.0f, 25.0f};
        try {
            if (table != null) {
                table.setWidths(sizesC);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return table;
    }
}

