/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.piccolo;

import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PActivityScheduler;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.event.PSelectionEventHandler;
import gdtel.bd.ConjuntoDatos;
import gdtel.ui.piccolo.AccionPCanvas;
import gdtel.ui.piccolo.PCanvasEx;
import gdtel.ui.piccolo.activities.PParpadeoActivity;
import gdtel.ui.swing.PropiedadesJDialog;
import gdtel.util.GeneradorID;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import modela.bd.ConjuntoDatosModela;
import modela.bd.obj.ConjuntoDatosFase;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrFaseGr;
import modela.bd.obj.TrMetafase;
import modela.bd.obj.TrNodoGr;
import modela.bd.obj.TrTransicion;
import modela.bd.obj.TrTransicionDefProcedimiento;
import modela.bd.obj.TrTransicionGr;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.graf.ModificaTransiciones;
import modela.graf.Referencia;
import modela.ui.ModelaUI;
import modela.ui.piccolo.AccionPCanvasModela;
import modela.ui.piccolo.events.GraficoEliminadoEvent;
import modela.ui.piccolo.events.GraficoEliminadoListener;
import modela.ui.piccolo.events.GraficoGeneradoDisponibleEvent;
import modela.ui.piccolo.events.GraficoGeneradoDisponibleListener;
import modela.ui.piccolo.events.GraficoGeneradoEvent;
import modela.ui.piccolo.events.GraficoGeneradoListener;
import modela.ui.piccolo.events.GraficoModificadoEvent;
import modela.ui.piccolo.events.GraficoModificadoListener;
import modela.ui.piccolo.events.GraficoObtenidoDisponibleEvent;
import modela.ui.piccolo.events.GraficoObtenidoDisponibleListener;
import modela.ui.piccolo.events.GraficoObtenidoEvent;
import modela.ui.piccolo.events.GraficoObtenidoListener;
import modela.ui.piccolo.handlers.EventoCreationEventHandler;
import modela.ui.piccolo.handlers.FaseCreationEventHandler;
import modela.ui.piccolo.handlers.FinProcedimientoCreationEventHandler;
import modela.ui.piccolo.handlers.PObtenerGraficoEventHandler;
import modela.ui.piccolo.handlers.PSelectionEventHandlerEx;
import modela.ui.piccolo.handlers.PostItCreationEventHandler;
import modela.ui.piccolo.handlers.TransicionCreationEventHandler;
import modela.ui.piccolo.handlers.TransicionDivisionCreationEventHandler;
import modela.ui.piccolo.handlers.TransicionUnionCreationEventHandler;
import modela.ui.piccolo.nodes.CreadorExtremoTransicion;
import modela.ui.piccolo.nodes.DivisionPNode;
import modela.ui.piccolo.nodes.EventoSalidaPNode;
import modela.ui.piccolo.nodes.EventoSinSalidaPNode;
import modela.ui.piccolo.nodes.FasePNode;
import modela.ui.piccolo.nodes.FinPNode;
import modela.ui.piccolo.nodes.ImagenPNode;
import modela.ui.piccolo.nodes.InicioPNode;
import modela.ui.piccolo.nodes.PNodoGrafico;
import modela.ui.piccolo.nodes.PToolTipText;
import modela.ui.piccolo.nodes.PostItPNode;
import modela.ui.piccolo.nodes.RepGraficaNodo;
import modela.ui.piccolo.nodes.TransicionPNode;
import modela.ui.piccolo.nodes.UnionPNode;
import modela.ui.swing.EliminarGraficoFaseJDialog;
import modela.ui.swing.EliminarGraficoTransicionJDialog;
import modela.ui.swing.MantenimientoAccionTransicionJDialog;
import modela.ui.swing.MantenimientoAvisoTransicionJDialog;
import modela.ui.swing.MantenimientoCondicionTransicionJDialog;
import modela.ui.swing.MantenimientoPerfilTransicionJDialog;
import modela.ui.swing.MantenimientoPlazoSimpleJDialog;
import modela.ui.swing.MantenimientoTareaEnFaseDefProcJDialog;
import modela.ui.swing.MantenimientoTareaEnFaseJDialog;
import modela.ui.swing.PropTransicionJPanel;

public class PCanvasModela
extends PCanvasEx {
    private static final long serialVersionUID = -3168539317610646822L;
    public final int EFECTO_COLOR_FIJO = 1;
    public final int EFECTO_PARPADEO = 2;
    public static final int VISTA_EXTENSION_TOTAL = 1;
    public static final int VISTA_ZOOM_OBJETO = 2;
    public static final int VISTA_ZOOM_OBJETO_BIS = 3;
    public static final int VISTA_PRESERVAR_EXTENSION = 4;
    protected AccionPCanvas nAccion;
    protected TransicionCreationEventHandler transEvent;
    protected TransicionDivisionCreationEventHandler transEventDivision;
    protected TransicionUnionCreationEventHandler transEventUnion;
    protected EventoCreationEventHandler transEventEvento;
    protected FinProcedimientoCreationEventHandler transEventFin;
    protected FaseCreationEventHandler crearGrFaseEvent;
    protected PostItCreationEventHandler crearPostItEvent;
    protected PObtenerGraficoEventHandler obtenerGrEvent;
    protected DDPGrafico diagrama = null;
    protected ModificaTransiciones modificaTransiciones = null;
    protected static TrTransicion transiDivTmp = null;
    public final long ANCHO_GRAFICO_FASE = 100L;
    public final long ALTO_GRAFICO_FASE = 30L;
    public final long ANCHO_GRAFICO_ESFERAS = 50L;
    public final long ALTO_GRAFICO_ESFERAS = 50L;
    public final long DISTANCIA_VERTICAL_ENTRE_GRAFICOS = 100L;
    public final long DISTANCIA_HORIZONTAL_ENTRE_GRAFICOS = 200L;
    boolean bInicializarCoordenadas = false;
    long posXActual;
    long posYActual;
    private TrTransicionGr transicionGrActivo = null;
    private TransicionPNode pNodoTr = null;
    private TrNodoGr nodoIniTransi = null;
    private TrNodoGr nodoFinTransi = null;
    protected Graphics graphBuffer = null;
    protected Image imgBuff = null;
    private final transient ArrayList graficoGeneradoDisponibleListeners = new ArrayList(2);
    private final transient ArrayList graficoEliminadoListeners = new ArrayList(2);
    private final transient ArrayList graficoModificadoListeners = new ArrayList(2);
    private final transient ArrayList graficoObtenidoDisponibleListeners = new ArrayList(2);
    private boolean bPrimeraVisualizacion = true;
    private boolean bImprimiendo = false;
    public static final int ALINEAR_IZQUIERDA = 1;
    public static final int ALINEAR_CENTRO = 2;
    public static final int ALINEAR_DERECHA = 3;
    public static final int ALINEAR_SUPERIOR = 4;
    public static final int ALINEAR_MEDIO = 5;
    public static final int ALINEAR_INFERIOR = 6;
    public static final int IGUALAR_ANCHO = 1;
    public static final int IGUALAR_ALTO = 2;
    public static final int IGUALAR_AMBOS = 3;
    private final int NO_SUCH_PAGE = 1;
    private final int PAGE_EXISTS = 0;

    public PCanvasModela() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.inicializarCanvas();
        if (this.imgBuff != null) {
            this.graphBuffer = this.imgBuff.getGraphics();
        }
    }

    public void inicializarCanvas() {
        this.diagrama = null;
        this.modificaTransiciones = new ModificaTransiciones();
        this.modificaTransiciones.setCanvas(this);
        this.nAccion = AccionPCanvas.SIN_ACCION;
        this.removeInputEventListener((PInputEventListener)this.getPanEventHandler());
        this.removeInputEventListener((PInputEventListener)this.getZoomEventHandler());
        for (int n = 0; n < this.getKeyListeners().length; ++n) {
            this.removeKeyListener(this.getKeyListeners()[n]);
        }
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    PCanvasModela.this.eliminarPostItSeleccionados();
                    PCanvasModela.this.eliminarFasesSeleccionadas();
                    PCanvasModela.this.eliminarTransicionesSeleccionadas();
                    PCanvasModela.this.eliminarToolTipsSeleccionados();
                } else if (e.getKeyCode() == 10) {
                    PCanvasModela.this.propiedadesGraficosSelec(1);
                    PCanvasModela.this.propiedadesGraficosSelec(2);
                }
            }
        });
        this.transEvent = null;
        this.transEventDivision = null;
        this.transEventUnion = null;
        this.transEventEvento = null;
        this.transEventFin = null;
        this.crearGrFaseEvent = null;
        this.crearPostItEvent = null;
        this.obtenerGrEvent = null;
        this.controlarEvent(this.nAccion);
        this.bInicializarCoordenadas = true;
        this.bPrimeraVisualizacion = true;
        this.bImprimiendo = false;
        this.getCamera().setTransparency(0.5f);
    }

    public PBounds getClipActual() {
        if (this.getCamera() == null) {
            return null;
        }
        PBounds boundsTotal = this.getCamera().getUnionOfLayerFullBounds();
        return boundsTotal;
    }

    public AccionPCanvas getAccionActual() {
        return this.nAccion;
    }

    public boolean controlarEvent(AccionPCanvas pAccion) {
        this.nAccion = pAccion;
        if (this.getCamera().getLayerCount() > 2) {
            this.getCamera().removeLayer(this.getCamera().getLayerCount() - 1);
        }
        if (this.transEvent != null) {
            this.removeInputEventListener((PInputEventListener)this.transEvent);
            this.transEvent.unselectAll();
            this.transEvent = null;
        }
        if (this.transEventDivision != null) {
            this.removeInputEventListener((PInputEventListener)this.transEventDivision);
            this.transEventDivision.unselectAll();
            this.transEventDivision = null;
        }
        if (this.transEventUnion != null) {
            this.removeInputEventListener((PInputEventListener)this.transEventUnion);
            this.transEventUnion.unselectAll();
            this.transEventUnion = null;
        }
        if (this.transEventEvento != null) {
            this.removeInputEventListener((PInputEventListener)this.transEventEvento);
            this.transEventEvento.unselectAll();
            this.transEventEvento = null;
        }
        if (this.crearGrFaseEvent != null) {
            this.removeInputEventListener((PInputEventListener)this.crearGrFaseEvent);
            this.crearGrFaseEvent.unselectAll();
            this.crearGrFaseEvent = null;
        }
        if (this.crearPostItEvent != null) {
            this.removeInputEventListener((PInputEventListener)this.crearPostItEvent);
            this.crearPostItEvent.unselectAll();
            this.crearPostItEvent = null;
        }
        if (this.transEventFin != null) {
            this.removeInputEventListener((PInputEventListener)this.transEventFin);
            this.transEventFin.unselectAll();
            this.transEventFin = null;
        }
        if (this.obtenerGrEvent != null) {
            this.removeInputEventListener((PInputEventListener)this.obtenerGrEvent);
            this.obtenerGrEvent = null;
            if (this.getModificaTransiciones() != null && (this.getModificaTransiciones().isModificandoFaseInicial() || this.getModificaTransiciones().isModificandoFaseFinal())) {
                this.getModificaTransiciones().setModificandoFaseFinal(false);
                this.getModificaTransiciones().setModificandoFaseInicial(false);
            }
        }
        if (super.controlarEvent(pAccion)) {
            return true;
        }
        if (pAccion == AccionPCanvasModela.ACCION_FASE || pAccion == AccionPCanvasModela.ACCION_SELEC_TRANSICION) {
            return true;
        }
        if (pAccion == AccionPCanvasModela.ACCION_CREAR_FASES) {
            this.crearGrFaseEvent = new FaseCreationEventHandler((PNode)this.getLayer(), (PNode)this.getLayer(), this);
            this.crearGrFaseEvent.addGraficoGeneradoListener(new GraficoGeneradoListener(){

                public void obtenerGraficoGenerado(GraficoGeneradoEvent evt) {
                    PCanvasModela.this.graficoGenerado(evt);
                }
            });
            this.getCamera().addInputEventListener((PInputEventListener)this.crearGrFaseEvent);
            return true;
        }
        if (pAccion == AccionPCanvasModela.ACCION_CREAR_POST_IT) {
            this.crearPostItEvent = new PostItCreationEventHandler((PNode)this.getLayer(), (PNode)this.getLayer(), this);
            this.crearPostItEvent.addGraficoGeneradoListener(new GraficoGeneradoListener(){

                public void obtenerGraficoGenerado(GraficoGeneradoEvent evt) {
                    PCanvasModela.this.graficoGenerado(evt);
                }
            });
            this.getCamera().addInputEventListener((PInputEventListener)this.crearPostItEvent);
            return true;
        }
        if (pAccion == AccionPCanvasModela.ACCION_TRANSICION) {
            this.transEvent = new TransicionCreationEventHandler((PNode)this.getLayer(), (PNode)this.getLayer(), this);
            this.transEvent.addGraficoGeneradoListener(new GraficoGeneradoListener(){

                public void obtenerGraficoGenerado(GraficoGeneradoEvent evt) {
                    PCanvasModela.this.graficoGenerado(evt);
                }
            });
            this.getCamera().addInputEventListener((PInputEventListener)this.transEvent);
            return true;
        }
        if (pAccion == AccionPCanvasModela.ACCION_TRANSICION_UNION) {
            this.transEventUnion = new TransicionUnionCreationEventHandler((PNode)this.getLayer(), (PNode)this.getLayer(), this);
            this.transEventUnion.addGraficoGeneradoListener(new GraficoGeneradoListener(){

                public void obtenerGraficoGenerado(GraficoGeneradoEvent evt) {
                    PCanvasModela.this.graficoGenerado(evt);
                }
            });
            this.getCamera().addInputEventListener((PInputEventListener)this.transEventUnion);
            return true;
        }
        if (pAccion == AccionPCanvasModela.ACCION_TRANSICION_DIVISION) {
            this.transEventDivision = new TransicionDivisionCreationEventHandler((PNode)this.getLayer(), (PNode)this.getLayer(), this);
            this.transEventDivision.addGraficoGeneradoListener(new GraficoGeneradoListener(){

                public void obtenerGraficoGenerado(GraficoGeneradoEvent evt) {
                    PCanvasModela.this.graficoGenerado(evt);
                }
            });
            this.getCamera().addInputEventListener((PInputEventListener)this.transEventDivision);
            return true;
        }
        if (pAccion == AccionPCanvasModela.ACCION_EVENTO_SALIDA) {
            this.transEventEvento = new EventoCreationEventHandler(1, (PNode)this.getLayer(), (PNode)this.getLayer(), this);
            this.transEventEvento.addGraficoGeneradoListener(new GraficoGeneradoListener(){

                public void obtenerGraficoGenerado(GraficoGeneradoEvent evt) {
                    PCanvasModela.this.graficoGenerado(evt);
                }
            });
            this.getCamera().addInputEventListener((PInputEventListener)this.transEventEvento);
            return true;
        }
        if (pAccion == AccionPCanvasModela.ACCION_EVENTO_SIN_SALIDA) {
            this.transEventEvento = new EventoCreationEventHandler(2, (PNode)this.getLayer(), (PNode)this.getLayer(), this);
            this.transEventEvento.addGraficoGeneradoListener(new GraficoGeneradoListener(){

                public void obtenerGraficoGenerado(GraficoGeneradoEvent evt) {
                    PCanvasModela.this.graficoGenerado(evt);
                }
            });
            this.getCamera().addInputEventListener((PInputEventListener)this.transEventEvento);
            return true;
        }
        if (pAccion == AccionPCanvasModela.ACCION_EVENTO_INICIO) {
            this.transEventEvento = new EventoCreationEventHandler(3, (PNode)this.getLayer(), (PNode)this.getLayer(), this);
            this.transEventEvento.addGraficoGeneradoListener(new GraficoGeneradoListener(){

                public void obtenerGraficoGenerado(GraficoGeneradoEvent evt) {
                    PCanvasModela.this.graficoGenerado(evt);
                }
            });
            this.getCamera().addInputEventListener((PInputEventListener)this.transEventEvento);
            return true;
        }
        if (pAccion == AccionPCanvasModela.ACCION_EVENTO_FIN) {
            this.transEventFin = new FinProcedimientoCreationEventHandler((PNode)this.getLayer(), (PNode)this.getLayer(), this);
            this.transEventFin.addGraficoGeneradoListener(new GraficoGeneradoListener(){

                public void obtenerGraficoGenerado(GraficoGeneradoEvent evt) {
                    PCanvasModela.this.graficoGenerado(evt);
                }
            });
            this.getCamera().addInputEventListener((PInputEventListener)this.transEventFin);
            return true;
        }
        if (pAccion == AccionPCanvas.ACCION_OBTENER_GRAFICO) {
            this.obtenerGrEvent = new PObtenerGraficoEventHandler((PNode)this.getLayer(), (PNode)this.getLayer());
            this.obtenerGrEvent.addGraficoObtenidoListener(new GraficoObtenidoListener(){

                public void obtenerGraficoObtenido(GraficoObtenidoEvent evt) {
                    PCanvasModela.this.graficoObtenido(evt);
                }
            });
            this.addInputEventListener((PInputEventListener)this.obtenerGrEvent);
        }
        return false;
    }

    public void graficoGenerado(GraficoGeneradoEvent e) {
        boolean bAddTransi = true;
        boolean bVerDialog = true;
        if (e.getGraficoGenerado() instanceof TransicionPNode) {
            TransicionPNode tNode = (TransicionPNode)e.getGraficoGenerado();
            if (tNode.getTrTransicion().getTIPO() == "U") {
                if (tNode.getTrTransicion().getTrFaseIni() == null) {
                    tNode.setTrTransicion(null);
                    bAddTransi = false;
                    bVerDialog = false;
                }
            } else if (tNode.getTrTransicion().getTIPO() == "D") {
                if (tNode.getTrTransicion().getFaseFin() == null && tNode.getTrTransicion().getTrFaseIni() != null) {
                    bAddTransi = true;
                    bVerDialog = true;
                }
            } else if (tNode.getTrTransicion().getTIPO() == "N" && tNode.getPNodoGraficoFaseIni() instanceof DivisionPNode && tNode.getTrTransicion().getFaseFin() != null && tNode.getTrTransicion().getTrFaseIni() == null) {
                bAddTransi = false;
                bVerDialog = false;
                TransicionPNode transiDeDiv = null;
                if (tNode.getPNodoGraficoFaseIni() != null && tNode.getPNodoGraficoFaseIni().getTrFaseGrAsociada() != null) {
                    transiDeDiv = this.localizarGraficoTransicion(tNode.getPNodoGraficoFaseIni().getTrFaseGrAsociada().getID());
                }
                if (transiDeDiv != null && transiDeDiv.getTrTransicion() != null) {
                    ArrayList graficosUsados;
                    transiDivTmp = transiDeDiv.getTrTransicion();
                    if (transiDivTmp.getConjuntoFasesFin() != null && transiDivTmp.getConjuntoFasesFin().getListaDatos() != null) {
                        for (int n = 0; n < transiDivTmp.getConjuntoFasesFin().getListaDatos().size(); ++n) {
                            if (((TrFase)transiDivTmp.getConjuntoFasesFin().getListaDatos().get(n)).getFASEID().longValue() != tNode.getTrTransicion().getFaseFin().getFASEID().longValue()) continue;
                            JOptionPane.showMessageDialog((Component)((Object)this), "La fase de destino ya pertenece al conjunto de fases fin de la transici\u00f3n de divisi\u00f3n.", "Atenci\u00f3n", 2);
                            tNode = null;
                            transiDivTmp = null;
                            return;
                        }
                    }
                    if ((graficosUsados = this.localizarGraficosTransicion(transiDivTmp)) != null && graficosUsados.size() > 1) {
                        JOptionPane.showMessageDialog((Component)((Object)this), "No se pueden a\u00f1adir ramificaciones a una transici\u00f3n de divisi\u00f3n involucrada en m\u00e1s de un diagrama.", "Atenci\u00f3n", 2);
                        tNode = null;
                        transiDivTmp = null;
                        return;
                    }
                    transiDivTmp.addFaseFin(tNode.getTrTransicion().getFaseFin());
                    transiDivTmp.setTrFaseFin(tNode.getTrTransicion().getFaseFin());
                }
                tNode.setTrTransicion(transiDivTmp);
            }
            if (bVerDialog && !this.insertarDatosTransicion(tNode)) {
                return;
            }
            tNode.notificarCreacionAExtremos();
            if (bAddTransi) {
                this.diagrama.getTransicionesInvolucradas().add(tNode.getTrTransicion());
            }
            switch (e.getTipo()) {
                case 2: {
                    this.getLayer().addChild((PNode)tNode);
                    break;
                }
                case 3: {
                    this.getLayer().addChild((PNode)tNode.getPNodoGraficoFaseFin());
                    this.getLayer().addChild((PNode)tNode);
                    break;
                }
                case 4: {
                    this.getLayer().addChild((PNode)tNode.getPNodoGraficoFaseIni());
                    this.getLayer().addChild((PNode)tNode);
                    break;
                }
                case 5: {
                    this.getLayer().addChild((PNode)tNode.getPNodoGraficoFaseIni());
                    this.getLayer().addChild((PNode)tNode);
                    break;
                }
                case 6: {
                    this.getLayer().addChild((PNode)tNode.getPNodoGraficoFaseIni());
                    this.getLayer().addChild((PNode)tNode);
                    break;
                }
                case 7: {
                    this.getLayer().addChild((PNode)tNode.getPNodoGraficoFaseIni());
                    this.getLayer().addChild((PNode)tNode);
                    break;
                }
                case 8: {
                    this.getLayer().addChild((PNode)tNode.getPNodoGraficoFaseFin());
                    this.getLayer().addChild((PNode)tNode);
                }
            }
            tNode.readaptarBounds();
            if (tNode.getTrTransicion() != null) {
                this.diagrama.getTransicionesDelProcInvolucradas().add(tNode.getTrTransicion());
            }
        } else if (e.getGraficoGenerado() instanceof FasePNode) {
            FasePNode fNode = (FasePNode)e.getGraficoGenerado();
            this.getLayer().addChild((PNode)fNode);
        } else if (e.getGraficoGenerado() instanceof PostItPNode) {
            PostItPNode postIt = (PostItPNode)e.getGraficoGenerado();
            this.getLayer().addChild((PNode)postIt);
            postIt.editarTextoPostIt();
        }
        this.repaint();
        this.fireObtenerGraficoGeneradoDisponible(new GraficoGeneradoDisponibleEvent(e.getGraficoGenerado(), e.getTipo()));
    }

    public void graficoModificado(PNode nodoModificado) {
        if (nodoModificado == null) {
            return;
        }
        if (nodoModificado instanceof TransicionPNode) {
            this.fireObtenerGraficoModificado(new GraficoModificadoEvent(nodoModificado, 2));
        } else if (nodoModificado instanceof FasePNode) {
            this.fireObtenerGraficoModificado(new GraficoModificadoEvent(nodoModificado, 1));
        } else if (nodoModificado instanceof PostItPNode) {
            this.fireObtenerGraficoModificado(new GraficoModificadoEvent(nodoModificado, 9));
        }
    }

    protected void graficoObtenido(GraficoObtenidoEvent e) {
        if (e == null) {
            return;
        }
        if (e.getGraficoObtenido() == null) {
            return;
        }
        this.fireObtenerGraficoObtenidoDisponible(new GraficoObtenidoDisponibleEvent(e.getGraficoObtenido()));
    }

    public boolean insertarDatosTransicion(TransicionPNode tNode) {
        if (tNode == null) {
            return false;
        }
        if (tNode.getTrTransicion() == null) {
            return false;
        }
        if (!ModelaConf.isCreacionRapidaTransiciones()) {
            PropTransicionJPanel propTr = new PropTransicionJPanel(true);
            propTr.setDesdeGrafico(true);
            propTr.setGrafico(this.diagrama);
            propTr.setTiposActoInvolucrados(this.getDiagrama().getTiposActoInvolucrados());
            PropiedadesJDialog propDlg = new PropiedadesJDialog(propTr, 2);
            propDlg.setValoresAsignables(tNode.getTrTransicion());
            propDlg.setTitle("Propiedades de la transici\u00f3n");
            propDlg.setSize(610, 460);
            propDlg.setLocationRelativeTo((Component)((Object)this));
            propDlg.setVisible(true);
            if (propDlg.seAplica()) {
                if (this.diagrama.getTransicionesInvolucradas().existeElemento(tNode.getTrTransicion(), true) != null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Imposible crear la transici\u00f3n:\nYa existe una transici\u00f3n con id\u00e9nticas caracter\u00edsticas.", "Atenci\u00f3n", 2);
                    return false;
                }
                return true;
            }
        } else {
            int identificadorTransicion = 1;
            String nombreTransicion = "Trans. " + tNode.getTrTransicion().getTIPO() + " " + String.valueOf(identificadorTransicion);
            tNode.getTrTransicion().setETIQUETA(nombreTransicion);
            while (this.diagrama.getTransicionesInvolucradas().existeElemento(tNode.getTrTransicion(), true) != null) {
                nombreTransicion = "Trans. " + tNode.getTrTransicion().getTIPO() + " " + String.valueOf(++identificadorTransicion);
                tNode.getTrTransicion().setETIQUETA(nombreTransicion);
            }
            tNode.getTrTransicion().setETIQUETA(nombreTransicion);
            tNode.getTrTransicion().setDESCRIPCION("--");
            return true;
        }
        return false;
    }

    public int obtenerNumGraficos(int nTipo) {
        int nNumItems = 0;
        int nContTipo = 0;
        if (this.diagrama == null) {
            return 0;
        }
        if (this.diagrama.getDDP() == null) {
            return 0;
        }
        PLayer lyr = this.getLayer();
        if (lyr == null) {
            return 0;
        }
        nNumItems = lyr.getChildrenCount();
        if (nNumItems < 1) {
            return 0;
        }
        block11: for (int i = 0; i < nNumItems; ++i) {
            PNode nodoActual = lyr.getChild(i);
            switch (nTipo) {
                case 1: {
                    if (!(nodoActual instanceof FasePNode)) continue block11;
                    ++nContTipo;
                    continue block11;
                }
                case 2: {
                    if (!(nodoActual instanceof TransicionPNode)) continue block11;
                    ++nContTipo;
                    continue block11;
                }
                case 3: {
                    if (!(nodoActual instanceof DivisionPNode)) continue block11;
                    ++nContTipo;
                    continue block11;
                }
                case 4: {
                    if (!(nodoActual instanceof UnionPNode)) continue block11;
                    ++nContTipo;
                    continue block11;
                }
                case 5: {
                    if (!(nodoActual instanceof EventoSalidaPNode)) continue block11;
                    ++nContTipo;
                    continue block11;
                }
                case 6: {
                    if (!(nodoActual instanceof EventoSinSalidaPNode)) continue block11;
                    ++nContTipo;
                    continue block11;
                }
                case 7: {
                    if (!(nodoActual instanceof InicioPNode)) continue block11;
                    ++nContTipo;
                    continue block11;
                }
                case 8: {
                    if (!(nodoActual instanceof FinPNode)) continue block11;
                    ++nContTipo;
                    continue block11;
                }
                case 9: {
                    if (!(nodoActual instanceof PostItPNode)) continue block11;
                    ++nContTipo;
                }
            }
        }
        return nContTipo;
    }

    public PNodoGrafico localizarGraficoFase(BigDecimal extremoID) {
        if (extremoID == null) {
            return null;
        }
        if (this.getLayer() == null) {
            return null;
        }
        PLayer lyr = this.getLayer();
        for (int i = 0; i < lyr.getChildrenCount(); ++i) {
            TrFaseGr faseGr;
            PNodoGrafico pNodo;
            if (!(lyr.getChild(i) instanceof PNodoGrafico) || (pNodo = (PNodoGrafico)lyr.getChild(i)).getTrFaseGrAsociada() == null || (faseGr = pNodo.getTrFaseGrAsociada()).getID().longValue() != extremoID.longValue()) continue;
            return pNodo;
        }
        return null;
    }

    public PNodoGrafico localizarGraficoFase(TrFase faseABuscar) {
        if (faseABuscar == null) {
            return null;
        }
        if (this.getLayer() == null) {
            return null;
        }
        PLayer lyr = this.getLayer();
        for (int i = 0; i < lyr.getChildrenCount(); ++i) {
            TrFaseGr faseGr;
            PNodoGrafico pNodo;
            if (!(lyr.getChild(i) instanceof PNodoGrafico) || (pNodo = (PNodoGrafico)lyr.getChild(i)).getTrFaseGrAsociada() == null || (faseGr = pNodo.getTrFaseGrAsociada()).getTrFase() == null || faseGr.getTrFase().getFASEID().longValue() != faseABuscar.getFASEID().longValue()) continue;
            return pNodo;
        }
        return null;
    }

    public ArrayList localizarGraficosFase(TrFase faseABuscar, String tipoGrafico) {
        int c;
        if (faseABuscar == null) {
            return null;
        }
        if (this.getDiagrama() == null) {
            return null;
        }
        ArrayList<PNodoGrafico> graficosEncontrados = new ArrayList<PNodoGrafico>();
        ArrayList<PCanvasModela> listaCanvas = new ArrayList<PCanvasModela>();
        if (this.getDiagrama().getDDPPadre() == null) {
            listaCanvas.add(this.getDiagrama().getCanvas());
            for (c = 0; c < this.getDiagrama().getListaDDPs().size(); ++c) {
                listaCanvas.add(((DDPGrafico)this.getDiagrama().getListaDDPs().get(c)).getCanvas());
            }
        } else {
            listaCanvas.add(this.getDiagrama().getDDPPadre().getCanvas());
            for (c = 0; c < this.getDiagrama().getDDPPadre().getListaDDPs().size(); ++c) {
                listaCanvas.add(((DDPGrafico)this.getDiagrama().getDDPPadre().getListaDDPs().get(c)).getCanvas());
            }
        }
        PCanvasModela canvasAux = null;
        for (int nCanvas = 0; nCanvas < listaCanvas.size(); ++nCanvas) {
            canvasAux = (PCanvasModela)((Object)listaCanvas.get(nCanvas));
            if (canvasAux.getLayer() == null) continue;
            PLayer lyr = canvasAux.getLayer();
            for (int i = 0; i < lyr.getChildrenCount(); ++i) {
                TrFaseGr faseGr;
                PNodoGrafico pNodo;
                if (!(lyr.getChild(i) instanceof PNodoGrafico) || (pNodo = (PNodoGrafico)lyr.getChild(i)).getTrFaseGrAsociada() == null || (faseGr = pNodo.getTrFaseGrAsociada()).getTrFase() == null || faseGr.getTrFase().getFASEID().longValue() != faseABuscar.getFASEID().longValue() || !pNodo.getTipo().equals(tipoGrafico)) continue;
                graficosEncontrados.add(pNodo);
            }
        }
        for (int r = listaCanvas.size() - 1; r >= 0; --r) {
            listaCanvas.remove(r);
        }
        listaCanvas = null;
        return graficosEncontrados;
    }

    public ArrayList localizarGraficosFaseEnCanvasActual(TrFase faseABuscar, String tipoGrafico) {
        ArrayList<PNodoGrafico> graficosEncontrados = new ArrayList<PNodoGrafico>();
        if (faseABuscar == null) {
            return null;
        }
        if (this.getLayer() == null) {
            return null;
        }
        PLayer lyr = this.getLayer();
        for (int i = 0; i < lyr.getChildrenCount(); ++i) {
            TrFaseGr faseGr;
            PNodoGrafico pNodo;
            if (!(lyr.getChild(i) instanceof PNodoGrafico) || (pNodo = (PNodoGrafico)lyr.getChild(i)).getTrFaseGrAsociada() == null || (faseGr = pNodo.getTrFaseGrAsociada()).getTrFase() == null || faseGr.getTrFase().getFASEID().longValue() != faseABuscar.getFASEID().longValue() || !pNodo.getTipo().equals(tipoGrafico)) continue;
            graficosEncontrados.add(pNodo);
        }
        return graficosEncontrados;
    }

    public PNodoGrafico localizarGraficoFase(TrFase faseABuscar, String tipoGrafico) {
        if (faseABuscar == null) {
            return null;
        }
        if (this.getLayer() == null) {
            return null;
        }
        PLayer lyr = this.getLayer();
        for (int i = 0; i < lyr.getChildrenCount(); ++i) {
            TrFaseGr faseGr;
            PNodoGrafico pNodo;
            if (!(lyr.getChild(i) instanceof PNodoGrafico) || (pNodo = (PNodoGrafico)lyr.getChild(i)).getTrFaseGrAsociada() == null || (faseGr = pNodo.getTrFaseGrAsociada()).getTrFase() == null || faseGr.getTrFase().getFASEID().longValue() != faseABuscar.getFASEID().longValue() || !pNodo.getTipo().equals(tipoGrafico)) continue;
            return pNodo;
        }
        return null;
    }

    public ArrayList localizarGraficosTransicion(TrTransicion transiABuscar) {
        int c;
        if (transiABuscar == null) {
            return null;
        }
        if (this.getDiagrama() == null) {
            return null;
        }
        ArrayList<TransicionPNode> graficosEncontrados = new ArrayList<TransicionPNode>();
        ArrayList<PCanvasModela> listaCanvas = new ArrayList<PCanvasModela>();
        if (this.getDiagrama().getDDPPadre() == null) {
            listaCanvas.add(this.getDiagrama().getCanvas());
            for (c = 0; c < this.getDiagrama().getListaDDPs().size(); ++c) {
                listaCanvas.add(((DDPGrafico)this.getDiagrama().getListaDDPs().get(c)).getCanvas());
            }
        } else {
            listaCanvas.add(this.getDiagrama().getDDPPadre().getCanvas());
            for (c = 0; c < this.getDiagrama().getDDPPadre().getListaDDPs().size(); ++c) {
                listaCanvas.add(((DDPGrafico)this.getDiagrama().getDDPPadre().getListaDDPs().get(c)).getCanvas());
            }
        }
        PCanvasModela canvasAux = null;
        TransicionPNode grTransi = null;
        for (int nCanvas = 0; nCanvas < listaCanvas.size(); ++nCanvas) {
            canvasAux = (PCanvasModela)((Object)listaCanvas.get(nCanvas));
            grTransi = canvasAux.localizarGraficoTransicion(transiABuscar);
            if (grTransi == null) continue;
            graficosEncontrados.add(grTransi);
        }
        for (int r = listaCanvas.size() - 1; r >= 0; --r) {
            listaCanvas.remove(r);
        }
        listaCanvas = null;
        return graficosEncontrados;
    }

    public TransicionPNode localizarGraficoTransicion(TrTransicion transiABuscar) {
        if (transiABuscar == null) {
            return null;
        }
        if (this.getLayer() == null) {
            return null;
        }
        PLayer lyr = this.getLayer();
        for (int i = 0; i < lyr.getChildrenCount(); ++i) {
            TrTransicion transiGr;
            TransicionPNode transiPNode;
            if (!(lyr.getChild(i) instanceof TransicionPNode) || (transiPNode = (TransicionPNode)lyr.getChild(i)).getTrTransicion() == null || (transiGr = transiPNode.getTrTransicion()).getTRANID().longValue() != transiABuscar.getTRANID().longValue()) continue;
            return transiPNode;
        }
        return null;
    }

    public TransicionPNode localizarGraficoTransicion(BigDecimal transiID, BigDecimal extremoIniID, BigDecimal extremoFinID) {
        if (transiID == null || extremoIniID == null || extremoFinID == null) {
            return null;
        }
        if (this.getLayer() == null) {
            return null;
        }
        PLayer lyr = this.getLayer();
        for (int i = 0; i < lyr.getChildrenCount(); ++i) {
            TransicionPNode transiPNode;
            if (!(lyr.getChild(i) instanceof TransicionPNode) || (transiPNode = (TransicionPNode)lyr.getChild(i)).getTransicionGr() == null || transiPNode.getTrTransicion() == null || transiPNode.getPNodoGraficoFaseIni() == null || transiPNode.getPNodoGraficoFaseFin() == null || transiPNode.getPNodoGraficoFaseIni().getTrFaseGrAsociada() == null || transiPNode.getPNodoGraficoFaseFin() == null || transiPNode.getTrTransicion().getTRANID().longValue() != transiID.longValue() || transiPNode.getPNodoGraficoFaseIni().getTrFaseGrAsociada().getID().longValue() != extremoIniID.longValue() || transiPNode.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getID().longValue() != extremoFinID.longValue()) continue;
            return transiPNode;
        }
        return null;
    }

    public TransicionPNode localizarGraficoTransicion(BigDecimal extremoIniID, BigDecimal extremoFinID) {
        if (extremoIniID == null || extremoFinID == null) {
            return null;
        }
        if (this.getLayer() == null) {
            return null;
        }
        PLayer lyr = this.getLayer();
        for (int i = 0; i < lyr.getChildrenCount(); ++i) {
            TransicionPNode transiPNode;
            if (!(lyr.getChild(i) instanceof TransicionPNode) || (transiPNode = (TransicionPNode)lyr.getChild(i)).getTransicionGr() == null || transiPNode.getPNodoGraficoFaseIni() == null || transiPNode.getPNodoGraficoFaseFin() == null || transiPNode.getTrTransicion() != null || transiPNode.getPNodoGraficoFaseIni().getTrFaseGrAsociada().getID().longValue() != extremoIniID.longValue() || transiPNode.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getID().longValue() != extremoFinID.longValue()) continue;
            return transiPNode;
        }
        return null;
    }

    public TransicionPNode localizarGraficoTransicionFinalDeUnion(BigDecimal extremoIniID) {
        if (extremoIniID == null) {
            return null;
        }
        if (this.getLayer() == null) {
            return null;
        }
        PLayer lyr = this.getLayer();
        for (int i = 0; i < lyr.getChildrenCount(); ++i) {
            TransicionPNode transiPNode;
            if (!(lyr.getChild(i) instanceof TransicionPNode) || (transiPNode = (TransicionPNode)lyr.getChild(i)).getTransicionGr() == null || transiPNode.getPNodoGraficoFaseIni() == null || transiPNode.getPNodoGraficoFaseFin() == null || transiPNode.getTrTransicion() != null || transiPNode.getPNodoGraficoFaseIni().getTrFaseGrAsociada().getID().longValue() != extremoIniID.longValue()) continue;
            return transiPNode;
        }
        return null;
    }

    public ArrayList localizarGraficosTransicionUni(BigDecimal nodoUniID) {
        ArrayList<TransicionPNode> transiRelacionadas = new ArrayList<TransicionPNode>();
        if (nodoUniID == null) {
            return null;
        }
        if (this.getLayer() == null) {
            return null;
        }
        PLayer lyr = this.getLayer();
        for (int i = 0; i < lyr.getChildrenCount(); ++i) {
            TransicionPNode transiPNode;
            if (!(lyr.getChild(i) instanceof TransicionPNode) || !(transiPNode = (TransicionPNode)lyr.getChild(i)).getPNodoGraficoFaseFin().getTipo().equals("U") || transiPNode.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getID().longValue() != nodoUniID.longValue()) continue;
            transiRelacionadas.add(transiPNode);
        }
        return transiRelacionadas;
    }

    public ArrayList localizarGraficosTransicionRelacionados(BigDecimal nodoID, String tipoNodo) {
        ArrayList<TransicionPNode> transiRelacionadas = new ArrayList<TransicionPNode>();
        if (nodoID == null) {
            return null;
        }
        if (this.getLayer() == null) {
            return null;
        }
        PLayer lyr = this.getLayer();
        for (int i = 0; i < lyr.getChildrenCount(); ++i) {
            if (!(lyr.getChild(i) instanceof TransicionPNode)) continue;
            TransicionPNode transiPNode = (TransicionPNode)lyr.getChild(i);
            if (transiPNode.getPNodoGraficoFaseIni() != null && transiPNode.getPNodoGraficoFaseIni().getTrFaseGrAsociada() != null && transiPNode.getPNodoGraficoFaseIni().getTrFaseGrAsociada().getID().longValue() == nodoID.longValue() && transiPNode.getPNodoGraficoFaseIni().getTipo().equals(tipoNodo)) {
                transiRelacionadas.add(transiPNode);
            }
            if (transiPNode.getPNodoGraficoFaseFin() == null || transiPNode.getPNodoGraficoFaseFin().getTrFaseGrAsociada() == null || transiPNode.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getID().longValue() != nodoID.longValue() || !transiPNode.getPNodoGraficoFaseFin().getTipo().equals(tipoNodo)) continue;
            transiRelacionadas.add(transiPNode);
        }
        return transiRelacionadas;
    }

    public TransicionPNode localizarGraficoTransicion(BigDecimal extremoFinID) {
        if (extremoFinID == null) {
            return null;
        }
        if (this.getLayer() == null) {
            return null;
        }
        PLayer lyr = this.getLayer();
        for (int i = 0; i < lyr.getChildrenCount(); ++i) {
            PNodoGrafico extremoGrFinal;
            TransicionPNode transiPNode;
            if (!(lyr.getChild(i) instanceof TransicionPNode) || (transiPNode = (TransicionPNode)lyr.getChild(i)).getPNodoGraficoFaseFin() == null || (extremoGrFinal = transiPNode.getPNodoGraficoFaseFin()).getTrFaseGrAsociada() == null || extremoGrFinal.getTrFaseGrAsociada().getID().longValue() != extremoFinID.longValue()) continue;
            return transiPNode;
        }
        return null;
    }

    public TransicionPNode localizarGraficoTransicionDivPrincipal(TransicionPNode transicionRamificada) {
        ArrayList arrTrDiv;
        TransicionPNode grTrAux = null;
        if (transicionRamificada.getPNodoGraficoFaseIni() != null && transicionRamificada.getPNodoGraficoFaseIni().getTrFaseGrAsociada() != null && (arrTrDiv = this.localizarGraficosTransicionRelacionados(transicionRamificada.getPNodoGraficoFaseIni().getTrFaseGrAsociada().getID(), "D")) != null) {
            for (int n = 0; n < arrTrDiv.size(); ++n) {
                grTrAux = (TransicionPNode)arrTrDiv.get(n);
                if (grTrAux.getPNodoGraficoFaseIni() == null || grTrAux.getPNodoGraficoFaseIni() instanceof DivisionPNode) continue;
                return grTrAux;
            }
        }
        return grTrAux;
    }

    public void limpiarDiagrama() {
        if (this.diagrama != null) {
            super.limpiarDiagrama();
            this.getLayer().removeAllChildren();
            this.diagrama.limpiar();
            this.diagrama = null;
            this.inicializarCoordenadas();
        }
    }

    public boolean asignarColorGrafico(Color pColor) {
        if (this.getLayer() == null) {
            return false;
        }
        TransicionPNode elementoTransicion = null;
        PNodoGrafico elementoNodoGrafico = null;
        PLayer lyr = this.getLayer();
        for (int i = 0; i < lyr.getChildrenCount(); ++i) {
            if (lyr.getChild(i) instanceof PNodoGrafico) {
                elementoNodoGrafico = (PNodoGrafico)lyr.getChild(i);
                elementoNodoGrafico.setColorFondo(pColor);
                elementoNodoGrafico.repaint();
                continue;
            }
            if (!(lyr.getChild(i) instanceof TransicionPNode)) continue;
            elementoTransicion = (TransicionPNode)lyr.getChild(i);
            elementoTransicion.setColorFondo(pColor);
            elementoTransicion.repaint();
        }
        return true;
    }

    public DDPGrafico getDiagrama() {
        return this.diagrama;
    }

    public void setDiagrama(DDPGrafico pDiagrama) {
        this.diagrama = pDiagrama;
    }

    public ModificaTransiciones getModificaTransiciones() {
        return this.modificaTransiciones;
    }

    public void setModificaTransiciones(ModificaTransiciones nuevaModificaTransiciones) {
        this.modificaTransiciones = nuevaModificaTransiciones;
    }

    public void representacionAutomatica() {
        ArrayList transicionesSinGrafico = this.obtenerTransiciones(false, true);
        if (transicionesSinGrafico == null) {
            return;
        }
        for (int n = 0; n < transicionesSinGrafico.size(); ++n) {
            this.crearGraficoTransicion((TrTransicion)transicionesSinGrafico.get(n));
        }
    }

    public ArrayList obtenerTransiciones(boolean bConGrafico, boolean bFiltrarPorDPP) {
        if (this.diagrama == null) {
            return null;
        }
        if (this.diagrama.getDDP() == null) {
            return null;
        }
        if (this.diagrama.getDDP().getTIPOEVOL() == null) {
            return null;
        }
        ConjuntoDatos todasTransiciones = new ConjuntoDatos();
        if (!bFiltrarPorDPP) {
            todasTransiciones = this.diagrama.getTransicionesInvolucradas();
        } else if (this.diagrama.getTransicionesDelProcInvolucradas() != null && this.diagrama.getTransicionesDelProcInvolucradas().getListaDatos() != null) {
            for (int ind = 0; ind < this.diagrama.getTransicionesDelProcInvolucradas().getListaDatos().size(); ++ind) {
                if (((TrTransicionDefProcedimiento)this.diagrama.getTransicionesDelProcInvolucradas().obtenerDato(ind)).getTransicion() == null) continue;
                todasTransiciones.add(((TrTransicionDefProcedimiento)this.diagrama.getTransicionesDelProcInvolucradas().obtenerDato(ind)).getTransicion());
            }
        }
        ArrayList<TrTransicion> listadoTransiSinGraf = new ArrayList<TrTransicion>();
        ArrayList<TrTransicion> listadoTransiConGraf = new ArrayList<TrTransicion>();
        for (int n = 0; n < todasTransiciones.getListaDatos().size(); ++n) {
            TrTransicion transiTmp = new TrTransicion();
            transiTmp = (TrTransicion)todasTransiciones.obtenerDato(n);
            if (this.localizarGraficoTransicion(transiTmp) == null) {
                listadoTransiSinGraf.add(transiTmp);
                continue;
            }
            if (this.localizarGraficoTransicion(transiTmp) == null) continue;
            listadoTransiConGraf.add(transiTmp);
        }
        if (bConGrafico) {
            return listadoTransiConGraf;
        }
        return listadoTransiSinGraf;
    }

    public ArrayList obtenerFases(boolean bConGrafico) {
        if (this.diagrama == null) {
            return null;
        }
        ConjuntoDatosModela todasFases = this.diagrama.getFasesInvolucradas();
        ArrayList<TrFase> listadoFasesSinGraf = new ArrayList<TrFase>();
        ArrayList<TrFase> listadoFasesConGraf = new ArrayList<TrFase>();
        for (int n = 0; n < todasFases.getListaDatos().size(); ++n) {
            TrFase faseTmp = new TrFase();
            faseTmp = (TrFase)todasFases.obtenerDato(n);
            if (this.localizarGraficoFase(faseTmp) == null) {
                listadoFasesSinGraf.add(faseTmp);
                continue;
            }
            if (this.localizarGraficoFase(faseTmp) == null) continue;
            listadoFasesConGraf.add(faseTmp);
        }
        if (bConGrafico) {
            return listadoFasesConGraf;
        }
        return listadoFasesSinGraf;
    }

    public ArrayList obtenerGraficosSeleccionados(int tipoGrafico) {
        if (this.getSelectionEventHandler() == null) {
            return null;
        }
        if (!(this.getSelectionEventHandler() instanceof PSelectionEventHandler)) {
            return null;
        }
        ArrayList<Object> arrGraficosSeleccionados = null;
        Object[] graficosSelec = ((PSelectionEventHandler)this.getSelectionEventHandler()).getSelection().toArray();
        for (int n = 0; n < graficosSelec.length; ++n) {
            if (tipoGrafico == 1 && graficosSelec[n] instanceof FasePNode) {
                if (arrGraficosSeleccionados == null) {
                    arrGraficosSeleccionados = new ArrayList<Object>();
                }
                arrGraficosSeleccionados.add(graficosSelec[n]);
                continue;
            }
            if (tipoGrafico == 9 && graficosSelec[n] instanceof PostItPNode) {
                if (arrGraficosSeleccionados == null) {
                    arrGraficosSeleccionados = new ArrayList();
                }
                arrGraficosSeleccionados.add(graficosSelec[n]);
                continue;
            }
            if (tipoGrafico == 2 && graficosSelec[n] instanceof TransicionPNode) {
                if (arrGraficosSeleccionados == null) {
                    arrGraficosSeleccionados = new ArrayList();
                }
                arrGraficosSeleccionados.add(graficosSelec[n]);
                continue;
            }
            if (tipoGrafico == -1 && graficosSelec[n] instanceof PNodoGrafico) {
                if (arrGraficosSeleccionados == null) {
                    arrGraficosSeleccionados = new ArrayList();
                }
                arrGraficosSeleccionados.add(graficosSelec[n]);
                continue;
            }
            if (tipoGrafico != 10 || !(graficosSelec[n] instanceof PToolTipText)) continue;
            if (arrGraficosSeleccionados == null) {
                arrGraficosSeleccionados = new ArrayList();
            }
            arrGraficosSeleccionados.add(graficosSelec[n]);
        }
        return arrGraficosSeleccionados;
    }

    public ArrayList obtenerGraficosCircularesSeleccionados() {
        if (this.getSelectionEventHandler() == null) {
            return null;
        }
        if (!(this.getSelectionEventHandler() instanceof PSelectionEventHandler)) {
            return null;
        }
        ArrayList<Object> grCircularesSeleccionados = new ArrayList<Object>();
        Object[] graficosSelec = ((PSelectionEventHandler)this.getSelectionEventHandler()).getSelection().toArray();
        for (int n = 0; n < graficosSelec.length; ++n) {
            if (!(graficosSelec[n] instanceof InicioPNode) && !(graficosSelec[n] instanceof FinPNode) && !(graficosSelec[n] instanceof EventoSalidaPNode) && !(graficosSelec[n] instanceof EventoSinSalidaPNode) && !(graficosSelec[n] instanceof DivisionPNode) && !(graficosSelec[n] instanceof UnionPNode)) continue;
            grCircularesSeleccionados.add(graficosSelec[n]);
        }
        return grCircularesSeleccionados;
    }

    public ArrayList obtenerGraficosPostItSeleccionados() {
        if (this.getSelectionEventHandler() == null) {
            return null;
        }
        if (!(this.getSelectionEventHandler() instanceof PSelectionEventHandler)) {
            return null;
        }
        ArrayList<Object> grPostItSeleccionados = new ArrayList<Object>();
        Object[] graficosSelec = ((PSelectionEventHandler)this.getSelectionEventHandler()).getSelection().toArray();
        for (int n = 0; n < graficosSelec.length; ++n) {
            if (!(graficosSelec[n] instanceof PostItPNode)) continue;
            grPostItSeleccionados.add(graficosSelec[n]);
        }
        return grPostItSeleccionados;
    }

    public void actualizarEtiquetas() {
        PLayer lyr = this.getLayer();
        for (int i = 0; i < lyr.getChildrenCount(); ++i) {
            if (!(lyr.getChild(i) instanceof TransicionPNode)) continue;
            TransicionPNode transiPNode = (TransicionPNode)lyr.getChild(i);
            transiPNode.posicionarEtiqueta();
        }
    }

    public void actualizarIconosTr() {
        PLayer lyr = this.getLayer();
        for (int i = 0; i < lyr.getChildrenCount(); ++i) {
            if (!(lyr.getChild(i) instanceof TransicionPNode)) continue;
            TransicionPNode transiPNode = (TransicionPNode)lyr.getChild(i);
            transiPNode.posicionarIconosHijos();
        }
    }

    public void actualizarIconosFs() {
        PLayer lyr = this.getLayer();
        for (int i = 0; i < lyr.getChildrenCount(); ++i) {
            if (!(lyr.getChild(i) instanceof FasePNode)) continue;
            FasePNode fasePNode = (FasePNode)lyr.getChild(i);
            fasePNode.posicionarIconosHijos();
        }
    }

    public void actualizarGraficosDeFase() {
        PLayer lyr = this.getLayer();
        for (int i = 0; i < lyr.getChildrenCount(); ++i) {
            if (!(lyr.getChild(i) instanceof FasePNode)) continue;
            FasePNode fasePNode = (FasePNode)lyr.getChild(i);
            fasePNode.repaint();
        }
    }

    public void actualizarPostIts() {
        PLayer lyr = this.getLayer();
        for (int i = 0; i < lyr.getChildrenCount(); ++i) {
            if (!(lyr.getChild(i) instanceof PostItPNode)) continue;
            PostItPNode notaPNode = (PostItPNode)lyr.getChild(i);
            notaPNode.repaint();
        }
    }

    public void actualizarToolTips() {
        PLayer lyr = this.getLayer();
        for (int i = 0; i < lyr.getChildrenCount(); ++i) {
            if (!(lyr.getChild(i) instanceof PToolTipText)) continue;
            PToolTipText notaPNode = (PToolTipText)lyr.getChild(i);
            notaPNode.repaint();
        }
    }

    public void crearGraficoTransicion(TrTransicion pTransicion) {
        if (pTransicion == null) {
            return;
        }
        if (this.localizarGraficoTransicion(pTransicion) != null) {
            return;
        }
        if (this.bInicializarCoordenadas) {
            this.inicializarCoordenadas();
            this.bInicializarCoordenadas = false;
        }
        TrFase faseAValidar = null;
        boolean seguirProceso = true;
        if (pTransicion.getTIPO().equals("N")) {
            faseAValidar = pTransicion.getTrFaseIni();
            if (faseAValidar != null && faseAValidar.getTIPOEVOL() != null && faseAValidar.getTIPOEVOL().getTIEVID().longValue() == this.getDiagrama().getDDP().getTIPOEVOL().getTIEVID().longValue()) {
                seguirProceso = false;
            }
            if (seguirProceso && (faseAValidar = pTransicion.getFaseFin()) != null && faseAValidar.getTIPOEVOL() != null && faseAValidar.getTIPOEVOL().getTIEVID().longValue() == this.getDiagrama().getDDP().getTIPOEVOL().getTIEVID().longValue()) {
                seguirProceso = false;
            }
            if (seguirProceso) {
                this.crearGraficoTransicionNormal(pTransicion);
            }
        }
        if (pTransicion.getTIPO().equals("I") || pTransicion.getTIPO().equals("EN") || pTransicion.getTIPO().equals("ES")) {
            faseAValidar = pTransicion.getFaseFin();
            if (faseAValidar != null && faseAValidar.getTIPOEVOL() != null && faseAValidar.getTIPOEVOL().getTIEVID().longValue() == this.getDiagrama().getDDP().getTIPOEVOL().getTIEVID().longValue()) {
                seguirProceso = false;
            }
            if (seguirProceso) {
                this.crearGraficoTransicionEventos(pTransicion);
            }
        }
        if (pTransicion.getTIPO().equals("F")) {
            faseAValidar = pTransicion.getTrFaseIni();
            if (faseAValidar != null && faseAValidar.getTIPOEVOL() != null && faseAValidar.getTIPOEVOL().getTIEVID().longValue() == this.getDiagrama().getDDP().getTIPOEVOL().getTIEVID().longValue()) {
                seguirProceso = false;
            }
            if (seguirProceso) {
                this.crearGraficoTransicionFin(pTransicion);
            }
        }
        if (pTransicion.getTIPO().equals("D")) {
            faseAValidar = pTransicion.getTrFaseIni();
            if (faseAValidar != null && faseAValidar.getTIPOEVOL() != null && faseAValidar.getTIPOEVOL().getTIEVID().longValue() == this.getDiagrama().getDDP().getTIPOEVOL().getTIEVID().longValue()) {
                seguirProceso = false;
            }
            if (seguirProceso && pTransicion.getConjuntoFasesFin() != null && pTransicion.getConjuntoFasesFin().getListaDatos() != null) {
                for (int t = 0; t < pTransicion.getConjuntoFasesFin().getListaDatos().size(); ++t) {
                    faseAValidar = (TrFase)pTransicion.getConjuntoFasesFin().getListaDatos().get(t);
                    if (faseAValidar == null || faseAValidar.getTIPOEVOL() == null || faseAValidar.getTIPOEVOL().getTIEVID().longValue() != this.getDiagrama().getDDP().getTIPOEVOL().getTIEVID().longValue()) continue;
                    seguirProceso = false;
                }
            }
            if (seguirProceso) {
                this.crearGraficoTransicionDiv(pTransicion);
            }
        }
        if (pTransicion.getTIPO().equals("U")) {
            faseAValidar = pTransicion.getTrFaseIni();
            if (faseAValidar != null && faseAValidar.getTIPOEVOL() != null && faseAValidar.getTIPOEVOL().getTIEVID().longValue() == this.getDiagrama().getDDP().getTIPOEVOL().getTIEVID().longValue()) {
                seguirProceso = false;
            }
            if (seguirProceso && (faseAValidar = pTransicion.getFaseFin()) != null && faseAValidar.getTIPOEVOL() != null && faseAValidar.getTIPOEVOL().getTIEVID().longValue() == this.getDiagrama().getDDP().getTIPOEVOL().getTIEVID().longValue()) {
                seguirProceso = false;
            }
            if (seguirProceso) {
                this.crearGraficoTransicionUni(pTransicion);
            }
        }
        if (this.diagrama.getTransicionesDelProcInvolucradas() != null && seguirProceso) {
            this.diagrama.getTransicionesDelProcInvolucradas().add(pTransicion);
        }
    }

    private void crearGraficoTransicionNormal(TrTransicion pTransicionN) {
        PNodoGrafico extremoFinTmp = null;
        PNodoGrafico extremoIniTmp = null;
        long xTmp = this.posXActual;
        long yTmp = this.posYActual;
        extremoIniTmp = this.localizarGraficoFase(pTransicionN.getTrFaseIni(), "FA");
        if (extremoIniTmp == null) {
            ((Object)((Object)this)).getClass();
            yTmp = this.posYActual + 100L;
            while (true) {
                ((Object)((Object)this)).getClass();
                if (!this.intersectaConAlgunGrafico(xTmp, yTmp, 100L, this.ALTO_GRAFICO_FASE)) break;
                xTmp += this.DISTANCIA_HORIZONTAL_ENTRE_GRAFICOS;
            }
            extremoIniTmp = this.crearGraficoExtremo(xTmp, yTmp, pTransicionN.getTrFaseIni(), pTransicionN.getTIPO(), true);
        }
        this.posXActual = (long)extremoIniTmp.getGlobalBounds().getX();
        this.posYActual = (long)extremoIniTmp.getGlobalBounds().getY();
        xTmp = this.posXActual;
        yTmp = this.posYActual;
        extremoFinTmp = this.localizarGraficoFase(pTransicionN.getFaseFin(), "FA");
        if (extremoFinTmp == null) {
            ((Object)((Object)this)).getClass();
            yTmp = this.posYActual + 100L;
            while (true) {
                ((Object)((Object)this)).getClass();
                if (!this.intersectaConAlgunGrafico(xTmp, yTmp, 100L, this.ALTO_GRAFICO_FASE)) break;
                xTmp += this.DISTANCIA_HORIZONTAL_ENTRE_GRAFICOS;
            }
            extremoFinTmp = this.crearGraficoExtremo(xTmp, yTmp, pTransicionN.getFaseFin(), pTransicionN.getTIPO(), false);
        }
        this.posXActual = (long)extremoFinTmp.getGlobalBounds().getX();
        this.posYActual = (long)extremoFinTmp.getGlobalBounds().getY();
        this.pintarTransicion(pTransicionN, extremoIniTmp, extremoFinTmp);
    }

    private void crearGraficoTransicionEventos(TrTransicion pTransicionEv) {
        PNodoGrafico extremoFinTmp = null;
        PNodoGrafico extremoIniTmp = null;
        long xTmp = this.posXActual;
        long yTmp = this.posYActual;
        String strTipoABuscar = null;
        strTipoABuscar = "FA";
        extremoFinTmp = this.localizarGraficoFase(pTransicionEv.getFaseFin(), strTipoABuscar);
        if (extremoFinTmp == null) {
            ((Object)((Object)this)).getClass();
            yTmp = this.posYActual + 100L;
            while (true) {
                ((Object)((Object)this)).getClass();
                if (!this.intersectaConAlgunGrafico(xTmp, yTmp, 100L, this.ALTO_GRAFICO_FASE)) break;
                xTmp += this.DISTANCIA_HORIZONTAL_ENTRE_GRAFICOS;
            }
            extremoFinTmp = this.crearGraficoExtremo(xTmp, yTmp, pTransicionEv.getFaseFin(), pTransicionEv.getTIPO(), false);
        }
        this.posXActual = (long)extremoFinTmp.getGlobalBounds().getX();
        this.posYActual = (long)extremoFinTmp.getGlobalBounds().getY();
        xTmp = this.posXActual;
        yTmp = this.posYActual;
        if (pTransicionEv.getTIPO().equals("I")) {
            strTipoABuscar = "I";
        } else if (pTransicionEv.getTIPO().equals("EN")) {
            strTipoABuscar = "EN";
        } else if (pTransicionEv.getTIPO().equals("ES")) {
            strTipoABuscar = "ES";
        }
        extremoIniTmp = this.localizarGraficoFase(pTransicionEv.getTrFaseIni(), strTipoABuscar);
        if (extremoIniTmp == null) {
            if (strTipoABuscar.equals("I")) {
                ((Object)((Object)this)).getClass();
                yTmp = this.posYActual - 100L;
            } else if (strTipoABuscar.equals("EN")) {
                xTmp = this.posXActual + this.DISTANCIA_HORIZONTAL_ENTRE_GRAFICOS;
            } else if (strTipoABuscar.equals("ES")) {
                xTmp = this.posXActual - this.DISTANCIA_HORIZONTAL_ENTRE_GRAFICOS;
            }
            while (true) {
                ((Object)((Object)this)).getClass();
                if (!this.intersectaConAlgunGrafico(xTmp, yTmp, 100L, this.ALTO_GRAFICO_FASE)) break;
                xTmp += this.DISTANCIA_HORIZONTAL_ENTRE_GRAFICOS;
            }
            extremoIniTmp = this.crearGraficoExtremo(xTmp, yTmp, pTransicionEv.getFaseFin(), pTransicionEv.getTIPO(), true);
        }
        this.pintarTransicion(pTransicionEv, extremoIniTmp, extremoFinTmp);
    }

    private void crearGraficoTransicionFin(TrTransicion pTransicionFin) {
        long xTmp = this.posXActual;
        long yTmp = this.posYActual;
        PNodoGrafico extremoFinTmp = null;
        PNodoGrafico extremoIniTmp = null;
        extremoIniTmp = this.localizarGraficoFase(pTransicionFin.getTrFaseIni(), "FA");
        if (extremoIniTmp == null) {
            ((Object)((Object)this)).getClass();
            yTmp = this.posYActual + 100L;
            while (true) {
                ((Object)((Object)this)).getClass();
                if (!this.intersectaConAlgunGrafico(xTmp, yTmp, 100L, this.ALTO_GRAFICO_FASE)) break;
                xTmp += this.DISTANCIA_HORIZONTAL_ENTRE_GRAFICOS;
            }
            extremoIniTmp = this.crearGraficoExtremo(xTmp, yTmp, pTransicionFin.getTrFaseIni(), pTransicionFin.getTIPO(), true);
        }
        this.posXActual = (long)extremoIniTmp.getGlobalBounds().getX();
        this.posYActual = (long)extremoIniTmp.getGlobalBounds().getY();
        xTmp = this.posXActual;
        yTmp = this.posYActual;
        extremoFinTmp = this.localizarGraficoFase(pTransicionFin.getFaseFin(), "F");
        if (extremoFinTmp == null) {
            ((Object)((Object)this)).getClass();
            yTmp = this.posYActual + 100L;
            while (true) {
                ((Object)((Object)this)).getClass();
                if (!this.intersectaConAlgunGrafico(xTmp, yTmp, 100L, this.ALTO_GRAFICO_FASE)) break;
                xTmp += this.DISTANCIA_HORIZONTAL_ENTRE_GRAFICOS;
            }
            extremoFinTmp = this.crearGraficoExtremo(xTmp, yTmp, pTransicionFin.getTrFaseIni(), pTransicionFin.getTIPO(), false);
        }
        this.posXActual = (long)extremoFinTmp.getGlobalBounds().getX();
        this.posYActual = (long)extremoFinTmp.getGlobalBounds().getY();
        this.pintarTransicion(pTransicionFin, extremoIniTmp, extremoFinTmp);
    }

    private void crearGraficoTransicionDiv(TrTransicion pTransicionDiv) {
        long xTmp = this.posXActual;
        long yTmp = this.posYActual;
        PNodoGrafico extremoFinTmp = null;
        PNodoGrafico extremoIniTmp = null;
        extremoIniTmp = this.localizarGraficoFase(pTransicionDiv.getTrFaseIni(), "FA");
        if (extremoIniTmp == null) {
            ((Object)((Object)this)).getClass();
            yTmp = this.posYActual + 100L;
            while (true) {
                ((Object)((Object)this)).getClass();
                if (!this.intersectaConAlgunGrafico(xTmp, yTmp, 100L, this.ALTO_GRAFICO_FASE)) break;
                xTmp += this.DISTANCIA_HORIZONTAL_ENTRE_GRAFICOS;
            }
            extremoIniTmp = this.crearGraficoExtremo(xTmp, yTmp, pTransicionDiv.getTrFaseIni(), pTransicionDiv.getTIPO(), true);
        }
        this.posXActual = (long)extremoIniTmp.getGlobalBounds().getX();
        this.posYActual = (long)extremoIniTmp.getGlobalBounds().getY();
        xTmp = this.posXActual;
        yTmp = this.posYActual;
        extremoFinTmp = this.localizarGraficoFase(pTransicionDiv.getTrFaseIni(), "D");
        if (extremoFinTmp == null) {
            ((Object)((Object)this)).getClass();
            yTmp = this.posYActual + 100L;
            while (true) {
                ((Object)((Object)this)).getClass();
                if (!this.intersectaConAlgunGrafico(xTmp, yTmp, 100L, this.ALTO_GRAFICO_FASE)) break;
                xTmp += this.DISTANCIA_HORIZONTAL_ENTRE_GRAFICOS;
            }
            extremoFinTmp = this.crearGraficoExtremo(xTmp, yTmp, pTransicionDiv.getTrFaseIni(), pTransicionDiv.getTIPO(), false);
        }
        this.posXActual = (long)extremoFinTmp.getGlobalBounds().getX();
        this.posYActual = (long)extremoFinTmp.getGlobalBounds().getY();
        xTmp = this.posXActual;
        yTmp = this.posYActual;
        this.pintarTransicion(pTransicionDiv, extremoIniTmp, extremoFinTmp);
        ((Object)((Object)this)).getClass();
        yTmp = this.posYActual + 100L;
        xTmp = this.posXActual;
        long xTmpAux = this.posXActual;
        boolean bLeft = true;
        for (int n = 0; n < pTransicionDiv.getConjuntoFasesFin().getListaDatos().size(); ++n) {
            extremoIniTmp = null;
            extremoIniTmp = this.localizarGraficoFase((TrFase)pTransicionDiv.getConjuntoFasesFin().getListaDatos().get(n), "FA");
            if (extremoIniTmp == null) {
                if (bLeft) {
                    xTmpAux -= this.DISTANCIA_HORIZONTAL_ENTRE_GRAFICOS;
                    while (true) {
                        ((Object)((Object)this)).getClass();
                        if (!this.intersectaConAlgunGrafico(xTmpAux, yTmp, 100L, this.ALTO_GRAFICO_FASE)) break;
                        xTmpAux -= this.DISTANCIA_HORIZONTAL_ENTRE_GRAFICOS;
                    }
                    extremoIniTmp = this.crearGraficoExtremo(xTmpAux, yTmp, (TrFase)pTransicionDiv.getConjuntoFasesFin().getListaDatos().get(n), pTransicionDiv.getTIPO(), true);
                    bLeft = false;
                } else {
                    xTmp += this.DISTANCIA_HORIZONTAL_ENTRE_GRAFICOS;
                    while (true) {
                        ((Object)((Object)this)).getClass();
                        if (!this.intersectaConAlgunGrafico(xTmp, yTmp, 100L, this.ALTO_GRAFICO_FASE)) break;
                        xTmp += this.DISTANCIA_HORIZONTAL_ENTRE_GRAFICOS;
                    }
                    extremoIniTmp = this.crearGraficoExtremo(xTmp, yTmp, (TrFase)pTransicionDiv.getConjuntoFasesFin().getListaDatos().get(n), pTransicionDiv.getTIPO(), true);
                    bLeft = true;
                }
                this.posYActual = (long)extremoIniTmp.getGlobalBounds().getY();
            }
            this.pintarTransicion(pTransicionDiv, extremoFinTmp, extremoIniTmp);
        }
    }

    private void crearGraficoTransicionUni(TrTransicion pTransicionUni) {
        PNodoGrafico extremoFinTmp = null;
        PNodoGrafico extremoIniTmp = null;
        PNodoGrafico extremoUnionTmp = null;
        long xTmp = this.posXActual;
        long yTmp = this.posYActual;
        extremoUnionTmp = this.localizarGraficoFase(pTransicionUni.getFaseFin(), "U");
        if (extremoUnionTmp == null) {
            if (this.localizarGraficoFase(pTransicionUni.getTrFaseIni(), "FA") == null) {
                ((Object)((Object)this)).getClass();
                yTmp = this.posYActual + 100L * 2L;
            } else {
                ((Object)((Object)this)).getClass();
                yTmp = this.posYActual + 100L;
            }
            while (true) {
                ((Object)((Object)this)).getClass();
                if (!this.intersectaConAlgunGrafico(xTmp, yTmp, 100L, this.ALTO_GRAFICO_FASE)) break;
                xTmp += this.DISTANCIA_HORIZONTAL_ENTRE_GRAFICOS;
            }
            extremoUnionTmp = this.crearGraficoExtremo(xTmp, yTmp, pTransicionUni.getFaseFin(), pTransicionUni.getTIPO(), false);
        }
        this.posXActual = (long)extremoUnionTmp.getGlobalBounds().getX();
        this.posYActual = (long)extremoUnionTmp.getGlobalBounds().getY();
        xTmp = this.posXActual;
        yTmp = this.posYActual;
        extremoIniTmp = this.localizarGraficoFase(pTransicionUni.getTrFaseIni(), "FA");
        if (extremoIniTmp == null) {
            ((Object)((Object)this)).getClass();
            yTmp = this.posYActual - 100L;
            while (true) {
                ((Object)((Object)this)).getClass();
                if (!this.intersectaConAlgunGrafico(xTmp, yTmp, 100L, this.ALTO_GRAFICO_FASE)) break;
                xTmp += this.DISTANCIA_HORIZONTAL_ENTRE_GRAFICOS;
            }
            extremoIniTmp = this.crearGraficoExtremo(xTmp, yTmp, pTransicionUni.getTrFaseIni(), pTransicionUni.getTIPO(), true);
        }
        this.posXActual = (long)extremoIniTmp.getGlobalBounds().getX();
        this.posYActual = (long)extremoIniTmp.getGlobalBounds().getY();
        xTmp = this.posXActual;
        yTmp = this.posYActual;
        this.pintarTransicion(pTransicionUni, extremoIniTmp, extremoUnionTmp);
        extremoFinTmp = this.localizarGraficoFase(pTransicionUni.getFaseFin(), "FA");
        if (extremoFinTmp == null) {
            ((Object)((Object)this)).getClass();
            yTmp = this.posYActual + 100L * 2L;
            while (true) {
                ((Object)((Object)this)).getClass();
                if (!this.intersectaConAlgunGrafico(xTmp, yTmp, 100L, this.ALTO_GRAFICO_FASE)) break;
                xTmp += this.DISTANCIA_HORIZONTAL_ENTRE_GRAFICOS;
            }
            extremoFinTmp = this.crearGraficoExtremo(xTmp, yTmp, pTransicionUni.getFaseFin(), pTransicionUni.getTIPO(), true);
        }
        this.posXActual = (long)extremoFinTmp.getGlobalBounds().getX();
        this.posYActual = (long)extremoFinTmp.getGlobalBounds().getY();
        if (this.localizarGraficoTransicion(extremoUnionTmp.getTrFaseGrAsociada().getID(), extremoFinTmp.getTrFaseGrAsociada().getID()) == null) {
            this.pintarTransicion(pTransicionUni, extremoUnionTmp, extremoFinTmp);
        }
    }

    public void pintarTransicion(TrTransicion pTransicionApintar, PNodoGrafico extremoIniTmp, PNodoGrafico extremoFinTmp) {
        String strIdAux = null;
        strIdAux = String.valueOf(GeneradorID.getID());
        this.transicionGrActivo = new TrTransicionGr();
        this.transicionGrActivo.setID(new BigDecimal(strIdAux));
        if (extremoIniTmp instanceof UnionPNode && extremoFinTmp instanceof FasePNode) {
            this.transicionGrActivo.setTransicion(null);
        } else {
            this.transicionGrActivo.setTransicion(pTransicionApintar);
        }
        this.transicionGrActivo.setGraficoExtremoInicial(extremoIniTmp.getTrFaseGrAsociada());
        this.transicionGrActivo.setGraficoExtremoFinal(extremoFinTmp.getTrFaseGrAsociada());
        this.transicionGrActivo.setDefProcGr(this.diagrama.getDDP());
        this.nodoIniTransi = new TrNodoGr();
        strIdAux = String.valueOf(GeneradorID.getID());
        this.nodoIniTransi.setNOTGID(new BigDecimal(strIdAux));
        this.nodoIniTransi.setX(Long.parseLong(String.valueOf(Math.round(extremoIniTmp.getGlobalBounds().getCenterX()))));
        this.nodoIniTransi.setY(Long.parseLong(String.valueOf(Math.round(extremoIniTmp.getGlobalBounds().getCenterY()))));
        this.nodoIniTransi.setOrden(1);
        this.transicionGrActivo.addVertice(this.nodoIniTransi);
        this.nodoFinTransi = new TrNodoGr();
        strIdAux = String.valueOf(GeneradorID.getID());
        this.nodoFinTransi.setNOTGID(new BigDecimal(strIdAux));
        this.nodoFinTransi.setX(Long.parseLong(String.valueOf(Math.round(extremoFinTmp.getGlobalBounds().getCenterX()))));
        this.nodoFinTransi.setY(Long.parseLong(String.valueOf(Math.round(extremoFinTmp.getGlobalBounds().getCenterY()))));
        this.nodoFinTransi.setOrden(2);
        this.transicionGrActivo.addVertice(this.nodoFinTransi);
        this.pNodoTr = new TransicionPNode(this.transicionGrActivo, this);
        this.pNodoTr.setPNodoGraficoFaseIni(extremoIniTmp);
        this.pNodoTr.setPNodoGraficoFaseFin(extremoFinTmp);
        this.pNodoTr.notificarCreacionAExtremos();
        this.getLayer().addChild((PNode)this.pNodoTr);
        this.pNodoTr.readaptarBounds();
    }

    public PNodoGrafico crearGraficoDeFase(TrFaseGr faseGr) {
        FasePNode nodoFase = new FasePNode(faseGr, this);
        this.getLayer().addChild((PNode)nodoFase);
        nodoFase.setX(this.getCamera().getViewBounds().getX() + 10.0);
        nodoFase.setY(this.getCamera().getViewBounds().getY() + 10.0);
        this.fireObtenerGraficoGeneradoDisponible(new GraficoGeneradoDisponibleEvent(nodoFase, 1));
        return nodoFase;
    }

    public PNodoGrafico crearGraficoExtremo(long posX, long posY, TrFase extremo, String strTipo, boolean bExtremoDeInicio) {
        PNodoGrafico extremoCreado;
        TrFaseGr faseGr = new TrFaseGr();
        ((Object)((Object)this)).getClass();
        long anchoGrafico = 50L;
        ((Object)((Object)this)).getClass();
        long altoGrafico = 50L;
        String strId = null;
        strId = String.valueOf(GeneradorID.getID());
        faseGr.setID(new BigDecimal(strId));
        if (strTipo.equals("N")) {
            strTipo = "FA";
            ((Object)((Object)this)).getClass();
            anchoGrafico = 100L;
            altoGrafico = this.ALTO_GRAFICO_FASE;
        } else if (strTipo.equals("I")) {
            if (bExtremoDeInicio) {
                strTipo = "I";
            } else {
                strTipo = "FA";
                ((Object)((Object)this)).getClass();
                anchoGrafico = 100L;
                altoGrafico = this.ALTO_GRAFICO_FASE;
            }
        } else if (strTipo.equals("F")) {
            if (bExtremoDeInicio) {
                strTipo = "FA";
                ((Object)((Object)this)).getClass();
                anchoGrafico = 100L;
                altoGrafico = this.ALTO_GRAFICO_FASE;
            } else {
                strTipo = "F";
            }
        } else if (strTipo.equals("EN")) {
            if (bExtremoDeInicio) {
                strTipo = "EN";
            } else {
                strTipo = "FA";
                ((Object)((Object)this)).getClass();
                anchoGrafico = 100L;
                altoGrafico = this.ALTO_GRAFICO_FASE;
            }
        } else if (strTipo.equals("ES")) {
            if (bExtremoDeInicio) {
                strTipo = "ES";
            } else {
                strTipo = "FA";
                ((Object)((Object)this)).getClass();
                anchoGrafico = 100L;
                altoGrafico = this.ALTO_GRAFICO_FASE;
            }
        } else if (strTipo.equals("D")) {
            if (bExtremoDeInicio) {
                strTipo = "FA";
                ((Object)((Object)this)).getClass();
                anchoGrafico = 100L;
                altoGrafico = this.ALTO_GRAFICO_FASE;
            } else {
                strTipo = "D";
            }
        } else if (strTipo.equals("U")) {
            if (bExtremoDeInicio) {
                strTipo = "FA";
                ((Object)((Object)this)).getClass();
                anchoGrafico = 100L;
                altoGrafico = this.ALTO_GRAFICO_FASE;
            } else {
                strTipo = "U";
            }
        }
        faseGr.setX(posX);
        faseGr.setY(posY);
        faseGr.setAncho(anchoGrafico);
        faseGr.setAlto(altoGrafico);
        faseGr.setDefProcGr(this.getDiagrama().getDDP());
        if (extremo != null) {
            BigDecimal faseID = extremo.getFASEID();
            faseGr.setTrFase((TrFase)this.diagrama.getFasesInvolucradas().obtenerDato(faseID));
        }
        if ((extremoCreado = CreadorExtremoTransicion.crearExtremo(faseGr, strTipo, this)) != null) {
            this.diagrama.getCanvas().getLayer().addChild((PNode)extremoCreado);
        }
        return extremoCreado;
    }

    public void eliminarPNodoGrafico(PNode pNodoAEliminar) {
        if (this.getLayer() == null || pNodoAEliminar == null) {
            return;
        }
        if (this.getLayer().getAllNodes() != null && !this.getLayer().getAllNodes().contains(pNodoAEliminar)) {
            return;
        }
        this.getLayer().removeChild(pNodoAEliminar);
        if (pNodoAEliminar instanceof PNodoGrafico) {
            ArrayList arrPostItAux = ((PNodoGrafico)pNodoAEliminar).getListaPostIt();
            PostItPNode postItAux = null;
            if (arrPostItAux != null) {
                for (int i = 0; i < arrPostItAux.size(); ++i) {
                    postItAux = (PostItPNode)arrPostItAux.get(i);
                    this.getLayer().removeChild((PNode)postItAux);
                }
            }
        }
        if (pNodoAEliminar instanceof FasePNode) {
            FasePNode faseAux = (FasePNode)pNodoAEliminar;
            for (int n = 0; n < faseAux.getChildrenCount(); ++n) {
                if (!(faseAux.getChild(n) instanceof ImagenPNode)) continue;
                ((ImagenPNode)faseAux.getChild(n)).eliminarToolTipExtendido();
            }
        }
        if (pNodoAEliminar instanceof TransicionPNode) {
            TransicionPNode transiAux = (TransicionPNode)pNodoAEliminar;
            for (int n = 0; n < transiAux.getChildrenCount(); ++n) {
                if (!(transiAux.getChild(n) instanceof ImagenPNode)) continue;
                ((ImagenPNode)transiAux.getChild(n)).eliminarToolTipExtendido();
            }
        }
        if (pNodoAEliminar instanceof TransicionPNode) {
            this.fireObtenerGraficoEliminado(new GraficoEliminadoEvent(pNodoAEliminar, 2));
        } else if (pNodoAEliminar instanceof FasePNode) {
            this.fireObtenerGraficoEliminado(new GraficoEliminadoEvent(pNodoAEliminar, 1));
        } else if (pNodoAEliminar instanceof PostItPNode) {
            this.fireObtenerGraficoEliminado(new GraficoEliminadoEvent(pNodoAEliminar, 9));
        }
    }

    public PBasicInputEventHandler getSelectionEventHandler() {
        if (super.getSelectionEventHandler() != null) {
            return super.getSelectionEventHandler();
        }
        if (this.transEvent != null) {
            return this.transEvent;
        }
        if (this.transEventDivision != null) {
            return this.transEventDivision;
        }
        if (this.transEventUnion != null) {
            return this.transEventUnion;
        }
        if (this.transEventEvento != null) {
            return this.transEventEvento;
        }
        if (this.transEventFin != null) {
            return this.transEventFin;
        }
        if (this.crearGrFaseEvent != null) {
            return this.crearGrFaseEvent;
        }
        if (this.crearPostItEvent != null) {
            return this.crearPostItEvent;
        }
        return null;
    }

    public void inicializarCoordenadas() {
        long l = (long)this.getCamera().getBounds().getWidth() / 2L;
        ((Object)((Object)this)).getClass();
        this.posXActual = l - 100L / 2L;
        this.posYActual = 10L;
    }

    public boolean intersectaConAlgunGrafico(Rectangle2D.Double evaluarRec) {
        if (evaluarRec == null) {
            return false;
        }
        if (this.getLayer() == null) {
            return false;
        }
        PLayer lyr = this.getLayer();
        for (int i = 0; i < lyr.getChildrenCount(); ++i) {
            PNodoGrafico pNodo;
            if (!(lyr.getChild(i) instanceof PNodoGrafico) || !(pNodo = (PNodoGrafico)lyr.getChild(i)).intersects(evaluarRec)) continue;
            return true;
        }
        return false;
    }

    public boolean intersectaConAlgunGrafico(long paramX, long paramY, long paramAncho, long paramAlto) {
        if (this.getLayer() == null) {
            return false;
        }
        Rectangle2D.Double rectEvaluar = new Rectangle2D.Double(paramX, paramY, paramAncho, paramAlto);
        PLayer lyr = this.getLayer();
        for (int i = 0; i < lyr.getChildrenCount(); ++i) {
            PNodoGrafico pNodo;
            if (!(lyr.getChild(i) instanceof PNodoGrafico) || !rectEvaluar.intersects((pNodo = (PNodoGrafico)lyr.getChild(i)).getGlobalBounds().getX(), pNodo.getGlobalBounds().getY(), pNodo.getGlobalBounds().getWidth(), pNodo.getGlobalBounds().getHeight())) continue;
            return true;
        }
        return false;
    }

    public void esperarDurante(long nMilisegundos) {
        try {
            Thread.sleep(nMilisegundos);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void aplicarEstilo(RepGraficaNodo nodoAfectado, int nTipo, long nDuracion, int pAplicarA) {
        if (nodoAfectado == null) {
            return;
        }
        ((Object)((Object)this)).getClass();
        if (nTipo == 1) {
            nodoAfectado.setColorFondo(Color.red);
            this.getCamera().repaint();
            return;
        }
        if (nTipo == this.EFECTO_PARPADEO) {
            Color colorAux = null;
            if (pAplicarA == PParpadeoActivity.APLICAR_A_RELLENO) {
                colorAux = nodoAfectado.getColorFondo();
            } else if (pAplicarA == PParpadeoActivity.APLICAR_A_TEXTO) {
                colorAux = nodoAfectado.getColorTexto();
            } else if (pAplicarA == PParpadeoActivity.APLICAR_A_BORDE) {
                colorAux = nodoAfectado.getColorBorde();
            }
            PParpadeoActivity efecto = new PParpadeoActivity(nDuracion);
            efecto.efectoParpadeo(this, nodoAfectado, ModelaUI.colorSeleccion, colorAux, pAplicarA);
            return;
        }
    }

    public boolean eliminarEstilo(RepGraficaNodo nodoAfectado) {
        PActivityScheduler manejaActivities = this.getRoot().getActivityScheduler();
        for (int n = 0; n < manejaActivities.getActivitiesReference().size(); ++n) {
            if (!(manejaActivities.getActivitiesReference().get(n) instanceof PParpadeoActivity) || ((PParpadeoActivity)((Object)manejaActivities.getActivitiesReference().get((int)n))).nodoEnAccion == null || ((PParpadeoActivity)((Object)manejaActivities.getActivitiesReference().get((int)n))).nodoEnAccion != nodoAfectado) continue;
            ((PParpadeoActivity)((Object)manejaActivities.getActivitiesReference().get(n))).activityFinished();
            manejaActivities.removeActivity((PActivity)((PParpadeoActivity)((Object)manejaActivities.getActivitiesReference().get(n))));
        }
        return true;
    }

    public void aplicarVista(int tipoVista, long delayDesplazamientoVista, Rectangle2D extensionVista) {
        switch (tipoVista) {
            case 1: {
                PBounds boundsTotal = this.getCamera().getUnionOfLayerFullBounds();
                this.getCamera().animateViewToCenterBounds((Rectangle2D)boundsTotal, true, delayDesplazamientoVista);
                break;
            }
            case 4: {
                this.getCamera().animateViewToCenterBounds(extensionVista, false, delayDesplazamientoVista);
                break;
            }
            case 2: {
                this.getCamera().animateViewToCenterBounds(extensionVista, true, delayDesplazamientoVista);
                break;
            }
            case 3: {
                this.getCamera().animateViewToCenterBounds(extensionVista, true, delayDesplazamientoVista);
            }
        }
        this.repaint();
    }

    public boolean eliminarActivities() {
        PActivityScheduler manejaActivities = this.getRoot().getActivityScheduler();
        for (int n = 0; n < manejaActivities.getActivitiesReference().size(); ++n) {
            if (!(manejaActivities.getActivitiesReference().get(n) instanceof PParpadeoActivity)) continue;
            ((PParpadeoActivity)((Object)manejaActivities.getActivitiesReference().get(n))).activityFinished();
        }
        manejaActivities.removeAllActivities();
        return true;
    }

    public ArrayList obtenerGraficosRelacionados(TrTransicion transiAEnfocar) {
        if (transiAEnfocar == null) {
            return null;
        }
        ArrayList<RepGraficaNodo> listaNodosGraficos = null;
        TransicionPNode graficoTransi = null;
        TransicionPNode graficoTransiUni = null;
        TransicionPNode graficoTransiDiv = null;
        PNodoGrafico graficoFaseIni = null;
        PNodoGrafico graficoFaseFin = null;
        PNodoGrafico graficoNodoUni = null;
        PNodoGrafico graficoNodoDiv = null;
        if (transiAEnfocar.getTIPO().equals("N") || transiAEnfocar.getTIPO().equals("I") || transiAEnfocar.getTIPO().equals("EN") || transiAEnfocar.getTIPO().equals("ES") || transiAEnfocar.getTIPO().equals("F")) {
            graficoTransi = this.localizarGraficoTransicion(transiAEnfocar);
            if (graficoTransi == null) {
                return null;
            }
            if (graficoTransi.getPNodoGraficoFaseIni() != null && graficoTransi.getPNodoGraficoFaseIni().getTrFaseGrAsociada() != null) {
                graficoFaseIni = this.localizarGraficoFase(graficoTransi.getPNodoGraficoFaseIni().getTrFaseGrAsociada().getID());
            }
            if (graficoTransi.getPNodoGraficoFaseFin() != null && graficoTransi.getPNodoGraficoFaseFin().getTrFaseGrAsociada() != null) {
                graficoFaseFin = this.localizarGraficoFase(graficoTransi.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getID());
            }
            if (graficoFaseIni == null || graficoFaseFin == null) {
                return null;
            }
            listaNodosGraficos = new ArrayList<RepGraficaNodo>();
            listaNodosGraficos.add(graficoFaseIni);
            listaNodosGraficos.add(graficoFaseFin);
            listaNodosGraficos.add(graficoTransi);
        } else if (transiAEnfocar.getTIPO().equals("U")) {
            graficoTransi = this.localizarGraficoTransicion(transiAEnfocar);
            if (graficoTransi == null) {
                return null;
            }
            if (graficoTransi.getPNodoGraficoFaseIni() != null && graficoTransi.getPNodoGraficoFaseIni().getTrFaseGrAsociada() != null) {
                graficoFaseIni = this.localizarGraficoFase(graficoTransi.getPNodoGraficoFaseIni().getTrFaseGrAsociada().getID());
            }
            if (graficoTransi.getPNodoGraficoFaseFin() != null && graficoTransi.getPNodoGraficoFaseFin().getTrFaseGrAsociada() != null) {
                graficoNodoUni = this.localizarGraficoFase(graficoTransi.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getID());
            }
            if (graficoNodoUni != null && graficoNodoUni.getTrFaseGrAsociada() != null) {
                graficoTransiUni = this.localizarGraficoTransicionFinalDeUnion(graficoNodoUni.getTrFaseGrAsociada().getID());
            }
            if (graficoTransiUni != null && graficoTransiUni.getPNodoGraficoFaseFin() != null && graficoTransiUni.getPNodoGraficoFaseFin().getTrFaseGrAsociada() != null) {
                graficoFaseFin = this.localizarGraficoFase(graficoTransiUni.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getID());
            }
            if (graficoFaseIni == null || graficoFaseFin == null || graficoNodoUni == null) {
                return null;
            }
            listaNodosGraficos = new ArrayList();
            listaNodosGraficos.add(graficoTransi);
            listaNodosGraficos.add(graficoFaseIni);
            listaNodosGraficos.add(graficoNodoUni);
            listaNodosGraficos.add(graficoFaseFin);
            if (graficoTransiUni != null) {
                listaNodosGraficos.add(graficoTransiUni);
            }
        } else if (transiAEnfocar.getTIPO().equals("D")) {
            graficoTransi = this.localizarGraficoTransicion(transiAEnfocar);
            if (graficoTransi == null) {
                return null;
            }
            if (graficoTransi.getPNodoGraficoFaseIni() != null && graficoTransi.getPNodoGraficoFaseIni().getTrFaseGrAsociada() != null) {
                graficoFaseIni = this.localizarGraficoFase(graficoTransi.getPNodoGraficoFaseIni().getTrFaseGrAsociada().getID());
            }
            if (graficoTransi.getPNodoGraficoFaseFin() != null && graficoTransi.getPNodoGraficoFaseFin().getTrFaseGrAsociada() != null) {
                graficoNodoDiv = this.localizarGraficoFase(graficoTransi.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getID());
            }
            if (graficoFaseIni == null || graficoNodoDiv == null) {
                return null;
            }
            listaNodosGraficos = new ArrayList();
            listaNodosGraficos.add(graficoFaseIni);
            listaNodosGraficos.add(graficoTransi);
            listaNodosGraficos.add(graficoNodoDiv);
            ArrayList arrRamificaciones = this.localizarGraficosTransicionRelacionados(graficoNodoDiv.getTrFaseGrAsociada().getID(), "D");
            if (arrRamificaciones != null) {
                for (int n = 0; n < arrRamificaciones.size(); ++n) {
                    graficoTransiDiv = (TransicionPNode)arrRamificaciones.get(n);
                    if (graficoTransiDiv.getPNodoGraficoFaseIni() == null || !(graficoTransiDiv.getPNodoGraficoFaseIni() instanceof DivisionPNode)) continue;
                    listaNodosGraficos.add(graficoTransiDiv);
                    if (graficoTransiDiv.getPNodoGraficoFaseFin() != null && graficoTransiDiv.getPNodoGraficoFaseFin().getTrFaseGrAsociada() != null) {
                        graficoFaseFin = this.localizarGraficoFase(graficoTransiDiv.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getID());
                    }
                    if (graficoFaseFin == null) continue;
                    listaNodosGraficos.add(graficoFaseFin);
                }
            }
        }
        return listaNodosGraficos;
    }

    public Rectangle2D calcularExtension(ArrayList listadoRecs) {
        if (listadoRecs == null) {
            return null;
        }
        double norte = 0.0;
        double sur = 0.0;
        double este = 0.0;
        double oeste = 0.0;
        for (int indiceRec = 0; indiceRec < listadoRecs.size(); ++indiceRec) {
            if (indiceRec == 0) {
                norte = ((Rectangle2D)listadoRecs.get(indiceRec)).getMinY();
                sur = ((Rectangle2D)listadoRecs.get(indiceRec)).getMaxY();
                oeste = ((Rectangle2D)listadoRecs.get(indiceRec)).getMinX();
                este = ((Rectangle2D)listadoRecs.get(indiceRec)).getMaxX();
                continue;
            }
            if (((Rectangle2D)listadoRecs.get(indiceRec)).getMinY() < norte) {
                norte = ((Rectangle2D)listadoRecs.get(indiceRec)).getMinY();
            }
            if (((Rectangle2D)listadoRecs.get(indiceRec)).getMaxY() > sur) {
                sur = ((Rectangle2D)listadoRecs.get(indiceRec)).getMaxY();
            }
            if (((Rectangle2D)listadoRecs.get(indiceRec)).getMinX() < oeste) {
                oeste = ((Rectangle2D)listadoRecs.get(indiceRec)).getMinX();
            }
            if (!(((Rectangle2D)listadoRecs.get(indiceRec)).getMaxX() > este)) continue;
            este = ((Rectangle2D)listadoRecs.get(indiceRec)).getMaxX();
        }
        Rectangle2D.Double recFinal = new Rectangle2D.Double(oeste - 10.0, norte - 10.0, este + 20.0 - oeste, sur + 20.0 - norte);
        return recFinal;
    }

    public void asignarMetafase() {
        if (this.diagrama == null) {
            return;
        }
        if (this.getSelectionEventHandler() == null) {
            return;
        }
        if (!(this.getSelectionEventHandler() instanceof PSelectionEventHandler)) {
            return;
        }
        if (((PSelectionEventHandler)this.getSelectionEventHandler()).getSelection() == null) {
            return;
        }
        if (((PSelectionEventHandler)this.getSelectionEventHandler()).getSelection().size() < 1) {
            return;
        }
        TrMetafase metaSelec = this.diagrama.seleccionarMetafaseAasignar();
        if (metaSelec == null) {
            return;
        }
        ArrayList graficosSel = this.obtenerGraficosSeleccionados(1);
        if (graficosSel == null) {
            return;
        }
        if (graficosSel.size() < 1) {
            return;
        }
        FasePNode grFaseAux = null;
        for (int n = 0; n < graficosSel.size(); ++n) {
            grFaseAux = (FasePNode)graficosSel.get(n);
            grFaseAux.getTrFaseGrAsociada().getTrFase().setMETAFASE(metaSelec);
            grFaseAux.repaint();
        }
        if (grFaseAux != null) {
            this.fireObtenerGraficoModificado(new GraficoModificadoEvent(grFaseAux, 1));
        }
    }

    public void propiedadesGraficosSelec(int nTipoGrafico) {
        if (this.diagrama == null) {
            return;
        }
        if (this.getSelectionEventHandler() == null) {
            return;
        }
        if (!(this.getSelectionEventHandler() instanceof PSelectionEventHandlerEx)) {
            return;
        }
        if (((PSelectionEventHandler)this.getSelectionEventHandler()).getSelection() == null) {
            return;
        }
        if (((PSelectionEventHandler)this.getSelectionEventHandler()).getSelection().size() < 1) {
            return;
        }
        if (this.getAccionActual() == AccionPCanvas.ACCION_SEL_LIMITADA) {
            return;
        }
        ArrayList graficosSel = this.obtenerGraficosSeleccionados(nTipoGrafico);
        if (graficosSel == null) {
            return;
        }
        if (graficosSel.size() < 1) {
            return;
        }
        ArrayList<Referencia> elementosSelec = new ArrayList<Referencia>();
        ConjuntoDatos listaFiltrada = new ConjuntoDatos();
        if (nTipoGrafico == 1) {
            FasePNode grFaseAux = null;
            for (int n = 0; n < graficosSel.size(); ++n) {
                grFaseAux = (FasePNode)graficosSel.get(n);
                if (grFaseAux.getTrFaseGrAsociada() == null || grFaseAux.getTrFaseGrAsociada().getTrFase() == null || elementosSelec.contains(grFaseAux.getTrFaseGrAsociada().getTrFase())) continue;
                elementosSelec.add(grFaseAux.getTrFaseGrAsociada().getTrFase());
            }
            listaFiltrada.setListaDatos(elementosSelec);
            this.diagrama.mostrarPropiedadesSeleccion(listaFiltrada, nTipoGrafico);
            if (grFaseAux != null) {
                this.fireObtenerGraficoModificado(new GraficoModificadoEvent(grFaseAux, 1));
            }
        } else if (nTipoGrafico == 2) {
            TransicionPNode grTransiAux = null;
            for (int t = 0; t < graficosSel.size(); ++t) {
                grTransiAux = (TransicionPNode)graficosSel.get(t);
                if (grTransiAux.getTrTransicion() != null) {
                    if (elementosSelec.contains(grTransiAux.getTrTransicion())) continue;
                    elementosSelec.add(grTransiAux.getTrTransicion());
                    continue;
                }
                if (grTransiAux.getPNodoGraficoFaseIni() == null) {
                    return;
                }
                if (grTransiAux.getPNodoGraficoFaseIni().getTrFaseGrAsociada() == null) {
                    return;
                }
                ArrayList transicionesRelacionadas = this.localizarGraficosTransicionUni(grTransiAux.getPNodoGraficoFaseIni().getTrFaseGrAsociada().getID());
                for (int nt = 0; nt < transicionesRelacionadas.size(); ++nt) {
                    if (((TransicionPNode)transicionesRelacionadas.get(nt)).getTrTransicion() == null || elementosSelec.contains(((TransicionPNode)transicionesRelacionadas.get(nt)).getTrTransicion())) continue;
                    elementosSelec.add(((TransicionPNode)transicionesRelacionadas.get(nt)).getTrTransicion());
                }
            }
            listaFiltrada.setListaDatos(elementosSelec);
            this.diagrama.mostrarPropiedadesSeleccion(listaFiltrada, nTipoGrafico);
            this.actualizarEtiquetas();
            if (grTransiAux != null) {
                this.fireObtenerGraficoModificado(new GraficoModificadoEvent(grTransiAux, 2));
            }
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        this.setBackground(ModelaConf.getColorFondoCanvas());
        boolean grafBufferEsNulo = false;
        Dimension d = this.getSize();
        if (d == null) {
            d = new Dimension();
        }
        if (this.imgBuff != null && ((double)this.imgBuff.getWidth((ImageObserver)((Object)this)) != d.getWidth() || (double)this.imgBuff.getHeight((ImageObserver)((Object)this)) != d.getHeight())) {
            this.graphBuffer = null;
        }
        if (this.graphBuffer == null) {
            this.imgBuff = this.createImage(d.width, d.height);
            if (this.imgBuff != null) {
                this.graphBuffer = this.imgBuff.getGraphics();
            }
        }
        if (this.graphBuffer == null) {
            this.graphBuffer = g;
            grafBufferEsNulo = true;
        }
        this.graphBuffer.clearRect(0, 0, d.width, d.height);
        super.paint(this.graphBuffer);
        if (!grafBufferEsNulo) {
            g.drawImage(this.imgBuff, 0, 0, (ImageObserver)((Object)this));
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public synchronized void addGraficoGeneradoDisponibleListener(GraficoGeneradoDisponibleListener l) {
        if (!this.graficoGeneradoDisponibleListeners.contains(l)) {
            this.graficoGeneradoDisponibleListeners.add(l);
        }
    }

    public synchronized void removeGraficoGeneradoDisponibleListener(GraficoGeneradoDisponibleListener l) {
        this.graficoGeneradoDisponibleListeners.remove(l);
    }

    protected void fireObtenerGraficoGeneradoDisponible(GraficoGeneradoDisponibleEvent e) {
        List listeners = (List)this.graficoGeneradoDisponibleListeners.clone();
        int count = listeners.size();
        for (int i = 0; i < count; ++i) {
            ((GraficoGeneradoDisponibleListener)listeners.get(i)).obtenerGraficoGeneradoDisponible(e);
        }
    }

    public synchronized void addGraficoObtenidoDisponibleListener(GraficoObtenidoDisponibleListener l) {
        if (!this.graficoObtenidoDisponibleListeners.contains(l)) {
            this.graficoObtenidoDisponibleListeners.add(l);
        }
    }

    public synchronized void removeGraficoObtenidoDisponibleListener(GraficoObtenidoDisponibleListener l) {
        this.graficoObtenidoDisponibleListeners.remove(l);
    }

    protected void fireObtenerGraficoObtenidoDisponible(GraficoObtenidoDisponibleEvent e) {
        List listeners = (List)this.graficoObtenidoDisponibleListeners.clone();
        int count = listeners.size();
        for (int i = 0; i < count; ++i) {
            ((GraficoObtenidoDisponibleListener)listeners.get(i)).obtenerGraficoObtenidoDisponible(e);
        }
    }

    public synchronized void addGraficoEliminadoListener(GraficoEliminadoListener l) {
        if (!this.graficoEliminadoListeners.contains(l)) {
            this.graficoEliminadoListeners.add(l);
        }
    }

    public synchronized void removeGraficoEliminadoListener(GraficoEliminadoListener l) {
        this.graficoEliminadoListeners.remove(l);
    }

    protected void fireObtenerGraficoEliminado(GraficoEliminadoEvent e) {
        List listeners = (List)this.graficoEliminadoListeners.clone();
        int count = listeners.size();
        for (int i = 0; i < count; ++i) {
            ((GraficoEliminadoListener)listeners.get(i)).obtenerGraficoEliminado(e);
        }
    }

    public synchronized void addGraficoModificadoListener(GraficoModificadoListener l) {
        if (!this.graficoModificadoListeners.contains(l)) {
            this.graficoModificadoListeners.add(l);
        }
    }

    public synchronized void removeGraficoModificadoListener(GraficoModificadoListener l) {
        this.graficoModificadoListeners.remove(l);
    }

    protected void fireObtenerGraficoModificado(GraficoModificadoEvent e) {
        List listeners = (List)this.graficoModificadoListeners.clone();
        int count = listeners.size();
        for (int i = 0; i < count; ++i) {
            ((GraficoModificadoListener)listeners.get(i)).obtenerGraficoModificado(e);
        }
    }

    public TrTransicionDefProcedimiento mostrarAccionTransicion(TrTransicion transicion) {
        TrTransicionDefProcedimiento transicionDefProc = null;
        MantenimientoAccionTransicionJDialog mttoAccionTrans = new MantenimientoAccionTransicionJDialog();
        if (this.diagrama != null) {
            mttoAccionTrans.setGrafico(this.diagrama);
            transicionDefProc = this.diagrama.getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transicion.getID());
            if (transicionDefProc == null) {
                transicionDefProc = this.diagrama.getTransicionesDelProcInvolucradas().add(transicion);
            }
            mttoAccionTrans.setAccionesInvolucradas(this.diagrama.getAccionesInvolucradas());
            mttoAccionTrans.setTransicionDefProc(transicionDefProc);
            mttoAccionTrans.inicializarListaElementos(transicionDefProc.getConjuntoAccionTransicion());
        }
        mttoAccionTrans.activarSeleccion(false);
        mttoAccionTrans.setLocationRelativeTo(null);
        if (this.nAccion == AccionPCanvas.ACCION_SEL_LIMITADA) {
            mttoAccionTrans.setDesdeSeleccionLimitada(true);
        }
        mttoAccionTrans.setVisible(true);
        return transicionDefProc;
    }

    public TrTransicionDefProcedimiento mostrarCondicionTransicion(TrTransicion transicion) {
        TrTransicionDefProcedimiento transicionDefProc = null;
        MantenimientoCondicionTransicionJDialog mttoCondicionTrans = new MantenimientoCondicionTransicionJDialog();
        if (this.diagrama != null) {
            mttoCondicionTrans.setGrafico(this.diagrama);
            transicionDefProc = this.diagrama.getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transicion.getID());
            if (transicionDefProc == null) {
                transicionDefProc = this.diagrama.getTransicionesDelProcInvolucradas().add(transicion);
            }
            mttoCondicionTrans.setCondicionesInvolucradas(this.diagrama.getCondicionesInvolucradas());
            mttoCondicionTrans.setTransicionDefProc(transicionDefProc);
            mttoCondicionTrans.inicializarListaElementos(transicionDefProc.getConjuntoCondicionTransicion());
        }
        mttoCondicionTrans.activarSeleccion(false);
        mttoCondicionTrans.setLocationRelativeTo(null);
        if (this.nAccion == AccionPCanvas.ACCION_SEL_LIMITADA) {
            mttoCondicionTrans.setDesdeSeleccionLimitada(true);
        }
        mttoCondicionTrans.setVisible(true);
        return transicionDefProc;
    }

    public TrTransicionDefProcedimiento mostrarAvisoTransicion(TrTransicion transicion) {
        TrTransicionDefProcedimiento transicionDefProc = null;
        MantenimientoAvisoTransicionJDialog mttoAvisoTrans = new MantenimientoAvisoTransicionJDialog();
        if (this.diagrama != null) {
            mttoAvisoTrans.setGrafico(this.diagrama);
            transicionDefProc = this.diagrama.getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transicion.getID());
            if (transicionDefProc == null) {
                transicionDefProc = this.diagrama.getTransicionesDelProcInvolucradas().add(transicion);
            }
            mttoAvisoTrans.setAvisosInvolucrados(this.diagrama.getAvisosInvolucrados());
            mttoAvisoTrans.setTransicionDefProc(transicionDefProc);
            mttoAvisoTrans.inicializarListaElementos(transicionDefProc.getConjuntoAvisoTransicion());
        }
        mttoAvisoTrans.activarSeleccion(false);
        mttoAvisoTrans.setLocationRelativeTo(null);
        if (this.nAccion == AccionPCanvas.ACCION_SEL_LIMITADA) {
            mttoAvisoTrans.setDesdeSeleccionLimitada(true);
        }
        mttoAvisoTrans.setVisible(true);
        return transicionDefProc;
    }

    public TrTransicionDefProcedimiento mostrarPermisoTransicion(TrTransicion transicion) {
        TrTransicionDefProcedimiento transicionDefProc = null;
        MantenimientoPerfilTransicionJDialog mttoPerfilTrans = new MantenimientoPerfilTransicionJDialog();
        if (this.diagrama != null) {
            mttoPerfilTrans.setGrafico(this.diagrama);
            transicionDefProc = this.diagrama.getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transicion.getID());
            if (transicionDefProc == null) {
                transicionDefProc = this.diagrama.getTransicionesDelProcInvolucradas().add(transicion);
            }
            mttoPerfilTrans.setTransicionDefProc(transicionDefProc);
            mttoPerfilTrans.inicializarListaElementos(transicionDefProc.getConjuntoPerfilTransEvol());
        }
        mttoPerfilTrans.activarSeleccion(false);
        mttoPerfilTrans.setLocationRelativeTo(null);
        if (this.nAccion == AccionPCanvas.ACCION_SEL_LIMITADA) {
            mttoPerfilTrans.setDesdeSeleccionLimitada(true);
        }
        mttoPerfilTrans.setVisible(true);
        return transicionDefProc;
    }

    public void mostrarTareaFaseDefProc(TrFase fase) {
        MantenimientoTareaEnFaseDefProcJDialog mttoTareaEnFaseDefProc = new MantenimientoTareaEnFaseDefProcJDialog();
        if (this.diagrama != null) {
            mttoTareaEnFaseDefProc.permitirOrdenar(false);
            mttoTareaEnFaseDefProc.setGrafico(this.diagrama);
            mttoTareaEnFaseDefProc.setFaseActiva(fase);
            mttoTareaEnFaseDefProc.inicializarListaElementos(this.diagrama.getTareaFaseDefProcInvolucradas());
        }
        mttoTareaEnFaseDefProc.activarSeleccion(false);
        mttoTareaEnFaseDefProc.setLocationRelativeTo(null);
        if (this.nAccion == AccionPCanvas.ACCION_SEL_LIMITADA) {
            mttoTareaEnFaseDefProc.setDesdeSeleccionLimitada(true);
        }
        mttoTareaEnFaseDefProc.setVisible(true);
    }

    public void mostrarPlazoSimpleTransicion(TrTransicion transicion) {
        if (transicion == null) {
            return;
        }
        if (transicion.getFaseFin() == null) {
            return;
        }
        boolean bTipoDiv = false;
        if (transicion.getTIPO().equals("D")) {
            bTipoDiv = true;
        }
        MantenimientoPlazoSimpleJDialog plazoSimpleDlg = new MantenimientoPlazoSimpleJDialog();
        TrTransicionDefProcedimiento transicionDefProc = null;
        if (this.diagrama != null) {
            plazoSimpleDlg.setGrafico(this.diagrama);
            transicionDefProc = this.diagrama.getTransicionesDelProcInvolucradas().add(transicion);
            ConjuntoDatos FasesFinales = new ConjuntoDatos();
            if (bTipoDiv) {
                FasesFinales = transicion.getConjuntoFasesFin();
            } else {
                FasesFinales.getListaDatos().add(transicion.getFaseFin());
            }
            plazoSimpleDlg.setTransicionDivision(bTipoDiv);
            plazoSimpleDlg.setTransDefProcedimiento(transicionDefProc);
            plazoSimpleDlg.inicializarListaElementos(FasesFinales);
        }
        plazoSimpleDlg.setLocationRelativeTo(null);
        plazoSimpleDlg.setModal(true);
        plazoSimpleDlg.setVisible(true);
    }

    public void mostrarTareaFase(TrFase fase) {
        MantenimientoTareaEnFaseJDialog mttoTareaEnFase = new MantenimientoTareaEnFaseJDialog();
        if (this.diagrama != null) {
            mttoTareaEnFase.setGrafico(this.diagrama);
            mttoTareaEnFase.setFaseActiva(fase);
        }
        mttoTareaEnFase.inicializarListaElementos(fase.getConjuntoTareasEnFase());
        mttoTareaEnFase.activarSeleccion(false);
        mttoTareaEnFase.setLocationRelativeTo(null);
        mttoTareaEnFase.setVisible(true);
    }

    public void setPrimeraVisualizacion(boolean bPrimeraVez) {
        this.bPrimeraVisualizacion = bPrimeraVez;
    }

    public boolean isPrimeraVisualizacion() {
        return this.bPrimeraVisualizacion;
    }

    public boolean isImprimiendo() {
        return this.bImprimiendo;
    }

    public void setImprimiendo(boolean pValor) {
        this.bImprimiendo = pValor;
    }

    public void zoomExtensionTotal() {
        PBounds boundsTotal;
        if (this.obtenerNumGraficos(1) > 0 && this.getCamera() != null && (boundsTotal = this.getCamera().getUnionOfLayerFullBounds()) != null) {
            this.getCamera().animateViewToCenterBounds((Rectangle2D)boundsTotal, true, 0L);
        }
    }

    public boolean isGrTransicionCoherente(TrTransicionGr transicionGr, PNodoGrafico extremoIniPNode, PNodoGrafico extremoFinPNode) {
        if (transicionGr == null) {
            return false;
        }
        if (this == null) {
            return false;
        }
        boolean bCoherente = true;
        TrTransicion trTransi = transicionGr.getTransicion();
        TrFase trFaseIniDeTransi = null;
        TrFase trFaseFinDeTransi = null;
        if (trTransi != null) {
            trFaseIniDeTransi = trTransi.getTrFaseIni();
            trFaseFinDeTransi = trTransi.getFaseFin();
        }
        TrFaseGr grFaseIni = transicionGr.getGraficoExtremoInicial();
        TrFaseGr grFaseFin = transicionGr.getGraficoExtremoFinal();
        TrFase trFaseIniDeGraf = null;
        TrFase trFaseFinDeGraf = null;
        if (grFaseIni != null) {
            trFaseIniDeGraf = grFaseIni.getTrFase();
        }
        if (grFaseFin != null) {
            trFaseFinDeGraf = grFaseFin.getTrFase();
        }
        if (trTransi != null) {
            if (trTransi.getTIPO().equals("N")) {
                if (trFaseIniDeGraf == null || trFaseFinDeGraf == null || trFaseIniDeTransi == null || trFaseFinDeTransi == null) {
                    return false;
                }
                if (trFaseIniDeGraf.getFASEID().longValue() != trFaseIniDeTransi.getFASEID().longValue() || trFaseFinDeGraf.getFASEID().longValue() != trFaseFinDeTransi.getFASEID().longValue()) {
                    return false;
                }
            } else if (trTransi.getTIPO().equals("EN") || trTransi.getTIPO().equals("ES") || trTransi.getTIPO().equals("I")) {
                if (trFaseIniDeGraf == null || trFaseFinDeGraf == null || trFaseFinDeTransi == null) {
                    bCoherente = false;
                }
                if (bCoherente && trFaseIniDeGraf != null && trFaseFinDeGraf != null && trFaseFinDeTransi != null && (trFaseIniDeGraf.getFASEID().longValue() != trFaseFinDeTransi.getFASEID().longValue() || trFaseFinDeGraf.getFASEID().longValue() != trFaseFinDeTransi.getFASEID().longValue())) {
                    bCoherente = false;
                }
                if (!bCoherente) {
                    this.eliminarPNodoGrafico(extremoIniPNode);
                    return false;
                }
            } else if (trTransi.getTIPO().equals("F")) {
                if (trFaseIniDeGraf == null || trFaseFinDeGraf == null || trFaseIniDeTransi == null) {
                    bCoherente = false;
                }
                if (bCoherente && trFaseIniDeGraf != null && trFaseFinDeGraf != null && trFaseIniDeTransi != null && (trFaseIniDeGraf.getFASEID().longValue() != trFaseIniDeTransi.getFASEID().longValue() || trFaseFinDeGraf.getFASEID().longValue() != trFaseIniDeTransi.getFASEID().longValue())) {
                    bCoherente = false;
                }
                if (!bCoherente) {
                    this.eliminarPNodoGrafico(extremoFinPNode);
                    return false;
                }
            } else if (trTransi.getTIPO().equals("U")) {
                if (trFaseIniDeGraf == null || trFaseFinDeGraf == null || trFaseIniDeTransi == null || trFaseFinDeTransi == null) {
                    return false;
                }
                if (trFaseIniDeGraf.getFASEID().longValue() != trFaseIniDeTransi.getFASEID().longValue() || trFaseFinDeGraf.getFASEID().longValue() != trFaseFinDeTransi.getFASEID().longValue()) {
                    return false;
                }
            } else if (trTransi.getTIPO().equals("D")) {
                if (extremoIniPNode instanceof FasePNode) {
                    if (trFaseIniDeGraf == null || trFaseIniDeTransi == null || trFaseFinDeGraf == null) {
                        bCoherente = false;
                    }
                    if (bCoherente && trFaseIniDeGraf != null && trFaseIniDeTransi != null && trFaseIniDeGraf.getFASEID().longValue() != trFaseIniDeTransi.getFASEID().longValue()) {
                        bCoherente = false;
                    }
                    if (!bCoherente) {
                        this.eliminarPNodoGrafico(extremoFinPNode);
                        return false;
                    }
                } else {
                    if (this.localizarGraficoTransicion(trTransi) == null) {
                        return false;
                    }
                    if (trFaseIniDeGraf == null || trFaseIniDeTransi == null || trFaseFinDeGraf == null) {
                        return false;
                    }
                    ConjuntoDatosFase fasesFin = trTransi.getConjuntoFasesFin();
                    if (fasesFin == null) {
                        return false;
                    }
                    if (fasesFin.getListaDatos() == null) {
                        return false;
                    }
                    if (fasesFin.getListaDatos().size() < 1) {
                        return false;
                    }
                    bCoherente = false;
                    for (int n = 0; n < fasesFin.getListaDatos().size(); ++n) {
                        if (trFaseFinDeGraf.getFASEID().longValue() != ((TrFase)fasesFin.getListaDatos().get(n)).getFASEID().longValue()) continue;
                        bCoherente = true;
                    }
                    if (!bCoherente) {
                        if (grFaseIni == null) {
                            return false;
                        }
                        ArrayList grTransicionesAEliminar = this.localizarGraficosTransicionRelacionados(grFaseIni.getID(), "D");
                        if (grTransicionesAEliminar == null) {
                            return false;
                        }
                        if (grTransicionesAEliminar.size() < 1) {
                            return false;
                        }
                        for (int t = 0; t < grTransicionesAEliminar.size(); ++t) {
                            this.eliminarPNodoGrafico((PNode)((TransicionPNode)grTransicionesAEliminar.get(t)));
                        }
                        this.eliminarPNodoGrafico(extremoIniPNode);
                    }
                    return bCoherente;
                }
            }
        }
        return true;
    }

    public void igualarTamanioGraficos(int propiedad, PNodoGrafico graficoReferencia) {
        if (this.diagrama == null) {
            return;
        }
        if (this.getSelectionEventHandler() == null) {
            return;
        }
        if (!(this.getSelectionEventHandler() instanceof PSelectionEventHandler)) {
            return;
        }
        if (((PSelectionEventHandler)this.getSelectionEventHandler()).getSelection() == null) {
            return;
        }
        if (((PSelectionEventHandler)this.getSelectionEventHandler()).getSelection().size() < 2) {
            return;
        }
        ArrayList graficosSel = new ArrayList();
        if (graficoReferencia instanceof FasePNode) {
            graficosSel = this.obtenerGraficosSeleccionados(1);
            if (graficosSel == null) {
                return;
            }
            if (graficosSel.size() < 2) {
                return;
            }
        } else if (graficoReferencia instanceof PostItPNode) {
            graficosSel = this.obtenerGraficosPostItSeleccionados();
            if (graficosSel == null) {
                return;
            }
            if (graficosSel.size() < 2) {
                return;
            }
        } else {
            graficosSel = this.obtenerGraficosCircularesSeleccionados();
            if (graficosSel == null) {
                return;
            }
            if (graficosSel.size() < 2) {
                return;
            }
        }
        PNodoGrafico graficoAux = null;
        for (int n = 0; n < graficosSel.size(); ++n) {
            graficoAux = (PNodoGrafico)graficosSel.get(n);
            if (propiedad == 1) {
                graficoAux.setWidth(graficoReferencia.getWidth());
            } else if (propiedad == 2) {
                graficoAux.setHeight(graficoReferencia.getHeight());
            } else if (propiedad == 3) {
                graficoAux.setWidth(graficoReferencia.getWidth());
                graficoAux.setHeight(graficoReferencia.getHeight());
            }
            graficoAux.repaint();
            if (!(graficoAux instanceof FasePNode)) continue;
            ((FasePNode)graficoAux).posicionarIconosHijos();
        }
    }

    public void alinearGraficos(int posicion, PNodoGrafico graficoReferencia) {
        if (this.diagrama == null) {
            return;
        }
        if (this.getSelectionEventHandler() == null) {
            return;
        }
        if (!(this.getSelectionEventHandler() instanceof PSelectionEventHandler)) {
            return;
        }
        if (((PSelectionEventHandler)this.getSelectionEventHandler()).getSelection() == null) {
            return;
        }
        if (((PSelectionEventHandler)this.getSelectionEventHandler()).getSelection().size() < 2) {
            return;
        }
        ArrayList graficosSel = this.obtenerGraficosSeleccionados(-1);
        if (graficosSel == null) {
            return;
        }
        if (graficosSel.size() < 2) {
            return;
        }
        PNodoGrafico graficoAux = null;
        for (int n = 0; n < graficosSel.size(); ++n) {
            graficoAux = (PNodoGrafico)graficosSel.get(n);
            if (posicion == 1) {
                graficoAux.setOffset(graficoReferencia.getXOffset(), graficoAux.getYOffset());
                graficoAux.setX(graficoReferencia.getX());
            } else if (posicion == 2) {
                graficoAux.setOffset(graficoReferencia.getXOffset(), graficoAux.getYOffset());
                graficoAux.setX(graficoReferencia.getX() + graficoReferencia.getWidth() / 2.0 - graficoAux.getWidth() / 2.0);
            } else if (posicion == 3) {
                graficoAux.setOffset(graficoReferencia.getXOffset(), graficoAux.getYOffset());
                graficoAux.setX(graficoReferencia.getX() + graficoReferencia.getWidth() - graficoAux.getWidth());
            }
            if (posicion == 4) {
                graficoAux.setOffset(graficoAux.getXOffset(), graficoReferencia.getYOffset());
                graficoAux.setY(graficoReferencia.getY());
            } else if (posicion == 5) {
                graficoAux.setOffset(graficoAux.getXOffset(), graficoReferencia.getYOffset());
                graficoAux.setY(graficoReferencia.getY() + graficoReferencia.getHeight() / 2.0 - graficoAux.getHeight() / 2.0);
            } else if (posicion == 6) {
                graficoAux.setOffset(graficoAux.getXOffset(), graficoReferencia.getYOffset());
                graficoAux.setY(graficoReferencia.getY() + graficoReferencia.getHeight() - graficoAux.getHeight());
            }
            graficoAux.repaint();
            if (!(graficoAux instanceof FasePNode)) continue;
            ((FasePNode)graficoAux).posicionarIconosHijos();
        }
    }

    public void eliminarFasesSeleccionadas() {
        PNodoGrafico graficoAux = null;
        if (this.getSelectionEventHandler() == null) {
            return;
        }
        if (!(this.getSelectionEventHandler() instanceof PSelectionEventHandlerEx)) {
            return;
        }
        if (((PSelectionEventHandler)this.getSelectionEventHandler()).getSelection() == null) {
            return;
        }
        if (((PSelectionEventHandler)this.getSelectionEventHandler()).getSelection().size() < 1) {
            return;
        }
        if (this.getAccionActual() == AccionPCanvas.ACCION_SEL_LIMITADA) {
            return;
        }
        ArrayList graficosSel = this.obtenerGraficosSeleccionados(1);
        if (graficosSel == null) {
            return;
        }
        if (graficosSel.size() < 1) {
            return;
        }
        if (graficosSel.size() == 1) {
            graficoAux = (PNodoGrafico)graficosSel.get(0);
            if (graficoAux instanceof FasePNode) {
                ((FasePNode)graficoAux).eliminar();
            }
            this.actualizarGraficosDeFase();
            return;
        }
        if (graficosSel.size() > 1) {
            EliminarGraficoFaseJDialog delDialogo = new EliminarGraficoFaseJDialog();
            delDialogo.setTitle("Eliminando gr\u00e1ficos de fase");
            delDialogo.setLocationRelativeTo((Component)((Object)this));
            delDialogo.setModoTrabajo(1);
            delDialogo.setVisible(true);
            if (delDialogo.isCancelado()) {
                return;
            }
            for (int n = 0; n < graficosSel.size(); ++n) {
                graficoAux = (PNodoGrafico)graficosSel.get(n);
                if (!(graficoAux instanceof FasePNode)) continue;
                ((FasePNode)graficoAux).eliminar(delDialogo.eliminarFase(), delDialogo.eliminarTransiciones());
            }
        }
        this.actualizarGraficosDeFase();
    }

    public void eliminarTransicionesSeleccionadas() {
        PPath graficoAux = null;
        if (this.getSelectionEventHandler() == null) {
            return;
        }
        if (!(this.getSelectionEventHandler() instanceof PSelectionEventHandlerEx)) {
            return;
        }
        if (((PSelectionEventHandler)this.getSelectionEventHandler()).getSelection() == null) {
            return;
        }
        if (((PSelectionEventHandler)this.getSelectionEventHandler()).getSelection().size() < 1) {
            return;
        }
        if (this.getAccionActual() == AccionPCanvas.ACCION_SEL_LIMITADA) {
            return;
        }
        ArrayList graficosSel = this.obtenerGraficosSeleccionados(2);
        if (graficosSel == null) {
            return;
        }
        if (graficosSel.size() < 1) {
            return;
        }
        if (graficosSel.size() == 1) {
            graficoAux = (PPath)graficosSel.get(0);
            if (graficoAux instanceof TransicionPNode) {
                ((TransicionPNode)graficoAux).eliminar(null);
            }
            return;
        }
        if (graficosSel.size() > 1) {
            EliminarGraficoTransicionJDialog delDialogo = new EliminarGraficoTransicionJDialog();
            delDialogo.setTitle("Eliminando gr\u00e1ficos de transici\u00f3n");
            delDialogo.setLocationRelativeTo((Component)((Object)this));
            delDialogo.setModoTrabajo(1);
            delDialogo.setVisible(true);
            if (delDialogo.isCancelado()) {
                return;
            }
            for (int n = 0; n < graficosSel.size(); ++n) {
                graficoAux = (PPath)graficosSel.get(n);
                if (!(graficoAux instanceof TransicionPNode)) continue;
                ((TransicionPNode)graficoAux).eliminar(delDialogo.eliminarTransicion(), delDialogo.eliminarTransicionDefProc());
            }
        }
    }

    public int printPLayer(Graphics graphics, PageFormat pageFormat, int pageIndex, PLayer layer, int despl, int desplPie) {
        double anchoDeFolioEnCanvas;
        if (pageIndex != 0) {
            ((Object)((Object)this)).getClass();
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics;
        PBounds imageBounds = layer.getFullBounds();
        double offSet = 0.0;
        imageBounds.setRect(imageBounds.getX() - 10.0, imageBounds.getY() - 10.0, imageBounds.getWidth() + 20.0, imageBounds.getHeight() + 20.0);
        imageBounds.expandNearestIntegerDimensions();
        g2.translate(0, despl);
        g2.setClip(0, 0, (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight() - despl);
        g2.drawRect(0, 3, (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight() - despl - desplPie - 3);
        double scale = 1.0;
        double scaleAux = 1.0;
        double anchoGrafico = 1.0;
        if (pageFormat.getOrientation() == 1) {
            scale = pageFormat.getImageableWidth() / (imageBounds.getWidth() + 20.0);
            scaleAux = (pageFormat.getImageableHeight() - (double)despl - (double)desplPie) / (imageBounds.getHeight() + 20.0);
            if (scaleAux < scale) {
                scale = scaleAux;
            }
            anchoGrafico = scale * (imageBounds.getWidth() + 20.0);
            anchoDeFolioEnCanvas = (imageBounds.getWidth() + 20.0) * pageFormat.getImageableWidth() / anchoGrafico;
            offSet = (anchoDeFolioEnCanvas - (imageBounds.getWidth() + 20.0)) / 2.0;
        } else if (pageFormat.getOrientation() == 0) {
            scale = (pageFormat.getImageableHeight() - (double)despl - (double)desplPie) / (imageBounds.getHeight() + 20.0);
            scaleAux = pageFormat.getImageableWidth() / (imageBounds.getWidth() + 20.0);
            if (scaleAux < scale) {
                scale = scaleAux;
            }
            anchoGrafico = scale * (imageBounds.getWidth() + 20.0);
            anchoDeFolioEnCanvas = (imageBounds.getWidth() + 20.0) * pageFormat.getImageableWidth() / anchoGrafico;
            offSet = (anchoDeFolioEnCanvas - (imageBounds.getWidth() + 20.0)) / 2.0;
        }
        g2.scale(scale, scale);
        g2.translate(-imageBounds.x + (double)((int)offSet), -imageBounds.y);
        PPaintContext pc = new PPaintContext(g2);
        pc.setRenderQuality(1);
        layer.fullPaint(pc);
        return this.PAGE_EXISTS;
    }

    public void eliminarPostItSeleccionados() {
        PNodoGrafico graficoAux = null;
        if (this.getSelectionEventHandler() == null) {
            return;
        }
        if (!(this.getSelectionEventHandler() instanceof PSelectionEventHandlerEx)) {
            return;
        }
        if (((PSelectionEventHandler)this.getSelectionEventHandler()).getSelection() == null) {
            return;
        }
        if (((PSelectionEventHandler)this.getSelectionEventHandler()).getSelection().size() < 1) {
            return;
        }
        if (this.getAccionActual() == AccionPCanvas.ACCION_SEL_LIMITADA) {
            return;
        }
        ArrayList graficosSel = this.obtenerGraficosSeleccionados(9);
        if (graficosSel == null) {
            return;
        }
        if (graficosSel.size() < 1) {
            return;
        }
        for (int n = 0; n < graficosSel.size(); ++n) {
            graficoAux = (PNodoGrafico)graficosSel.get(n);
            if (!(graficoAux instanceof PostItPNode)) continue;
            ((PostItPNode)graficoAux).eliminar();
        }
    }

    public void eliminarToolTipsSeleccionados() {
        PToolTipText graficoAux = null;
        if (this.getSelectionEventHandler() == null) {
            return;
        }
        if (!(this.getSelectionEventHandler() instanceof PSelectionEventHandlerEx)) {
            return;
        }
        if (((PSelectionEventHandler)this.getSelectionEventHandler()).getSelection() == null) {
            return;
        }
        if (((PSelectionEventHandler)this.getSelectionEventHandler()).getSelection().size() < 1) {
            return;
        }
        if (this.getAccionActual() == AccionPCanvas.ACCION_SEL_LIMITADA) {
            return;
        }
        ArrayList graficosSel = this.obtenerGraficosSeleccionados(10);
        if (graficosSel == null) {
            return;
        }
        if (graficosSel.size() < 1) {
            return;
        }
        for (int n = 0; n < graficosSel.size(); ++n) {
            graficoAux = (PToolTipText)((Object)graficosSel.get(n));
            if (!(graficoAux instanceof PToolTipText)) continue;
            graficoAux.eliminar();
        }
    }
}

