/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.piccolo.handlers;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.util.ArrayList;
import java.util.List;
import modela.bd.obj.ConjuntoDatosFase;
import modela.bd.obj.CreadorRapidoGraficos;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrFaseGr;
import modela.bd.obj.TrMetafase;
import modela.ui.piccolo.PCanvasModela;
import modela.ui.piccolo.events.GraficoGeneradoEvent;
import modela.ui.piccolo.events.GraficoGeneradoListener;
import modela.ui.piccolo.handlers.PSelectionEventHandlerEx;
import modela.ui.piccolo.nodes.FasePNode;

public class FaseCreationEventHandler
extends PSelectionEventHandlerEx {
    private FasePNode graficoDeFase = null;
    private TrFase fase = null;
    private PCanvasModela canvas = null;
    private transient ArrayList GraficoGeneradoListeners = new ArrayList(2);

    public FaseCreationEventHandler(PNode param1, PNode param2, PCanvasModela pCanvas) {
        super(param1, param2);
        this.canvas = pCanvas;
        this.graficoDeFase = null;
        this.fase = null;
    }

    public void cancelarProceso(PInputEvent e) {
        this.fase = null;
        this.graficoDeFase = null;
    }

    public void mousePressed(PInputEvent e) {
        PNode p;
        if (e.getButton() == 3) {
            this.cancelarProceso(e);
            return;
        }
        if (e.getButton() == 1 && !((p = e.getPickedNode()) instanceof PCamera)) {
            this.cancelarProceso(e);
            return;
        }
        if (this.canvas == null) {
            this.cancelarProceso(e);
            return;
        }
        this.graficoDeFase = new FasePNode(this.canvas);
        this.graficoDeFase.setX(e.getPosition().getX() - this.graficoDeFase.getGlobalBounds().getWidth() / 2.0);
        this.graficoDeFase.setY(e.getPosition().getY() - this.graficoDeFase.getGlobalBounds().getHeight() / 2.0);
        if (this.canvas.getDiagrama() == null) {
            this.cancelarProceso(e);
            return;
        }
        TrMetafase metaActiva = null;
        metaActiva = this.canvas.getDiagrama().obtenerMetafaseActiva();
        if (metaActiva == null) {
            this.cancelarProceso(e);
            return;
        }
        this.fase = CreadorRapidoGraficos.crearFase((ConjuntoDatosFase)this.canvas.getDiagrama().getFasesInvolucradas(), metaActiva);
        if (this.fase == null) {
            this.cancelarProceso(e);
            return;
        }
        this.canvas.getDiagrama().getFasesInvolucradas().add(this.fase);
        TrFaseGr faseGr = new TrFaseGr();
        faseGr.setTrFase(this.fase);
        this.graficoDeFase.setFaseGraficaAsociada(faseGr);
        GraficoGeneradoEvent ggE = new GraficoGeneradoEvent((Object)this);
        this.graficoDeFase.setPickable(true);
        ggE.setTipo(1);
        ggE.setGraficoGenerado(this.graficoDeFase);
        this.fireGraficoGenerado(ggE);
        this.cancelarProceso(e);
    }

    public synchronized void addGraficoGeneradoListener(GraficoGeneradoListener l) {
        if (!this.GraficoGeneradoListeners.contains(l)) {
            this.GraficoGeneradoListeners.add(l);
        }
    }

    public synchronized void removeGraficoGeneradoListener(GraficoGeneradoListener l) {
        this.GraficoGeneradoListeners.remove(l);
    }

    protected void fireGraficoGenerado(GraficoGeneradoEvent e) {
        List listeners = (List)this.GraficoGeneradoListeners.clone();
        int count = listeners.size();
        for (int i = 0; i < count; ++i) {
            ((GraficoGeneradoListener)listeners.get(i)).obtenerGraficoGenerado(e);
        }
    }
}

