/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.piccolo.handlers;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import modela.bd.obj.TrFaseGr;
import modela.conf.ModelaConf;
import modela.ui.piccolo.PCanvasModela;
import modela.ui.piccolo.events.GraficoGeneradoEvent;
import modela.ui.piccolo.events.GraficoGeneradoListener;
import modela.ui.piccolo.handlers.PGrTransicionEventHandler;
import modela.ui.piccolo.nodes.FasePNode;
import modela.ui.piccolo.nodes.PNodoGrafico;
import modela.ui.piccolo.nodes.PostItPNode;
import modela.ui.piccolo.nodes.TransicionPNode;
import modela.ui.piccolo.nodes.UnionPNode;

public class TransicionUnionCreationEventHandler
extends PGrTransicionEventHandler {
    protected TransicionPNode tr = null;
    protected UnionPNode faseGIni = null;
    protected FasePNode faseGFin = null;
    private TransicionPNode trNew = null;
    private Point2D pInicial = null;
    private transient ArrayList GraficoGeneradoListeners = new ArrayList(2);

    public TransicionUnionCreationEventHandler(PNode param1, PNode param2, PCanvasModela pCanvas) {
        super(param1, param2, pCanvas);
    }

    public void cancelarProceso(PInputEvent e) {
        this.eliminarPath();
        this.eliminarLayer(e);
        this.pInicial = null;
        this.trNew = null;
    }

    public void mouseMoved(PInputEvent e) {
        if (this.trNew == null) {
            return;
        }
        this.faseGIni.repaint();
        this.trNew.updateBounds();
        this.trNew.repaint();
        this.dragPoint = e.getPosition();
        this.updateRectangle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mousePressed(PInputEvent e) {
        Point2D pActual = null;
        if (e.getButton() == 3) {
            this.cancelarProceso(e);
            return;
        }
        if (e.getButton() != 1) return;
        this.eliminarPath();
        this.pressPoint = e.getPosition();
        if (e.getClickCount() > 1) {
            if (e.getPickedNode() instanceof PNodoGrafico && !(e.getPickedNode() instanceof PostItPNode)) {
                PNode evaluarFinal;
                if (this.trNew == null) {
                    return;
                }
                if (this.trNew.getTrTransicion() != null && !((evaluarFinal = e.getPickedNode()) instanceof FasePNode)) {
                    this.cancelarProceso(e);
                    return;
                }
                this.faseGFin = (FasePNode)e.getPickedNode();
                if (this.faseGIni.getTrFaseGrAsociada() != null && this.faseGFin.getTrFaseGrAsociada() != null) {
                    this.faseGIni.getTrFaseGrAsociada().setTrFase(this.faseGFin.getTrFaseGrAsociada().getTrFase());
                }
                this.trNew.setPNodoGraficoFaseFin(this.faseGFin);
                System.out.println("- [ Info ] Transici\u00f3n creada: " + this.trNew);
                this.trNew.setPickable(true);
                ModelaConf.setCreacionRapidaTransiciones(false);
                if ((e.getModifiers() & 2) != 0) {
                    ModelaConf.setCreacionRapidaTransiciones(true);
                }
            } else {
                this.cancelarProceso(e);
                return;
            }
            GraficoGeneradoEvent ggE = new GraficoGeneradoEvent((Object)this);
            ggE.setTipo(4);
            ggE.setGraficoGenerado(this.trNew);
            this.fireGraficoGenerado(ggE);
            this.cancelarProceso(e);
            return;
        }
        pActual = e.getPosition();
        this.crearPath(e);
        if (this.trNew == null) {
            if (e.getPickedNode() instanceof PNodoGrafico) return;
            this.trNew = new TransicionPNode("U", this.getCanvas());
            this.trNew.setPickable(false);
            this.crearLayer(e);
            this.crearPath(e);
            this.pInicial = pActual;
            this.faseGIni = new UnionPNode(this.getCanvas());
            TrFaseGr faseGr = new TrFaseGr();
            this.faseGIni.setFaseGraficaAsociada(faseGr);
            this.trNew.setPNodoGraficoFaseIni(this.faseGIni);
            this.layer.addChild((PNode)this.trNew);
            this.layer.addChild((PNode)this.faseGIni);
            this.faseGIni.centerBoundsOnPoint(pActual.getX() + this.faseGIni.getBounds().getWidth() / 2.0 + 1.0, pActual.getY());
            this.trNew.getPoints2D().addElement(this.pInicial.clone());
            this.trNew.updateBounds();
            this.faseGIni.repaint();
            return;
        } else if (this.trNew != null) {
            this.trNew.getPoints2D().addElement(pActual.clone());
            this.trNew.updateBounds();
            this.trNew.repaint();
            return;
        } else {
            this.cancelarProceso(e);
            return;
        }
    }

    public synchronized void addGraficoGeneradoListener(GraficoGeneradoListener l) {
        if (!this.GraficoGeneradoListeners.contains(l)) {
            this.GraficoGeneradoListeners.add(l);
        }
    }

    public synchronized void removeGraficoGeneradoListener(GraficoGeneradoListener l) {
        this.GraficoGeneradoListeners.remove(l);
    }

    protected void fireGraficoGenerado(GraficoGeneradoEvent e) {
        List listeners = (List)this.GraficoGeneradoListeners.clone();
        int count = listeners.size();
        for (int i = 0; i < count; ++i) {
            ((GraficoGeneradoListener)listeners.get(i)).obtenerGraficoGenerado(e);
        }
    }
}

