/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.piccolo.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import modela.bd.obj.TrFaseGr;
import modela.graf.CreadorXMLDefProc;
import modela.ui.piccolo.PCanvasModela;
import modela.ui.piccolo.nodes.PostItPNode;
import modela.ui.piccolo.nodes.RepGraficaNodo;
import modela.ui.piccolo.nodes.TransicionPNode;

public class PNodoGrafico
extends PNode
implements RepGraficaNodo {
    private static final long serialVersionUID = 3842658665382083616L;
    protected PCanvasModela canvas = null;
    public static final int GRAFICO_EXTENDIDOS_DE_PNODOGRAFICO = -1;
    public static final int GRAFICO_EXTENDIDOS_DE_PPATH = -2;
    public static final int GRAFICO_NODO_FASE = 1;
    public static final int GRAFICO_TRANSICION = 2;
    public static final int GRAFICO_NODO_DIVISION = 3;
    public static final int GRAFICO_NODO_UNION = 4;
    public static final int GRAFICO_NODO_EVENTO_SALIDA = 5;
    public static final int GRAFICO_NODO_EVENTO_SIN_SALIDA = 6;
    public static final int GRAFICO_NODO_INICIO_PROCEDIMIENTO = 7;
    public static final int GRAFICO_NODO_FIN_PROCEDIMINETO = 8;
    public static final int GRAFICO_NODO_POST_IT = 9;
    public static final int GRAFICO_NODO_TOOL_TIP = 10;
    public static final String TIPO_GRAFICO_NODO_FASE = "FA";
    public static final String TIPO_GRAFICO_NODO_DIVISION = "D";
    public static final String TIPO_GRAFICO_NODO_UNION = "U";
    public static final String TIPO_GRAFICO_NODO_EVENTO_SALIDA = "ES";
    public static final String TIPO_GRAFICO_NODO_EVENTO_SIN_SALIDA = "EN";
    public static final String TIPO_GRAFICO_NODO_INICIO_PROCEDIMIENTO = "I";
    public static final String TIPO_GRAFICO_NODO_FIN_PROCEDIMIENTO = "F";
    public static final String TIPO_GRAFICO_NODO_POST_IT = "PI";
    public static final String TIPO_GRAFICO_NODO_TOOL_TIP = "TT";
    protected TrFaseGr faseGraficaAsociada;
    protected String sTexto = "Sin descripci\u00f3n";
    protected String sTipo = "FA";
    protected ArrayList transicionesEntrada = null;
    protected ArrayList transicionesSalida = null;
    protected Color colorFondo;
    protected Color colorTexto;
    protected Color colorBorde;
    protected PBounds boundAnterior = null;
    protected JPopupMenu popup = null;
    protected JMenuItem menuProp = null;
    protected JMenuItem menuPropGr = null;
    private JMenu subMenuAlinear = null;
    private JMenuItem menuAlinearIzquierda = null;
    private JMenuItem menuAlinearCentro = null;
    private JMenuItem menuAlinearDerecha = null;
    private JMenuItem menuAlinearSuperior = null;
    private JMenuItem menuAlinearMedio = null;
    private JMenuItem menuAlinearInferior = null;
    private JMenu subMenuIgualarSize = null;
    private JMenuItem menuIgualarAncho = null;
    private JMenuItem menuIgualarAlto = null;
    private JMenuItem menuIgualarAmbos = null;
    protected JMenuItem menuAddPostIt = null;
    protected Stroke stroke;
    int sizeFuenteTexto = 15;
    int posXTexto = 120;
    int posYTexto = 120;
    int nFontHeight;
    Image imagenNodo = null;
    ArrayList arrPalabras = null;
    ArrayList arrLongitudSegmento = null;
    ArrayList arrLineas = null;
    JFiltroTextField textEdit = new JFiltroTextField();
    boolean bEnEdicion = false;
    float nSizeLetraEdicion = 14.0f;
    protected ArrayList arrPostItAsociados = null;
    int nNotasActualmenteSeleccionadas = 0;

    public PNodoGrafico() {
        this.stroke = new BasicStroke(1.0f, 1, 1);
        this.transicionesEntrada = new ArrayList();
        this.transicionesSalida = new ArrayList();
        this.arrPostItAsociados = new ArrayList();
        this.colorFondo = Color.white;
        this.colorTexto = Color.black;
        this.colorBorde = Color.black;
    }

    public void reposicionarGraficosAsociados() {
        TransicionPNode trPNode;
        int k = 0;
        if (!this.cambiaBounds()) {
            return;
        }
        if (this.transicionesEntrada != null) {
            for (k = 0; k < this.transicionesEntrada.size(); ++k) {
                trPNode = (TransicionPNode)this.transicionesEntrada.get(k);
                trPNode.readaptarBounds();
            }
        }
        if (this.transicionesSalida != null) {
            for (k = 0; k < this.transicionesSalida.size(); ++k) {
                trPNode = (TransicionPNode)this.transicionesSalida.get(k);
                trPNode.readaptarBounds();
            }
        }
        if (this.arrPostItAsociados != null) {
            for (k = 0; k < this.arrPostItAsociados.size(); ++k) {
                PostItPNode postIt = (PostItPNode)this.arrPostItAsociados.get(k);
                postIt.setVisible(true);
                postIt.readaptarBounds();
            }
        }
    }

    public void addTransicionEntrada(TransicionPNode trPNode) {
        this.transicionesEntrada.add(trPNode);
    }

    public void addTransicionSalida(TransicionPNode trPNode) {
        this.transicionesSalida.add(trPNode);
    }

    public TrFaseGr getTrFaseGrAsociada() {
        return this.faseGraficaAsociada;
    }

    public void setFaseGraficaAsociada(TrFaseGr nuevaFase) {
        this.faseGraficaAsociada = nuevaFase;
    }

    public String getTipo() {
        return this.sTipo;
    }

    public void inicializarBounds() {
        int l = this.sTexto.length();
        double dX = 120.0;
        double dY = 120.0;
        double dWidth = 15.0 + 9.0 * (double)l;
        double dHeight = 30.0;
        this.setBounds(dX, dY, dWidth, dHeight);
    }

    public void inicializarBounds(double dX, double dY, double dWidth, double dHeight) {
        if (dWidth == 0.0 && dHeight == 0.0 && dX == 0.0 && dY == 0.0) {
            this.inicializarBounds();
            return;
        }
        this.setBounds(dX, dY, dWidth, dHeight);
    }

    public void setTexto(String str) {
        this.sTexto = str;
    }

    public String getTexto() {
        return this.sTexto;
    }

    public String toXMLCabecera() {
        String strXML = null;
        if (this.faseGraficaAsociada == null) {
            return null;
        }
        if (this.faseGraficaAsociada.getID() == null) {
            return null;
        }
        if (this.faseGraficaAsociada.getTrFase() == null) {
            return null;
        }
        if (this.faseGraficaAsociada.getTrFase().getFASEID() == null) {
            return null;
        }
        strXML = "<EXTREMOTRAN_GR id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(this.faseGraficaAsociada.getID().longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " tipo=" + CreadorXMLDefProc.COMILLAS_DOBLES + this.sTipo + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " fase_id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(this.faseGraficaAsociada.getTrFase().getFASEID().longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES;
        PBounds bounds = this.getFullBounds();
        Point2D pt = bounds.getOrigin();
        Dimension2D dim = bounds.getSize();
        strXML = strXML + " xizq=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf((long)pt.getX()) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " yarr=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf((long)pt.getY()) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " ancho=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf((long)dim.getWidth()) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " alto=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf((long)dim.getHeight()) + CreadorXMLDefProc.COMILLAS_DOBLES;
        if (this.faseGraficaAsociada.getColorFondo() != null) {
            strXML = strXML + " color_fondo=" + CreadorXMLDefProc.COMILLAS_DOBLES + this.faseGraficaAsociada.getColorFondo().getRGB() + CreadorXMLDefProc.COMILLAS_DOBLES;
        }
        if (this.faseGraficaAsociada.getColorTexto() != null) {
            strXML = strXML + " color_texto=" + CreadorXMLDefProc.COMILLAS_DOBLES + this.faseGraficaAsociada.getColorTexto().getRGB() + CreadorXMLDefProc.COMILLAS_DOBLES;
        }
        strXML = strXML + "/>";
        return strXML;
    }

    public boolean cambiaBounds() {
        if (this.boundAnterior == null) {
            this.boundAnterior = this.getGlobalFullBounds();
            return true;
        }
        PBounds boundsAux = this.getGlobalFullBounds();
        if (boundsAux.equals((Object)this.boundAnterior)) {
            return false;
        }
        this.boundAnterior = this.getGlobalFullBounds();
        return true;
    }

    public boolean crearPopupMenu() {
        this.eliminarPopupMenu();
        this.popup = new JPopupMenu();
        this.subMenuAlinear = new JMenu("Alinear");
        this.menuAlinearIzquierda = new JMenuItem("Izquierda");
        this.menuAlinearCentro = new JMenuItem("Centro");
        this.menuAlinearDerecha = new JMenuItem("Derecha");
        this.menuAlinearSuperior = new JMenuItem("Superior");
        this.menuAlinearMedio = new JMenuItem("Medio");
        this.menuAlinearInferior = new JMenuItem("Inferior");
        this.subMenuIgualarSize = new JMenu("Igualar tama\u00f1o");
        this.menuIgualarAncho = new JMenuItem("Ancho");
        this.menuIgualarAlto = new JMenuItem("Alto");
        this.menuIgualarAmbos = new JMenuItem("Ambos");
        this.menuAddPostIt = new JMenuItem("Asociar nota");
        this.menuAlinearIzquierda.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNodoGrafico.this.alinear(1);
            }
        });
        this.menuAlinearCentro.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNodoGrafico.this.alinear(2);
            }
        });
        this.menuAlinearDerecha.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNodoGrafico.this.alinear(3);
            }
        });
        this.menuAlinearSuperior.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNodoGrafico.this.alinear(4);
            }
        });
        this.menuAlinearMedio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNodoGrafico.this.alinear(5);
            }
        });
        this.menuAlinearInferior.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNodoGrafico.this.alinear(6);
            }
        });
        this.menuIgualarAncho.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNodoGrafico.this.igualar(1);
            }
        });
        this.menuIgualarAlto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNodoGrafico.this.igualar(2);
            }
        });
        this.menuIgualarAmbos.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNodoGrafico.this.igualar(3);
            }
        });
        this.menuAddPostIt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNodoGrafico.this.addPostIt();
            }
        });
        this.subMenuAlinear.add(this.menuAlinearIzquierda);
        this.subMenuAlinear.add(this.menuAlinearCentro);
        this.subMenuAlinear.add(this.menuAlinearDerecha);
        this.subMenuAlinear.addSeparator();
        this.subMenuAlinear.add(this.menuAlinearSuperior);
        this.subMenuAlinear.add(this.menuAlinearMedio);
        this.subMenuAlinear.add(this.menuAlinearInferior);
        this.popup.add(this.subMenuAlinear);
        this.subMenuIgualarSize.add(this.menuIgualarAlto);
        this.subMenuIgualarSize.add(this.menuIgualarAncho);
        this.subMenuIgualarSize.add(this.menuIgualarAmbos);
        this.popup.add(this.subMenuIgualarSize);
        this.popup.addSeparator();
        this.popup.add(this.menuAddPostIt);
        return true;
    }

    public void eliminarPopupMenu() {
        ActionListener[] actionListener = null;
        int nActions = 0;
        int i = 0;
        this.popup = null;
        if (this.menuAlinearIzquierda != null) {
            actionListener = this.menuAlinearIzquierda.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuAlinearIzquierda.removeActionListener(actionListener[i]);
            }
            this.menuAlinearIzquierda = null;
        }
        if (this.menuAlinearCentro != null) {
            actionListener = this.menuAlinearCentro.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuAlinearCentro.removeActionListener(actionListener[i]);
            }
            this.menuAlinearCentro = null;
        }
        if (this.menuAlinearDerecha != null) {
            actionListener = this.menuAlinearDerecha.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuAlinearDerecha.removeActionListener(actionListener[i]);
            }
            this.menuAlinearDerecha = null;
        }
        if (this.menuAlinearSuperior != null) {
            actionListener = this.menuAlinearSuperior.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuAlinearSuperior.removeActionListener(actionListener[i]);
            }
            this.menuAlinearSuperior = null;
        }
        if (this.menuAlinearMedio != null) {
            actionListener = this.menuAlinearMedio.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuAlinearMedio.removeActionListener(actionListener[i]);
            }
            this.menuAlinearMedio = null;
        }
        if (this.menuAlinearInferior != null) {
            actionListener = this.menuAlinearInferior.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuAlinearInferior.removeActionListener(actionListener[i]);
            }
            this.menuAlinearInferior = null;
        }
        if (this.subMenuAlinear != null) {
            actionListener = this.subMenuAlinear.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.subMenuAlinear.removeActionListener(actionListener[i]);
            }
            this.subMenuAlinear = null;
        }
        if (this.menuIgualarAlto != null) {
            actionListener = this.menuIgualarAlto.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuIgualarAlto.removeActionListener(actionListener[i]);
            }
            this.menuIgualarAlto = null;
        }
        if (this.menuIgualarAncho != null) {
            actionListener = this.menuIgualarAncho.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuIgualarAncho.removeActionListener(actionListener[i]);
            }
            this.menuIgualarAncho = null;
        }
        if (this.menuIgualarAmbos != null) {
            actionListener = this.menuIgualarAmbos.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuIgualarAmbos.removeActionListener(actionListener[i]);
            }
            this.menuIgualarAmbos = null;
        }
        if (this.subMenuIgualarSize != null) {
            actionListener = this.subMenuIgualarSize.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.subMenuIgualarSize.removeActionListener(actionListener[i]);
            }
            this.subMenuIgualarSize = null;
        }
        if (this.menuAddPostIt != null) {
            actionListener = this.menuAddPostIt.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuAddPostIt.removeActionListener(actionListener[i]);
            }
            this.menuAddPostIt = null;
        }
    }

    public void alinear(int posicion) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.alinearGraficos(posicion, this);
    }

    public void igualar(int propiedad) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.igualarTamanioGraficos(propiedad, this);
    }

    public boolean isEditando() {
        return this.bEnEdicion;
    }

    public void addPostIt() {
        PostItPNode notaRapida = new PostItPNode(this.canvas, this);
        this.arrPostItAsociados.add(notaRapida);
        this.canvas.getLayer().addChild((PNode)notaRapida);
        notaRapida.editarTextoPostIt();
        System.out.println("\u00b7 [ Info ] PostIt asociado al gr\u00e1fico: " + this.toString());
    }

    public void addPostIt(PostItPNode notaRapida) {
        if (notaRapida == null) {
            return;
        }
        this.arrPostItAsociados.add(notaRapida);
        this.canvas.getLayer().addChild((PNode)notaRapida);
        System.out.println("\u00b7 [ Info ] PostIt asociado al gr\u00e1fico: " + this.toString());
    }

    public void removePostIt(PostItPNode notaRapida) {
        this.arrPostItAsociados.remove(notaRapida);
    }

    public void removeAllPostIt() {
        if (this.canvas == null) {
            return;
        }
        if (this.arrPostItAsociados == null) {
            return;
        }
        for (int i = this.arrPostItAsociados.size() - 1; i >= 0; --i) {
            this.arrPostItAsociados.remove(i);
        }
    }

    public ArrayList getListaPostIt() {
        return this.arrPostItAsociados;
    }

    public PCanvasModela getCanvasAsociado() {
        return this.canvas;
    }

    public void setColorFondo(Color nuevoColor) {
        this.colorFondo = nuevoColor;
    }

    public Color getColorFondo() {
        return this.colorFondo;
    }

    public void setColorBorde(Color nuevoColor) {
        this.colorBorde = nuevoColor;
    }

    public Color getColorBorde() {
        return this.colorBorde;
    }

    public void setColorTexto(Color nuevoColor) {
        this.colorTexto = nuevoColor;
    }

    public Color getColorTexto() {
        return this.colorTexto;
    }

    public int getNumNotasActualmenteSeleccionadas() {
        return this.nNotasActualmenteSeleccionadas;
    }

    public void actualizarNumNotasActualmenteSeleccionadas(int pValor) {
        this.nNotasActualmenteSeleccionadas += pValor;
        if (this.nNotasActualmenteSeleccionadas < 0) {
            this.nNotasActualmenteSeleccionadas = 0;
        }
    }
}

