/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.piccolo.nodes;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.event.PSelectionEventHandler;
import gdtel.ui.graf.Geometria;
import gdtel.ui.graf.grafobjects.FlechaShp;
import gdtel.ui.piccolo.AccionPCanvas;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import gdtel.util.GeneradorID;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrNodoGr;
import modela.bd.obj.TrPlazoCompuestoDefProc;
import modela.bd.obj.TrPlazoSimple;
import modela.bd.obj.TrTransicion;
import modela.bd.obj.TrTransicionDefProcedimiento;
import modela.bd.obj.TrTransicionGr;
import modela.conf.ModelaConf;
import modela.graf.CreadorXMLDefProc;
import modela.ui.piccolo.PCanvasModela;
import modela.ui.piccolo.PPointLocator;
import modela.ui.piccolo.handlers.PNodeHandle;
import modela.ui.piccolo.handlers.PSelectionEventHandlerEx;
import modela.ui.piccolo.nodes.DivisionPNode;
import modela.ui.piccolo.nodes.FasePNode;
import modela.ui.piccolo.nodes.ImagenPNode;
import modela.ui.piccolo.nodes.PNodoGrafico;
import modela.ui.piccolo.nodes.RepGraficaNodo;
import modela.ui.piccolo.nodes.UnionPNode;
import modela.ui.swing.EliminarGraficoTransicionJDialog;
import modela.ui.swing.OcurrenciasTransicionJpanel;
import modela.ui.swing.PropGraficoTransicion;

public class TransicionPNode
extends PPath
implements Cloneable,
RepGraficaNodo {
    private static final long serialVersionUID = 326310613708049509L;
    boolean bMostrarDireccion;
    Color colorLinea;
    boolean bMostrarTooltip;
    protected Stroke stroke;
    private Vector points2D = null;
    private PPointLocator locator;
    private final TrTransicionGr graficoTransicion;
    protected TrTransicion trTransicion;
    protected PCanvasModela canvas = null;
    private PNodoGrafico pNodoGraficofaseInicial;
    private PNodoGrafico pNodoGraficofaseFinal;
    private JPopupMenu popup = null;
    private JMenuItem menuInsertarPunto = null;
    private JMenuItem menuEliminarPunto = null;
    private JMenuItem menuProp = null;
    private JMenuItem menuPropGr = null;
    private JMenuItem menuAccion = null;
    private JMenuItem menuCondicion = null;
    private JMenuItem menuAviso = null;
    private JMenuItem menuPermiso = null;
    private JMenuItem menuPlazoSimple = null;
    private JMenuItem menuEliminarGr = null;
    private JMenuItem menuCambiarFaseIni = null;
    private JMenuItem menuCambiarFaseFin = null;
    private JCheckBoxMenuItem menuValida = null;
    static final PText tooltipNode = new PText();
    protected PText pTextEtiqueta = new PText();
    private Point2D ptPulsacion = null;
    private PNode nodoPulsado = null;
    private ImagenPNode accionPNode = null;
    private ImagenPNode condicionPNode = null;
    private ImagenPNode avisoPNode = null;
    private ImagenPNode perfilAvisoPNode = null;
    private ImagenPNode perfilPNode = null;
    Point2D pPuntoInicial;
    Point2D pPuntoFinal;
    protected static boolean bSeleccionada = false;
    private boolean bCancelarEliminarHandles = false;
    protected JFiltroTextField textEdit = new JFiltroTextField();
    private boolean bEnEdicion = false;
    private final int NUM_ELEMENTOS_MENU_NORMAL = 12;
    private boolean bPosicionarIconos = false;
    private boolean bMenuSobreNodos = false;
    boolean bCalcularDistancia = true;
    boolean bCalcularDistanciaBis = true;
    double xDistancia = 0.0;
    double yDistancia = 0.0;
    double xDistanciaBis = 0.0;
    double yDistanciaBis = 0.0;
    float nSizeLetraEdicion = 15.0f;

    public TransicionPNode(String strTipoTransicion, PCanvasModela pCanvas) {
        this.canvas = pCanvas;
        this.bPosicionarIconos = false;
        this.trTransicion = new TrTransicion();
        this.trTransicion.setTIPO(strTipoTransicion);
        this.graficoTransicion = new TrTransicionGr();
        this.locator = null;
        this.points2D = new Vector();
        this.stroke = new BasicStroke(1.0f, 1, 1);
        this.setPaint(Color.BLACK);
        this.bMostrarDireccion = true;
        this.colorLinea = Color.BLACK;
        this.bMostrarTooltip = false;
        this.bCancelarEliminarHandles = false;
        this.addInputEventListener((PInputEventListener)new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent myEvent) {
                TransicionPNode.this.onRightClick(myEvent);
            }

            public void mouseMoved(PInputEvent event) {
                if (TransicionPNode.this.bMostrarTooltip) {
                    TransicionPNode.this.updateToolTip(event);
                }
            }

            public void mouseExited(PInputEvent e) {
                tooltipNode.setText("");
            }
        });
        this.pTextEtiqueta.setPickable(false);
        this.addChild((PNode)this.pTextEtiqueta);
        tooltipNode.setPickable(false);
        this.addChild((PNode)tooltipNode);
        this.ptPulsacion = null;
        this.nodoPulsado = null;
        this.addIconosHijos();
        this.updateBounds();
        this.bCalcularDistancia = true;
        this.bCalcularDistanciaBis = true;
        this.xDistancia = 0.0;
        this.yDistancia = 0.0;
        this.xDistanciaBis = 0.0;
        this.yDistanciaBis = 0.0;
    }

    public TransicionPNode(Vector v, String strTipo, PCanvasModela pCanvas) {
        this.canvas = pCanvas;
        this.bPosicionarIconos = false;
        this.trTransicion = new TrTransicion();
        this.trTransicion.setTIPO(strTipo);
        this.graficoTransicion = new TrTransicionGr();
        this.points2D = v;
        this.locator = null;
        this.stroke = new BasicStroke(1.0f, 1, 1);
        this.setPaint(Color.BLACK);
        this.bMostrarDireccion = true;
        this.colorLinea = Color.BLACK;
        this.bMostrarTooltip = false;
        this.bCancelarEliminarHandles = false;
        this.addInputEventListener((PInputEventListener)new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent myEvent) {
                TransicionPNode.this.onRightClick(myEvent);
            }

            public void mouseMoved(PInputEvent event) {
                if (TransicionPNode.this.bMostrarTooltip) {
                    TransicionPNode.this.updateToolTip(event);
                }
            }

            public void mouseExited(PInputEvent e) {
                tooltipNode.setText("");
            }
        });
        this.pTextEtiqueta.setPickable(false);
        this.addChild((PNode)this.pTextEtiqueta);
        tooltipNode.setPickable(false);
        this.addChild((PNode)tooltipNode);
        this.ptPulsacion = null;
        this.nodoPulsado = null;
        this.addIconosHijos();
        this.updateBounds();
        this.bCalcularDistancia = true;
        this.bCalcularDistanciaBis = true;
        this.xDistancia = 0.0;
        this.yDistancia = 0.0;
        this.xDistanciaBis = 0.0;
        this.yDistanciaBis = 0.0;
    }

    public TransicionPNode(TrTransicionGr trTransicionGr, PCanvasModela pCanvas) {
        this.canvas = pCanvas;
        this.bPosicionarIconos = false;
        this.graficoTransicion = trTransicionGr;
        this.trTransicion = trTransicionGr.getTransicion();
        this.points2D = new Vector();
        ArrayList vNodos = this.graficoTransicion.getVerticesTransicion();
        if (vNodos != null) {
            for (int i = 0; i < vNodos.size(); ++i) {
                TrNodoGr nodo = (TrNodoGr)vNodos.get(i);
                this.addVerticeSiguiente(new Point2D.Double(nodo.getX(), nodo.getY()));
            }
        }
        this.locator = null;
        if (this.trTransicion != null && this.trTransicion.getVALIDA().equals("N")) {
            float[] dash = new float[]{5.0f};
            this.stroke = new BasicStroke(1.0f, 0, 2, 10.0f, dash, 0.0f);
        } else {
            this.stroke = new BasicStroke(1.0f, 1, 1);
        }
        this.setPaint(Color.BLACK);
        this.bMostrarDireccion = true;
        this.colorLinea = Color.BLACK;
        this.bMostrarTooltip = false;
        this.bCancelarEliminarHandles = false;
        this.addInputEventListener((PInputEventListener)new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent myEvent) {
                TransicionPNode.this.onRightClick(myEvent);
            }

            public void mouseMoved(PInputEvent event) {
                if (TransicionPNode.this.bMostrarTooltip) {
                    TransicionPNode.this.updateToolTip(event);
                }
            }

            public void mouseExited(PInputEvent e) {
                tooltipNode.setText("");
            }
        });
        this.pTextEtiqueta.setPickable(false);
        this.addChild((PNode)this.pTextEtiqueta);
        tooltipNode.setPickable(false);
        this.addChild((PNode)tooltipNode);
        this.ptPulsacion = null;
        this.nodoPulsado = null;
        this.addIconosHijos();
        this.updateBounds();
    }

    public void addIconosHijos() {
        this.accionPNode = new ImagenPNode(1);
        this.condicionPNode = new ImagenPNode(2);
        this.avisoPNode = new ImagenPNode(3);
        this.perfilAvisoPNode = new ImagenPNode(10);
        this.perfilPNode = new ImagenPNode(11);
        this.accionPNode.setTransicionPNode(this);
        this.condicionPNode.setTransicionPNode(this);
        this.avisoPNode.setTransicionPNode(this);
        this.perfilAvisoPNode.setTransicionPNode(this);
        this.perfilPNode.setTransicionPNode(this);
        this.accionPNode.setVisible(false);
        this.condicionPNode.setVisible(false);
        this.avisoPNode.setVisible(false);
        this.perfilAvisoPNode.setVisible(false);
        this.perfilPNode.setVisible(false);
    }

    public void asignarPuntos(Vector nuevosPuntos) {
        this.points2D = nuevosPuntos;
    }

    public void setPNodoGraficoFaseIni(PNodoGrafico fi) {
        this.pNodoGraficofaseInicial = fi;
        if (fi == null) {
            return;
        }
        if (fi.getTrFaseGrAsociada() == null) {
            return;
        }
        if (this.trTransicion == null) {
            return;
        }
        if (fi instanceof FasePNode) {
            this.trTransicion.setTrFaseIni(fi.getTrFaseGrAsociada().getTrFase());
            return;
        }
        if (fi instanceof DivisionPNode && this.trTransicion.getTIPO().equals("D")) {
            this.trTransicion.setTrFaseIni(fi.getTrFaseGrAsociada().getTrFase());
            return;
        }
        this.trTransicion.setTrFaseIni(null);
    }

    public void setPNodoGraficoFaseFin(PNodoGrafico ff) {
        this.pNodoGraficofaseFinal = ff;
        if (ff == null) {
            return;
        }
        if (ff.getTrFaseGrAsociada() == null) {
            return;
        }
        if (this.trTransicion == null) {
            return;
        }
        if (ff instanceof FasePNode) {
            this.trTransicion.setTrFaseFin(ff.getTrFaseGrAsociada().getTrFase());
            return;
        }
        if (ff instanceof UnionPNode) {
            this.trTransicion.setTIPO("U");
            this.trTransicion.setTrFaseFin(ff.getTrFaseGrAsociada().getTrFase());
            return;
        }
        this.trTransicion.setTrFaseFin(null);
    }

    public PNodoGrafico getPNodoGraficoFaseIni() {
        return this.pNodoGraficofaseInicial;
    }

    public PNodoGrafico getPNodoGraficoFaseFin() {
        return this.pNodoGraficofaseFinal;
    }

    public void notificarCreacionAExtremos() {
        this.pTextEtiqueta.setFont(ModelaConf.getFuenteGrTransi());
        if (this.getTrTransicion() != null) {
            this.pTextEtiqueta.setText(this.etiquetaAMostrar());
            if (this.graficoTransicion != null && this.graficoTransicion.getColorTexto() != null) {
                this.pTextEtiqueta.setTextPaint((Paint)this.graficoTransicion.getColorTexto());
            }
        } else {
            this.pTextEtiqueta.setText("");
        }
        this.posicionarEtiqueta();
        this.posicionarIconosHijos();
        if (this.pNodoGraficofaseInicial != null) {
            this.pNodoGraficofaseInicial.addTransicionSalida(this);
        }
        if (this.pNodoGraficofaseFinal != null) {
            this.pNodoGraficofaseFinal.addTransicionEntrada(this);
        }
    }

    public void invertirPuntos() {
        if (this.points2D == null) {
            return;
        }
        if (this.points2D.size() < 2) {
            return;
        }
        Vector vectorInvertido = new Vector();
        for (int k = this.points2D.size() - 1; k >= 0; --k) {
            vectorInvertido.add(this.points2D.elementAt(k));
        }
        this.points2D = vectorInvertido;
    }

    public void addHandlesVertices() {
        if (this.points2D == null) {
            return;
        }
        for (int k = 0; k < this.points2D.size(); ++k) {
            this.locator = new PPointLocator((Point2D)this.points2D.elementAt(k));
            PNodeHandle h = new PNodeHandle(this, this.locator, (Point2D)this.points2D.elementAt(k), k);
            this.addChild((PNode)h);
        }
        bSeleccionada = true;
    }

    public void eliminarHandlesVertices() {
        if (this.bCancelarEliminarHandles) {
            this.bCancelarEliminarHandles = false;
            return;
        }
        ArrayList<PNode> handles = new ArrayList<PNode>();
        ListIterator i = this.getChildrenIterator();
        while (i.hasNext()) {
            PNode each = (PNode)i.next();
            if (!(each instanceof PNodeHandle)) continue;
            handles.add(each);
        }
        this.removeChildren(handles);
        bSeleccionada = false;
    }

    public GeneralPath getAnglePath() {
        GeneralPath p = new GeneralPath();
        if (this.points2D == null) {
            return p;
        }
        for (int k = 0; this.points2D.size() > 0 && k < this.points2D.size() - 1; ++k) {
            p.moveTo((float)((Point2D)this.points2D.elementAt(k)).getX(), (float)((Point2D)this.points2D.elementAt(k)).getY());
            p.lineTo((float)((Point2D)this.points2D.elementAt(k + 1)).getX(), (float)((Point2D)this.points2D.elementAt(k + 1)).getY());
        }
        return p;
    }

    protected void paint(PPaintContext paintContext) {
        PBounds clipActual;
        if (this.points2D == null) {
            return;
        }
        if (this.points2D.size() < 2) {
            return;
        }
        Graphics2D g2 = paintContext.getGraphics();
        float[] dash = new float[]{5.0f};
        this.stroke = this.trTransicion != null && this.trTransicion.getVALIDA().equals("N") ? new BasicStroke(1.0f, 0, 2, 10.0f, dash, 0.0f) : (this.trTransicion != null ? new BasicStroke(1.0f, 1, 1) : (this.obtenerValidezTransiUnion() ? new BasicStroke(1.0f, 1, 1) : new BasicStroke(1.0f, 0, 2, 10.0f, dash, 0.0f)));
        g2.setClip(null);
        if (this.canvas != null && (clipActual = this.canvas.getClipActual()) != null && this.canvas.isImprimiendo()) {
            g2.setClip((int)clipActual.getX() - 10, (int)clipActual.getY() - 10, (int)clipActual.getWidth() + 20, (int)clipActual.getHeight() + 20);
        }
        g2.setStroke(this.stroke);
        g2.setPaint(Color.BLACK);
        if (this.graficoTransicion != null && this.graficoTransicion.getcolorLinea() != null) {
            g2.setPaint(this.graficoTransicion.getcolorLinea());
        }
        g2.setPaintMode();
        g2.draw(this.getAnglePath());
        if (this.bMostrarDireccion) {
            int nSize = this.points2D.size();
            FlechaShp flecha = new FlechaShp();
            flecha.setColor(Color.BLACK);
            if (this.graficoTransicion != null && this.graficoTransicion.getcolorLinea() != null) {
                flecha.setColor(this.graficoTransicion.getcolorLinea());
            }
            flecha.setTipo(2);
            flecha.dibujar((Point2D)this.points2D.get(nSize - 2), (Point2D)this.points2D.get(nSize - 1), g2);
            flecha = null;
        }
        if (this.bEnEdicion) {
            this.posicionarTextEdit();
        }
        if (this.bPosicionarIconos) {
            this.posicionarIconosHijos();
            this.bPosicionarIconos = false;
        }
    }

    public boolean isEditando() {
        return this.bEnEdicion;
    }

    public void updateBounds() {
        GeneralPath p = this.getAnglePath();
        Rectangle2D b = this.stroke.createStrokedShape(p).getBounds2D();
        super.setBounds(b.getX(), b.getY(), b.getWidth(), b.getHeight());
    }

    public boolean setBounds(double x, double y, double width, double height) {
        return false;
    }

    public String toString() {
        String info = this.pNodoGraficofaseInicial + " --> " + this.pNodoGraficofaseFinal;
        return info;
    }

    public void addVerticeSiguiente(Point2D puntoToAdd) {
        this.points2D.addElement(puntoToAdd);
    }

    public Vector getPoints2D() {
        return this.points2D;
    }

    public Object clone() {
        Object obj = null;
        try {
            obj = super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("\u00b7 [ Error ] No se pudo duplicar");
        }
        return obj;
    }

    public void onRightClick(PInputEvent e) {
        this.bCancelarEliminarHandles = false;
        if (e.getButton() == 3 && this.canvas.getAccionActual() == AccionPCanvas.ACCION_SEL) {
            this.ptPulsacion = e.getPosition();
            this.nodoPulsado = e.getPickedNode();
            if (this.nodoPulsado instanceof ImagenPNode || this.nodoPulsado instanceof PText) {
                return;
            }
            boolean bPunto = false;
            this.bMenuSobreNodos = false;
            if (this.nodoPulsado instanceof TransicionPNode) {
                bPunto = false;
                this.bMenuSobreNodos = false;
            } else if (this.nodoPulsado instanceof PNodeHandle) {
                bPunto = true;
                this.bMenuSobreNodos = true;
                this.bCancelarEliminarHandles = true;
            }
            if (this.crearPopupMenu(bPunto) && !this.popup.isVisible()) {
                tooltipNode.setText("");
                Point2D p = e.getCanvasPosition();
                this.popup.show((JComponent)e.getComponent(), (int)p.getX(), (int)p.getY());
            }
        }
        if (e.getClickCount() > 1 && e.getPickedNode() instanceof PText && this.canvas.getAccionActual() == AccionPCanvas.ACCION_SEL) {
            this.editarEtiqueta();
        }
    }

    public void updateToolTip(PInputEvent event) {
        String tooltipString = "";
        tooltipString = this.toString();
        Point2D p = event.getCanvasPosition();
        event.getPath().canvasToLocal(p, (PNode)this);
        tooltipNode.setText(tooltipString);
        tooltipNode.setOffset(p.getX() + 8.0, p.getY() - 8.0);
    }

    void Propiedades_ActionPerformed(ActionEvent e) {
        this.bCancelarEliminarHandles = false;
        if (this.popup != null && this.popup.getSubElements().length > this.NUM_ELEMENTOS_MENU_NORMAL) {
            this.eliminarHandlesVertices();
            this.addHandlesEvent();
        }
        this.eliminarPopupMenu();
        this.canvas.propiedadesGraficosSelec(2);
        this.canvas.actualizarEtiquetas();
    }

    void PropiedadesGr_ActionPerformed(ActionEvent e) {
        this.bCancelarEliminarHandles = false;
        if (this.popup != null && this.popup.getSubElements().length > this.NUM_ELEMENTOS_MENU_NORMAL) {
            this.eliminarHandlesVertices();
            this.addHandlesEvent();
        }
        this.eliminarPopupMenu();
        PropGraficoTransicion dlgProp = new PropGraficoTransicion();
        dlgProp.setColor(this.graficoTransicion.getcolorLinea());
        dlgProp.setColorTexto(this.graficoTransicion.getColorTexto());
        dlgProp.setDireccion(this.bMostrarDireccion);
        dlgProp.actualizarCampos();
        dlgProp.setVisible(true);
        if (dlgProp.getAcepta()) {
            this.graficoTransicion.setcolorLinea(dlgProp.getColor());
            this.graficoTransicion.setColorTexto(dlgProp.getColorTexto());
            this.posicionarEtiqueta();
            this.bMostrarDireccion = dlgProp.getDireccion();
            this.repaint();
        }
    }

    void PlazoSimple_ActionPerformed(ActionEvent e) {
        this.bCancelarEliminarHandles = false;
        if (this.popup != null && this.popup.getSubElements().length > this.NUM_ELEMENTOS_MENU_NORMAL) {
            this.eliminarHandlesVertices();
            this.addHandlesEvent();
        }
        if (this.canvas != null) {
            this.canvas.mostrarPlazoSimpleTransicion(this.trTransicion);
        }
    }

    void establecerValidezTr(ActionEvent e) {
        this.bCancelarEliminarHandles = false;
        if (this.popup != null && this.popup.getSubElements().length > this.NUM_ELEMENTOS_MENU_NORMAL) {
            this.eliminarHandlesVertices();
            this.addHandlesEvent();
        }
        if (this.getTrTransicion() != null) {
            if (this.canvas == null) {
                return;
            }
            if (this.canvas.getDiagrama() == null) {
                return;
            }
            this.getTrTransicion().setValida(this.menuValida.isSelected());
            if (this.canvas.getDiagrama().getTransicionesInvolucradas().existeElemento(this.getTrTransicion(), true) != null) {
                this.menuValida.setSelected(!this.menuValida.isSelected());
                this.getTrTransicion().setValida(this.menuValida.isSelected());
                JOptionPane.showMessageDialog((Component)((Object)this.canvas), "Imposible crear la transici\u00f3n:\nYa existe una transici\u00f3n con id\u00e9nticas caracter\u00edsticas.", "Atenci\u00f3n", 2);
            }
        } else {
            if (this.getPNodoGraficoFaseIni() == null) {
                return;
            }
            if (this.getPNodoGraficoFaseIni().getTrFaseGrAsociada() == null) {
                return;
            }
            ArrayList transicionesAValidar = this.canvas.localizarGraficosTransicionUni(this.getPNodoGraficoFaseIni().getTrFaseGrAsociada().getID());
            for (int nt = 0; nt < transicionesAValidar.size(); ++nt) {
                if (((TransicionPNode)transicionesAValidar.get(nt)).getTrTransicion() == null) continue;
                if (!this.menuValida.isSelected()) {
                    ((TransicionPNode)transicionesAValidar.get(nt)).getTrTransicion().setValida(false);
                    continue;
                }
                ((TransicionPNode)transicionesAValidar.get(nt)).getTrTransicion().setValida(true);
            }
        }
    }

    public void eliminar(ActionEvent e) {
        if (this.canvas == null) {
            return;
        }
        if (this.canvas.getDiagrama() == null) {
            return;
        }
        ArrayList graficosAsociadosAlaTransi = null;
        if (this.getTrTransicion() != null && this.getTrTransicion().getTIPO().equals("D") && this.getPNodoGraficoFaseIni().getTipo().equals("D") && (graficosAsociadosAlaTransi = this.canvas.localizarGraficosTransicion(this.getTrTransicion())) != null && graficosAsociadosAlaTransi.size() > 1) {
            JOptionPane.showMessageDialog((Component)((Object)this.canvas), "No se pueden eliminar ramificaciones de una transici\u00f3n de divisi\u00f3n involucrada en m\u00e1s de un diagrama.", "Atenci\u00f3n", 2);
            return;
        }
        boolean eliminarTransicion = false;
        boolean eliminarTransicionDefProc = false;
        int modoDeTrabajo = 1;
        if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(this.getTrTransicion()) > 1) {
            modoDeTrabajo = 2;
        }
        if (this.getTrTransicion() == null && this.getPNodoGraficoFaseIni() != null && this.getPNodoGraficoFaseIni().getTrFaseGrAsociada() != null) {
            boolean bTodasEnVariosProc = true;
            TransicionPNode transiRelacionada = null;
            ArrayList transicionesAborrar = this.canvas.localizarGraficosTransicionUni(this.getPNodoGraficoFaseIni().getTrFaseGrAsociada().getID());
            for (int nt = 0; nt < transicionesAborrar.size(); ++nt) {
                transiRelacionada = (TransicionPNode)transicionesAborrar.get(nt);
                if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(transiRelacionada.getTrTransicion()) > 1) continue;
                bTodasEnVariosProc = false;
                break;
            }
            modoDeTrabajo = bTodasEnVariosProc ? 2 : 1;
        }
        EliminarGraficoTransicionJDialog delDialogo = new EliminarGraficoTransicionJDialog();
        delDialogo.setLocationRelativeTo((Component)((Object)this.canvas));
        delDialogo.setModoTrabajo(modoDeTrabajo);
        this.prepararDialogo(delDialogo);
        delDialogo.setVisible(true);
        if (delDialogo.isCancelado()) {
            this.bCancelarEliminarHandles = false;
            if (this.popup != null && this.popup.getSubElements().length > this.NUM_ELEMENTOS_MENU_NORMAL) {
                this.eliminarHandlesVertices();
                this.addHandlesEvent();
            }
            return;
        }
        eliminarTransicion = delDialogo.eliminarTransicion();
        eliminarTransicionDefProc = delDialogo.eliminarTransicionDefProc();
        this.eliminarTransicion(eliminarTransicion, eliminarTransicionDefProc);
        ((PSelectionEventHandler)this.canvas.getSelectionEventHandler()).unselectAll();
    }

    private void prepararDialogo(EliminarGraficoTransicionJDialog dialogo) {
        String mensaje = "Eliminando gr\u00e1fico de transici\u00f3n";
        if (this.getTrTransicion() != null) {
            if (this.getTrTransicion().getTIPO().equals("D") && this.getPNodoGraficoFaseIni().getTipo().equals("D")) {
                mensaje = "Eliminando gr\u00e1fico de transici\u00f3n";
                dialogo.permitirEliminarTransicion(false);
                dialogo.permitirEliminarTransicionDefProc(false);
            } else {
                mensaje = "Eliminando gr\u00e1fico de transici\u00f3n";
            }
        } else if (this.getTrTransicion() == null) {
            mensaje = "Eliminando gr\u00e1fico de transici\u00f3n";
        }
        dialogo.setTitulo(mensaje);
    }

    void EliminarPuntoGr_ActionPerformed(ActionEvent e) {
        this.eliminarPopupMenu();
        if (this.ptPulsacion == null) {
            return;
        }
        if (this.nodoPulsado == null) {
            return;
        }
        int nIndice = this.obtenerIndiceNodo(this.nodoPulsado);
        if (nIndice < 1 || nIndice >= this.points2D.size() - 1 || this.isFaseOrigenIgualFaseFin() && this.points2D.size() == 3 || this.points2D.size() < 3) {
            this.bCancelarEliminarHandles = false;
            this.eliminarHandlesVertices();
            this.addHandlesEvent();
            return;
        }
        this.points2D.remove(nIndice);
        this.bCancelarEliminarHandles = false;
        this.eliminarHandlesVertices();
        this.addHandlesEvent();
        this.posicionarEtiqueta();
        this.posicionarIconosHijos();
        this.repaint();
    }

    void InsertarPuntoGr_ActionPerformed(ActionEvent e) {
        this.eliminarPopupMenu();
        if (this.ptPulsacion == null) {
            return;
        }
        if (this.nodoPulsado == null) {
            return;
        }
        int nIndice = this.obtenerIndiceNodo(this.nodoPulsado);
        if (nIndice < 0) {
            return;
        }
        this.points2D.add(nIndice, this.ptPulsacion);
        this.bCancelarEliminarHandles = false;
        this.eliminarHandlesVertices();
        this.addHandlesEvent();
        this.posicionarEtiqueta();
        this.posicionarIconosHijos();
        this.repaint();
    }

    public void condicion_ActionPerformed(ActionEvent e) {
        if (this.canvas == null) {
            return;
        }
        if (this.canvas.getSelectionEventHandler() == null || !(this.canvas.getSelectionEventHandler() instanceof PSelectionEventHandler)) {
            return;
        }
        this.bCancelarEliminarHandles = false;
        if (this.popup != null && this.popup.getSubElements().length > this.NUM_ELEMENTOS_MENU_NORMAL) {
            this.eliminarHandlesVertices();
            this.addHandlesEvent();
        }
        if (this.canvas != null) {
            this.canvas.mostrarCondicionTransicion(this.trTransicion);
        }
        this.posicionarIconosHijos();
        this.bPosicionarIconos = true;
    }

    public void accion_ActionPerformed(ActionEvent e) {
        if (this.canvas == null) {
            return;
        }
        if (this.canvas.getSelectionEventHandler() == null || !(this.canvas.getSelectionEventHandler() instanceof PSelectionEventHandler)) {
            return;
        }
        this.bCancelarEliminarHandles = false;
        if (this.popup != null && this.popup.getSubElements().length > this.NUM_ELEMENTOS_MENU_NORMAL) {
            this.eliminarHandlesVertices();
            this.addHandlesEvent();
        }
        if (this.canvas != null) {
            this.canvas.mostrarAccionTransicion(this.trTransicion);
        }
        this.posicionarIconosHijos();
        this.bPosicionarIconos = true;
    }

    public void aviso_ActionPerformed(ActionEvent e) {
        if (this.canvas == null) {
            return;
        }
        if (this.canvas.getSelectionEventHandler() == null || !(this.canvas.getSelectionEventHandler() instanceof PSelectionEventHandler)) {
            return;
        }
        this.bCancelarEliminarHandles = false;
        if (this.popup != null && this.popup.getSubElements().length > this.NUM_ELEMENTOS_MENU_NORMAL) {
            this.eliminarHandlesVertices();
            this.addHandlesEvent();
        }
        if (this.canvas != null) {
            this.canvas.mostrarAvisoTransicion(this.trTransicion);
        }
        this.posicionarIconosHijos();
        this.bPosicionarIconos = true;
    }

    public void permiso_ActionPerformed(ActionEvent e) {
        if (this.canvas == null) {
            return;
        }
        if (this.canvas.getSelectionEventHandler() == null || !(this.canvas.getSelectionEventHandler() instanceof PSelectionEventHandler)) {
            return;
        }
        this.bCancelarEliminarHandles = false;
        if (this.popup != null && this.popup.getSubElements().length > this.NUM_ELEMENTOS_MENU_NORMAL) {
            this.eliminarHandlesVertices();
            this.addHandlesEvent();
        }
        if (this.canvas != null) {
            this.canvas.mostrarPermisoTransicion(this.trTransicion);
        }
        this.posicionarIconosHijos();
        this.bPosicionarIconos = true;
    }

    public void addHandlesEvent() {
        PLayer miPLayer = null;
        PCamera miPCamera = null;
        PCanvasModela miPCanvasModela = null;
        PBasicInputEventHandler miEventHandler = null;
        if (this.getParent() == null) {
            return;
        }
        miPLayer = (PLayer)this.getParent();
        if (miPLayer.getCamera(0) == null) {
            return;
        }
        miPCamera = miPLayer.getCamera(0);
        if (miPCamera.getComponent() == null) {
            return;
        }
        miPCanvasModela = (PCanvasModela)miPCamera.getComponent();
        if (miPCanvasModela.getSelectionEventHandler() != null) {
            miEventHandler = miPCanvasModela.getSelectionEventHandler();
            if (miEventHandler instanceof PSelectionEventHandlerEx) {
                ((PSelectionEventHandlerEx)miEventHandler).select((PNode)this);
            }
        } else {
            return;
        }
    }

    public int obtenerIndiceNodo(PNode pNodoActual) {
        Vector<PNode> listaNodos = new Vector<PNode>();
        for (int n = 0; n < this.getChildrenCount(); ++n) {
            if (this.getChild(n) instanceof PText || this.getChild(n) instanceof ImagenPNode) continue;
            listaNodos.add(this.getChild(n));
        }
        for (int i = 0; i < listaNodos.size(); ++i) {
            PNode nodoAux = (PNode)listaNodos.get(i);
            if (!nodoAux.equals(pNodoActual)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        super.finalize();
    }

    public TrTransicion getTrTransicion() {
        return this.trTransicion;
    }

    public void setTrTransicion(TrTransicion pValor) {
        this.trTransicion = pValor;
    }

    public TrTransicionGr getTransicionGr() {
        return this.graficoTransicion;
    }

    public PCanvasModela getCanvas() {
        return this.canvas;
    }

    public static boolean isSeleccionada() {
        return bSeleccionada;
    }

    public static void setSeleccionada(boolean param) {
        bSeleccionada = param;
    }

    public void posicionarEtiqueta() {
        if (this.points2D == null) {
            return;
        }
        if (this.points2D.size() < 2) {
            return;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double();
        this.pTextEtiqueta.setFont(ModelaConf.getFuenteGrTransi());
        if (this.getTrTransicion() != null) {
            this.pTextEtiqueta.setText(this.etiquetaAMostrar());
            if (ModelaConf.getMostrarOcurrenciasTransicion()) {
                TrTransicionDefProcedimiento transDefProcAux = null;
                if (this.canvas != null && this.canvas.getDiagrama() != null && this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transDefProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(this.getTrTransicion().getID())) != null && transDefProcAux.getMaxOcurrencias() != null) {
                    this.pTextEtiqueta.setText(this.pTextEtiqueta.getText() + " <<[" + transDefProcAux.getMaxOcurrencias() + "]>>");
                }
            }
            if (this.graficoTransicion != null && this.graficoTransicion.getColorTexto() != null) {
                this.pTextEtiqueta.setTextPaint((Paint)this.graficoTransicion.getColorTexto());
            }
        } else {
            this.pTextEtiqueta.setText("");
        }
        this.pTextEtiqueta.setPickable(true);
        if (this.points2D.size() == 2) {
            rect.setFrameFromDiagonal((Point2D)this.points2D.elementAt(0), (Point2D)this.points2D.elementAt(1));
            this.pTextEtiqueta.setOffset(rect.getCenterX(), rect.getCenterY());
            this.pTextEtiqueta.setPickable(true);
            rect = null;
            return;
        }
        int nVal = this.points2D.size() / 2 - 1;
        if (nVal < 0) {
            nVal = 0;
        }
        rect.setFrameFromDiagonal((Point2D)this.points2D.elementAt(nVal), (Point2D)this.points2D.elementAt(nVal + 1));
        this.pTextEtiqueta.setOffset(rect.getCenterX(), rect.getCenterY());
        this.pTextEtiqueta.setPickable(true);
        rect = null;
    }

    public void posicionarIconosHijos() {
        if (this.points2D == null) {
            return;
        }
        if (this.points2D.size() < 2) {
            return;
        }
        if (this.getTrTransicion() == null) {
            return;
        }
        this.pPuntoInicial = (Point2D)this.points2D.firstElement();
        this.pPuntoFinal = (Point2D)this.points2D.lastElement();
        if (this.condicionPNode != null) {
            this.posicionarIconosCondiciones();
        }
        if (this.avisoPNode != null) {
            this.posicionarIconosAvisos();
        }
        if (this.accionPNode != null) {
            this.posicionarIconosAcciones();
        }
        if (this.perfilAvisoPNode != null) {
            this.posicionarIconosAvisoPerfiles();
        }
        if (this.perfilPNode != null) {
            this.posicionarIconosPerfiles();
        }
    }

    private void posicionarIconosCondiciones() {
        boolean bAddIcono = true;
        this.condicionPNode.setVisible(false);
        this.condicionPNode.setPickable(false);
        if (ModelaConf.getMostrarIconoCondiciones()) {
            TransicionPNode transiPrincipalDiv;
            if (this.existeAlgunaCondicion()) {
                for (int n = 0; n < this.getChildrenCount(); ++n) {
                    if (!(this.getChild(n) instanceof ImagenPNode) || ((ImagenPNode)this.getChild(n)).getTipoImagen() != 2) continue;
                    bAddIcono = false;
                }
                if (bAddIcono) {
                    this.addChild((PNode)this.condicionPNode);
                }
                if (!this.getTrTransicion().getTIPO().equals("D")) {
                    this.condicionPNode.setOffset(this.pPuntoInicial.getX() - this.accionPNode.getWidth() / 2.0, this.pPuntoInicial.getY() - this.accionPNode.getHeight());
                    this.condicionPNode.setPickable(true);
                    this.condicionPNode.setVisible(true);
                } else if (!(this.pNodoGraficofaseInicial instanceof DivisionPNode) && this.pNodoGraficofaseFinal instanceof DivisionPNode) {
                    this.condicionPNode.setOffset(this.pPuntoInicial.getX() - this.condicionPNode.getWidth() / 2.0, this.pPuntoInicial.getY() - this.condicionPNode.getHeight());
                    this.condicionPNode.setPickable(true);
                    this.condicionPNode.setVisible(true);
                } else {
                    TransicionPNode transiPrincipalDiv2 = this.canvas.localizarGraficoTransicionDivPrincipal(this);
                    if (transiPrincipalDiv2 != null) {
                        if (transiPrincipalDiv2.getCondicionPNode() == null || transiPrincipalDiv2.getPuntoInicial() == null) {
                            return;
                        }
                        transiPrincipalDiv2.getCondicionPNode().setOffset(transiPrincipalDiv2.getPuntoInicial().getX() - transiPrincipalDiv2.getCondicionPNode().getWidth() / 2.0, transiPrincipalDiv2.getPuntoInicial().getY() - transiPrincipalDiv2.getCondicionPNode().getHeight());
                        transiPrincipalDiv2.getCondicionPNode().setPickable(true);
                        transiPrincipalDiv2.getCondicionPNode().setVisible(true);
                    }
                }
            } else if (this.getTrTransicion().getTIPO().equals("D") && this.pNodoGraficofaseInicial instanceof DivisionPNode && (transiPrincipalDiv = this.canvas.localizarGraficoTransicionDivPrincipal(this)) != null) {
                if (transiPrincipalDiv.getCondicionPNode() == null || transiPrincipalDiv.getPuntoInicial() == null) {
                    return;
                }
                transiPrincipalDiv.getCondicionPNode().setOffset(transiPrincipalDiv.getPuntoInicial().getX() - transiPrincipalDiv.getCondicionPNode().getWidth() / 2.0, transiPrincipalDiv.getPuntoInicial().getY() - transiPrincipalDiv.getCondicionPNode().getHeight());
                transiPrincipalDiv.getCondicionPNode().setPickable(true);
                transiPrincipalDiv.getCondicionPNode().setVisible(false);
            }
        }
    }

    private void posicionarIconosAvisos() {
        boolean bAddIcono = true;
        this.avisoPNode.setVisible(false);
        this.avisoPNode.setPickable(false);
        if (ModelaConf.getMostrarIconoAvisos()) {
            TransicionPNode transiPrincipalDiv;
            if (this.existeAviso()) {
                for (int n = 0; n < this.getChildrenCount(); ++n) {
                    if (!(this.getChild(n) instanceof ImagenPNode) || ((ImagenPNode)this.getChild(n)).getTipoImagen() != 3) continue;
                    bAddIcono = false;
                }
                if (bAddIcono) {
                    this.addChild((PNode)this.avisoPNode);
                }
                if (!this.getTrTransicion().getTIPO().equals("D")) {
                    this.avisoPNode.setOffset(this.pPuntoInicial.getX() - this.avisoPNode.getWidth() / 2.0, this.pPuntoInicial.getY());
                    this.avisoPNode.setPickable(true);
                    this.avisoPNode.setVisible(true);
                } else if (!(this.pNodoGraficofaseInicial instanceof DivisionPNode) && this.pNodoGraficofaseFinal instanceof DivisionPNode) {
                    this.avisoPNode.setOffset(this.pPuntoInicial.getX() - this.avisoPNode.getWidth() / 2.0, this.pPuntoInicial.getY());
                    this.avisoPNode.setPickable(true);
                    this.avisoPNode.setVisible(true);
                } else {
                    TransicionPNode transiPrincipalDiv2 = this.canvas.localizarGraficoTransicionDivPrincipal(this);
                    if (transiPrincipalDiv2 != null) {
                        if (transiPrincipalDiv2.getAvisoPNode() == null || transiPrincipalDiv2.getPuntoInicial() == null) {
                            return;
                        }
                        transiPrincipalDiv2.getAvisoPNode().setOffset(transiPrincipalDiv2.getPuntoInicial().getX() - transiPrincipalDiv2.getAvisoPNode().getWidth() / 2.0, transiPrincipalDiv2.getPuntoInicial().getY());
                        transiPrincipalDiv2.getAvisoPNode().setPickable(true);
                        transiPrincipalDiv2.getAvisoPNode().setVisible(true);
                    }
                }
            } else if (this.getTrTransicion().getTIPO().equals("D") && this.pNodoGraficofaseInicial instanceof DivisionPNode && (transiPrincipalDiv = this.canvas.localizarGraficoTransicionDivPrincipal(this)) != null) {
                if (transiPrincipalDiv.getAvisoPNode() == null || transiPrincipalDiv.getPuntoInicial() == null) {
                    return;
                }
                transiPrincipalDiv.getAvisoPNode().setOffset(transiPrincipalDiv.getPuntoFinal().getX() - transiPrincipalDiv.getAvisoPNode().getWidth() / 2.0, transiPrincipalDiv.getPuntoFinal().getY() - this.accionPNode.getHeight());
                transiPrincipalDiv.getAvisoPNode().setPickable(true);
                transiPrincipalDiv.getAvisoPNode().setVisible(false);
            }
        }
    }

    private void posicionarIconosAcciones() {
        boolean bAddIcono = true;
        this.accionPNode.setVisible(false);
        this.accionPNode.setPickable(false);
        if (ModelaConf.getMostrarIconoAcciones()) {
            TransicionPNode transiPrincipalDiv;
            if (this.existeAlgunaAccion()) {
                for (int n = 0; n < this.getChildrenCount(); ++n) {
                    if (!(this.getChild(n) instanceof ImagenPNode) || ((ImagenPNode)this.getChild(n)).getTipoImagen() != 1) continue;
                    bAddIcono = false;
                }
                if (bAddIcono) {
                    this.addChild((PNode)this.accionPNode);
                }
                if (!this.getTrTransicion().getTIPO().equals("D")) {
                    this.accionPNode.setOffset(this.pPuntoFinal.getX() - this.condicionPNode.getWidth() / 2.0, this.pPuntoFinal.getY() - this.condicionPNode.getHeight());
                    this.accionPNode.setPickable(true);
                    this.accionPNode.setVisible(true);
                } else if (!(this.pNodoGraficofaseInicial instanceof DivisionPNode) && this.pNodoGraficofaseFinal instanceof DivisionPNode) {
                    this.accionPNode.setOffset(this.pPuntoFinal.getX() - this.condicionPNode.getWidth() / 2.0, this.pPuntoFinal.getY() - this.condicionPNode.getHeight());
                    this.accionPNode.setPickable(true);
                    this.accionPNode.setVisible(true);
                } else {
                    TransicionPNode transiPrincipalDiv2 = this.canvas.localizarGraficoTransicionDivPrincipal(this);
                    if (transiPrincipalDiv2 != null) {
                        transiPrincipalDiv2.getAccionPNode().setOffset(transiPrincipalDiv2.pPuntoFinal.getX() - this.accionPNode.getWidth() / 2.0, transiPrincipalDiv2.pPuntoFinal.getY() - this.accionPNode.getHeight());
                        transiPrincipalDiv2.getAccionPNode().setPickable(true);
                        transiPrincipalDiv2.getAccionPNode().setVisible(true);
                        transiPrincipalDiv2.notificarCreacionAExtremos();
                    }
                }
            } else if (this.getTrTransicion().getTIPO().equals("D") && this.pNodoGraficofaseInicial instanceof DivisionPNode && (transiPrincipalDiv = this.canvas.localizarGraficoTransicionDivPrincipal(this)) != null) {
                if (transiPrincipalDiv.getAccionPNode() == null || transiPrincipalDiv.getPuntoFinal() == null) {
                    return;
                }
                transiPrincipalDiv.getAccionPNode().setOffset(transiPrincipalDiv.getPuntoFinal().getX() - this.accionPNode.getWidth() / 2.0, transiPrincipalDiv.getPuntoFinal().getY() - this.accionPNode.getHeight());
                transiPrincipalDiv.getAccionPNode().setPickable(true);
                transiPrincipalDiv.getAccionPNode().setVisible(false);
            }
        }
    }

    private void posicionarIconosAvisoPerfiles() {
        boolean bAddIcono = true;
        this.perfilAvisoPNode.setVisible(false);
        this.perfilAvisoPNode.setPickable(false);
        if (ModelaConf.getMostrarIconoAvisoPerfiles()) {
            TransicionPNode transiPrincipalDiv;
            if (!this.existePerfil() && (ModelaConf.getAtributoMostrarPerfiles().equals("No existan perfiles") || ModelaConf.getAtributoMostrarPerfiles().equals("Ambos casos"))) {
                for (int n = 0; n < this.getChildrenCount(); ++n) {
                    if (!(this.getChild(n) instanceof ImagenPNode) || ((ImagenPNode)this.getChild(n)).getTipoImagen() != 10) continue;
                    bAddIcono = false;
                }
                if (bAddIcono) {
                    this.addChild((PNode)this.perfilAvisoPNode);
                }
                if (!this.getTrTransicion().getTIPO().equals("D")) {
                    this.perfilAvisoPNode.setX(this.pTextEtiqueta.getGlobalBounds().getX() - this.perfilAvisoPNode.getWidth());
                    this.perfilAvisoPNode.setY(this.pTextEtiqueta.getGlobalBounds().getY());
                    this.perfilAvisoPNode.setPickable(true);
                    this.perfilAvisoPNode.setVisible(true);
                } else if (!(this.pNodoGraficofaseInicial instanceof DivisionPNode) && this.pNodoGraficofaseFinal instanceof DivisionPNode) {
                    this.perfilAvisoPNode.setX(this.pTextEtiqueta.getGlobalBounds().getX() - this.perfilAvisoPNode.getWidth());
                    this.perfilAvisoPNode.setY(this.pTextEtiqueta.getGlobalBounds().getY());
                    this.perfilAvisoPNode.setPickable(true);
                    this.perfilAvisoPNode.setVisible(true);
                } else {
                    TransicionPNode transiPrincipalDiv2 = this.canvas.localizarGraficoTransicionDivPrincipal(this);
                    if (transiPrincipalDiv2 != null) {
                        transiPrincipalDiv2.getPerfilAvisoPNode().setX(this.pTextEtiqueta.getGlobalBounds().getX() - this.perfilAvisoPNode.getWidth());
                        transiPrincipalDiv2.getPerfilAvisoPNode().setY(this.pTextEtiqueta.getGlobalBounds().getY());
                        transiPrincipalDiv2.getPerfilAvisoPNode().setPickable(true);
                        transiPrincipalDiv2.getPerfilAvisoPNode().setVisible(true);
                        transiPrincipalDiv2.notificarCreacionAExtremos();
                    }
                }
            } else if (this.getTrTransicion().getTIPO().equals("D") && this.pNodoGraficofaseInicial instanceof DivisionPNode && (transiPrincipalDiv = this.canvas.localizarGraficoTransicionDivPrincipal(this)) != null) {
                if (transiPrincipalDiv.getPerfilAvisoPNode() == null || transiPrincipalDiv.getPuntoFinal() == null) {
                    return;
                }
                transiPrincipalDiv.getPerfilAvisoPNode().setX(this.pTextEtiqueta.getGlobalBounds().getX() - this.perfilAvisoPNode.getWidth());
                transiPrincipalDiv.getPerfilAvisoPNode().setY(this.pTextEtiqueta.getGlobalBounds().getY());
                transiPrincipalDiv.getPerfilAvisoPNode().setPickable(true);
                transiPrincipalDiv.getPerfilAvisoPNode().setVisible(false);
            }
        }
    }

    private void posicionarIconosPerfiles() {
        boolean bAddIcono = true;
        this.perfilPNode.setVisible(false);
        this.perfilPNode.setPickable(false);
        if (ModelaConf.getMostrarIconoAvisoPerfiles()) {
            TransicionPNode transiPrincipalDiv;
            if (this.existePerfil() && (ModelaConf.getAtributoMostrarPerfiles().equals("Existan perfiles") || ModelaConf.getAtributoMostrarPerfiles().equals("Ambos casos"))) {
                for (int n = 0; n < this.getChildrenCount(); ++n) {
                    if (!(this.getChild(n) instanceof ImagenPNode) || ((ImagenPNode)this.getChild(n)).getTipoImagen() != 11) continue;
                    bAddIcono = false;
                }
                if (bAddIcono) {
                    this.addChild((PNode)this.perfilPNode);
                }
                if (!this.getTrTransicion().getTIPO().equals("D")) {
                    this.perfilPNode.setX(this.pTextEtiqueta.getGlobalBounds().getX() - this.perfilPNode.getWidth());
                    this.perfilPNode.setY(this.pTextEtiqueta.getGlobalBounds().getY());
                    this.perfilPNode.setPickable(true);
                    this.perfilPNode.setVisible(true);
                } else if (!(this.pNodoGraficofaseInicial instanceof DivisionPNode) && this.pNodoGraficofaseFinal instanceof DivisionPNode) {
                    this.perfilPNode.setX(this.pTextEtiqueta.getGlobalBounds().getX() - this.perfilPNode.getWidth());
                    this.perfilPNode.setY(this.pTextEtiqueta.getGlobalBounds().getY());
                    this.perfilPNode.setPickable(true);
                    this.perfilPNode.setVisible(true);
                } else {
                    TransicionPNode transiPrincipalDiv2 = this.canvas.localizarGraficoTransicionDivPrincipal(this);
                    if (transiPrincipalDiv2 != null) {
                        transiPrincipalDiv2.getPerfilPNode().setX(this.pTextEtiqueta.getGlobalBounds().getX() - this.perfilPNode.getWidth());
                        transiPrincipalDiv2.getPerfilPNode().setY(this.pTextEtiqueta.getGlobalBounds().getY());
                        transiPrincipalDiv2.getPerfilPNode().setPickable(true);
                        transiPrincipalDiv2.getPerfilPNode().setVisible(true);
                        transiPrincipalDiv2.notificarCreacionAExtremos();
                    }
                }
            } else if (this.getTrTransicion().getTIPO().equals("D") && this.pNodoGraficofaseInicial instanceof DivisionPNode && (transiPrincipalDiv = this.canvas.localizarGraficoTransicionDivPrincipal(this)) != null) {
                if (transiPrincipalDiv.getPerfilPNode() == null || transiPrincipalDiv.getPuntoFinal() == null) {
                    return;
                }
                transiPrincipalDiv.getPerfilPNode().setX(this.pTextEtiqueta.getGlobalBounds().getX() - this.perfilPNode.getWidth());
                transiPrincipalDiv.getPerfilPNode().setY(this.pTextEtiqueta.getGlobalBounds().getY());
                transiPrincipalDiv.getPerfilPNode().setPickable(true);
                transiPrincipalDiv.getPerfilPNode().setVisible(false);
            }
        }
    }

    public String toXMLCabecera() {
        String strXML = null;
        boolean bTieneId = true;
        if (this.getTrTransicion() == null) {
            bTieneId = false;
        }
        if (bTieneId && this.getTrTransicion().getTRANID() == null) {
            bTieneId = false;
        }
        if (this.getTransicionGr() == null) {
            return null;
        }
        if (this.getTransicionGr().getID() == null) {
            return null;
        }
        if (this.getPNodoGraficoFaseIni() == null) {
            return null;
        }
        if (this.getPNodoGraficoFaseIni().getTrFaseGrAsociada() == null) {
            return null;
        }
        if (this.getPNodoGraficoFaseFin() == null) {
            return null;
        }
        if (this.getPNodoGraficoFaseFin().getTrFaseGrAsociada() == null) {
            return null;
        }
        strXML = "<TRANSICION_GR id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(this.getTransicionGr().getID().longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES;
        if (bTieneId) {
            strXML = strXML + " transicion_id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(this.getTrTransicion().getTRANID().longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES;
        }
        strXML = strXML + " extremotran_ini=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(this.getPNodoGraficoFaseIni().getTrFaseGrAsociada().getID().longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " extremotran_fin=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(this.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getID().longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " color_linea=" + CreadorXMLDefProc.COMILLAS_DOBLES + this.getColorFondo().getRGB() + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " color_texto=" + CreadorXMLDefProc.COMILLAS_DOBLES + this.getColorTexto().getRGB() + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + ">";
        Vector vect = this.getPoints2D();
        if (vect != null) {
            strXML = strXML + "\n<NODOS_TRANSICION>\n";
            for (int n = 0; n < vect.size(); ++n) {
                strXML = strXML + "<NODO_TRANGR id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(GeneradorID.getID()) + CreadorXMLDefProc.COMILLAS_DOBLES;
                strXML = strXML + " x=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf((long)((Point2D)vect.get(n)).getX()) + CreadorXMLDefProc.COMILLAS_DOBLES;
                strXML = strXML + " y=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf((long)((Point2D)vect.get(n)).getY()) + CreadorXMLDefProc.COMILLAS_DOBLES;
                strXML = strXML + " orden=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(n) + CreadorXMLDefProc.COMILLAS_DOBLES + "/>";
            }
            strXML = strXML + "\n</NODOS_TRANSICION>";
        }
        strXML = strXML + "\n</TRANSICION_GR>";
        return strXML;
    }

    public boolean intersects(Rectangle2D rect) {
        if (this.points2D == null) {
            return false;
        }
        Point puntoEvaluado = new Point();
        Point2D puntoInicial = new Point();
        Point2D puntoFinal = new Point();
        int nUmbral = 2;
        puntoEvaluado.setLocation(rect.getX(), rect.getY());
        int indicePunto2 = 1;
        for (int indicePunto1 = 0; indicePunto1 < this.points2D.size(); ++indicePunto1) {
            if (indicePunto1 + 1 >= this.points2D.size()) continue;
            indicePunto2 = indicePunto1 + 1;
            puntoInicial = (Point2D)this.points2D.get(indicePunto1);
            puntoFinal = (Point2D)this.points2D.get(indicePunto2);
            if (!(rect.getWidth() > 10.0 ? Geometria.intersects(puntoInicial, puntoFinal, rect) : Geometria.intersects(puntoInicial, puntoFinal, puntoEvaluado, nUmbral))) continue;
            return true;
        }
        return false;
    }

    public boolean crearPopupMenu(boolean bPunto) {
        block35: {
            block33: {
                block39: {
                    block38: {
                        block37: {
                            block36: {
                                block34: {
                                    this.eliminarPopupMenu();
                                    this.popup = new JPopupMenu();
                                    if (this.popup == null) {
                                        return false;
                                    }
                                    this.menuProp = new JMenuItem("Propiedades");
                                    if (this.menuProp == null) {
                                        return false;
                                    }
                                    this.menuPropGr = new JMenuItem("Propiedades del gr\u00e1fico");
                                    if (this.menuPropGr == null) {
                                        return false;
                                    }
                                    this.menuPlazoSimple = new JMenuItem("Plazo simple");
                                    if (this.menuPlazoSimple == null) {
                                        return false;
                                    }
                                    this.menuEliminarGr = new JMenuItem("Eliminar");
                                    if (this.menuEliminarGr == null) {
                                        return false;
                                    }
                                    this.menuCambiarFaseIni = new JMenuItem("Cambiar extremo inicial");
                                    if (this.menuCambiarFaseIni == null) {
                                        return false;
                                    }
                                    this.menuCambiarFaseFin = new JMenuItem("Cambiar extremo final");
                                    if (this.menuCambiarFaseFin == null) {
                                        return false;
                                    }
                                    this.menuAccion = new JMenuItem("Acciones");
                                    if (this.menuAccion == null) {
                                        return false;
                                    }
                                    this.menuCondicion = new JMenuItem("Condiciones");
                                    if (this.menuCondicion == null) {
                                        return false;
                                    }
                                    this.menuAviso = new JMenuItem("Avisos");
                                    if (this.menuAviso == null) {
                                        return false;
                                    }
                                    this.menuPermiso = new JMenuItem("Perfiles");
                                    if (this.menuPermiso == null) {
                                        return false;
                                    }
                                    this.menuValida = new JCheckBoxMenuItem("V\u00e1lida");
                                    if (this.menuValida == null) {
                                        return false;
                                    }
                                    if (this.getTrTransicion() != null) {
                                        this.menuValida.setSelected(this.getTrTransicion().isValida());
                                    } else {
                                        this.menuValida.setSelected(this.obtenerValidezTransiUnion());
                                    }
                                    this.popup.addPopupMenuListener(new PopupMenuListener(){

                                        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                                        }

                                        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                                        }

                                        public void popupMenuCanceled(PopupMenuEvent e) {
                                            TransicionPNode.this.trasFinalizarMenu();
                                        }
                                    });
                                    this.menuProp.addActionListener(new ActionListener(){

                                        public void actionPerformed(ActionEvent ae) {
                                            TransicionPNode.this.Propiedades_ActionPerformed(ae);
                                        }
                                    });
                                    this.menuPropGr.addActionListener(new ActionListener(){

                                        public void actionPerformed(ActionEvent ae) {
                                            TransicionPNode.this.PropiedadesGr_ActionPerformed(ae);
                                        }
                                    });
                                    this.menuPlazoSimple.addActionListener(new ActionListener(){

                                        public void actionPerformed(ActionEvent ae) {
                                            TransicionPNode.this.PlazoSimple_ActionPerformed(ae);
                                        }
                                    });
                                    this.menuEliminarGr.addActionListener(new ActionListener(){

                                        public void actionPerformed(ActionEvent ae) {
                                            TransicionPNode.this.eliminar(ae);
                                        }
                                    });
                                    this.menuCambiarFaseIni.addActionListener(new ActionListener(){

                                        public void actionPerformed(ActionEvent ae) {
                                            TransicionPNode.this.cambiarFaseInicial(ae);
                                        }
                                    });
                                    this.menuCambiarFaseFin.addActionListener(new ActionListener(){

                                        public void actionPerformed(ActionEvent ae) {
                                            TransicionPNode.this.cambiarFaseFinal(ae);
                                        }
                                    });
                                    this.menuValida.addActionListener(new ActionListener(){

                                        public void actionPerformed(ActionEvent ae) {
                                            TransicionPNode.this.establecerValidezTr(ae);
                                        }
                                    });
                                    this.menuAccion.addActionListener(new ActionListener(){

                                        public void actionPerformed(ActionEvent ae) {
                                            TransicionPNode.this.accion_ActionPerformed(ae);
                                        }
                                    });
                                    this.menuCondicion.addActionListener(new ActionListener(){

                                        public void actionPerformed(ActionEvent ae) {
                                            TransicionPNode.this.condicion_ActionPerformed(ae);
                                        }
                                    });
                                    this.menuAviso.addActionListener(new ActionListener(){

                                        public void actionPerformed(ActionEvent ae) {
                                            TransicionPNode.this.aviso_ActionPerformed(ae);
                                        }
                                    });
                                    this.menuPermiso.addActionListener(new ActionListener(){

                                        public void actionPerformed(ActionEvent ae) {
                                            TransicionPNode.this.permiso_ActionPerformed(ae);
                                        }
                                    });
                                    if (this.popup.add(this.menuValida) == null) {
                                        return false;
                                    }
                                    this.popup.addSeparator();
                                    if (this.popup.add(this.menuEliminarGr) == null) {
                                        return false;
                                    }
                                    this.popup.addSeparator();
                                    if (this.popup.add(this.menuCambiarFaseIni) == null) {
                                        return false;
                                    }
                                    if (this.popup.add(this.menuCambiarFaseFin) == null) {
                                        return false;
                                    }
                                    this.popup.addSeparator();
                                    if (this.getTrTransicion() == null) break block33;
                                    if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(this.getTrTransicion()) <= 1) break block34;
                                    this.menuCambiarFaseIni.setEnabled(false);
                                    this.menuCambiarFaseFin.setEnabled(false);
                                    break block35;
                                }
                                if (!this.getTrTransicion().getTIPO().equals("I") && !this.getTrTransicion().getTIPO().equals("ES") && !this.getTrTransicion().getTIPO().equals("EN")) break block36;
                                this.menuCambiarFaseIni.setEnabled(false);
                                this.menuCambiarFaseFin.setEnabled(true);
                                break block35;
                            }
                            if (!this.getTrTransicion().getTIPO().equals("F")) break block37;
                            this.menuCambiarFaseIni.setEnabled(true);
                            this.menuCambiarFaseFin.setEnabled(false);
                            break block35;
                        }
                        if (!this.getTrTransicion().getTIPO().equals("N") && !this.getTrTransicion().getTIPO().equals("U")) break block38;
                        this.menuCambiarFaseIni.setEnabled(true);
                        this.menuCambiarFaseFin.setEnabled(true);
                        break block35;
                    }
                    if (!this.getTrTransicion().getTIPO().equals("D") || this.getPNodoGraficoFaseIni() == null) break block35;
                    if (this.getPNodoGraficoFaseIni().getTipo().equals("D")) break block39;
                    this.menuCambiarFaseIni.setEnabled(true);
                    this.menuCambiarFaseFin.setEnabled(false);
                    break block35;
                }
                if (this.getTrTransicion().getConjuntoFasesFin() == null) break block35;
                this.menuCambiarFaseIni.setEnabled(false);
                this.menuCambiarFaseFin.setEnabled(true);
                break block35;
            }
            this.menuCambiarFaseIni.setEnabled(false);
            this.menuCambiarFaseFin.setEnabled(true);
            if (this.getPNodoGraficoFaseIni() != null && this.getPNodoGraficoFaseIni().getTrFaseGrAsociada() != null) {
                TransicionPNode transiRelacionada = null;
                ArrayList transicionesAborrar = this.canvas.localizarGraficosTransicionUni(this.getPNodoGraficoFaseIni().getTrFaseGrAsociada().getID());
                for (int nt = 0; nt < transicionesAborrar.size(); ++nt) {
                    transiRelacionada = (TransicionPNode)transicionesAborrar.get(nt);
                    if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(transiRelacionada.getTrTransicion()) <= 1) continue;
                    this.menuCambiarFaseFin.setEnabled(false);
                    break;
                }
            }
        }
        if (this.popup.add(this.menuProp) == null) {
            return false;
        }
        if (this.popup.add(this.menuPropGr) == null) {
            return false;
        }
        this.popup.addSeparator();
        if (this.popup.add(this.menuPlazoSimple) == null) {
            return false;
        }
        if (this.getTrTransicion() != null) {
            this.popup.addSeparator();
            if (this.popup.add(this.menuAccion) == null) {
                return false;
            }
            if (this.popup.add(this.menuCondicion) == null) {
                return false;
            }
            if (this.popup.add(this.menuAviso) == null) {
                return false;
            }
            if (this.popup.add(this.menuPermiso) == null) {
                return false;
            }
            this.popup.addSeparator();
            OcurrenciasTransicionJpanel pMaxOcurr = new OcurrenciasTransicionJpanel();
            TrTransicionDefProcedimiento transDefProc = null;
            if (this.getTrTransicion() != null && this.canvas != null) {
                transDefProc = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(this.getTrTransicion().getID());
                pMaxOcurr.setTransicionPNode(this);
                pMaxOcurr.setValor(transDefProc);
            }
            this.popup.add(pMaxOcurr);
            JMenuItem separator = new JMenuItem();
            separator.setEnabled(false);
            this.popup.add(separator);
        }
        if (!bPunto) {
            return true;
        }
        this.menuInsertarPunto = new JMenuItem("Insertar punto");
        if (this.menuInsertarPunto == null) {
            return false;
        }
        this.menuEliminarPunto = new JMenuItem("Eliminar punto");
        if (this.menuEliminarPunto == null) {
            return false;
        }
        this.menuEliminarPunto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TransicionPNode.this.EliminarPuntoGr_ActionPerformed(ae);
            }
        });
        this.menuInsertarPunto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TransicionPNode.this.InsertarPuntoGr_ActionPerformed(ae);
            }
        });
        this.popup.addSeparator();
        if (this.popup.add(this.menuInsertarPunto) == null) {
            return false;
        }
        return this.popup.add(this.menuEliminarPunto) != null;
    }

    public void eliminarPopupMenu() {
        ActionListener[] actionListener = null;
        int nActions = 0;
        int i = 0;
        this.popup = null;
        if (this.menuProp != null) {
            actionListener = this.menuProp.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuProp.removeActionListener(actionListener[i]);
            }
            this.menuProp = null;
        }
        if (this.menuPropGr != null) {
            actionListener = this.menuPropGr.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuPropGr.removeActionListener(actionListener[i]);
            }
            this.menuPropGr = null;
        }
        if (this.menuEliminarGr != null) {
            actionListener = this.menuEliminarGr.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuEliminarGr.removeActionListener(actionListener[i]);
            }
            this.menuEliminarGr = null;
        }
        if (this.menuInsertarPunto != null) {
            actionListener = this.menuInsertarPunto.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuInsertarPunto.removeActionListener(actionListener[i]);
            }
            this.menuInsertarPunto = null;
        }
        if (this.menuEliminarPunto != null) {
            actionListener = this.menuEliminarPunto.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuEliminarPunto.removeActionListener(actionListener[i]);
            }
            this.menuEliminarPunto = null;
        }
        if (this.menuAccion != null) {
            actionListener = this.menuAccion.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuAccion.removeActionListener(actionListener[i]);
            }
            this.menuAccion = null;
        }
        if (this.menuCondicion != null) {
            actionListener = this.menuCondicion.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuCondicion.removeActionListener(actionListener[i]);
            }
            this.menuCondicion = null;
        }
        if (this.menuAviso != null) {
            actionListener = this.menuAviso.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuAviso.removeActionListener(actionListener[i]);
            }
            this.menuAviso = null;
        }
        if (this.menuPermiso != null) {
            actionListener = this.menuPermiso.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuPermiso.removeActionListener(actionListener[i]);
            }
            this.menuPermiso = null;
        }
        if (this.menuPlazoSimple != null) {
            actionListener = this.menuPlazoSimple.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuPlazoSimple.removeActionListener(actionListener[i]);
            }
            this.menuPlazoSimple = null;
        }
        if (this.menuCambiarFaseIni != null) {
            actionListener = this.menuCambiarFaseIni.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuCambiarFaseIni.removeActionListener(actionListener[i]);
            }
            this.menuCambiarFaseIni = null;
        }
        if (this.menuCambiarFaseFin != null) {
            actionListener = this.menuCambiarFaseFin.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuCambiarFaseFin.removeActionListener(actionListener[i]);
            }
            this.menuCambiarFaseFin = null;
        }
    }

    private void editarEtiqueta() {
        if (this.getTrTransicion() == null) {
            return;
        }
        this.bEnEdicion = true;
        this.textEdit = new JFiltroTextField();
        this.textEdit.setFont(this.pTextEtiqueta.getFont().deriveFont(this.nSizeLetraEdicion));
        this.textEdit.setCambiarColorAlModificar(false);
        this.textEdit.setTipoFiltro(1);
        this.textEdit.setNumItems(11);
        this.textEdit.setText(this.getTrTransicion().getETIQUETA());
        if (this.graficoTransicion != null && this.graficoTransicion.getColorTexto() != null) {
            this.textEdit.setForeground(this.graficoTransicion.getColorTexto());
        }
        this.textEdit.setVisible(true);
        this.posicionarTextEdit();
        this.textEdit.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent anEvent) {
                if (anEvent.getKeyCode() == 10) {
                    TransicionPNode.this.validarEdicionEtiqueta();
                } else if (anEvent.getKeyCode() == 27) {
                    TransicionPNode.this.cancelarEdicionEtiqueta();
                }
            }
        });
        this.textEdit.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!TransicionPNode.this.validarEdicionEtiqueta() && TransicionPNode.this.textEdit != null) {
                    TransicionPNode.this.textEdit.requestFocus();
                    TransicionPNode.this.textEdit.selectAll();
                }
            }
        });
        this.canvas.add(this.textEdit);
        if (this.textEdit != null) {
            this.textEdit.requestFocus();
            this.textEdit.selectAll();
            this.pTextEtiqueta.setVisible(false);
        }
    }

    private void posicionarTextEdit() {
        if (!this.bEnEdicion) {
            return;
        }
        if (this.textEdit == null) {
            return;
        }
        if (this.pTextEtiqueta == null) {
            return;
        }
        double posXtextEdit = this.pTextEtiqueta.getGlobalBounds().getX();
        double posYtextEdit = this.pTextEtiqueta.getGlobalBounds().getY();
        double altoTextEdit = this.pTextEtiqueta.getGlobalBounds().getHeight();
        double anchoTextEdit = this.pTextEtiqueta.getGlobalBounds().getWidth();
        double gbX = posXtextEdit - this.canvas.getCamera().getViewBounds().getOrigin().getX();
        double vbX = this.canvas.getCamera().getViewBounds().getWidth();
        double dAncho = this.canvas.getWidth();
        posXtextEdit = gbX * dAncho / vbX;
        double gbY = posYtextEdit - this.canvas.getCamera().getViewBounds().getOrigin().getY();
        double vbY = this.canvas.getCamera().getViewBounds().getHeight();
        double dAlto = this.canvas.getHeight();
        posYtextEdit = gbY * dAlto / vbY;
        if ((anchoTextEdit = (double)((int)(anchoTextEdit * this.canvas.getCamera().getViewScale()))) * (altoTextEdit = (double)((int)(altoTextEdit * this.canvas.getCamera().getViewScale()))) < 2000.0) {
            if (anchoTextEdit < 100.0) {
                anchoTextEdit = 100.0;
            }
            if (altoTextEdit < 20.0) {
                altoTextEdit = 20.0;
            }
        }
        this.textEdit.setBounds((int)posXtextEdit, (int)posYtextEdit, (int)anchoTextEdit, (int)altoTextEdit);
    }

    void cancelarEdicionEtiqueta() {
        for (int nC = 0; nC < this.canvas.getComponents().length; ++nC) {
            if (!(this.canvas.getComponent(nC) instanceof JTextField)) continue;
            this.canvas.remove(nC);
        }
        this.textEdit = null;
        this.pTextEtiqueta.setVisible(true);
        this.canvas.repaint();
        this.bEnEdicion = false;
    }

    boolean validarEdicionEtiqueta() {
        if (this.textEdit == null) {
            this.cancelarEdicionEtiqueta();
            return false;
        }
        if (this.canvas.getDiagrama() == null) {
            this.cancelarEdicionEtiqueta();
            return false;
        }
        if (this.canvas.getDiagrama().getTransicionesInvolucradas() == null) {
            this.cancelarEdicionEtiqueta();
            return false;
        }
        if (this.canvas.getDiagrama().getTransicionesInvolucradas().getListaDatos() == null) {
            this.cancelarEdicionEtiqueta();
            return false;
        }
        if (this.textEdit.getText().equals("")) {
            this.cancelarEdicionEtiqueta();
            JOptionPane.showMessageDialog((Component)((Object)this.canvas), "Imposible modificar:\nDebe indicar una etiqueta.", "Atenci\u00f3n", 2);
            return false;
        }
        if (!this.textEdit.getText().equals(this.getTrTransicion().getETIQUETA())) {
            TrTransicion transiValidar = new TrTransicion();
            transiValidar.setETIQUETA(this.textEdit.getText());
            transiValidar.setTIPO(this.getTrTransicion().getTIPO());
            transiValidar.setTrFaseIni(this.getTrTransicion().getTrFaseIni());
            transiValidar.setTrFaseFin(this.getTrTransicion().getFaseFin());
            if (this.canvas.getDiagrama().getTransicionesInvolucradas().existeElemento(transiValidar, true) != null) {
                this.cancelarEdicionEtiqueta();
                JOptionPane.showMessageDialog((Component)((Object)this.canvas), "Imposible modificar:\nYa existe una transici\u00f3n con id\u00e9nticas caracter\u00edsticas.", "Atenci\u00f3n", 2);
                return false;
            }
        }
        this.getTrTransicion().setETIQUETA(this.textEdit.getText());
        this.posicionarEtiqueta();
        this.cancelarEdicionEtiqueta();
        this.canvas.graficoModificado((PNode)this);
        this.canvas.actualizarEtiquetas();
        return true;
    }

    public void trasFinalizarMenu() {
        if (this.popup == null) {
            return;
        }
        this.bCancelarEliminarHandles = false;
        if (this.popup.getSubElements().length > this.NUM_ELEMENTOS_MENU_NORMAL) {
            this.eliminarHandlesVertices();
            this.addHandlesEvent();
        }
    }

    private boolean obtenerValidezTransiUnion() {
        if (this.getPNodoGraficoFaseIni() == null) {
            return true;
        }
        if (this.getPNodoGraficoFaseIni().getTrFaseGrAsociada() == null) {
            return true;
        }
        ArrayList transiRelacionadas = this.canvas.localizarGraficosTransicionUni(this.getPNodoGraficoFaseIni().getTrFaseGrAsociada().getID());
        if (transiRelacionadas.size() > 0) {
            for (int nt = 0; nt < transiRelacionadas.size(); ++nt) {
                if (((TransicionPNode)transiRelacionadas.get(nt)).getTrTransicion() == null || !((TransicionPNode)transiRelacionadas.get(nt)).getTrTransicion().isValida()) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private ImagenPNode getAccionPNode() {
        return this.accionPNode;
    }

    private ImagenPNode getCondicionPNode() {
        return this.condicionPNode;
    }

    private ImagenPNode getAvisoPNode() {
        return this.avisoPNode;
    }

    private ImagenPNode getPerfilAvisoPNode() {
        return this.perfilAvisoPNode;
    }

    private ImagenPNode getPerfilPNode() {
        return this.perfilPNode;
    }

    private Point2D getPuntoInicial() {
        return this.pPuntoInicial;
    }

    private Point2D getPuntoFinal() {
        return this.pPuntoFinal;
    }

    public boolean existeAlgunaAccion() {
        if (this.canvas == null || this.canvas.getDiagrama() == null || this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() == null || this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getListaDatos() == null || this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getListaDatos().size() <= 0) {
            return false;
        }
        if (this.getTrTransicion() == null) {
            return false;
        }
        TrTransicionDefProcedimiento transDefProc = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(this.getTrTransicion().getID());
        return transDefProc != null && transDefProc.existeAccion();
    }

    public boolean existeAlgunaCondicion() {
        if (this.canvas == null || this.canvas.getDiagrama() == null || this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() == null || this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getListaDatos() == null || this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getListaDatos().size() <= 0) {
            return false;
        }
        if (this.getTrTransicion() == null) {
            return false;
        }
        TrTransicionDefProcedimiento transDefProc = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(this.getTrTransicion().getID());
        return transDefProc != null && transDefProc.existeCondicion();
    }

    public boolean existeAviso() {
        if (this.canvas == null || this.canvas.getDiagrama() == null || this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() == null || this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getListaDatos() == null || this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getListaDatos().size() <= 0) {
            return false;
        }
        if (this.getTrTransicion() == null) {
            return false;
        }
        TrTransicionDefProcedimiento transDefProc = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(this.getTrTransicion().getID());
        return transDefProc != null && transDefProc.existeAviso();
    }

    public boolean existePerfil() {
        if (this.canvas == null || this.canvas.getDiagrama() == null || this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() == null || this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getListaDatos() == null || this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getListaDatos().size() <= 0) {
            return false;
        }
        if (this.getTrTransicion() == null) {
            return false;
        }
        TrTransicionDefProcedimiento transDefProc = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(this.getTrTransicion().getID());
        return transDefProc != null && transDefProc.existePerfil();
    }

    public boolean controlRelacionEnPlazosSimple() {
        ArrayList arrPlazosRelacionados;
        this.bCancelarEliminarHandles = false;
        if (this.popup != null && this.popup.getSubElements().length > this.NUM_ELEMENTOS_MENU_NORMAL) {
            this.eliminarHandlesVertices();
            this.addHandlesEvent();
        }
        if ((arrPlazosRelacionados = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().obtenerPlazoSimpleAsociadoATransicion(this.getTrTransicion().getTRANID())) != null && arrPlazosRelacionados.size() > 0) {
            Object[] options = new Object[]{"S\u00ed", "No"};
            int i = JOptionPane.showOptionDialog((Component)((Object)this.canvas), "Existen plazos simples que utilizan la transici\u00f3n " + this.getTrTransicion().getETIQUETA() + " como transici\u00f3n provocada\nEstos plazos simples perder\u00e1n dicha transici\u00f3n provocada. \u00bf Desea continuar ?", "Atenci\u00f3n", 0, 3, null, options, options[1]);
            if (i == -1) {
                i = 1;
            }
            if (i == 1) {
                return false;
            }
            TrPlazoSimple plazoEncontrado = null;
            for (int p = 0; p < arrPlazosRelacionados.size(); ++p) {
                plazoEncontrado = (TrPlazoSimple)arrPlazosRelacionados.get(p);
                plazoEncontrado.setTransicionQueProvoca(null);
            }
        }
        return true;
    }

    public boolean controlRelacionEnPlazosCompuestos() {
        this.bCancelarEliminarHandles = false;
        if (this.popup != null && this.popup.getSubElements().length > this.NUM_ELEMENTOS_MENU_NORMAL) {
            this.eliminarHandlesVertices();
            this.addHandlesEvent();
        }
        if (this.canvas.getDiagrama().getDDP() != null && this.canvas.getDiagrama().getDDP().getTIPOEVOL() != null && this.canvas.getDiagrama().getDDP().getTIPOEVOL().getPlazosCompuestosProcedimiento() != null && this.canvas.getDiagrama().getDDP().getTIPOEVOL().getPlazosCompuestosProcedimiento().getListaDatos() != null) {
            ArrayList arrPlazosCompuestos = this.canvas.getDiagrama().getDDP().getTIPOEVOL().getPlazosCompuestosProcedimiento().getListaDatos();
            TrPlazoCompuestoDefProc plazo = null;
            TrTransicion tranAux = null;
            boolean bExistenRelacionados = false;
            boolean bEsPosibleEliminar = true;
            for (int n = 0; !bExistenRelacionados && n < arrPlazosCompuestos.size(); ++n) {
                plazo = (TrPlazoCompuestoDefProc)arrPlazosCompuestos.get(n);
                if (plazo.getTransicionesIni() != null && plazo.getTransicionesIni().getListaDatos() != null) {
                    for (int t = 0; t < plazo.getTransicionesIni().getListaDatos().size(); ++t) {
                        tranAux = (TrTransicion)plazo.getTransicionesIni().getListaDatos().get(t);
                        if (tranAux.getTRANID().longValue() != this.getTrTransicion().getTRANID().longValue()) continue;
                        bExistenRelacionados = true;
                        if (plazo.getTransicionesIni().getListaDatos().size() != 1) continue;
                        bEsPosibleEliminar = false;
                    }
                }
                if (bExistenRelacionados || !bEsPosibleEliminar || plazo.getTransicionesFin() == null || plazo.getTransicionesFin().getListaDatos() == null) continue;
                for (int tf = 0; tf < plazo.getTransicionesFin().getListaDatos().size(); ++tf) {
                    tranAux = (TrTransicion)plazo.getTransicionesFin().getListaDatos().get(tf);
                    if (tranAux.getTRANID().longValue() != this.getTrTransicion().getTRANID().longValue()) continue;
                    bExistenRelacionados = true;
                    if (plazo.getTransicionesFin().getListaDatos().size() != 1) continue;
                    bEsPosibleEliminar = false;
                }
            }
            if (bExistenRelacionados) {
                if (!bEsPosibleEliminar) {
                    JOptionPane.showMessageDialog((Component)((Object)this.canvas), "No se puede eliminar la transici\u00f3n " + this.getTrTransicion().getETIQUETA() + ".\nExisten plazos compuestos que la usan como \u00fanica transici\u00f3n de inicio o final", "Atenci\u00f3n", 2);
                    return false;
                }
                Object[] options = new Object[]{"S\u00ed", "No"};
                int i = JOptionPane.showOptionDialog((Component)((Object)this.canvas), "Existen plazos compuestos que utilizan la transici\u00f3n " + this.getTrTransicion().getETIQUETA() + " como transici\u00f3n de inicio o final\nEstos plazos compuestos perder\u00e1n dicha transici\u00f3n. \u00bf Desea continuar ?", "Atenci\u00f3n", 0, 3, null, options, options[1]);
                if (i == -1) {
                    i = 1;
                }
                if (i == 1) {
                    return false;
                }
                for (int b = 0; b < arrPlazosCompuestos.size(); ++b) {
                    plazo = (TrPlazoCompuestoDefProc)arrPlazosCompuestos.get(b);
                    if (plazo.getTransicionesIni() != null && plazo.getTransicionesIni().getListaDatos() != null) {
                        for (int r = plazo.getTransicionesIni().getListaDatos().size() - 1; r >= 0; --r) {
                            tranAux = (TrTransicion)plazo.getTransicionesIni().getListaDatos().get(r);
                            if (tranAux.getTRANID().longValue() != this.getTrTransicion().getTRANID().longValue()) continue;
                            plazo.getTransicionesIni().remove(tranAux);
                        }
                    }
                    if (plazo.getTransicionesFin() == null || plazo.getTransicionesFin().getListaDatos() == null) continue;
                    for (int r2 = plazo.getTransicionesFin().getListaDatos().size() - 1; r2 >= 0; --r2) {
                        tranAux = (TrTransicion)plazo.getTransicionesFin().getListaDatos().get(r2);
                        if (tranAux.getTRANID().longValue() != this.getTrTransicion().getTRANID().longValue()) continue;
                        plazo.getTransicionesFin().remove(tranAux);
                    }
                }
            }
        }
        return true;
    }

    public boolean eliminarTransicion(boolean bEliminaTransAsoc, boolean bEliminaTransProc) {
        TrTransicionDefProcedimiento transiProcAux = null;
        ArrayList graficosAsociadosAlaTransi = null;
        if (bEliminaTransProc && this.getTrTransicion() != null && this.canvas != null && this.canvas.getDiagrama() != null && this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null) {
            if (!this.controlRelacionEnPlazosSimple()) {
                return false;
            }
            if (!this.controlRelacionEnPlazosCompuestos()) {
                return false;
            }
        }
        this.eliminarHandlesVertices();
        if (this.getTrTransicion() != null) {
            this.canvas.eliminarPNodoGrafico((PNode)this);
            PNodoGrafico nodoABorrar = null;
            if (this.getTrTransicion().getTIPO().equals("N")) {
                if (bEliminaTransAsoc && this.canvas.getDiagrama() != null && this.canvas.getDiagrama().obtenerAparicionesDeTransicion(this.getTrTransicion()) <= 1 && this.canvas.getDiagrama().getTransicionesInvolucradas() != null) {
                    this.canvas.getDiagrama().getTransicionesInvolucradas().remove(this.getTrTransicion());
                }
                if (bEliminaTransProc && this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(this.getTrTransicion().getTRANID().doubleValue())) != null) {
                    this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiProcAux);
                }
            } else if (this.getTrTransicion().getTIPO().equals("EN") || this.getTrTransicion().getTIPO().equals("ES") || this.getTrTransicion().getTIPO().equals("I")) {
                if (this.getPNodoGraficoFaseIni() != null) {
                    this.canvas.eliminarPNodoGrafico(this.getPNodoGraficoFaseIni());
                } else if (this.getTransicionGr() != null && this.getTransicionGr().getGraficoExtremoInicial() != null) {
                    nodoABorrar = this.canvas.localizarGraficoFase(this.getTransicionGr().getGraficoExtremoInicial().getID());
                    this.canvas.eliminarPNodoGrafico(nodoABorrar);
                }
                if (bEliminaTransAsoc && this.canvas.getDiagrama() != null && this.canvas.getDiagrama().obtenerAparicionesDeTransicion(this.getTrTransicion()) <= 1 && this.canvas.getDiagrama().getTransicionesInvolucradas() != null) {
                    this.canvas.getDiagrama().getTransicionesInvolucradas().remove(this.getTrTransicion());
                }
                if (bEliminaTransProc && this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(this.getTrTransicion().getTRANID().doubleValue())) != null) {
                    this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiProcAux);
                }
            } else if (this.getTrTransicion().getTIPO().equals("F")) {
                if (this.getPNodoGraficoFaseFin() != null) {
                    this.canvas.eliminarPNodoGrafico(this.getPNodoGraficoFaseFin());
                } else if (this.getTransicionGr() != null && this.getTransicionGr().getGraficoExtremoFinal() != null) {
                    nodoABorrar = this.canvas.localizarGraficoFase(this.getTransicionGr().getGraficoExtremoFinal().getID());
                    this.canvas.eliminarPNodoGrafico(nodoABorrar);
                }
                if (bEliminaTransAsoc && this.canvas.getDiagrama() != null && this.canvas.getDiagrama().obtenerAparicionesDeTransicion(this.getTrTransicion()) <= 1 && this.canvas.getDiagrama().getTransicionesInvolucradas() != null) {
                    this.canvas.getDiagrama().getTransicionesInvolucradas().remove(this.getTrTransicion());
                }
                if (bEliminaTransProc && this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(this.getTrTransicion().getTRANID().doubleValue())) != null) {
                    this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiProcAux);
                }
            } else if (this.getTrTransicion().getTIPO().equals("D")) {
                if (this.getPNodoGraficoFaseIni() != null) {
                    if (!this.getPNodoGraficoFaseIni().getTipo().equals("D")) {
                        nodoABorrar = this.getPNodoGraficoFaseFin() != null ? this.getPNodoGraficoFaseFin() : this.canvas.localizarGraficoFase(this.getTrTransicion().getTrFaseIni(), "D");
                        nodoABorrar = this.getPNodoGraficoFaseFin();
                        this.canvas.eliminarPNodoGrafico(nodoABorrar);
                        TransicionPNode transiAborrar = null;
                        PNodoGrafico graficoAuxFaseFin = null;
                        for (int f = 0; f < this.getTrTransicion().getConjuntoFasesFin().obtenerNumRegistros(); ++f) {
                            graficoAuxFaseFin = this.canvas.localizarGraficoFase((TrFase)this.getTrTransicion().getConjuntoFasesFin().obtenerDato(f));
                            if (graficoAuxFaseFin != null) {
                                transiAborrar = this.canvas.localizarGraficoTransicion(this.getTrTransicion().getTRANID(), nodoABorrar.getTrFaseGrAsociada().getID(), graficoAuxFaseFin.getTrFaseGrAsociada().getID());
                            }
                            this.canvas.eliminarPNodoGrafico((PNode)transiAborrar);
                        }
                        if (bEliminaTransAsoc && this.canvas.getDiagrama() != null && this.canvas.getDiagrama().obtenerAparicionesDeTransicion(this.getTrTransicion()) <= 1 && this.canvas.getDiagrama().getTransicionesInvolucradas() != null) {
                            this.canvas.getDiagrama().getTransicionesInvolucradas().remove(this.getTrTransicion());
                        }
                        if (bEliminaTransProc && this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(this.getTrTransicion().getTRANID().doubleValue())) != null) {
                            this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiProcAux);
                        }
                    } else if (this.getTrTransicion().getConjuntoFasesFin() != null) {
                        TrTransicionDefProcedimiento transiProc;
                        if (this.getPNodoGraficoFaseFin() != null) {
                            this.getTrTransicion().getConjuntoFasesFin().remove(this.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getTrFase());
                        }
                        if (this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiProc = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(this.getTrTransicion().getTRANID().doubleValue())) != null && this.getPNodoGraficoFaseFin() != null && this.getPNodoGraficoFaseFin().getTrFaseGrAsociada() != null && this.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getTrFase() != null) {
                            transiProc.removePlazoSimpleAsociadoAFase(this.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getTrFase().getFASEID());
                        }
                    }
                }
            } else if (this.getTrTransicion().getTIPO().equals("U")) {
                if (bEliminaTransAsoc && this.canvas.getDiagrama() != null && this.canvas.getDiagrama().obtenerAparicionesDeTransicion(this.getTrTransicion()) <= 1 && this.canvas.getDiagrama().getTransicionesInvolucradas() != null) {
                    this.canvas.getDiagrama().getTransicionesInvolucradas().remove(this.getTrTransicion());
                }
                if (bEliminaTransProc && this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(this.getTrTransicion().getTRANID().doubleValue())) != null) {
                    this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiProcAux);
                }
                this.canvas.repaint();
            }
        } else if (this.getTrTransicion() == null) {
            TransicionPNode transiRelacionada = null;
            ArrayList transicionesAborrar = this.canvas.localizarGraficosTransicionUni(this.getPNodoGraficoFaseIni().getTrFaseGrAsociada().getID());
            for (int nt = 0; nt < transicionesAborrar.size(); ++nt) {
                transiRelacionada = (TransicionPNode)transicionesAborrar.get(nt);
                if (bEliminaTransProc && this.canvas != null && this.canvas.getDiagrama() != null && this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null) {
                    if (!transiRelacionada.controlRelacionEnPlazosSimple()) {
                        return false;
                    }
                    if (!transiRelacionada.controlRelacionEnPlazosCompuestos()) {
                        return false;
                    }
                }
                if (bEliminaTransAsoc && this.canvas.getDiagrama() != null && (graficosAsociadosAlaTransi = this.canvas.localizarGraficosTransicion(transiRelacionada.getTrTransicion())).size() <= 1 && this.canvas.getDiagrama().obtenerAparicionesDeTransicion(transiRelacionada.getTrTransicion()) <= 1 && this.canvas.getDiagrama().getTransicionesInvolucradas() != null) {
                    this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiRelacionada.getTrTransicion());
                }
                if (bEliminaTransProc && this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transiRelacionada.getTrTransicion().getTRANID().doubleValue())) != null) {
                    this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiProcAux);
                }
                this.canvas.eliminarPNodoGrafico((PNode)transiRelacionada);
            }
            this.canvas.eliminarPNodoGrafico((PNode)this);
            this.canvas.eliminarPNodoGrafico(this.getPNodoGraficoFaseIni());
        }
        return true;
    }

    public void cambiarFaseInicial(ActionEvent ae) {
        if (this.canvas == null) {
            return;
        }
        if (this.canvas.getDiagrama() == null) {
            return;
        }
        if (this.canvas.getModificaTransiciones() == null) {
            return;
        }
        if (this.canvas.getSelectionEventHandler() == null || !(this.canvas.getSelectionEventHandler() instanceof PSelectionEventHandler)) {
            return;
        }
        this.bCancelarEliminarHandles = false;
        if (this.popup != null && this.bMenuSobreNodos) {
            this.eliminarHandlesVertices();
            this.addHandlesEvent();
        }
        this.canvas.getModificaTransiciones().setTransicion(this);
        this.canvas.getModificaTransiciones().setModificandoFaseInicial(true);
        this.canvas.getModificaTransiciones().prepararObtencionDeNuevoExtremo();
        this.setRecalcularDistancia(false);
        this.moveToFront();
    }

    public void cambiarFaseFinal(ActionEvent ae) {
        if (this.canvas == null) {
            return;
        }
        if (this.canvas.getDiagrama() == null) {
            return;
        }
        if (this.canvas.getModificaTransiciones() == null) {
            return;
        }
        if (this.canvas.getSelectionEventHandler() == null || !(this.canvas.getSelectionEventHandler() instanceof PSelectionEventHandler)) {
            return;
        }
        this.bCancelarEliminarHandles = false;
        if (this.popup != null && this.bMenuSobreNodos) {
            this.eliminarHandlesVertices();
            this.addHandlesEvent();
        }
        this.canvas.getModificaTransiciones().setTransicion(this);
        this.canvas.getModificaTransiciones().setModificandoFaseFinal(true);
        this.canvas.getModificaTransiciones().prepararObtencionDeNuevoExtremo();
        this.setRecalcularDistancia(false);
        this.moveToFront();
    }

    public void readaptarBounds() {
        if (this.points2D == null) {
            return;
        }
        if (this.points2D.size() < 2) {
            return;
        }
        if (this.pNodoGraficofaseInicial == null) {
            return;
        }
        if (this.pNodoGraficofaseFinal == null) {
            return;
        }
        if (this.isFaseOrigenIgualFaseFin() && this.points2D.size() == 2) {
            this.readaptarBoundsMismoIniYFin();
            this.setRecalcularDistancia(true);
            this.posicionarEtiqueta();
            this.posicionarIconosHijos();
            this.updateBounds();
            this.repaint();
            return;
        }
        double margenIzquierdo = 0.0;
        double margenDerecho = 0.0;
        double margenSuperior = 0.0;
        double margenInferior = 0.0;
        double xParaVertice = 0.0;
        double yParaVertice = 0.0;
        Point2D puntoInicioRecta = new Point2D.Double();
        Point2D puntoFinalRecta = new Point2D.Double();
        Point2D.Double puntoDeCorte = null;
        margenIzquierdo = this.getPNodoGraficoFaseIni().getGlobalBounds().getX();
        margenDerecho = margenIzquierdo + this.getPNodoGraficoFaseIni().getGlobalBounds().getWidth();
        margenSuperior = this.getPNodoGraficoFaseIni().getGlobalBounds().getY();
        margenInferior = margenSuperior + this.getPNodoGraficoFaseIni().getGlobalBounds().getHeight();
        if (this.bCalcularDistancia) {
            this.xDistancia = (((Point2D)this.points2D.elementAt(0)).getX() - margenIzquierdo) / (margenDerecho - margenIzquierdo) * 100.0;
            this.yDistancia = (((Point2D)this.points2D.elementAt(0)).getY() - margenSuperior) / (margenInferior - margenSuperior) * 100.0;
            this.bCalcularDistancia = false;
        }
        xParaVertice = margenIzquierdo + this.xDistancia * (margenDerecho - margenIzquierdo) / 100.0;
        yParaVertice = margenSuperior + this.yDistancia * (margenInferior - margenSuperior) / 100.0;
        ((Point2D)this.points2D.elementAt(0)).setLocation(xParaVertice, yParaVertice);
        puntoFinalRecta = (Point2D)this.getPoints2D().get(0);
        puntoInicioRecta = (Point2D)this.getPoints2D().get(1);
        puntoDeCorte = Geometria.puntoDeCorte(puntoInicioRecta, puntoFinalRecta, margenIzquierdo, margenDerecho, margenSuperior, margenInferior);
        if (puntoDeCorte != null) {
            ((Point2D)this.points2D.elementAt(0)).setLocation(puntoDeCorte.getX(), puntoDeCorte.getY());
        }
        margenIzquierdo = this.getPNodoGraficoFaseFin().getGlobalBounds().getX();
        margenDerecho = margenIzquierdo + this.getPNodoGraficoFaseFin().getGlobalBounds().getWidth();
        margenSuperior = this.getPNodoGraficoFaseFin().getGlobalBounds().getY();
        margenInferior = margenSuperior + this.getPNodoGraficoFaseFin().getGlobalBounds().getHeight();
        if (this.bCalcularDistanciaBis) {
            this.xDistanciaBis = (((Point2D)this.points2D.elementAt(this.points2D.size() - 1)).getX() - margenIzquierdo) / (margenDerecho - margenIzquierdo) * 100.0;
            this.yDistanciaBis = (((Point2D)this.points2D.elementAt(this.points2D.size() - 1)).getY() - margenSuperior) / (margenInferior - margenSuperior) * 100.0;
            this.bCalcularDistanciaBis = false;
        }
        xParaVertice = margenIzquierdo + this.xDistanciaBis * (margenDerecho - margenIzquierdo) / 100.0;
        yParaVertice = margenSuperior + this.yDistanciaBis * (margenInferior - margenSuperior) / 100.0;
        ((Point2D)this.points2D.elementAt(this.points2D.size() - 1)).setLocation(xParaVertice, yParaVertice);
        puntoInicioRecta = (Point2D)this.getPoints2D().get(this.getPoints2D().size() - 2);
        puntoFinalRecta = (Point2D)this.getPoints2D().get(this.getPoints2D().size() - 1);
        puntoDeCorte = null;
        puntoDeCorte = Geometria.puntoDeCorte(puntoInicioRecta, puntoFinalRecta, margenIzquierdo, margenDerecho, margenSuperior, margenInferior);
        if (puntoDeCorte != null) {
            ((Point2D)this.points2D.elementAt(this.points2D.size() - 1)).setLocation(puntoDeCorte.getX(), puntoDeCorte.getY());
        }
        this.posicionarEtiqueta();
        this.posicionarIconosHijos();
        this.updateBounds();
        this.repaint();
    }

    public void setRecalcularDistancia(boolean bValor) {
        this.bCalcularDistancia = bValor;
        this.bCalcularDistanciaBis = bValor;
    }

    public boolean isFaseOrigenIgualFaseFin() {
        return this.pNodoGraficofaseInicial != null && this.pNodoGraficofaseFinal != null && this.pNodoGraficofaseInicial.getTrFaseGrAsociada() != null && this.pNodoGraficofaseFinal.getTrFaseGrAsociada() != null && this.pNodoGraficofaseInicial.getTrFaseGrAsociada().getID().longValue() == this.pNodoGraficofaseFinal.getTrFaseGrAsociada().getID().longValue();
    }

    public void readaptarBoundsMismoIniYFin() {
        ((Point2D)this.points2D.elementAt(0)).setLocation(this.pNodoGraficofaseInicial.getGlobalBounds().getX(), this.pNodoGraficofaseInicial.getGlobalBounds().getY() + this.pNodoGraficofaseInicial.getGlobalBounds().getHeight());
        ((Point2D)this.points2D.elementAt(this.points2D.size() - 1)).setLocation(this.pNodoGraficofaseInicial.getGlobalBounds().getX() + this.pNodoGraficofaseInicial.getGlobalBounds().getWidth(), this.pNodoGraficofaseInicial.getGlobalBounds().getY() + this.pNodoGraficofaseInicial.getGlobalBounds().getHeight());
        Point2D.Double pInter = new Point2D.Double();
        this.points2D.add(1, pInter);
        ((Point2D)this.points2D.elementAt(1)).setLocation(this.pNodoGraficofaseInicial.getGlobalBounds().getX() + this.pNodoGraficofaseInicial.getGlobalBounds().getWidth() / 2.0, this.pNodoGraficofaseInicial.getGlobalBounds().getY() + this.pNodoGraficofaseInicial.getGlobalBounds().getHeight() + this.pNodoGraficofaseInicial.getGlobalBounds().getHeight() / 3.0);
    }

    public void eliminar(boolean bEliminarTransicion, boolean bEliminarTransicionProc) {
        if (this.canvas == null) {
            return;
        }
        if (this.canvas.getDiagrama() == null) {
            return;
        }
        ArrayList graficosAsociadosAlaTransi = null;
        if (this.getTrTransicion() != null && this.getTrTransicion().getTIPO().equals("D") && this.getPNodoGraficoFaseIni().getTipo().equals("D") && (graficosAsociadosAlaTransi = this.canvas.localizarGraficosTransicion(this.getTrTransicion())) != null && graficosAsociadosAlaTransi.size() > 1) {
            JOptionPane.showMessageDialog((Component)((Object)this.canvas), "No se pueden eliminar ramificaciones de una transici\u00f3n de divisi\u00f3n involucrada en m\u00e1s de un diagrama.", "Atenci\u00f3n", 2);
            return;
        }
        boolean eliminarTransicion = false;
        boolean eliminarTransicionDefProc = false;
        eliminarTransicion = bEliminarTransicion;
        eliminarTransicionDefProc = bEliminarTransicionProc;
        if (this.getTrTransicion() == null && this.getPNodoGraficoFaseIni() != null && this.getPNodoGraficoFaseIni().getTrFaseGrAsociada() != null) {
            TransicionPNode transiRelacionada = null;
            ArrayList transicionesAborrar = this.canvas.localizarGraficosTransicionUni(this.getPNodoGraficoFaseIni().getTrFaseGrAsociada().getID());
            for (int nt = 0; nt < transicionesAborrar.size(); ++nt) {
                transiRelacionada = (TransicionPNode)transicionesAborrar.get(nt);
                if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(transiRelacionada.getTrTransicion()) <= 1) break;
            }
        }
        this.eliminarTransicion(eliminarTransicion, eliminarTransicionDefProc);
        ((PSelectionEventHandler)this.canvas.getSelectionEventHandler()).unselectAll();
    }

    private String etiquetaAMostrar() {
        String etiqueta = new String("Error");
        if (this.getTrTransicion() == null) {
            return etiqueta;
        }
        etiqueta = this.getTrTransicion().getETIQUETA();
        if (!ModelaConf.getMostrarInfoAuxiliarTransicion()) {
            return etiqueta;
        }
        if (ModelaConf.getAtributoAuxTransicion().equals("")) {
            return etiqueta;
        }
        if (ModelaConf.getAtributoAuxTransicion().equals("Descripci\u00f3n")) {
            String auxStr = this.getTrTransicion().getDescripcion();
            if (auxStr == null) {
                auxStr = "";
            }
            return etiqueta + ":\n" + auxStr;
        }
        if (ModelaConf.getAtributoAuxTransicion().equals("Descripci\u00f3n fecha")) {
            String auxStr = this.getTrTransicion().getDESCRIPCIONFECHA();
            if (auxStr == null) {
                auxStr = "";
            }
            return etiqueta + ":\n" + auxStr;
        }
        if (ModelaConf.getAtributoAuxTransicion().equals("Etiqueta larga")) {
            String auxStr = this.getTrTransicion().getETIQUETA_LARGA();
            if (auxStr == null) {
                auxStr = "";
            }
            return etiqueta + ":\n" + auxStr;
        }
        return etiqueta;
    }

    public void setColorFondo(Color nuevoColor) {
        this.graficoTransicion.setcolorLinea(nuevoColor);
    }

    public Color getColorFondo() {
        return this.graficoTransicion.getcolorLinea();
    }

    public void setColorTexto(Color cColor) {
        this.graficoTransicion.setColorTexto(cColor);
    }

    public Color getColorTexto() {
        return this.graficoTransicion.getColorTexto();
    }

    public void setColorBorde(Color nuevoColor) {
    }

    public Color getColorBorde() {
        return null;
    }
}

