/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.piccolo.nodes;

import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import gdtel.ui.piccolo.AccionPCanvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import modela.bd.obj.TrFaseGr;
import modela.conf.ModelaConf;
import modela.ui.ModelaUI;
import modela.ui.piccolo.PCanvasModela;
import modela.ui.piccolo.nodes.ImagenPNode;
import modela.ui.piccolo.nodes.PNodoGrafico;
import modela.ui.piccolo.nodes.TransicionPNode;

public class UnionPNode
extends PNodoGrafico {
    private static final long serialVersionUID = -7420791178541623204L;
    Image imagenNodoUnionResaltada;
    private boolean bResaltarBajoPuntero = false;
    Color colorResaltar;
    protected static int GROSOR_MARGENES = 1;

    public UnionPNode(PCanvasModela pCanvas) {
        this.sTipo = "U";
        this.canvas = pCanvas;
        this.transicionesEntrada = new ArrayList();
        this.transicionesSalida = new ArrayList();
        this.bResaltarBajoPuntero = false;
        this.colorFondo = Color.white;
        this.colorTexto = Color.black;
        this.colorBorde = Color.black;
        this.faseGraficaAsociada = new TrFaseGr();
        this.sTexto = "U";
        this.imagenNodo = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_NODO_UNION)).getImage();
        this.imagenNodoUnionResaltada = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_NODO_UNION_RESALTADO)).getImage();
        this.setBounds(120.0, 120.0, 53.0, 53.0);
        this.addListeners();
    }

    public UnionPNode(TrFaseGr nuevaFase, PCanvasModela pCanvas) {
        this.sTipo = "U";
        this.canvas = pCanvas;
        this.transicionesEntrada = new ArrayList();
        this.transicionesSalida = new ArrayList();
        this.bResaltarBajoPuntero = false;
        this.colorFondo = Color.white;
        this.colorTexto = Color.black;
        this.colorBorde = Color.black;
        this.faseGraficaAsociada = nuevaFase;
        this.sTexto = "U";
        this.imagenNodo = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_NODO_UNION)).getImage();
        this.imagenNodoUnionResaltada = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_NODO_UNION_RESALTADO)).getImage();
        if (nuevaFase != null) {
            this.inicializarBounds(nuevaFase.getX(), nuevaFase.getY(), nuevaFase.getAncho(), nuevaFase.getAlto());
        } else {
            this.inicializarBounds();
        }
        this.addListeners();
    }

    private void addListeners() {
        this.addInputEventListener((PInputEventListener)new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent myEvent) {
                UnionPNode.this.onRightClick(myEvent);
            }

            public void mouseMoved(PInputEvent event) {
                if (UnionPNode.this.canvas != null && UnionPNode.this.canvas.getModificaTransiciones() != null && UnionPNode.this.canvas.getModificaTransiciones().isModificandoFaseFinal() && UnionPNode.this.canvas.getModificaTransiciones().getTransicion() != null && UnionPNode.this.canvas.getModificaTransiciones().getTransicion().getTrTransicion() != null && (UnionPNode.this.canvas.getModificaTransiciones().getTransicion().getTrTransicion().getTIPO().equals("N") || UnionPNode.this.canvas.getModificaTransiciones().getTransicion().getTrTransicion().getTIPO().equals("U"))) {
                    UnionPNode.this.aplicarResaltado(true);
                }
            }

            public void mouseExited(PInputEvent e) {
                UnionPNode.this.aplicarResaltado(false);
            }
        });
    }

    public void onRightClick(PInputEvent e) {
        if (e.getButton() == 3 && !(e.getPickedNode() instanceof ImagenPNode) && this.canvas.getAccionActual() == AccionPCanvas.ACCION_SEL && this.crearPopupMenu() && !this.popup.isVisible()) {
            Point2D p = e.getCanvasPosition();
            this.popup.show((JComponent)e.getComponent(), (int)p.getX(), (int)p.getY());
        }
    }

    public String toString() {
        if (this.faseGraficaAsociada == null) {
            return "Gr\u00e1fico de Uni\u00f3n (Sin Fase Asociada)";
        }
        if (this.faseGraficaAsociada.getTrFase() == null) {
            return "Gr\u00e1fico de Uni\u00f3n (Sin Fase Asociada)";
        }
        return "Gr\u00e1fico de Uni\u00f3n (" + this.faseGraficaAsociada.getTrFase().toString() + ")";
    }

    protected void paint(PPaintContext paintContext) {
        try {
            PBounds clipActual;
            PBounds xyAndSizeFase = this.getBounds();
            Graphics2D g2 = paintContext.getGraphics();
            g2.setStroke(this.stroke);
            g2.setClip(null);
            if (this.canvas != null && (clipActual = this.canvas.getClipActual()) != null && this.canvas.isImprimiendo()) {
                g2.setClip((int)clipActual.getX() - 10, (int)clipActual.getY() - 10, (int)clipActual.getWidth() + 10, (int)clipActual.getHeight() + 10);
            }
            if (ModelaConf.getMostrarNodosClasicos()) {
                this.drawGraficoUnion(g2, (int)xyAndSizeFase.getOrigin().getX(), (int)xyAndSizeFase.getOrigin().getY(), (int)xyAndSizeFase.getSize().getWidth(), (int)xyAndSizeFase.getSize().getHeight());
                this.drawTextoUnion(xyAndSizeFase, g2);
            } else {
                this.drawImagenGraficoUnion(g2);
            }
            g2.setClip(null);
            this.setBounds((Rectangle2D)this.getBounds());
            this.reposicionarGraficosAsociados();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addTransicionEntrada(TransicionPNode trPNode) {
        this.transicionesEntrada.add(trPNode);
    }

    public void addTransicionSalida(TransicionPNode trPNode) {
        this.transicionesSalida.add(trPNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        super.finalize();
    }

    public void aplicarResaltado(boolean bResaltar) {
        this.bResaltarBajoPuntero = bResaltar;
        this.repaint();
    }

    public void fill3DOval(Graphics2D gr, int x, int y, int width, int height, boolean raised) {
        GROSOR_MARGENES = 1;
        if (this.canvas.isImprimiendo()) {
            GROSOR_MARGENES = 3;
        }
        Paint p = gr.getPaint();
        Color c = gr.getColor();
        Color darker = c.darker();
        if (!raised) {
            gr.setColor(darker);
        } else if (p != c) {
            gr.setColor(c);
        }
        gr.fillOval(x, y, width, height);
        if (this.colorBorde == null) {
            this.colorBorde = Color.black;
        }
        gr.setColor(this.colorBorde);
        gr.drawOval(x - GROSOR_MARGENES, y - GROSOR_MARGENES, width + GROSOR_MARGENES * 2, height + GROSOR_MARGENES * 2);
        gr.setPaint(p);
        gr.setPaintMode();
    }

    private void drawGraficoUnion(Graphics2D gr, int x, int y, int width, int height) {
        if (this.bResaltarBajoPuntero) {
            this.colorResaltar = ModelaUI.colorSeleccionGraficos;
            gr.setPaint(this.colorResaltar);
        } else {
            if (this.colorFondo == null) {
                this.colorFondo = Color.white;
            }
            gr.setPaint(this.colorFondo);
        }
        gr.setPaintMode();
        this.fill3DOval(gr, x, y, width, height, true);
    }

    private void drawTextoUnion(PBounds limitesFase, Graphics2D contextoGrafico) {
        if (this.colorTexto == null) {
            this.colorTexto = Color.black;
        }
        contextoGrafico.setPaint(this.colorTexto);
        contextoGrafico.setPaintMode();
        this.sizeFuenteTexto = (int)Math.sqrt(limitesFase.getSize().getWidth() * limitesFase.getSize().getWidth()) / 2;
        this.posXTexto = (int)(limitesFase.getOrigin().getX() + 0.1 * limitesFase.getSize().getWidth());
        this.posYTexto = (int)(limitesFase.getOrigin().getY() + 0.1 * limitesFase.getSize().getHeight());
        contextoGrafico.setFont(new Font("Arial", 0, this.sizeFuenteTexto));
        FontMetrics fm = contextoGrafico.getFontMetrics();
        this.nFontHeight = fm.getAscent();
        Rectangle2D rectTexto = fm.getStringBounds(this.sTexto, contextoGrafico);
        this.posXTexto = (int)limitesFase.getCenter2D().getX() - (int)rectTexto.getBounds().getWidth() / 2;
        this.posYTexto = (int)limitesFase.getCenter2D().getY() + this.nFontHeight / 2;
        contextoGrafico.setClip((int)this.getBounds().getX(), (int)this.getBounds().getY(), (int)this.getBounds().getWidth(), (int)this.getBounds().getHeight());
        contextoGrafico.drawString(this.sTexto, this.posXTexto, this.posYTexto);
    }

    private void drawImagenGraficoUnion(Graphics2D contextoGrafico) {
        if (!this.bResaltarBajoPuntero) {
            contextoGrafico.drawImage(this.imagenNodo, (int)this.getBounds().getX(), (int)this.getBounds().getY(), (int)this.getBounds().getWidth(), (int)this.getBounds().getHeight(), null);
        } else {
            contextoGrafico.drawImage(this.imagenNodoUnionResaltada, (int)this.getBounds().getX(), (int)this.getBounds().getY(), (int)this.getBounds().getWidth(), (int)this.getBounds().getHeight(), null);
        }
        if (this.colorBorde == null) {
            this.colorBorde = Color.black;
        }
        contextoGrafico.setPaint(this.colorBorde);
        contextoGrafico.setPaintMode();
        contextoGrafico.drawOval((int)this.getBounds().getOrigin().getX() - 1, (int)this.getBounds().getOrigin().getY() - 1, (int)this.getBounds().getSize().getWidth() + 2, (int)this.getBounds().getSize().getHeight() + 2);
    }

    public PCanvasModela getCanvas() {
        return this.canvas;
    }
}

