/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.ui.ValidarNombreFichero;
import gdtel.ui.swing.FileFilterEx;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.bd.BotonesMantenimientoJPanel;
import gdtel.ui.swing.excontrols.CreadorButton;
import gdtel.ui.swing.excontrols.JCheckBoxEx;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import modela.conf.ModelaConf;
import modela.graf.CreadorXMLDefProc;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.event.InfoResultado;
import modela.ui.event.InfoResultadoEvent;
import modela.ui.event.InfoResultadoListener;
import modela.ui.swing.excontrols.JTableResultados;
import modela.ui.swing.renderers.ResultadosTableCellRenderer;

public class CerrarDefProcJDialog
extends JDialog
implements ContainerListener,
KeyListener {
    private static final long serialVersionUID = 5399498996182513691L;
    JPanel panelSuperior;
    private JLabel archivoLabel;
    private JFiltroTextField archivoText;
    ImageIcon seleccionarIconN = new ImageIcon(CerrarDefProcJDialog.class.getResource(ModelaUI.IMG_SMALL_SELECCION));
    ImageIcon seleccionarIconS = new ImageIcon(CerrarDefProcJDialog.class.getResource(ModelaUI.IMG_SMALL_SELECCION_SOBRE));
    ImageIcon seleccionarIconD = new ImageIcon(CerrarDefProcJDialog.class.getResource(ModelaUI.IMG_SMALL_SELECCION_NO_ENABLED));
    private final JButton bttSeleccionar = (JButton)CreadorButton.crearBoton(1, false, this.seleccionarIconN, this.seleccionarIconD, this.seleccionarIconS, this.seleccionarIconS);
    JPanel panelMedio;
    ButtonGroup grupoOpciones;
    JRadioButton opcionVarTodas;
    JRadioButton opcionVarWarning;
    JRadioButton opcionVarErrores;
    private JTableResultados tablaResultados;
    JPanel panelInferior;
    private JCheckBoxEx comprimirCheck;
    ImageIcon generarIconN = new ImageIcon(CerrarDefProcJDialog.class.getResource(ModelaUI.IMG_GENERAR));
    ImageIcon generarIconS = new ImageIcon(CerrarDefProcJDialog.class.getResource(ModelaUI.IMG_GENERAR_SOBRE));
    ImageIcon generarIconD = new ImageIcon(CerrarDefProcJDialog.class.getResource(ModelaUI.IMG_GENERAR_NO_ENABLED));
    ImageIcon cerrarIconN = new ImageIcon(BotonesMantenimientoJPanel.class.getResource(ModelaUI.IMG_MTTO_CERRAR));
    ImageIcon cerrarIconS = new ImageIcon(BotonesMantenimientoJPanel.class.getResource(ModelaUI.IMG_MTTO_CERRAR_SOBRE));
    private final JButton bttCerrar = (JButton)CreadorButton.crearBoton(1, false, this.cerrarIconN, this.cerrarIconN, this.cerrarIconS, this.cerrarIconS);
    private final JButton bttGenerar = (JButton)CreadorButton.crearBoton(1, false, this.generarIconN, this.generarIconN, this.generarIconS, this.generarIconS);
    String rutaDestino = "";
    String sFichero = "";
    String strNombreFichero = "";
    DDPGrafico DDPGrNuevo = null;

    public CerrarDefProcJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void jbInit() {
        this.setModal(true);
        this.setTitle("Cerrar definici\u00f3n del procedimiento");
        this.setSize(750, 515);
        this.setResizable(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.panelSuperior = new JPanel();
        this.panelSuperior.setLayout(new BorderLayout());
        this.archivoLabel = new JLabel();
        this.archivoLabel.setText("  Archivo:");
        this.archivoLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.archivoLabel.setPreferredSize(new Dimension(70, 20));
        this.archivoText = new JFiltroTextField();
        this.archivoText.setEditable(false);
        this.archivoText.setNumItems(250);
        this.archivoText.establecerTipografia(2);
        this.archivoText.setTipoFiltro(1);
        this.archivoText.setEnabled(true);
        this.archivoText.setPreferredSize(new Dimension(600, 25));
        this.bttSeleccionar.setFocusPainted(false);
        this.bttSeleccionar.setBorderPainted(false);
        this.bttSeleccionar.setPreferredSize(new Dimension(100, 25));
        this.panelSuperior.add((Component)new JLabel(" "), "North");
        this.panelSuperior.add((Component)this.archivoLabel, "West");
        this.panelSuperior.add((Component)this.archivoText, "Center");
        this.panelSuperior.add((Component)this.bttSeleccionar, "East");
        this.panelSuperior.add((Component)new JLabel(" "), "South");
        this.getContentPane().add((Component)this.panelSuperior, "North");
        this.panelMedio = new JPanel();
        this.panelMedio.setLayout(new BorderLayout());
        JPanel panelAuxNorth = new JPanel();
        panelAuxNorth = new JPanel();
        panelAuxNorth.setLayout(new XYLayout());
        this.grupoOpciones = new ButtonGroup();
        this.opcionVarTodas = new JRadioButton("Todos");
        this.opcionVarWarning = new JRadioButton("Avisos");
        this.opcionVarErrores = new JRadioButton("Errores");
        this.opcionVarTodas.setSelected(true);
        this.opcionVarTodas.setFont(ModelaUI.fuenteMenu);
        this.opcionVarWarning.setFont(ModelaUI.fuenteMenu);
        this.opcionVarErrores.setFont(ModelaUI.fuenteMenu);
        this.grupoOpciones.add(this.opcionVarTodas);
        this.grupoOpciones.add(this.opcionVarWarning);
        this.grupoOpciones.add(this.opcionVarErrores);
        panelAuxNorth.add((Component)this.opcionVarTodas, new XYConstraints(5, 5, 80, 25));
        panelAuxNorth.add((Component)this.opcionVarWarning, new XYConstraints(90, 5, 80, 25));
        panelAuxNorth.add((Component)this.opcionVarErrores, new XYConstraints(175, 5, 80, 25));
        this.panelMedio.add((Component)panelAuxNorth, "North");
        this.tablaResultados = new JTableResultados();
        this.tablaResultados.setDefaultRenderer(this.tablaResultados.getColumnClass(0), new ResultadosTableCellRenderer());
        this.tablaResultados.setAutoscrolls(true);
        this.tablaResultados.setAutoscrolls(true);
        this.panelMedio.add((Component)this.tablaResultados.getScroll(), "Center");
        this.getContentPane().add((Component)this.panelMedio, "Center");
        this.panelInferior = new JPanel();
        this.panelInferior.setLayout(new BorderLayout());
        JPanel panelAuxSouth = new JPanel();
        panelAuxSouth = new JPanel();
        this.comprimirCheck = new JCheckBoxEx();
        this.comprimirCheck.setText("Comprimir");
        this.comprimirCheck.setEnabled(true);
        this.comprimirCheck.setSelected(false);
        this.bttCerrar.setFocusPainted(false);
        this.bttCerrar.setBorderPainted(false);
        this.bttCerrar.setPreferredSize(new Dimension(115, 30));
        this.bttGenerar.setFocusPainted(false);
        this.bttGenerar.setEnabled(false);
        this.bttGenerar.setPreferredSize(new Dimension(120, 30));
        panelAuxSouth.add(this.bttGenerar);
        panelAuxSouth.add(this.bttCerrar);
        this.panelInferior.add((Component)this.comprimirCheck, "West");
        this.panelInferior.add((Component)panelAuxSouth, "East");
        this.getContentPane().add((Component)this.panelInferior, "South");
        this.bttSeleccionar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CerrarDefProcJDialog.this.selArchivo_actionPerformed(e);
            }
        });
        this.bttCerrar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CerrarDefProcJDialog.this.dispose();
            }
        });
        this.bttGenerar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CerrarDefProcJDialog.this.generar_actionPerformed(e);
            }
        });
        this.opcionVarTodas.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CerrarDefProcJDialog.this.tablaResultados.aplicarFiltro(1);
            }
        });
        this.opcionVarWarning.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CerrarDefProcJDialog.this.tablaResultados.aplicarFiltro(2);
            }
        });
        this.opcionVarErrores.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CerrarDefProcJDialog.this.tablaResultados.aplicarFiltro(3);
            }
        });
        this.addKeyAndContainerListenerRecursively(this);
        ModelaConf.setVentanaActiva(this);
    }

    public void selArchivo_actionPerformed(ActionEvent e) {
        String strRuta = ModelaConf.getRutaArchivo();
        JFileChooser fileDlg = strRuta != null ? new JFileChooser(strRuta) : new JFileChooser();
        fileDlg.setFileSelectionMode(0);
        String[] ext = new String[]{"xml"};
        FileFilterEx filter = new FileFilterEx(ext, "Archivos XML");
        fileDlg.addChoosableFileFilter(filter);
        int nRet = fileDlg.showOpenDialog(this);
        if (nRet == 0) {
            ValidarNombreFichero validaFichero;
            File fich = fileDlg.getSelectedFile();
            File path = fileDlg.getCurrentDirectory();
            this.rutaDestino = path.getAbsolutePath();
            this.sFichero = fich.getPath();
            this.strNombreFichero = fich.getName();
            if (!this.strNombreFichero.endsWith(".xml")) {
                this.strNombreFichero = this.strNombreFichero + ".xml";
            }
            if (!(validaFichero = new ValidarNombreFichero()).validaNombreFichero(this.strNombreFichero)) {
                return;
            }
            ModelaConf.setRutaArchivo(path.getAbsolutePath());
            ModelaConf.salvar();
            if (!this.sFichero.endsWith(".xml")) {
                this.sFichero = this.sFichero + ".xml";
            }
            this.archivoText.setText(this.sFichero);
            this.bttGenerar.setEnabled(true);
        }
    }

    public void setDiagrama(DDPGrafico DDPGr) {
        this.DDPGrNuevo = DDPGr;
    }

    public void generar_actionPerformed(ActionEvent e) {
        if (this.DDPGrNuevo == null) {
            return;
        }
        if (!this.rutaDestino.equals("") && !this.sFichero.equals("")) {
            CreadorXMLDefProc creadorXML = null;
            this.tablaResultados.removeAllRows();
            this.tablaResultados.updateUI();
            creadorXML = new CreadorXMLDefProc();
            creadorXML.addInfoResultadoListener(new InfoResultadoListener(){

                public void obtenerResultado(InfoResultadoEvent evt) {
                    CerrarDefProcJDialog.this.nuevoResultado(evt);
                }
            });
            if (!this.sFichero.endsWith(".xml")) {
                this.sFichero = this.sFichero + ".xml";
            }
            creadorXML.setRutaSalida(this.rutaDestino);
            creadorXML.setComprimir(this.comprimirCheck.isSelected());
            if (this.DDPGrNuevo.getDDPPadre() == null) {
                creadorXML.generarArchivo(this.sFichero, this.DDPGrNuevo, true);
            } else {
                creadorXML.generarArchivo(this.sFichero, this.DDPGrNuevo.getDDPPadre(), true);
            }
            if (this.comprimirCheck.isSelected() && creadorXML.getValidador() != null) {
                creadorXML.comprimirXml(this.archivoText.getText());
                creadorXML.getValidador().eliminarListaArchivosCopiados();
            }
        } else {
            System.out.println("\u00b7 [ Alerta ] Debe seleccionar un fichero");
        }
    }

    public void nuevoResultado(InfoResultadoEvent evt) {
        if (evt == null) {
            return;
        }
        InfoResultado info = evt.getResultado();
        if (info == null) {
            return;
        }
        this.tablaResultados.addFila(info);
    }

    private void addKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        c.addKeyListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            cont.addContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.addKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    private void removeKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.removeKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    public void componentAdded(ContainerEvent e) {
        this.addKeyAndContainerListenerRecursively(e.getChild());
    }

    public void componentRemoved(ContainerEvent e) {
        this.removeKeyAndContainerListenerRecursively(e.getChild());
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 27) {
            this.dispose();
        } else if (code == 10) {
            this.performEnterAction(e);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    void performEnterAction(KeyEvent e) {
    }
}

