/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.excontrols.CreadorButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.PropGraficoFase;
import modela.ui.swing.excontrols.ProcedimientosJTable;
import modela.ui.swing.renderers.ProcedimientosTableCellRenderer;

public class ConfigurarModulosJDialog
extends JDialog
implements ContainerListener,
KeyListener {
    private static final long serialVersionUID = 5638929034903079773L;
    ImageIcon cancelarIconN = new ImageIcon(PropGraficoFase.class.getResource(ModelaUI.IMG_MTTO_CANCELAR));
    ImageIcon cancelarIconD = new ImageIcon(PropGraficoFase.class.getResource(ModelaUI.IMG_MTTO_CANCELAR_NO_ENABLED));
    ImageIcon cancelarIconS = new ImageIcon(PropGraficoFase.class.getResource(ModelaUI.IMG_MTTO_CANCELAR_SOBRE));
    ImageIcon aplicarIconN = new ImageIcon(PropGraficoFase.class.getResource(ModelaUI.IMG_MTTO_APLICAR));
    ImageIcon aplicarIconD = new ImageIcon(PropGraficoFase.class.getResource(ModelaUI.IMG_MTTO_APLICAR_NO_ENABLED));
    ImageIcon aplicarIconS = new ImageIcon(PropGraficoFase.class.getResource(ModelaUI.IMG_MTTO_APLICAR_SOBRE));
    JButton cancelarButton = (JButton)CreadorButton.crearBoton(1, false, this.cancelarIconN, this.cancelarIconD, this.cancelarIconN, this.cancelarIconS);
    JButton aceptarButton = (JButton)CreadorButton.crearBoton(1, false, this.aplicarIconN, this.aplicarIconD, this.aplicarIconN, this.aplicarIconS);
    ProcedimientosJTable tablaProcedimientos = new ProcedimientosJTable();
    boolean bCambiosRealizados = false;
    boolean bCambiosAplicados = false;

    public ConfigurarModulosJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(675, 285));
        this.setModal(true);
        this.setResizable(false);
        this.setTitle("Configuraci\u00f3n de m\u00f3dulos asociados al procedimiento");
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new XYLayout());
        this.tablaProcedimientos.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ConfigurarModulosJDialog.this.cambiarValorCheck(e);
            }
        });
        this.aceptarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigurarModulosJDialog.this.accionAceptar();
            }
        });
        this.cancelarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigurarModulosJDialog.this.accionCancelar();
            }
        });
        this.tablaProcedimientos.setDefaultRenderer(this.tablaProcedimientos.getColumnClass(0), new ProcedimientosTableCellRenderer());
        this.tablaProcedimientos.setAutoscrolls(true);
        this.tablaProcedimientos.setRowSelectionAllowed(true);
        this.tablaProcedimientos.setSelectionMode(0);
        this.getContentPane().add((Component)this.tablaProcedimientos.getScroll(), new XYConstraints(15, 15, 640, 170));
        this.getContentPane().add((Component)this.aceptarButton, new XYConstraints(250, 200, 80, 55));
        this.getContentPane().add((Component)this.cancelarButton, new XYConstraints(345, 200, 80, 55));
        this.addKeyAndContainerListenerRecursively(this);
    }

    protected void cargarTablaDDPs(ArrayList arrModulos) {
        if (arrModulos == null) {
            return;
        }
        if (arrModulos.size() < 1) {
            return;
        }
        this.tablaProcedimientos.removeAllRows();
        for (int n = 0; n < arrModulos.size(); ++n) {
            this.tablaProcedimientos.addFila((DDPGrafico)arrModulos.get(n));
        }
        this.tablaProcedimientos.updateUI();
    }

    void accionAceptar() {
        if (this.bCambiosRealizados) {
            for (int n = 0; n < this.tablaProcedimientos.getRowCount(); ++n) {
                String valorEditableAux = (String)this.tablaProcedimientos.getValueAt(n, 0);
                if (valorEditableAux.equals("S")) {
                    ((DDPGrafico)this.tablaProcedimientos.getValueAt(n, 1)).setEditable(true);
                    continue;
                }
                if (!valorEditableAux.equals("N")) continue;
                ((DDPGrafico)this.tablaProcedimientos.getValueAt(n, 1)).setEditable(false);
            }
        }
        this.bCambiosAplicados = true;
        this.dispose();
    }

    void accionCancelar() {
        this.bCambiosAplicados = false;
        this.bCambiosRealizados = false;
        this.dispose();
    }

    void cambiarValorCheck(MouseEvent e) {
        Object valorCeldaEditable;
        if (e.getSource() == null) {
            return;
        }
        if (!(e.getSource() instanceof ProcedimientosJTable)) {
            return;
        }
        if (((ProcedimientosJTable)e.getSource()).getSelectedColumn() != 0) {
            return;
        }
        int nFila = ((ProcedimientosJTable)e.getSource()).getFilaSeleccionada();
        if (nFila < 0) {
            return;
        }
        if (e.getClickCount() > 1 && (valorCeldaEditable = ((ProcedimientosJTable)e.getSource()).getValueAt(nFila, 0)) instanceof String) {
            if (((String)valorCeldaEditable).equals("S")) {
                ((ProcedimientosJTable)e.getSource()).setValueAt(new String("N"), nFila, 0);
            } else if (((String)valorCeldaEditable).equals("N")) {
                ((ProcedimientosJTable)e.getSource()).setValueAt(new String("S"), nFila, 0);
            }
            this.bCambiosRealizados = true;
        }
    }

    public boolean isCambiosAplicados() {
        return this.bCambiosAplicados;
    }

    public boolean isCambiosRealizados() {
        return this.bCambiosRealizados;
    }

    private void addKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        c.addKeyListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            cont.addContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.addKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    private void removeKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.removeKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    public void componentAdded(ContainerEvent e) {
        this.addKeyAndContainerListenerRecursively(e.getChild());
    }

    public void componentRemoved(ContainerEvent e) {
        this.removeKeyAndContainerListenerRecursively(e.getChild());
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 27) {
            this.dispose();
        } else if (code == 10) {
            this.performEnterAction(e);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    void performEnterAction(KeyEvent e) {
    }
}

