/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.excontrols.CreadorButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import modela.ui.ModelaUI;

public class EliminarGraficoFaseJDialog
extends JDialog
implements ContainerListener,
KeyListener {
    private static final long serialVersionUID = -5629112757646778844L;
    public static final int MODO_UN_GRAFICO = 1;
    public static final int MODO_VARIOS_GRAFICOS = 2;
    private int modoTrabajo = 1;
    boolean cancelado = false;
    JCheckBox delFaseCheck = new JCheckBox();
    JCheckBox delTransiCheck = new JCheckBox();
    private final Insets MARGEN_BOTONES = new Insets(-2, -3, -2, -3);
    ImageIcon cancelarIconN = new ImageIcon(EliminarGraficoFaseJDialog.class.getResource(ModelaUI.IMG_MTTO_CANCELAR));
    ImageIcon cancelarIconD = new ImageIcon(EliminarGraficoFaseJDialog.class.getResource(ModelaUI.IMG_MTTO_CANCELAR_NO_ENABLED));
    ImageIcon cancelarIconS = new ImageIcon(EliminarGraficoFaseJDialog.class.getResource(ModelaUI.IMG_MTTO_CANCELAR_SOBRE));
    ImageIcon eliminarIconN = new ImageIcon(EliminarGraficoFaseJDialog.class.getResource(ModelaUI.IMG_MTTO_ELIMINAR));
    ImageIcon eliminarIconD = new ImageIcon(EliminarGraficoFaseJDialog.class.getResource(ModelaUI.IMG_MTTO_ELIMINAR_NO_ENABLED));
    ImageIcon eliminarIconS = new ImageIcon(EliminarGraficoFaseJDialog.class.getResource(ModelaUI.IMG_MTTO_ELIMINAR_SOBRE));
    private JButton btnCancelar = (JButton)CreadorButton.crearBoton(1, false, this.cancelarIconN, this.cancelarIconD, this.cancelarIconN, this.cancelarIconS);
    private JButton btnEliminar = (JButton)CreadorButton.crearBoton(1, false, this.eliminarIconN, this.eliminarIconD, this.eliminarIconN, this.eliminarIconS);

    public EliminarGraficoFaseJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new XYLayout());
        this.setSize(new Dimension(320, 190));
        this.setTitle("Eliminando gr\u00e1fico de fase");
        this.setResizable(false);
        this.setModal(true);
        this.delFaseCheck.setFont(ModelaUI.fuentePrincipal);
        this.delFaseCheck.setText("Eliminar adem\u00e1s la fase asociada");
        this.delTransiCheck.setFont(ModelaUI.fuentePrincipal);
        this.delTransiCheck.setText("Eliminar adem\u00e1s las transiciones asociadas");
        this.btnEliminar.setMargin(this.MARGEN_BOTONES);
        this.btnCancelar.setMargin(this.MARGEN_BOTONES);
        this.getContentPane().add((Component)this.delFaseCheck, new XYConstraints(20, 25, 300, 20));
        this.getContentPane().add((Component)this.delTransiCheck, new XYConstraints(20, 65, 300, 20));
        this.getContentPane().add((Component)this.btnCancelar, new XYConstraints(165, 100, 80, 55));
        this.getContentPane().add((Component)this.btnEliminar, new XYConstraints(70, 100, 80, 55));
        this.addListeners();
        this.configurarSegunModo(this.modoTrabajo);
    }

    private void addListeners() {
        this.btnEliminar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                EliminarGraficoFaseJDialog.this.btnEliminar_actionPerformed();
            }
        });
        this.btnCancelar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                EliminarGraficoFaseJDialog.this.btnCancelar_actionPerformed();
            }
        });
        this.delFaseCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                EliminarGraficoFaseJDialog.this.delFaseCheck_actionPerformed();
            }
        });
        this.delTransiCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                EliminarGraficoFaseJDialog.this.delTransiCheck_actionPerformed();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                EliminarGraficoFaseJDialog.this.delFaseCheck.setSelected(false);
                EliminarGraficoFaseJDialog.this.delTransiCheck.setSelected(false);
                EliminarGraficoFaseJDialog.this.cancelado = true;
            }
        });
        this.addKeyAndContainerListenerRecursively(this);
    }

    public void setModoTrabajo(int nuevoModo) {
        this.modoTrabajo = nuevoModo;
        this.configurarSegunModo(nuevoModo);
    }

    public boolean isCancelado() {
        return this.cancelado;
    }

    private void configurarSegunModo(int modo) {
        if (modo == 1) {
            this.delFaseCheck.setEnabled(true);
        } else if (modo == 2) {
            this.delFaseCheck.setSelected(false);
            this.delFaseCheck.setEnabled(false);
            this.delFaseCheck.setToolTipText("La fase tiene m\u00e1s de 1 gr\u00e1fico asociado en \u00e9ste u otros procedimientos.");
        }
    }

    public boolean eliminarTransiciones() {
        return this.delTransiCheck.isSelected();
    }

    public boolean eliminarFase() {
        return this.delFaseCheck.isSelected();
    }

    void btnEliminar_actionPerformed() {
        this.dispose();
    }

    void btnCancelar_actionPerformed() {
        this.delFaseCheck.setSelected(false);
        this.delTransiCheck.setSelected(false);
        this.cancelado = true;
        this.dispose();
    }

    void delFaseCheck_actionPerformed() {
        if (this.delFaseCheck.isSelected()) {
            this.delTransiCheck.setSelected(true);
        }
    }

    void delTransiCheck_actionPerformed() {
        if (!this.delTransiCheck.isSelected()) {
            this.delFaseCheck.setSelected(false);
        }
    }

    private void addKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        c.addKeyListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            cont.addContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.addKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    private void removeKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.removeKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    public void componentAdded(ContainerEvent e) {
        this.addKeyAndContainerListenerRecursively(e.getChild());
    }

    public void componentRemoved(ContainerEvent e) {
        this.removeKeyAndContainerListenerRecursively(e.getChild());
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 27) {
            this.delFaseCheck.setSelected(false);
            this.delTransiCheck.setSelected(false);
            this.cancelado = true;
            this.dispose();
        } else if (code == 10) {
            this.performEnterAction(e);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    void performEnterAction(KeyEvent e) {
    }
}

