/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import modela.bd.obj.ConjuntoDatosMetafase;
import modela.conf.ModelaConf;
import modela.ui.ModelaUI;
import modela.ui.swing.PropGraficoMetafaseJPanel;
import modela.ui.swing.renderers.ColorMetafaseListRenderer;

public class GestionPropGraficoMetafaseJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = 6731976713502655403L;
    PropGraficoMetafaseJPanel pPanel;
    private JLabel listaLabel = new JLabel();
    private boolean bDesdeUtilidadGrf;
    private final int ANCHO_ACTUAL = 510;
    private final int ALTO_ACTUAL = 400;

    public GestionPropGraficoMetafaseJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle("Gesti\u00f3n de propiedades gr\u00e1ficas de metafases");
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.setLocationRelativeTo(null);
        this.listaLabel.setText("Lista de metafases");
        this.listaLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.listaLabel.setForeground(ModelaUI.colorSeleccion);
        this.pPanel = new PropGraficoMetafaseJPanel();
        this.bDesdeUtilidadGrf = false;
        this.setPanelAtributable(this.pPanel);
        this.establecerModoTrabajo(7);
        this.botones.permitirEliminar(false);
        this.botones.permitirInsertar(false);
        this.getContentPane().add((Component)this.listaLabel, new XYConstraints(20, 15, 130, 25));
        this.listaAsignable.setCellRenderer(new ColorMetafaseListRenderer());
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                if (e.getSource() != null) {
                    if (e.getClickCount() == 2) {
                        GestionPropGraficoMetafaseJDialog.this.dobleClick();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = GestionPropGraficoMetafaseJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index < GestionPropGraficoMetafaseJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = GestionPropGraficoMetafaseJDialog.this.listaAsignable.getElementAt(index);
                        GestionPropGraficoMetafaseJDialog.this.establecerModoTrabajo(2);
                        GestionPropGraficoMetafaseJDialog.this.pPanel.setValoresAsignables(objAsig);
                        GestionPropGraficoMetafaseJDialog.this.botones.modificarButton_mousePressed(e);
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (GestionPropGraficoMetafaseJDialog.this.listaAsignable.getSelectedValues() == null || GestionPropGraficoMetafaseJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    GestionPropGraficoMetafaseJDialog.this.establecerModoTrabajo(7);
                    GestionPropGraficoMetafaseJDialog.this.pPanel.limpiarCampos();
                    return;
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                if (GestionPropGraficoMetafaseJDialog.this.listaAsignable.getSelectedValues() == null || GestionPropGraficoMetafaseJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    GestionPropGraficoMetafaseJDialog.this.establecerModoTrabajo(7);
                    GestionPropGraficoMetafaseJDialog.this.pPanel.limpiarCampos();
                } else {
                    IAsignable objAsig = (IAsignable)GestionPropGraficoMetafaseJDialog.this.listaAsignable.getSelectedValue();
                    GestionPropGraficoMetafaseJDialog.this.establecerModoTrabajo(2);
                    GestionPropGraficoMetafaseJDialog.this.pPanel.setValoresAsignables(objAsig);
                    GestionPropGraficoMetafaseJDialog.this.botones.modificarButton_mousePressed(null);
                }
            }
        });
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 2);
        ModelaConf.setVentanaActiva(this);
    }

    public void cerrar() {
        if (!this.bDesdeUtilidadGrf) {
            this.refrescarGrafico();
        }
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        return true;
    }

    public boolean aplicar() {
        boolean respuesta = false;
        if (this.getAccion() == 3) {
            respuesta = this.aplicarModificar();
        }
        if (!respuesta) {
            this.botones.setModoModificarPorDefault(false);
        }
        return respuesta;
    }

    public boolean aplicarModificar() {
        if (!this.pPanel.obtenerValoresCampos()) {
            return false;
        }
        this.listaAsignable.updateUI();
        return true;
    }

    public boolean refrescarGrafico() {
        if (this.elementosAsignados != null) {
            ((ConjuntoDatosMetafase)this.elementosAsignados).setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public boolean cancelar() {
        if (this.listaAsignable == null) {
            this.pPanel.limpiarCampos();
            this.establecerModoTrabajo(7);
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.pPanel.limpiarCampos();
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        this.listaAsignable.setSelectedIndex(index);
        IAsignable obj = this.listaAsignable.getElementAt(index);
        this.pPanel.setValoresAsignables(obj);
        this.establecerModoTrabajo(2);
        return true;
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        super.inicializarListaElementos(cdElementos);
    }

    public void setDesdeUtilidadGrf(boolean pValor) {
        this.bDesdeUtilidadGrf = pValor;
    }
}

