/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.TrAvisoTareaFase;
import modela.bd.obj.TrTipoTarea;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.PropAvisoTareaEnFaseJPanel;
import modela.ui.swing.renderers.AtributosListRenderer;

public class MantenimientoAvisoTareaEnFaseJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = -2228760074328371076L;
    PropAvisoTareaEnFaseJPanel pPanel;
    private JLabel tituloLabel = new JLabel("Avisos asociados");
    private DDPGrafico grafico = null;
    private TrTipoTarea m_tipoTarea = null;
    private final int ANCHO_ACTUAL = 650;
    private final int ALTO_ACTUAL = 515;

    public MantenimientoAvisoTareaEnFaseJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public MantenimientoAvisoTareaEnFaseJDialog(TrTipoTarea tipoTarea) {
        try {
            this.m_tipoTarea = tipoTarea;
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.setTitle("Mantenimiento de avisos en tarea en Fase");
        this.pPanel = new PropAvisoTareaEnFaseJPanel();
        this.pPanel.inicializarCampos(7);
        this.pPanel.setTipoTarea(this.m_tipoTarea);
        this.setPanelAtributable(this.pPanel);
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.tituloLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.tituloLabel.setForeground(ModelaUI.colorSeleccion);
        this.botones.permitirEliminar(true);
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                if (e.getSource() != null) {
                    if (e.getClickCount() == 2) {
                        MantenimientoAvisoTareaEnFaseJDialog.this.dobleClick();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = MantenimientoAvisoTareaEnFaseJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index <= MantenimientoAvisoTareaEnFaseJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = MantenimientoAvisoTareaEnFaseJDialog.this.listaAsignable.getElementAt(index);
                        MantenimientoAvisoTareaEnFaseJDialog.this.establecerModoTrabajo(2);
                        MantenimientoAvisoTareaEnFaseJDialog.this.pPanel.setValoresAsignables(objAsig);
                        MantenimientoAvisoTareaEnFaseJDialog.this.botones.modificarButton_mousePressed(e);
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (MantenimientoAvisoTareaEnFaseJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoAvisoTareaEnFaseJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoAvisoTareaEnFaseJDialog.this.establecerModoTrabajo(7);
                    MantenimientoAvisoTareaEnFaseJDialog.this.pPanel.limpiarCampos();
                    return;
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                if (MantenimientoAvisoTareaEnFaseJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoAvisoTareaEnFaseJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoAvisoTareaEnFaseJDialog.this.establecerModoTrabajo(7);
                    MantenimientoAvisoTareaEnFaseJDialog.this.pPanel.limpiarCampos();
                } else {
                    IAsignable objAsig = (IAsignable)MantenimientoAvisoTareaEnFaseJDialog.this.listaAsignable.getSelectedValue();
                    MantenimientoAvisoTareaEnFaseJDialog.this.establecerModoTrabajo(2);
                    MantenimientoAvisoTareaEnFaseJDialog.this.pPanel.setValoresAsignables(objAsig);
                    MantenimientoAvisoTareaEnFaseJDialog.this.botones.modificarButton_mousePressed(null);
                }
            }
        });
        this.listaAsignable.setCellRenderer(new AtributosListRenderer());
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 15, 170, 25));
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 4);
        ModelaConf.setVentanaActiva(this);
    }

    public boolean eliminarElemento() {
        if (this.grafico == null) {
            return false;
        }
        if (this.grafico.getDestructorDDP() == null) {
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            return false;
        }
        String msgPanel = new String();
        this.establecerModoTrabajo(2);
        int nElementos = this.listaAsignable.getSelectedValues().length;
        Object[] options = new Object[]{"Aceptar", "Cancelar"};
        msgPanel = nElementos > 1 ? "\u00bfConfirma eliminar los elementos seleccionados?" : "\u00bfConfirma eliminar el elemento seleccionado?";
        int n = JOptionPane.showOptionDialog(this, msgPanel, "Eliminar", 0, 3, null, options, options[1]);
        if (n == -1) {
            n = 1;
        }
        if (n == 1) {
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        this.refrescarGrafico();
        int[] indicesEliminar = this.listaAsignable.getSelectedIndices();
        for (int ind = indicesEliminar.length - 1; ind >= 0; --ind) {
            this.listaAsignable.removeItem(indicesEliminar[ind]);
        }
        this.listaAsignable.setSelectedIndex(-1);
        this.establecerModoTrabajo(7);
        this.pPanel.limpiarCampos();
        return true;
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        return true;
    }

    public boolean insertarElemento() {
        this.establecerModoTrabajo(1);
        this.pPanel.inicializarFoco();
        return true;
    }

    public boolean aplicar() {
        boolean bRespuesta = false;
        if (this.getAccion() == 1) {
            bRespuesta = this.aplicarNuevo();
        } else if (this.getAccion() == 3) {
            bRespuesta = this.aplicarModificar();
        }
        if (!bRespuesta) {
            this.botones.setModoModificarPorDefault(false);
        }
        return bRespuesta;
    }

    public boolean aplicarNuevo() {
        TrAvisoTareaFase aviso;
        double avisoID = this.pPanel.getAvisoSeleccionado();
        if (!this.comprobarExistenciaAviso(avisoID, -1)) {
            aviso = null;
            if (!this.pPanel.obtenerValoresCampos()) {
                return false;
            }
            aviso = (TrAvisoTareaFase)this.pPanel.getValoresAsignables();
            if (aviso == null) {
                return false;
            }
        } else {
            JOptionPane.showMessageDialog(this, "Imposible asociar el aviso:\nEl aviso ya existe en la lista de avisos en tarea en fase.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        this.listaAsignable.addItem(aviso);
        this.listaAsignable.setSelectedValue(aviso, true);
        this.listaAsignable.updateUI();
        return true;
    }

    public boolean aplicarModificar() {
        int nSelectedIndex;
        double avisoID = this.pPanel.getAvisoSeleccionado();
        if (!this.comprobarExistenciaAviso(avisoID, nSelectedIndex = this.listaAsignable.getSelectedIndex())) {
            if (!this.pPanel.obtenerValoresCampos()) {
                return false;
            }
        } else {
            JOptionPane.showMessageDialog(this, "Imposible asociar el aviso:\nEl aviso ya existe en la lista de avisos en tarea en fase.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        this.listaAsignable.updateUI();
        return true;
    }

    public boolean refrescarGrafico() {
        if (this.elementosAsignados != null) {
            this.elementosAsignados.setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public boolean cancelar() {
        if (this.listaAsignable == null) {
            this.pPanel.limpiarCampos();
            this.establecerModoTrabajo(7);
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.pPanel.limpiarCampos();
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        this.listaAsignable.setSelectedIndex(index);
        IAsignable obj = this.listaAsignable.getElementAt(index);
        this.pPanel.setValoresAsignables(obj);
        this.establecerModoTrabajo(2);
        return true;
    }

    public void cerrar() {
        this.refrescarGrafico();
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        if (cdElementos != null) {
            cdElementos.ordenar();
        }
        super.inicializarListaElementos(cdElementos);
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
        this.pPanel.setGrafico(this.grafico);
    }

    public ConjuntoDatos getElementos() {
        ConjuntoDatos conjuntoAcciones = new ConjuntoDatos();
        conjuntoAcciones.setListaDatos(this.listaAsignable.toArrayList());
        return conjuntoAcciones;
    }

    public boolean comprobarExistenciaAviso(double avisoID, int nSelectedIndex) {
        if (avisoID < 0.0) {
            return false;
        }
        if (this.listaAsignable.getNumItems() <= 0) {
            return false;
        }
        boolean bID = false;
        boolean bEncontrado = false;
        for (int i = 0; i < this.listaAsignable.getNumItems() && !bEncontrado; ++i) {
            bID = false;
            TrAvisoTareaFase avisoAux = (TrAvisoTareaFase)this.listaAsignable.getElementAt(i);
            if (avisoAux != null && i != nSelectedIndex && avisoAux.getAviso() != null && avisoID == avisoAux.getAviso().getID()) {
                bID = true;
            }
            if (!bID) continue;
            bEncontrado = true;
        }
        return bEncontrado;
    }
}

