/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.TrCondicionTareaFase;
import modela.bd.obj.TrTipoTarea;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.PropCondicionTareaEnFaseJPanel;
import modela.ui.swing.renderers.AtributosListRenderer;

public class MantenimientoCondicionTareaEnFaseJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = 3942892623797661934L;
    PropCondicionTareaEnFaseJPanel pPanel;
    private JLabel tituloLabel = new JLabel("Condiciones asociadas");
    private DDPGrafico grafico = null;
    private TrTipoTarea m_tipoTarea = null;
    private final int ANCHO_ACTUAL = 650;
    private final int ALTO_ACTUAL = 515;

    public MantenimientoCondicionTareaEnFaseJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public MantenimientoCondicionTareaEnFaseJDialog(TrTipoTarea tipoTarea) {
        try {
            this.m_tipoTarea = tipoTarea;
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.setTitle("Mantenimiento de condiciones en tarea en fase");
        this.pPanel = new PropCondicionTareaEnFaseJPanel();
        this.pPanel.inicializarCampos(7);
        this.pPanel.setTipoTarea(this.m_tipoTarea);
        this.setPanelAtributable(this.pPanel);
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.tituloLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.tituloLabel.setForeground(ModelaUI.colorSeleccion);
        this.botones.permitirEliminar(true);
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                if (e.getSource() != null) {
                    if (e.getClickCount() == 2) {
                        MantenimientoCondicionTareaEnFaseJDialog.this.dobleClick();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = MantenimientoCondicionTareaEnFaseJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index <= MantenimientoCondicionTareaEnFaseJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = MantenimientoCondicionTareaEnFaseJDialog.this.listaAsignable.getElementAt(index);
                        MantenimientoCondicionTareaEnFaseJDialog.this.establecerModoTrabajo(2);
                        MantenimientoCondicionTareaEnFaseJDialog.this.pPanel.setValoresAsignables(objAsig);
                        MantenimientoCondicionTareaEnFaseJDialog.this.botones.modificarButton_mousePressed(e);
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (MantenimientoCondicionTareaEnFaseJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoCondicionTareaEnFaseJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoCondicionTareaEnFaseJDialog.this.establecerModoTrabajo(7);
                    MantenimientoCondicionTareaEnFaseJDialog.this.pPanel.limpiarCampos();
                    return;
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                if (MantenimientoCondicionTareaEnFaseJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoCondicionTareaEnFaseJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoCondicionTareaEnFaseJDialog.this.establecerModoTrabajo(7);
                    MantenimientoCondicionTareaEnFaseJDialog.this.pPanel.limpiarCampos();
                } else {
                    IAsignable objAsig = (IAsignable)MantenimientoCondicionTareaEnFaseJDialog.this.listaAsignable.getSelectedValue();
                    MantenimientoCondicionTareaEnFaseJDialog.this.establecerModoTrabajo(2);
                    MantenimientoCondicionTareaEnFaseJDialog.this.pPanel.setValoresAsignables(objAsig);
                    MantenimientoCondicionTareaEnFaseJDialog.this.botones.modificarButton_mousePressed(null);
                }
            }
        });
        this.listaAsignable.setCellRenderer(new AtributosListRenderer());
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 15, 170, 25));
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 4);
        ModelaConf.setVentanaActiva(this);
    }

    public boolean eliminarElemento() {
        if (this.grafico == null) {
            return false;
        }
        if (this.grafico.getDestructorDDP() == null) {
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            return false;
        }
        String msgPanel = new String();
        this.establecerModoTrabajo(2);
        int nElementos = this.listaAsignable.getSelectedValues().length;
        Object[] options = new Object[]{"Aceptar", "Cancelar"};
        msgPanel = nElementos > 1 ? "\u00bfConfirma eliminar los elementos seleccionados?" : "\u00bfConfirma eliminar el elemento seleccionado?";
        int n = JOptionPane.showOptionDialog(this, msgPanel, "Eliminar", 0, 3, null, options, options[1]);
        if (n == -1) {
            n = 1;
        }
        if (n == 1) {
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        this.refrescarGrafico();
        int[] indicesEliminar = this.listaAsignable.getSelectedIndices();
        for (int ind = indicesEliminar.length - 1; ind >= 0; --ind) {
            this.listaAsignable.removeItem(indicesEliminar[ind]);
        }
        this.listaAsignable.setSelectedIndex(-1);
        this.establecerModoTrabajo(7);
        this.pPanel.limpiarCampos();
        return true;
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        return true;
    }

    public boolean insertarElemento() {
        this.establecerModoTrabajo(1);
        this.pPanel.inicializarFoco();
        return true;
    }

    public boolean aplicar() {
        boolean bRespuesta = false;
        if (this.getAccion() == 1) {
            bRespuesta = this.aplicarNuevo();
        } else if (this.getAccion() == 3) {
            bRespuesta = this.aplicarModificar();
        }
        if (!bRespuesta) {
            this.botones.setModoModificarPorDefault(false);
        }
        return bRespuesta;
    }

    public boolean aplicarNuevo() {
        TrCondicionTareaFase condicion;
        double condicionID = this.pPanel.getCondicionSeleccionada();
        if (!this.comprobarExistenciaCondicion(condicionID, -1)) {
            condicion = null;
            if (!this.pPanel.obtenerValoresCampos()) {
                return false;
            }
            condicion = (TrCondicionTareaFase)this.pPanel.getValoresAsignables();
            if (condicion == null) {
                return false;
            }
        } else {
            JOptionPane.showMessageDialog(this, "Imposible asociar la condici\u00f3n:\nLa condici\u00f3n ya existe en la lista de condiciones en tarea en fase.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        this.listaAsignable.addItem(condicion);
        this.listaAsignable.setSelectedValue(condicion, true);
        this.listaAsignable.updateUI();
        return true;
    }

    public boolean aplicarModificar() {
        int nSelectedIndex;
        double condicionID = this.pPanel.getCondicionSeleccionada();
        if (!this.comprobarExistenciaCondicion(condicionID, nSelectedIndex = this.listaAsignable.getSelectedIndex())) {
            if (!this.pPanel.obtenerValoresCampos()) {
                return false;
            }
        } else {
            JOptionPane.showMessageDialog(this, "Imposible asociar la condici\u00f3n:\nLa condici\u00f3n ya existe en la lista de condiciones en tarea en fase.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        this.listaAsignable.updateUI();
        return true;
    }

    public boolean refrescarGrafico() {
        if (this.elementosAsignados != null) {
            this.elementosAsignados.setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public boolean cancelar() {
        if (this.listaAsignable == null) {
            this.pPanel.limpiarCampos();
            this.establecerModoTrabajo(7);
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.pPanel.limpiarCampos();
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        this.listaAsignable.setSelectedIndex(index);
        IAsignable obj = this.listaAsignable.getElementAt(index);
        this.pPanel.setValoresAsignables(obj);
        this.establecerModoTrabajo(2);
        return true;
    }

    public void cerrar() {
        this.refrescarGrafico();
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        if (cdElementos != null) {
            cdElementos.ordenar();
        }
        super.inicializarListaElementos(cdElementos);
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
        this.pPanel.setGrafico(this.grafico);
    }

    public ConjuntoDatos getElementos() {
        ConjuntoDatos conjuntoAcciones = new ConjuntoDatos();
        conjuntoAcciones.setListaDatos(this.listaAsignable.toArrayList());
        return conjuntoAcciones;
    }

    public boolean comprobarExistenciaCondicion(double condicionID, int nSelectedIndex) {
        if (condicionID < 0.0) {
            return false;
        }
        if (this.listaAsignable.getNumItems() <= 0) {
            return false;
        }
        boolean bID = false;
        boolean bEncontrado = false;
        for (int i = 0; i < this.listaAsignable.getNumItems() && !bEncontrado; ++i) {
            bID = false;
            TrCondicionTareaFase condicionAux = (TrCondicionTareaFase)this.listaAsignable.getElementAt(i);
            if (condicionAux != null && i != nSelectedIndex && condicionAux.getCondicion() != null && condicionID == condicionAux.getCondicion().getID()) {
                bID = true;
            }
            if (!bID) continue;
            bEncontrado = true;
        }
        return bEncontrado;
    }
}

