/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import modela.conf.ModelaConf;
import modela.ui.ModelaUI;
import modela.ui.swing.PropOrganismoJPanel;

public class MantenimientoOrganismoJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = 8425906914930260427L;
    PropOrganismoJPanel pPanel;
    private final JLabel tituloLabel = new JLabel("Lista de organismos");
    IAsignable datosasignables = null;
    private final int ANCHO_ACTUAL = 790;
    private final int ALTO_ACTUAL = 560;

    public MantenimientoOrganismoJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.setModoModificarTrasBusqueda(false);
        this.setTitle("Selecci\u00f3n de organismos");
        this.pPanel = new PropOrganismoJPanel();
        this.pPanel.inicializarCampos(7);
        this.botones.setVisible(false);
        this.activarSeleccion(true);
        this.setPanelAtributable(this.pPanel);
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.tituloLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.tituloLabel.setForeground(ModelaUI.colorSeleccion);
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                if (e.getSource() != null) {
                    if (e.getClickCount() == 2) {
                        MantenimientoOrganismoJDialog.this.dobleClick();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = MantenimientoOrganismoJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index <= MantenimientoOrganismoJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = MantenimientoOrganismoJDialog.this.listaAsignable.getElementAt(index);
                        MantenimientoOrganismoJDialog.this.establecerModoTrabajo(2);
                        MantenimientoOrganismoJDialog.this.pPanel.setValoresAsignables(objAsig);
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (MantenimientoOrganismoJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoOrganismoJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoOrganismoJDialog.this.establecerModoTrabajo(7);
                    MantenimientoOrganismoJDialog.this.pPanel.limpiarCampos();
                    return;
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                if (MantenimientoOrganismoJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoOrganismoJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoOrganismoJDialog.this.establecerModoTrabajo(7);
                    MantenimientoOrganismoJDialog.this.pPanel.limpiarCampos();
                } else {
                    IAsignable objAsig = (IAsignable)MantenimientoOrganismoJDialog.this.listaAsignable.getSelectedValue();
                    MantenimientoOrganismoJDialog.this.establecerModoTrabajo(2);
                    MantenimientoOrganismoJDialog.this.pPanel.setValoresAsignables(objAsig);
                }
            }
        });
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 15, 170, 25));
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 0);
        ModelaConf.setVentanaActiva(this);
    }

    public void cerrar() {
        this.refrescarGrafico();
    }

    public boolean refrescarGrafico() {
        if (this.elementosAsignados != null) {
            this.elementosAsignados.setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        cdElementos.ordenar();
        super.inicializarListaElementos(cdElementos);
    }
}

