/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.TrPerfilTransEvol;
import modela.bd.obj.TrTransicionDefProcedimiento;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.Portapapeles;
import modela.ui.swing.PropPerfilTransicionJPanel;

public class MantenimientoPerfilTransicionJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = 8052960780167510110L;
    PropPerfilTransicionJPanel pPanel;
    private final JLabel tituloLabel = new JLabel("Perfiles asociados");
    DDPGrafico grafico = null;
    private final int ANCHO_ACTUAL = 600;
    private final int ALTO_ACTUAL = 515;
    TrTransicionDefProcedimiento transicionDefProc = null;

    public MantenimientoPerfilTransicionJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.setTitle("Mantenimiento de perfiles en transici\u00f3n");
        this.pPanel = new PropPerfilTransicionJPanel();
        this.pPanel.inicializarCampos(7);
        this.transicionDefProc = null;
        this.setPanelAtributable(this.pPanel);
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.tituloLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.tituloLabel.setForeground(ModelaUI.colorSeleccion);
        this.botones.permitirEliminar(true);
        this.listaAsignable.setTipoAlmacenado(1);
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    if (MantenimientoPerfilTransicionJDialog.this.listaAsignable.crearPopupMenu() && !MantenimientoPerfilTransicionJDialog.this.listaAsignable.popup.isVisible()) {
                        Portapapeles.setGrafico(MantenimientoPerfilTransicionJDialog.this.grafico);
                        MantenimientoPerfilTransicionJDialog.this.listaAsignable.popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                    return;
                }
                if (e.getSource() != null) {
                    if (e.getClickCount() == 2) {
                        MantenimientoPerfilTransicionJDialog.this.dobleClick();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = MantenimientoPerfilTransicionJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index <= MantenimientoPerfilTransicionJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = MantenimientoPerfilTransicionJDialog.this.listaAsignable.getElementAt(index);
                        MantenimientoPerfilTransicionJDialog.this.establecerModoTrabajo(2);
                        MantenimientoPerfilTransicionJDialog.this.pPanel.setValoresAsignables(objAsig);
                        if (!MantenimientoPerfilTransicionJDialog.this.isDesdeSeleccionLimitada()) {
                            MantenimientoPerfilTransicionJDialog.this.botones.modificarButton_mousePressed(e);
                        }
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (MantenimientoPerfilTransicionJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoPerfilTransicionJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoPerfilTransicionJDialog.this.establecerModoTrabajo(7);
                    MantenimientoPerfilTransicionJDialog.this.pPanel.limpiarCampos();
                    return;
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                if (MantenimientoPerfilTransicionJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoPerfilTransicionJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoPerfilTransicionJDialog.this.establecerModoTrabajo(7);
                    MantenimientoPerfilTransicionJDialog.this.pPanel.limpiarCampos();
                } else {
                    IAsignable objAsig = (IAsignable)MantenimientoPerfilTransicionJDialog.this.listaAsignable.getSelectedValue();
                    MantenimientoPerfilTransicionJDialog.this.establecerModoTrabajo(2);
                    MantenimientoPerfilTransicionJDialog.this.pPanel.setValoresAsignables(objAsig);
                    if (!MantenimientoPerfilTransicionJDialog.this.isDesdeSeleccionLimitada()) {
                        MantenimientoPerfilTransicionJDialog.this.botones.modificarButton_mousePressed(null);
                    }
                }
            }
        });
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 15, 170, 25));
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 4);
        ModelaConf.setVentanaActiva(this);
    }

    public boolean eliminarElemento() {
        if (this.grafico == null) {
            return false;
        }
        if (this.grafico.getDestructorDDP() == null) {
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            return false;
        }
        String msgPanel = new String();
        this.establecerModoTrabajo(2);
        int nElementos = this.listaAsignable.getSelectedValues().length;
        Object[] options = new Object[]{"Aceptar", "Cancelar"};
        msgPanel = nElementos > 1 ? "\u00bfConfirma eliminar los elementos seleccionados?" : "\u00bfConfirma eliminar el elemento seleccionado?";
        int n = JOptionPane.showOptionDialog(this, msgPanel, "Eliminar", 0, 3, null, options, options[1]);
        if (n == -1) {
            n = 1;
        }
        if (n == 1) {
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        this.refrescarGrafico();
        int[] indicesEliminar = this.listaAsignable.getSelectedIndices();
        for (int ind = indicesEliminar.length - 1; ind >= 0; --ind) {
            this.listaAsignable.removeItem(indicesEliminar[ind]);
        }
        this.listaAsignable.setSelectedIndex(-1);
        this.establecerModoTrabajo(7);
        this.pPanel.limpiarCampos();
        if (this.transicionDefProc != null) {
            this.transicionDefProc.getConjuntoPerfilTransEvol().setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        return true;
    }

    public boolean insertarElemento() {
        this.establecerModoTrabajo(1);
        this.pPanel.inicializarFoco();
        return true;
    }

    public void setTransicionDefProc(TrTransicionDefProcedimiento transiAsociada) {
        this.transicionDefProc = transiAsociada;
    }

    public boolean aplicar() {
        boolean bRespuesta = false;
        if (this.getAccion() == 1) {
            bRespuesta = this.aplicarNuevo();
        } else if (this.getAccion() == 3) {
            bRespuesta = this.aplicarModificar();
        }
        if (!bRespuesta) {
            this.botones.setModoModificarPorDefault(false);
        }
        return bRespuesta;
    }

    public boolean aplicarNuevo() {
        TrPerfilTransEvol perfilInicial = (TrPerfilTransEvol)this.pPanel.getValoresAsignablesTemporales();
        if (!this.comprobarExistenciaPerfil(perfilInicial, -1)) {
            TrPerfilTransEvol perfil = null;
            if (!this.pPanel.obtenerValoresCampos()) {
                return false;
            }
            perfil = (TrPerfilTransEvol)this.pPanel.getValoresAsignables();
            if (perfil == null) {
                return false;
            }
            this.listaAsignable.addItem(perfil);
            this.listaAsignable.setSelectedValue(perfil, true);
            this.listaAsignable.updateUI();
            if (this.transicionDefProc != null) {
                this.transicionDefProc.getConjuntoPerfilTransEvol().setListaDatos(this.listaAsignable.toArrayList());
            }
        } else {
            JOptionPane.showMessageDialog(this, "Imposible asociar el perfil:\nEl perfil ya existe en la lista de perfiles en transici\u00f3n.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        return true;
    }

    public boolean aplicarModificar() {
        int nSelectedIndex;
        TrPerfilTransEvol perfilInicial = (TrPerfilTransEvol)this.pPanel.getValoresAsignablesTemporales();
        if (!this.comprobarExistenciaPerfil(perfilInicial, nSelectedIndex = this.listaAsignable.getSelectedIndex())) {
            if (!this.pPanel.obtenerValoresCampos()) {
                return false;
            }
            this.listaAsignable.updateUI();
            if (this.transicionDefProc != null) {
                this.transicionDefProc.getConjuntoPerfilTransEvol().setListaDatos(this.listaAsignable.toArrayList());
            }
        } else {
            JOptionPane.showMessageDialog(this, "Imposible asociar el perfil:\nEl perfil ya existe en la lista de perfiles en transici\u00f3n.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        return true;
    }

    public boolean refrescarGrafico() {
        if (this.elementosAsignados != null) {
            this.elementosAsignados.setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public boolean cancelar() {
        if (this.listaAsignable == null) {
            this.pPanel.limpiarCampos();
            this.establecerModoTrabajo(7);
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.pPanel.limpiarCampos();
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        this.listaAsignable.setSelectedIndex(index);
        IAsignable obj = this.listaAsignable.getElementAt(index);
        this.pPanel.setValoresAsignables(obj);
        this.establecerModoTrabajo(2);
        return true;
    }

    public void cerrar() {
        this.refrescarGrafico();
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        if (cdElementos != null) {
            cdElementos.ordenar();
        }
        super.inicializarListaElementos(cdElementos);
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
        this.pPanel.setGrafico(this.grafico);
    }

    public boolean comprobarExistenciaPerfil(TrPerfilTransEvol perfil, int nSelectedIndex) {
        if (this.listaAsignable.getNumItems() <= 0) {
            return false;
        }
        if (perfil == null) {
            return false;
        }
        boolean bID = false;
        boolean bEncontrado = false;
        for (int i = 0; i < this.listaAsignable.getNumItems() && !bEncontrado; ++i) {
            bID = false;
            TrPerfilTransEvol perfilAux = (TrPerfilTransEvol)this.listaAsignable.getElementAt(i);
            if (perfilAux != null && i != nSelectedIndex && perfil.getPERFIL() != null && perfilAux.getPERFIL() != null && perfil.getPERFIL().getID() == perfilAux.getPERFIL().getID()) {
                bID = true;
            }
            if (!bID) continue;
            bEncontrado = true;
        }
        return bEncontrado;
    }
}

