/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.ConjuntoDatosTareaFaseDefProcedimiento;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrTareaEnFase;
import modela.bd.obj.TrTareaEnFaseDefProcedimiento;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.Portapapeles;
import modela.ui.swing.PropTareaEnFaseDefProcJPanel;
import modela.ui.swing.filtros.TareaEnFaseDefProcListModelFilter;
import modela.ui.swing.renderers.TareaEnFaseCellRenderer;

public class MantenimientoTareaEnFaseDefProcJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = -1140168896851757432L;
    private PropTareaEnFaseDefProcJPanel pPanel;
    private final JLabel tituloListaLabel = new JLabel();
    DDPGrafico grafico = null;
    private final JLabel jLabel1 = new JLabel();
    public static final String TAREA_GENERAR = "TAREA_GENERAR";
    public static final String TAREA_INCORPORAR = "TAREA_INCORPORAR";
    public static final String TAREA_MANIPULAR = "TAREA_MANIPULAR";
    TrFase m_faseActiva = null;
    private TareaEnFaseDefProcListModelFilter model;
    private final int ANCHO_ACTUAL = 800;
    private final int ALTO_ACTUAL = 515;

    public MantenimientoTareaEnFaseDefProcJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.setPPanel(new PropTareaEnFaseDefProcJPanel());
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.setPanelAtributable(this.getPPanel());
        this.establecerModoTrabajo(7);
        this.tituloListaLabel.setText("Tareas en fase ...");
        this.tituloListaLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.jLabel1.setText("Lista de tareas en fase actual");
        this.jLabel1.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.jLabel1.setForeground(ModelaUI.colorSeleccion);
        this.setTitle("Mantenimiento de tareas en fase para la definici\u00f3n del procedimiento");
        this.listaAsignable.setTipoAlmacenado(6);
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    if (MantenimientoTareaEnFaseDefProcJDialog.this.listaAsignable.crearPopupMenu() && !MantenimientoTareaEnFaseDefProcJDialog.this.listaAsignable.popup.isVisible()) {
                        Portapapeles.setGrafico(MantenimientoTareaEnFaseDefProcJDialog.this.grafico);
                        Portapapeles.setFaseActiva(MantenimientoTareaEnFaseDefProcJDialog.this.m_faseActiva);
                        MantenimientoTareaEnFaseDefProcJDialog.this.listaAsignable.popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                    return;
                }
                if (e.getSource() != null) {
                    if (e.getClickCount() == 2) {
                        MantenimientoTareaEnFaseDefProcJDialog.this.dobleClick();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = MantenimientoTareaEnFaseDefProcJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index < MantenimientoTareaEnFaseDefProcJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = MantenimientoTareaEnFaseDefProcJDialog.this.listaAsignable.getElementAt(index);
                        MantenimientoTareaEnFaseDefProcJDialog.this.establecerModoTrabajo(2);
                        MantenimientoTareaEnFaseDefProcJDialog.this.getPPanel().setValoresAsignables(objAsig);
                        MantenimientoTareaEnFaseDefProcJDialog.this.getPPanel().actualizarListas();
                        if (!MantenimientoTareaEnFaseDefProcJDialog.this.isDesdeSeleccionLimitada()) {
                            MantenimientoTareaEnFaseDefProcJDialog.this.botones.modificarButton_mousePressed(e);
                        }
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (MantenimientoTareaEnFaseDefProcJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoTareaEnFaseDefProcJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoTareaEnFaseDefProcJDialog.this.establecerModoTrabajo(7);
                    MantenimientoTareaEnFaseDefProcJDialog.this.getPPanel().limpiarCampos();
                    return;
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                if (MantenimientoTareaEnFaseDefProcJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoTareaEnFaseDefProcJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoTareaEnFaseDefProcJDialog.this.establecerModoTrabajo(7);
                    MantenimientoTareaEnFaseDefProcJDialog.this.getPPanel().limpiarCampos();
                } else if (!MantenimientoTareaEnFaseDefProcJDialog.this.getPPanel().haySeleccionMultiple()) {
                    IAsignable objAsig = (IAsignable)MantenimientoTareaEnFaseDefProcJDialog.this.listaAsignable.getSelectedValue();
                    MantenimientoTareaEnFaseDefProcJDialog.this.establecerModoTrabajo(2);
                    MantenimientoTareaEnFaseDefProcJDialog.this.getPPanel().setValoresAsignables(objAsig);
                    if (!MantenimientoTareaEnFaseDefProcJDialog.this.isDesdeSeleccionLimitada()) {
                        MantenimientoTareaEnFaseDefProcJDialog.this.botones.modificarButton_mousePressed(null);
                    }
                }
            }
        });
        this.getContentPane().add((Component)this.jLabel1, new XYConstraints(20, 15, 185, 20));
        this.listaAsignable.setCellRenderer(new TareaEnFaseCellRenderer());
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 4);
        ModelaConf.setVentanaActiva(this);
    }

    public boolean eliminarElemento() {
        if (this.grafico == null) {
            return false;
        }
        if (this.grafico.getDestructorDDP() == null) {
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            return false;
        }
        String msgPanel = new String();
        int[] indicesOriginal = this.listaAsignable.getSelectedIndices();
        this.establecerModoTrabajo(2);
        int nElementos = this.listaAsignable.getSelectedValues().length;
        Object[] options = new Object[]{"Aceptar", "Cancelar"};
        msgPanel = nElementos > 1 ? "\u00bfConfirma eliminar los elementos seleccionados?" : "\u00bfConfirma eliminar el elemento seleccionado?";
        int n = JOptionPane.showOptionDialog(this, msgPanel, "Eliminar", 0, 3, null, options, options[1]);
        if (n == -1) {
            n = 1;
        }
        if (n == 1) {
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.getPPanel().restaurarColoresDeFondo();
            return false;
        }
        this.refrescarGrafico();
        int resulEliminar = this.grafico.getDestructorDDP().eliminarTareasEnFaseDefProc(this.listaAsignable.getSelectedValues());
        if (resulEliminar == 0) {
            msgPanel = nElementos > 1 ? "Ha sido imposible eliminar los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades." : "Ha sido imposible eliminar el elemento seleccionado.\nCompruebe que no est\u00e1 intentando eliminar un elemento relacionado con otras entidades.";
            JOptionPane.showMessageDialog(this, msgPanel, "Atenci\u00f3n", 2);
            this.listaAsignable.setSelectedIndices(indicesOriginal);
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.getPPanel().restaurarColoresDeFondo();
            return false;
        }
        if (resulEliminar < nElementos) {
            JOptionPane.showMessageDialog(this, "Ha sido imposible eliminar alguno de los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades.", "Atenci\u00f3n", 2);
        }
        if (this.m_faseActiva != null && this.m_faseActiva.getConjuntoTareasEnFase() != null && this.grafico != null) {
            this.setFaseActiva(this.m_faseActiva);
            this.inicializarListaElementos(this.grafico.getTareaFaseDefProcInvolucradas());
        }
        this.listaAsignable.setSelectedIndex(-1);
        this.establecerModoTrabajo(7);
        this.getPPanel().limpiarCampos();
        return true;
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        return true;
    }

    public boolean insertarElemento() {
        this.establecerModoTrabajo(1);
        this.getPPanel().inicializarFoco();
        this.getPPanel().lanzarSeleccionTarea();
        return true;
    }

    public boolean aplicar() {
        boolean bRespuesta = false;
        if (this.getAccion() == 1) {
            bRespuesta = this.aplicarNuevo();
        } else if (this.getAccion() == 3) {
            bRespuesta = this.aplicarModificar();
        }
        if (!bRespuesta) {
            this.botones.setModoModificarPorDefault(false);
        }
        return bRespuesta;
    }

    public boolean aplicarNuevo() {
        TrTareaEnFaseDefProcedimiento tareaFaseDefProc = null;
        TrTareaEnFase tareaFase = this.getPPanel().getTareaEnFaseActual();
        if (!this.getPPanel().obtenerValoresCampos()) {
            this.getPPanel().inicializarCampos(3);
            this.getPPanel().activarOperacionesListas(false);
            return false;
        }
        if (!this.comprobarExistenciaTareaEnFase(-1.0, tareaFase.getID())) {
            if (!this.getPPanel().obtenerValoresCampos()) {
                return false;
            }
            tareaFaseDefProc = (TrTareaEnFaseDefProcedimiento)this.getPPanel().getValoresAsignables();
            if (tareaFaseDefProc == null) {
                return false;
            }
        } else {
            JOptionPane.showMessageDialog(this, "Imposible asociar la tarea en fase:\nYa existe una tarea en fase con estas caracter\u00edsticas asociada al procedimiento.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        this.listaAsignable.addItem(tareaFaseDefProc);
        this.aplicarFiltro(false);
        this.listaAsignable.setSelectedValue(tareaFaseDefProc, true);
        this.listaAsignable.updateUI();
        return true;
    }

    public boolean aplicarModificar() {
        TrTareaEnFase tareaFase = this.getPPanel().getTareaEnFaseActual();
        TrTareaEnFaseDefProcedimiento tareaFaseDefProc = (TrTareaEnFaseDefProcedimiento)this.getPPanel().getValoresAsignables();
        if (tareaFase == null) {
            return false;
        }
        if (tareaFaseDefProc == null) {
            return false;
        }
        if (!this.comprobarExistenciaTareaEnFase(tareaFaseDefProc.getID(), tareaFase.getID())) {
            if (!this.getPPanel().obtenerValoresCampos()) {
                return false;
            }
        } else {
            JOptionPane.showMessageDialog(this, "Imposible asociar la tarea en fase:\nYa existe una tarea en fase con estas caracter\u00edsticas asociada al procedimiento.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        this.listaAsignable.updateUI();
        this.aplicarFiltro(false);
        return true;
    }

    public boolean cancelar() {
        if (this.listaAsignable == null) {
            this.getPPanel().limpiarCampos();
            this.establecerModoTrabajo(7);
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.getPPanel().limpiarCampos();
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        this.listaAsignable.setSelectedIndex(index);
        IAsignable obj = this.listaAsignable.getElementAt(index);
        this.getPPanel().setValoresAsignables(obj);
        this.establecerModoTrabajo(2);
        return true;
    }

    public boolean refrescarGrafico() {
        if (this.elementosAsignados != null) {
            ((ConjuntoDatosTareaFaseDefProcedimiento)this.elementosAsignados).setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public void cerrar() {
        this.refrescarGrafico();
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        if (cdElementos != null) {
            cdElementos.ordenar();
        }
        super.inicializarListaElementos(cdElementos);
        this.aplicarFiltro(true);
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
        this.getPPanel().setGrafico(this.grafico);
    }

    public void setTextoFaseActual(String str) {
        this.getPPanel().setTextoFaseActual(str);
    }

    public void setFaseActiva(TrFase fase) {
        this.m_faseActiva = fase;
        if (this.getPPanel() != null) {
            this.getPPanel().setFaseActiva(fase);
        }
    }

    public boolean comprobarExistenciaTareaEnFase(double tareaFaseDefProcID, double tareaFaseID) {
        if (this.listaAsignable.getNumItems() <= 0) {
            return false;
        }
        for (int i = 0; i < this.listaAsignable.getNumItems(); ++i) {
            TrTareaEnFaseDefProcedimiento t = (TrTareaEnFaseDefProcedimiento)this.listaAsignable.getElementAt(i);
            if (t == null || t.getID() == tareaFaseDefProcID || t.getTareaEnFase() == null || t.getTareaEnFase().getID() != tareaFaseID) continue;
            return true;
        }
        return false;
    }

    private void aplicarFiltro(boolean bCrearModel) {
        if (this.m_faseActiva != null) {
            if (bCrearModel) {
                this.model = new TareaEnFaseDefProcListModelFilter(this.listaAsignable.getModel());
                this.model.setTareasEnFaseDefProc(this.m_faseActiva.getFASEID());
                this.listaAsignable.setFiltro(this.model);
            } else if (this.model != null) {
                this.model.setTareasEnFaseDefProc(this.m_faseActiva.getFASEID());
            }
        }
    }

    public void setPPanel(PropTareaEnFaseDefProcJPanel pPanel) {
        this.pPanel = pPanel;
    }

    public PropTareaEnFaseDefProcJPanel getPPanel() {
        return this.pPanel;
    }
}

