/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.ConjuntoDatosTipoActo;
import modela.bd.obj.TrTipoActo;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.PropTipoActoJPanel;

public class MantenimientoTipoActoJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = 2923486780233194842L;
    PropTipoActoJPanel pPanel;
    private final JLabel listaLabel = new JLabel();
    private DDPGrafico grafico = null;
    private final int ANCHO_ACTUAL = 600;
    private final int ALTO_ACTUAL = 515;

    public MantenimientoTipoActoJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() {
        this.pPanel = new PropTipoActoJPanel();
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.setTitle(this.pPanel.getTitulo(0));
        this.setPanelAtributable(this.pPanel);
        this.establecerModoTrabajo(7);
        this.listaLabel.setText("Lista de tipos de actos");
        this.listaLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.listaLabel.setForeground(ModelaUI.colorSeleccion);
        this.botones.permitirEliminar(true);
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                if (e.getSource() != null) {
                    if (e.getClickCount() == 2) {
                        MantenimientoTipoActoJDialog.this.dobleClick();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = MantenimientoTipoActoJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index < MantenimientoTipoActoJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = MantenimientoTipoActoJDialog.this.listaAsignable.getElementAt(index);
                        MantenimientoTipoActoJDialog.this.establecerModoTrabajo(2);
                        MantenimientoTipoActoJDialog.this.pPanel.setValoresAsignables(objAsig);
                        MantenimientoTipoActoJDialog.this.botones.modificarButton_mousePressed(e);
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (MantenimientoTipoActoJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoTipoActoJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoTipoActoJDialog.this.establecerModoTrabajo(7);
                    MantenimientoTipoActoJDialog.this.pPanel.limpiarCampos();
                    return;
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                if (MantenimientoTipoActoJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoTipoActoJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoTipoActoJDialog.this.establecerModoTrabajo(7);
                    MantenimientoTipoActoJDialog.this.pPanel.limpiarCampos();
                } else {
                    IAsignable objAsig = (IAsignable)MantenimientoTipoActoJDialog.this.listaAsignable.getSelectedValue();
                    MantenimientoTipoActoJDialog.this.establecerModoTrabajo(2);
                    MantenimientoTipoActoJDialog.this.pPanel.setValoresAsignables(objAsig);
                    MantenimientoTipoActoJDialog.this.botones.modificarButton_mousePressed(null);
                }
            }
        });
        this.getContentPane().add((Component)this.listaLabel, new XYConstraints(20, 15, 150, 25));
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 4);
        ModelaConf.setVentanaActiva(this);
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        return true;
    }

    public boolean insertarElemento() {
        this.establecerModoTrabajo(1);
        this.pPanel.inicializarFoco();
        return true;
    }

    public boolean aplicar() {
        boolean bRespuesta = false;
        if (this.getAccion() == 1) {
            bRespuesta = this.aplicarNuevo();
        } else if (this.getAccion() == 3) {
            bRespuesta = this.aplicarModificar();
        }
        if (!bRespuesta) {
            this.botones.setModoModificarPorDefault(false);
        }
        return bRespuesta;
    }

    public boolean aplicarNuevo() {
        TrTipoActo acto = null;
        if (!this.pPanel.obtenerValoresCampos()) {
            return false;
        }
        acto = (TrTipoActo)this.pPanel.getValoresAsignables();
        if (acto == null) {
            return false;
        }
        if (this.grafico.getTiposActoInvolucrados().existeElemento(acto, true) != null) {
            JOptionPane.showMessageDialog(this, "Imposible crear el tipo:\nYa existe un tipo con la abreviatura indicada.", "Atenci\u00f3n", 2);
            return false;
        }
        this.listaAsignable.addItem(acto);
        this.listaAsignable.setSelectedValue(acto, true);
        this.listaAsignable.updateUI();
        if (this.grafico != null) {
            ConjuntoDatosTipoActo c = new ConjuntoDatosTipoActo();
            c.setListaDatos(this.listaAsignable.toArrayList());
            this.grafico.setTiposActoInvolucrados(c);
        }
        return true;
    }

    public boolean aplicarModificar() {
        if ((TrTipoActo)this.listaAsignable.getElementAt(this.listaAsignable.getSelectedIndex()) == null) {
            return false;
        }
        TrTipoActo tipoAux = new TrTipoActo();
        tipoAux.setTIPOID(((TrTipoActo)this.listaAsignable.getElementAt(this.listaAsignable.getSelectedIndex())).getTIPOID());
        tipoAux.setABREVIATURA(this.pPanel.getAbreviaturaTmp());
        if (this.grafico.getTiposActoInvolucrados().existeElemento(tipoAux, true) != null) {
            JOptionPane.showMessageDialog(this, "Imposible modificar:\nYa existe un tipo con la abreviatura indicada.", "Atenci\u00f3n", 2);
            return false;
        }
        if (!this.pPanel.obtenerValoresCampos()) {
            return false;
        }
        this.listaAsignable.updateUI();
        return true;
    }

    public boolean refrescarGrafico() {
        if (this.elementosAsignados != null) {
            ((ConjuntoDatosTipoActo)this.elementosAsignados).setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public boolean cancelar() {
        if (this.listaAsignable == null) {
            this.pPanel.limpiarCampos();
            this.establecerModoTrabajo(7);
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.pPanel.limpiarCampos();
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        this.listaAsignable.setSelectedIndex(index);
        IAsignable obj = this.listaAsignable.getElementAt(index);
        this.pPanel.setValoresAsignables(obj);
        this.establecerModoTrabajo(2);
        return true;
    }

    public void cerrar() {
        this.refrescarGrafico();
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        cdElementos.ordenar();
        super.inicializarListaElementos(cdElementos);
    }

    public boolean eliminarElemento() {
        if (this.grafico == null) {
            return false;
        }
        if (this.grafico.getDestructorDDP() == null) {
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            return false;
        }
        String msgPanel = new String();
        int[] indicesOriginal = this.listaAsignable.getSelectedIndices();
        this.establecerModoTrabajo(2);
        int nElementos = this.listaAsignable.getSelectedValues().length;
        Object[] options = new Object[]{"Aceptar", "Cancelar"};
        msgPanel = nElementos > 1 ? "\u00bfConfirma eliminar los elementos seleccionados?" : "\u00bfConfirma eliminar el elemento seleccionado?";
        int n = JOptionPane.showOptionDialog(this, msgPanel, "Eliminar", 0, 3, null, options, options[1]);
        if (n == -1) {
            n = 1;
        }
        if (n == 1) {
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        this.refrescarGrafico();
        int resulEliminar = this.grafico.getDestructorDDP().eliminarTiposActo(this.listaAsignable.getSelectedValues());
        if (resulEliminar == 0) {
            msgPanel = nElementos > 1 ? "Ha sido imposible eliminar los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades." : "Ha sido imposible eliminar el elemento seleccionado.\nCompruebe que no est\u00e1 intentando eliminar un elemento relacionado con otras entidades.";
            JOptionPane.showMessageDialog(this, msgPanel, "Atenci\u00f3n", 2);
            this.listaAsignable.setSelectedIndices(indicesOriginal);
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        if (resulEliminar < nElementos) {
            JOptionPane.showMessageDialog(this, "Ha sido imposible eliminar alguno de los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades.", "Atenci\u00f3n", 2);
        }
        this.listaAsignable.setSelectedIndex(-1);
        this.establecerModoTrabajo(7);
        this.pPanel.limpiarCampos();
        this.inicializarListaElementos(this.grafico.getTiposActoInvolucrados());
        return true;
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        if (nuevoGrafico.getDDP().getTIPOEVOL() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
    }
}

