/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import gdtel.ui.swing.excontrols.CreadorButton;
import gdtel.ui.swing.excontrols.JCheckBoxEx;
import gdtel.ui.swing.excontrols.JComboBoxEx;
import gdtel.ui.swing.excontrols.JFiltroTextArea;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import gdtel.ui.swing.excontrols.JPanelAtributable;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import modela.bd.obj.TrCondicion;
import modela.bd.obj.TrTipoImplementacion;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.GeneradorCondicionesJDialog;
import modela.ui.swing.PropBloqueJPanel;

public class PropCondicionJPanel
extends JPanelAtributable {
    private static final long serialVersionUID = 5768120838030763106L;
    private DDPGrafico grafico = null;
    private final XYLayout xYLayout = new XYLayout();
    private final JLabel labelTitulo = new JLabel();
    private final JTabbedPane tabbedCondicion = new JTabbedPane();
    private final JPanel panelPropiedades = new JPanel();
    private final JLabel labelNombre = new JLabel();
    private final JFiltroTextField nombreTextField = new JFiltroTextField();
    private final JLabel labelImplementacion = new JLabel();
    private final JComboBoxEx cmbImplementacion = new JComboBoxEx();
    private final JLabel labelPaquete = new JLabel();
    private final JFiltroTextField paqueteTextField = new JFiltroTextField();
    private final JLabel labelFuncion = new JLabel();
    private final JFiltroTextField funcionTextField = new JFiltroTextField();
    private final JCheckBoxEx isV_ComplejaCheck = new JCheckBoxEx();
    JFiltroTextArea expresionComplejaTextArea = new JFiltroTextArea();
    ImageIcon generarIconN = new ImageIcon(PropCondicionJPanel.class.getResource(ModelaUI.IMG_SMALL_GENERAR));
    ImageIcon generarIconS = new ImageIcon(PropCondicionJPanel.class.getResource(ModelaUI.IMG_SMALL_GENERAR_SOBRE));
    ImageIcon generarIconD = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_GENERAR_NO_ENABLED));
    ImageIcon limpiarIconN = new ImageIcon(PropCondicionJPanel.class.getResource(ModelaUI.IMG_SMALL_LIMPIAR));
    ImageIcon limpiarIconS = new ImageIcon(PropCondicionJPanel.class.getResource(ModelaUI.IMG_SMALL_LIMPIAR_SOBRE));
    ImageIcon limpiarIconD = new ImageIcon(PropCondicionJPanel.class.getResource(ModelaUI.IMG_SMALL_LIMPIAR_NO_ENABLED));
    private final JButton generarExpresion = (JButton)CreadorButton.crearBoton(1, false, this.generarIconN, this.generarIconD, this.generarIconS, this.generarIconS);
    private final JButton limpiarExpresion = (JButton)CreadorButton.crearBoton(1, false, this.limpiarIconN, this.limpiarIconD, this.limpiarIconS, this.limpiarIconS);
    private final JLabel labelDescripcion = new JLabel();
    private final JFiltroTextArea decripTextArea = new JFiltroTextArea();
    private final JPanel panelParametros = new JPanel();
    JCheckBoxEx isExpCheck = new JCheckBoxEx();
    private final JCheckBoxEx isDocPermitidoCheck = new JCheckBoxEx();
    private final JCheckBoxEx isTransCheck = new JCheckBoxEx();
    private final JCheckBoxEx isExpEnFaseCheck = new JCheckBoxEx();
    private final JCheckBoxEx isTipoEvolCheck = new JCheckBoxEx();
    private final JCheckBoxEx isFechaCheck = new JCheckBoxEx();
    private final JCheckBoxEx isUsuarioCheck = new JCheckBoxEx();
    private final JCheckBoxEx isFaseCheck = new JCheckBoxEx();
    private final JCheckBoxEx isTipoDocCheck = new JCheckBoxEx();
    private final JLabel labelTextoLibre = new JLabel();
    private final JFiltroTextArea textoLibreTextArea = new JFiltroTextArea();
    private Color colorFondoNombre = null;
    private Color colorFondoTipoImplementacion = null;
    private Color colorFondoPaquete = null;
    private Color colorFondoFuncion = null;
    private Color colorFondoExpresion = null;
    private Color colorFondoDescripcion = null;
    private Color colorFondoExpediente = null;
    private Color colorFondoTransicion = null;
    private Color colorFondoUsuario = null;
    private Color colorFondoDocPermitido = null;
    private Color colorFondoExpedienteEnFase = null;
    private Color colorFondoFase = null;
    private Color colorFondoTipoEvolucion = null;
    private Color colorFondoFecha = null;
    private Color colorFondoTipoDocumento = null;
    private Color colorFondoTextoLibre = null;

    public PropCondicionJPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void jbInit() {
        this.setLayout(this.xYLayout);
        this.labelTitulo.setText("Propiedades de la condici\u00f3n");
        this.labelTitulo.setFont(ModelaUI.fuentePrincipalNegrita);
        this.labelTitulo.setForeground(ModelaUI.colorSeleccion);
        this.labelNombre.setText("Nombre:");
        this.labelNombre.setFont(ModelaUI.fuentePrincipalNegrita);
        this.labelImplementacion.setText("Tipo de implementaci\u00f3n:");
        this.labelPaquete.setText("Paquete:");
        this.labelFuncion.setText("Nombre funci\u00f3n:");
        this.isV_ComplejaCheck.setText("Expresi\u00f3n compleja");
        this.isV_ComplejaCheck.setFont(ModelaUI.fuentePrincipalNegrita);
        this.labelDescripcion.setText("Descripci\u00f3n:");
        this.labelDescripcion.setFont(ModelaUI.fuentePrincipalNegrita);
        this.isExpCheck.setText("Expediente");
        this.isExpCheck.setFont(ModelaUI.fuentePrincipalNegrita);
        this.isTransCheck.setText("Transici\u00f3n");
        this.isTransCheck.setFont(ModelaUI.fuentePrincipalNegrita);
        this.isUsuarioCheck.setText("Usuario");
        this.isUsuarioCheck.setFont(ModelaUI.fuentePrincipalNegrita);
        this.isDocPermitidoCheck.setText("Documento permitido");
        this.isDocPermitidoCheck.setFont(ModelaUI.fuentePrincipalNegrita);
        this.isExpEnFaseCheck.setText("Expediente en fase");
        this.isExpEnFaseCheck.setFont(ModelaUI.fuentePrincipalNegrita);
        this.isFaseCheck.setText("Fase");
        this.isFaseCheck.setFont(ModelaUI.fuentePrincipalNegrita);
        this.isTipoEvolCheck.setText("Tipo de evoluci\u00f3n");
        this.isTipoEvolCheck.setFont(ModelaUI.fuentePrincipalNegrita);
        this.isFechaCheck.setText("Fecha");
        this.isFechaCheck.setFont(ModelaUI.fuentePrincipalNegrita);
        this.isTipoDocCheck.setText("Tipo de documento");
        this.isTipoDocCheck.setFont(ModelaUI.fuentePrincipalNegrita);
        this.labelTextoLibre.setText("Texto libre:");
        this.nombreTextField.setNumItems(50);
        this.nombreTextField.establecerTipografia(1);
        this.nombreTextField.setTipoFiltro(1);
        this.nombreTextField.setEnabled(true);
        this.nombreTextField.setEditable(false);
        this.cmbImplementacion.setEditable(false);
        this.cargarCmbImplementacion();
        this.paqueteTextField.setNumItems(100);
        this.paqueteTextField.establecerTipografia(2);
        this.paqueteTextField.setTipoFiltro(1);
        this.paqueteTextField.setEnabled(true);
        this.paqueteTextField.setEditable(false);
        this.funcionTextField.setNumItems(50);
        this.funcionTextField.establecerTipografia(2);
        this.funcionTextField.setTipoFiltro(1);
        this.funcionTextField.setEnabled(true);
        this.funcionTextField.setEditable(false);
        this.isV_ComplejaCheck.setEnabled(false);
        this.expresionComplejaTextArea.setNumItems(4000);
        this.expresionComplejaTextArea.establecerTipografia(1);
        this.expresionComplejaTextArea.setTipoFiltro(1);
        this.expresionComplejaTextArea.setEnabled(false);
        this.expresionComplejaTextArea.setEditable(false);
        this.generarExpresion.setEnabled(false);
        this.limpiarExpresion.setEnabled(false);
        this.decripTextArea.setNumItems(250);
        this.decripTextArea.establecerTipografia(1);
        this.decripTextArea.setTipoFiltro(1);
        this.decripTextArea.setEnabled(true);
        this.decripTextArea.setEditable(false);
        this.isExpCheck.setEnabled(false);
        this.isTransCheck.setEnabled(false);
        this.isUsuarioCheck.setEnabled(false);
        this.isDocPermitidoCheck.setEnabled(false);
        this.isExpEnFaseCheck.setEnabled(false);
        this.isFaseCheck.setEnabled(false);
        this.isTipoEvolCheck.setEnabled(false);
        this.isFechaCheck.setEnabled(false);
        this.isTipoDocCheck.setEnabled(false);
        this.textoLibreTextArea.setNumItems(50);
        this.textoLibreTextArea.establecerTipografia(1);
        this.textoLibreTextArea.setTipoFiltro(1);
        this.textoLibreTextArea.setEnabled(true);
        this.textoLibreTextArea.setEditable(false);
        this.add((Component)this.labelTitulo, new XYConstraints(0, 0, 210, 15));
        this.panelPropiedades.setLayout(new XYLayout());
        this.panelPropiedades.add((Component)this.labelNombre, new XYConstraints(10, 10, 70, 20));
        this.panelPropiedades.add((Component)this.nombreTextField, new XYConstraints(75, 10, 337, 25));
        this.panelPropiedades.add((Component)this.labelImplementacion, new XYConstraints(10, 40, 300, 25));
        this.panelPropiedades.add((Component)this.cmbImplementacion, new XYConstraints(165, 40, 75, 25));
        this.panelPropiedades.add((Component)this.labelPaquete, new XYConstraints(12, 70, 100, 25));
        this.panelPropiedades.add((Component)this.paqueteTextField, new XYConstraints(75, 70, 337, 25));
        this.panelPropiedades.add((Component)this.labelFuncion, new XYConstraints(10, 100, 100, 25));
        this.panelPropiedades.add((Component)this.funcionTextField, new XYConstraints(115, 100, 297, 25));
        this.panelPropiedades.add((Component)this.isV_ComplejaCheck, new XYConstraints(11, 130, 210, 20));
        this.panelPropiedades.add((Component)this.expresionComplejaTextArea.getScrollableArea(), new XYConstraints(10, 150, 402, 55));
        this.panelPropiedades.add((Component)this.generarExpresion, new XYConstraints(205, 208, 100, 27));
        this.panelPropiedades.add((Component)this.limpiarExpresion, new XYConstraints(310, 208, 100, 27));
        this.panelPropiedades.add((Component)this.labelDescripcion, new XYConstraints(10, 227, 110, 20));
        this.panelPropiedades.add((Component)this.decripTextArea.getScrollableArea(), new XYConstraints(10, 247, 402, 60));
        this.panelParametros.setLayout(new XYLayout());
        this.panelParametros.add((Component)this.isExpCheck, new XYConstraints(10, 10, 100, 20));
        this.panelParametros.add((Component)this.isDocPermitidoCheck, new XYConstraints(108, 10, 165, 20));
        this.panelParametros.add((Component)this.isTipoEvolCheck, new XYConstraints(270, 10, 150, 20));
        this.panelParametros.add((Component)this.isTransCheck, new XYConstraints(10, 35, 95, 20));
        this.panelParametros.add((Component)this.isExpEnFaseCheck, new XYConstraints(108, 35, 155, 20));
        this.panelParametros.add((Component)this.isFechaCheck, new XYConstraints(270, 35, 70, 20));
        this.panelParametros.add((Component)this.isUsuarioCheck, new XYConstraints(10, 60, 80, 20));
        this.panelParametros.add((Component)this.isFaseCheck, new XYConstraints(108, 60, 60, 20));
        this.panelParametros.add((Component)this.isTipoDocCheck, new XYConstraints(270, 60, 150, 20));
        this.panelParametros.add((Component)this.labelTextoLibre, new XYConstraints(10, 90, 250, 20));
        this.panelParametros.add((Component)this.textoLibreTextArea.getScrollableArea(), new XYConstraints(10, 110, 402, 40));
        this.isV_ComplejaCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PropCondicionJPanel.this.activar_botonesPerformed();
            }
        });
        this.generarExpresion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropCondicionJPanel.this.btnGenerarExpresionCompleja(e);
            }
        });
        this.limpiarExpresion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropCondicionJPanel.this.expresionComplejaTextArea.setText("");
            }
        });
        this.decripTextArea.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                if (evt.getKeyChar() == '\t') {
                    PropCondicionJPanel.this.isExpCheck.requestFocus();
                }
            }
        });
        this.tabbedCondicion.add("Propiedades", this.panelPropiedades);
        this.tabbedCondicion.add("Par\u00e1metros", this.panelParametros);
        this.add((Component)this.tabbedCondicion, new XYConstraints(0, 25, 430, 340));
    }

    public void limpiarCampos() {
        this.nombreTextField.setText("");
        this.cmbImplementacion.setSelectedItem(TrTipoImplementacion.PLSQL);
        this.paqueteTextField.setText("");
        this.funcionTextField.setText("");
        this.isV_ComplejaCheck.setSelected(false);
        this.expresionComplejaTextArea.setText("");
        this.decripTextArea.setText("");
        this.isExpCheck.setSelected(false);
        this.isDocPermitidoCheck.setSelected(false);
        this.isTipoEvolCheck.setSelected(false);
        this.isTransCheck.setSelected(false);
        this.isExpEnFaseCheck.setSelected(false);
        this.isFechaCheck.setSelected(false);
        this.isUsuarioCheck.setSelected(false);
        this.isFaseCheck.setSelected(false);
        this.isTipoDocCheck.setSelected(false);
        this.textoLibreTextArea.setText("");
    }

    public void inicializarCampos(int nTipo) {
        boolean activo = false;
        boolean bReiniciarColoresLabel = true;
        switch (nTipo) {
            case 4: {
                this.conservarColoresDeFondo();
                bReiniciarColoresLabel = false;
                break;
            }
            case 2: {
                this.generarExpresion.setEnabled(false);
                this.limpiarExpresion.setEnabled(false);
                activo = false;
                bReiniciarColoresLabel = false;
                break;
            }
            case 3: {
                this.activar_botonesPerformed();
                activo = true;
                break;
            }
            case 1: {
                this.activar_botonesPerformed();
                this.iDatoAsignable = new TrCondicion();
                this.limpiarCampos();
                activo = true;
            }
        }
        this.nombreTextField.setEditable(activo);
        this.cmbImplementacion.setEnabled(activo);
        this.paqueteTextField.setEditable(activo);
        this.funcionTextField.setEditable(activo);
        this.isV_ComplejaCheck.setEnabled(activo);
        this.decripTextArea.setEditable(activo);
        this.isExpCheck.setEnabled(activo);
        this.isDocPermitidoCheck.setEnabled(activo);
        this.isTipoEvolCheck.setEnabled(activo);
        this.isTransCheck.setEnabled(activo);
        this.isExpEnFaseCheck.setEnabled(activo);
        this.isFechaCheck.setEnabled(activo);
        this.isUsuarioCheck.setEnabled(activo);
        this.isFaseCheck.setEnabled(activo);
        this.isTipoDocCheck.setEnabled(activo);
        this.textoLibreTextArea.setEditable(activo);
        if (bReiniciarColoresLabel) {
            // empty if block
        }
    }

    public IAsignable getValoresAsignables() {
        return this.iDatoAsignable;
    }

    public void setValoresAsignables(IAsignable datosAsignables) {
        if (datosAsignables != null && datosAsignables instanceof TrCondicion) {
            this.iDatoAsignable = datosAsignables;
            TrCondicion condicion = (TrCondicion)datosAsignables;
            this.nombreTextField.setText(condicion.getNombre());
            if (condicion.getTipoImplementacion().toString().equals("PLSQL")) {
                this.cmbImplementacion.setSelectedItem(TrTipoImplementacion.PLSQL);
            } else if (condicion.getTipoImplementacion().toString().equals("JAVA")) {
                this.cmbImplementacion.setSelectedItem(TrTipoImplementacion.JAVA);
            }
            this.paqueteTextField.setText(condicion.getPaquete());
            this.funcionTextField.setText(condicion.getFuncion());
            this.isV_ComplejaCheck.setSelected(condicion.isExpresionCompleja());
            this.expresionComplejaTextArea.setText(condicion.getValorExpresionCompleja());
            this.decripTextArea.setText(condicion.getDescripcion());
            this.isExpCheck.setSelected(condicion.isExp());
            this.isDocPermitidoCheck.setSelected(condicion.isDocPermitido());
            this.isTipoEvolCheck.setSelected(condicion.isTipoEvol());
            this.isTransCheck.setSelected(condicion.isTrans());
            this.isExpEnFaseCheck.setSelected(condicion.isExpEnFase());
            this.isFechaCheck.setSelected(condicion.isFecha());
            this.isUsuarioCheck.setSelected(condicion.isUsuario());
            this.isFaseCheck.setSelected(condicion.isFase());
            this.isTipoDocCheck.setSelected(condicion.isTipo_Documento());
            this.textoLibreTextArea.setText(condicion.getTextoLibre());
        }
    }

    public String getTitulo(int n) {
        return "Mantenimiento de condici\u00f3n";
    }

    private void cargarCmbImplementacion() {
        this.cmbImplementacion.removeAllItems();
        this.cmbImplementacion.addItem(TrTipoImplementacion.PLSQL);
        this.cmbImplementacion.addItem(TrTipoImplementacion.JAVA);
        this.cmbImplementacion.setSelectedItem(TrTipoImplementacion.PLSQL);
    }

    public boolean obtenerValoresCampos() {
        boolean ok = true;
        TrCondicion trCondicion = null;
        trCondicion = new TrCondicion();
        trCondicion = (TrCondicion)this.iDatoAsignable;
        if (trCondicion == null) {
            ok = false;
        } else if (this.nombreTextField.getText() == null) {
            ok = false;
        } else if (this.nombreTextField.getText().equals("")) {
            ok = false;
        }
        if (this.decripTextArea.getText() == null) {
            ok = false;
        }
        if (this.decripTextArea.getText().equals("")) {
            ok = false;
        }
        if (!ok) {
            JOptionPane.showMessageDialog(null, MantenimientoJDialog.TEXTO_FALTAN_ATRIBUTOS_OBLIGATORIOS, MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
        } else {
            if (trCondicion != null) {
                trCondicion.setNombre(this.nombreTextField.getText());
                trCondicion.setDescripcion(this.decripTextArea.getText());
                trCondicion.setPaquete(this.paqueteTextField.getText());
                trCondicion.setFuncion(this.funcionTextField.getText());
                trCondicion.setValorExpresionCompleja(this.expresionComplejaTextArea.getText());
                trCondicion.setUsuario(this.isUsuarioCheck.isSelected());
                trCondicion.setFase(this.isFaseCheck.isSelected());
                trCondicion.setTipo_Documento(this.isTipoDocCheck.isSelected());
                trCondicion.setExpresionCompleja(this.isV_ComplejaCheck.isSelected());
                trCondicion.setDocPermitido(this.isDocPermitidoCheck.isSelected());
                trCondicion.setExp(this.isExpCheck.isSelected());
                trCondicion.setExpEnFase(this.isExpEnFaseCheck.isSelected());
                trCondicion.setFecha(this.isFechaCheck.isSelected());
                trCondicion.setTipoEvol(this.isTipoEvolCheck.isSelected());
                trCondicion.setTrans(this.isTransCheck.isSelected());
                trCondicion.setTextoLibre(this.textoLibreTextArea.getText());
            }
            this.generarExpresion.setEnabled(false);
            this.limpiarExpresion.setEnabled(false);
            int nSelectedItem = this.cmbImplementacion.getSelectedIndex();
            if (trCondicion != null) {
                trCondicion.setTipoImplementacion((TrTipoImplementacion)this.cmbImplementacion.getItemAt(nSelectedItem));
            }
        }
        return ok;
    }

    public String getNombreTmp() {
        return this.nombreTextField.getText();
    }

    public void activar_botonesPerformed() {
        if (this.isV_ComplejaCheck.isSelected()) {
            this.generarExpresion.setEnabled(true);
            this.limpiarExpresion.setEnabled(true);
        } else {
            this.generarExpresion.setEnabled(false);
            this.limpiarExpresion.setEnabled(false);
        }
    }

    void btnGenerarExpresionCompleja(ActionEvent e) {
        GeneradorCondicionesJDialog generadorDlg = new GeneradorCondicionesJDialog();
        generadorDlg.setGrafico(this.grafico);
        generadorDlg.setExpresion(this.expresionComplejaTextArea.getText());
        generadorDlg.setLocationRelativeTo(null);
        generadorDlg.setVisible(true);
        String strExpresion = generadorDlg.getExpresion();
        if (strExpresion != null) {
            this.expresionComplejaTextArea.setText(strExpresion);
        }
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null || nuevoGrafico.getDDP() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
    }

    public void inicializarFoco() {
        this.nombreTextField.requestFocus();
    }

    public void conservarColoresDeFondo() {
        this.colorFondoNombre = this.nombreTextField.getBackground();
        this.colorFondoTipoImplementacion = this.cmbImplementacion.getBackground();
        this.colorFondoPaquete = this.paqueteTextField.getBackground();
        this.colorFondoFuncion = this.funcionTextField.getBackground();
        this.colorFondoExpresion = this.isV_ComplejaCheck.getForeground();
        this.colorFondoDescripcion = this.decripTextArea.getBackground();
        this.colorFondoExpediente = this.isExpCheck.getForeground();
        this.colorFondoTransicion = this.isTransCheck.getForeground();
        this.colorFondoUsuario = this.isUsuarioCheck.getForeground();
        this.colorFondoDocPermitido = this.isDocPermitidoCheck.getForeground();
        this.colorFondoExpedienteEnFase = this.isExpEnFaseCheck.getForeground();
        this.colorFondoFase = this.isFaseCheck.getForeground();
        this.colorFondoTipoEvolucion = this.isTipoEvolCheck.getForeground();
        this.colorFondoFecha = this.isFechaCheck.getForeground();
        this.colorFondoTipoDocumento = this.isTipoDocCheck.getForeground();
        this.colorFondoTextoLibre = this.textoLibreTextArea.getBackground();
    }

    public void restaurarColoresDeFondo() {
        if (this.colorFondoNombre != null) {
            this.nombreTextField.setBackground(this.colorFondoNombre);
            this.colorFondoNombre = null;
        }
        if (this.colorFondoTipoImplementacion != null) {
            this.cmbImplementacion.setBackground(this.colorFondoTipoImplementacion);
            this.colorFondoTipoImplementacion = null;
        }
        if (this.colorFondoPaquete != null) {
            this.paqueteTextField.setBackground(this.colorFondoPaquete);
            this.colorFondoPaquete = null;
        }
        if (this.colorFondoFuncion != null) {
            this.funcionTextField.setBackground(this.colorFondoFuncion);
            this.colorFondoFuncion = null;
        }
        if (this.colorFondoExpresion != null) {
            this.isV_ComplejaCheck.setForeground(this.colorFondoExpresion);
            this.colorFondoExpresion = null;
        }
        if (this.colorFondoDescripcion != null) {
            this.decripTextArea.setBackground(this.colorFondoDescripcion);
            this.colorFondoDescripcion = null;
        }
        if (this.colorFondoExpediente != null) {
            this.isExpCheck.setForeground(this.colorFondoExpediente);
            this.colorFondoExpediente = null;
        }
        if (this.colorFondoTransicion != null) {
            this.isTransCheck.setForeground(this.colorFondoTransicion);
            this.colorFondoTransicion = null;
        }
        if (this.colorFondoUsuario != null) {
            this.isUsuarioCheck.setForeground(this.colorFondoUsuario);
            this.colorFondoUsuario = null;
        }
        if (this.colorFondoDocPermitido != null) {
            this.isDocPermitidoCheck.setForeground(this.colorFondoDocPermitido);
            this.colorFondoDocPermitido = null;
        }
        if (this.colorFondoExpedienteEnFase != null) {
            this.isExpEnFaseCheck.setForeground(this.colorFondoExpedienteEnFase);
            this.colorFondoExpedienteEnFase = null;
        }
        if (this.colorFondoFase != null) {
            this.isFaseCheck.setForeground(this.colorFondoFase);
            this.colorFondoFase = null;
        }
        if (this.colorFondoTipoEvolucion != null) {
            this.isTipoEvolCheck.setForeground(this.colorFondoTipoEvolucion);
            this.colorFondoTipoEvolucion = null;
        }
        if (this.colorFondoFecha != null) {
            this.isFechaCheck.setForeground(this.colorFondoFecha);
            this.colorFondoFecha = null;
        }
        if (this.colorFondoTipoDocumento != null) {
            this.isTipoDocCheck.setForeground(this.colorFondoTipoDocumento);
            this.colorFondoTipoDocumento = null;
        }
        if (this.colorFondoTextoLibre != null) {
            this.textoLibreTextArea.setBackground(this.colorFondoTextoLibre);
            this.colorFondoTextoLibre = null;
        }
    }
}

