/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import gdtel.ui.swing.excontrols.CreadorButton;
import gdtel.ui.swing.excontrols.JFiltroTextArea;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import gdtel.ui.swing.excontrols.JPanelAtributable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import modela.bd.obj.TrIndicacionFicha;
import modela.bd.obj.TrTipoIndicacionFicha;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.MantenimientoIndicacionFichaJDialog;

public class PropFichaProcedimientoJPanel
extends JPanelAtributable {
    private static final long serialVersionUID = -6186445024678132478L;
    private final JFiltroTextArea descripArea = new JFiltroTextArea();
    private final JLabel jLabel1 = new JLabel();
    private final JLabel jLabel2 = new JLabel();
    private final XYLayout xYLayout = new XYLayout();
    private final JLabel descripcionTipoLabel = new JLabel();
    private final JLabel abreviaturaTipoLabel = new JLabel();
    private final JFiltroTextArea descripccionTipo = new JFiltroTextArea();
    private final JFiltroTextField abreviaturaTipoTextField = new JFiltroTextField();
    private DDPGrafico grafico;
    private TrTipoIndicacionFicha tipoIndicacionFicha;
    ImageIcon seleccionarIconN = new ImageIcon(PropFichaProcedimientoJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION));
    ImageIcon seleccionarIconS = new ImageIcon(PropFichaProcedimientoJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION_SOBRE));
    ImageIcon seleccionarIconD = new ImageIcon(PropFichaProcedimientoJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION_NO_ENABLED));
    JButton seleccionarTipoButton = (JButton)CreadorButton.crearBoton(1, false, this.seleccionarIconN, this.seleccionarIconD, this.seleccionarIconS, this.seleccionarIconS);
    private final JPanel jPanelTipo = new JPanel();
    private Color colorFondoDescripcion = null;
    private Color colorFuenteAbreviaturaTipo = null;
    private Color colorFuenteDescripcionTipo = null;

    public PropFichaProcedimientoJPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void jbInit() {
        this.setLayout(this.xYLayout);
        this.jLabel1.setText("Descripci\u00f3n:");
        this.jLabel1.setFont(ModelaUI.fuentePrincipalNegrita);
        this.jLabel2.setText("Propiedades de la indicaci\u00f3n de la ficha");
        this.jLabel2.setFont(ModelaUI.fuentePrincipalNegrita);
        this.jLabel2.setForeground(ModelaUI.colorSeleccion);
        this.descripcionTipoLabel.setText("Descripci\u00f3n:");
        this.descripcionTipoLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.abreviaturaTipoLabel.setText("Abreviatura:");
        this.abreviaturaTipoLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.descripArea.setBorder(BorderFactory.createBevelBorder(1));
        this.descripArea.setNumItems(300);
        this.descripArea.setTipoFiltro(1);
        this.descripArea.setEnabled(true);
        this.descripArea.setEditable(false);
        this.descripccionTipo.setNumItems(100);
        this.descripccionTipo.establecerTipografia(1);
        this.descripccionTipo.setTipoFiltro(1);
        this.descripccionTipo.setEnabled(true);
        this.descripccionTipo.setEditable(false);
        this.descripccionTipo.setBorder(BorderFactory.createBevelBorder(1));
        this.abreviaturaTipoTextField.setNumItems(10);
        this.abreviaturaTipoTextField.establecerTipografia(1);
        this.abreviaturaTipoTextField.setTipoFiltro(1);
        this.abreviaturaTipoTextField.setEnabled(true);
        this.abreviaturaTipoTextField.setEditable(false);
        this.jPanelTipo.setBounds(new Rectangle(130, 50, 160, 150));
        TitledBorder bordeTipo = new TitledBorder("Tipo de indicaci\u00f3n");
        bordeTipo.setTitleFont(ModelaUI.fuentePrincipalNegrita);
        this.jPanelTipo.setBorder(bordeTipo);
        this.jPanelTipo.setOpaque(false);
        this.add((Component)this.jLabel2, new XYConstraints(0, 0, 285, 15));
        this.add((Component)this.jPanelTipo, new XYConstraints(0, 50, 436, 190));
        this.add((Component)this.abreviaturaTipoLabel, new XYConstraints(20, 73, 100, 20));
        this.add((Component)this.abreviaturaTipoTextField, new XYConstraints(20, 93, 310, 25));
        this.add((Component)this.descripcionTipoLabel, new XYConstraints(20, 120, 120, 20));
        this.add((Component)this.descripccionTipo.getScrollableArea(), new XYConstraints(20, 140, 400, 85));
        this.add((Component)this.seleccionarTipoButton, new XYConstraints(335, 93, 85, 25));
        this.add((Component)this.jLabel1, new XYConstraints(0, 240, 120, 20));
        this.add((Component)this.descripArea.getScrollableArea(), new XYConstraints(0, 260, 436, 105));
        this.seleccionarTipoButton.setBorderPainted(false);
        this.seleccionarTipoButton.setFocusPainted(false);
        this.seleccionarTipoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropFichaProcedimientoJPanel.this.seleccionarTipo_actionPerformed(e);
            }
        });
    }

    public void limpiarCampos() {
        this.descripArea.setText("");
        this.descripccionTipo.setText("");
        this.abreviaturaTipoTextField.setText("");
        this.tipoIndicacionFicha = null;
    }

    public void inicializarCampos(int nTipo) {
        this.nModoActualDeTrabajo = nTipo;
        boolean activo = false;
        boolean bReiniciarColoresLabel = true;
        switch (nTipo) {
            case 4: {
                this.conservarColoresDeFondo();
                bReiniciarColoresLabel = false;
                break;
            }
            case 2: {
                activo = false;
                bReiniciarColoresLabel = false;
                break;
            }
            case 3: {
                activo = true;
                break;
            }
            case 1: {
                this.iDatoAsignable = new TrIndicacionFicha();
                this.limpiarCampos();
                activo = true;
            }
        }
        this.descripArea.setEditable(activo);
        this.descripccionTipo.setEditable(false);
        this.abreviaturaTipoTextField.setEditable(false);
        this.seleccionarTipoButton.setEnabled(activo);
        if (bReiniciarColoresLabel) {
            this.descripcionTipoLabel.setForeground(Color.BLACK);
            this.abreviaturaTipoLabel.setForeground(Color.BLACK);
        }
    }

    public IAsignable getValoresAsignables() {
        return this.iDatoAsignable;
    }

    public void setValoresAsignables(IAsignable datosAsignables) {
        if (datosAsignables != null && datosAsignables instanceof TrIndicacionFicha) {
            this.iDatoAsignable = datosAsignables;
            TrIndicacionFicha ficha = (TrIndicacionFicha)datosAsignables;
            this.descripArea.setText(ficha.getDESCRIPCION());
            this.tipoIndicacionFicha = ficha.getTipoIndicacionFicha();
            if (this.tipoIndicacionFicha != null) {
                this.descripccionTipo.setText(this.tipoIndicacionFicha.getDescripcion());
                this.abreviaturaTipoTextField.setText(this.tipoIndicacionFicha.getAbreviatura());
            }
        }
    }

    public String getTitulo(int n) {
        return "Mantenimiento de Fichas";
    }

    public boolean obtenerValoresCampos() {
        TrIndicacionFicha trIndicacionFicha = null;
        boolean ok = true;
        trIndicacionFicha = new TrIndicacionFicha();
        trIndicacionFicha = (TrIndicacionFicha)this.iDatoAsignable;
        if (trIndicacionFicha == null) {
            ok = false;
        }
        if (this.tipoIndicacionFicha == null) {
            ok = false;
        }
        if (this.descripArea.getText() == null) {
            ok = false;
        }
        if (this.descripArea.getText().equals("")) {
            ok = false;
        }
        if (!ok) {
            JOptionPane.showMessageDialog(null, MantenimientoJDialog.TEXTO_FALTAN_ATRIBUTOS_OBLIGATORIOS, MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
        } else if (trIndicacionFicha != null) {
            trIndicacionFicha.setDESCRIPCION(this.descripArea.getText());
            trIndicacionFicha.setTipoIndicacionFicha(this.tipoIndicacionFicha);
        }
        return ok;
    }

    void seleccionarTipo_actionPerformed(ActionEvent e) {
        MantenimientoIndicacionFichaJDialog mttoIndicacion = new MantenimientoIndicacionFichaJDialog();
        if (this.grafico != null) {
            mttoIndicacion.setGrafico(this.grafico);
            if (this.nModoActualDeTrabajo != 1) {
                mttoIndicacion.inicializarListaElementos(this.grafico.getTiposIndicacionInvolucrados(), this.tipoIndicacionFicha);
            } else {
                mttoIndicacion.inicializarListaElementos(this.grafico.getTiposIndicacionInvolucrados());
            }
        }
        mttoIndicacion.setLocationRelativeTo(null);
        mttoIndicacion.activarSeleccion(true);
        mttoIndicacion.setVisible(true);
        if (mttoIndicacion.obtenerElementoSeleccionado() != null) {
            TrTipoIndicacionFicha indi = null;
            this.tipoIndicacionFicha = indi = (TrTipoIndicacionFicha)mttoIndicacion.obtenerElementoSeleccionado();
            if (this.tipoIndicacionFicha != null) {
                this.descripccionTipo.setText(this.tipoIndicacionFicha.getDescripcion());
                this.abreviaturaTipoTextField.setText(this.tipoIndicacionFicha.getAbreviatura());
                this.descripcionTipoLabel.setForeground(ModelaUI.colorFuenteEtiquetaModificandose);
                this.abreviaturaTipoLabel.setForeground(ModelaUI.colorFuenteEtiquetaModificandose);
            }
        }
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
    }

    public void inicializarFoco() {
        this.descripccionTipo.requestFocus();
    }

    public void conservarColoresDeFondo() {
        this.colorFondoDescripcion = this.descripArea.getBackground();
        this.colorFuenteAbreviaturaTipo = this.abreviaturaTipoLabel.getForeground();
        this.colorFuenteDescripcionTipo = this.descripcionTipoLabel.getForeground();
    }

    public void restaurarColoresDeFondo() {
        if (this.colorFondoDescripcion != null) {
            this.descripArea.setBackground(this.colorFondoDescripcion);
            this.colorFondoDescripcion = null;
        }
        if (this.colorFuenteAbreviaturaTipo != null) {
            this.abreviaturaTipoLabel.setForeground(this.colorFuenteAbreviaturaTipo);
            this.colorFuenteAbreviaturaTipo = null;
        }
        if (this.colorFuenteDescripcionTipo != null) {
            this.descripcionTipoLabel.setForeground(this.colorFuenteDescripcionTipo);
            this.colorFuenteDescripcionTipo = null;
        }
    }
}

