/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import gdtel.ui.swing.excontrols.JComboBoxEx;
import gdtel.ui.swing.excontrols.JFiltroTextArea;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import gdtel.ui.swing.excontrols.JPanelAtributable;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.TrParametro;
import modela.bd.obj.TrTipoParametro;
import modela.ui.ModelaUI;

public class PropParametrosJPanel
extends JPanelAtributable {
    private static final long serialVersionUID = 2217919161116807485L;
    private final XYLayout xYLayout = new XYLayout();
    private final JLabel labelCabecera = new JLabel();
    private final JLabel labelNombre = new JLabel();
    private final JLabel labelDescripcion = new JLabel();
    private final JFiltroTextField nombreField = new JFiltroTextField();
    private final JFiltroTextArea descripArea = new JFiltroTextArea();
    private final JLabel labelTipo = new JLabel();
    private final JLabel labelTamano = new JLabel();
    JComboBoxEx cmbTipo = new JComboBoxEx();
    private final JFiltroTextField tamanoField = new JFiltroTextField();
    private Color colorFondoNombre = null;
    private Color colorFondoDescripcion = null;
    private Color colorFondoTipo = null;
    private Color colorFondoTamanio = null;

    public PropParametrosJPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void jbInit() {
        this.setLayout(this.xYLayout);
        this.labelCabecera.setText("Propiedades del par\u00e1metro");
        this.labelCabecera.setFont(ModelaUI.fuentePrincipalNegrita);
        this.labelCabecera.setForeground(ModelaUI.colorSeleccion);
        this.labelNombre.setText("Nombre:");
        this.labelNombre.setFont(ModelaUI.fuentePrincipalNegrita);
        this.labelDescripcion.setText("Descripci\u00f3n:");
        this.labelDescripcion.setFont(ModelaUI.fuentePrincipalNegrita);
        this.labelTipo.setText("Tipo:");
        this.labelTipo.setFont(ModelaUI.fuentePrincipalNegrita);
        this.labelTamano.setText("Tama\u00f1o:");
        this.nombreField.setNumItems(20);
        this.nombreField.establecerTipografia(1);
        this.nombreField.setTipoFiltro(1);
        this.nombreField.setEnabled(true);
        this.nombreField.setEditable(false);
        this.descripArea.setNumItems(100);
        this.descripArea.establecerTipografia(1);
        this.descripArea.setTipoFiltro(1);
        this.descripArea.setEnabled(true);
        this.descripArea.setEditable(false);
        this.tamanoField.setTipoFiltro(2);
        this.tamanoField.setNumItems(4);
        this.tamanoField.setEnabled(true);
        this.tamanoField.setEditable(false);
        this.cmbTipo.setEditable(false);
        this.add((Component)this.labelCabecera, new XYConstraints(0, 0, 210, 15));
        this.add((Component)this.labelNombre, new XYConstraints(0, 50, 55, 20));
        this.add((Component)this.nombreField, new XYConstraints(0, 70, 346, 25));
        this.add((Component)this.labelDescripcion, new XYConstraints(0, 95, 120, 25));
        this.add((Component)this.descripArea.getScrollableArea(), new XYConstraints(0, 118, 346, 160));
        this.add((Component)this.labelTipo, new XYConstraints(0, 282, 150, 15));
        this.add((Component)this.cmbTipo, new XYConstraints(0, 300, 100, 25));
        this.add((Component)this.labelTamano, new XYConstraints(120, 282, 65, 15));
        this.add((Component)this.tamanoField, new XYConstraints(120, 300, 75, 25));
        this.cargarCmbTipos();
        this.descripArea.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                if (evt.getKeyChar() == '\t') {
                    PropParametrosJPanel.this.cmbTipo.requestFocus();
                }
            }
        });
    }

    public void limpiarCampos() {
        this.nombreField.setText("");
        this.descripArea.setText("");
        this.tamanoField.setText("");
        this.cmbTipo.setSelectedIndex(0);
    }

    public void inicializarCampos(int nTipo) {
        boolean activo = false;
        switch (nTipo) {
            case 4: {
                this.conservarColoresDeFondo();
                break;
            }
            case 2: {
                activo = false;
                break;
            }
            case 3: {
                activo = true;
                break;
            }
            case 1: {
                this.iDatoAsignable = new TrParametro();
                this.limpiarCampos();
                activo = true;
            }
        }
        this.nombreField.setEditable(activo);
        this.descripArea.setEditable(activo);
        this.tamanoField.setEditable(activo);
        this.cmbTipo.setEnabled(activo);
    }

    public IAsignable getValoresAsignables() {
        return this.iDatoAsignable;
    }

    public boolean obtenerValoresCampos() {
        TrParametro trParametro = null;
        boolean ok = true;
        trParametro = new TrParametro();
        trParametro = (TrParametro)this.iDatoAsignable;
        if (trParametro == null) {
            ok = false;
        } else if (this.nombreField.getText() == null || this.descripArea.getText() == null) {
            ok = false;
        } else if (this.nombreField.getText().equals("") || this.descripArea.getText().equals("")) {
            ok = false;
        }
        if (this.cmbTipo.getSelectedIndex() < 0) {
            ok = false;
        }
        if (!ok) {
            JOptionPane.showMessageDialog(null, MantenimientoJDialog.TEXTO_FALTAN_ATRIBUTOS_OBLIGATORIOS, MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
        } else if (trParametro != null) {
            trParametro.setNOMBRE(this.nombreField.getText());
            trParametro.setDESCRIPCION(this.descripArea.getText());
            if (!this.tamanoField.getText().equals("")) {
                trParametro.setTAMANIO(Long.parseLong(this.tamanoField.getText()));
            } else {
                trParametro.setTAMANIO(0L);
            }
            int nSelectedItem = this.cmbTipo.getSelectedIndex();
            trParametro.setTipoParametro((TrTipoParametro)this.cmbTipo.getItemAt(nSelectedItem));
        }
        return ok;
    }

    public void setValoresAsignables(IAsignable datosAsignables) {
        if (datosAsignables != null && datosAsignables instanceof TrParametro) {
            this.iDatoAsignable = datosAsignables;
            TrParametro trPara = null;
            trPara = (TrParametro)this.iDatoAsignable;
            if (trPara.getNOMBRE() != null) {
                this.nombreField.setText(trPara.getNOMBRE());
            }
            if (trPara.getDESCRIPCION() != null) {
                this.descripArea.setText(trPara.getDESCRIPCION());
            }
            if (trPara.getTAMANIO() > 0L) {
                this.tamanoField.setText(String.valueOf(trPara.getTAMANIO()));
            } else {
                this.tamanoField.setText("");
            }
            this.cmbTipo.setSelectedItem(trPara.getTipoParametro());
        }
    }

    public String getTitulo(int nTipo) {
        return "";
    }

    private void cargarCmbTipos() {
        this.cmbTipo.removeAllItems();
        this.cmbTipo.addItem(TrTipoParametro.NUMERICO);
        this.cmbTipo.addItem(TrTipoParametro.CADENA);
        this.cmbTipo.addItem(TrTipoParametro.FECHA);
        this.cmbTipo.setSelectedIndex(0);
    }

    public String getNombreTmp() {
        return this.nombreField.getText();
    }

    public void inicializarFoco() {
        this.nombreField.requestFocus();
    }

    public void conservarColoresDeFondo() {
        this.colorFondoNombre = this.nombreField.getBackground();
        this.colorFondoDescripcion = this.descripArea.getBackground();
        this.colorFondoTipo = this.cmbTipo.getBackground();
        this.colorFondoTamanio = this.tamanoField.getBackground();
    }

    public void restaurarColoresDeFondo() {
        if (this.colorFondoNombre != null) {
            this.nombreField.setBackground(this.colorFondoNombre);
            this.colorFondoNombre = null;
        }
        if (this.colorFondoDescripcion != null) {
            this.descripArea.setBackground(this.colorFondoDescripcion);
            this.colorFondoDescripcion = null;
        }
        if (this.colorFondoTipo != null) {
            this.cmbTipo.setBackground(this.colorFondoTipo);
            this.colorFondoTipo = null;
        }
        if (this.colorFondoTamanio != null) {
            this.tamanoField.setBackground(this.colorFondoTamanio);
            this.colorFondoTamanio = null;
        }
    }
}

