/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import gdtel.ui.swing.excontrols.CreadorButton;
import gdtel.ui.swing.excontrols.JFiltroTextArea;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import gdtel.ui.swing.excontrols.JPanelAtributable;
import gdtel.util.CopiadorArchivos;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.TrPlantillaProcedimiento;
import modela.conf.ModelaConf;
import modela.ui.MimeTypeUtil;
import modela.ui.ModelaUI;
import modela.ui.swing.PropBloqueJPanel;
import modela.ui.swing.PropFaseJPanel;
import modela.util.UtilidadesVarias;

public class PropPlantillaProcJPanel
extends JPanelAtributable {
    private static final long serialVersionUID = -800740246180936206L;
    JFiltroTextField nombreTextField = new JFiltroTextField();
    private final JLabel jLabel1 = new JLabel();
    private final JLabel decripAreaLabel = new JLabel();
    private final JFiltroTextArea decripTextArea = new JFiltroTextArea();
    private final JLabel jLabel2 = new JLabel();
    private final XYLayout xYLayout = new XYLayout();
    private final JLabel imagenLabel = new JLabel();
    private final JFiltroTextField nombreImagenTextField = new JFiltroTextField();
    private String sMime = null;
    private String sRutaCompleta = null;
    private final String sistemaOperativo = "Wind";
    ImageIcon seleccionarIconN = new ImageIcon(PropFaseJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION));
    ImageIcon seleccionarIconS = new ImageIcon(PropFaseJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION_SOBRE));
    ImageIcon seleccionarIconD = new ImageIcon(PropFaseJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION_NO_ENABLED));
    JButton seleccionarImagenButton = (JButton)CreadorButton.crearBoton(1, false, this.seleccionarIconN, this.seleccionarIconD, this.seleccionarIconS, this.seleccionarIconS);
    ImageIcon previewIconN = new ImageIcon(PropFaseJPanel.class.getResource(ModelaUI.IMG_PREVIEW_FILE));
    ImageIcon previewIconS = new ImageIcon(PropFaseJPanel.class.getResource(ModelaUI.IMG_PREVIEW_FILE_SOBRE));
    ImageIcon previewIconD = new ImageIcon(PropFaseJPanel.class.getResource(ModelaUI.IMG_PREVIEW_FILE_NO_ENABLED));
    JButton vistaArchivoButton = (JButton)CreadorButton.crearBoton(1, false, this.seleccionarIconN, this.seleccionarIconD, this.seleccionarIconS, this.seleccionarIconS);
    ImageIcon quitarIconN = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_QUITAR));
    ImageIcon quitarIconS = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_QUITAR_SOBRE));
    ImageIcon quitarIconD = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_QUITAR_NO_ENABLED));
    JButton eliminarImagenButton = (JButton)CreadorButton.crearBoton(1, false, this.quitarIconN, this.quitarIconD, this.quitarIconS, this.quitarIconS);
    private Color colorFondoNombre = null;
    private Color colorFondoDescripcion = null;
    private Color colorFuenteLabelImagen = null;

    public PropPlantillaProcJPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void jbInit() {
        this.setLayout(this.xYLayout);
        this.jLabel1.setText("Nombre:");
        this.jLabel1.setFont(ModelaUI.fuentePrincipalNegrita);
        this.decripAreaLabel.setText("Descripci\u00f3n:");
        this.decripAreaLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.jLabel2.setText("Propiedades de la plantilla de procedimiento");
        this.jLabel2.setFont(ModelaUI.fuentePrincipalNegrita);
        this.jLabel2.setForeground(ModelaUI.colorSeleccion);
        this.imagenLabel.setText("Archivo:");
        this.imagenLabel.setFont(ModelaUI.fuentePrincipal);
        this.nombreTextField.setNumItems(100);
        this.nombreTextField.establecerTipografia(1);
        this.nombreTextField.setTipoFiltro(1);
        this.nombreTextField.setEnabled(true);
        this.nombreTextField.setEditable(false);
        this.decripTextArea.setNumItems(250);
        this.decripTextArea.establecerTipografia(1);
        this.decripTextArea.setTipoFiltro(1);
        this.decripTextArea.setEnabled(true);
        this.decripTextArea.setEditable(false);
        this.decripTextArea.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                if (evt.getKeyChar() == '\t') {
                    PropPlantillaProcJPanel.this.nombreTextField.requestFocus();
                }
            }
        });
        this.nombreImagenTextField.setToolTipText("Doble clic para abrir");
        this.nombreImagenTextField.setNumItems(64);
        this.nombreImagenTextField.establecerTipografia(2);
        this.nombreImagenTextField.setTipoFiltro(1);
        this.nombreImagenTextField.setEnabled(true);
        this.nombreImagenTextField.setEditable(false);
        this.nombreImagenTextField.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                if (e.getSource() != null && e.getClickCount() == 2) {
                    PropPlantillaProcJPanel.this.abrirArchivoPlantilla(null);
                    return;
                }
            }
        });
        this.add((Component)this.jLabel2, new XYConstraints(0, 0, 300, 15));
        this.add((Component)this.jLabel1, new XYConstraints(0, 50, 63, 20));
        this.add((Component)this.nombreTextField, new XYConstraints(0, 70, 346, 25));
        this.add((Component)this.decripAreaLabel, new XYConstraints(0, 95, 120, 25));
        this.add((Component)this.decripTextArea.getScrollableArea(), new XYConstraints(0, 118, 346, 160));
        this.add((Component)this.imagenLabel, new XYConstraints(0, 282, 80, 15));
        this.add((Component)this.nombreImagenTextField, new XYConstraints(0, 300, 346, 25));
        this.add((Component)this.seleccionarImagenButton, new XYConstraints(226, 327, 85, 25));
        this.add((Component)this.eliminarImagenButton, new XYConstraints(316, 329, 30, 21));
        this.seleccionarImagenButton.setBorderPainted(false);
        this.seleccionarImagenButton.setFocusPainted(false);
        this.seleccionarImagenButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropPlantillaProcJPanel.this.seleccionarImagen_actionPerformed(e);
            }
        });
        this.eliminarImagenButton.setBorderPainted(false);
        this.eliminarImagenButton.setFocusPainted(false);
        this.eliminarImagenButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropPlantillaProcJPanel.this.eliminarImagen_actionPerformed(e);
            }
        });
        this.vistaArchivoButton.setBorderPainted(false);
        this.vistaArchivoButton.setFocusPainted(false);
        this.vistaArchivoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropPlantillaProcJPanel.this.abrirArchivoPlantilla(e);
            }
        });
    }

    public void limpiarCampos() {
        this.nombreTextField.setText("");
        this.decripTextArea.setText("");
        this.nombreImagenTextField.setText("");
        this.sMime = "";
        this.sRutaCompleta = "";
    }

    public void inicializarCampos(int nTipo) {
        boolean activo = false;
        boolean bReiniciarColoresLabel = true;
        switch (nTipo) {
            case 4: {
                this.conservarColoresDeFondo();
                bReiniciarColoresLabel = false;
                break;
            }
            case 2: {
                activo = false;
                bReiniciarColoresLabel = false;
                break;
            }
            case 3: {
                activo = true;
                break;
            }
            case 1: {
                this.iDatoAsignable = new TrPlantillaProcedimiento();
                this.limpiarCampos();
                activo = true;
            }
        }
        this.nombreTextField.setEditable(activo);
        this.decripTextArea.setEditable(activo);
        this.nombreImagenTextField.setEditable(false);
        this.seleccionarImagenButton.setEnabled(activo);
        this.eliminarImagenButton.setEnabled(activo);
        this.vistaArchivoButton.setEnabled(activo);
        if (bReiniciarColoresLabel) {
            this.imagenLabel.setForeground(Color.BLACK);
        }
    }

    public IAsignable getValoresAsignables() {
        return this.iDatoAsignable;
    }

    public void setValoresAsignables(IAsignable datosAsignables) {
        if (datosAsignables != null && datosAsignables instanceof TrPlantillaProcedimiento) {
            this.iDatoAsignable = datosAsignables;
            TrPlantillaProcedimiento Plantilla = (TrPlantillaProcedimiento)datosAsignables;
            this.nombreTextField.setText(Plantilla.getNOMBRE());
            this.decripTextArea.setText(Plantilla.getDESCRIPCION());
            this.nombreImagenTextField.setText(Plantilla.getNOMB_FICHERO());
            this.sMime = Plantilla.getFORMATO();
            this.sRutaCompleta = Plantilla.getRutaCompleta();
        }
    }

    public String getTitulo(int n) {
        return "Mantenimiento de plantillas";
    }

    public boolean obtenerValoresCampos() {
        TrPlantillaProcedimiento trPlantillaProc = null;
        boolean ok = true;
        if (this.nombreTextField.getText() == null || this.decripTextArea.getText() == null) {
            ok = false;
        } else if (this.nombreTextField.getText().equals("") || this.decripTextArea.getText().equals("")) {
            ok = false;
        }
        if (!ok) {
            JOptionPane.showMessageDialog(null, MantenimientoJDialog.TEXTO_FALTAN_ATRIBUTOS_OBLIGATORIOS, MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            this.inicializarCampos(3);
        } else {
            trPlantillaProc = (TrPlantillaProcedimiento)this.iDatoAsignable;
            if (trPlantillaProc == null) {
                return false;
            }
            trPlantillaProc.setNOMBRE(this.nombreTextField.getText());
            trPlantillaProc.setDESCRIPCION(this.decripTextArea.getText());
            trPlantillaProc.setNOMB_FICHERO(this.nombreImagenTextField.getText());
            trPlantillaProc.setFORMATO(this.sMime);
            trPlantillaProc.setRutaCompleta(this.sRutaCompleta);
        }
        return ok;
    }

    void seleccionarImagen_actionPerformed(ActionEvent e) {
        String strRuta = ModelaConf.getRutaArchivo();
        JFileChooser fileDlg = strRuta != null ? new JFileChooser(strRuta) : new JFileChooser();
        fileDlg.setFileSelectionMode(0);
        int nRet = fileDlg.showOpenDialog(this);
        if (nRet == 0) {
            File fich = fileDlg.getSelectedFile();
            String sFichero = fich.getName();
            if (sFichero != null && sFichero.length() > 64) {
                Object[] opciones = new Object[]{"S\u00ed", "No, renombrar\u00e9 manualmente"};
                int n = JOptionPane.showOptionDialog(null, "Nombre del fichero demasiado largo:\nLa longitud m\u00e1xima permitida es de 64 caracteres (extensi\u00f3n incluida).\n\n\u00bfQuiere renombrarlo autom\u00e1ticamente a ... \n" + UtilidadesVarias.adjustNameFileMaxLen(fich.getName(), 64) + " ?", "Atenci\u00f3n", 0, 2, null, opciones, opciones[1]);
                if (n != 0) {
                    return;
                }
                File fileDestino = new File(fich.getParent() + File.separator + UtilidadesVarias.adjustNameFileMaxLen(fich.getName(), 64));
                if (fich.renameTo(fileDestino)) {
                    sFichero = fileDestino.getName();
                } else {
                    return;
                }
            }
            this.nombreImagenTextField.setText(sFichero);
            MimeTypeUtil mime = MimeTypeUtil.getInstance();
            this.sMime = mime.mimeTypeOf(fich.getPath());
            this.sRutaCompleta = fich.getPath();
            this.imagenLabel.setForeground(ModelaUI.colorFuenteEtiquetaModificandose);
        }
    }

    void eliminarImagen_actionPerformed(ActionEvent e) {
        if (!this.nombreImagenTextField.getText().equals("")) {
            this.imagenLabel.setForeground(ModelaUI.colorFuenteEtiquetaModificandose);
        }
        this.nombreImagenTextField.setText("");
        this.sMime = "";
        this.sRutaCompleta = "";
    }

    public String getNombrePlantillaSeleccionada() {
        String strNombre = this.nombreTextField.getText();
        if (strNombre == null) {
            return null;
        }
        if (strNombre.equals("")) {
            return null;
        }
        return strNombre;
    }

    public void inicializarFoco() {
        this.nombreTextField.requestFocus();
    }

    public void conservarColoresDeFondo() {
        this.colorFondoNombre = this.nombreTextField.getBackground();
        this.colorFondoDescripcion = this.decripTextArea.getBackground();
        this.colorFuenteLabelImagen = this.imagenLabel.getForeground();
    }

    public void restaurarColoresDeFondo() {
        if (this.colorFondoNombre != null) {
            this.nombreTextField.setBackground(this.colorFondoNombre);
            this.colorFondoNombre = null;
        }
        if (this.colorFondoDescripcion != null) {
            this.decripTextArea.setBackground(this.colorFondoDescripcion);
            this.colorFondoDescripcion = null;
        }
        if (this.colorFuenteLabelImagen != null) {
            this.imagenLabel.setForeground(this.colorFuenteLabelImagen);
            this.colorFuenteLabelImagen = null;
        }
    }

    public void abrirArchivoPlantilla(ActionEvent e) {
        if (this.nombreImagenTextField.getText().equals("")) {
            return;
        }
        Runtime r = Runtime.getRuntime();
        try {
            String strRutaValidaExe = null;
            if (CopiadorArchivos.existeArchivo(this.sRutaCompleta)) {
                strRutaValidaExe = this.sRutaCompleta;
            } else if (CopiadorArchivos.existeArchivo(ModelaConf.getRutaArchivo() + System.getProperty("file.separator") + this.nombreImagenTextField.getText())) {
                strRutaValidaExe = ModelaConf.getRutaArchivo() + System.getProperty("file.separator") + this.nombreImagenTextField.getText();
            } else {
                JOptionPane.showMessageDialog(null, "No se ha podido localizar el fichero asociado.", "Atenci\u00f3n", 0);
            }
            if (strRutaValidaExe != null) {
                String tmp = System.getProperty("os.name");
                if (tmp.startsWith(this.sistemaOperativo)) {
                    r.exec("rundll32 SHELL32.DLL,ShellExec_RunDLL " + strRutaValidaExe);
                } else {
                    String[] comando = new String[]{"xdg-open", strRutaValidaExe};
                    r.exec(comando);
                }
            }
        }
        catch (Exception ex) {
            Object[] opciones = new Object[]{"Aceptar", "Cancelar"};
            int n = JOptionPane.showOptionDialog(null, "Archivo no encontrado.", "Atencion", 0, 3, null, opciones, opciones[1]);
            if (n == -1) {
                n = 1;
            }
            if (n == 1) {
                return;
            }
            ActionEvent acEven = null;
            this.seleccionarImagen_actionPerformed(acEven);
            return;
        }
    }
}

