/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing.graficas;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrTareaEnFaseDefProcedimiento;
import modela.bd.obj.TrTipoTarea;
import modela.conf.ModelaConf;
import modela.ui.swing.graficas.JPanelGrafica;
import org.jfree.chart.ChartPanel;

public class JPanelGraficaTareasXFase
extends JPanelGrafica {
    private static final long serialVersionUID = -4238319537650579322L;

    public JPanelGraficaTareasXFase() {
        this.jbInit();
    }

    private void jbInit() {
        this.setTituloPanel("Tareas en Fase del Proc:");
        this.comboTipo.addItem("Barras apiladas");
        this.comboTipo.addItem("Barras apiladas 3D");
        this.add((Component)this.panelOpcionesGraficas, "South");
        this.setNElementosVista(ModelaConf.getItemsPorPagina());
    }

    public String toString() {
        return "Tareas en Fase del Procedimiento";
    }

    public boolean loadGrafica(int nTipoGraf, boolean bLimitarAmbito) {
        this.setTipoGrafica(nTipoGraf);
        if (this.diagramaAsociado == null || this.diagramaAsociado.getDDP() == null) {
            return false;
        }
        try {
            String tituloGrafica;
            ArrayList arrFases = new ArrayList();
            if (!bLimitarAmbito) {
                arrFases = this.diagramaAsociado.getFasesInvolucradas().getListaDatos();
                tituloGrafica = "Todo el procedimiento (Reutilizables inclusive)";
            } else {
                arrFases = this.diagramaAsociado.getFasesInvolucradasGr().getListaDatos();
                tituloGrafica = this.diagramaAsociado.getDDP().getTITULO();
                if (tituloGrafica == null) {
                    tituloGrafica = this.diagramaAsociado.getDDP().getNOMBRE();
                }
            }
            Collections.sort(arrFases);
            int nIncorporarDocumentos = 0;
            int nGenerarDocumentos = 0;
            int nBloques = 0;
            int nOtras = 0;
            for (int n = 0; arrFases != null && n < arrFases.size(); ++n) {
                TrFase faseAux = (TrFase)arrFases.get(n);
                ArrayList arrTareasDefProc = !bLimitarAmbito ? this.calculaEstadisticas.getArrTotalTrTareaEnFaseDefProc(faseAux) : this.diagramaAsociado.getTareasEnFaseDefProc(faseAux).getListaDatos();
                nIncorporarDocumentos = 0;
                nGenerarDocumentos = 0;
                nBloques = 0;
                nOtras = 0;
                for (int t = 0; arrTareasDefProc != null && t < arrTareasDefProc.size(); ++t) {
                    TrTareaEnFaseDefProcedimiento tareaFaseProcAux = (TrTareaEnFaseDefProcedimiento)arrTareasDefProc.get(t);
                    if (tareaFaseProcAux.getTareaEnFase() == null || tareaFaseProcAux.getTareaEnFase().getTarea() == null) continue;
                    if (tareaFaseProcAux.getTareaEnFase().getTarea().getTrTipoTarea().equals(TrTipoTarea.INCORPORAR_DOCUMENTO)) {
                        ++nIncorporarDocumentos;
                        continue;
                    }
                    if (tareaFaseProcAux.getTareaEnFase().getTarea().getTrTipoTarea().equals(TrTipoTarea.GENERAR_DOCUMENTO)) {
                        ++nGenerarDocumentos;
                        continue;
                    }
                    if (tareaFaseProcAux.getTareaEnFase().getTarea().getTrTipoTarea().equals(TrTipoTarea.MANIPULAR_DATOS)) {
                        ++nBloques;
                        continue;
                    }
                    ++nOtras;
                }
                super.addValor(faseAux.getNombre(), "Incorporar Documentos", new Double(nIncorporarDocumentos));
                super.addValor(faseAux.getNombre(), "Generar Documentos", new Double(nGenerarDocumentos));
                super.addValor(faseAux.getNombre(), "Bloques", new Double(nBloques));
                super.addValor(faseAux.getNombre(), "Otras", new Double(nOtras));
            }
            super.createChart(tituloGrafica);
            if (this.getComponentCount() > 1 && this.getComponent(1) instanceof ChartPanel) {
                this.remove(1);
            }
            this.add((Component)super.createPanel(), "Center");
            this.validate();
            this.repaint();
            return true;
        }
        catch (Exception e) {
            System.out.println("\u00b7 [ Error ] No se pudo cargar la gr\u00e1fica de Tareas X Fase.");
            e.printStackTrace();
            return false;
        }
    }
}

