/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing.renderers;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import modela.bd.obj.TrDocumentoPermitido;
import modela.bd.obj.TrTarea;
import modela.bd.obj.TrTareaEnFase;
import modela.bd.obj.TrTareaEnFaseDefProcedimiento;
import modela.bd.obj.TrTipoTarea;
import modela.ui.ModelaUI;

public class TareaEnFaseCellRenderer
extends JLabel
implements ListCellRenderer {
    private static final long serialVersionUID = 8103842588310868331L;
    private TrTareaEnFase m_TareaEnFase;
    Color highlightColor = new Color(0, 0, 128);
    public static final String TAREA_GENERAR = "TAREA_GENERAR";
    public static final String TAREA_INCORPORAR = "TAREA_INCORPORAR";
    public static final String TAREA_MANIPULAR = "TAREA_MANIPULAR";
    private Color colorDeFondo;
    private Color colorDeLetra;
    ImageIcon tareaGen;
    ImageIcon tareaGenMultiple;
    ImageIcon tareaInc;
    ImageIcon tareaIncMultiple;
    ImageIcon tareaMani;
    ImageIcon tareaOtro;

    public TareaEnFaseCellRenderer() {
        this.setOpaque(true);
        this.tareaGen = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_TAREA_GENERAR));
        this.tareaGenMultiple = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_TAREA_GENERAR_MULTIPLE));
        this.tareaInc = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_TAREA_INCORPORAR));
        this.tareaIncMultiple = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_TAREA_INCORPORAR_MULTIPLE));
        this.tareaMani = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_TAREA_MANIPULAR));
        this.tareaOtro = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_TAREA_OTROS));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        TrTarea tarea = null;
        if (value == null) {
            return null;
        }
        if (index == -1) {
            int selected = list.getSelectedIndex();
            if (selected == -1) {
                return this;
            }
            index = selected;
        }
        if (value instanceof TrTareaEnFase) {
            this.m_TareaEnFase = (TrTareaEnFase)value;
            if (this.m_TareaEnFase != null) {
                this.setText(this.m_TareaEnFase.toString());
                tarea = this.m_TareaEnFase.getTarea();
            }
        } else if (value instanceof TrTareaEnFaseDefProcedimiento) {
            TrTareaEnFaseDefProcedimiento tf = (TrTareaEnFaseDefProcedimiento)value;
            this.m_TareaEnFase = tf.getTareaEnFase();
            if (this.m_TareaEnFase != null) {
                this.setText(this.m_TareaEnFase.toString());
                tarea = this.m_TareaEnFase.getTarea();
            }
        } else if (value instanceof TrTarea) {
            TrTarea tar = null;
            tar = (TrTarea)value;
            this.setText(tar.toString());
            tarea = tar;
        } else {
            return this;
        }
        if (tarea != null) {
            boolean bMultiple = false;
            if (tarea instanceof TrDocumentoPermitido && ((TrDocumentoPermitido)tarea).getTipoDocumento() != null && ((TrDocumentoPermitido)tarea).getTipoDocumento().isMultiple()) {
                bMultiple = true;
            }
            if (tarea.getTrTipoTarea() == TrTipoTarea.GENERAR_DOCUMENTO) {
                if (bMultiple) {
                    this.setIcon(this.tareaGenMultiple);
                } else {
                    this.setIcon(this.tareaGen);
                }
            }
            if (tarea.getTrTipoTarea() == TrTipoTarea.INCORPORAR_DOCUMENTO) {
                if (bMultiple) {
                    this.setIcon(this.tareaIncMultiple);
                } else {
                    this.setIcon(this.tareaInc);
                }
            }
            if (tarea.getTrTipoTarea() == TrTipoTarea.MANIPULAR_DATOS) {
                this.setIcon(this.tareaMani);
            }
            if (tarea.getTrTipoTarea() == TrTipoTarea.OTROS) {
                this.setIcon(this.tareaOtro);
            }
        }
        if (isSelected) {
            this.colorDeFondo = list.getSelectionBackground();
            this.colorDeLetra = list.getSelectionForeground();
        } else {
            this.colorDeFondo = list.getBackground();
            this.colorDeLetra = list.getForeground();
        }
        if (this.m_TareaEnFase != null && !this.m_TareaEnFase.isValida()) {
            this.colorDeLetra = ModelaUI.colorElementoInvalido;
        }
        this.setFont(ModelaUI.fuentePrincipal);
        if (this.m_TareaEnFase != null && this.m_TareaEnFase.isOBLIGATORIA()) {
            this.setFont(ModelaUI.fuentePrincipalNegrita);
        }
        this.setBackground(this.colorDeFondo);
        this.setForeground(this.colorDeLetra);
        return this;
    }
}

