/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.security.CertificateStore;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;

public class HttpsRootCACertStore
implements CertificateStore {
    private static String _filename = null;
    private KeyStore _jssecacerts = null;

    static {
        _filename = System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "jssecacerts";
    }

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(this){
                private final HttpsRootCACertStore this$0;
                {
                    this.this$0 = httpsRootCACertStore;
                }

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file;
                    if (HttpsRootCACertStore.access$000(this.this$0) == null) {
                        HttpsRootCACertStore.access$002(this.this$0, KeyStore.getInstance("JKS"));
                        HttpsRootCACertStore.access$000(this.this$0).load(null, null);
                    }
                    if ((file = new File(HttpsRootCACertStore.access$100())).exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        HttpsRootCACertStore.access$000(this.this$0).load(bufferedInputStream, null);
                        bufferedInputStream.close();
                        fileInputStream.close();
                    } else if (Globals.TraceHttpsCert) {
                        Debug.println("roothttpscertstore.cert.noload" + new Object[]{HttpsRootCACertStore.access$100()});
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            exception.printStackTrace();
        }
        if (Globals.TraceHttpsCert) {
            Debug.println("roothttpscertstore.cert.loaded" + new Object[]{_filename});
        }
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (Globals.TraceHttpsCert) {
            Debug.println("roothttpscertstore.cert.saving" + new Object[]{_filename});
        }
    }

    static String access$100() {
        return _filename;
    }

    public void add(Certificate certificate) throws KeyStoreException {
        if (Globals.TraceHttpsCert) {
            Debug.println("roothttpscertstore.cert.adding");
        }
        throw new KeyStoreException("Cannot add Https root CA certificate");
    }

    public void remove(Certificate certificate) throws KeyStoreException {
        if (Globals.TraceHttpsCert) {
            Debug.println("roothttpscertstore.cert.removing");
        }
        throw new KeyStoreException("Cannot remove Https root CA certificate");
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        if (Globals.TraceHttpsCert) {
            Debug.println("roothttpscertstore.cert.instore");
        }
        return false;
    }

    public boolean verify(Certificate certificate) throws KeyStoreException {
        if (Globals.TraceHttpsCert) {
            Debug.println("roothttpscertstore.cert.canverify");
            Debug.println("roothttpscertstore.cert.tobeverified" + new Object[]{certificate});
        }
        Enumeration<String> enumeration = this._jssecacerts.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate2 = this._jssecacerts.getCertificate(string);
            if (Globals.TraceHttpsCert) {
                Debug.println("roothttpscertstore.cert.tobecompared" + new Object[]{certificate2});
            }
            try {
                certificate.verify(certificate2.getPublicKey());
                if (Globals.TraceHttpsCert) {
                    Debug.println("roothttpscertstore.cert.verify.ok");
                }
                return true;
            }
            catch (Exception exception) {
                Debug.ignoredException(exception);
            }
        }
        if (Globals.TraceHttpsCert) {
            Debug.println("roothttpscertstore.cert.verify.fail");
        }
        return false;
    }

    public Iterator iterator() throws KeyStoreException {
        if (Globals.TraceHttpsCert) {
            Debug.println("roothttpscertstore.cert.iterator");
        }
        HashSet<Certificate> hashSet = new HashSet<Certificate>();
        Enumeration<String> enumeration = this._jssecacerts.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = this._jssecacerts.getCertificate(string);
            hashSet.add(certificate);
        }
        return hashSet.iterator();
    }

    static KeyStore access$000(HttpsRootCACertStore httpsRootCACertStore) {
        return httpsRootCACertStore._jssecacerts;
    }

    static KeyStore access$002(HttpsRootCACertStore httpsRootCACertStore, KeyStore keyStore) {
        httpsRootCACertStore._jssecacerts = keyStore;
        return httpsRootCACertStore._jssecacerts;
    }
}

