/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui.prefs;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.JRELocator;
import com.sun.javaws.Resources;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.ui.general.AbstractController;
import com.sun.javaws.ui.general.GeneralUtilities;
import com.sun.javaws.ui.general.Subcontroller;
import com.sun.javaws.ui.prefs.PluggablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JRESearcher
extends PluggablePanel {
    private static String defaultClassPath;
    private static final int CANCEL_INDEX = 0;
    private static final int PREVIOUS_INDEX = 1;
    private static final int NEXT_INDEX = 2;
    private JButton _cancelButton;
    private JDialog dialog;
    private File directory;
    private ResourceBundle resources;
    private AbstractController controller;
    private ConfigProperties.JREInformation[] jres;
    static Class class$java$awt$Frame;
    static Class class$javax$swing$JFileChooser;

    private int getState() {
        return this.controller.getActiveSubcontrollerIndex();
    }

    protected void cancel() {
        this.setJREs(null);
        this.dialog.setVisible(false);
    }

    private void createController() {
        this.controller = new AbstractController(this){
            private final JRESearcher this$0;

            protected Subcontroller createSubcontroller(int n) {
                switch (n) {
                    case 1: {
                        return new PathController(this.this$0, null);
                    }
                }
                return new SearchController(this.this$0, null);
            }
            {
                this.this$0 = jRESearcher;
            }
        };
    }

    protected void next() {
        int n = this.getState();
        if (++n == 3) {
            this.dialog.setVisible(false);
        } else {
            this.setState(n);
        }
    }

    protected void previous() {
        int n = this.getState();
        this.setState(--n);
    }

    protected void buttonPressed(int n) {
        switch (n) {
            case 0: {
                this.cancel();
                break;
            }
            case 1: {
                this.previous();
                break;
            }
            default: {
                this.next();
            }
        }
    }

    private void setState(int n) {
        this.setButtonEnabled(0, true);
        this.setButtonEnabled(1, false);
        this.setButtonEnabled(2, true);
        this.controller.setActiveSubcontrollerIndex(n);
        if (n == 1) {
            this.setJREs(null);
        }
        if (n != -1) {
            this.setComponent(this.controller.getActiveSubcontroller().getComponent());
        }
        this.revalidate();
        this.repaint();
    }

    private void setJREs(ConfigProperties.JREInformation[] jREInformationArray) {
        this.jres = jREInformationArray;
    }

    private void show(Component component) {
        Frame frame = component instanceof Frame ? (Frame)component : (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = JRESearcher.class$("java.awt.Frame")) : class$java$awt$Frame, component);
        this.dialog = GeneralUtilities.createDialog(frame, Resources.getString("jresearcher.maintitle"), true);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)this, "Center");
        this.dialog.pack();
        Dimension dimension = this.dialog.getSize();
        dimension.width = Math.max(dimension.width, 500);
        dimension.height = Math.max(dimension.height, 400);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.dialog.setBounds((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2, dimension.width, dimension.height);
        this.dialog.addKeyListener(new KeyAdapter(this){
            private final JRESearcher this$0;
            {
                this.this$0 = jRESearcher;
            }

            public void keyPressed(KeyEvent keyEvent) {
                int n = Resources.getVKCode("jresearcher.cancelButtonMnemonic");
                if (keyEvent.getKeyCode() == n) {
                    JRESearcher.access$300(this.this$0).doClick();
                }
            }
        });
        this.dialog.show();
        this.dialog.dispose();
        this.setState(-1);
    }

    private File getDirectory() {
        return this.directory;
    }

    private void setDirectory(File file) {
        this.directory = file;
        this.setButtonEnabled(2, this.directory != null);
    }

    static void access$1000(JRESearcher jRESearcher, ConfigProperties.JREInformation[] jREInformationArray) {
        jRESearcher.setJREs(jREInformationArray);
    }

    static File access$400(JRESearcher jRESearcher) {
        return jRESearcher.getDirectory();
    }

    static void access$700(JRESearcher jRESearcher, File file) {
        jRESearcher.setDirectory(file);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static JButton access$300(JRESearcher jRESearcher) {
        return jRESearcher._cancelButton;
    }

    public ConfigProperties.JREInformation[] search(Component component, ResourceBundle resourceBundle, String string) {
        this.resources = resourceBundle;
        this.setJREs(null);
        String[] stringArray = new String[]{Resources.getString("jresearcher.cancelButton"), Resources.getString("jresearcher.previousButton"), Resources.getString("jresearcher.nextButton")};
        this.setButtons(stringArray);
        this.setTitle(Resources.getString("jresearcher.title"));
        this.buttons[1].setMnemonic(Resources.getVKCode("jresearcher.previousButtonMnemonic"));
        this.buttons[2].setMnemonic(Resources.getVKCode("jresearcher.nextButtonMnemonic"));
        this._cancelButton = this.buttons[0];
        if (this.controller == null) {
            this.createController();
        }
        SimpleController simpleController = new SimpleController(this, null);
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFont(UIManager.getFont("Label.font"));
        simpleController.setComponent(jTextArea);
        this.controller.setSubcontroller(0, simpleController);
        this.directory = null;
        this.setState(0);
        this.show(component);
        return this.jres;
    }

    private class PathController
    extends SimpleController {
        private JFileChooser fc;
        private final JRESearcher this$0;

        public void start() {
            this.this$0.setButtonEnabled(2, JRESearcher.access$400(this.this$0) != null);
            this.this$0.setButtonEnabled(1, true);
        }

        private void updateDirectory() {
            File file = this.fc.getSelectedFile();
            if (file == null) {
                file = this.fc.getCurrentDirectory();
            }
            JRESearcher.access$700(this.this$0, file);
        }

        private PathController(JRESearcher jRESearcher) {
            super(jRESearcher, null);
            this.this$0 = jRESearcher;
        }

        static void access$500(PathController pathController) {
            pathController.updateDirectory();
        }

        protected Component createComponent() {
            this.fc = new JFileChooser();
            this.fc.setFileSelectionMode(2);
            this.fc.addActionListener(new ActionListener(this){
                private final PathController this$1;
                {
                    this.this$1 = pathController;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if ("ApproveSelection".equals(actionEvent.getActionCommand())) {
                        JFileChooser jFileChooser;
                        File file;
                        if (actionEvent.getSource() instanceof JFileChooser && (file = (jFileChooser = (JFileChooser)actionEvent.getSource()).getSelectedFile()) != null && file.isDirectory()) {
                            jFileChooser.setCurrentDirectory(file);
                        }
                        PathController.access$500(this.this$1);
                    } else if ("CancelSelection".equals(actionEvent.getActionCommand())) {
                        PathController.access$600(this.this$1).cancel();
                    }
                }
            });
            this.fc.addPropertyChangeListener(new PropertyChangeListener(this){
                private final PathController this$1;
                {
                    this.this$1 = pathController;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName()) || "directoryChanged".equals(propertyChangeEvent.getPropertyName())) {
                        PathController.access$500(this.this$1);
                    }
                }
            });
            try {
                Class[] classArray = new Class[]{Boolean.TYPE};
                Method method = (class$javax$swing$JFileChooser == null ? (class$javax$swing$JFileChooser = JRESearcher.class$("javax.swing.JFileChooser")) : class$javax$swing$JFileChooser).getMethod("setControlButtonsAreShown", classArray);
                if (method != null) {
                    Object[] objectArray = new Object[]{Boolean.FALSE};
                    method.invoke((Object)this.fc, objectArray);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            this.fc.setDialogType(0);
            this.updateDirectory();
            return this.fc;
        }

        static JRESearcher access$600(PathController pathController) {
            return pathController.this$0;
        }

        PathController(JRESearcher jRESearcher, 1 var2_2) {
            this(jRESearcher);
        }
    }

    private class SearchController
    extends SimpleController
    implements ActionListener {
        private DefaultListModel model;
        private JList list;
        private JLabel searchLabel;
        private String searchPrefix;
        private JLabel titleLabel;
        private Searcher searcher;
        private Timer timer;
        private boolean active;
        private final JRESearcher this$0;

        public void start() {
            this.active = true;
            this.this$0.setButtonEnabled(2, false);
            this.this$0.setButtonEnabled(1, true);
            if (this.model != null) {
                this.model.removeAllElements();
            }
            this.timer = new Timer(100, this);
            this.timer.setRepeats(true);
            this.timer.start();
            this.searcher = new Searcher(this, null);
            this.searcher.start(JRESearcher.access$400(this.this$0));
        }

        public void stop() {
            this.active = false;
            this.stopSearching();
        }

        private void stopSearching() {
            if (this.searcher != null) {
                this.searcher.stop();
                this.searcher = null;
                this.timer.stop();
                this.timer = null;
            }
        }

        private void updateJREs() {
            if (!this.active) {
                return;
            }
            if (this.model != null) {
                int n = this.model.getSize();
                if (n > 0) {
                    this.this$0.setButtonEnabled(2, true);
                    int[] nArray = this.list.getSelectedIndices();
                    if (nArray != null && nArray.length > 0) {
                        ConfigProperties.JREInformation[] jREInformationArray = new ConfigProperties.JREInformation[nArray.length];
                        for (int i = 0; i < nArray.length; ++i) {
                            jREInformationArray[i] = (ConfigProperties.JREInformation)this.model.getElementAt(nArray[i]);
                        }
                        JRESearcher.access$1000(this.this$0, jREInformationArray);
                    } else {
                        Object[] objectArray = new ConfigProperties.JREInformation[n];
                        this.model.copyInto(objectArray);
                        JRESearcher.access$1000(this.this$0, (ConfigProperties.JREInformation[])objectArray);
                    }
                } else {
                    JRESearcher.access$1000(this.this$0, null);
                    this.this$0.setButtonEnabled(2, false);
                }
            } else {
                JRESearcher.access$1000(this.this$0, null);
            }
        }

        private SearchController(JRESearcher jRESearcher) {
            super(jRESearcher, null);
            this.this$0 = jRESearcher;
        }

        static void access$900(SearchController searchController) {
            searchController.updateJREs();
        }

        protected Component createComponent() {
            this.searchPrefix = Resources.getString("jresearcher.searchingPrefix");
            this.model = new DefaultListModel();
            this.list = new JList(this.model);
            this.list.setCellRenderer(new DefaultListCellRenderer(this){
                private final SearchController this$1;
                {
                    this.this$1 = searchController;
                }

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    if (object instanceof ConfigProperties.JREInformation) {
                        object = ((ConfigProperties.JREInformation)object).getInstalledPath();
                    }
                    return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                }
            });
            this.list.addListSelectionListener(new ListSelectionListener(this){
                private final SearchController this$1;
                {
                    this.this$1 = searchController;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    SearchController.access$900(this.this$1);
                }
            });
            this.searchLabel = new JLabel(" ");
            this.titleLabel = new JLabel(Resources.getString("jresearcher.searchingTitle"));
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 2, 0, 2);
            gridBagConstraints.gridy = 0;
            jPanel.add((Component)this.titleLabel, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            jPanel.add((Component)this.searchLabel, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets.bottom = 0;
            jPanel.add((Component)new JScrollPane(this.list), gridBagConstraints);
            return jPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.searcher.isFinished()) {
                File file = this.searcher.getCurrentFile();
                if (file != null) {
                    this.searchLabel.setText(this.searchPrefix + file.getPath());
                } else {
                    this.searchLabel.setText(this.searchPrefix);
                }
            } else {
                if (this.model.getSize() > 0) {
                    this.titleLabel.setText(Resources.getString("jresearcher.foundJREsTitle"));
                } else {
                    this.titleLabel.setText(Resources.getString("jresearcher.noJREsTitle"));
                }
                this.this$0.setButtonEnabled(2, true);
                this.searchLabel.setText(" ");
                this.stopSearching();
            }
        }

        private void add(Searcher searcher, ConfigProperties.JREInformation jREInformation) {
            SwingUtilities.invokeLater(new Runnable(this, searcher, jREInformation){
                private final Searcher val$searcher;
                private final ConfigProperties.JREInformation val$jre;
                private final SearchController this$1;

                public void run() {
                    if (SearchController.access$1100(this.this$1) == this.val$searcher) {
                        SearchController.access$1200(this.this$1).addElement(this.val$jre);
                        SearchController.access$900(this.this$1);
                    }
                }
                {
                    this.this$1 = searchController;
                    this.val$searcher = searcher;
                    this.val$jre = jREInformation;
                }
            });
        }

        SearchController(JRESearcher jRESearcher, 1 var2_2) {
            this(jRESearcher);
        }

        static Searcher access$1100(SearchController searchController) {
            return searchController.searcher;
        }

        static DefaultListModel access$1200(SearchController searchController) {
            return searchController.model;
        }

        static void access$1300(SearchController searchController, Searcher searcher, ConfigProperties.JREInformation jREInformation) {
            searchController.add(searcher, jREInformation);
        }

        private class Searcher
        implements Runnable {
            private File file;
            private boolean stop;
            private File currentFile;
            private boolean finished;
            private final SearchController this$1;

            public void run() {
                this.check(this.file);
                this.finished = true;
            }

            public void stop() {
                this.stop = true;
            }

            public boolean isFinished() {
                return this.finished;
            }

            private Searcher(SearchController searchController) {
                this.this$1 = searchController;
            }

            public File getCurrentFile() {
                return this.currentFile;
            }

            private void check(File file) {
                String[] stringArray;
                this.currentFile = file;
                String string = file.getName();
                if (file.isFile() && (string.equals("java") || string.equals("javaw.exe"))) {
                    ConfigProperties.JREInformation jREInformation = this.getVersion(file);
                    if (jREInformation != null) {
                        SearchController.access$1300(this.this$1, this, jREInformation);
                    }
                } else if (!file.isFile() && (stringArray = file.list()) != null) {
                    int n = stringArray.length;
                    for (int i = 0; i < n && !this.stop; ++i) {
                        this.check(new File(file, stringArray[i]));
                    }
                }
            }

            void start(File file) {
                this.file = file;
                new Thread(this).start();
                SearchController.access$900(this.this$1);
            }

            private boolean isValidJavaPath(File file) {
                String string = file.getParent();
                if (string.endsWith(File.separator + "native_threads") || string.endsWith(File.separator + "green_threads")) {
                    return false;
                }
                String string2 = File.separator + "jre" + File.separator + "bin";
                if (string.endsWith(string2) && string.length() > string2.length()) {
                    String string3 = string.substring(0, string.length() - string2.length() + 1) + "bin" + File.separator;
                    File file2 = new File(string3 + "java");
                    if (file2.exists() && file2.isFile()) {
                        return false;
                    }
                    file2 = new File(string3 + "javaw.exe");
                    if (file2.exists() && file2.isFile()) {
                        return false;
                    }
                }
                return true;
            }

            private ConfigProperties.JREInformation getVersion(File file) {
                if (Globals.TraceJRESearch) {
                    Debug.println("checking " + file);
                }
                if (!this.isValidJavaPath(file)) {
                    if (Globals.TraceJRESearch) {
                        Debug.println("\tisn't valid java path");
                    }
                    return null;
                }
                ConfigProperties.JREInformation jREInformation = JRELocator.getVersion(file);
                jREInformation.setOsInfo(Globals.osName, Globals.osArch);
                return jREInformation;
            }

            Searcher(SearchController searchController, 1 var2_2) {
                this(searchController);
            }
        }
    }

    private class SimpleController
    implements Subcontroller {
        private Component component;
        private final JRESearcher this$0;

        public void apply() {
        }

        public void revert() {
        }

        public void start() {
        }

        public void stop() {
        }

        private SimpleController(JRESearcher jRESearcher) {
            this.this$0 = jRESearcher;
        }

        protected Component createComponent() {
            return null;
        }

        public Component getComponent() {
            if (this.component == null) {
                this.setComponent(this.createComponent());
            }
            return this.component;
        }

        public void setComponent(Component component) {
            this.component = component;
        }

        SimpleController(JRESearcher jRESearcher, 1 var2_2) {
            this(jRESearcher);
        }
    }
}

