/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.corba;

import com.sun.corba.se.internal.corba.AnyImpl;
import com.sun.corba.se.internal.corba.TypeCodeFactory;
import com.sun.corba.se.internal.corba.TypeCodeInputStream;
import com.sun.corba.se.internal.corba.TypeCodeOutputStream;
import com.sun.corba.se.internal.corba.TypeCodeReader;
import com.sun.corba.se.internal.corba.WrapperInputStream;
import com.sun.corba.se.internal.iiop.CDRInputStream;
import com.sun.corba.se.internal.iiop.CDROutputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public final class TypeCodeImpl
extends TypeCode {
    private static final TypeCodeImpl[] primitiveConstants = new TypeCodeImpl[]{new TypeCodeImpl(0), new TypeCodeImpl(1), new TypeCodeImpl(2), new TypeCodeImpl(3), new TypeCodeImpl(4), new TypeCodeImpl(5), new TypeCodeImpl(6), new TypeCodeImpl(7), new TypeCodeImpl(8), new TypeCodeImpl(9), new TypeCodeImpl(10), new TypeCodeImpl(11), new TypeCodeImpl(12), new TypeCodeImpl(13), new TypeCodeImpl(14), null, null, null, new TypeCodeImpl(18), null, null, null, null, new TypeCodeImpl(23), new TypeCodeImpl(24), new TypeCodeImpl(25), new TypeCodeImpl(26), new TypeCodeImpl(27), new TypeCodeImpl(28), new TypeCodeImpl(29), new TypeCodeImpl(30), new TypeCodeImpl(31), new TypeCodeImpl(32)};
    protected static final int tk_indirect = -1;
    private static final int EMPTY = 0;
    private static final int SIMPLE = 1;
    private static final int COMPLEX = 2;
    private static final int[] typeTable = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 1, 2, 2, 2, 2, 0, 0, 0, 0, 1, 1, 2, 2, 2, 2};
    private static final String[] kindNames = new String[]{"null", "void", "short", "long", "ushort", "ulong", "float", "double", "boolean", "char", "octet", "any", "typecode", "principal", "objref", "struct", "union", "enum", "string", "sequence", "array", "alias", "exception", "longlong", "ulonglong", "longdouble", "wchar", "wstring", "fixed", "value", "valueBox", "native", "abstractInterface"};
    private int _kind = 0;
    private String _id = "";
    private String _name = "";
    private int _memberCount = 0;
    private String[] _memberNames = null;
    private TypeCodeImpl[] _memberTypes = null;
    private AnyImpl[] _unionLabels = null;
    private TypeCodeImpl _discriminator = null;
    private int _defaultIndex = -1;
    private int _length = 0;
    private TypeCodeImpl _contentType = null;
    private short _digits = 0;
    private short _scale = 0;
    private short _type_modifier = (short)-1;
    private TypeCodeImpl _concrete_base = null;
    private short[] _memberAccess = null;
    private TypeCodeImpl _parent = null;
    private int _parentOffset = 0;
    private TypeCodeImpl _indirectType = null;
    private byte[] outBuffer = null;
    private boolean cachingEnabled = false;
    private ORB _orb;

    public int default_index() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().default_index();
            }
            case 16: {
                return this._defaultIndex;
            }
        }
        throw new BadKind();
    }

    public int length() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().length();
            }
            case 18: 
            case 19: 
            case 20: 
            case 27: {
                return this._length;
            }
        }
        throw new BadKind();
    }

    public int member_count() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().member_count();
            }
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 29: {
                return this._memberCount;
            }
        }
        throw new BadKind();
    }

    public short fixed_digits() throws BadKind {
        switch (this._kind) {
            case 28: {
                return this._digits;
            }
        }
        throw new BadKind();
    }

    public short fixed_scale() throws BadKind {
        switch (this._kind) {
            case 28: {
                return this._scale;
            }
        }
        throw new BadKind();
    }

    public short type_modifier() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().type_modifier();
            }
            case 29: {
                return this._type_modifier;
            }
        }
        throw new BadKind();
    }

    public boolean is_recursive() {
        return this._kind == -1;
    }

    public short member_visibility(int n2) throws BadKind, Bounds {
        switch (this._kind) {
            case -1: {
                return this.indirectType().member_visibility(n2);
            }
            case 29: {
                try {
                    return this._memberAccess[n2];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new Bounds();
                }
            }
        }
        throw new BadKind();
    }

    public TypeCodeImpl(int n2) {
        this._orb = null;
        this._kind = n2;
        switch (this._kind) {
            case 14: {
                this.setId("IDL:omg.org/CORBA/Object:1.0");
                this._name = "Object";
                break;
            }
            case 18: 
            case 27: {
                this._length = 0;
                break;
            }
            case 29: {
                this._concrete_base = null;
            }
        }
    }

    protected void setCaching(boolean bl2) {
        this.cachingEnabled = bl2;
        if (!bl2) {
            this.outBuffer = null;
        }
    }

    private TypeCodeImpl indirectType() {
        this._indirectType = this.tryIndirectType();
        if (this._indirectType == null) {
            throw new BAD_TYPECODE("Invoked operation on unresolved recursive type code!");
        }
        return this._indirectType;
    }

    private TypeCodeImpl lazy_content_type() {
        TypeCodeImpl typeCodeImpl;
        if (this._contentType == null && this._kind == 19 && this._parentOffset > 0 && this._parent != null && (typeCodeImpl = this.getParentAtLevel(this._parentOffset)) != null && typeCodeImpl._id != null) {
            this._contentType = new TypeCodeImpl(this._orb, typeCodeImpl._id);
        }
        return this._contentType;
    }

    private TypeCodeImpl tryIndirectType() {
        if (this._indirectType != null) {
            return this._indirectType;
        }
        if (!(this._orb instanceof TypeCodeFactory)) {
            throw new BAD_TYPECODE("ORB not supporting recursive type codes!");
        }
        this.setIndirectType(((TypeCodeFactory)((Object)this._orb)).getTypeCode(this._id));
        return this._indirectType;
    }

    private TypeCodeImpl getParentAtLevel(int n2) {
        if (n2 == 0) {
            return this;
        }
        if (this._parent == null) {
            throw new BAD_TYPECODE("Invoked operation on unresolved recursive type code!");
        }
        return this._parent.getParentAtLevel(n2 - 1);
    }

    public static TypeCodeImpl get_primitive_tc(int n2) {
        try {
            return primitiveConstants[n2];
        }
        catch (Throwable throwable) {
            throw new BAD_OPERATION("Invalid or unavailable typecode for kind = " + n2);
        }
    }

    private void setIndirectType(TypeCodeImpl typeCodeImpl) {
        this._indirectType = typeCodeImpl;
        if (this._indirectType != null) {
            try {
                this._id = this._indirectType.id();
            }
            catch (BadKind badKind) {
                // empty catch block
            }
        }
    }

    private void setParent(TypeCodeImpl typeCodeImpl) {
        this._parent = typeCodeImpl;
    }

    private void read_value_recursive(TypeCodeInputStream typeCodeInputStream) {
        if (typeCodeInputStream instanceof TypeCodeReader) {
            if (this.read_value_kind(typeCodeInputStream)) {
                this.read_value_body(typeCodeInputStream);
            }
        } else {
            this.read_value_kind(typeCodeInputStream);
            this.read_value_body(typeCodeInputStream);
        }
    }

    public void write_value(TypeCodeOutputStream typeCodeOutputStream) {
        if (this._kind == 31) {
            throw new MARSHAL();
        }
        TypeCodeOutputStream typeCodeOutputStream2 = typeCodeOutputStream.getTopLevelStream();
        if (this._kind == -1) {
            int n2 = typeCodeOutputStream2.getPositionForID(this._id);
            int n3 = typeCodeOutputStream.getTopLevelPosition();
            typeCodeOutputStream.writeIndirection(-1, n2);
            return;
        }
        typeCodeOutputStream.write_long(this._kind);
        typeCodeOutputStream2.addIDAtPosition(this._id, typeCodeOutputStream.getTopLevelPosition() - 4);
        block0 : switch (typeTable[this._kind]) {
            case 0: {
                break;
            }
            case 1: {
                switch (this._kind) {
                    case 18: 
                    case 27: {
                        typeCodeOutputStream.write_long(this._length);
                        break block0;
                    }
                    case 28: {
                        typeCodeOutputStream.write_ushort(this._digits);
                        typeCodeOutputStream.write_short(this._scale);
                        break block0;
                    }
                }
                throw new MARSHAL();
            }
            case 2: {
                TypeCodeOutputStream typeCodeOutputStream3 = typeCodeOutputStream.createEncapsulation(this._orb);
                switch (this._kind) {
                    case 14: 
                    case 32: {
                        typeCodeOutputStream3.write_string(this._id);
                        typeCodeOutputStream3.write_string(this._name);
                        break;
                    }
                    case 16: {
                        typeCodeOutputStream3.write_string(this._id);
                        typeCodeOutputStream3.write_string(this._name);
                        this._discriminator.write_value(typeCodeOutputStream3);
                        typeCodeOutputStream3.write_long(this._defaultIndex);
                        typeCodeOutputStream3.write_long(this._memberCount);
                        for (int i2 = 0; i2 < this._memberCount; ++i2) {
                            if (i2 == this._defaultIndex) {
                                typeCodeOutputStream3.write_octet(this._unionLabels[i2].extract_octet());
                            } else {
                                switch (this.realType(this._discriminator).kind().value()) {
                                    case 2: {
                                        typeCodeOutputStream3.write_short(this._unionLabels[i2].extract_short());
                                        break;
                                    }
                                    case 3: {
                                        typeCodeOutputStream3.write_long(this._unionLabels[i2].extract_long());
                                        break;
                                    }
                                    case 4: {
                                        typeCodeOutputStream3.write_short(this._unionLabels[i2].extract_ushort());
                                        break;
                                    }
                                    case 5: {
                                        typeCodeOutputStream3.write_long(this._unionLabels[i2].extract_ulong());
                                        break;
                                    }
                                    case 6: {
                                        typeCodeOutputStream3.write_float(this._unionLabels[i2].extract_float());
                                        break;
                                    }
                                    case 7: {
                                        typeCodeOutputStream3.write_double(this._unionLabels[i2].extract_double());
                                        break;
                                    }
                                    case 8: {
                                        typeCodeOutputStream3.write_boolean(this._unionLabels[i2].extract_boolean());
                                        break;
                                    }
                                    case 9: {
                                        typeCodeOutputStream3.write_char(this._unionLabels[i2].extract_char());
                                        break;
                                    }
                                    case 17: {
                                        typeCodeOutputStream3.write_long(this._unionLabels[i2].extract_long());
                                        break;
                                    }
                                    case 23: {
                                        typeCodeOutputStream3.write_longlong(this._unionLabels[i2].extract_longlong());
                                        break;
                                    }
                                    case 24: {
                                        typeCodeOutputStream3.write_longlong(this._unionLabels[i2].extract_ulonglong());
                                        break;
                                    }
                                    case 26: {
                                        typeCodeOutputStream3.write_wchar(this._unionLabels[i2].extract_wchar());
                                        break;
                                    }
                                    default: {
                                        throw new MARSHAL();
                                    }
                                }
                            }
                            typeCodeOutputStream3.write_string(this._memberNames[i2]);
                            this._memberTypes[i2].write_value(typeCodeOutputStream3);
                        }
                        break;
                    }
                    case 17: {
                        typeCodeOutputStream3.write_string(this._id);
                        typeCodeOutputStream3.write_string(this._name);
                        typeCodeOutputStream3.write_long(this._memberCount);
                        for (int i3 = 0; i3 < this._memberCount; ++i3) {
                            typeCodeOutputStream3.write_string(this._memberNames[i3]);
                        }
                        break;
                    }
                    case 19: {
                        this.lazy_content_type().write_value(typeCodeOutputStream3);
                        typeCodeOutputStream3.write_long(this._length);
                        break;
                    }
                    case 20: {
                        this._contentType.write_value(typeCodeOutputStream3);
                        typeCodeOutputStream3.write_long(this._length);
                        break;
                    }
                    case 21: 
                    case 30: {
                        typeCodeOutputStream3.write_string(this._id);
                        typeCodeOutputStream3.write_string(this._name);
                        this._contentType.write_value(typeCodeOutputStream3);
                        break;
                    }
                    case 15: 
                    case 22: {
                        typeCodeOutputStream3.write_string(this._id);
                        typeCodeOutputStream3.write_string(this._name);
                        typeCodeOutputStream3.write_long(this._memberCount);
                        for (int i4 = 0; i4 < this._memberCount; ++i4) {
                            typeCodeOutputStream3.write_string(this._memberNames[i4]);
                            this._memberTypes[i4].write_value(typeCodeOutputStream3);
                        }
                        break;
                    }
                    case 29: {
                        typeCodeOutputStream3.write_string(this._id);
                        typeCodeOutputStream3.write_string(this._name);
                        typeCodeOutputStream3.write_short(this._type_modifier);
                        if (this._concrete_base == null) {
                            primitiveConstants[0].write_value(typeCodeOutputStream3);
                        } else {
                            this._concrete_base.write_value(typeCodeOutputStream3);
                        }
                        typeCodeOutputStream3.write_long(this._memberCount);
                        for (int i5 = 0; i5 < this._memberCount; ++i5) {
                            typeCodeOutputStream3.write_string(this._memberNames[i5]);
                            this._memberTypes[i5].write_value(typeCodeOutputStream3);
                            typeCodeOutputStream3.write_short(this._memberAccess[i5]);
                        }
                        break;
                    }
                    default: {
                        throw new MARSHAL();
                    }
                }
                typeCodeOutputStream3.writeOctetSequenceTo(typeCodeOutputStream);
            }
        }
    }

    boolean read_value_kind(TypeCodeReader typeCodeReader) {
        this._kind = typeCodeReader.read_long();
        int n2 = typeCodeReader.getTopLevelPosition() - 4;
        if ((this._kind < 0 || this._kind > typeTable.length) && this._kind != -1) {
            throw new MARSHAL();
        }
        if (this._kind == 31) {
            throw new MARSHAL();
        }
        TypeCodeReader typeCodeReader2 = typeCodeReader.getTopLevelStream();
        if (this._kind == -1) {
            int n3 = typeCodeReader.read_long();
            if (n3 > -4) {
                throw new MARSHAL("Invalid indirection value " + n3);
            }
            int n4 = typeCodeReader.getTopLevelPosition();
            int n5 = n4 - 4 + n3;
            TypeCodeImpl typeCodeImpl = typeCodeReader2.getTypeCodeAtPosition(n5);
            if (typeCodeImpl == null) {
                throw new MARSHAL("Referenced type of indirect type not marshaled!");
            }
            this.setIndirectType(typeCodeImpl);
            return false;
        }
        typeCodeReader2.addTypeCodeAtPosition(this, n2);
        return true;
    }

    public void printStream(PrintStream printStream) {
        this.printStream(printStream, 0);
    }

    private void printStream(PrintStream printStream, int n2) {
        if (this._kind == -1) {
            printStream.print("indirect " + this._id);
            return;
        }
        switch (this._kind) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: {
                printStream.print(kindNames[this._kind] + " " + this._name);
                break;
            }
            case 15: 
            case 22: 
            case 29: {
                printStream.println(kindNames[this._kind] + " " + this._name + " = {");
                for (int i2 = 0; i2 < this._memberCount; ++i2) {
                    printStream.print(this.indent(n2 + 1));
                    if (this._memberTypes[i2] != null) {
                        this._memberTypes[i2].printStream(printStream, n2 + 1);
                    } else {
                        printStream.print("<unknown type>");
                    }
                    printStream.println(" " + this._memberNames[i2] + ";");
                }
                printStream.print(this.indent(n2) + "}");
                break;
            }
            case 16: {
                printStream.print("union " + this._name + "...");
                break;
            }
            case 17: {
                printStream.print("enum " + this._name + "...");
                break;
            }
            case 18: {
                if (this._length == 0) {
                    printStream.print("unbounded string " + this._name);
                    break;
                }
                printStream.print("bounded string(" + this._length + ") " + this._name);
                break;
            }
            case 19: 
            case 20: {
                printStream.println(kindNames[this._kind] + "[" + this._length + "] " + this._name + " = {");
                printStream.print(this.indent(n2 + 1));
                if (this.lazy_content_type() != null) {
                    this.lazy_content_type().printStream(printStream, n2 + 1);
                }
                printStream.println(this.indent(n2) + "}");
                break;
            }
            case 21: {
                printStream.print("alias " + this._name + " = " + (this._contentType != null ? this._contentType._name : "<unresolved>"));
                break;
            }
            case 27: {
                printStream.print("wstring[" + this._length + "] " + this._name);
                break;
            }
            case 28: {
                printStream.print("fixed(" + this._digits + ", " + this._scale + ") " + this._name);
                break;
            }
            case 30: {
                printStream.print("valueBox " + this._name + "...");
                break;
            }
            case 32: {
                printStream.print("abstractInterface " + this._name + "...");
                break;
            }
            default: {
                printStream.print("<unknown type>");
            }
        }
    }

    String description() {
        return "TypeCodeImpl with kind " + this._kind + " and id " + this._id;
    }

    public String id() throws BadKind {
        switch (this._kind) {
            case -1: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return this._id;
            }
        }
        throw new BadKind();
    }

    public String name() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().name();
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return this._name;
            }
        }
        throw new BadKind();
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        PrintStream printStream = new PrintStream(byteArrayOutputStream, true);
        this.printStream(printStream);
        return super.toString() + " =\n" + byteArrayOutputStream.toString();
    }

    private String indent(int n2) {
        String string = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + "  ";
        }
        return string;
    }

    public String member_name(int n2) throws BadKind, Bounds {
        switch (this._kind) {
            case -1: {
                return this.indirectType().member_name(n2);
            }
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 29: {
                try {
                    return this._memberNames[n2];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new Bounds();
                }
            }
        }
        throw new BadKind();
    }

    private void setId(String string) {
        this._id = string;
        if (this._orb instanceof TypeCodeFactory) {
            ((TypeCodeFactory)((Object)this._orb)).setTypeCode(this._id, this);
        }
    }

    protected static short digits(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return 0;
        }
        short s2 = (short)bigDecimal.unscaledValue().toString().length();
        if (bigDecimal.signum() == -1) {
            s2 = (short)(s2 - 1);
        }
        return s2;
    }

    protected static short scale(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return 0;
        }
        return (short)bigDecimal.scale();
    }

    public Any member_label(int n2) throws BadKind, Bounds {
        switch (this._kind) {
            case -1: {
                return this.indirectType().member_label(n2);
            }
            case 16: {
                try {
                    return new AnyImpl(this._orb, this._unionLabels[n2]);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new Bounds();
                }
            }
        }
        throw new BadKind();
    }

    int currentUnionMemberIndex(Any any) throws BadKind {
        if (this._kind != 16) {
            throw new BadKind();
        }
        try {
            for (int i2 = 0; i2 < this.member_count(); ++i2) {
                if (!this.member_label(i2).equal(any)) continue;
                return i2;
            }
            if (this._defaultIndex != -1) {
                return this._defaultIndex;
            }
        }
        catch (BadKind badKind) {
        }
        catch (Bounds bounds) {
            // empty catch block
        }
        return -1;
    }

    public TypeCodeImpl(ORB oRB) {
        this._orb = oRB;
    }

    public TypeCodeImpl(ORB oRB, int n2, int n3) {
        if (n3 < 0) {
            throw new BAD_PARAM("bound can not be negative!");
        }
        this._orb = oRB;
        if (n2 == 18 || n2 == 27) {
            this._kind = n2;
            this._length = n3;
        }
    }

    public TypeCodeImpl(ORB oRB, int n2, int n3, int n4) {
        this._orb = oRB;
        if (n2 == 19) {
            this._kind = n2;
            this._length = n3;
            this._parentOffset = n4;
        }
    }

    public TypeCodeImpl(ORB oRB, int n2, short s2, short s3) {
        this._orb = oRB;
        if (n2 == 28) {
            this._kind = n2;
            this._digits = s2;
            this._scale = s3;
        }
    }

    public TCKind kind() {
        if (this._kind == -1) {
            return this.indirectType().kind();
        }
        return TCKind.from_int(this._kind);
    }

    public TypeCode concrete_base_type() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().concrete_base_type();
            }
            case 29: {
                return this._concrete_base;
            }
        }
        throw new BadKind();
    }

    public TypeCode content_type() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().content_type();
            }
            case 19: {
                return this.lazy_content_type();
            }
            case 20: 
            case 21: 
            case 30: {
                return this._contentType;
            }
        }
        throw new BadKind();
    }

    public TypeCode discriminator_type() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().discriminator_type();
            }
            case 16: {
                return this._discriminator;
            }
        }
        throw new BadKind();
    }

    public TypeCode get_compact_typecode() {
        return this;
    }

    public TypeCode member_type(int n2) throws BadKind, Bounds {
        switch (this._kind) {
            case -1: {
                return this.indirectType().member_type(n2);
            }
            case 15: 
            case 16: 
            case 22: 
            case 29: {
                try {
                    return this._memberTypes[n2];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new Bounds();
                }
            }
        }
        throw new BadKind();
    }

    public final boolean equal(TypeCode typeCode) {
        if (typeCode == this) {
            return true;
        }
        try {
            if (this._kind == -1) {
                if (this._id != null && typeCode.id() != null) {
                    return this._id.equals(typeCode.id());
                }
                return this._id == null && typeCode.id() == null;
            }
            if (this._kind != typeCode.kind().value()) {
                return false;
            }
            switch (typeTable[this._kind]) {
                case 0: {
                    return true;
                }
                case 1: {
                    switch (this._kind) {
                        case 18: 
                        case 27: {
                            return this._length == typeCode.length();
                        }
                        case 28: {
                            return this._digits == typeCode.fixed_digits() && this._scale == typeCode.fixed_scale();
                        }
                    }
                    return false;
                }
                case 2: {
                    switch (this._kind) {
                        case 14: {
                            if (this._id.compareTo(typeCode.id()) == 0) {
                                return true;
                            }
                            if (this._id.compareTo(TypeCodeImpl.get_primitive_tc(this._kind).id()) == 0) {
                                return true;
                            }
                            return typeCode.id().compareTo(TypeCodeImpl.get_primitive_tc(this._kind).id()) == 0;
                        }
                        case 31: 
                        case 32: {
                            return this._id.compareTo(typeCode.id()) == 0;
                        }
                        case 15: 
                        case 22: {
                            if (this._memberCount != typeCode.member_count()) {
                                return false;
                            }
                            if (this._id.compareTo(typeCode.id()) != 0) {
                                return false;
                            }
                            for (int i2 = 0; i2 < this._memberCount; ++i2) {
                                if (this._memberTypes[i2].equal(typeCode.member_type(i2))) continue;
                                return false;
                            }
                            return true;
                        }
                        case 16: {
                            int n2;
                            if (this._memberCount != typeCode.member_count()) {
                                return false;
                            }
                            if (this._id.compareTo(typeCode.id()) != 0) {
                                return false;
                            }
                            if (this._defaultIndex != typeCode.default_index()) {
                                return false;
                            }
                            if (!this._discriminator.equal(typeCode.discriminator_type())) {
                                return false;
                            }
                            for (n2 = 0; n2 < this._memberCount; ++n2) {
                                if (this._unionLabels[n2].equal(typeCode.member_label(n2))) continue;
                                return false;
                            }
                            for (n2 = 0; n2 < this._memberCount; ++n2) {
                                if (this._memberTypes[n2].equal(typeCode.member_type(n2))) continue;
                                return false;
                            }
                            return true;
                        }
                        case 17: {
                            if (this._id.compareTo(typeCode.id()) != 0) {
                                return false;
                            }
                            return this._memberCount == typeCode.member_count();
                        }
                        case 19: 
                        case 20: {
                            if (this._length != typeCode.length()) {
                                return false;
                            }
                            return this.lazy_content_type().equal(typeCode.content_type());
                        }
                        case 29: {
                            if (this._memberCount != typeCode.member_count()) {
                                return false;
                            }
                            if (this._id.compareTo(typeCode.id()) != 0) {
                                return false;
                            }
                            for (int i3 = 0; i3 < this._memberCount; ++i3) {
                                if (this._memberAccess[i3] == typeCode.member_visibility(i3) && this._memberTypes[i3].equal(typeCode.member_type(i3))) continue;
                                return false;
                            }
                            if (this._type_modifier == typeCode.type_modifier()) {
                                return false;
                            }
                            TypeCode typeCode2 = typeCode.concrete_base_type();
                            return !(this._concrete_base == null && typeCode2 != null || this._concrete_base != null && typeCode2 == null) && this._concrete_base.equal(typeCode2);
                        }
                        case 21: 
                        case 30: {
                            if (this._id.compareTo(typeCode.id()) != 0) {
                                return false;
                            }
                            return this._contentType.equal(typeCode.content_type());
                        }
                    }
                }
            }
        }
        catch (Bounds bounds) {
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        return false;
    }

    public boolean equivalent(TypeCode typeCode) {
        if (typeCode == this) {
            return true;
        }
        TypeCode typeCode2 = this._kind == -1 ? this.indirectType() : this;
        typeCode2 = this.realType(typeCode2);
        TypeCode typeCode3 = this.realType(typeCode);
        if (typeCode2.kind().value() != typeCode3.kind().value()) {
            return false;
        }
        String string = null;
        String string2 = null;
        try {
            string = this.id();
            string2 = typeCode.id();
            if (string != null && string2 != null) {
                return string.equals(string2);
            }
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        int n2 = typeCode2.kind().value();
        try {
            int n3;
            if ((n2 == 15 || n2 == 16 || n2 == 17 || n2 == 22 || n2 == 29) && typeCode2.member_count() != typeCode3.member_count()) {
                return false;
            }
            if (n2 == 16 && typeCode2.default_index() != typeCode3.default_index()) {
                return false;
            }
            if ((n2 == 18 || n2 == 27 || n2 == 19 || n2 == 20) && typeCode2.length() != typeCode3.length()) {
                return false;
            }
            if (n2 == 28 && (typeCode2.fixed_digits() != typeCode3.fixed_digits() || typeCode2.fixed_scale() != typeCode3.fixed_scale())) {
                return false;
            }
            if (n2 == 16) {
                for (n3 = 0; n3 < typeCode2.member_count(); ++n3) {
                    if (typeCode2.member_label(n3) == typeCode3.member_label(n3)) continue;
                    return false;
                }
                if (!typeCode2.discriminator_type().equivalent(typeCode3.discriminator_type())) {
                    return false;
                }
            }
            if (!(n2 != 21 && n2 != 30 && n2 != 19 && n2 != 20 || typeCode2.content_type().equivalent(typeCode3.content_type()))) {
                return false;
            }
            if (n2 == 15 || n2 == 16 || n2 == 22 || n2 == 29) {
                for (n3 = 0; n3 < typeCode2.member_count(); ++n3) {
                    if (typeCode2.member_type(n3).equivalent(typeCode3.member_type(n3))) continue;
                    return false;
                }
            }
        }
        catch (BadKind badKind) {
            throw new INTERNAL();
        }
        catch (Bounds bounds) {
            throw new INTERNAL();
        }
        return true;
    }

    public void read_value(InputStream inputStream) {
        if (inputStream instanceof TypeCodeReader) {
            if (this.read_value_kind((TypeCodeReader)((Object)inputStream))) {
                this.read_value_body(inputStream);
            }
        } else if (inputStream instanceof CDRInputStream) {
            WrapperInputStream wrapperInputStream = new WrapperInputStream((CDRInputStream)inputStream);
            if (this.read_value_kind(wrapperInputStream)) {
                this.read_value_body(wrapperInputStream);
            }
        } else {
            this.read_value_kind(inputStream);
            this.read_value_body(inputStream);
        }
    }

    void read_value_body(InputStream inputStream) {
        block0 : switch (typeTable[this._kind]) {
            case 0: {
                break;
            }
            case 1: {
                switch (this._kind) {
                    case 18: 
                    case 27: {
                        this._length = inputStream.read_long();
                        break block0;
                    }
                    case 28: {
                        this._digits = inputStream.read_ushort();
                        this._scale = inputStream.read_short();
                        break block0;
                    }
                }
                throw new MARSHAL();
            }
            case 2: {
                TypeCodeInputStream typeCodeInputStream = TypeCodeInputStream.readEncapsulation(inputStream, this._orb);
                switch (this._kind) {
                    case 14: 
                    case 32: {
                        this.setId(typeCodeInputStream.read_string());
                        this._name = typeCodeInputStream.read_string();
                        break block0;
                    }
                    case 16: {
                        this.setId(typeCodeInputStream.read_string());
                        this._name = typeCodeInputStream.read_string();
                        this._discriminator = new TypeCodeImpl(this._orb);
                        this._discriminator.read_value_recursive(typeCodeInputStream);
                        this._defaultIndex = typeCodeInputStream.read_long();
                        this._memberCount = typeCodeInputStream.read_long();
                        this._unionLabels = new AnyImpl[this._memberCount];
                        this._memberNames = new String[this._memberCount];
                        this._memberTypes = new TypeCodeImpl[this._memberCount];
                        for (int i2 = 0; i2 < this._memberCount; ++i2) {
                            this._unionLabels[i2] = new AnyImpl(this._orb);
                            if (i2 == this._defaultIndex) {
                                this._unionLabels[i2].insert_octet(typeCodeInputStream.read_octet());
                            } else {
                                switch (this.realType(this._discriminator).kind().value()) {
                                    case 2: {
                                        this._unionLabels[i2].insert_short(typeCodeInputStream.read_short());
                                        break;
                                    }
                                    case 3: {
                                        this._unionLabels[i2].insert_long(typeCodeInputStream.read_long());
                                        break;
                                    }
                                    case 4: {
                                        this._unionLabels[i2].insert_ushort(typeCodeInputStream.read_short());
                                        break;
                                    }
                                    case 5: {
                                        this._unionLabels[i2].insert_ulong(typeCodeInputStream.read_long());
                                        break;
                                    }
                                    case 6: {
                                        this._unionLabels[i2].insert_float(typeCodeInputStream.read_float());
                                        break;
                                    }
                                    case 7: {
                                        this._unionLabels[i2].insert_double(typeCodeInputStream.read_double());
                                        break;
                                    }
                                    case 8: {
                                        this._unionLabels[i2].insert_boolean(typeCodeInputStream.read_boolean());
                                        break;
                                    }
                                    case 9: {
                                        this._unionLabels[i2].insert_char(typeCodeInputStream.read_char());
                                        break;
                                    }
                                    case 17: {
                                        this._unionLabels[i2].type(this._discriminator);
                                        this._unionLabels[i2].insert_long(typeCodeInputStream.read_long());
                                        break;
                                    }
                                    case 23: {
                                        this._unionLabels[i2].insert_longlong(typeCodeInputStream.read_longlong());
                                        break;
                                    }
                                    case 24: {
                                        this._unionLabels[i2].insert_ulonglong(typeCodeInputStream.read_longlong());
                                        break;
                                    }
                                    case 26: {
                                        this._unionLabels[i2].insert_wchar(typeCodeInputStream.read_wchar());
                                        break;
                                    }
                                    default: {
                                        throw new MARSHAL();
                                    }
                                }
                            }
                            this._memberNames[i2] = typeCodeInputStream.read_string();
                            this._memberTypes[i2] = new TypeCodeImpl(this._orb);
                            this._memberTypes[i2].read_value_recursive(typeCodeInputStream);
                            this._memberTypes[i2].setParent(this);
                        }
                        break block0;
                    }
                    case 17: {
                        this.setId(typeCodeInputStream.read_string());
                        this._name = typeCodeInputStream.read_string();
                        this._memberCount = typeCodeInputStream.read_long();
                        this._memberNames = new String[this._memberCount];
                        for (int i3 = 0; i3 < this._memberCount; ++i3) {
                            this._memberNames[i3] = typeCodeInputStream.read_string();
                        }
                        break block0;
                    }
                    case 19: {
                        this._contentType = new TypeCodeImpl(this._orb);
                        this._contentType.read_value_recursive(typeCodeInputStream);
                        this._length = typeCodeInputStream.read_long();
                        break block0;
                    }
                    case 20: {
                        this._contentType = new TypeCodeImpl(this._orb);
                        this._contentType.read_value_recursive(typeCodeInputStream);
                        this._length = typeCodeInputStream.read_long();
                        break block0;
                    }
                    case 21: 
                    case 30: {
                        this.setId(typeCodeInputStream.read_string());
                        this._name = typeCodeInputStream.read_string();
                        this._contentType = new TypeCodeImpl(this._orb);
                        this._contentType.read_value_recursive(typeCodeInputStream);
                        break block0;
                    }
                    case 15: 
                    case 22: {
                        this.setId(typeCodeInputStream.read_string());
                        this._name = typeCodeInputStream.read_string();
                        this._memberCount = typeCodeInputStream.read_long();
                        this._memberNames = new String[this._memberCount];
                        this._memberTypes = new TypeCodeImpl[this._memberCount];
                        for (int i4 = 0; i4 < this._memberCount; ++i4) {
                            this._memberNames[i4] = typeCodeInputStream.read_string();
                            this._memberTypes[i4] = new TypeCodeImpl(this._orb);
                            this._memberTypes[i4].read_value_recursive(typeCodeInputStream);
                            this._memberTypes[i4].setParent(this);
                        }
                        break block0;
                    }
                    case 29: {
                        this.setId(typeCodeInputStream.read_string());
                        this._name = typeCodeInputStream.read_string();
                        this._type_modifier = typeCodeInputStream.read_short();
                        this._concrete_base = new TypeCodeImpl(this._orb);
                        this._concrete_base.read_value_recursive(typeCodeInputStream);
                        if (this._concrete_base.kind().value() == 0) {
                            this._concrete_base = null;
                        }
                        this._memberCount = typeCodeInputStream.read_long();
                        this._memberNames = new String[this._memberCount];
                        this._memberTypes = new TypeCodeImpl[this._memberCount];
                        this._memberAccess = new short[this._memberCount];
                        for (int i5 = 0; i5 < this._memberCount; ++i5) {
                            this._memberNames[i5] = typeCodeInputStream.read_string();
                            this._memberTypes[i5] = new TypeCodeImpl(this._orb);
                            this._memberTypes[i5].read_value_recursive(typeCodeInputStream);
                            this._memberTypes[i5].setParent(this);
                            this._memberAccess[i5] = typeCodeInputStream.read_short();
                        }
                        break block0;
                    }
                }
                throw new MARSHAL();
            }
        }
    }

    void read_value_kind(InputStream inputStream) {
        this._kind = inputStream.read_long();
        if ((this._kind < 0 || this._kind > typeTable.length) && this._kind != -1) {
            throw new MARSHAL();
        }
        if (this._kind == 31) {
            throw new MARSHAL();
        }
        if (this._kind == -1) {
            throw new MARSHAL("InputStream subtype not supporting recursive type codes!");
        }
    }

    public void write_value(OutputStream outputStream) {
        if (outputStream instanceof TypeCodeOutputStream) {
            this.write_value((TypeCodeOutputStream)outputStream);
        } else {
            TypeCodeOutputStream typeCodeOutputStream = null;
            if (this.outBuffer == null) {
                typeCodeOutputStream = TypeCodeOutputStream.wrapOutputStream(outputStream);
                this.write_value(typeCodeOutputStream);
                if (this.cachingEnabled) {
                    this.outBuffer = typeCodeOutputStream.getTypeCodeBuffer();
                }
            }
            if (this.cachingEnabled && this.outBuffer != null) {
                outputStream.write_long(this._kind);
                outputStream.write_octet_array(this.outBuffer, 0, this.outBuffer.length);
            } else {
                typeCodeOutputStream.writeRawBuffer(outputStream, this._kind);
            }
        }
    }

    public static TypeCodeImpl get_primitive_tc(TCKind tCKind) {
        try {
            return primitiveConstants[tCKind.value()];
        }
        catch (Throwable throwable) {
            throw new BAD_OPERATION("Invalid or unavailable typecode for kind = " + tCKind.value());
        }
    }

    public static CDROutputStream newOutputStream(ORB oRB) {
        TypeCodeOutputStream typeCodeOutputStream = new TypeCodeOutputStream(oRB);
        return typeCodeOutputStream;
    }

    public TypeCodeImpl(ORB oRB, String string) {
        this._orb = oRB;
        this._kind = -1;
        this._id = string;
        this.tryIndirectType();
    }

    public TypeCodeImpl(ORB oRB, int n2, int n3, TypeCode typeCode) {
        this._orb = oRB;
        if (n2 == 19 || n2 == 20) {
            this._kind = n2;
            this._length = n3;
            this._contentType = TypeCodeImpl.convertToNative(this._orb, typeCode);
        }
    }

    public TypeCodeImpl(ORB oRB, TypeCode typeCode) {
        TypeCode typeCode2;
        this._orb = oRB;
        if (typeCode instanceof TypeCodeImpl) {
            typeCode2 = (TypeCodeImpl)typeCode;
            if (typeCode2._kind == -1) {
                throw new BAD_TYPECODE();
            }
            if (typeCode2._kind == 19 && typeCode2._contentType == null) {
                throw new BAD_TYPECODE();
            }
        }
        this._kind = typeCode.kind().value();
        try {
            switch (this._kind) {
                case 29: {
                    int n2;
                    this._type_modifier = typeCode.type_modifier();
                    typeCode2 = typeCode.concrete_base_type();
                    this._concrete_base = typeCode2 != null ? TypeCodeImpl.convertToNative(this._orb, typeCode2) : null;
                    this._memberAccess = new short[typeCode.member_count()];
                    for (n2 = 0; n2 < typeCode.member_count(); ++n2) {
                        this._memberAccess[n2] = typeCode.member_visibility(n2);
                    }
                }
                case 15: 
                case 16: 
                case 22: {
                    int n2;
                    this._memberTypes = new TypeCodeImpl[typeCode.member_count()];
                    for (n2 = 0; n2 < typeCode.member_count(); ++n2) {
                        this._memberTypes[n2] = TypeCodeImpl.convertToNative(this._orb, typeCode.member_type(n2));
                        this._memberTypes[n2].setParent(this);
                    }
                }
                case 17: {
                    int n2;
                    this._memberNames = new String[typeCode.member_count()];
                    for (n2 = 0; n2 < typeCode.member_count(); ++n2) {
                        this._memberNames[n2] = typeCode.member_name(n2);
                    }
                    this._memberCount = typeCode.member_count();
                }
                case 14: 
                case 21: 
                case 30: 
                case 31: 
                case 32: {
                    this.setId(typeCode.id());
                    this._name = typeCode.name();
                }
            }
            switch (this._kind) {
                case 16: {
                    this._discriminator = TypeCodeImpl.convertToNative(this._orb, typeCode.discriminator_type());
                    this._defaultIndex = typeCode.default_index();
                    this._unionLabels = new AnyImpl[this._memberCount];
                    for (int i2 = 0; i2 < this._memberCount; ++i2) {
                        this._unionLabels[i2] = new AnyImpl(this._orb, typeCode.member_label(i2));
                    }
                    break;
                }
            }
            switch (this._kind) {
                case 18: 
                case 19: 
                case 20: 
                case 27: {
                    this._length = typeCode.length();
                }
            }
            switch (this._kind) {
                case 19: 
                case 20: 
                case 21: 
                case 30: {
                    this._contentType = TypeCodeImpl.convertToNative(this._orb, typeCode.content_type());
                }
            }
        }
        catch (Bounds bounds) {
        }
        catch (BadKind badKind) {
            // empty catch block
        }
    }

    private TypeCode realType(TypeCode typeCode) {
        TypeCode typeCode2 = typeCode;
        try {
            while (typeCode2.kind().value() == 21) {
                typeCode2 = typeCode2.content_type();
            }
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        return typeCode2;
    }

    protected void copy(org.omg.CORBA.portable.InputStream inputStream, org.omg.CORBA.portable.OutputStream outputStream) {
        switch (this._kind) {
            case 0: 
            case 1: 
            case 31: 
            case 32: {
                break;
            }
            case 2: 
            case 4: {
                outputStream.write_short(inputStream.read_short());
                break;
            }
            case 3: 
            case 5: {
                outputStream.write_long(inputStream.read_long());
                break;
            }
            case 6: {
                outputStream.write_float(inputStream.read_float());
                break;
            }
            case 7: {
                outputStream.write_double(inputStream.read_double());
                break;
            }
            case 23: 
            case 24: {
                outputStream.write_longlong(inputStream.read_longlong());
                break;
            }
            case 25: {
                throw new NO_IMPLEMENT();
            }
            case 8: {
                outputStream.write_boolean(inputStream.read_boolean());
                break;
            }
            case 9: {
                outputStream.write_char(inputStream.read_char());
                break;
            }
            case 26: {
                outputStream.write_wchar(inputStream.read_wchar());
                break;
            }
            case 10: {
                outputStream.write_octet(inputStream.read_octet());
                break;
            }
            case 18: {
                String string = inputStream.read_string();
                if (this._length != 0 && string.length() > this._length) {
                    throw new MARSHAL();
                }
                outputStream.write_string(string);
                break;
            }
            case 27: {
                String string = inputStream.read_wstring();
                if (this._length != 0 && string.length() > this._length) {
                    throw new MARSHAL();
                }
                outputStream.write_wstring(string);
                break;
            }
            case 28: {
                outputStream.write_ushort(inputStream.read_ushort());
                outputStream.write_short(inputStream.read_short());
                break;
            }
            case 11: {
                Any any = ((CDRInputStream)inputStream).orb().create_any();
                TypeCodeImpl typeCodeImpl = new TypeCodeImpl(this._orb);
                typeCodeImpl.read_value((InputStream)inputStream);
                typeCodeImpl.write_value((OutputStream)outputStream);
                any.read_value(inputStream, typeCodeImpl);
                any.write_value(outputStream);
                break;
            }
            case 12: {
                outputStream.write_TypeCode(inputStream.read_TypeCode());
                break;
            }
            case 13: {
                outputStream.write_Principal(inputStream.read_Principal());
                break;
            }
            case 14: {
                outputStream.write_Object(inputStream.read_Object());
                break;
            }
            case 22: {
                outputStream.write_string(inputStream.read_string());
            }
            case 15: 
            case 29: {
                for (int i2 = 0; i2 < this._memberTypes.length; ++i2) {
                    this._memberTypes[i2].copy(inputStream, outputStream);
                }
                break;
            }
            case 16: {
                int n2;
                AnyImpl anyImpl = new AnyImpl(this._orb);
                switch (this.realType(this._discriminator).kind().value()) {
                    case 2: {
                        short s2 = inputStream.read_short();
                        ((Any)anyImpl).insert_short(s2);
                        outputStream.write_short(s2);
                        break;
                    }
                    case 3: {
                        int n3 = inputStream.read_long();
                        ((Any)anyImpl).insert_long(n3);
                        outputStream.write_long(n3);
                        break;
                    }
                    case 4: {
                        short s3 = inputStream.read_short();
                        ((Any)anyImpl).insert_ushort(s3);
                        outputStream.write_short(s3);
                        break;
                    }
                    case 5: {
                        int n4 = inputStream.read_long();
                        ((Any)anyImpl).insert_ulong(n4);
                        outputStream.write_long(n4);
                        break;
                    }
                    case 6: {
                        float f2 = inputStream.read_float();
                        ((Any)anyImpl).insert_float(f2);
                        outputStream.write_float(f2);
                        break;
                    }
                    case 7: {
                        double d2 = inputStream.read_double();
                        ((Any)anyImpl).insert_double(d2);
                        outputStream.write_double(d2);
                        break;
                    }
                    case 8: {
                        boolean bl2 = inputStream.read_boolean();
                        ((Any)anyImpl).insert_boolean(bl2);
                        outputStream.write_boolean(bl2);
                        break;
                    }
                    case 9: {
                        char c2 = inputStream.read_char();
                        ((Any)anyImpl).insert_char(c2);
                        outputStream.write_char(c2);
                        break;
                    }
                    case 17: {
                        int n5 = inputStream.read_long();
                        ((Any)anyImpl).type(this._discriminator);
                        ((Any)anyImpl).insert_long(n5);
                        outputStream.write_long(n5);
                        break;
                    }
                    case 23: {
                        long l2 = inputStream.read_longlong();
                        ((Any)anyImpl).insert_longlong(l2);
                        outputStream.write_longlong(l2);
                        break;
                    }
                    case 24: {
                        long l3 = inputStream.read_longlong();
                        ((Any)anyImpl).insert_ulonglong(l3);
                        outputStream.write_longlong(l3);
                        break;
                    }
                    case 26: {
                        char c3 = inputStream.read_wchar();
                        ((Any)anyImpl).insert_wchar(c3);
                        outputStream.write_wchar(c3);
                        break;
                    }
                    default: {
                        throw new MARSHAL();
                    }
                }
                for (n2 = 0; n2 < this._unionLabels.length; ++n2) {
                    if (!((Any)anyImpl).equal(this._unionLabels[n2])) continue;
                    this._memberTypes[n2].copy(inputStream, outputStream);
                    break;
                }
                if (n2 != this._unionLabels.length) break;
                if (this._defaultIndex == -1) {
                    throw new MARSHAL();
                }
                this._memberTypes[this._defaultIndex].copy(inputStream, outputStream);
                break;
            }
            case 17: {
                outputStream.write_long(inputStream.read_long());
                break;
            }
            case 19: {
                int n6 = inputStream.read_long();
                if (this._length != 0 && n6 > this._length) {
                    throw new MARSHAL();
                }
                outputStream.write_long(n6);
                this.lazy_content_type();
                for (int i3 = 0; i3 < n6; ++i3) {
                    this._contentType.copy(inputStream, outputStream);
                }
                break;
            }
            case 20: {
                for (int i4 = 0; i4 < this._length; ++i4) {
                    this._contentType.copy(inputStream, outputStream);
                }
                break;
            }
            case 21: 
            case 30: {
                this._contentType.copy(inputStream, outputStream);
                break;
            }
            case -1: {
                this.indirectType().copy(inputStream, outputStream);
                break;
            }
            default: {
                throw new MARSHAL();
            }
        }
    }

    protected static TypeCodeImpl convertToNative(ORB oRB, TypeCode typeCode) {
        if (typeCode instanceof TypeCodeImpl) {
            return (TypeCodeImpl)typeCode;
        }
        return new TypeCodeImpl(oRB, typeCode);
    }

    public TypeCodeImpl(ORB oRB, int n2, String string, String string2) {
        this._orb = oRB;
        if (n2 == 14 || n2 == 31 || n2 == 32) {
            this._kind = n2;
            this.setId(string);
            this._name = string2;
        }
    }

    public TypeCodeImpl(ORB oRB, int n2, String string, String string2, String[] stringArray) {
        this._orb = oRB;
        if (n2 == 17) {
            this._kind = n2;
            this.setId(string);
            this._name = string2;
            this._memberCount = stringArray.length;
            this._memberNames = new String[this._memberCount];
            for (int i2 = 0; i2 < this._memberCount; ++i2) {
                this._memberNames[i2] = stringArray[i2];
            }
        }
    }

    public TypeCodeImpl(ORB oRB, int n2, String string, String string2, StructMember[] structMemberArray) {
        this._orb = oRB;
        if (n2 == 15 || n2 == 22) {
            this._kind = n2;
            this.setId(string);
            this._name = string2;
            this._memberCount = structMemberArray.length;
            this._memberNames = new String[this._memberCount];
            this._memberTypes = new TypeCodeImpl[this._memberCount];
            for (int i2 = 0; i2 < this._memberCount; ++i2) {
                this._memberNames[i2] = structMemberArray[i2].name;
                this._memberTypes[i2] = TypeCodeImpl.convertToNative(this._orb, structMemberArray[i2].type);
                this._memberTypes[i2].setParent(this);
            }
        }
    }

    public TypeCodeImpl(ORB oRB, int n2, String string, String string2, TypeCode typeCode) {
        this._orb = oRB;
        if (n2 == 21 || n2 == 30) {
            this._kind = n2;
            this.setId(string);
            this._name = string2;
            this._contentType = TypeCodeImpl.convertToNative(this._orb, typeCode);
        }
    }

    public TypeCodeImpl(ORB oRB, int n2, String string, String string2, TypeCode typeCode, UnionMember[] unionMemberArray) {
        this._orb = oRB;
        if (n2 == 16) {
            this._kind = n2;
            this.setId(string);
            this._name = string2;
            this._memberCount = unionMemberArray.length;
            this._discriminator = TypeCodeImpl.convertToNative(this._orb, typeCode);
            this._memberNames = new String[this._memberCount];
            this._memberTypes = new TypeCodeImpl[this._memberCount];
            this._unionLabels = new AnyImpl[this._memberCount];
            for (int i2 = 0; i2 < this._memberCount; ++i2) {
                this._memberNames[i2] = unionMemberArray[i2].name;
                this._memberTypes[i2] = TypeCodeImpl.convertToNative(this._orb, unionMemberArray[i2].type);
                this._memberTypes[i2].setParent(this);
                this._unionLabels[i2] = new AnyImpl(this._orb, unionMemberArray[i2].label);
                if (this._unionLabels[i2].type().kind() != TCKind.tk_octet || this._unionLabels[i2].extract_octet() != 0) continue;
                this._defaultIndex = i2;
            }
        }
    }

    public TypeCodeImpl(ORB oRB, int n2, String string, String string2, short s2, TypeCode typeCode, ValueMember[] valueMemberArray) {
        this._orb = oRB;
        if (n2 == 29) {
            this._kind = n2;
            this.setId(string);
            this._name = string2;
            this._type_modifier = s2;
            if (this._concrete_base != null) {
                this._concrete_base = TypeCodeImpl.convertToNative(this._orb, typeCode);
            }
            this._memberCount = valueMemberArray.length;
            this._memberNames = new String[this._memberCount];
            this._memberTypes = new TypeCodeImpl[this._memberCount];
            this._memberAccess = new short[this._memberCount];
            for (int i2 = 0; i2 < this._memberCount; ++i2) {
                this._memberNames[i2] = valueMemberArray[i2].name;
                this._memberTypes[i2] = TypeCodeImpl.convertToNative(this._orb, valueMemberArray[i2].type);
                this._memberTypes[i2].setParent(this);
                this._memberAccess[i2] = valueMemberArray[i2].access;
            }
        }
    }
}

