/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.iiop;

import com.sun.corba.se.internal.corba.ORB;
import com.sun.corba.se.internal.core.GIOPVersion;
import com.sun.corba.se.internal.iiop.BufferManagerRead;
import com.sun.corba.se.internal.iiop.BufferManagerReadGrow;
import com.sun.corba.se.internal.iiop.BufferManagerReadStream;
import com.sun.corba.se.internal.iiop.BufferManagerWrite;
import com.sun.corba.se.internal.iiop.BufferManagerWriteCollect;
import com.sun.corba.se.internal.iiop.BufferManagerWriteGrow;
import com.sun.corba.se.internal.iiop.BufferManagerWriteStream;
import org.omg.CORBA.INTERNAL;

public class BufferManagerFactory {
    public static final int GROW = 0;
    public static final int COLLECT = 1;
    public static final int STREAM = 2;

    public static BufferManagerRead defaultBufferManagerRead() {
        return new BufferManagerReadGrow();
    }

    public static BufferManagerWrite defaultBufferManagerWrite(org.omg.CORBA.ORB oRB) {
        if (oRB == null || !(oRB instanceof ORB)) {
            return new BufferManagerWriteGrow(1024);
        }
        return new BufferManagerWriteGrow(((ORB)oRB).getGIOPBufferSize());
    }

    public static BufferManagerRead newBufferManagerRead(GIOPVersion gIOPVersion, org.omg.CORBA.ORB oRB) {
        switch (gIOPVersion.intValue()) {
            case 256: {
                return new BufferManagerReadGrow();
            }
            case 257: 
            case 258: {
                return new BufferManagerReadStream();
            }
        }
        throw new INTERNAL();
    }

    public static BufferManagerWrite newBufferManagerWrite(GIOPVersion gIOPVersion, org.omg.CORBA.ORB oRB) {
        switch (gIOPVersion.intValue()) {
            case 256: {
                int n2 = oRB != null ? ((ORB)oRB).getGIOPBufferSize() : 1024;
                return new BufferManagerWriteGrow(n2);
            }
            case 257: {
                int n3;
                int n4;
                if (oRB != null) {
                    n4 = ((ORB)oRB).getGIOPFragmentSize();
                    n3 = ((ORB)oRB).getGIOPBuffMgrStrategy(gIOPVersion);
                } else {
                    n4 = 1024;
                    n3 = 0;
                }
                if (n3 == 0) {
                    return new BufferManagerWriteGrow(n4);
                }
                return new BufferManagerWriteCollect(n4);
            }
            case 258: {
                int n5;
                int n6;
                if (oRB != null) {
                    n6 = ((ORB)oRB).getGIOPFragmentSize();
                    n5 = ((ORB)oRB).getGIOPBuffMgrStrategy(gIOPVersion);
                } else {
                    n6 = 1024;
                    n5 = 2;
                }
                if (n5 == 0) {
                    return new BufferManagerWriteGrow(n6);
                }
                if (n5 == 1) {
                    return new BufferManagerWriteCollect(n6);
                }
                return new BufferManagerWriteStream(n6);
            }
        }
        throw new INTERNAL();
    }

    public static BufferManagerWrite newBufferManagerWrite(GIOPVersion gIOPVersion, org.omg.CORBA.ORB oRB, int n2) {
        switch (gIOPVersion.intValue()) {
            case 256: {
                return new BufferManagerWriteGrow(n2);
            }
            case 257: {
                int n3 = oRB != null ? ((ORB)oRB).getGIOPBuffMgrStrategy(gIOPVersion) : 0;
                if (n3 == 0) {
                    return new BufferManagerWriteGrow(n2);
                }
                return new BufferManagerWriteCollect(n2);
            }
            case 258: {
                int n4 = oRB != null ? ((ORB)oRB).getGIOPBuffMgrStrategy(gIOPVersion) : 2;
                if (n4 == 0) {
                    return new BufferManagerWriteGrow(n2);
                }
                if (n4 == 1) {
                    return new BufferManagerWriteCollect(n2);
                }
                return new BufferManagerWriteStream(n2);
            }
        }
        throw new INTERNAL();
    }
}

