/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.iiop;

import com.sun.corba.se.internal.iiop.BufferManagerReadStream;
import com.sun.corba.se.internal.iiop.ByteBufferWithInfo;
import com.sun.corba.se.internal.iiop.CDRInputStream_1_0;
import com.sun.corba.se.internal.iiop.ClientResponseImpl;
import com.sun.corba.se.internal.iiop.Connection;
import com.sun.corba.se.internal.iiop.IIOPConnection;
import com.sun.corba.se.internal.iiop.IIOPInputStream;
import com.sun.corba.se.internal.iiop.RequestProcessor;
import com.sun.corba.se.internal.iiop.ServerRequestImpl;
import com.sun.corba.se.internal.iiop.messages.CancelRequestMessage_1_0;
import com.sun.corba.se.internal.iiop.messages.CancelRequestMessage_1_1;
import com.sun.corba.se.internal.iiop.messages.CancelRequestMessage_1_2;
import com.sun.corba.se.internal.iiop.messages.FragmentMessage_1_1;
import com.sun.corba.se.internal.iiop.messages.FragmentMessage_1_2;
import com.sun.corba.se.internal.iiop.messages.LocateReplyMessage_1_0;
import com.sun.corba.se.internal.iiop.messages.LocateReplyMessage_1_1;
import com.sun.corba.se.internal.iiop.messages.LocateReplyMessage_1_2;
import com.sun.corba.se.internal.iiop.messages.LocateRequestMessage_1_0;
import com.sun.corba.se.internal.iiop.messages.LocateRequestMessage_1_1;
import com.sun.corba.se.internal.iiop.messages.LocateRequestMessage_1_2;
import com.sun.corba.se.internal.iiop.messages.MessageBase;
import com.sun.corba.se.internal.iiop.messages.ReplyMessage;
import com.sun.corba.se.internal.iiop.messages.ReplyMessage_1_0;
import com.sun.corba.se.internal.iiop.messages.ReplyMessage_1_1;
import com.sun.corba.se.internal.iiop.messages.ReplyMessage_1_2;
import com.sun.corba.se.internal.iiop.messages.RequestMessage;
import com.sun.corba.se.internal.iiop.messages.RequestMessage_1_0;
import com.sun.corba.se.internal.iiop.messages.RequestMessage_1_1;
import com.sun.corba.se.internal.iiop.messages.RequestMessage_1_2;
import com.sun.corba.se.internal.orbutil.ORBUtility;
import com.sun.corba.se.internal.orbutil.ThreadPool;
import com.sun.corba.se.internal.orbutil.Work;
import java.io.IOException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public final class MessageMediator {
    private IIOPConnection conn;
    private byte[] buf;
    private static final ThreadPool threadPool = new ThreadPool();

    public final void processRequest() throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Creating message from stream");
        }
        MessageBase messageBase = (MessageBase)MessageBase.createFromStream(this.conn.getORB(), this.conn.getInputStream());
        this.buf = new byte[messageBase.getSize()];
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Reading the message fully, size =" + messageBase.getSize());
        }
        MessageBase.readFully(this.conn.getInputStream(), this.buf, 12, messageBase.getSize() - 12);
        if (this.conn.getORB().giopDebugFlag) {
            System.arraycopy(messageBase.giopHeader, 0, this.buf, 0, 12);
            this.dprint("Received message:");
            ByteBufferWithInfo byteBufferWithInfo = new ByteBufferWithInfo(this.buf, 0);
            byteBufferWithInfo.buflen = messageBase.getSize();
            CDRInputStream_1_0.printBuffer(byteBufferWithInfo);
        }
        messageBase.callback(this);
    }

    private final void processCancelRequest(int n2) {
        Object object;
        if (!this.conn.isServer()) {
            return;
        }
        IIOPInputStream iIOPInputStream = (IIOPInputStream)this.conn.serverRequestMap.get(new Integer(n2));
        if (iIOPInputStream == null) {
            iIOPInputStream = this.conn.theOnly1_1ServerRequestImpl;
            if (iIOPInputStream == null) {
                return;
            }
            object = iIOPInputStream.getMessage();
            if (object.getType() != 0) {
                return;
            }
            int n3 = ((RequestMessage)object).getRequestId();
            if (n3 == 0) {
                return;
            }
            if (n3 != n2) {
                return;
            }
        }
        object = (BufferManagerReadStream)iIOPInputStream.getBufferManager();
        ((BufferManagerReadStream)object).cancelProcessing(n2);
    }

    public MessageMediator(IIOPConnection iIOPConnection) {
        this.conn = iIOPConnection;
    }

    public final void handleInput(CancelRequestMessage_1_0 cancelRequestMessage_1_0) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.0 CancelRequest");
        }
        IIOPInputStream iIOPInputStream = new IIOPInputStream(this.conn, this.buf, cancelRequestMessage_1_0);
        cancelRequestMessage_1_0.read(iIOPInputStream);
        this.processCancelRequest(cancelRequestMessage_1_0.getRequestId());
    }

    public final void handleInput(CancelRequestMessage_1_1 cancelRequestMessage_1_1) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.1 CancelRequest");
        }
        IIOPInputStream iIOPInputStream = new IIOPInputStream(this.conn, this.buf, cancelRequestMessage_1_1);
        cancelRequestMessage_1_1.read(iIOPInputStream);
        this.processCancelRequest(cancelRequestMessage_1_1.getRequestId());
    }

    public final void handleInput(CancelRequestMessage_1_2 cancelRequestMessage_1_2) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.2 CancelRequest");
        }
        IIOPInputStream iIOPInputStream = new IIOPInputStream(this.conn, this.buf, cancelRequestMessage_1_2);
        cancelRequestMessage_1_2.read(iIOPInputStream);
        this.processCancelRequest(cancelRequestMessage_1_2.getRequestId());
    }

    public final void handleInput(FragmentMessage_1_1 fragmentMessage_1_1) throws IOException {
        IIOPInputStream iIOPInputStream;
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.1 Fragment.  Last? " + fragmentMessage_1_1.moreFragmentsToFollow());
        }
        if ((iIOPInputStream = this.conn.isServer() ? this.conn.theOnly1_1ServerRequestImpl : this.conn.theOnly1_1ClientResponseImpl) == null) {
            return;
        }
        iIOPInputStream.getBufferManager().processFragment(this.buf, fragmentMessage_1_1);
        if (!this.conn.isServer() && !fragmentMessage_1_1.moreFragmentsToFollow()) {
            this.conn.theOnly1_1ClientResponseImpl = null;
        }
    }

    public final void handleInput(FragmentMessage_1_2 fragmentMessage_1_2) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.2 Fragment.  Last? " + fragmentMessage_1_2.moreFragmentsToFollow());
        }
        fragmentMessage_1_2.unmarshalRequestID(this.buf);
        Integer n2 = new Integer(fragmentMessage_1_2.getRequestId());
        IIOPInputStream iIOPInputStream = this.conn.isServer() ? (IIOPInputStream)this.conn.serverRequestMap.get(n2) : (IIOPInputStream)this.conn.clientReplyMap.get(n2);
        if (iIOPInputStream == null) {
            return;
        }
        iIOPInputStream.getBufferManager().processFragment(this.buf, fragmentMessage_1_2);
        if (!this.conn.isServer() && !fragmentMessage_1_2.moreFragmentsToFollow()) {
            this.conn.clientReplyMap.remove(n2);
        }
    }

    public final void handleInput(LocateReplyMessage_1_0 locateReplyMessage_1_0) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.0 LocateReply");
        }
        IIOPInputStream iIOPInputStream = new IIOPInputStream(this.conn, this.buf, locateReplyMessage_1_0);
        iIOPInputStream.unmarshalHeader();
        this.conn.signalReplyReceived(locateReplyMessage_1_0.getRequestId(), iIOPInputStream);
    }

    public final void handleInput(LocateReplyMessage_1_1 locateReplyMessage_1_1) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.1 LocateReply");
        }
        IIOPInputStream iIOPInputStream = new IIOPInputStream(this.conn, this.buf, locateReplyMessage_1_1);
        iIOPInputStream.unmarshalHeader();
        this.conn.signalReplyReceived(locateReplyMessage_1_1.getRequestId(), iIOPInputStream);
    }

    public final void handleInput(LocateReplyMessage_1_2 locateReplyMessage_1_2) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.2 LocateReply");
        }
        IIOPInputStream iIOPInputStream = new IIOPInputStream(this.conn, this.buf, locateReplyMessage_1_2);
        locateReplyMessage_1_2.unmarshalRequestID(this.buf);
        if (locateReplyMessage_1_2.moreFragmentsToFollow()) {
            this.conn.clientReplyMap.put(new Integer(locateReplyMessage_1_2.getRequestId()), iIOPInputStream);
        }
        this.conn.signalReplyReceived(locateReplyMessage_1_2.getRequestId(), iIOPInputStream);
    }

    public final void handleInput(LocateRequestMessage_1_0 locateRequestMessage_1_0) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.0 LocateRequest");
        }
        IIOPInputStream iIOPInputStream = new IIOPInputStream(this.conn, this.buf, locateRequestMessage_1_0);
        threadPool.addWork(new RequestProcessor(this.conn.getServerGIOP().getRequestHandler(), this.conn, iIOPInputStream));
    }

    public final void handleInput(LocateRequestMessage_1_1 locateRequestMessage_1_1) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.1 LocateRequest");
        }
        IIOPInputStream iIOPInputStream = new IIOPInputStream(this.conn, this.buf, locateRequestMessage_1_1);
        threadPool.addWork(new RequestProcessor(this.conn.getServerGIOP().getRequestHandler(), this.conn, iIOPInputStream));
    }

    public final void handleInput(LocateRequestMessage_1_2 locateRequestMessage_1_2) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.2 LocateRequest");
        }
        IIOPInputStream iIOPInputStream = new IIOPInputStream(this.conn, this.buf, locateRequestMessage_1_2);
        locateRequestMessage_1_2.unmarshalRequestID(this.buf);
        if (locateRequestMessage_1_2.moreFragmentsToFollow()) {
            this.conn.serverRequestMap.put(new Integer(locateRequestMessage_1_2.getRequestId()), iIOPInputStream);
        }
        threadPool.addWork(new RequestProcessor(this.conn.getServerGIOP().getRequestHandler(), this.conn, iIOPInputStream));
    }

    public final void handleInput(MessageBase messageBase) {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling other GIOP message: " + messageBase.getType());
        }
        switch (messageBase.getType()) {
            case 5: {
                if (this.conn.getORB().transportDebugFlag) {
                    this.dprint("Connection.processInput: got CloseConn, purging");
                }
                this.conn.purge_calls(1398079697, true, false);
                break;
            }
            case 6: {
                if (this.conn.getORB().transportDebugFlag) {
                    this.dprint("Received MessageError, purging");
                }
                this.conn.purge_calls(1398079698, true, false);
                break;
            }
            default: {
                if (this.conn.getORB().transportDebugFlag) {
                    this.dprint("Connection: bad message type" + messageBase.getType());
                }
                throw new INTERNAL(1398079700, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    public final void handleInput(ReplyMessage_1_0 replyMessage_1_0) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.0 reply");
        }
        ClientResponseImpl clientResponseImpl = new ClientResponseImpl((Connection)this.conn, this.buf, replyMessage_1_0);
        clientResponseImpl.unmarshalHeader();
        this.conn.signalReplyReceived(replyMessage_1_0.getRequestId(), clientResponseImpl);
    }

    public final void handleInput(ReplyMessage_1_1 replyMessage_1_1) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.1 reply");
        }
        ClientResponseImpl clientResponseImpl = new ClientResponseImpl((Connection)this.conn, this.buf, replyMessage_1_1);
        if (replyMessage_1_1.moreFragmentsToFollow()) {
            this.conn.theOnly1_1ClientResponseImpl = clientResponseImpl;
            threadPool.addWork(new ReplyProcessor_1_1(this.conn, clientResponseImpl));
        } else {
            clientResponseImpl.unmarshalHeader();
            this.conn.signalReplyReceived(replyMessage_1_1.getRequestId(), clientResponseImpl);
        }
    }

    public final void handleInput(ReplyMessage_1_2 replyMessage_1_2) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.2 reply");
        }
        ClientResponseImpl clientResponseImpl = new ClientResponseImpl((Connection)this.conn, this.buf, replyMessage_1_2);
        replyMessage_1_2.unmarshalRequestID(this.buf);
        if (replyMessage_1_2.moreFragmentsToFollow()) {
            this.conn.clientReplyMap.put(new Integer(replyMessage_1_2.getRequestId()), clientResponseImpl);
        }
        this.conn.signalReplyReceived(replyMessage_1_2.getRequestId(), clientResponseImpl);
    }

    public final void handleInput(RequestMessage_1_0 requestMessage_1_0) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.0 request");
        }
        ServerRequestImpl serverRequestImpl = new ServerRequestImpl((Connection)this.conn, this.buf, requestMessage_1_0);
        threadPool.addWork(new RequestProcessor(this.conn.getServerGIOP().getRequestHandler(), this.conn, serverRequestImpl));
    }

    public final void handleInput(RequestMessage_1_1 requestMessage_1_1) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.1 request");
        }
        ServerRequestImpl serverRequestImpl = new ServerRequestImpl((Connection)this.conn, this.buf, requestMessage_1_1);
        if (requestMessage_1_1.moreFragmentsToFollow()) {
            this.conn.theOnly1_1ServerRequestImpl = serverRequestImpl;
        }
        threadPool.addWork(new RequestProcessor(this.conn.getServerGIOP().getRequestHandler(), this.conn, serverRequestImpl));
    }

    public final void handleInput(RequestMessage_1_2 requestMessage_1_2) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.2 request");
        }
        ServerRequestImpl serverRequestImpl = new ServerRequestImpl((Connection)this.conn, this.buf, requestMessage_1_2);
        requestMessage_1_2.unmarshalRequestID(this.buf);
        if (requestMessage_1_2.moreFragmentsToFollow()) {
            this.conn.serverRequestMap.put(new Integer(requestMessage_1_2.getRequestId()), serverRequestImpl);
        }
        threadPool.addWork(new RequestProcessor(this.conn.getServerGIOP().getRequestHandler(), this.conn, serverRequestImpl));
    }

    private void dprint(String string) {
        ORBUtility.dprint(this, string);
    }

    private static class ReplyProcessor_1_1
    implements Work {
        private static final String name = "ReplyProcessor 1.1";
        private IIOPConnection conn;
        private IIOPInputStream reply;

        public void process() {
            this.reply.unmarshalHeader();
            ReplyMessage replyMessage = (ReplyMessage)this.reply.getMessage();
            this.conn.signalReplyReceived(replyMessage.getRequestId(), this.reply);
        }

        public final String getName() {
            return name;
        }

        ReplyProcessor_1_1(IIOPConnection iIOPConnection, IIOPInputStream iIOPInputStream) {
            this.conn = iIOPConnection;
            this.reply = iIOPInputStream;
        }
    }
}

