/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.dir;

import com.sun.jndi.toolkit.dir.AttrFilter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InvalidSearchFilterException;

public class SearchFilter
implements AttrFilter {
    String filter;
    int pos;
    private StringFilter rootFilter;
    protected static final boolean debug = false;
    protected static final char BEGIN_FILTER_TOKEN = '(';
    protected static final char END_FILTER_TOKEN = ')';
    protected static final char AND_TOKEN = '&';
    protected static final char OR_TOKEN = '|';
    protected static final char NOT_TOKEN = '!';
    protected static final char EQUAL_TOKEN = '=';
    protected static final char APPROX_TOKEN = '~';
    protected static final char LESS_TOKEN = '<';
    protected static final char GREATER_TOKEN = '>';
    protected static final char EXTEND_TOKEN = ':';
    protected static final char WILDCARD_TOKEN = '*';
    static final int EQUAL_MATCH = 1;
    static final int APPROX_MATCH = 2;
    static final int GREATER_MATCH = 3;
    static final int LESS_MATCH = 4;

    protected char getCurrentChar() {
        return this.filter.charAt(this.pos);
    }

    protected void consumeChar() {
        ++this.pos;
    }

    protected void normalizeFilter() {
        this.skipWhiteSpace();
        if (this.getCurrentChar() != '(') {
            this.filter = '(' + this.filter + ')';
        }
    }

    private void skipWhiteSpace() {
        while (Character.isWhitespace(this.getCurrentChar())) {
            this.consumeChar();
        }
    }

    protected char relCharAt(int n2) {
        return this.filter.charAt(this.pos + n2);
    }

    protected int relIndexOf(int n2) {
        return this.filter.indexOf(n2, this.pos) - this.pos;
    }

    protected void consumeChars(int n2) {
        this.pos += n2;
    }

    static void access$000(SearchFilter searchFilter) {
        searchFilter.skipWhiteSpace();
    }

    protected StringFilter createNextFilter() throws InvalidSearchFilterException {
        StringFilter stringFilter;
        this.skipWhiteSpace();
        try {
            if (this.getCurrentChar() != '(') {
                throw new InvalidSearchFilterException("expected \"(\" at position " + this.pos);
            }
            this.consumeChar();
            this.skipWhiteSpace();
            switch (this.getCurrentChar()) {
                case '&': {
                    stringFilter = new CompoundFilter(this, true);
                    stringFilter.parse();
                    break;
                }
                case '|': {
                    stringFilter = new CompoundFilter(this, false);
                    stringFilter.parse();
                    break;
                }
                case '!': {
                    stringFilter = new NotFilter(this);
                    stringFilter.parse();
                    break;
                }
                default: {
                    stringFilter = new AtomicFilter(this);
                    stringFilter.parse();
                }
            }
            this.skipWhiteSpace();
            if (this.getCurrentChar() != ')') {
                throw new InvalidSearchFilterException("expected \")\" at position " + this.pos);
            }
            this.consumeChar();
        }
        catch (InvalidSearchFilterException invalidSearchFilterException) {
            throw invalidSearchFilterException;
        }
        catch (Exception exception) {
            throw new InvalidSearchFilterException("Unable to parse character " + this.pos + " in \"" + this.filter + "\"");
        }
        return stringFilter;
    }

    public static int findUnescaped(char c2, String string, int n2) {
        int n3 = string.length();
        while (n2 < n3) {
            int n4 = string.indexOf(c2, n2);
            if (n4 == n2 || n4 == -1 || string.charAt(n4 - 1) != '\\') {
                return n4;
            }
            n2 = n4 + 1;
        }
        return -1;
    }

    protected String relSubstring(int n2, int n3) {
        return this.filter.substring(n2 + this.pos, n3 + this.pos);
    }

    public SearchFilter(String string) throws InvalidSearchFilterException {
        this.filter = string;
        this.pos = 0;
        this.normalizeFilter();
        this.rootFilter = this.createNextFilter();
    }

    private static void hexDigit(StringBuffer stringBuffer, byte by) {
        char c2 = (char)(by >> 4 & 0xF);
        c2 = c2 > '\t' ? (char)(c2 - 10 + 65) : (char)(c2 + 48);
        stringBuffer.append(c2);
        c2 = (char)(by & 0xF);
        c2 = c2 > '\t' ? (char)(c2 - 10 + 65) : (char)(c2 + 48);
        stringBuffer.append(c2);
    }

    public boolean check(Attributes attributes) throws NamingException {
        if (attributes == null) {
            return false;
        }
        return this.rootFilter.check(attributes);
    }

    private static String getEncodedStringRep(Object object) throws NamingException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                stringBuffer.append('\\');
                SearchFilter.hexDigit(stringBuffer, byArray[i2]);
            }
            return stringBuffer.toString();
        }
        String string = !(object instanceof String) ? object.toString() : (String)object;
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        block8: for (int i3 = 0; i3 < n2; ++i3) {
            char c2 = string.charAt(i3);
            switch (c2) {
                case '*': {
                    stringBuffer.append("\\2a");
                    continue block8;
                }
                case '(': {
                    stringBuffer.append("\\28");
                    continue block8;
                }
                case ')': {
                    stringBuffer.append("\\29");
                    continue block8;
                }
                case '\\': {
                    stringBuffer.append("\\5c");
                    continue block8;
                }
                case '\u0000': {
                    stringBuffer.append("\\00");
                    continue block8;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String format(Attributes attributes) throws NamingException {
        if (attributes == null || attributes.size() == 0) {
            return "objectClass=*";
        }
        String string = "(& ";
        NamingEnumeration namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMore()) {
            Attribute attribute = (Attribute)namingEnumeration.next();
            if (attribute.size() == 0 || attribute.size() == 1 && attribute.get() == null) {
                string = string + "(" + attribute.getID() + "=" + "*)";
                continue;
            }
            NamingEnumeration namingEnumeration2 = attribute.getAll();
            while (namingEnumeration2.hasMore()) {
                String string2 = SearchFilter.getEncodedStringRep(namingEnumeration2.next());
                if (string2 == null) continue;
                string = string + "(" + attribute.getID() + "=" + string2 + ")";
            }
        }
        string = string + ")";
        return string;
    }

    public static String format(String string, Object[] objectArray) throws NamingException {
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while ((n2 = SearchFilter.findUnescaped('{', string, n3)) >= 0) {
            int n4;
            int n5 = n2 + 1;
            int n6 = string.indexOf(125, n5);
            if (n6 < 0) {
                throw new InvalidSearchFilterException("unbalanced {: " + string);
            }
            try {
                n4 = Integer.parseInt(string.substring(n5, n6));
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidSearchFilterException("integer expected inside {}: " + string);
            }
            if (n4 >= objectArray.length) {
                throw new InvalidSearchFilterException("number exceeds argument list: " + n4);
            }
            stringBuffer.append(string.substring(n3, n2)).append(SearchFilter.getEncodedStringRep(objectArray[n4]));
            n3 = n6 + 1;
        }
        if (n3 < string.length()) {
            stringBuffer.append(string.substring(n3));
        }
        return stringBuffer.toString();
    }

    public static Attributes selectAttributes(Attributes attributes, String[] stringArray) throws NamingException {
        if (stringArray == null) {
            return attributes;
        }
        BasicAttributes basicAttributes = new BasicAttributes();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Attribute attribute = attributes.get(stringArray[i2]);
            if (attribute == null) continue;
            basicAttributes.put(attribute);
        }
        return basicAttributes;
    }

    final class AtomicFilter
    implements StringFilter {
        private String attrID;
        private String value;
        private int matchType;
        private final SearchFilter this$0;

        public void parse() throws InvalidSearchFilterException {
            SearchFilter.access$000(this.this$0);
            try {
                int n2 = this.this$0.relIndexOf(41);
                int n3 = this.this$0.relIndexOf(61);
                char c2 = this.this$0.relCharAt(n3 - 1);
                switch (c2) {
                    case '~': {
                        this.matchType = 2;
                        this.attrID = this.this$0.relSubstring(0, n3 - 1);
                        this.value = this.this$0.relSubstring(n3 + 1, n2);
                        break;
                    }
                    case '>': {
                        this.matchType = 3;
                        this.attrID = this.this$0.relSubstring(0, n3 - 1);
                        this.value = this.this$0.relSubstring(n3 + 1, n2);
                        break;
                    }
                    case '<': {
                        this.matchType = 4;
                        this.attrID = this.this$0.relSubstring(0, n3 - 1);
                        this.value = this.this$0.relSubstring(n3 + 1, n2);
                        break;
                    }
                    case ':': {
                        throw new OperationNotSupportedException("Extensible match not supported");
                    }
                    default: {
                        this.matchType = 1;
                        this.attrID = this.this$0.relSubstring(0, n3);
                        this.value = this.this$0.relSubstring(n3 + 1, n2);
                    }
                }
                this.attrID = this.attrID.trim();
                this.value = this.value.trim();
                this.this$0.consumeChars(n2);
            }
            catch (Exception exception) {
                InvalidSearchFilterException invalidSearchFilterException = new InvalidSearchFilterException("Unable to parse character " + this.this$0.pos + " in \"" + this.this$0.filter + "\"");
                invalidSearchFilterException.setRootCause(exception);
                throw invalidSearchFilterException;
            }
        }

        AtomicFilter(SearchFilter searchFilter) {
            this.this$0 = searchFilter;
        }

        public boolean check(Attributes attributes) {
            NamingEnumeration namingEnumeration;
            Object object;
            try {
                object = attributes.get(this.attrID);
                if (object == null) {
                    return false;
                }
                namingEnumeration = object.getAll();
            }
            catch (NamingException namingException) {
                return false;
            }
            block7: while (namingEnumeration.hasMoreElements()) {
                object = namingEnumeration.nextElement().toString();
                switch (this.matchType) {
                    case 1: 
                    case 2: {
                        if (!this.substringMatch(this.value, (String)object)) continue block7;
                        return true;
                    }
                    case 3: {
                        if (((String)object).compareTo(this.value) < 0) continue block7;
                        return true;
                    }
                    case 4: {
                        if (((String)object).compareTo(this.value) > 0) continue block7;
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean substringMatch(String string, String string2) {
            if (string.equals(new Character('*').toString())) {
                return true;
            }
            if (string.indexOf(42) == -1) {
                return string.equalsIgnoreCase(string2);
            }
            int n2 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "*", false);
            if (string.charAt(0) != '*' && !string2.toString().toLowerCase().startsWith(stringTokenizer.nextToken().toLowerCase())) {
                return false;
            }
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                n2 = string2.toLowerCase().indexOf(string3.toLowerCase(), n2);
                if (n2 == -1) {
                    return false;
                }
                n2 += string3.length();
            }
            return string.charAt(string.length() - 1) == '*' || n2 == string2.length();
        }
    }

    final class CompoundFilter
    implements StringFilter {
        private Vector subFilters;
        private boolean polarity;
        private final SearchFilter this$0;

        public void parse() throws InvalidSearchFilterException {
            this.this$0.consumeChar();
            while (this.this$0.getCurrentChar() != ')') {
                StringFilter stringFilter = this.this$0.createNextFilter();
                this.subFilters.addElement(stringFilter);
                SearchFilter.access$000(this.this$0);
            }
        }

        CompoundFilter(SearchFilter searchFilter, boolean bl2) {
            this.this$0 = searchFilter;
            this.subFilters = new Vector();
            this.polarity = bl2;
        }

        public boolean check(Attributes attributes) throws NamingException {
            for (int i2 = 0; i2 < this.subFilters.size(); ++i2) {
                StringFilter stringFilter = (StringFilter)this.subFilters.elementAt(i2);
                if (stringFilter.check(attributes) == this.polarity) continue;
                return !this.polarity;
            }
            return this.polarity;
        }
    }

    final class NotFilter
    implements StringFilter {
        private StringFilter filter;
        private final SearchFilter this$0;

        public void parse() throws InvalidSearchFilterException {
            this.this$0.consumeChar();
            this.filter = this.this$0.createNextFilter();
        }

        NotFilter(SearchFilter searchFilter) {
            this.this$0 = searchFilter;
        }

        public boolean check(Attributes attributes) throws NamingException {
            return !this.filter.check(attributes);
        }
    }

    static interface StringFilter
    extends AttrFilter {
        public void parse() throws InvalidSearchFilterException;
    }
}

