/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.Platform;
import com.sun.media.sound.PortMixer;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;

public class PortMixerProvider
extends MixerProvider {
    private static PortMixerInfo[] infos;
    private static PortMixer[] devices;

    private static native int nGetNumDevices();

    static {
        Platform.initialize();
    }

    public PortMixerProvider() {
        if (Platform.isPortsEnabled()) {
            PortMixerProvider.init();
        } else {
            infos = new PortMixerInfo[0];
            devices = new PortMixer[0];
        }
    }

    private static void init() {
        int n2 = PortMixerProvider.nGetNumDevices();
        if (infos == null || infos.length != n2) {
            infos = new PortMixerInfo[n2];
            devices = new PortMixer[n2];
            for (int i2 = 0; i2 < infos.length; ++i2) {
                PortMixerProvider.infos[i2] = PortMixerProvider.nNewPortMixerInfo(i2);
            }
        }
    }

    private static native PortMixerInfo nNewPortMixerInfo(int var0);

    public Mixer.Info[] getMixerInfo() {
        Mixer.Info[] infoArray = new Mixer.Info[infos.length];
        System.arraycopy(infos, 0, infoArray, 0, infos.length);
        return infoArray;
    }

    private Mixer getDevice(PortMixerInfo portMixerInfo) {
        int n2 = portMixerInfo.getIndex();
        if (devices[n2] == null) {
            PortMixerProvider.devices[n2] = new PortMixer(portMixerInfo);
        }
        return devices[n2];
    }

    public Mixer getMixer(Mixer.Info info) {
        for (int i2 = 0; i2 < infos.length; ++i2) {
            if (!infos[i2].equals(info)) continue;
            return this.getDevice(infos[i2]);
        }
        throw new IllegalArgumentException("Mixer " + info.toString() + " not supported by this provider.");
    }

    static class PortMixerInfo
    extends Mixer.Info {
        private int index;

        int getIndex() {
            return this.index;
        }

        private PortMixerInfo(int n2, String string, String string2, String string3, String string4) {
            super(string, string2, string3, string4);
            this.index = n2;
        }
    }
}

