/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.CharacterIterator;

public abstract class FontMetrics
implements Serializable {
    protected Font font;
    private static final long serialVersionUID = 1681126225205050147L;

    public int getAscent() {
        return this.font.getSize();
    }

    public int getDescent() {
        return 0;
    }

    public int getHeight() {
        return this.getLeading() + this.getAscent() + this.getDescent();
    }

    public int getLeading() {
        return 0;
    }

    public int getMaxAdvance() {
        return -1;
    }

    public int getMaxAscent() {
        return this.getAscent();
    }

    public int getMaxDecent() {
        return this.getMaxDescent();
    }

    public int getMaxDescent() {
        return this.getDescent();
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            FontMetrics.initIDs();
        }
    }

    private static native void initIDs();

    public boolean hasUniformLineMetrics() {
        return this.font.hasUniformLineMetrics();
    }

    public int[] getWidths() {
        int[] nArray = new int[256];
        for (char c2 = '\u0000'; c2 < '\u0100'; c2 = (char)(c2 + '\u0001')) {
            nArray[c2] = this.charWidth(c2);
        }
        return nArray;
    }

    public int charWidth(char c2) {
        if (c2 < '\u0100') {
            return this.getWidths()[c2];
        }
        char[] cArray = new char[]{c2};
        return this.charsWidth(cArray, 0, 1);
    }

    public int charWidth(int n2) {
        return this.charWidth((char)n2);
    }

    public int bytesWidth(byte[] byArray, int n2, int n3) {
        return this.stringWidth(new String(byArray, 0, n2, n3));
    }

    public int charsWidth(char[] cArray, int n2, int n3) {
        return this.stringWidth(new String(cArray, n2, n3));
    }

    public Font getFont() {
        return this.font;
    }

    protected FontMetrics(Font font) {
        this.font = font;
    }

    public String toString() {
        return this.getClass().getName() + "[font=" + this.getFont() + "ascent=" + this.getAscent() + ", descent=" + this.getDescent() + ", height=" + this.getHeight() + "]";
    }

    public int stringWidth(String string) {
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        return this.charsWidth(cArray, 0, n2);
    }

    private FontRenderContext myFRC(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            return ((Graphics2D)graphics).getFontRenderContext();
        }
        return new FontRenderContext(null, false, false);
    }

    public LineMetrics getLineMetrics(char[] cArray, int n2, int n3, Graphics graphics) {
        return this.font.getLineMetrics(cArray, n2, n3, this.myFRC(graphics));
    }

    public Rectangle2D getMaxCharBounds(Graphics graphics) {
        return this.font.getMaxCharBounds(this.myFRC(graphics));
    }

    public Rectangle2D getStringBounds(char[] cArray, int n2, int n3, Graphics graphics) {
        return this.font.getStringBounds(cArray, n2, n3, this.myFRC(graphics));
    }

    public LineMetrics getLineMetrics(String string, int n2, int n3, Graphics graphics) {
        return this.font.getLineMetrics(string, n2, n3, this.myFRC(graphics));
    }

    public LineMetrics getLineMetrics(String string, Graphics graphics) {
        return this.font.getLineMetrics(string, this.myFRC(graphics));
    }

    public LineMetrics getLineMetrics(CharacterIterator characterIterator, int n2, int n3, Graphics graphics) {
        return this.font.getLineMetrics(characterIterator, n2, n3, this.myFRC(graphics));
    }

    public Rectangle2D getStringBounds(String string, int n2, int n3, Graphics graphics) {
        return this.font.getStringBounds(string, n2, n3, this.myFRC(graphics));
    }

    public Rectangle2D getStringBounds(String string, Graphics graphics) {
        return this.font.getStringBounds(string, this.myFRC(graphics));
    }

    public Rectangle2D getStringBounds(CharacterIterator characterIterator, int n2, int n3, Graphics graphics) {
        return this.font.getStringBounds(characterIterator, n2, n3, this.myFRC(graphics));
    }
}

