/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;

class GenericBeanInfo
extends SimpleBeanInfo {
    private BeanDescriptor beanDescriptor;
    private EventSetDescriptor[] events;
    private int defaultEvent;
    private PropertyDescriptor[] properties;
    private int defaultProperty;
    private MethodDescriptor[] methods;
    private BeanInfo targetBeanInfo;

    public int getDefaultEventIndex() {
        return this.defaultEvent;
    }

    public int getDefaultPropertyIndex() {
        return this.defaultProperty;
    }

    public Image getIcon(int n2) {
        if (this.targetBeanInfo != null) {
            return this.targetBeanInfo.getIcon(n2);
        }
        return super.getIcon(n2);
    }

    public BeanDescriptor getBeanDescriptor() {
        return this.beanDescriptor;
    }

    public EventSetDescriptor[] getEventSetDescriptors() {
        return this.events;
    }

    GenericBeanInfo(GenericBeanInfo genericBeanInfo) {
        int n2;
        int n3;
        this.beanDescriptor = new BeanDescriptor(genericBeanInfo.beanDescriptor);
        if (genericBeanInfo.events != null) {
            n3 = genericBeanInfo.events.length;
            this.events = new EventSetDescriptor[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.events[n2] = new EventSetDescriptor(genericBeanInfo.events[n2]);
            }
        }
        this.defaultEvent = genericBeanInfo.defaultEvent;
        if (genericBeanInfo.properties != null) {
            n3 = genericBeanInfo.properties.length;
            this.properties = new PropertyDescriptor[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                PropertyDescriptor propertyDescriptor = genericBeanInfo.properties[n2];
                this.properties[n2] = propertyDescriptor instanceof IndexedPropertyDescriptor ? new IndexedPropertyDescriptor((IndexedPropertyDescriptor)propertyDescriptor) : new PropertyDescriptor(propertyDescriptor);
            }
        }
        this.defaultProperty = genericBeanInfo.defaultProperty;
        if (genericBeanInfo.methods != null) {
            n3 = genericBeanInfo.methods.length;
            this.methods = new MethodDescriptor[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.methods[n2] = new MethodDescriptor(genericBeanInfo.methods[n2]);
            }
        }
        this.targetBeanInfo = genericBeanInfo.targetBeanInfo;
    }

    public MethodDescriptor[] getMethodDescriptors() {
        return this.methods;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.properties;
    }

    public GenericBeanInfo(BeanDescriptor beanDescriptor, EventSetDescriptor[] eventSetDescriptorArray, int n2, PropertyDescriptor[] propertyDescriptorArray, int n3, MethodDescriptor[] methodDescriptorArray, BeanInfo beanInfo) {
        this.beanDescriptor = beanDescriptor;
        this.events = eventSetDescriptorArray;
        this.defaultEvent = n2;
        this.properties = propertyDescriptorArray;
        this.defaultProperty = n3;
        this.methods = methodDescriptorArray;
        this.targetBeanInfo = beanInfo;
    }
}

