/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.util.Date;

public class Timestamp
extends Date {
    private int nanos;
    static final long serialVersionUID = 2745179027874758501L;

    public int getNanos() {
        return this.nanos;
    }

    public long getTime() {
        long l2 = super.getTime();
        return l2 + (long)(this.nanos / 1000000);
    }

    public void setNanos(int n2) {
        if (n2 > 999999999 || n2 < 0) {
            throw new IllegalArgumentException("nanos > 999999999 or < 0");
        }
        this.nanos = n2;
    }

    public Timestamp(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(n2, n3, n4, n5, n6, n7);
        if (n8 > 999999999 || n8 < 0) {
            throw new IllegalArgumentException("nanos > 999999999 or < 0");
        }
        this.nanos = n8;
    }

    public Timestamp(long l2) {
        super(l2 / 1000L * 1000L);
        this.nanos = (int)(l2 % 1000L * 1000000L);
        if (this.nanos < 0) {
            this.nanos = 1000000000 + this.nanos;
            super.setTime((l2 / 1000L - 1L) * 1000L);
        }
    }

    public void setTime(long l2) {
        super.setTime(l2 / 1000L * 1000L);
        this.nanos = (int)(l2 % 1000L * 1000000L);
        if (this.nanos < 0) {
            this.nanos = 1000000000 + this.nanos;
            super.setTime((l2 / 1000L - 1L) * 1000L);
        }
    }

    public int compareTo(Object object) {
        return this.compareTo((Timestamp)object);
    }

    public boolean equals(Object object) {
        if (object instanceof Timestamp) {
            return this.equals((Timestamp)object);
        }
        return false;
    }

    public String toString() {
        String string;
        String string2;
        int n2 = super.getYear() + 1900;
        int n3 = super.getMonth() + 1;
        int n4 = super.getDate();
        int n5 = super.getHours();
        int n6 = super.getMinutes();
        int n7 = super.getSeconds();
        String string3 = "000000000";
        String string4 = "0000";
        if (n2 < 1000) {
            string2 = "" + n2;
            string2 = string4.substring(0, 4 - string2.length()) + string2;
        } else {
            string2 = "" + n2;
        }
        String string5 = n3 < 10 ? "0" + n3 : Integer.toString(n3);
        String string6 = n4 < 10 ? "0" + n4 : Integer.toString(n4);
        String string7 = n5 < 10 ? "0" + n5 : Integer.toString(n5);
        String string8 = n6 < 10 ? "0" + n6 : Integer.toString(n6);
        String string9 = n7 < 10 ? "0" + n7 : Integer.toString(n7);
        if (this.nanos == 0) {
            string = "0";
        } else {
            string = Integer.toString(this.nanos);
            string = string3.substring(0, 9 - string.length()) + string;
            char[] cArray = new char[string.length()];
            string.getChars(0, string.length(), cArray, 0);
            int n8 = 8;
            while (cArray[n8] == '0') {
                --n8;
            }
            string = new String(cArray, 0, n8 + 1);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append("-");
        stringBuffer.append(string5);
        stringBuffer.append("-");
        stringBuffer.append(string6);
        stringBuffer.append(" ");
        stringBuffer.append(string7);
        stringBuffer.append(":");
        stringBuffer.append(string8);
        stringBuffer.append(":");
        stringBuffer.append(string9);
        stringBuffer.append(".");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public int compareTo(Timestamp timestamp) {
        int n2 = super.compareTo(timestamp);
        if (n2 == 0) {
            if (this.nanos > timestamp.nanos) {
                return 1;
            }
            if (this.nanos < timestamp.nanos) {
                return -1;
            }
        }
        return n2;
    }

    public boolean after(Timestamp timestamp) {
        if (super.after(timestamp)) {
            return true;
        }
        if (super.equals(timestamp)) {
            return this.nanos > timestamp.nanos;
        }
        return false;
    }

    public boolean before(Timestamp timestamp) {
        if (super.before(timestamp)) {
            return true;
        }
        if (super.equals(timestamp)) {
            return this.nanos < timestamp.nanos;
        }
        return false;
    }

    public boolean equals(Timestamp timestamp) {
        if (super.equals(timestamp)) {
            return this.nanos == timestamp.nanos;
        }
        return false;
    }

    public static Timestamp valueOf(String string) {
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        String string2 = "Timestamp format must be yyyy-mm-dd hh:mm:ss.fffffffff";
        String string3 = "000000000";
        if (string == null) {
            throw new IllegalArgumentException("null string");
        }
        int n9 = (string = string.trim()).indexOf(32);
        if (n9 <= 0) {
            throw new IllegalArgumentException(string2);
        }
        String string4 = string.substring(0, n9);
        String string5 = string.substring(n9 + 1);
        int n10 = string4.indexOf(45);
        int n11 = string4.indexOf(45, n10 + 1);
        if (string5 == null) {
            throw new IllegalArgumentException(string2);
        }
        n6 = string5.indexOf(58);
        n7 = string5.indexOf(58, n6 + 1);
        n8 = string5.indexOf(46, n7 + 1);
        if (!(n10 > 0 & n11 > 0 & n11 < string4.length() - 1)) {
            throw new IllegalArgumentException(string2);
        }
        int n12 = Integer.parseInt(string4.substring(0, n10)) - 1900;
        int n13 = Integer.parseInt(string4.substring(n10 + 1, n11)) - 1;
        int n14 = Integer.parseInt(string4.substring(n11 + 1));
        if (n6 > 0 & n7 > 0 & n7 < string5.length() - 1) {
            n4 = Integer.parseInt(string5.substring(0, n6));
            n3 = Integer.parseInt(string5.substring(n6 + 1, n7));
            if (n8 > 0 & n8 < string5.length() - 1) {
                n2 = Integer.parseInt(string5.substring(n7 + 1, n8));
                String string6 = string5.substring(n8 + 1);
                if (string6.length() > 9) {
                    throw new IllegalArgumentException(string2);
                }
                if (!Character.isDigit(string6.charAt(0))) {
                    throw new IllegalArgumentException(string2);
                }
                string6 = string6 + string3.substring(0, 9 - string6.length());
                n5 = Integer.parseInt(string6);
            } else {
                if (n8 > 0) {
                    throw new IllegalArgumentException(string2);
                }
                n2 = Integer.parseInt(string5.substring(n7 + 1));
            }
        } else {
            throw new IllegalArgumentException();
        }
        return new Timestamp(n12, n13, n14, n4, n3, n2, n5);
    }
}

