/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class TreeMap
extends AbstractMap
implements SortedMap,
Cloneable,
Serializable {
    private Comparator comparator = null;
    private transient Entry root = null;
    private transient int size = 0;
    private transient int modCount = 0;
    private volatile transient Set entrySet = null;
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    private static final long serialVersionUID = 919286545866124006L;

    public int size() {
        return this.size;
    }

    public TreeMap() {
    }

    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = null;
    }

    private void decrementSize() {
        ++this.modCount;
        --this.size;
    }

    private void incrementSize() {
        ++this.modCount;
        ++this.size;
    }

    private static int computeRedLevel(int n2) {
        int n3 = 0;
        int n4 = n2 - 1;
        while (n4 >= 0) {
            ++n3;
            n4 = n4 / 2 - 1;
        }
        return n3;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.buildFromSorted(n2, null, objectInputStream, null);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            objectOutputStream.writeObject(entry.key);
            objectOutputStream.writeObject(entry.value);
        }
    }

    public Object clone() {
        TreeMap treeMap = null;
        try {
            treeMap = (TreeMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        treeMap.root = null;
        treeMap.size = 0;
        treeMap.modCount = 0;
        treeMap.entrySet = null;
        try {
            treeMap.buildFromSorted(this.size, this.entrySet().iterator(), null, null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return treeMap;
    }

    public Object firstKey() {
        return TreeMap.key(this.firstEntry());
    }

    public Object lastKey() {
        return TreeMap.key(this.lastEntry());
    }

    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    public boolean containsValue(Object object) {
        return this.root == null ? false : (object == null ? this.valueSearchNull(this.root) : this.valueSearchNonNull(this.root, object));
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(this){
                private final TreeMap this$0;

                public int size() {
                    return this.this$0.size();
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object object) {
                    Entry entry = TreeMap.access$300(this.this$0);
                    while (entry != null) {
                        if (TreeMap.access$500(entry.getValue(), object)) {
                            return true;
                        }
                        entry = TreeMap.access$400(this.this$0, entry);
                    }
                    return false;
                }

                public boolean remove(Object object) {
                    Entry entry = TreeMap.access$300(this.this$0);
                    while (entry != null) {
                        if (TreeMap.access$500(entry.getValue(), object)) {
                            TreeMap.access$600(this.this$0, entry);
                            return true;
                        }
                        entry = TreeMap.access$400(this.this$0, entry);
                    }
                    return false;
                }

                public Iterator iterator() {
                    return new ValueIterator(this.this$0, null);
                }
                {
                    this.this$0 = treeMap;
                }
            };
        }
        return this.values;
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public TreeMap(Comparator comparator) {
        this.comparator = comparator;
    }

    public TreeMap(Map map) {
        this.putAll(map);
    }

    public void putAll(Map map) {
        Comparator comparator;
        int n2 = map.size();
        if (this.size == 0 && n2 != 0 && map instanceof SortedMap && ((comparator = ((SortedMap)map).comparator()) == this.comparator || comparator != null && ((Object)comparator).equals(this.comparator))) {
            ++this.modCount;
            try {
                this.buildFromSorted(n2, map.entrySet().iterator(), null, null);
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return;
        }
        super.putAll(map);
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(this){
                private final TreeMap this$0;

                public int size() {
                    return this.this$0.size();
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object object2 = entry.getValue();
                    Entry entry2 = TreeMap.access$700(this.this$0, entry.getKey());
                    return entry2 != null && TreeMap.access$500(entry2.getValue(), object2);
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object object2 = entry.getValue();
                    Entry entry2 = TreeMap.access$700(this.this$0, entry.getKey());
                    if (entry2 != null && TreeMap.access$500(entry2.getValue(), object2)) {
                        TreeMap.access$600(this.this$0, entry2);
                        return true;
                    }
                    return false;
                }

                public Iterator iterator() {
                    return new EntryIterator(this.this$0);
                }
                {
                    this.this$0 = treeMap;
                }
            };
        }
        return this.entrySet;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(this){
                private final TreeMap this$0;

                public int size() {
                    return this.this$0.size();
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object object) {
                    return this.this$0.containsKey(object);
                }

                public boolean remove(Object object) {
                    int n2 = TreeMap.access$100(this.this$0);
                    this.this$0.remove(object);
                    return TreeMap.access$100(this.this$0) != n2;
                }

                public Iterator iterator() {
                    return new KeyIterator(this.this$0, null);
                }
                {
                    this.this$0 = treeMap;
                }
            };
        }
        return this.keySet;
    }

    public TreeMap(SortedMap sortedMap) {
        this.comparator = sortedMap.comparator();
        try {
            this.buildFromSorted(sortedMap.size(), sortedMap.entrySet().iterator(), null, null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    static int access$100(TreeMap treeMap) {
        return treeMap.size;
    }

    static int access$1600(TreeMap treeMap) {
        return treeMap.modCount;
    }

    private Entry firstEntry() {
        Entry entry = this.root;
        if (entry != null) {
            while (entry.left != null) {
                entry = entry.left;
            }
        }
        return entry;
    }

    private Entry lastEntry() {
        Entry entry = this.root;
        if (entry != null) {
            while (entry.right != null) {
                entry = entry.right;
            }
        }
        return entry;
    }

    private void deleteEntry(Entry entry) {
        Entry entry2;
        this.decrementSize();
        if (entry.left != null && entry.right != null) {
            entry2 = this.successor(entry);
            entry.key = entry2.key;
            entry.value = entry2.value;
            entry = entry2;
        }
        Entry entry3 = entry2 = entry.left != null ? entry.left : entry.right;
        if (entry2 != null) {
            entry2.parent = entry.parent;
            if (entry.parent == null) {
                this.root = entry2;
            } else if (entry == entry.parent.left) {
                entry.parent.left = entry2;
            } else {
                entry.parent.right = entry2;
            }
            entry.parent = null;
            entry.right = null;
            entry.left = null;
            if (entry.color) {
                this.fixAfterDeletion(entry2);
            }
        } else if (entry.parent == null) {
            this.root = null;
        } else {
            if (entry.color) {
                this.fixAfterDeletion(entry);
            }
            if (entry.parent != null) {
                if (entry == entry.parent.left) {
                    entry.parent.left = null;
                } else if (entry == entry.parent.right) {
                    entry.parent.right = null;
                }
                entry.parent = null;
            }
        }
    }

    private void fixAfterDeletion(Entry entry) {
        while (entry != this.root && TreeMap.colorOf(entry)) {
            Entry entry2;
            if (entry == TreeMap.leftOf(TreeMap.parentOf(entry))) {
                entry2 = TreeMap.rightOf(TreeMap.parentOf(entry));
                if (!TreeMap.colorOf(entry2)) {
                    TreeMap.setColor(entry2, true);
                    TreeMap.setColor(TreeMap.parentOf(entry), false);
                    this.rotateLeft(TreeMap.parentOf(entry));
                    entry2 = TreeMap.rightOf(TreeMap.parentOf(entry));
                }
                if (TreeMap.colorOf(TreeMap.leftOf(entry2)) && TreeMap.colorOf(TreeMap.rightOf(entry2))) {
                    TreeMap.setColor(entry2, false);
                    entry = TreeMap.parentOf(entry);
                    continue;
                }
                if (TreeMap.colorOf(TreeMap.rightOf(entry2))) {
                    TreeMap.setColor(TreeMap.leftOf(entry2), true);
                    TreeMap.setColor(entry2, false);
                    this.rotateRight(entry2);
                    entry2 = TreeMap.rightOf(TreeMap.parentOf(entry));
                }
                TreeMap.setColor(entry2, TreeMap.colorOf(TreeMap.parentOf(entry)));
                TreeMap.setColor(TreeMap.parentOf(entry), true);
                TreeMap.setColor(TreeMap.rightOf(entry2), true);
                this.rotateLeft(TreeMap.parentOf(entry));
                entry = this.root;
                continue;
            }
            entry2 = TreeMap.leftOf(TreeMap.parentOf(entry));
            if (!TreeMap.colorOf(entry2)) {
                TreeMap.setColor(entry2, true);
                TreeMap.setColor(TreeMap.parentOf(entry), false);
                this.rotateRight(TreeMap.parentOf(entry));
                entry2 = TreeMap.leftOf(TreeMap.parentOf(entry));
            }
            if (TreeMap.colorOf(TreeMap.rightOf(entry2)) && TreeMap.colorOf(TreeMap.leftOf(entry2))) {
                TreeMap.setColor(entry2, false);
                entry = TreeMap.parentOf(entry);
                continue;
            }
            if (TreeMap.colorOf(TreeMap.leftOf(entry2))) {
                TreeMap.setColor(TreeMap.rightOf(entry2), true);
                TreeMap.setColor(entry2, false);
                this.rotateLeft(entry2);
                entry2 = TreeMap.leftOf(TreeMap.parentOf(entry));
            }
            TreeMap.setColor(entry2, TreeMap.colorOf(TreeMap.parentOf(entry)));
            TreeMap.setColor(TreeMap.parentOf(entry), true);
            TreeMap.setColor(TreeMap.leftOf(entry2), true);
            this.rotateRight(TreeMap.parentOf(entry));
            entry = this.root;
        }
        TreeMap.setColor(entry, true);
    }

    private void fixAfterInsertion(Entry entry) {
        entry.color = false;
        while (entry != null && entry != this.root && !entry.parent.color) {
            Entry entry2;
            if (TreeMap.parentOf(entry) == TreeMap.leftOf(TreeMap.parentOf(TreeMap.parentOf(entry)))) {
                entry2 = TreeMap.rightOf(TreeMap.parentOf(TreeMap.parentOf(entry)));
                if (!TreeMap.colorOf(entry2)) {
                    TreeMap.setColor(TreeMap.parentOf(entry), true);
                    TreeMap.setColor(entry2, true);
                    TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
                    entry = TreeMap.parentOf(TreeMap.parentOf(entry));
                    continue;
                }
                if (entry == TreeMap.rightOf(TreeMap.parentOf(entry))) {
                    entry = TreeMap.parentOf(entry);
                    this.rotateLeft(entry);
                }
                TreeMap.setColor(TreeMap.parentOf(entry), true);
                TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
                if (TreeMap.parentOf(TreeMap.parentOf(entry)) == null) continue;
                this.rotateRight(TreeMap.parentOf(TreeMap.parentOf(entry)));
                continue;
            }
            entry2 = TreeMap.leftOf(TreeMap.parentOf(TreeMap.parentOf(entry)));
            if (!TreeMap.colorOf(entry2)) {
                TreeMap.setColor(TreeMap.parentOf(entry), true);
                TreeMap.setColor(entry2, true);
                TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
                entry = TreeMap.parentOf(TreeMap.parentOf(entry));
                continue;
            }
            if (entry == TreeMap.leftOf(TreeMap.parentOf(entry))) {
                entry = TreeMap.parentOf(entry);
                this.rotateRight(entry);
            }
            TreeMap.setColor(TreeMap.parentOf(entry), true);
            TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
            if (TreeMap.parentOf(TreeMap.parentOf(entry)) == null) continue;
            this.rotateLeft(TreeMap.parentOf(TreeMap.parentOf(entry)));
        }
        this.root.color = true;
    }

    private void rotateLeft(Entry entry) {
        Entry entry2 = entry.right;
        entry.right = entry2.left;
        if (entry2.left != null) {
            entry2.left.parent = entry;
        }
        entry2.parent = entry.parent;
        if (entry.parent == null) {
            this.root = entry2;
        } else if (entry.parent.left == entry) {
            entry.parent.left = entry2;
        } else {
            entry.parent.right = entry2;
        }
        entry2.left = entry;
        entry.parent = entry2;
    }

    private void rotateRight(Entry entry) {
        Entry entry2 = entry.left;
        entry.left = entry2.right;
        if (entry2.right != null) {
            entry2.right.parent = entry;
        }
        entry2.parent = entry.parent;
        if (entry.parent == null) {
            this.root = entry2;
        } else if (entry.parent.right == entry) {
            entry.parent.right = entry2;
        } else {
            entry.parent.left = entry2;
        }
        entry2.right = entry;
        entry.parent = entry2;
    }

    private static boolean colorOf(Entry entry) {
        return entry == null ? true : entry.color;
    }

    private boolean valueSearchNull(Entry entry) {
        if (entry.value == null) {
            return true;
        }
        return entry.left != null && this.valueSearchNull(entry.left) || entry.right != null && this.valueSearchNull(entry.right);
    }

    private static void setColor(Entry entry, boolean bl2) {
        if (entry != null) {
            entry.color = bl2;
        }
    }

    void readTreeSet(int n2, ObjectInputStream objectInputStream, Object object) throws IOException, ClassNotFoundException {
        this.buildFromSorted(n2, null, objectInputStream, object);
    }

    public Object get(Object object) {
        Entry entry = this.getEntry(object);
        return entry == null ? null : entry.value;
    }

    public Object remove(Object object) {
        Entry entry = this.getEntry(object);
        if (entry == null) {
            return null;
        }
        Object object2 = entry.value;
        this.deleteEntry(entry);
        return object2;
    }

    private int compare(Object object, Object object2) {
        return this.comparator == null ? ((Comparable)object).compareTo(object2) : this.comparator.compare(object, object2);
    }

    static boolean access$500(Object object, Object object2) {
        return TreeMap.valEquals(object, object2);
    }

    private static boolean valEquals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    void addAllForTreeSet(SortedSet sortedSet, Object object) {
        try {
            this.buildFromSorted(sortedSet.size(), sortedSet.iterator(), null, object);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    static Object access$1100(Entry entry) {
        return TreeMap.key(entry);
    }

    private static Object key(Entry entry) {
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.key;
    }

    private boolean valueSearchNonNull(Entry entry, Object object) {
        if (object.equals(entry.value)) {
            return true;
        }
        return entry.left != null && this.valueSearchNonNull(entry.left, object) || entry.right != null && this.valueSearchNonNull(entry.right, object);
    }

    static Comparator access$900(TreeMap treeMap) {
        return treeMap.comparator;
    }

    public SortedMap headMap(Object object) {
        return new SubMap(this, object, true);
    }

    public SortedMap tailMap(Object object) {
        return new SubMap(this, object, false);
    }

    private Entry getCeilEntry(Object object) {
        Entry entry = this.root;
        if (entry == null) {
            return null;
        }
        while (true) {
            int n2;
            if ((n2 = this.compare(object, entry.key)) == 0) {
                return entry;
            }
            if (n2 < 0) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                return entry;
            }
            if (entry.right == null) break;
            entry = entry.right;
        }
        Entry entry2 = entry.parent;
        Entry entry3 = entry;
        while (entry2 != null && entry3 == entry2.right) {
            entry3 = entry2;
            entry2 = entry2.parent;
        }
        return entry2;
    }

    private Entry getEntry(Object object) {
        Entry entry = this.root;
        while (entry != null) {
            int n2 = this.compare(object, entry.key);
            if (n2 == 0) {
                return entry;
            }
            if (n2 < 0) {
                entry = entry.left;
                continue;
            }
            entry = entry.right;
        }
        return null;
    }

    private Entry getPrecedingEntry(Object object) {
        Entry entry = this.root;
        if (entry == null) {
            return null;
        }
        while (true) {
            int n2;
            if ((n2 = this.compare(object, entry.key)) > 0) {
                if (entry.right != null) {
                    entry = entry.right;
                    continue;
                }
                return entry;
            }
            if (entry.left == null) break;
            entry = entry.left;
        }
        Entry entry2 = entry.parent;
        Entry entry3 = entry;
        while (entry2 != null && entry3 == entry2.left) {
            entry3 = entry2;
            entry2 = entry2.parent;
        }
        return entry2;
    }

    static Entry access$1200(TreeMap treeMap) {
        return treeMap.lastEntry();
    }

    static Entry access$300(TreeMap treeMap) {
        return treeMap.firstEntry();
    }

    static void access$600(TreeMap treeMap, Entry entry) {
        treeMap.deleteEntry(entry);
    }

    private static Entry leftOf(Entry entry) {
        return entry == null ? null : entry.left;
    }

    private static Entry parentOf(Entry entry) {
        return entry == null ? null : entry.parent;
    }

    private static Entry rightOf(Entry entry) {
        return entry == null ? null : entry.right;
    }

    private Entry successor(Entry entry) {
        if (entry == null) {
            return null;
        }
        if (entry.right != null) {
            Entry entry2 = entry.right;
            while (entry2.left != null) {
                entry2 = entry2.left;
            }
            return entry2;
        }
        Entry entry3 = entry.parent;
        Entry entry4 = entry;
        while (entry3 != null && entry4 == entry3.right) {
            entry4 = entry3;
            entry3 = entry3.parent;
        }
        return entry3;
    }

    private void buildFromSorted(int n2, Iterator iterator, ObjectInputStream objectInputStream, Object object) throws IOException, ClassNotFoundException {
        this.size = n2;
        this.root = TreeMap.buildFromSorted(0, 0, n2 - 1, TreeMap.computeRedLevel(n2), iterator, objectInputStream, object);
    }

    public Object put(Object object, Object object2) {
        Entry entry = this.root;
        if (entry == null) {
            this.incrementSize();
            this.root = new Entry(object, object2, null);
            return null;
        }
        while (true) {
            int n2;
            if ((n2 = this.compare(object, entry.key)) == 0) {
                return entry.setValue(object2);
            }
            if (n2 < 0) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                this.incrementSize();
                entry.left = new Entry(object, object2, entry);
                this.fixAfterInsertion(entry.left);
                return null;
            }
            if (entry.right == null) break;
            entry = entry.right;
        }
        this.incrementSize();
        entry.right = new Entry(object, object2, entry);
        this.fixAfterInsertion(entry.right);
        return null;
    }

    static int access$800(TreeMap treeMap, Object object, Object object2) {
        return treeMap.compare(object, object2);
    }

    public SortedMap subMap(Object object, Object object2) {
        return new SubMap(this, object, object2);
    }

    static Entry access$1000(TreeMap treeMap, Object object) {
        return treeMap.getCeilEntry(object);
    }

    static Entry access$1300(TreeMap treeMap, Object object) {
        return treeMap.getPrecedingEntry(object);
    }

    static Entry access$700(TreeMap treeMap, Object object) {
        return treeMap.getEntry(object);
    }

    static Entry access$400(TreeMap treeMap, Entry entry) {
        return treeMap.successor(entry);
    }

    private static Entry buildFromSorted(int n2, int n3, int n4, int n5, Iterator iterator, ObjectInputStream objectInputStream, Object object) throws IOException, ClassNotFoundException {
        Object object2;
        Object object3;
        Map.Entry entry;
        if (n4 < n3) {
            return null;
        }
        int n6 = (n3 + n4) / 2;
        Entry entry2 = null;
        if (n3 < n6) {
            entry2 = TreeMap.buildFromSorted(n2 + 1, n3, n6 - 1, n5, iterator, objectInputStream, object);
        }
        if (iterator != null) {
            if (object == null) {
                entry = (Map.Entry)iterator.next();
                object3 = entry.getKey();
                object2 = entry.getValue();
            } else {
                object3 = iterator.next();
                object2 = object;
            }
        } else {
            object3 = objectInputStream.readObject();
            object2 = object != null ? object : objectInputStream.readObject();
        }
        entry = new Entry(object3, object2, null);
        if (n2 == n5) {
            ((Entry)entry).color = false;
        }
        if (entry2 != null) {
            ((Entry)entry).left = entry2;
            entry2.parent = entry;
        }
        if (n6 < n4) {
            Entry entry3;
            ((Entry)entry).right = entry3 = TreeMap.buildFromSorted(n2 + 1, n6 + 1, n4, n5, iterator, objectInputStream, object);
            entry3.parent = entry;
        }
        return entry;
    }

    static class Entry
    implements Map.Entry {
        Object key;
        Object value;
        Entry left = null;
        Entry right = null;
        Entry parent;
        boolean color = true;

        public int hashCode() {
            int n2 = this.key == null ? 0 : this.key.hashCode();
            int n3 = this.value == null ? 0 : this.value.hashCode();
            return n2 ^ n3;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return TreeMap.access$500(this.key, entry.getKey()) && TreeMap.access$500(this.value, entry.getValue());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        Entry(Object object, Object object2, Entry entry) {
            this.key = object;
            this.value = object2;
            this.parent = entry;
        }
    }

    private class EntryIterator
    implements Iterator {
        private int expectedModCount;
        private Entry lastReturned;
        Entry next;
        private final TreeMap this$0;

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (TreeMap.access$1600(this.this$0) != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastReturned.left != null && this.lastReturned.right != null) {
                this.next = this.lastReturned;
            }
            TreeMap.access$600(this.this$0, this.lastReturned);
            ++this.expectedModCount;
            this.lastReturned = null;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            return this.nextEntry();
        }

        EntryIterator(TreeMap treeMap) {
            this.this$0 = treeMap;
            this.expectedModCount = TreeMap.access$1600(this.this$0);
            this.lastReturned = null;
            this.next = TreeMap.access$300(treeMap);
        }

        final Entry nextEntry() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            if (TreeMap.access$1600(this.this$0) != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.lastReturned = this.next;
            this.next = TreeMap.access$400(this.this$0, this.next);
            return this.lastReturned;
        }

        EntryIterator(TreeMap treeMap, Entry entry) {
            this.this$0 = treeMap;
            this.expectedModCount = TreeMap.access$1600(this.this$0);
            this.lastReturned = null;
            this.next = entry;
        }
    }

    private class KeyIterator
    extends EntryIterator {
        private final TreeMap this$0;

        public Object next() {
            return this.nextEntry().key;
        }

        private KeyIterator(TreeMap treeMap) {
            this.this$0 = treeMap;
            super(treeMap);
        }

        KeyIterator(TreeMap treeMap, 1 var2_2) {
            this(treeMap);
        }
    }

    private class SubMap
    extends AbstractMap
    implements SortedMap,
    Serializable {
        private static final long serialVersionUID = -6520786458950516097L;
        private boolean fromStart;
        private boolean toEnd;
        private Object fromKey;
        private Object toKey;
        private transient Set entrySet;
        private final TreeMap this$0;

        public boolean isEmpty() {
            return this.entrySet.isEmpty();
        }

        public Object firstKey() {
            Object object = TreeMap.access$1100(this.fromStart ? TreeMap.access$300(this.this$0) : TreeMap.access$1000(this.this$0, this.fromKey));
            if (!this.toEnd && TreeMap.access$800(this.this$0, object, this.toKey) >= 0) {
                throw new NoSuchElementException();
            }
            return object;
        }

        public Object lastKey() {
            Object object = TreeMap.access$1100(this.toEnd ? TreeMap.access$1200(this.this$0) : TreeMap.access$1300(this.this$0, this.toKey));
            if (!this.fromStart && TreeMap.access$800(this.this$0, object, this.fromKey) < 0) {
                throw new NoSuchElementException();
            }
            return object;
        }

        public boolean containsKey(Object object) {
            return this.inRange(object) && this.this$0.containsKey(object);
        }

        private boolean inRange(Object object) {
            return !(!this.fromStart && TreeMap.access$800(this.this$0, object, this.fromKey) < 0 || !this.toEnd && TreeMap.access$800(this.this$0, object, this.toKey) >= 0);
        }

        private boolean inRange2(Object object) {
            return !(!this.fromStart && TreeMap.access$800(this.this$0, object, this.fromKey) < 0 || !this.toEnd && TreeMap.access$800(this.this$0, object, this.toKey) > 0);
        }

        public Comparator comparator() {
            return TreeMap.access$900(this.this$0);
        }

        public Set entrySet() {
            return this.entrySet;
        }

        static boolean access$1800(SubMap subMap) {
            return subMap.fromStart;
        }

        static boolean access$2000(SubMap subMap) {
            return subMap.toEnd;
        }

        public Object get(Object object) {
            if (!this.inRange(object)) {
                return null;
            }
            return this.this$0.get(object);
        }

        SubMap(TreeMap treeMap, Object object, boolean bl2) {
            this.this$0 = treeMap;
            this.fromStart = false;
            this.toEnd = false;
            this.entrySet = new EntrySetView(this, null);
            TreeMap.access$800(treeMap, object, object);
            if (bl2) {
                this.fromStart = true;
                this.toKey = object;
            } else {
                this.toEnd = true;
                this.fromKey = object;
            }
        }

        static Object access$1900(SubMap subMap) {
            return subMap.fromKey;
        }

        static Object access$2100(SubMap subMap) {
            return subMap.toKey;
        }

        static boolean access$1700(SubMap subMap, Object object) {
            return subMap.inRange(object);
        }

        public SortedMap headMap(Object object) {
            if (!this.inRange2(object)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(this.this$0, this.fromStart, this.fromKey, false, object);
        }

        public SortedMap tailMap(Object object) {
            if (!this.inRange2(object)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new SubMap(this.this$0, false, object, this.toEnd, this.toKey);
        }

        static TreeMap access$1500(SubMap subMap) {
            return subMap.this$0;
        }

        public Object put(Object object, Object object2) {
            if (!this.inRange(object)) {
                throw new IllegalArgumentException("key out of range");
            }
            return this.this$0.put(object, object2);
        }

        SubMap(TreeMap treeMap, Object object, Object object2) {
            this.this$0 = treeMap;
            this.fromStart = false;
            this.toEnd = false;
            this.entrySet = new EntrySetView(this, null);
            if (TreeMap.access$800(treeMap, object, object2) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.fromKey = object;
            this.toKey = object2;
        }

        SubMap(TreeMap treeMap, boolean bl2, Object object, boolean bl3, Object object2) {
            this.this$0 = treeMap;
            this.fromStart = false;
            this.toEnd = false;
            this.entrySet = new EntrySetView(this, null);
            this.fromStart = bl2;
            this.fromKey = object;
            this.toEnd = bl3;
            this.toKey = object2;
        }

        public SortedMap subMap(Object object, Object object2) {
            if (!this.inRange2(object)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange2(object2)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(this.this$0, object, object2);
        }

        private class EntrySetView
        extends AbstractSet {
            private transient int size;
            private transient int sizeModCount;
            private final SubMap this$1;

            public int size() {
                if (this.size == -1 || this.sizeModCount != TreeMap.access$1600(SubMap.access$1500(this.this$1))) {
                    this.size = 0;
                    this.sizeModCount = TreeMap.access$1600(SubMap.access$1500(this.this$1));
                    Iterator iterator = this.iterator();
                    while (iterator.hasNext()) {
                        ++this.size;
                        iterator.next();
                    }
                }
                return this.size;
            }

            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }

            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object object2 = entry.getKey();
                if (!SubMap.access$1700(this.this$1, object2)) {
                    return false;
                }
                Entry entry2 = TreeMap.access$700(SubMap.access$1500(this.this$1), object2);
                return entry2 != null && TreeMap.access$500(entry2.getValue(), entry.getValue());
            }

            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object object2 = entry.getKey();
                if (!SubMap.access$1700(this.this$1, object2)) {
                    return false;
                }
                Entry entry2 = TreeMap.access$700(SubMap.access$1500(this.this$1), object2);
                if (entry2 != null && TreeMap.access$500(entry2.getValue(), entry.getValue())) {
                    TreeMap.access$600(SubMap.access$1500(this.this$1), entry2);
                    return true;
                }
                return false;
            }

            public Iterator iterator() {
                return new SubMapEntryIterator(SubMap.access$1500(this.this$1), SubMap.access$1800(this.this$1) ? TreeMap.access$300(SubMap.access$1500(this.this$1)) : TreeMap.access$1000(SubMap.access$1500(this.this$1), SubMap.access$1900(this.this$1)), SubMap.access$2000(this.this$1) ? null : TreeMap.access$1000(SubMap.access$1500(this.this$1), SubMap.access$2100(this.this$1)));
            }

            private EntrySetView(SubMap subMap) {
                this.this$1 = subMap;
                this.size = -1;
            }

            EntrySetView(SubMap subMap, 1 var2_2) {
                this(subMap);
            }
        }
    }

    private class SubMapEntryIterator
    extends EntryIterator {
        private final Object firstExcludedKey;
        private final TreeMap this$0;

        public boolean hasNext() {
            return this.next != null && this.next.key != this.firstExcludedKey;
        }

        public Object next() {
            if (this.next == null || this.next.key == this.firstExcludedKey) {
                throw new NoSuchElementException();
            }
            return this.nextEntry();
        }

        SubMapEntryIterator(TreeMap treeMap, Entry entry, Entry entry2) {
            this.this$0 = treeMap;
            super(treeMap, entry);
            this.firstExcludedKey = entry2 == null ? entry2 : entry2.key;
        }
    }

    private class ValueIterator
    extends EntryIterator {
        private final TreeMap this$0;

        public Object next() {
            return this.nextEntry().value;
        }

        private ValueIterator(TreeMap treeMap) {
            this.this$0 = treeMap;
            super(treeMap);
        }

        ValueIterator(TreeMap treeMap, 1 var2_2) {
            this(treeMap);
        }
    }
}

