/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import java.io.ByteArrayOutputStream;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Base64;
import java.util.prefs.Preferences;

class WindowsPreferences
extends AbstractPreferences {
    private static Logger logger;
    private static final byte[] WINDOWS_ROOT_PATH;
    private static final int HKEY_CURRENT_USER = -2147483647;
    private static final int HKEY_LOCAL_MACHINE = -2147483646;
    private static final int USER_ROOT_NATIVE_HANDLE = -2147483647;
    private static final int SYSTEM_ROOT_NATIVE_HANDLE = -2147483646;
    private static final int MAX_WINDOWS_PATH_LENGTH = 256;
    static final Preferences userRoot;
    static final Preferences systemRoot;
    private static final int ERROR_SUCCESS = 0;
    private static final int ERROR_FILE_NOT_FOUND = 2;
    private static final int ERROR_ACCESS_DENIED = 5;
    private static final int NATIVE_HANDLE = 0;
    private static final int ERROR_CODE = 1;
    private static final int SUBKEYS_NUMBER = 0;
    private static final int VALUES_NUMBER = 2;
    private static final int MAX_KEY_LENGTH = 3;
    private static final int MAX_VALUE_NAME_LENGTH = 4;
    private static final int DISPOSITION = 2;
    private static final int REG_CREATED_NEW_KEY = 1;
    private static final int REG_OPENED_EXISTING_KEY = 2;
    private static final int NULL_NATIVE_HANDLE = 0;
    private static final int DELETE = 65536;
    private static final int KEY_QUERY_VALUE = 1;
    private static final int KEY_SET_VALUE = 2;
    private static final int KEY_CREATE_SUB_KEY = 4;
    private static final int KEY_ENUMERATE_SUB_KEYS = 8;
    private static final int KEY_READ = 131097;
    private static final int KEY_WRITE = 131078;
    private static final int KEY_ALL_ACCESS = 983103;
    private static int INIT_SLEEP_TIME;
    private static int MAX_ATTEMPTS;
    private boolean isBackingStoreAvailable = true;

    private int rootNativeHandle() {
        return this.isUserNode() ? -2147483647 : -2147483646;
    }

    static {
        WINDOWS_ROOT_PATH = WindowsPreferences.stringToByteArray("Software\\JavaSoft\\Prefs");
        userRoot = new WindowsPreferences(-2147483647, WINDOWS_ROOT_PATH);
        systemRoot = new WindowsPreferences(-2147483646, WINDOWS_ROOT_PATH);
        INIT_SLEEP_TIME = 50;
        MAX_ATTEMPTS = 5;
    }

    public void flush() throws BackingStoreException {
        if (this.isRemoved()) {
            this.parent.flush();
            return;
        }
        if (!this.isBackingStoreAvailable) {
            throw new BackingStoreException("flush(): Backing store not available.");
        }
        int n2 = this.openKey(131097);
        if (n2 == 0) {
            throw new BackingStoreException("Could not open windowsregistry node " + WindowsPreferences.byteArrayToString(this.windowsAbsolutePath()) + " at root 0x" + Integer.toHexString(this.rootNativeHandle()) + ".");
        }
        int n3 = WindowsPreferences.WindowsRegFlushKey1(n2);
        if (n3 != 0) {
            String string = "Could not flush windows registry node " + WindowsPreferences.byteArrayToString(this.windowsAbsolutePath()) + " at root 0x" + Integer.toHexString(this.rootNativeHandle()) + ". Windows RegFlushKey(...) returned error code " + n3 + ".";
            WindowsPreferences.logger().warning(string);
            throw new BackingStoreException(string);
        }
        this.closeKey(n2);
    }

    protected void flushSpi() throws BackingStoreException {
    }

    public void removeNodeSpi() throws BackingStoreException {
        int n2 = ((WindowsPreferences)this.parent()).openKey(65536);
        if (n2 == 0) {
            throw new BackingStoreException("Could not open parent windowsregistry node of " + WindowsPreferences.byteArrayToString(this.windowsAbsolutePath()) + " at root 0x" + Integer.toHexString(this.rootNativeHandle()) + ".");
        }
        int n3 = WindowsPreferences.WindowsRegDeleteKey(n2, WindowsPreferences.toWindowsName(this.name()));
        if (n3 != 0) {
            String string = "Could not delete windows registry node " + WindowsPreferences.byteArrayToString(this.windowsAbsolutePath()) + " at root 0x" + Integer.toHexString(this.rootNativeHandle()) + ". Windows RegDeleteKeyEx(...) returned error code " + n3 + ".";
            WindowsPreferences.logger().warning(string);
            throw new BackingStoreException(string);
        }
        this.closeKey(n2);
    }

    public void sync() throws BackingStoreException {
        if (this.isRemoved()) {
            throw new IllegalStateException("Node has been removed");
        }
        this.flush();
    }

    protected void syncSpi() throws BackingStoreException {
    }

    private byte[] windowsAbsolutePath() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(WINDOWS_ROOT_PATH, 0, WINDOWS_ROOT_PATH.length - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(this.absolutePath(), "/");
        while (stringTokenizer.hasMoreTokens()) {
            byteArrayOutputStream.write(92);
            String string = stringTokenizer.nextToken();
            byte[] byArray = WindowsPreferences.toWindowsName(string);
            byteArrayOutputStream.write(byArray, 0, byArray.length - 1);
        }
        byteArrayOutputStream.write(0);
        return byteArrayOutputStream.toByteArray();
    }

    private static native int WindowsRegCloseKey(int var0);

    private static native int WindowsRegFlushKey(int var0);

    private static int WindowsRegFlushKey1(int n2) {
        int n3 = WindowsPreferences.WindowsRegFlushKey(n2);
        if (n3 == 0) {
            return n3;
        }
        long l2 = INIT_SLEEP_TIME;
        for (int i2 = 0; i2 < MAX_ATTEMPTS; ++i2) {
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                return n3;
            }
            l2 *= 2L;
            n3 = WindowsPreferences.WindowsRegFlushKey(n2);
            if (n3 != 0) continue;
            return n3;
        }
        return n3;
    }

    private int openKey(int n2) {
        return this.openKey(n2, n2);
    }

    private void closeKey(int n2) {
        int n3 = WindowsPreferences.WindowsRegCloseKey(n2);
        if (n3 != 0) {
            WindowsPreferences.logger().warning("Could not close windows registry node " + WindowsPreferences.byteArrayToString(this.windowsAbsolutePath()) + " at root 0x" + Integer.toHexString(this.rootNativeHandle()) + ". Windows RegCloseKey(...) returned error code " + n3 + ".");
        }
    }

    private static native int[] WindowsRegQueryInfoKey(int var0);

    private static int[] WindowsRegQueryInfoKey1(int n2) {
        int[] nArray = WindowsPreferences.WindowsRegQueryInfoKey(n2);
        if (nArray[1] == 0) {
            return nArray;
        }
        long l2 = INIT_SLEEP_TIME;
        for (int i2 = 0; i2 < MAX_ATTEMPTS; ++i2) {
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                return nArray;
            }
            l2 *= 2L;
            nArray = WindowsPreferences.WindowsRegQueryInfoKey(n2);
            if (nArray[1] != 0) continue;
            return nArray;
        }
        return nArray;
    }

    private int openKey(int n2, int n3) {
        return this.openKey(this.windowsAbsolutePath(), n2, n3);
    }

    private static native byte[] WindowsRegEnumKeyEx(int var0, int var1, int var2);

    private static byte[] WindowsRegEnumKeyEx1(int n2, int n3, int n4) {
        byte[] byArray = WindowsPreferences.WindowsRegEnumKeyEx(n2, n3, n4);
        if (byArray != null) {
            return byArray;
        }
        long l2 = INIT_SLEEP_TIME;
        for (int i2 = 0; i2 < MAX_ATTEMPTS; ++i2) {
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                return byArray;
            }
            l2 *= 2L;
            byArray = WindowsPreferences.WindowsRegEnumKeyEx(n2, n3, n4);
            if (byArray == null) continue;
            return byArray;
        }
        return byArray;
    }

    private static native byte[] WindowsRegEnumValue(int var0, int var1, int var2);

    private static byte[] WindowsRegEnumValue1(int n2, int n3, int n4) {
        byte[] byArray = WindowsPreferences.WindowsRegEnumValue(n2, n3, n4);
        if (byArray != null) {
            return byArray;
        }
        long l2 = INIT_SLEEP_TIME;
        for (int i2 = 0; i2 < MAX_ATTEMPTS; ++i2) {
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                return byArray;
            }
            l2 *= 2L;
            byArray = WindowsPreferences.WindowsRegEnumValue(n2, n3, n4);
            if (byArray == null) continue;
            return byArray;
        }
        return byArray;
    }

    private static native int WindowsRegDeleteKey(int var0, byte[] var1);

    private static native int WindowsRegDeleteValue(int var0, byte[] var1);

    private WindowsPreferences(int n2, byte[] byArray) {
        super(null, "");
        int[] nArray = WindowsPreferences.WindowsRegCreateKeyEx1(n2, byArray);
        if (nArray[1] != 0) {
            WindowsPreferences.logger().warning("Could not open/create prefs root node " + WindowsPreferences.byteArrayToString(this.windowsAbsolutePath()) + " at root 0x" + Integer.toHexString(this.rootNativeHandle()) + ". Windows RegCreateKeyEx(...) returned error code " + nArray[1] + ".");
            this.isBackingStoreAvailable = false;
            return;
        }
        this.newNode = nArray[2] == 1;
        this.closeKey(nArray[0]);
    }

    private static native byte[] WindowsRegQueryValueEx(int var0, byte[] var1);

    private static native int[] WindowsRegCreateKeyEx(int var0, byte[] var1);

    private static int[] WindowsRegCreateKeyEx1(int n2, byte[] byArray) {
        int[] nArray = WindowsPreferences.WindowsRegCreateKeyEx(n2, byArray);
        if (nArray[1] == 0) {
            return nArray;
        }
        long l2 = INIT_SLEEP_TIME;
        for (int i2 = 0; i2 < MAX_ATTEMPTS; ++i2) {
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                return nArray;
            }
            l2 *= 2L;
            nArray = WindowsPreferences.WindowsRegCreateKeyEx(n2, byArray);
            if (nArray[1] != 0) continue;
            return nArray;
        }
        return nArray;
    }

    private static native int[] WindowsRegOpenKey(int var0, byte[] var1, int var2);

    private static int[] WindowsRegOpenKey1(int n2, byte[] byArray, int n3) {
        int[] nArray = WindowsPreferences.WindowsRegOpenKey(n2, byArray, n3);
        if (nArray[1] == 0) {
            return nArray;
        }
        if (nArray[1] == 2) {
            WindowsPreferences.logger().warning("Trying to recreate Windows registry node " + WindowsPreferences.byteArrayToString(byArray) + " at root 0x" + Integer.toHexString(n2) + ".");
            int n4 = WindowsPreferences.WindowsRegCreateKeyEx(n2, byArray)[0];
            WindowsPreferences.WindowsRegCloseKey(n4);
            return WindowsPreferences.WindowsRegOpenKey(n2, byArray, n3);
        }
        if (nArray[1] != 5) {
            long l2 = INIT_SLEEP_TIME;
            for (int i2 = 0; i2 < MAX_ATTEMPTS; ++i2) {
                try {
                    Thread.sleep(l2);
                }
                catch (InterruptedException interruptedException) {
                    return nArray;
                }
                l2 *= 2L;
                nArray = WindowsPreferences.WindowsRegOpenKey(n2, byArray, n3);
                if (nArray[1] != 0) continue;
                return nArray;
            }
        }
        return nArray;
    }

    private int openKey(int n2, byte[] byArray, int n3, int n4) {
        if (byArray.length <= 257) {
            int[] nArray = WindowsPreferences.WindowsRegOpenKey1(n2, byArray, n3);
            if (nArray[1] == 5 && n4 != n3) {
                nArray = WindowsPreferences.WindowsRegOpenKey1(n2, byArray, n4);
            }
            if (nArray[1] != 0) {
                WindowsPreferences.logger().warning("Could not open windows registry node " + WindowsPreferences.byteArrayToString(this.windowsAbsolutePath()) + " at root 0x" + Integer.toHexString(n2) + ". Windows RegOpenKey(...) returned error code " + nArray[1] + ".");
                nArray[0] = 0;
            }
            return nArray[0];
        }
        int n5 = -1;
        for (int i2 = 256; i2 > 0; --i2) {
            if (byArray[i2] != 92) continue;
            n5 = i2;
            break;
        }
        byte[] byArray2 = new byte[n5 + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n5);
        byArray2[n5] = 0;
        byte[] byArray3 = new byte[byArray.length - n5 - 1];
        System.arraycopy(byArray, n5 + 1, byArray3, 0, byArray3.length);
        int n6 = this.openKey(n2, byArray2, n3, n4);
        if (n6 == 0) {
            return 0;
        }
        int n7 = this.openKey(n6, byArray3, n3, n4);
        this.closeKey(n6);
        return n7;
    }

    private static native int WindowsRegSetValueEx(int var0, byte[] var1, byte[] var2);

    private static int WindowsRegSetValueEx1(int n2, byte[] byArray, byte[] byArray2) {
        int n3 = WindowsPreferences.WindowsRegSetValueEx(n2, byArray, byArray2);
        if (n3 == 0) {
            return n3;
        }
        long l2 = INIT_SLEEP_TIME;
        for (int i2 = 0; i2 < MAX_ATTEMPTS; ++i2) {
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                return n3;
            }
            l2 *= 2L;
            n3 = WindowsPreferences.WindowsRegSetValueEx(n2, byArray, byArray2);
            if (n3 != 0) continue;
            return n3;
        }
        return n3;
    }

    private int openKey(byte[] byArray, int n2, int n3) {
        if (byArray.length <= 257) {
            int[] nArray = WindowsPreferences.WindowsRegOpenKey1(this.rootNativeHandle(), byArray, n2);
            if (nArray[1] == 5 && n3 != n2) {
                nArray = WindowsPreferences.WindowsRegOpenKey1(this.rootNativeHandle(), byArray, n3);
            }
            if (nArray[1] != 0) {
                WindowsPreferences.logger().warning("Could not open windows registry node " + WindowsPreferences.byteArrayToString(this.windowsAbsolutePath()) + " at root 0x" + Integer.toHexString(this.rootNativeHandle()) + ". Windows RegOpenKey(...) returned error code " + nArray[1] + ".");
                nArray[0] = 0;
                if (nArray[1] == 5) {
                    throw new SecurityException("Could not open windows registry node " + WindowsPreferences.byteArrayToString(this.windowsAbsolutePath()) + " at root 0x" + Integer.toHexString(this.rootNativeHandle()) + ": Access denied");
                }
            }
            return nArray[0];
        }
        return this.openKey(this.rootNativeHandle(), byArray, n2, n3);
    }

    protected String[] childrenNamesSpi() throws BackingStoreException {
        int n2 = this.openKey(9);
        if (n2 == 0) {
            throw new BackingStoreException("Could not open windowsregistry node " + WindowsPreferences.byteArrayToString(this.windowsAbsolutePath()) + " at root 0x" + Integer.toHexString(this.rootNativeHandle()) + ".");
        }
        int[] nArray = WindowsPreferences.WindowsRegQueryInfoKey1(n2);
        if (nArray[1] != 0) {
            String string = "Could not query windowsregistry node " + WindowsPreferences.byteArrayToString(this.windowsAbsolutePath()) + " at root 0x" + Integer.toHexString(this.rootNativeHandle()) + ". Windows RegQueryInfoKeyEx(...) returned error code " + nArray[1] + ".";
            WindowsPreferences.logger().warning(string);
            throw new BackingStoreException(string);
        }
        int n3 = nArray[3];
        int n4 = nArray[0];
        if (n4 == 0) {
            this.closeKey(n2);
            return new String[0];
        }
        String[] stringArray = new String[n4];
        String[] stringArray2 = new String[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            String string;
            byte[] byArray = WindowsPreferences.WindowsRegEnumKeyEx1(n2, i2, n3 + 1);
            if (byArray == null) {
                string = "Could not enumerate key #" + i2 + "  of windows node " + WindowsPreferences.byteArrayToString(this.windowsAbsolutePath()) + " at root 0x" + Integer.toHexString(this.rootNativeHandle()) + ". ";
                WindowsPreferences.logger().warning(string);
                throw new BackingStoreException(string);
            }
            stringArray2[i2] = string = WindowsPreferences.toJavaName(byArray);
        }
        this.closeKey(n2);
        return stringArray2;
    }

    protected String[] keysSpi() throws BackingStoreException {
        int n2 = this.openKey(1);
        if (n2 == 0) {
            throw new BackingStoreException("Could not open windowsregistry node " + WindowsPreferences.byteArrayToString(this.windowsAbsolutePath()) + " at root 0x" + Integer.toHexString(this.rootNativeHandle()) + ".");
        }
        int[] nArray = WindowsPreferences.WindowsRegQueryInfoKey1(n2);
        if (nArray[1] != 0) {
            String string = "Could not query windowsregistry node " + WindowsPreferences.byteArrayToString(this.windowsAbsolutePath()) + " at root 0x" + Integer.toHexString(this.rootNativeHandle()) + ". Windows RegQueryInfoKeyEx(...) returned error code " + nArray[1] + ".";
            WindowsPreferences.logger().warning(string);
            throw new BackingStoreException(string);
        }
        int n3 = nArray[4];
        int n4 = nArray[2];
        if (n4 == 0) {
            this.closeKey(n2);
            return new String[0];
        }
        String[] stringArray = new String[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            byte[] byArray = WindowsPreferences.WindowsRegEnumValue1(n2, i2, n3 + 1);
            if (byArray == null) {
                String string = "Could not enumerate value #" + i2 + "  of windows node " + WindowsPreferences.byteArrayToString(this.windowsAbsolutePath()) + " at root 0x" + Integer.toHexString(this.rootNativeHandle()) + ".";
                WindowsPreferences.logger().warning(string);
                throw new BackingStoreException(string);
            }
            stringArray[i2] = WindowsPreferences.toJavaName(byArray);
        }
        this.closeKey(n2);
        return stringArray;
    }

    protected void removeSpi(String string) {
        int n2 = this.openKey(2);
        if (n2 == 0) {
            return;
        }
        int n3 = WindowsPreferences.WindowsRegDeleteValue(n2, WindowsPreferences.toWindowsName(string));
        if (n3 != 0 && n3 != 2) {
            WindowsPreferences.logger().warning("Could not delete windows registry value " + WindowsPreferences.byteArrayToString(this.windowsAbsolutePath()) + "\\" + WindowsPreferences.toWindowsName(string) + " at root 0x" + Integer.toHexString(this.rootNativeHandle()) + ". Windows RegDeleteValue(...) returned error code " + n3 + ".");
            this.isBackingStoreAvailable = false;
        }
        this.closeKey(n2);
    }

    private static byte[] stringToByteArray(String string) {
        byte[] byArray = new byte[string.length() + 1];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            byArray[i2] = (byte)string.charAt(i2);
        }
        byArray[string.length()] = 0;
        return byArray;
    }

    private static byte[] toWindowsAlt64Name(String string) {
        byte[] byArray = new byte[2 * string.length()];
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            byArray[n2++] = (byte)(c2 >>> 8);
            byArray[n2++] = (byte)c2;
        }
        return WindowsPreferences.stringToByteArray("/!" + Base64.byteArrayToAltBase64(byArray));
    }

    private static byte[] toWindowsName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < ' ' || c2 > '\u007f') {
                return WindowsPreferences.toWindowsAlt64Name(string);
            }
            if (c2 == '\\') {
                stringBuffer.append("//");
                continue;
            }
            if (c2 == '/') {
                stringBuffer.append('\\');
                continue;
            }
            if (c2 >= 'A' && c2 <= 'Z') {
                stringBuffer.append("/" + c2);
                continue;
            }
            stringBuffer.append(c2);
        }
        return WindowsPreferences.stringToByteArray(stringBuffer.toString());
    }

    private static byte[] toWindowsValueString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < ' ' || c2 > '\u007f') {
                int n2;
                stringBuffer.append("/u");
                String string2 = Integer.toHexString(string.charAt(i2));
                StringBuffer stringBuffer2 = new StringBuffer(string2);
                stringBuffer2.reverse();
                int n3 = 4 - stringBuffer2.length();
                for (n2 = 0; n2 < n3; ++n2) {
                    stringBuffer2.append('0');
                }
                for (n2 = 0; n2 < 4; ++n2) {
                    stringBuffer.append(stringBuffer2.charAt(3 - n2));
                }
                continue;
            }
            if (c2 == '\\') {
                stringBuffer.append("//");
                continue;
            }
            if (c2 == '/') {
                stringBuffer.append('\\');
                continue;
            }
            if (c2 >= 'A' && c2 <= 'Z') {
                stringBuffer.append("/" + c2);
                continue;
            }
            stringBuffer.append(c2);
        }
        return WindowsPreferences.stringToByteArray(stringBuffer.toString());
    }

    private static String byteArrayToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length - 1; ++i2) {
            stringBuffer.append((char)byArray[i2]);
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static String toJavaName(byte[] var0) {
        var1_1 = WindowsPreferences.byteArrayToString(var0);
        if (var1_1.length() > 1 && var1_1.substring(0, 2).equals("/!")) {
            return WindowsPreferences.toJavaAlt64Name(var1_1);
        }
        var2_2 = new StringBuffer();
        for (var4_3 = 0; var4_3 < var1_1.length(); ++var4_3) {
            block7: {
                block6: {
                    var3_4 = var1_1.charAt(var4_3);
                    if (var3_4 != 47) break block6;
                    var5_5 = 32;
                    if (var1_1.length() <= var4_3 + 1) ** GOTO lbl-1000
                    v0 = var1_1.charAt(var4_3 + 1);
                    var5_5 = v0;
                    if (v0 >= 'A' && var5_5 <= 90) {
                        var3_4 = var5_5;
                        ++var4_3;
                    } else if (var1_1.length() > var4_3 + 1 && var5_5 == 47) {
                        var3_4 = 92;
                        ++var4_3;
                    }
                    break block7;
                }
                if (var3_4 == 92) {
                    var3_4 = 47;
                }
            }
            var2_2.append((char)var3_4);
        }
        return var2_2.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String toJavaValueString(byte[] byArray) {
        String string = WindowsPreferences.byteArrayToString(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            int n3;
            block8: {
                block6: {
                    int n4;
                    block7: {
                        n3 = string.charAt(n2);
                        if (n3 != 47) break block6;
                        n4 = 32;
                        if (string.length() <= n2 + 1) break block7;
                        char c2 = string.charAt(n2 + 1);
                        n4 = c2;
                        if (c2 != 'u') break block7;
                        if (string.length() < n2 + 6) {
                            return stringBuffer.toString();
                        }
                        n3 = (char)Integer.parseInt(string.substring(n2 + 2, n2 + 6), 16);
                        n2 += 5;
                        break block8;
                    }
                    if (string.length() > n2 + 1 && string.charAt(n2 + 1) >= 'A' && n4 <= 90) {
                        n3 = n4;
                        ++n2;
                        break block8;
                    } else if (string.length() > n2 + 1 && n4 == 47) {
                        n3 = 92;
                        ++n2;
                    }
                    break block8;
                }
                if (n3 == 92) {
                    n3 = 47;
                }
            }
            stringBuffer.append((char)n3);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static synchronized Logger logger() {
        if (logger == null) {
            logger = Logger.getLogger("java.util.prefs");
        }
        return logger;
    }

    protected String getSpi(String string) {
        int n2 = this.openKey(1);
        if (n2 == 0) {
            return null;
        }
        byte[] byArray = WindowsPreferences.WindowsRegQueryValueEx(n2, WindowsPreferences.toWindowsName(string));
        if (byArray == null) {
            this.closeKey(n2);
            return null;
        }
        this.closeKey(n2);
        return WindowsPreferences.toJavaValueString(byArray);
    }

    private static String toJavaAlt64Name(String string) {
        byte[] byArray = Base64.altBase64ToByteArray(string.substring(2));
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2++] & 0xFF;
            int n3 = byArray[i2] & 0xFF;
            stringBuffer.append((char)((n2 << 8) + n3));
        }
        return stringBuffer.toString();
    }

    protected void putSpi(String string, String string2) {
        int n2 = this.openKey(2);
        if (n2 == 0) {
            this.isBackingStoreAvailable = false;
            return;
        }
        int n3 = WindowsPreferences.WindowsRegSetValueEx1(n2, WindowsPreferences.toWindowsName(string), WindowsPreferences.toWindowsValueString(string2));
        if (n3 != 0) {
            WindowsPreferences.logger().warning("Could not assign value to key " + WindowsPreferences.byteArrayToString(WindowsPreferences.toWindowsName(string)) + " at Windows registry node " + WindowsPreferences.byteArrayToString(this.windowsAbsolutePath()) + " at root 0x" + Integer.toHexString(this.rootNativeHandle()) + ". Windows RegSetValueEx(...) returned error code " + n3 + ".");
            this.isBackingStoreAvailable = false;
        }
        this.closeKey(n2);
    }

    private WindowsPreferences(WindowsPreferences windowsPreferences, String string) {
        super(windowsPreferences, string);
        int n2 = windowsPreferences.openKey(4, 131097);
        if (n2 == 0) {
            this.isBackingStoreAvailable = false;
            return;
        }
        int[] nArray = WindowsPreferences.WindowsRegCreateKeyEx1(n2, WindowsPreferences.toWindowsName(string));
        if (nArray[1] != 0) {
            WindowsPreferences.logger().warning("Could not create windows registry node " + WindowsPreferences.byteArrayToString(this.windowsAbsolutePath()) + " at root 0x" + Integer.toHexString(this.rootNativeHandle()) + ". Windows RegCreateKeyEx(...) returned error code " + nArray[1] + ".");
            this.isBackingStoreAvailable = false;
            return;
        }
        this.newNode = nArray[2] == 1;
        this.closeKey(n2);
        this.closeKey(nArray[0]);
    }

    protected AbstractPreferences childSpi(String string) {
        return new WindowsPreferences(this, string);
    }
}

