/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingGraphics;
import javax.swing.UIManager;
import javax.swing.plaf.SplitPaneUI;

public class JSplitPane
extends JComponent
implements Accessible {
    private static final String uiClassID = "SplitPaneUI";
    public static final int VERTICAL_SPLIT = 0;
    public static final int HORIZONTAL_SPLIT = 1;
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String TOP = "top";
    public static final String BOTTOM = "bottom";
    public static final String DIVIDER = "divider";
    public static final String ORIENTATION_PROPERTY = "orientation";
    public static final String CONTINUOUS_LAYOUT_PROPERTY = "continuousLayout";
    public static final String DIVIDER_SIZE_PROPERTY = "dividerSize";
    public static final String ONE_TOUCH_EXPANDABLE_PROPERTY = "oneTouchExpandable";
    public static final String LAST_DIVIDER_LOCATION_PROPERTY = "lastDividerLocation";
    public static final String DIVIDER_LOCATION_PROPERTY = "dividerLocation";
    public static final String RESIZE_WEIGHT_PROPERTY = "resizeWeight";
    protected int orientation;
    protected boolean continuousLayout;
    protected Component leftComponent;
    protected Component rightComponent;
    protected int dividerSize;
    protected boolean oneTouchExpandable;
    protected int lastDividerLocation;
    private double resizeWeight;
    private int dividerLocation = -1;

    public double getResizeWeight() {
        return this.resizeWeight;
    }

    public int getDividerLocation() {
        return this.dividerLocation;
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public int getLastDividerLocation() {
        return this.lastDividerLocation;
    }

    public int getMaximumDividerLocation() {
        SplitPaneUI splitPaneUI = this.getUI();
        if (splitPaneUI != null) {
            return splitPaneUI.getMaximumDividerLocation(this);
        }
        return -1;
    }

    public int getMinimumDividerLocation() {
        SplitPaneUI splitPaneUI = this.getUI();
        if (splitPaneUI != null) {
            return splitPaneUI.getMinimumDividerLocation(this);
        }
        return -1;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public JSplitPane() {
        this(1, false, new JButton(UIManager.getString("SplitPane.leftButtonText")), new JButton(UIManager.getString("SplitPane.rightButtonText")));
    }

    public void removeAll() {
        this.rightComponent = null;
        this.leftComponent = null;
        super.removeAll();
        this.revalidate();
        this.repaint();
    }

    public void resetToPreferredSizes() {
        SplitPaneUI splitPaneUI = this.getUI();
        if (splitPaneUI != null) {
            splitPaneUI.resetToPreferredSizes(this);
        }
    }

    public void updateUI() {
        this.setUI((SplitPaneUI)UIManager.getUI(this));
        this.revalidate();
    }

    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    public boolean isOneTouchExpandable() {
        return this.oneTouchExpandable;
    }

    public boolean isValidateRoot() {
        return true;
    }

    public void setDividerLocation(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("proportional location must be between 0.0 and 1.0.");
        }
        if (this.getOrientation() == 0) {
            this.setDividerLocation((int)((double)(this.getHeight() - this.getDividerSize()) * d2));
        } else {
            this.setDividerLocation((int)((double)(this.getWidth() - this.getDividerSize()) * d2));
        }
    }

    public void setResizeWeight(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("JSplitPane weight must be between 0 and 1");
        }
        double d3 = this.resizeWeight;
        this.resizeWeight = d2;
        this.firePropertyChange(RESIZE_WEIGHT_PROPERTY, d3, d2);
    }

    public JSplitPane(int n2) {
        this(n2, false);
    }

    public void remove(int n2) {
        Component component = this.getComponent(n2);
        if (component == this.leftComponent) {
            this.leftComponent = null;
        } else if (component == this.rightComponent) {
            this.rightComponent = null;
        }
        super.remove(n2);
        this.revalidate();
        this.repaint();
    }

    public void setDividerLocation(int n2) {
        int n3 = this.dividerLocation;
        this.dividerLocation = n2;
        SplitPaneUI splitPaneUI = this.getUI();
        if (splitPaneUI != null) {
            splitPaneUI.setDividerLocation(this, n2);
        }
        this.firePropertyChange(DIVIDER_LOCATION_PROPERTY, n3, n2);
        this.setLastDividerLocation(n3);
    }

    public void setDividerSize(int n2) {
        int n3 = this.dividerSize;
        if (n3 != n2) {
            this.dividerSize = n2;
            this.firePropertyChange(DIVIDER_SIZE_PROPERTY, n3, n2);
        }
    }

    public void setLastDividerLocation(int n2) {
        int n3 = this.lastDividerLocation;
        this.lastDividerLocation = n2;
        this.firePropertyChange(LAST_DIVIDER_LOCATION_PROPERTY, n3, n2);
    }

    public void setOrientation(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("JSplitPane: orientation must be one of JSplitPane.VERTICAL_SPLIT or JSplitPane.HORIZONTAL_SPLIT");
        }
        int n3 = this.orientation;
        this.orientation = n2;
        this.firePropertyChange(ORIENTATION_PROPERTY, n3, n2);
    }

    public JSplitPane(int n2, boolean bl2) {
        this(n2, bl2, null, null);
    }

    public void setContinuousLayout(boolean bl2) {
        boolean bl3 = this.continuousLayout;
        this.continuousLayout = bl2;
        this.firePropertyChange(CONTINUOUS_LAYOUT_PROPERTY, bl3, bl2);
    }

    public void setOneTouchExpandable(boolean bl2) {
        boolean bl3 = this.oneTouchExpandable;
        this.oneTouchExpandable = bl2;
        this.firePropertyChange(ONE_TOUCH_EXPANDABLE_PROPERTY, bl3, bl2);
        this.repaint();
    }

    public Component getBottomComponent() {
        return this.rightComponent;
    }

    public Component getLeftComponent() {
        return this.leftComponent;
    }

    public Component getRightComponent() {
        return this.rightComponent;
    }

    public Component getTopComponent() {
        return this.leftComponent;
    }

    public void remove(Component component) {
        if (component == this.leftComponent) {
            this.leftComponent = null;
        } else if (component == this.rightComponent) {
            this.rightComponent = null;
        }
        super.remove(component);
        this.revalidate();
        this.repaint();
    }

    public void setBottomComponent(Component component) {
        this.setRightComponent(component);
    }

    public void setLeftComponent(Component component) {
        if (component == null) {
            if (this.leftComponent != null) {
                this.remove(this.leftComponent);
                this.leftComponent = null;
            }
        } else {
            this.add(component, LEFT);
        }
    }

    public void setRightComponent(Component component) {
        if (component == null) {
            if (this.rightComponent != null) {
                this.remove(this.rightComponent);
                this.rightComponent = null;
            }
        } else {
            this.add(component, RIGHT);
        }
    }

    public void setTopComponent(Component component) {
        this.setLeftComponent(component);
    }

    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        SplitPaneUI splitPaneUI = this.getUI();
        if (splitPaneUI != null) {
            Graphics graphics2 = SwingGraphics.createSwingGraphics(graphics);
            splitPaneUI.finishedPaintingChildren(this, graphics2);
            graphics2.dispose();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected String paramString() {
        String string = this.orientation == 1 ? "HORIZONTAL_SPLIT" : "VERTICAL_SPLIT";
        String string2 = this.continuousLayout ? "true" : "false";
        String string3 = this.oneTouchExpandable ? "true" : "false";
        return super.paramString() + ",continuousLayout=" + string2 + ",dividerSize=" + this.dividerSize + ",lastDividerLocation=" + this.lastDividerLocation + ",oneTouchExpandable=" + string3 + ",orientation=" + string;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJSplitPane(this);
        }
        return this.accessibleContext;
    }

    public SplitPaneUI getUI() {
        return (SplitPaneUI)this.ui;
    }

    public void setUI(SplitPaneUI splitPaneUI) {
        if ((SplitPaneUI)this.ui != splitPaneUI) {
            super.setUI(splitPaneUI);
            this.revalidate();
        }
    }

    public JSplitPane(int n2, Component component, Component component2) {
        this(n2, false, component, component2);
    }

    public JSplitPane(int n2, boolean bl2, Component component, Component component2) {
        this.setLayout(null);
        this.setOpaque(true);
        this.orientation = n2;
        if (this.orientation != 1 && this.orientation != 0) {
            throw new IllegalArgumentException("cannot create JSplitPane, orientation must be one of JSplitPane.HORIZONTAL_SPLIT or JSplitPane.VERTICAL_SPLIT");
        }
        this.continuousLayout = bl2;
        if (component != null) {
            this.setLeftComponent(component);
        }
        if (component2 != null) {
            this.setRightComponent(component2);
        }
        this.updateUI();
    }

    protected void addImpl(Component component, Object object, int n2) {
        if (object != null && !(object instanceof String)) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
        }
        if (object == null) {
            if (this.getLeftComponent() == null) {
                object = LEFT;
            } else if (this.getRightComponent() == null) {
                object = RIGHT;
            }
        }
        if (object != null && (object.equals(LEFT) || object.equals(TOP))) {
            Component component2 = this.getLeftComponent();
            if (component2 != null) {
                this.remove(component2);
            }
            this.leftComponent = component;
            n2 = -1;
        } else if (object != null && (object.equals(RIGHT) || object.equals(BOTTOM))) {
            Component component3 = this.getRightComponent();
            if (component3 != null) {
                this.remove(component3);
            }
            this.rightComponent = component;
            n2 = -1;
        } else if (object != null && object.equals(DIVIDER)) {
            n2 = -1;
        }
        super.addImpl(component, object, n2);
        this.revalidate();
        this.repaint();
    }

    protected class AccessibleJSplitPane
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private final JSplitPane this$0;

        public Number getCurrentAccessibleValue() {
            return new Integer(this.this$0.getDividerLocation());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(this.this$0.getUI().getMaximumDividerLocation(this.this$0));
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(this.this$0.getUI().getMinimumDividerLocation(this.this$0));
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                this.this$0.setDividerLocation(number.intValue());
                return true;
            }
            return false;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SPLIT_PANE;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (this.this$0.getOrientation() == 0) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            } else {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            }
            return accessibleStateSet;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        protected AccessibleJSplitPane(JSplitPane jSplitPane) {
            this.this$0 = jSplitPane;
            super(jSplitPane);
        }
    }
}

