/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.EventListener;

public class EventListenerList
implements Serializable {
    private static final Object[] NULL_ARRAY = new Object[0];
    protected transient Object[] listenerList = NULL_ARRAY;

    public int getListenerCount() {
        return this.listenerList.length / 2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        this.listenerList = NULL_ARRAY;
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            EventListener eventListener = (EventListener)objectInputStream.readObject();
            this.add(Class.forName((String)object, true, classLoader), eventListener);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object[] objectArray = this.listenerList;
        objectOutputStream.defaultWriteObject();
        for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
            Class clazz = (Class)objectArray[i2];
            EventListener eventListener = (EventListener)objectArray[i2 + 1];
            if (eventListener == null || !(eventListener instanceof Serializable)) continue;
            objectOutputStream.writeObject(clazz.getName());
            objectOutputStream.writeObject(eventListener);
        }
        objectOutputStream.writeObject(null);
    }

    public int getListenerCount(Class clazz) {
        Object[] objectArray = this.listenerList;
        return this.getListenerCount(objectArray, clazz);
    }

    public Object[] getListenerList() {
        return this.listenerList;
    }

    public String toString() {
        Object[] objectArray = this.listenerList;
        String string = "EventListenerList: ";
        string = string + objectArray.length / 2 + " listeners: ";
        for (int i2 = 0; i2 <= objectArray.length - 2; i2 += 2) {
            string = string + " type " + ((Class)objectArray[i2]).getName();
            string = string + " listener " + objectArray[i2 + 1];
        }
        return string;
    }

    private int getListenerCount(Object[] objectArray, Class clazz) {
        int n2 = 0;
        for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
            if (clazz != (Class)objectArray[i2]) continue;
            ++n2;
        }
        return n2;
    }

    public EventListener[] getListeners(Class clazz) {
        Object[] objectArray = this.listenerList;
        int n2 = this.getListenerCount(objectArray, clazz);
        EventListener[] eventListenerArray = (EventListener[])Array.newInstance(clazz, n2);
        int n3 = 0;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != clazz) continue;
            eventListenerArray[n3++] = (EventListener)objectArray[i2 + 1];
        }
        return eventListenerArray;
    }

    public synchronized void add(Class clazz, EventListener eventListener) {
        if (eventListener == null) {
            return;
        }
        if (!clazz.isInstance(eventListener)) {
            throw new IllegalArgumentException("Listener " + eventListener + " is not of type " + clazz);
        }
        if (this.listenerList == NULL_ARRAY) {
            this.listenerList = new Object[]{clazz, eventListener};
        } else {
            int n2 = this.listenerList.length;
            Object[] objectArray = new Object[n2 + 2];
            System.arraycopy(this.listenerList, 0, objectArray, 0, n2);
            objectArray[n2] = clazz;
            objectArray[n2 + 1] = eventListener;
            this.listenerList = objectArray;
        }
    }

    public synchronized void remove(Class clazz, EventListener eventListener) {
        if (eventListener == null) {
            return;
        }
        if (!clazz.isInstance(eventListener)) {
            throw new IllegalArgumentException("Listener " + eventListener + " is not of type " + clazz);
        }
        int n2 = -1;
        for (int i2 = this.listenerList.length - 2; i2 >= 0; i2 -= 2) {
            if (this.listenerList[i2] != clazz || !this.listenerList[i2 + 1].equals(eventListener)) continue;
            n2 = i2;
            break;
        }
        if (n2 != -1) {
            Object[] objectArray = new Object[this.listenerList.length - 2];
            System.arraycopy(this.listenerList, 0, objectArray, 0, n2);
            if (n2 < objectArray.length) {
                System.arraycopy(this.listenerList, n2 + 2, objectArray, n2, objectArray.length - n2);
            }
            this.listenerList = objectArray.length == 0 ? NULL_ARRAY : objectArray;
        }
    }
}

